import * as sns from '@aws-cdk/aws-sns';
import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for PublishTask
 */
export interface PublishToTopicProps {
    /**
     * The text message to send to the topic.
     */
    readonly message: sfn.TaskInput;
    /**
     * If true, send a different message to every subscription type
     *
     * If this is set to true, message must be a JSON object with a
     * "default" key and a key for every subscription type (such as "sqs",
     * "email", etc.) The values are strings representing the messages
     * being sent to every subscription type.
     *
     * @see https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters
     */
    readonly messagePerSubscriptionType?: boolean;
    /**
     * Message subject
     */
    readonly subject?: string;
    /**
     * The service integration pattern indicates different ways to call Publish to SNS.
     *
     * The valid value is either FIRE_AND_FORGET or WAIT_FOR_TASK_TOKEN.
     *
     * @default FIRE_AND_FORGET
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * A Step Functions Task to publish messages to SNS topic.
 *
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 */
export declare class PublishToTopic implements sfn.IStepFunctionsTask {
    private readonly topic;
    private readonly props;
    private readonly integrationPattern;
    constructor(topic: sns.ITopic, props: PublishToTopicProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
