import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { BatchStrategy, TransformInput, TransformOutput, TransformResources } from './sagemaker-task-base-types';
/**
 *  @experimental
 */
export interface SagemakerTransformProps {
    /**
     * Training Job Name.
     */
    readonly transformJobName: string;
    /**
     * Role for thte Training Job.
     */
    readonly role?: iam.IRole;
    /**
     * The service integration pattern indicates different ways to call SageMaker APIs.
     *
     * The valid value is either FIRE_AND_FORGET or SYNC.
     *
     * @default FIRE_AND_FORGET
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
    /**
     * Number of records to include in a mini-batch for an HTTP inference request.
     */
    readonly batchStrategy?: BatchStrategy;
    /**
     * Environment variables to set in the Docker container.
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * Maximum number of parallel requests that can be sent to each instance in a transform job.
     */
    readonly maxConcurrentTransforms?: number;
    /**
     * Maximum allowed size of the payload, in MB.
     */
    readonly maxPayloadInMB?: number;
    /**
     * Name of the model that you want to use for the transform job.
     */
    readonly modelName: string;
    /**
     * Tags to be applied to the train job.
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Dataset to be transformed and the Amazon S3 location where it is stored.
     */
    readonly transformInput: TransformInput;
    /**
     * S3 location where you want Amazon SageMaker to save the results from the transform job.
     */
    readonly transformOutput: TransformOutput;
    /**
     * ML compute instances for the transform job.
     */
    readonly transformResources?: TransformResources;
}
/**
 * Class representing the SageMaker Create Training Job task.
 *
 *  @experimental
 */
export declare class SagemakerTransformTask implements sfn.IStepFunctionsTask {
    private readonly props;
    /**
     * Dataset to be transformed and the Amazon S3 location where it is stored.
     */
    private readonly transformInput;
    /**
     * ML compute instances for the transform job.
     */
    private readonly transformResources;
    private readonly integrationPattern;
    private _role?;
    constructor(props: SagemakerTransformProps);
    bind(task: sfn.Task): sfn.StepFunctionsTaskConfig;
    /**
     * The execution role for the Sagemaker training job.
     *
     * Only available after task has been added to a state machine.
     */
    get role(): iam.IRole;
    private renderParameters;
    private renderTransformInput;
    private renderTransformOutput;
    private renderTransformResources;
    private renderEnvironment;
    private renderTags;
    private makePolicyStatements;
}
