"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../lib");
let stack;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
});
test('Set termination protection with static ClusterId and TerminationProtected', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrSetClusterTerminationProtection({
            clusterId: 'ClusterId',
            terminationProtected: false
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:setClusterTerminationProtection',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            TerminationProtected: false
        },
    });
});
test('Set termination protection with static ClusterId and TerminationProtected from payload', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrSetClusterTerminationProtection({
            clusterId: 'ClusterId',
            terminationProtected: sfn.TaskInput.fromDataAt('$.TerminationProtected').value
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:setClusterTerminationProtection',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId': 'ClusterId',
            'TerminationProtected.$': '$.TerminationProtected'
        },
    });
});
test('Set termination protection with ClusterId from payload and static TerminationProtected', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrSetClusterTerminationProtection({
            clusterId: sfn.TaskInput.fromDataAt('$.ClusterId').value,
            terminationProtected: false
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:setClusterTerminationProtection',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId.$': '$.ClusterId',
            'TerminationProtected': false
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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