"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../lib");
class JobPollerStack extends cdk.Stack {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        const submitJobActivity = new sfn.Activity(this, 'SubmitJob');
        const checkJobActivity = new sfn.Activity(this, 'CheckJob');
        const submitJob = new sfn.Task(this, 'Submit Job', {
            task: new tasks.InvokeActivity(submitJobActivity),
            resultPath: '$.guid',
        });
        const waitX = new sfn.Wait(this, 'Wait X Seconds', { time: sfn.WaitTime.secondsPath('$.wait_time') });
        const getStatus = new sfn.Task(this, 'Get Job Status', {
            task: new tasks.InvokeActivity(checkJobActivity),
            inputPath: '$.guid',
            resultPath: '$.status',
        });
        const isComplete = new sfn.Choice(this, 'Job Complete?');
        const jobFailed = new sfn.Fail(this, 'Job Failed', {
            cause: 'AWS Batch Job Failed',
            error: 'DescribeJob returned FAILED',
        });
        const finalStatus = new sfn.Task(this, 'Get Final Job Status', {
            task: new tasks.InvokeActivity(checkJobActivity),
            inputPath: '$.guid',
        });
        const chain = sfn.Chain
            .start(submitJob)
            .next(waitX)
            .next(getStatus)
            .next(isComplete
            .when(sfn.Condition.stringEquals('$.status', 'FAILED'), jobFailed)
            .when(sfn.Condition.stringEquals('$.status', 'SUCCEEDED'), finalStatus)
            .otherwise(waitX));
        new sfn.StateMachine(this, 'StateMachine', {
            definition: chain,
            timeout: cdk.Duration.seconds(30)
        });
    }
}
const app = new cdk.App();
new JobPollerStack(app, 'aws-stepfunctions-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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