# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OauthAppArgs', 'OauthApp']

@pulumi.input_type
class OauthAppArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 type: pulumi.Input[str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 authentication_policy: Optional[pulumi.Input[str]] = None,
                 auto_key_rotation: Optional[pulumi.Input[bool]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 client_basic_secret: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_uri: Optional[pulumi.Input[str]] = None,
                 consent_method: Optional[pulumi.Input[str]] = None,
                 custom_client_id: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_claim: Optional[pulumi.Input['OauthAppGroupsClaimArgs']] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 jwks: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]] = None,
                 login_mode: Optional[pulumi.Input[str]] = None,
                 login_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login_uri: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 omit_secret: Optional[pulumi.Input[bool]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 policy_uri: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_leeway: Optional[pulumi.Input[int]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[str]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 tos_uri: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]] = None,
                 wildcard_redirect: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OauthApp resource.
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] type: The type of client application.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format
        :param pulumi.Input[str] authentication_policy: Id of this apps authentication policy
        :param pulumi.Input[bool] auto_key_rotation: Requested key rotation mode.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] client_basic_secret: OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        :param pulumi.Input[str] client_id: OAuth client ID. If set during creation, app is created with this id.
        :param pulumi.Input[str] client_uri: URI to a web page providing information about the client.
        :param pulumi.Input[str] consent_method: *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
               Default value is TRUSTED
        :param pulumi.Input[str] custom_client_id: **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
               no-op, use client_id for that behavior instead.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List of OAuth 2.0 grant types. Conditional validation params found here
               https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
               app type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input['OauthAppGroupsClaimArgs'] groups_claim: Groups claim for an OpenID Connect client application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enable Federation Broker Mode.
        :param pulumi.Input[str] issuer_mode: *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
               custom domain URL as the issuer of ID token for this client.
        :param pulumi.Input[str] login_mode: The type of Idp-Initiated login that the client supports, if any
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_scopes: List of scopes to use for the request
        :param pulumi.Input[str] login_uri: URI that initiates login.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_uri: URI that references a logo for the client.
        :param pulumi.Input[bool] omit_secret: This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
               your app will be recreated.
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
               `native` application types.
        :param pulumi.Input[str] policy_uri: URI to web page providing client policy document.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
               in a decentralized way.
        :param pulumi.Input[str] profile: Custom JSON that represents an OAuth application's profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
               okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        :param pulumi.Input[int] refresh_token_leeway: *Early Access Property* Grace period for token rotation
        :param pulumi.Input[str] refresh_token_rotation: *Early Access Property* Refresh token rotation behavior
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: List of OAuth 2.0 response type strings.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] token_endpoint_auth_method: Requested authentication method for the token endpoint.
        :param pulumi.Input[str] tos_uri: URI to web page providing client tos (terms of service).
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]] users: Users associated with the application
        :param pulumi.Input[str] wildcard_redirect: *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "type", type)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if app_settings_json is not None:
            pulumi.set(__self__, "app_settings_json", app_settings_json)
        if authentication_policy is not None:
            pulumi.set(__self__, "authentication_policy", authentication_policy)
        if auto_key_rotation is not None:
            pulumi.set(__self__, "auto_key_rotation", auto_key_rotation)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if client_basic_secret is not None:
            pulumi.set(__self__, "client_basic_secret", client_basic_secret)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_uri is not None:
            pulumi.set(__self__, "client_uri", client_uri)
        if consent_method is not None:
            pulumi.set(__self__, "consent_method", consent_method)
        if custom_client_id is not None:
            warnings.warn("""This field is being replaced by client_id. Please set that field instead.""", DeprecationWarning)
            pulumi.log.warn("""custom_client_id is deprecated: This field is being replaced by client_id. Please set that field instead.""")
        if custom_client_id is not None:
            pulumi.set(__self__, "custom_client_id", custom_client_id)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if implicit_assignment is not None:
            pulumi.set(__self__, "implicit_assignment", implicit_assignment)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if jwks is not None:
            pulumi.set(__self__, "jwks", jwks)
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)
        if login_scopes is not None:
            pulumi.set(__self__, "login_scopes", login_scopes)
        if login_uri is not None:
            pulumi.set(__self__, "login_uri", login_uri)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if omit_secret is not None:
            pulumi.set(__self__, "omit_secret", omit_secret)
        if pkce_required is not None:
            pulumi.set(__self__, "pkce_required", pkce_required)
        if policy_uri is not None:
            pulumi.set(__self__, "policy_uri", policy_uri)
        if post_logout_redirect_uris is not None:
            pulumi.set(__self__, "post_logout_redirect_uris", post_logout_redirect_uris)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if redirect_uris is not None:
            pulumi.set(__self__, "redirect_uris", redirect_uris)
        if refresh_token_leeway is not None:
            pulumi.set(__self__, "refresh_token_leeway", refresh_token_leeway)
        if refresh_token_rotation is not None:
            pulumi.set(__self__, "refresh_token_rotation", refresh_token_rotation)
        if response_types is not None:
            pulumi.set(__self__, "response_types", response_types)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if token_endpoint_auth_method is not None:
            pulumi.set(__self__, "token_endpoint_auth_method", token_endpoint_auth_method)
        if tos_uri is not None:
            pulumi.set(__self__, "tos_uri", tos_uri)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if wildcard_redirect is not None:
            pulumi.set(__self__, "wildcard_redirect", wildcard_redirect)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of client application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        Application settings in JSON format
        """
        return pulumi.get(self, "app_settings_json")

    @app_settings_json.setter
    def app_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_settings_json", value)

    @property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Id of this apps authentication policy
        """
        return pulumi.get(self, "authentication_policy")

    @authentication_policy.setter
    def authentication_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_policy", value)

    @property
    @pulumi.getter(name="autoKeyRotation")
    def auto_key_rotation(self) -> Optional[pulumi.Input[bool]]:
        """
        Requested key rotation mode.
        """
        return pulumi.get(self, "auto_key_rotation")

    @auto_key_rotation.setter
    def auto_key_rotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_key_rotation", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter(name="clientBasicSecret")
    def client_basic_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        """
        return pulumi.get(self, "client_basic_secret")

    @client_basic_secret.setter
    def client_basic_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_basic_secret", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client ID. If set during creation, app is created with this id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientUri")
    def client_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to a web page providing information about the client.
        """
        return pulumi.get(self, "client_uri")

    @client_uri.setter
    def client_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_uri", value)

    @property
    @pulumi.getter(name="consentMethod")
    def consent_method(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
        Default value is TRUSTED
        """
        return pulumi.get(self, "consent_method")

    @consent_method.setter
    def consent_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent_method", value)

    @property
    @pulumi.getter(name="customClientId")
    def custom_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
        no-op, use client_id for that behavior instead.
        """
        return pulumi.get(self, "custom_client_id")

    @custom_client_id.setter
    def custom_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_client_id", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OAuth 2.0 grant types. Conditional validation params found here
        https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
        app type.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input['OauthAppGroupsClaimArgs']]:
        """
        Groups claim for an OpenID Connect client application
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input['OauthAppGroupsClaimArgs']]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> Optional[pulumi.Input[bool]]:
        """
        *Early Access Property*. Enable Federation Broker Mode.
        """
        return pulumi.get(self, "implicit_assignment")

    @implicit_assignment.setter
    def implicit_assignment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_assignment", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
        custom domain URL as the issuer of ID token for this client.
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter
    def jwks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]]:
        return pulumi.get(self, "jwks")

    @jwks.setter
    def jwks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]]):
        pulumi.set(self, "jwks", value)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Idp-Initiated login that the client supports, if any
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_mode", value)

    @property
    @pulumi.getter(name="loginScopes")
    def login_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of scopes to use for the request
        """
        return pulumi.get(self, "login_scopes")

    @login_scopes.setter
    def login_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "login_scopes", value)

    @property
    @pulumi.getter(name="loginUri")
    def login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI that initiates login.
        """
        return pulumi.get(self, "login_uri")

    @login_uri.setter
    def login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_uri", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI that references a logo for the client.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter(name="omitSecret")
    def omit_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
        your app will be recreated.
        """
        return pulumi.get(self, "omit_secret")

    @omit_secret.setter
    def omit_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "omit_secret", value)

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
        `native` application types.
        """
        return pulumi.get(self, "pkce_required")

    @pkce_required.setter
    def pkce_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pkce_required", value)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to web page providing client policy document.
        """
        return pulumi.get(self, "policy_uri")

    @policy_uri.setter
    def policy_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_uri", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
        in a decentralized way.
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Custom JSON that represents an OAuth application's profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
        okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="refreshTokenLeeway")
    def refresh_token_leeway(self) -> Optional[pulumi.Input[int]]:
        """
        *Early Access Property* Grace period for token rotation
        """
        return pulumi.get(self, "refresh_token_leeway")

    @refresh_token_leeway.setter
    def refresh_token_leeway(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_token_leeway", value)

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property* Refresh token rotation behavior
        """
        return pulumi.get(self, "refresh_token_rotation")

    @refresh_token_rotation.setter
    def refresh_token_rotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token_rotation", value)

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OAuth 2.0 response type strings.
        """
        return pulumi.get(self, "response_types")

    @response_types.setter
    def response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_types", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        Requested authentication method for the token endpoint.
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @token_endpoint_auth_method.setter
    def token_endpoint_auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint_auth_method", value)

    @property
    @pulumi.getter(name="tosUri")
    def tos_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to web page providing client tos (terms of service).
        """
        return pulumi.get(self, "tos_uri")

    @tos_uri.setter
    def tos_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_uri", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter(name="wildcardRedirect")
    def wildcard_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        return pulumi.get(self, "wildcard_redirect")

    @wildcard_redirect.setter
    def wildcard_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wildcard_redirect", value)


@pulumi.input_type
class _OauthAppState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 authentication_policy: Optional[pulumi.Input[str]] = None,
                 auto_key_rotation: Optional[pulumi.Input[bool]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 client_basic_secret: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_uri: Optional[pulumi.Input[str]] = None,
                 consent_method: Optional[pulumi.Input[str]] = None,
                 custom_client_id: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_claim: Optional[pulumi.Input['OauthAppGroupsClaimArgs']] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 jwks: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 login_mode: Optional[pulumi.Input[str]] = None,
                 login_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login_uri: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 omit_secret: Optional[pulumi.Input[bool]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 policy_uri: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_leeway: Optional[pulumi.Input[int]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[str]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sign_on_mode: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 tos_uri: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]] = None,
                 wildcard_redirect: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OauthApp resources.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format
        :param pulumi.Input[str] authentication_policy: Id of this apps authentication policy
        :param pulumi.Input[bool] auto_key_rotation: Requested key rotation mode.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] client_basic_secret: OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        :param pulumi.Input[str] client_id: OAuth client ID. If set during creation, app is created with this id.
        :param pulumi.Input[str] client_secret: OAuth client secret key. This will be in plain text in your statefile unless you set omit_secret above.
        :param pulumi.Input[str] client_uri: URI to a web page providing information about the client.
        :param pulumi.Input[str] consent_method: *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
               Default value is TRUSTED
        :param pulumi.Input[str] custom_client_id: **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
               no-op, use client_id for that behavior instead.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List of OAuth 2.0 grant types. Conditional validation params found here
               https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
               app type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input['OauthAppGroupsClaimArgs'] groups_claim: Groups claim for an OpenID Connect client application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enable Federation Broker Mode.
        :param pulumi.Input[str] issuer_mode: *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
               custom domain URL as the issuer of ID token for this client.
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] login_mode: The type of Idp-Initiated login that the client supports, if any
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_scopes: List of scopes to use for the request
        :param pulumi.Input[str] login_uri: URI that initiates login.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_uri: URI that references a logo for the client.
        :param pulumi.Input[str] logo_url: URL of the application's logo
        :param pulumi.Input[str] name: Name of the app.
        :param pulumi.Input[bool] omit_secret: This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
               your app will be recreated.
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
               `native` application types.
        :param pulumi.Input[str] policy_uri: URI to web page providing client policy document.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
               in a decentralized way.
        :param pulumi.Input[str] profile: Custom JSON that represents an OAuth application's profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
               okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        :param pulumi.Input[int] refresh_token_leeway: *Early Access Property* Grace period for token rotation
        :param pulumi.Input[str] refresh_token_rotation: *Early Access Property* Refresh token rotation behavior
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: List of OAuth 2.0 response type strings.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] token_endpoint_auth_method: Requested authentication method for the token endpoint.
        :param pulumi.Input[str] tos_uri: URI to web page providing client tos (terms of service).
        :param pulumi.Input[str] type: The type of client application.
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]] users: Users associated with the application
        :param pulumi.Input[str] wildcard_redirect: *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if app_settings_json is not None:
            pulumi.set(__self__, "app_settings_json", app_settings_json)
        if authentication_policy is not None:
            pulumi.set(__self__, "authentication_policy", authentication_policy)
        if auto_key_rotation is not None:
            pulumi.set(__self__, "auto_key_rotation", auto_key_rotation)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if client_basic_secret is not None:
            pulumi.set(__self__, "client_basic_secret", client_basic_secret)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if client_uri is not None:
            pulumi.set(__self__, "client_uri", client_uri)
        if consent_method is not None:
            pulumi.set(__self__, "consent_method", consent_method)
        if custom_client_id is not None:
            warnings.warn("""This field is being replaced by client_id. Please set that field instead.""", DeprecationWarning)
            pulumi.log.warn("""custom_client_id is deprecated: This field is being replaced by client_id. Please set that field instead.""")
        if custom_client_id is not None:
            pulumi.set(__self__, "custom_client_id", custom_client_id)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if implicit_assignment is not None:
            pulumi.set(__self__, "implicit_assignment", implicit_assignment)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if jwks is not None:
            pulumi.set(__self__, "jwks", jwks)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)
        if login_scopes is not None:
            pulumi.set(__self__, "login_scopes", login_scopes)
        if login_uri is not None:
            pulumi.set(__self__, "login_uri", login_uri)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if omit_secret is not None:
            pulumi.set(__self__, "omit_secret", omit_secret)
        if pkce_required is not None:
            pulumi.set(__self__, "pkce_required", pkce_required)
        if policy_uri is not None:
            pulumi.set(__self__, "policy_uri", policy_uri)
        if post_logout_redirect_uris is not None:
            pulumi.set(__self__, "post_logout_redirect_uris", post_logout_redirect_uris)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if redirect_uris is not None:
            pulumi.set(__self__, "redirect_uris", redirect_uris)
        if refresh_token_leeway is not None:
            pulumi.set(__self__, "refresh_token_leeway", refresh_token_leeway)
        if refresh_token_rotation is not None:
            pulumi.set(__self__, "refresh_token_rotation", refresh_token_rotation)
        if response_types is not None:
            pulumi.set(__self__, "response_types", response_types)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if token_endpoint_auth_method is not None:
            pulumi.set(__self__, "token_endpoint_auth_method", token_endpoint_auth_method)
        if tos_uri is not None:
            pulumi.set(__self__, "tos_uri", tos_uri)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if wildcard_redirect is not None:
            pulumi.set(__self__, "wildcard_redirect", wildcard_redirect)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        Application settings in JSON format
        """
        return pulumi.get(self, "app_settings_json")

    @app_settings_json.setter
    def app_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_settings_json", value)

    @property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Id of this apps authentication policy
        """
        return pulumi.get(self, "authentication_policy")

    @authentication_policy.setter
    def authentication_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_policy", value)

    @property
    @pulumi.getter(name="autoKeyRotation")
    def auto_key_rotation(self) -> Optional[pulumi.Input[bool]]:
        """
        Requested key rotation mode.
        """
        return pulumi.get(self, "auto_key_rotation")

    @auto_key_rotation.setter
    def auto_key_rotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_key_rotation", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter(name="clientBasicSecret")
    def client_basic_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        """
        return pulumi.get(self, "client_basic_secret")

    @client_basic_secret.setter
    def client_basic_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_basic_secret", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client ID. If set during creation, app is created with this id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client secret key. This will be in plain text in your statefile unless you set omit_secret above.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clientUri")
    def client_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to a web page providing information about the client.
        """
        return pulumi.get(self, "client_uri")

    @client_uri.setter
    def client_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_uri", value)

    @property
    @pulumi.getter(name="consentMethod")
    def consent_method(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
        Default value is TRUSTED
        """
        return pulumi.get(self, "consent_method")

    @consent_method.setter
    def consent_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent_method", value)

    @property
    @pulumi.getter(name="customClientId")
    def custom_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
        no-op, use client_id for that behavior instead.
        """
        return pulumi.get(self, "custom_client_id")

    @custom_client_id.setter
    def custom_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_client_id", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OAuth 2.0 grant types. Conditional validation params found here
        https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
        app type.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input['OauthAppGroupsClaimArgs']]:
        """
        Groups claim for an OpenID Connect client application
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input['OauthAppGroupsClaimArgs']]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> Optional[pulumi.Input[bool]]:
        """
        *Early Access Property*. Enable Federation Broker Mode.
        """
        return pulumi.get(self, "implicit_assignment")

    @implicit_assignment.setter
    def implicit_assignment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_assignment", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
        custom domain URL as the issuer of ID token for this client.
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter
    def jwks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]]:
        return pulumi.get(self, "jwks")

    @jwks.setter
    def jwks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppJwkArgs']]]]):
        pulumi.set(self, "jwks", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Idp-Initiated login that the client supports, if any
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_mode", value)

    @property
    @pulumi.getter(name="loginScopes")
    def login_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of scopes to use for the request
        """
        return pulumi.get(self, "login_scopes")

    @login_scopes.setter
    def login_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "login_scopes", value)

    @property
    @pulumi.getter(name="loginUri")
    def login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI that initiates login.
        """
        return pulumi.get(self, "login_uri")

    @login_uri.setter
    def login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_uri", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI that references a logo for the client.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="omitSecret")
    def omit_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
        your app will be recreated.
        """
        return pulumi.get(self, "omit_secret")

    @omit_secret.setter
    def omit_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "omit_secret", value)

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
        `native` application types.
        """
        return pulumi.get(self, "pkce_required")

    @pkce_required.setter
    def pkce_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pkce_required", value)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to web page providing client policy document.
        """
        return pulumi.get(self, "policy_uri")

    @policy_uri.setter
    def policy_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_uri", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
        in a decentralized way.
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Custom JSON that represents an OAuth application's profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
        okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="refreshTokenLeeway")
    def refresh_token_leeway(self) -> Optional[pulumi.Input[int]]:
        """
        *Early Access Property* Grace period for token rotation
        """
        return pulumi.get(self, "refresh_token_leeway")

    @refresh_token_leeway.setter
    def refresh_token_leeway(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_token_leeway", value)

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property* Refresh token rotation behavior
        """
        return pulumi.get(self, "refresh_token_rotation")

    @refresh_token_rotation.setter
    def refresh_token_rotation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token_rotation", value)

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OAuth 2.0 response type strings.
        """
        return pulumi.get(self, "response_types")

    @response_types.setter
    def response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_types", value)

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sign_on_mode", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        Requested authentication method for the token endpoint.
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @token_endpoint_auth_method.setter
    def token_endpoint_auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint_auth_method", value)

    @property
    @pulumi.getter(name="tosUri")
    def tos_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI to web page providing client tos (terms of service).
        """
        return pulumi.get(self, "tos_uri")

    @tos_uri.setter
    def tos_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_uri", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of client application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OauthAppUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter(name="wildcardRedirect")
    def wildcard_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        return pulumi.get(self, "wildcard_redirect")

    @wildcard_redirect.setter
    def wildcard_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wildcard_redirect", value)


warnings.warn("""Deprecated. Use app.OAuth instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)


class OauthApp(pulumi.CustomResource):
    warnings.warn("""Deprecated. Use app.OAuth instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 authentication_policy: Optional[pulumi.Input[str]] = None,
                 auto_key_rotation: Optional[pulumi.Input[bool]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 client_basic_secret: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_uri: Optional[pulumi.Input[str]] = None,
                 consent_method: Optional[pulumi.Input[str]] = None,
                 custom_client_id: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_claim: Optional[pulumi.Input[pulumi.InputType['OauthAppGroupsClaimArgs']]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 jwks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppJwkArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 login_mode: Optional[pulumi.Input[str]] = None,
                 login_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login_uri: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 omit_secret: Optional[pulumi.Input[bool]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 policy_uri: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_leeway: Optional[pulumi.Input[int]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[str]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 tos_uri: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppUserArgs']]]]] = None,
                 wildcard_redirect: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a OauthApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format
        :param pulumi.Input[str] authentication_policy: Id of this apps authentication policy
        :param pulumi.Input[bool] auto_key_rotation: Requested key rotation mode.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] client_basic_secret: OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        :param pulumi.Input[str] client_id: OAuth client ID. If set during creation, app is created with this id.
        :param pulumi.Input[str] client_uri: URI to a web page providing information about the client.
        :param pulumi.Input[str] consent_method: *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
               Default value is TRUSTED
        :param pulumi.Input[str] custom_client_id: **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
               no-op, use client_id for that behavior instead.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List of OAuth 2.0 grant types. Conditional validation params found here
               https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
               app type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[pulumi.InputType['OauthAppGroupsClaimArgs']] groups_claim: Groups claim for an OpenID Connect client application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enable Federation Broker Mode.
        :param pulumi.Input[str] issuer_mode: *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
               custom domain URL as the issuer of ID token for this client.
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] login_mode: The type of Idp-Initiated login that the client supports, if any
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_scopes: List of scopes to use for the request
        :param pulumi.Input[str] login_uri: URI that initiates login.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_uri: URI that references a logo for the client.
        :param pulumi.Input[bool] omit_secret: This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
               your app will be recreated.
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
               `native` application types.
        :param pulumi.Input[str] policy_uri: URI to web page providing client policy document.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
               in a decentralized way.
        :param pulumi.Input[str] profile: Custom JSON that represents an OAuth application's profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
               okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        :param pulumi.Input[int] refresh_token_leeway: *Early Access Property* Grace period for token rotation
        :param pulumi.Input[str] refresh_token_rotation: *Early Access Property* Refresh token rotation behavior
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: List of OAuth 2.0 response type strings.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] token_endpoint_auth_method: Requested authentication method for the token endpoint.
        :param pulumi.Input[str] tos_uri: URI to web page providing client tos (terms of service).
        :param pulumi.Input[str] type: The type of client application.
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppUserArgs']]]] users: Users associated with the application
        :param pulumi.Input[str] wildcard_redirect: *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OauthApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OauthAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 authentication_policy: Optional[pulumi.Input[str]] = None,
                 auto_key_rotation: Optional[pulumi.Input[bool]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 client_basic_secret: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_uri: Optional[pulumi.Input[str]] = None,
                 consent_method: Optional[pulumi.Input[str]] = None,
                 custom_client_id: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_claim: Optional[pulumi.Input[pulumi.InputType['OauthAppGroupsClaimArgs']]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 jwks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppJwkArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 login_mode: Optional[pulumi.Input[str]] = None,
                 login_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login_uri: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 omit_secret: Optional[pulumi.Input[bool]] = None,
                 pkce_required: Optional[pulumi.Input[bool]] = None,
                 policy_uri: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_leeway: Optional[pulumi.Input[int]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[str]] = None,
                 response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
                 tos_uri: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppUserArgs']]]]] = None,
                 wildcard_redirect: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""OauthApp is deprecated: Deprecated. Use app.OAuth instead. This resource will be removed in version 4.0 of this provider.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthAppArgs.__new__(OauthAppArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["app_settings_json"] = app_settings_json
            __props__.__dict__["authentication_policy"] = authentication_policy
            __props__.__dict__["auto_key_rotation"] = auto_key_rotation
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            __props__.__dict__["client_basic_secret"] = client_basic_secret
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_uri"] = client_uri
            __props__.__dict__["consent_method"] = consent_method
            if custom_client_id is not None and not opts.urn:
                warnings.warn("""This field is being replaced by client_id. Please set that field instead.""", DeprecationWarning)
                pulumi.log.warn("""custom_client_id is deprecated: This field is being replaced by client_id. Please set that field instead.""")
            __props__.__dict__["custom_client_id"] = custom_client_id
            __props__.__dict__["enduser_note"] = enduser_note
            __props__.__dict__["grant_types"] = grant_types
            if groups is not None and not opts.urn:
                warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
            __props__.__dict__["groups"] = groups
            __props__.__dict__["groups_claim"] = groups_claim
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            __props__.__dict__["implicit_assignment"] = implicit_assignment
            __props__.__dict__["issuer_mode"] = issuer_mode
            __props__.__dict__["jwks"] = jwks
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["login_mode"] = login_mode
            __props__.__dict__["login_scopes"] = login_scopes
            __props__.__dict__["login_uri"] = login_uri
            __props__.__dict__["logo"] = logo
            __props__.__dict__["logo_uri"] = logo_uri
            __props__.__dict__["omit_secret"] = omit_secret
            __props__.__dict__["pkce_required"] = pkce_required
            __props__.__dict__["policy_uri"] = policy_uri
            __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
            __props__.__dict__["profile"] = profile
            __props__.__dict__["redirect_uris"] = redirect_uris
            __props__.__dict__["refresh_token_leeway"] = refresh_token_leeway
            __props__.__dict__["refresh_token_rotation"] = refresh_token_rotation
            __props__.__dict__["response_types"] = response_types
            __props__.__dict__["skip_groups"] = skip_groups
            __props__.__dict__["skip_users"] = skip_users
            __props__.__dict__["status"] = status
            __props__.__dict__["token_endpoint_auth_method"] = token_endpoint_auth_method
            __props__.__dict__["tos_uri"] = tos_uri
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_name_template"] = user_name_template
            __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
            __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
            __props__.__dict__["user_name_template_type"] = user_name_template_type
            if users is not None and not opts.urn:
                warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
            __props__.__dict__["users"] = users
            __props__.__dict__["wildcard_redirect"] = wildcard_redirect
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(OauthApp, __self__).__init__(
            'okta:deprecated/oauthApp:OauthApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_self_service: Optional[pulumi.Input[bool]] = None,
            admin_note: Optional[pulumi.Input[str]] = None,
            app_links_json: Optional[pulumi.Input[str]] = None,
            app_settings_json: Optional[pulumi.Input[str]] = None,
            authentication_policy: Optional[pulumi.Input[str]] = None,
            auto_key_rotation: Optional[pulumi.Input[bool]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
            client_basic_secret: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            client_uri: Optional[pulumi.Input[str]] = None,
            consent_method: Optional[pulumi.Input[str]] = None,
            custom_client_id: Optional[pulumi.Input[str]] = None,
            enduser_note: Optional[pulumi.Input[str]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups_claim: Optional[pulumi.Input[pulumi.InputType['OauthAppGroupsClaimArgs']]] = None,
            hide_ios: Optional[pulumi.Input[bool]] = None,
            hide_web: Optional[pulumi.Input[bool]] = None,
            implicit_assignment: Optional[pulumi.Input[bool]] = None,
            issuer_mode: Optional[pulumi.Input[str]] = None,
            jwks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppJwkArgs']]]]] = None,
            label: Optional[pulumi.Input[str]] = None,
            login_mode: Optional[pulumi.Input[str]] = None,
            login_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            login_uri: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            logo_uri: Optional[pulumi.Input[str]] = None,
            logo_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            omit_secret: Optional[pulumi.Input[bool]] = None,
            pkce_required: Optional[pulumi.Input[bool]] = None,
            policy_uri: Optional[pulumi.Input[str]] = None,
            post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            profile: Optional[pulumi.Input[str]] = None,
            redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            refresh_token_leeway: Optional[pulumi.Input[int]] = None,
            refresh_token_rotation: Optional[pulumi.Input[str]] = None,
            response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sign_on_mode: Optional[pulumi.Input[str]] = None,
            skip_groups: Optional[pulumi.Input[bool]] = None,
            skip_users: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            token_endpoint_auth_method: Optional[pulumi.Input[str]] = None,
            tos_uri: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_name_template: Optional[pulumi.Input[str]] = None,
            user_name_template_push_status: Optional[pulumi.Input[str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[str]] = None,
            user_name_template_type: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppUserArgs']]]]] = None,
            wildcard_redirect: Optional[pulumi.Input[str]] = None) -> 'OauthApp':
        """
        Get an existing OauthApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format
        :param pulumi.Input[str] authentication_policy: Id of this apps authentication policy
        :param pulumi.Input[bool] auto_key_rotation: Requested key rotation mode.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] client_basic_secret: OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        :param pulumi.Input[str] client_id: OAuth client ID. If set during creation, app is created with this id.
        :param pulumi.Input[str] client_secret: OAuth client secret key. This will be in plain text in your statefile unless you set omit_secret above.
        :param pulumi.Input[str] client_uri: URI to a web page providing information about the client.
        :param pulumi.Input[str] consent_method: *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
               Default value is TRUSTED
        :param pulumi.Input[str] custom_client_id: **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
               no-op, use client_id for that behavior instead.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: List of OAuth 2.0 grant types. Conditional validation params found here
               https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
               app type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[pulumi.InputType['OauthAppGroupsClaimArgs']] groups_claim: Groups claim for an OpenID Connect client application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enable Federation Broker Mode.
        :param pulumi.Input[str] issuer_mode: *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
               custom domain URL as the issuer of ID token for this client.
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] login_mode: The type of Idp-Initiated login that the client supports, if any
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_scopes: List of scopes to use for the request
        :param pulumi.Input[str] login_uri: URI that initiates login.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_uri: URI that references a logo for the client.
        :param pulumi.Input[str] logo_url: URL of the application's logo
        :param pulumi.Input[str] name: Name of the app.
        :param pulumi.Input[bool] omit_secret: This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
               your app will be recreated.
        :param pulumi.Input[bool] pkce_required: Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
               `native` application types.
        :param pulumi.Input[str] policy_uri: URI to web page providing client policy document.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
               in a decentralized way.
        :param pulumi.Input[str] profile: Custom JSON that represents an OAuth application's profile
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
               okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        :param pulumi.Input[int] refresh_token_leeway: *Early Access Property* Grace period for token rotation
        :param pulumi.Input[str] refresh_token_rotation: *Early Access Property* Refresh token rotation behavior
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_types: List of OAuth 2.0 response type strings.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] token_endpoint_auth_method: Requested authentication method for the token endpoint.
        :param pulumi.Input[str] tos_uri: URI to web page providing client tos (terms of service).
        :param pulumi.Input[str] type: The type of client application.
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OauthAppUserArgs']]]] users: Users associated with the application
        :param pulumi.Input[str] wildcard_redirect: *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthAppState.__new__(_OauthAppState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["app_settings_json"] = app_settings_json
        __props__.__dict__["authentication_policy"] = authentication_policy
        __props__.__dict__["auto_key_rotation"] = auto_key_rotation
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["client_basic_secret"] = client_basic_secret
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["client_uri"] = client_uri
        __props__.__dict__["consent_method"] = consent_method
        __props__.__dict__["custom_client_id"] = custom_client_id
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["grant_types"] = grant_types
        __props__.__dict__["groups"] = groups
        __props__.__dict__["groups_claim"] = groups_claim
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["implicit_assignment"] = implicit_assignment
        __props__.__dict__["issuer_mode"] = issuer_mode
        __props__.__dict__["jwks"] = jwks
        __props__.__dict__["label"] = label
        __props__.__dict__["login_mode"] = login_mode
        __props__.__dict__["login_scopes"] = login_scopes
        __props__.__dict__["login_uri"] = login_uri
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_uri"] = logo_uri
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["omit_secret"] = omit_secret
        __props__.__dict__["pkce_required"] = pkce_required
        __props__.__dict__["policy_uri"] = policy_uri
        __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
        __props__.__dict__["profile"] = profile
        __props__.__dict__["redirect_uris"] = redirect_uris
        __props__.__dict__["refresh_token_leeway"] = refresh_token_leeway
        __props__.__dict__["refresh_token_rotation"] = refresh_token_rotation
        __props__.__dict__["response_types"] = response_types
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["skip_groups"] = skip_groups
        __props__.__dict__["skip_users"] = skip_users
        __props__.__dict__["status"] = status
        __props__.__dict__["token_endpoint_auth_method"] = token_endpoint_auth_method
        __props__.__dict__["tos_uri"] = tos_uri
        __props__.__dict__["type"] = type
        __props__.__dict__["user_name_template"] = user_name_template
        __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
        __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
        __props__.__dict__["user_name_template_type"] = user_name_template_type
        __props__.__dict__["users"] = users
        __props__.__dict__["wildcard_redirect"] = wildcard_redirect
        return OauthApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> pulumi.Output[Optional[str]]:
        """
        Application settings in JSON format
        """
        return pulumi.get(self, "app_settings_json")

    @property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Id of this apps authentication policy
        """
        return pulumi.get(self, "authentication_policy")

    @property
    @pulumi.getter(name="autoKeyRotation")
    def auto_key_rotation(self) -> pulumi.Output[Optional[bool]]:
        """
        Requested key rotation mode.
        """
        return pulumi.get(self, "auto_key_rotation")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter(name="clientBasicSecret")
    def client_basic_secret(self) -> pulumi.Output[Optional[str]]:
        """
        OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
        """
        return pulumi.get(self, "client_basic_secret")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        OAuth client ID. If set during creation, app is created with this id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        OAuth client secret key. This will be in plain text in your statefile unless you set omit_secret above.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientUri")
    def client_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URI to a web page providing information about the client.
        """
        return pulumi.get(self, "client_uri")

    @property
    @pulumi.getter(name="consentMethod")
    def consent_method(self) -> pulumi.Output[Optional[str]]:
        """
        *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED.
        Default value is TRUSTED
        """
        return pulumi.get(self, "consent_method")

    @property
    @pulumi.getter(name="customClientId")
    def custom_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a
        no-op, use client_id for that behavior instead.
        """
        return pulumi.get(self, "custom_client_id")

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OAuth 2.0 grant types. Conditional validation params found here
        https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per
        app type.
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> pulumi.Output[Optional['outputs.OauthAppGroupsClaim']]:
        """
        Groups claim for an OpenID Connect client application
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> pulumi.Output[Optional[bool]]:
        """
        *Early Access Property*. Enable Federation Broker Mode.
        """
        return pulumi.get(self, "implicit_assignment")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[str]]:
        """
        *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a
        custom domain URL as the issuer of ID token for this client.
        """
        return pulumi.get(self, "issuer_mode")

    @property
    @pulumi.getter
    def jwks(self) -> pulumi.Output[Optional[Sequence['outputs.OauthAppJwk']]]:
        return pulumi.get(self, "jwks")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The type of Idp-Initiated login that the client supports, if any
        """
        return pulumi.get(self, "login_mode")

    @property
    @pulumi.getter(name="loginScopes")
    def login_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of scopes to use for the request
        """
        return pulumi.get(self, "login_scopes")

    @property
    @pulumi.getter(name="loginUri")
    def login_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URI that initiates login.
        """
        return pulumi.get(self, "login_uri")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URI that references a logo for the client.
        """
        return pulumi.get(self, "logo_uri")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[str]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="omitSecret")
    def omit_secret(self) -> pulumi.Output[Optional[bool]]:
        """
        This tells the provider not to persist the application's secret to state. If this is ever changes from true => false
        your app will be recreated.
        """
        return pulumi.get(self, "omit_secret")

    @property
    @pulumi.getter(name="pkceRequired")
    def pkce_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Require Proof Key for Code Exchange (PKCE) for additional verification key rotation mode. `true` for `browser` and
        `native` application types.
        """
        return pulumi.get(self, "pkce_required")

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URI to web page providing client policy document.
        """
        return pulumi.get(self, "policy_uri")

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list
        in a decentralized way.
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[str]]:
        """
        Custom JSON that represents an OAuth application's profile
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see
        okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter(name="refreshTokenLeeway")
    def refresh_token_leeway(self) -> pulumi.Output[int]:
        """
        *Early Access Property* Grace period for token rotation
        """
        return pulumi.get(self, "refresh_token_leeway")

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> pulumi.Output[str]:
        """
        *Early Access Property* Refresh token rotation behavior
        """
        return pulumi.get(self, "refresh_token_rotation")

    @property
    @pulumi.getter(name="responseTypes")
    def response_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of OAuth 2.0 response type strings.
        """
        return pulumi.get(self, "response_types")

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tokenEndpointAuthMethod")
    def token_endpoint_auth_method(self) -> pulumi.Output[Optional[str]]:
        """
        Requested authentication method for the token endpoint.
        """
        return pulumi.get(self, "token_endpoint_auth_method")

    @property
    @pulumi.getter(name="tosUri")
    def tos_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URI to web page providing client tos (terms of service).
        """
        return pulumi.get(self, "tos_uri")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of client application.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> pulumi.Output[Optional[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.OauthAppUser']]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter(name="wildcardRedirect")
    def wildcard_redirect(self) -> pulumi.Output[Optional[str]]:
        """
        *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
        """
        return pulumi.get(self, "wildcard_redirect")

