# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SocialIdpArgs', 'SocialIdp']

@pulumi.input_type
class SocialIdpArgs:
    def __init__(__self__, *,
                 scopes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apple_kid: Optional[pulumi.Input[str]] = None,
                 apple_private_key: Optional[pulumi.Input[str]] = None,
                 apple_team_id: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 match_type: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SocialIdp resource.
        :param pulumi.Input[str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        :param pulumi.Input[str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[str] apple_private_key: The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        :param pulumi.Input[str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[str] name: Name of the IdP
        """
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "type", type)
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if apple_kid is not None:
            pulumi.set(__self__, "apple_kid", apple_kid)
        if apple_private_key is not None:
            pulumi.set(__self__, "apple_private_key", apple_private_key)
        if apple_team_id is not None:
            pulumi.set(__self__, "apple_team_id", apple_team_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if match_attribute is not None:
            warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""", DeprecationWarning)
            pulumi.log.warn("""match_attribute is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""")
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if match_type is not None:
            warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_type\"""", DeprecationWarning)
            pulumi.log.warn("""match_type is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_type\"""")
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_link_action", value)

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> Optional[pulumi.Input[str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @apple_kid.setter
    def apple_kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_kid", value)

    @property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        """
        return pulumi.get(self, "apple_private_key")

    @apple_private_key.setter
    def apple_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_private_key", value)

    @property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @apple_team_id.setter
    def apple_team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_team_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_action", value)

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_filters", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "match_type")

    @match_type.setter
    def match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_type", value)

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_clock_skew", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "profile_master", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_action", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_type", value)

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suspended_action", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


@pulumi.input_type
class _SocialIdpState:
    def __init__(__self__, *,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apple_kid: Optional[pulumi.Input[str]] = None,
                 apple_private_key: Optional[pulumi.Input[str]] = None,
                 apple_team_id: Optional[pulumi.Input[str]] = None,
                 authorization_binding: Optional[pulumi.Input[str]] = None,
                 authorization_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 match_type: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 token_binding: Optional[pulumi.Input[str]] = None,
                 token_url: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SocialIdp resources.
        :param pulumi.Input[str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[str] apple_private_key: The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        :param pulumi.Input[str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if apple_kid is not None:
            pulumi.set(__self__, "apple_kid", apple_kid)
        if apple_private_key is not None:
            pulumi.set(__self__, "apple_private_key", apple_private_key)
        if apple_team_id is not None:
            pulumi.set(__self__, "apple_team_id", apple_team_id)
        if authorization_binding is not None:
            pulumi.set(__self__, "authorization_binding", authorization_binding)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if match_attribute is not None:
            warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""", DeprecationWarning)
            pulumi.log.warn("""match_attribute is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""")
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if match_type is not None:
            warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_type\"""", DeprecationWarning)
            pulumi.log.warn("""match_type is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_type\"""")
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if token_binding is not None:
            pulumi.set(__self__, "token_binding", token_binding)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_link_action", value)

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> Optional[pulumi.Input[str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @apple_kid.setter
    def apple_kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_kid", value)

    @property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        """
        return pulumi.get(self, "apple_private_key")

    @apple_private_key.setter
    def apple_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_private_key", value)

    @property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @apple_team_id.setter
    def apple_team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apple_team_id", value)

    @property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "authorization_binding")

    @authorization_binding.setter
    def authorization_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_binding", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_action", value)

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_filters", value)

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_mode", value)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "match_type")

    @match_type.setter
    def match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_type", value)

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_clock_skew", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "profile_master", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_action", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_match_type", value)

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suspended_action", value)

    @property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "token_binding")

    @token_binding.setter
    def token_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_binding", value)

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_url", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


warnings.warn("""Deprecated. Use idp.Social instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)


class SocialIdp(pulumi.CustomResource):
    warnings.warn("""Deprecated. Use idp.Social instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apple_kid: Optional[pulumi.Input[str]] = None,
                 apple_private_key: Optional[pulumi.Input[str]] = None,
                 apple_team_id: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 match_type: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a SocialIdp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[str] apple_private_key: The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        :param pulumi.Input[str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SocialIdpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SocialIdp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SocialIdpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SocialIdpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apple_kid: Optional[pulumi.Input[str]] = None,
                 apple_private_key: Optional[pulumi.Input[str]] = None,
                 apple_team_id: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[str]] = None,
                 groups_action: Optional[pulumi.Input[str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 match_type: Optional[pulumi.Input[str]] = None,
                 max_clock_skew: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_master: Optional[pulumi.Input[bool]] = None,
                 protocol_type: Optional[pulumi.Input[str]] = None,
                 provisioning_action: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[str]] = None,
                 subject_match_type: Optional[pulumi.Input[str]] = None,
                 suspended_action: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""SocialIdp is deprecated: Deprecated. Use idp.Social instead. This resource will be removed in version 4.0 of this provider.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SocialIdpArgs.__new__(SocialIdpArgs)

            __props__.__dict__["account_link_action"] = account_link_action
            __props__.__dict__["account_link_group_includes"] = account_link_group_includes
            __props__.__dict__["apple_kid"] = apple_kid
            __props__.__dict__["apple_private_key"] = apple_private_key
            __props__.__dict__["apple_team_id"] = apple_team_id
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["deprovisioned_action"] = deprovisioned_action
            __props__.__dict__["groups_action"] = groups_action
            __props__.__dict__["groups_assignments"] = groups_assignments
            __props__.__dict__["groups_attribute"] = groups_attribute
            __props__.__dict__["groups_filters"] = groups_filters
            __props__.__dict__["issuer_mode"] = issuer_mode
            if match_attribute is not None and not opts.urn:
                warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""", DeprecationWarning)
                pulumi.log.warn("""match_attribute is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_attribute\"""")
            __props__.__dict__["match_attribute"] = match_attribute
            if match_type is not None and not opts.urn:
                warnings.warn("""This property was incorrectly added to this resource, you should use \"subject_match_type\"""", DeprecationWarning)
                pulumi.log.warn("""match_type is deprecated: This property was incorrectly added to this resource, you should use \"subject_match_type\"""")
            __props__.__dict__["match_type"] = match_type
            __props__.__dict__["max_clock_skew"] = max_clock_skew
            __props__.__dict__["name"] = name
            __props__.__dict__["profile_master"] = profile_master
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["provisioning_action"] = provisioning_action
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
            __props__.__dict__["subject_match_attribute"] = subject_match_attribute
            __props__.__dict__["subject_match_type"] = subject_match_type
            __props__.__dict__["suspended_action"] = suspended_action
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["username_template"] = username_template
            __props__.__dict__["authorization_binding"] = None
            __props__.__dict__["authorization_url"] = None
            __props__.__dict__["token_binding"] = None
            __props__.__dict__["token_url"] = None
        super(SocialIdp, __self__).__init__(
            'okta:deprecated/socialIdp:SocialIdp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_link_action: Optional[pulumi.Input[str]] = None,
            account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            apple_kid: Optional[pulumi.Input[str]] = None,
            apple_private_key: Optional[pulumi.Input[str]] = None,
            apple_team_id: Optional[pulumi.Input[str]] = None,
            authorization_binding: Optional[pulumi.Input[str]] = None,
            authorization_url: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            deprovisioned_action: Optional[pulumi.Input[str]] = None,
            groups_action: Optional[pulumi.Input[str]] = None,
            groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups_attribute: Optional[pulumi.Input[str]] = None,
            groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            issuer_mode: Optional[pulumi.Input[str]] = None,
            match_attribute: Optional[pulumi.Input[str]] = None,
            match_type: Optional[pulumi.Input[str]] = None,
            max_clock_skew: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            profile_master: Optional[pulumi.Input[bool]] = None,
            protocol_type: Optional[pulumi.Input[str]] = None,
            provisioning_action: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subject_match_attribute: Optional[pulumi.Input[str]] = None,
            subject_match_type: Optional[pulumi.Input[str]] = None,
            suspended_action: Optional[pulumi.Input[str]] = None,
            token_binding: Optional[pulumi.Input[str]] = None,
            token_url: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            username_template: Optional[pulumi.Input[str]] = None) -> 'SocialIdp':
        """
        Get an existing SocialIdp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[str] apple_private_key: The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        :param pulumi.Input[str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[str] name: Name of the IdP
        :param pulumi.Input[str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SocialIdpState.__new__(_SocialIdpState)

        __props__.__dict__["account_link_action"] = account_link_action
        __props__.__dict__["account_link_group_includes"] = account_link_group_includes
        __props__.__dict__["apple_kid"] = apple_kid
        __props__.__dict__["apple_private_key"] = apple_private_key
        __props__.__dict__["apple_team_id"] = apple_team_id
        __props__.__dict__["authorization_binding"] = authorization_binding
        __props__.__dict__["authorization_url"] = authorization_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["deprovisioned_action"] = deprovisioned_action
        __props__.__dict__["groups_action"] = groups_action
        __props__.__dict__["groups_assignments"] = groups_assignments
        __props__.__dict__["groups_attribute"] = groups_attribute
        __props__.__dict__["groups_filters"] = groups_filters
        __props__.__dict__["issuer_mode"] = issuer_mode
        __props__.__dict__["match_attribute"] = match_attribute
        __props__.__dict__["match_type"] = match_type
        __props__.__dict__["max_clock_skew"] = max_clock_skew
        __props__.__dict__["name"] = name
        __props__.__dict__["profile_master"] = profile_master
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["provisioning_action"] = provisioning_action
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_match_attribute"] = subject_match_attribute
        __props__.__dict__["subject_match_type"] = subject_match_type
        __props__.__dict__["suspended_action"] = suspended_action
        __props__.__dict__["token_binding"] = token_binding
        __props__.__dict__["token_url"] = token_url
        __props__.__dict__["type"] = type
        __props__.__dict__["username_template"] = username_template
        return SocialIdp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "account_link_action")

    @property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "account_link_group_includes")

    @property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> pulumi.Output[Optional[str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> pulumi.Output[Optional[str]]:
        """
        The PKCS #8 encoded private key that you created for the client and downloaded from Apple
        """
        return pulumi.get(self, "apple_private_key")

    @property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> pulumi.Output[str]:
        return pulumi.get(self, "authorization_binding")

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "authorization_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "deprovisioned_action")

    @property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "groups_action")

    @property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "groups_assignments")

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "groups_attribute")

    @property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "groups_filters")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "match_attribute")

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "max_clock_skew")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "profile_master")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "provisioning_action")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subject_match_attribute")

    @property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subject_match_type")

    @property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "suspended_action")

    @property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> pulumi.Output[str]:
        return pulumi.get(self, "token_binding")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "token_url")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "username_template")

