# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['EmailCustomizationArgs', 'EmailCustomization']

@pulumi.input_type
class EmailCustomizationArgs:
    def __init__(__self__, *,
                 brand_id: pulumi.Input[str],
                 template_name: pulumi.Input[str],
                 body: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EmailCustomization resource.
        :param pulumi.Input[str] brand_id: Brand ID
        :param pulumi.Input[str] template_name: Template Name
        :param pulumi.Input[str] body: The body of the customization
        :param pulumi.Input[bool] is_default: Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        :param pulumi.Input[str] language: The language supported by the customization
        :param pulumi.Input[str] subject: The subject of the customization
        """
        pulumi.set(__self__, "brand_id", brand_id)
        pulumi.set(__self__, "template_name", template_name)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Input[str]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "brand_id", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[str]:
        """
        Template Name
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)


@pulumi.input_type
class _EmailCustomizationState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 brand_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 links: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EmailCustomization resources.
        :param pulumi.Input[str] body: The body of the customization
        :param pulumi.Input[str] brand_id: Brand ID
        :param pulumi.Input[bool] is_default: Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        :param pulumi.Input[str] language: The language supported by the customization
        :param pulumi.Input[str] links: (Read-Only) Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param pulumi.Input[str] subject: The subject of the customization
        :param pulumi.Input[str] template_name: Template Name
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if brand_id is not None:
            pulumi.set(__self__, "brand_id", brand_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> Optional[pulumi.Input[str]]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @brand_id.setter
    def brand_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "brand_id", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[str]]:
        """
        (Read-Only) Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Template Name
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)


class EmailCustomization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 brand_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to create an [email
        customization](https://developer.okta.com/docs/reference/api/brands/#create-email-customization)
        of an email template belonging to a brand in an Okta organization.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: The body of the customization
        :param pulumi.Input[str] brand_id: Brand ID
        :param pulumi.Input[bool] is_default: Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        :param pulumi.Input[str] language: The language supported by the customization
        :param pulumi.Input[str] subject: The subject of the customization
        :param pulumi.Input[str] template_name: Template Name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailCustomizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create an [email
        customization](https://developer.okta.com/docs/reference/api/brands/#create-email-customization)
        of an email template belonging to a brand in an Okta organization.

        :param str resource_name: The name of the resource.
        :param EmailCustomizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailCustomizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 brand_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailCustomizationArgs.__new__(EmailCustomizationArgs)

            __props__.__dict__["body"] = body
            if brand_id is None and not opts.urn:
                raise TypeError("Missing required property 'brand_id'")
            __props__.__dict__["brand_id"] = brand_id
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["language"] = language
            __props__.__dict__["subject"] = subject
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["links"] = None
        super(EmailCustomization, __self__).__init__(
            'okta:index/emailCustomization:EmailCustomization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[str]] = None,
            brand_id: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            language: Optional[pulumi.Input[str]] = None,
            links: Optional[pulumi.Input[str]] = None,
            subject: Optional[pulumi.Input[str]] = None,
            template_name: Optional[pulumi.Input[str]] = None) -> 'EmailCustomization':
        """
        Get an existing EmailCustomization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: The body of the customization
        :param pulumi.Input[str] brand_id: Brand ID
        :param pulumi.Input[bool] is_default: Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        :param pulumi.Input[str] language: The language supported by the customization
        :param pulumi.Input[str] links: (Read-Only) Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param pulumi.Input[str] subject: The subject of the customization
        :param pulumi.Input[str] template_name: Template Name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailCustomizationState.__new__(_EmailCustomizationState)

        __props__.__dict__["body"] = body
        __props__.__dict__["brand_id"] = brand_id
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["language"] = language
        __props__.__dict__["links"] = links
        __props__.__dict__["subject"] = subject
        __props__.__dict__["template_name"] = template_name
        return EmailCustomization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[str]]:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> pulumi.Output[str]:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the customization is the default. If `is_default` is true and there is already a default customization when this resource is created will cause an error. Only set to true for updating a resource.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[str]]:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[str]:
        """
        (Read-Only) Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output[Optional[str]]:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        Template Name
        """
        return pulumi.get(self, "template_name")

