# Generated by Django 3.0.5 on 2020-04-16 11:13

import django.db.models.deletion
from django.db import migrations, models

import weblate.utils.fields


class Migration(migrations.Migration):

    replaces = [
        ("addons", "0001_squashed_0006_addon_project_scope"),
        ("addons", "0007_auto_20180629_1736"),
        ("addons", "0008_auto_20180727_1454"),
        ("addons", "0009_auto_20181207_1322"),
        ("addons", "0010_auto_20181214_1232"),
        ("addons", "0011_squash_addon"),
        ("addons", "0012_addon_repo_scope"),
        ("addons", "0013_fix_repo_scope"),
        ("addons", "0014_auto_20190510_1325"),
        ("addons", "0015_flags"),
        ("addons", "0016_language_consistency"),
        ("addons", "0017_auto_format_fixup"),
        ("addons", "0018_resx"),
        ("addons", "0019_auto_20200210_0957"),
        ("addons", "0020_component_update"),
        ("addons", "0021_linguas_daily"),
    ]

    initial = True

    dependencies = [
        ("trans", "0001_squashed_0143_auto_20180609_1655"),
    ]

    operations = [
        migrations.CreateModel(
            name="Addon",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("configuration", weblate.utils.fields.JSONField(default={})),
                ("state", weblate.utils.fields.JSONField(default={})),
                (
                    "component",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.Component",
                    ),
                ),
                ("project_scope", models.BooleanField(db_index=True, default=False)),
                ("repo_scope", models.BooleanField(db_index=True, default=False)),
            ],
            options={"verbose_name": "add-on", "verbose_name_plural": "add-ons"},
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "event",
                    models.IntegerField(
                        choices=[
                            (10, "pre push"),
                            (1, "post push"),
                            (9, "pre update"),
                            (2, "post update"),
                            (3, "pre commit"),
                            (4, "post commit"),
                            (5, "post add"),
                            (6, "unit post create"),
                            (8, "unit post save"),
                            (7, "store post load"),
                            (11, "daily"),
                            (12, "component update"),
                        ]
                    ),
                ),
                (
                    "addon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="addons.Addon"
                    ),
                ),
            ],
            options={
                "unique_together": {("addon", "event")},
                "verbose_name": "add-on event",
                "verbose_name_plural": "add-on events",
            },
        ),
    ]
