# Generated by Django 3.1.7 on 2021-03-30 06:30

from django.db import migrations


def fixup_non_unique(apps, schema_editor):
    Metric = apps.get_model("metrics", "Metric")
    db_alias = schema_editor.connection.alias
    found = set()
    remove = []
    for metric in Metric.objects.using(db_alias).order_by("id").iterator():
        key = (metric.date, metric.scope, metric.relation, metric.name)
        if key in found:
            remove.append(metric.id)
        else:
            found.add(key)
    if remove:
        Metric.objects.filter(pk__in=remove).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("metrics", "0002_import_user_metrics"),
    ]

    operations = [
        migrations.RunPython(
            fixup_non_unique, migrations.RunPython.noop, elidable=True
        ),
    ]
