from typing import cast
from ubipod.circuit import Circuit, TexAniInfoFile
from ubipod.pbdf import PbdfFormat, PbdfReader, PbdfRelease, PbdfWriter

inFile = "C:\\Users\\User\\Archive\\Games\\Pod\\work\\DATA\\BINARY\\CIRCUITS\\SPIN.orig.BL4"
outFile = "C:\\Users\\User\\Archive\\Games\\Pod\\work\\DATA\\BINARY\\CIRCUITS\\SPIN.BL4"

format = PbdfFormat(inFile, PbdfRelease.RETAIL)
with PbdfReader(open(inFile, "rb"), format.key, format.buf_size) as read:
	read.format = format
	circuit = read.any(Circuit)

ani_info_file = cast(TexAniInfoFile, circuit.ani_info_files[0])
del ani_info_file.anis[0].sectors[8]

with PbdfWriter(open(outFile, "w+b"), format.key, format.buf_size, format.ofs_count) as write:
	write.format = format
	write.any(circuit)
