<p align="center">
  <a href="https://github.com/Decentra-Network/Decentra-Network">
    <img src="https://user-images.githubusercontent.com/41792982/114188349-b7cd0700-9951-11eb-84ea-3b31495b5635.png" alt="Logo" width="150" height="206">
  </a>

  <h3 align="center">Decentra Network Core</h3>

  <p align="center">
    Develop or use applications in your independent, decentralized application network.
    <br />
    <a href="https://decentranetwork.org/"><strong>Explore the website »</strong></a>
    <br />
  </p>
  <p align="center">
  <img src="https://img.shields.io/github/v/release/Decentra-Network/Decentra-Network" alt="release_version">
  </p>
  <p align="center">
  <a href="https://www.python.org/">
  <img src="https://img.shields.io/badge/Made%20with-Python-1f425f.svg" alt="Made_with_python">
  </a>
  .
  <img src="https://img.shields.io/github/repo-size/Decentra-Network/Decentra-Network" alt="repo_size">
  .
  <img  src="https://img.shields.io/tokei/lines/github/Decentra-Network/Decentra-Network" alt="total_lines">
  </p>

  <p align="center">
  <a href="https://www.codefactor.io/repository/github/decentra-network/decentra-network"><img src="https://www.codefactor.io/repository/github/decentra-network/decentra-network/badge" alt="CodeFactor" /></a>
  .
  <a href="https://lgtm.com/projects/g/Decentra-Network/Decentra-Network/context:python"><img alt="Language grade: Python" src="https://img.shields.io/lgtm/grade/python/g/Decentra-Network/Decentra-Network.svg?logo=lgtm&logoWidth=18"/></a>
  </p>

  <p align="center">
  <a href="https://codebeat.co/projects/github-com-decentra-network-decentra-network-master"><img alt="codebeat badge" src="https://codebeat.co/badges/de3a4741-5829-4fbd-9eaf-6ca26689586e" /></a>
  .
  <a href="https://www.codacy.com/gh/Decentra-Network/Decentra-Network/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=Decentra-Network/Decentra-Network&amp;utm_campaign=Badge_Grade"><img src="https://app.codacy.com/project/badge/Grade/b6a1e33964ac4759bc36a02763ca9bcb"/></a>
  </p>

  <p align="center">
  <a href="https://codescene.io/projects/23147/architecture/biomarkers?component=Decentra-network">
  <img alt="CodeScene Code Health" src="https://codescene.io/projects/23147/status-badges/code-health?component-name=Decentra-network">
</a>
  .
  <a href="https://codescene.io/projects/23147/">
  <img alt="CodeScene System Mastery" src="https://codescene.io/projects/23147/status-badges/system-mastery?component-name=Decentra-network">
</a>
  .
  <a href="https://codescene.io/projects/23147"><img src="https://codescene.io/projects/23147/status-badges/missed-goals" alt="Missed Goals"></a>
  </p>

  <p align="center">
  <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/windows_latest_unit_test.yml">
    <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/windows_latest_unit_test.yml/badge.svg" alt="Windows_Latest_Unit_Test">
  </a>
  .
  <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/ubuntu_latest_unit_test.yml">
    <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/ubuntu_latest_unit_test.yml/badge.svg" alt="Ubuntu_Latest_Unit_Test">
  </a>
  .
  <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/macos_latest_unit_test.yml">
    <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/macos_latest_unit_test.yml/badge.svg" alt="MacOS_Latest_Unit_Test">
  </a>
  </p>

  <p align="center">
  <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/codeql-analysis.yml">
  <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/codeql-analysis.yml/badge.svg" alt="CodeQL">
  </a>
  .
   <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/lint_with_flake8.yml">
  <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/lint_with_flake8.yml/badge.svg" alt="Lint_with_flake8">
  <a/>
  </p>

  <p align="center">
    <a href="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/functional_tests.yml">
      <img src="https://github.com/Decentra-Network/Decentra-Network/actions/workflows/functional_tests.yml/badge.svg" alt="Functional_tests">
    </a>
  </p>

# Introducing

Decentra Network is an **open source blockchain** that combines **speed**, **security** and **decentralization**. Decentra Network has very high speeds, scalability, asymptotic security and complete decentralization.
The main features of Decentra Network are:

- Less than 7 Seconds block time (Confirmation Time)
- Low size (~20mb per 1m user)
- 10k+ transactions per second
- Low Transaction Fee
- Custom and low cost Token, NTF etc. Creation system (Scheduled Feature)
- Usability even on mobile devices
- Environmentally Friendly
- Asymptotic security against Sybil attacks (51 Attack)
- Completely decentralized structure
- Official community officers supported in-chain
- In-chain developer incentives
- Built-in application structure
- Custom wallet system

The software is written in **PEP8** format and **only** needs dependent libraries for GUI panel. Decentra Network Core software, designed with a focus on the **community on the Github platform**, In addition, **UNIT** tests of some systems are ready and automated. It also has various structures for **automatic setup of test environments**. It is fully compatible with **Git code management system** and **Agile mindset**.

**The Decentra-Network Core has 4 control areas:**

## GUI

The GUI was made with **kivy** and some auxiliary libraries to be **cross platform**. It was intended to be useful with a **minimalist** design.The GUI, which has a useful structure, is ready for **additions** and **changes**.

**The GUI has a total of 4 pages.**
<br />

<p float="center">
  <img src="https://user-images.githubusercontent.com/41792982/124753209-5eb14700-df31-11eb-8f21-8b4d6575402f.PNG" width="48%" />
  <img src="https://user-images.githubusercontent.com/41792982/124753346-8bfdf500-df31-11eb-92c1-8629663000b2.PNG" width="48%" />

</p>
<p float="center">
  <img src="https://user-images.githubusercontent.com/41792982/124753515-bd76c080-df31-11eb-9663-6dba5db9db5d.PNG" width="48%" />
  <img src="https://user-images.githubusercontent.com/41792982/124753541-c5366500-df31-11eb-9dbf-daf39c7decb9.PNG" width="48%" />
</p>

## CLI Menu

The CLI Menu panel is designed to be useful.

![cli menu](https://user-images.githubusercontent.com/41792982/124754486-f5cace80-df32-11eb-9042-b3dadbd88904.PNG)

## CLI Arguments

The CLI Arguments panel is designed to make some adjustments quickly and in multiple ways.

![cli arguments](https://user-images.githubusercontent.com/41792982/124754779-44786880-df33-11eb-9dda-b5440128ed6c.PNG)

## WEB API

It has been developed to make web api control easier and to provide control by other languages and other systems.

![api](https://user-images.githubusercontent.com/41792982/124757058-ded9ab80-df35-11eb-8ceb-f3e9672a0283.PNG)

# Documents

Our documents are available in the [docs](https://github.com/Decentra-Network/Decentra-Network/tree/master/docs) folder and [this](https://decentra-network.github.io/Decentra-Network/) website.

# Contribute

Decentra Network is a completely community driven project, you can contribute in any way if you follow the [guidelines](https://github.com/Decentra-Network/Decentra-Network/blob/master/CONTRIBUTING.md) and [terms](https://github.com/Decentra-Network/Decentra-Network/blob/master/CODE_OF_CONDUCT.md).

<br />

# Analysis && Statistics

## Recent Activity

<details>
  <img src="https://images.repography.com/22744517/Decentra-Network/Decentra-Network/recent-activity/c5bdec035b13c76d31dd5333396957cc.svg" alt="Recent_Activity">
</details>

## Top Contributors

<details>
  <img src="https://images.repography.com/22744517/Decentra-Network/Decentra-Network/top-contributors/c5bdec035b13c76d31dd5333396957cc.svg" alt="Top_Contributors">
</details>

## Structure

<details>
  <img src="https://images.repography.com/22744517/Decentra-Network/Decentra-Network/structure/c5bdec035b13c76d31dd5333396957cc.svg" alt="Structure">
</details>

## Github Statistics

<p align="center">

  <p align="center">
    <img src="https://img.shields.io/github/stars/Decentra-Network/Decentra-Network?style=social" alt="Repo_stars">
  .
  <img src="https://img.shields.io/github/forks/Decentra-Network/Decentra-Network?style=social" alt="Repo_forks">
    <br />
  <img src="https://img.shields.io/github/issues-raw/Decentra-Network/Decentra-Network" alt="Open_issues">
  .
  <img src="https://img.shields.io/github/issues-closed-raw/Decentra-Network/Decentra-Network" alt="Closed_issues">
    <br />
  <img src="https://img.shields.io/github/issues-pr-raw/Decentra-Network/Decentra-Network" alt="Open_pull_requests">
  .
    <img src="https://img.shields.io/github/issues-pr-closed-raw/Decentra-Network/Decentra-Network" alt="Closed_pull_requests">

<br />
  </p>
</p>

<br />
<p align="center">

  <h3 align="center">Founder : Onur Atakan ULUSOY</h3>

</p>
