# -*- coding: utf-8 -*-
"""stopping_env.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1u-Eloh-W5d89s4AwSDJmCgSQpEQ7-jJc
"""

#packages environment
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import gym
from gym import error, spaces, utils
import pandas.testing as tm
import math


#Gym environment - continuous

class StoppingEnv(gym.Env):
  def __init__(self):    
    self.spot = 90.0
    self.strike = 100.0
    self.drift = 0.02
    self.sigma = 0.20
    self.maturity = 1.0
    self.periods = 365    # 365 day

    self.S1 = 0
    self.reward = 0
    self.day_step = 0    # from day 0 taking N steps to day N

    #set range for action space - just discrete
    #set ACTION SPACE
    self.action_space = gym.spaces.Discrete(2)         # 0: hold, 1:exercise
    
    
    #set range for obs space    
    self.min=np.array([0, 0])
    self.max=np.array([np.inf, 1.0])
    
    #set OBSERVATION SPACE
    self.observation_space = gym.spaces.Box(low=self.min, high=self.max, dtype=np.float32)      # stock price in [0, inf], ttm in [0, 1]

    #set an initial state
    self.state=None 


  #take an action with the environment
  def step(self, action):
    if action == 1: # exercise the option
      reward = max(self.strike-self.S1, 0.0) * np.exp(-self.drift * self.maturity * (self.day_step/self.periods))
      done = True
    else:       # do not exercise
      if self.day_step == self.periods:    # if we are anyway at maturity
        reward = max(self.strike-self.S1, 0.0) * np.exp(-self.drift * self.maturity)
        done = True
      else: # move to tomorrow
        reward = 0
        # lnS1 - lnS0 = (drift - 0.5*sigma^2)*t + sigma * Wt
        self.S1 = self.S1 * np.exp((self.drift - 0.5 * self.sigma**2) * (self.maturity/self.periods) + self.sigma * np.sqrt(self.maturity/self.periods) * np.random.normal())
        self.day_step += 1
        done = False

    #set placeholder for infos
    info ={}  
    ttm = 1.0-self.day_step/self.periods        # time to maturity, in unit of years
    self.state = np.array([self.S1, ttm])
    return self.state, reward, done, {}

  #reset state and horizon    
  def reset(self):
    
    self.day_step = 0
    self.S1 = self.spot
    tao = 1.0-self.day_step/self.periods        # time to maturity, in unit of years
    self.state = [self.S1, ttm]
    return self.state
  
  def close(self):
        pass
