"""Lodders et al. (2009) data.

This file was automatically created using the `lodders09_to_dict.py` parser available
in the dev/lodders09 folder.

The abundance data in this file are taken from:
Lodders, Palme, and Gail (2009)
doi: 10.1007/978-3-540-88055-4_34
"""

lodders09_elements = {
    "H": [
        25900503000.0,
        [1, 2],
        [0.9999809999999999, 1.94e-05],
        [25900000000.0, 503000.0],
    ],
    "He": [2511030000.0, [3, 4], [0.000166, 0.999834], [1030000.0, 2510000000.0]],
    "Li": [55.6, [6, 7], [0.07589, 0.92411], [4.2, 51.4]],
    "Be": [0.612, [9], [1.0], [0.612]],
    "B": [18.8, [10, 11], [0.19820000000000002, 0.8018000000000001], [3.7, 15.1]],
    "C": [7189900.0, [12, 13], [0.9888899999999999, 0.01111], [7110000.0, 79900.0]],
    "N": [2127780.0, [14, 15], [0.99634, 0.00366], [2120000.0, 7780.0]],
    "O": [
        15737400.0,
        [16, 17, 18],
        [0.99763, 0.00037, 0.002],
        [15700000.0, 5900.0, 31500.0],
    ],
    "F": [804.0, [19], [1.0], [804.0]],
    "Ne": [
        3292330.0,
        [20, 21, 22],
        [0.929431, 0.002228, 0.068341],
        [3060000.0, 7330.0, 225000.0],
    ],
    "Na": [57700.0, [23], [1.0], [57700.0]],
    "Mg": [
        1026000.0,
        [24, 25, 26],
        [0.7899200000000001, 0.10003000000000001, 0.11005000000000001],
        [810000.0, 103000.0, 113000.0],
    ],
    "Al": [84600.0, [27], [1.0], [84600.0]],
    "Si": [
        999700.0,
        [28, 29, 30],
        [0.9223, 0.04683, 0.03087],
        [922000.0, 46800.0, 30900.0],
    ],
    "P": [8300.0, [31], [1.0], [8300.0]],
    "S": [
        421290.0,
        [32, 33, 34, 36],
        [0.95018, 0.0075, 0.04215, 0.00017],
        [400258.0, 3160.0, 17800.0, 72.0],
    ],
    "Cl": [5170.0, [35, 37], [0.75771, 0.24229], [3920.0, 1250.0]],
    "Ar": [
        92722.0,
        [36, 38, 40],
        [0.84595, 0.15381, 0.00024],
        [78400.0, 14300.0, 22.0],
    ],
    "K": [3759.0, [39, 40, 41], [0.93132, 0.00147, 0.06721], [3500.0, 6.0, 253.0]],
    "Ca": [
        60348.0,
        [40, 42, 43, 44, 46, 48],
        [0.96941, 0.00647, 0.00135, 0.02086, 4e-05, 0.00187],
        [58500.0, 391.0, 82.0, 1260.0, 2.0, 113.0],
    ],
    "Sc": [34.4, [45], [1.0], [34.4]],
    "Ti": [
        2470.0,
        [46, 47, 48, 49, 50],
        [0.08249000000000001, 0.07437, 0.7372, 0.05409, 0.05184999999999999],
        [204.0, 184.0, 1820.0, 134.0, 128.0],
    ],
    "V": [286.4, [50, 51], [0.002497, 0.9975029999999999], [0.7, 285.7]],
    "Cr": [
        13118.0,
        [50, 52, 53, 54],
        [0.043452000000000005, 0.8378950000000001, 0.09500600000000001, 0.023647],
        [569.0, 11000.0, 1240.0, 309.0],
    ],
    "Mn": [9220.0, [55], [1.0], [9220.0]],
    "Fe": [
        847990.0,
        [54, 56, 57, 58],
        [0.058449999999999995, 0.91754, 0.021191, 0.002819],
        [49600.0, 778000.0, 18000.0, 2390.0],
    ],
    "Co": [2350.0, [59], [1.0], [2350.0]],
    "Ni": [
        49093.0,
        [58, 60, 61, 62, 64],
        [0.680769, 0.262231, 0.011399, 0.036345, 0.009256],
        [33400.0, 12900.0, 559.0, 1780.0, 454.0],
    ],
    "Cu": [541.0, [63, 65], [0.69174, 0.30826], [374.0, 167.0]],
    "Zn": [
        1296.0,
        [64, 66, 67, 68, 70],
        [0.4863, 0.27899999999999997, 0.040999999999999995, 0.1875, 0.0062],
        [630.0, 362.0, 53.0, 243.0, 8.0],
    ],
    "Ga": [36.6, [69, 71], [0.60108, 0.39892000000000005], [22.0, 14.6]],
    "Ge": [
        114.5,
        [70, 72, 73, 74, 76],
        [0.21234000000000003, 0.27662, 0.07717, 0.35942999999999997, 0.07444],
        [24.3, 31.7, 8.8, 41.2, 8.5],
    ],
    "As": [6.1, [75], [1.0], [6.1]],
    "Se": [
        67.47999999999999,
        [74, 76, 77, 78, 80, 82],
        [0.0089, 0.09369999999999999, 0.0764, 0.2377, 0.4961, 0.0873],
        [0.6, 6.32, 5.15, 16.04, 33.48, 5.89],
    ],
    "Br": [10.71, [79, 81], [0.50686, 0.49314], [5.43, 5.28]],
    "Kr": [
        55.85,
        [78, 80, 82, 83, 84, 86],
        [0.00362, 0.02326, 0.11654999999999999, 0.11546, 0.56903, 0.17207999999999998],
        [0.2, 1.3, 6.51, 6.45, 31.78, 9.61],
    ],
    "Rb": [7.229000000000001, [85, 87], [0.70844, 0.29156], [5.121, 2.108]],
    "Sr": [
        23.229999999999997,
        [84, 86, 87, 88],
        [0.005580000000000001, 0.098678, 0.068961, 0.826781],
        [0.13, 2.3, 1.6, 19.2],
    ],
    "Y": [4.63, [89], [1.0], [4.63]],
    "Zr": [
        10.779,
        [90, 91, 92, 94, 96],
        [0.51452, 0.11223000000000001, 0.17146, 0.17379999999999998, 0.02799],
        [5.546, 1.21, 1.848, 1.873, 0.302],
    ],
    "Nb": [0.78, [93], [1.0], [0.78]],
    "Mo": [
        2.549,
        [92, 94, 95, 96, 97, 98, 100],
        [0.14525, 0.09151, 0.15838, 0.16672, 0.09599, 0.24391, 0.09824],
        [0.37, 0.233, 0.404, 0.425, 0.245, 0.622, 0.25],
    ],
    "Ru": [
        1.7810000000000001,
        [96, 98, 99, 100, 101, 102, 104],
        [0.05542, 0.01869, 0.12758, 0.12599, 0.17059999999999997, 0.31552, 0.18621],
        [0.099, 0.033, 0.227, 0.224, 0.304, 0.562, 0.332],
    ],
    "Rh": [0.37, [103], [1.0], [0.37]],
    "Pd": [
        1.3574,
        [102, 104, 105, 106, 108, 110],
        [0.0102, 0.1114, 0.22329999999999997, 0.2733, 0.2646, 0.11720000000000001],
        [0.0139, 0.1513, 0.3032, 0.371, 0.359, 0.159],
    ],
    "Ag": [0.49, [107, 109], [0.51839, 0.48161000000000004], [0.254, 0.236]],
    "Cd": [
        1.5740000000000003,
        [106, 108, 110, 111, 112, 113, 114, 116],
        [0.0125, 0.0089, 0.1249, 0.128, 0.2413, 0.1222, 0.2873, 0.07490000000000001],
        [0.02, 0.014, 0.197, 0.201, 0.38, 0.192, 0.452, 0.118],
    ],
    "In": [
        0.17800000000000002,
        [113, 115],
        [0.04288, 0.9571200000000001],
        [0.008, 0.17],
    ],
    "Sn": [
        3.605,
        [112, 114, 115, 116, 117, 118, 119, 120, 122, 124],
        [
            0.00971,
            0.00659,
            0.0033900000000000002,
            0.14536,
            0.07676,
            0.24223,
            0.08585000000000001,
            0.32593000000000005,
            0.04629,
            0.05789,
        ],
        [0.035, 0.024, 0.012, 0.524, 0.277, 0.873, 0.309, 1.175, 0.167, 0.209],
    ],
    "Sb": [0.313, [121, 123], [0.57213, 0.42787], [0.179, 0.134]],
    "Te": [
        4.691,
        [120, 122, 123, 124, 125, 126, 128, 130],
        [
            0.00096,
            0.02603,
            0.00908,
            0.04816,
            0.07139000000000001,
            0.18952000000000002,
            0.31687,
            0.33799,
        ],
        [0.005, 0.122, 0.043, 0.226, 0.335, 0.889, 1.486, 1.585],
    ],
    "I": [1.1, [127], [1.0], [1.1]],
    "Xe": [
        5.457,
        [124, 126, 128, 129, 130, 131, 132, 134, 136],
        [
            0.0012900000000000001,
            0.0011200000000000001,
            0.02234,
            0.27463,
            0.04378,
            0.21802,
            0.26355,
            0.09661,
            0.07868,
        ],
        [0.007, 0.006, 0.122, 1.499, 0.239, 1.19, 1.438, 0.527, 0.429],
    ],
    "Cs": [0.371, [133], [1.0], [0.371]],
    "Ba": [
        4.471,
        [130, 132, 134, 135, 136, 137, 138],
        [
            0.00106,
            0.00101,
            0.024169999999999997,
            0.06591999999999999,
            0.07853,
            0.11231999999999999,
            0.71699,
        ],
        [0.005, 0.005, 0.108, 0.295, 0.351, 0.502, 3.205],
    ],
    "La": [0.45740000000000003, [138, 139], [0.00091, 0.99909], [0.0004, 0.457]],
    "Ce": [
        1.1789999999999998,
        [136, 138, 140, 142],
        [0.0018599999999999999, 0.0025, 0.8845000000000001, 0.11114],
        [0.002, 0.003, 1.043, 0.131],
    ],
    "Pr": [0.172, [141], [1.0], [0.172]],
    "Nd": [
        0.8560000000000001,
        [142, 143, 144, 145, 146, 148, 150],
        [0.27044, 0.12023, 0.23729, 0.08763, 0.17129999999999998, 0.05716, 0.05596],
        [0.231, 0.103, 0.203, 0.075, 0.147, 0.049, 0.048],
    ],
    "Sm": [
        0.26699999999999996,
        [144, 147, 148, 149, 150, 152, 154],
        [0.03073, 0.14993, 0.11241, 0.13819, 0.0738, 0.26742, 0.22752],
        [0.008, 0.041, 0.03, 0.037, 0.02, 0.071, 0.06],
    ],
    "Eu": [0.0985, [151, 153], [0.4781, 0.5219], [0.0471, 0.0514]],
    "Gd": [
        0.35979999999999995,
        [152, 154, 155, 156, 157, 158, 160],
        [
            0.00203,
            0.02181,
            0.14800000000000002,
            0.20466,
            0.15652,
            0.24835000000000002,
            0.21864,
        ],
        [0.0007, 0.0078, 0.0533, 0.0736, 0.0563, 0.0894, 0.0787],
    ],
    "Tb": [0.0634, [159], [1.0], [0.0634]],
    "Dy": [
        0.40359999999999996,
        [156, 158, 160, 161, 162, 163, 164],
        [
            0.0005600000000000001,
            0.00095,
            0.02329,
            0.18889,
            0.25475000000000003,
            0.24896000000000001,
            0.2826,
        ],
        [0.0002, 0.0004, 0.0094, 0.0762, 0.1028, 0.1005, 0.1141],
    ],
    "Ho": [0.091, [165], [1.0], [0.091]],
    "Er": [
        0.26259999999999994,
        [162, 164, 166, 167, 168, 170],
        [0.0013900000000000002, 0.01601, 0.33503, 0.22869, 0.26978, 0.1491],
        [0.0004, 0.0042, 0.088, 0.06, 0.071, 0.039],
    ],
    "Tm": [0.0406, [169], [1.0], [0.0406]],
    "Yb": [
        0.25630000000000003,
        [168, 170, 171, 172, 173, 174, 176],
        [0.0012, 0.0298, 0.1409, 0.2169, 0.161, 0.32030000000000003, 0.13],
        [0.0003, 0.0076, 0.0361, 0.0556, 0.0413, 0.0821, 0.0333],
    ],
    "Lu": [
        0.038099999999999995,
        [175, 176],
        [0.9717950000000001, 0.028205],
        [0.037, 0.0011],
    ],
    "Hf": [
        0.1558,
        [174, 176, 177, 178, 179, 180],
        [
            0.0016200000000000001,
            0.05206,
            0.18606,
            0.27297,
            0.13629,
            0.35100000000000003,
        ],
        [0.0003, 0.0081, 0.029, 0.0425, 0.0212, 0.0547],
    ],
    "Ta": [0.0210026, [180, 181], [0.000123, 0.999877], [2.6e-06, 0.021]],
    "W": [
        0.1371,
        [180, 182, 183, 184, 186],
        [0.0012, 0.26499, 0.14314, 0.30641999999999997, 0.28425999999999996],
        [0.0002, 0.0363, 0.0196, 0.042, 0.039],
    ],
    "Re": [0.0581, [185, 187], [0.35662, 0.64338], [0.0207, 0.0374]],
    "Os": [
        0.6769000000000001,
        [184, 186, 187, 188, 189, 190, 192],
        [0.0002, 0.01598, 0.012709999999999999, 0.13337, 0.16261, 0.26444, 0.4107],
        [0.0001, 0.0108, 0.0086, 0.0904, 0.11, 0.179, 0.278],
    ],
    "Ir": [0.671, [191, 193], [0.37272, 0.6272800000000001], [0.25, 0.421]],
    "Pt": [
        1.2742,
        [190, 192, 194, 195, 196, 198],
        [
            0.00014000000000000001,
            0.00783,
            0.32966999999999996,
            0.33832,
            0.25242000000000003,
            0.07163,
        ],
        [0.0002, 0.01, 0.42, 0.431, 0.322, 0.091],
    ],
    "Au": [0.195, [197], [1.0], [0.195]],
    "Hg": [
        0.45799999999999996,
        [196, 198, 199, 200, 201, 202, 204],
        [
            0.0015,
            0.09970000000000001,
            0.16870000000000002,
            0.231,
            0.1318,
            0.2986,
            0.0687,
        ],
        [0.001, 0.046, 0.077, 0.106, 0.06, 0.137, 0.031],
    ],
    "Tl": [0.183, [203, 205], [0.29524, 0.7047599999999999], [0.054, 0.129]],
    "Pb": [
        3.306,
        [204, 206, 207, 208],
        [0.01997, 0.18582, 0.20562999999999998, 0.58858],
        [0.066, 0.614, 0.68, 1.946],
    ],
    "Bi": [0.1382, [209], [1.0], [0.1382]],
    "Th": [0.044, [232], [1.0], [0.044]],
    "U": [
        0.015036748009799998,
        [234, 235, 238],
        [2e-05, 0.24286000000000002, 0.75712],
        [4.9e-07, 0.0058, 0.018],
    ],
}

lodders09_isotopes = {
    "H-1": [0.9999809999999999, 25900000000.0],
    "H-2": [1.94e-05, 503000.0],
    "He-3": [0.000166, 1030000.0],
    "He-4": [0.999834, 2510000000.0],
    "Li-6": [0.07589, 4.2],
    "Li-7": [0.92411, 51.4],
    "Be-9": [1.0, 0.612],
    "B-10": [0.19820000000000002, 3.7],
    "B-11": [0.8018000000000001, 15.1],
    "C-12": [0.9888899999999999, 7110000.0],
    "C-13": [0.01111, 79900.0],
    "N-14": [0.99634, 2120000.0],
    "N-15": [0.00366, 7780.0],
    "O-16": [0.99763, 15700000.0],
    "O-17": [0.00037, 5900.0],
    "O-18": [0.002, 31500.0],
    "F-19": [1.0, 804.0],
    "Ne-20": [0.929431, 3060000.0],
    "Ne-21": [0.002228, 7330.0],
    "Ne-22": [0.068341, 225000.0],
    "Na-23": [1.0, 57700.0],
    "Mg-24": [0.7899200000000001, 810000.0],
    "Mg-25": [0.10003000000000001, 103000.0],
    "Mg-26": [0.11005000000000001, 113000.0],
    "Al-27": [1.0, 84600.0],
    "Si-28": [0.9223, 922000.0],
    "Si-29": [0.04683, 46800.0],
    "Si-30": [0.03087, 30900.0],
    "P-31": [1.0, 8300.0],
    "S-32": [0.95018, 400258.0],
    "S-33": [0.0075, 3160.0],
    "S-34": [0.04215, 17800.0],
    "S-36": [0.00017, 72.0],
    "Cl-35": [0.75771, 3920.0],
    "Cl-37": [0.24229, 1250.0],
    "Ar-36": [0.84595, 78400.0],
    "Ar-38": [0.15381, 14300.0],
    "Ar-40": [0.00024, 22.0],
    "K-39": [0.93132, 3500.0],
    "K-40": [0.00147, 6.0],
    "K-41": [0.06721, 253.0],
    "Ca-40": [0.96941, 58500.0],
    "Ca-42": [0.00647, 391.0],
    "Ca-43": [0.00135, 82.0],
    "Ca-44": [0.02086, 1260.0],
    "Ca-46": [4e-05, 2.0],
    "Ca-48": [0.00187, 113.0],
    "Sc-45": [1.0, 34.4],
    "Ti-46": [0.08249000000000001, 204.0],
    "Ti-47": [0.07437, 184.0],
    "Ti-48": [0.7372, 1820.0],
    "Ti-49": [0.05409, 134.0],
    "Ti-50": [0.05184999999999999, 128.0],
    "V-50": [0.002497, 0.7],
    "V-51": [0.9975029999999999, 285.7],
    "Cr-50": [0.043452000000000005, 569.0],
    "Cr-52": [0.8378950000000001, 11000.0],
    "Cr-53": [0.09500600000000001, 1240.0],
    "Cr-54": [0.023647, 309.0],
    "Mn-55": [1.0, 9220.0],
    "Fe-54": [0.058449999999999995, 49600.0],
    "Fe-56": [0.91754, 778000.0],
    "Fe-57": [0.021191, 18000.0],
    "Fe-58": [0.002819, 2390.0],
    "Co-59": [1.0, 2350.0],
    "Ni-58": [0.680769, 33400.0],
    "Ni-60": [0.262231, 12900.0],
    "Ni-61": [0.011399, 559.0],
    "Ni-62": [0.036345, 1780.0],
    "Ni-64": [0.009256, 454.0],
    "Cu-63": [0.69174, 374.0],
    "Cu-65": [0.30826, 167.0],
    "Zn-64": [0.4863, 630.0],
    "Zn-66": [0.27899999999999997, 362.0],
    "Zn-67": [0.040999999999999995, 53.0],
    "Zn-68": [0.1875, 243.0],
    "Zn-70": [0.0062, 8.0],
    "Ga-69": [0.60108, 22.0],
    "Ga-71": [0.39892000000000005, 14.6],
    "Ge-70": [0.21234000000000003, 24.3],
    "Ge-72": [0.27662, 31.7],
    "Ge-73": [0.07717, 8.8],
    "Ge-74": [0.35942999999999997, 41.2],
    "Ge-76": [0.07444, 8.5],
    "As-75": [1.0, 6.1],
    "Se-74": [0.0089, 0.6],
    "Se-76": [0.09369999999999999, 6.32],
    "Se-77": [0.0764, 5.15],
    "Se-78": [0.2377, 16.04],
    "Se-80": [0.4961, 33.48],
    "Se-82": [0.0873, 5.89],
    "Br-79": [0.50686, 5.43],
    "Br-81": [0.49314, 5.28],
    "Kr-78": [0.00362, 0.2],
    "Kr-80": [0.02326, 1.3],
    "Kr-82": [0.11654999999999999, 6.51],
    "Kr-83": [0.11546, 6.45],
    "Kr-84": [0.56903, 31.78],
    "Kr-86": [0.17207999999999998, 9.61],
    "Rb-85": [0.70844, 5.121],
    "Rb-87": [0.29156, 2.108],
    "Sr-84": [0.005580000000000001, 0.13],
    "Sr-86": [0.098678, 2.3],
    "Sr-87": [0.068961, 1.6],
    "Sr-88": [0.826781, 19.2],
    "Y-89": [1.0, 4.63],
    "Zr-90": [0.51452, 5.546],
    "Zr-91": [0.11223000000000001, 1.21],
    "Zr-92": [0.17146, 1.848],
    "Zr-94": [0.17379999999999998, 1.873],
    "Zr-96": [0.02799, 0.302],
    "Nb-93": [1.0, 0.78],
    "Mo-92": [0.14525, 0.37],
    "Mo-94": [0.09151, 0.233],
    "Mo-95": [0.15838, 0.404],
    "Mo-96": [0.16672, 0.425],
    "Mo-97": [0.09599, 0.245],
    "Mo-98": [0.24391, 0.622],
    "Mo-100": [0.09824, 0.25],
    "Ru-96": [0.05542, 0.099],
    "Ru-98": [0.01869, 0.033],
    "Ru-99": [0.12758, 0.227],
    "Ru-100": [0.12599, 0.224],
    "Ru-101": [0.17059999999999997, 0.304],
    "Ru-102": [0.31552, 0.562],
    "Ru-104": [0.18621, 0.332],
    "Rh-103": [1.0, 0.37],
    "Pd-102": [0.0102, 0.0139],
    "Pd-104": [0.1114, 0.1513],
    "Pd-105": [0.22329999999999997, 0.3032],
    "Pd-106": [0.2733, 0.371],
    "Pd-108": [0.2646, 0.359],
    "Pd-110": [0.11720000000000001, 0.159],
    "Ag-107": [0.51839, 0.254],
    "Ag-109": [0.48161000000000004, 0.236],
    "Cd-106": [0.0125, 0.02],
    "Cd-108": [0.0089, 0.014],
    "Cd-110": [0.1249, 0.197],
    "Cd-111": [0.128, 0.201],
    "Cd-112": [0.2413, 0.38],
    "Cd-113": [0.1222, 0.192],
    "Cd-114": [0.2873, 0.452],
    "Cd-116": [0.07490000000000001, 0.118],
    "In-113": [0.04288, 0.008],
    "In-115": [0.9571200000000001, 0.17],
    "Sn-112": [0.00971, 0.035],
    "Sn-114": [0.00659, 0.024],
    "Sn-115": [0.0033900000000000002, 0.012],
    "Sn-116": [0.14536, 0.524],
    "Sn-117": [0.07676, 0.277],
    "Sn-118": [0.24223, 0.873],
    "Sn-119": [0.08585000000000001, 0.309],
    "Sn-120": [0.32593000000000005, 1.175],
    "Sn-122": [0.04629, 0.167],
    "Sn-124": [0.05789, 0.209],
    "Sb-121": [0.57213, 0.179],
    "Sb-123": [0.42787, 0.134],
    "Te-120": [0.00096, 0.005],
    "Te-122": [0.02603, 0.122],
    "Te-123": [0.00908, 0.043],
    "Te-124": [0.04816, 0.226],
    "Te-125": [0.07139000000000001, 0.335],
    "Te-126": [0.18952000000000002, 0.889],
    "Te-128": [0.31687, 1.486],
    "Te-130": [0.33799, 1.585],
    "I-127": [1.0, 1.1],
    "Xe-124": [0.0012900000000000001, 0.007],
    "Xe-126": [0.0011200000000000001, 0.006],
    "Xe-128": [0.02234, 0.122],
    "Xe-129": [0.27463, 1.499],
    "Xe-130": [0.04378, 0.239],
    "Xe-131": [0.21802, 1.19],
    "Xe-132": [0.26355, 1.438],
    "Xe-134": [0.09661, 0.527],
    "Xe-136": [0.07868, 0.429],
    "Cs-133": [1.0, 0.371],
    "Ba-130": [0.00106, 0.005],
    "Ba-132": [0.00101, 0.005],
    "Ba-134": [0.024169999999999997, 0.108],
    "Ba-135": [0.06591999999999999, 0.295],
    "Ba-136": [0.07853, 0.351],
    "Ba-137": [0.11231999999999999, 0.502],
    "Ba-138": [0.71699, 3.205],
    "La-138": [0.00091, 0.0004],
    "La-139": [0.99909, 0.457],
    "Ce-136": [0.0018599999999999999, 0.002],
    "Ce-138": [0.0025, 0.003],
    "Ce-140": [0.8845000000000001, 1.043],
    "Ce-142": [0.11114, 0.131],
    "Pr-141": [1.0, 0.172],
    "Nd-142": [0.27044, 0.231],
    "Nd-143": [0.12023, 0.103],
    "Nd-144": [0.23729, 0.203],
    "Nd-145": [0.08763, 0.075],
    "Nd-146": [0.17129999999999998, 0.147],
    "Nd-148": [0.05716, 0.049],
    "Nd-150": [0.05596, 0.048],
    "Sm-144": [0.03073, 0.008],
    "Sm-147": [0.14993, 0.041],
    "Sm-148": [0.11241, 0.03],
    "Sm-149": [0.13819, 0.037],
    "Sm-150": [0.0738, 0.02],
    "Sm-152": [0.26742, 0.071],
    "Sm-154": [0.22752, 0.06],
    "Eu-151": [0.4781, 0.0471],
    "Eu-153": [0.5219, 0.0514],
    "Gd-152": [0.00203, 0.0007],
    "Gd-154": [0.02181, 0.0078],
    "Gd-155": [0.14800000000000002, 0.0533],
    "Gd-156": [0.20466, 0.0736],
    "Gd-157": [0.15652, 0.0563],
    "Gd-158": [0.24835000000000002, 0.0894],
    "Gd-160": [0.21864, 0.0787],
    "Tb-159": [1.0, 0.0634],
    "Dy-156": [0.0005600000000000001, 0.0002],
    "Dy-158": [0.00095, 0.0004],
    "Dy-160": [0.02329, 0.0094],
    "Dy-161": [0.18889, 0.0762],
    "Dy-162": [0.25475000000000003, 0.1028],
    "Dy-163": [0.24896000000000001, 0.1005],
    "Dy-164": [0.2826, 0.1141],
    "Ho-165": [1.0, 0.091],
    "Er-162": [0.0013900000000000002, 0.0004],
    "Er-164": [0.01601, 0.0042],
    "Er-166": [0.33503, 0.088],
    "Er-167": [0.22869, 0.06],
    "Er-168": [0.26978, 0.071],
    "Er-170": [0.1491, 0.039],
    "Tm-169": [1.0, 0.0406],
    "Yb-168": [0.0012, 0.0003],
    "Yb-170": [0.0298, 0.0076],
    "Yb-171": [0.1409, 0.0361],
    "Yb-172": [0.2169, 0.0556],
    "Yb-173": [0.161, 0.0413],
    "Yb-174": [0.32030000000000003, 0.0821],
    "Yb-176": [0.13, 0.0333],
    "Lu-175": [0.9717950000000001, 0.037],
    "Lu-176": [0.028205, 0.0011],
    "Hf-174": [0.0016200000000000001, 0.0003],
    "Hf-176": [0.05206, 0.0081],
    "Hf-177": [0.18606, 0.029],
    "Hf-178": [0.27297, 0.0425],
    "Hf-179": [0.13629, 0.0212],
    "Hf-180": [0.35100000000000003, 0.0547],
    "Ta-180": [0.000123, 2.6e-06],
    "Ta-181": [0.999877, 0.021],
    "W-180": [0.0012, 0.0002],
    "W-182": [0.26499, 0.0363],
    "W-183": [0.14314, 0.0196],
    "W-184": [0.30641999999999997, 0.042],
    "W-186": [0.28425999999999996, 0.039],
    "Re-185": [0.35662, 0.0207],
    "Re-187": [0.64338, 0.0374],
    "Os-184": [0.0002, 0.0001],
    "Os-186": [0.01598, 0.0108],
    "Os-187": [0.012709999999999999, 0.0086],
    "Os-188": [0.13337, 0.0904],
    "Os-189": [0.16261, 0.11],
    "Os-190": [0.26444, 0.179],
    "Os-192": [0.4107, 0.278],
    "Ir-191": [0.37272, 0.25],
    "Ir-193": [0.6272800000000001, 0.421],
    "Pt-190": [0.00014000000000000001, 0.0002],
    "Pt-192": [0.00783, 0.01],
    "Pt-194": [0.32966999999999996, 0.42],
    "Pt-195": [0.33832, 0.431],
    "Pt-196": [0.25242000000000003, 0.322],
    "Pt-198": [0.07163, 0.091],
    "Au-197": [1.0, 0.195],
    "Hg-196": [0.0015, 0.001],
    "Hg-198": [0.09970000000000001, 0.046],
    "Hg-199": [0.16870000000000002, 0.077],
    "Hg-200": [0.231, 0.106],
    "Hg-201": [0.1318, 0.06],
    "Hg-202": [0.2986, 0.137],
    "Hg-204": [0.0687, 0.031],
    "Tl-203": [0.29524, 0.054],
    "Tl-205": [0.7047599999999999, 0.129],
    "Pb-204": [0.01997, 0.066],
    "Pb-206": [0.18582, 0.614],
    "Pb-207": [0.20562999999999998, 0.68],
    "Pb-208": [0.58858, 1.946],
    "Bi-209": [1.0, 0.1382],
    "Th-232": [1.0, 0.044],
    "U-234": [2e-05, 4.9e-07],
    "U-235": [0.24286000000000002, 0.0058],
    "U-238": [0.75712, 0.018],
}
