#Netsparker_Vulnerability.py    
#@package   Netsparker_Rest_API
#@author    Samy Younsi (Shino Corp') <samyyounsi@hotmail.fr>
#@license   MIT License (http://www.opensource.org/licenses/mit-license.php)
#@link      https://github.com/ShinoNoNuma/Netsparker-Rest-API
#@docs      https://www.netsparkercloud.com/docs/index#/Vulnerability

import requests
import json

class Vulnerability(object):
    '''
      Gets the list of vulnerability templates.
    '''
    def list(credentials, data):
      endpoint_url = credentials["API_ROOT"] % "vulnerability/list" + "?" + "reportPolicyId=" + data["reportPolicyId"]
      response = requests.get(endpoint_url, auth=(credentials["USER_ID"], credentials["API_TOKEN"]))
      json_response = response.json()
      return json_response

    '''
      Gets the vulnerability template using given vulnerability type.
    '''    
    def template(credentials, data):
      endpoint_url = credentials["API_ROOT"] % "vulnerability/template" + "?" + "reportPolicyId=" + data["reportPolicyId"]
      response = requests.get(endpoint_url, auth=(credentials["USER_ID"], credentials["API_TOKEN"]))
      json_response = response.json()
      return json_response

    '''
      Gets the list of vulnerability types.
    '''
    def type(credentials, data):
      endpoint_url = credentials["API_ROOT"] % "vulnerability/type"
      response = requests.get(endpoint_url, auth=(credentials["USER_ID"], credentials["API_TOKEN"]))
      json_response = response.json()
      return json_response