/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Node;
import java.util.Arrays;

public abstract class AbstractScalarScoreVisitor
implements Visitor<Double> {
    public static final int DEFAULT_IGNORE_LEAF_MASS_THRESHOLD = 0;
    protected final double[] pointToScore;
    protected final int treeMass;
    protected boolean pointInsideBox;
    protected boolean[] coordInsideBox;
    protected BoundingBox shadowBox = null;
    protected double score;
    protected boolean ignoreLeafEquals;
    protected int ignoreLeafMassThreshold;

    public AbstractScalarScoreVisitor(double[] pointToScore, int treeMass, int ignoreLeafMassThreshold) {
        this.pointToScore = Arrays.copyOf(pointToScore, pointToScore.length);
        this.treeMass = treeMass;
        this.pointInsideBox = false;
        this.score = 0.0;
        this.ignoreLeafEquals = ignoreLeafMassThreshold > 0;
        this.ignoreLeafMassThreshold = ignoreLeafMassThreshold;
        this.coordInsideBox = new boolean[pointToScore.length];
    }

    public AbstractScalarScoreVisitor(double[] pointToScore, int treeMass) {
        this(pointToScore, treeMass, 0);
    }

    @Override
    public Double getResult() {
        return CommonUtils.defaultScalarNormalizerFunction(this.score, this.treeMass);
    }

    @Override
    public void accept(Node node, int depthOfNode) {
        double probabilityOfSeparation;
        if (this.pointInsideBox) {
            return;
        }
        if (!this.ignoreLeafEquals) {
            probabilityOfSeparation = this.getProbabilityOfSeparation(node.getBoundingBox());
            if (probabilityOfSeparation <= 0.0) {
                this.pointInsideBox = true;
                return;
            }
        } else {
            Node sibling = Node.isLeftOf(this.pointToScore, node) ? node.getRightChild() : node.getLeftChild();
            this.shadowBox = this.shadowBox == null ? sibling.getBoundingBox() : this.shadowBox.getMergedBox(sibling.getBoundingBox());
            probabilityOfSeparation = this.shadowBox.getRangeSum() <= 0.0 ? 1.0 : this.getProbabilityOfSeparation(this.shadowBox);
        }
        this.score = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probabilityOfSeparation) * this.score;
    }

    @Override
    public void acceptLeaf(Node leafNode, int depthOfNode) {
        if (leafNode.leafPointEquals(this.pointToScore) && (!this.ignoreLeafEquals || leafNode.getMass() > this.ignoreLeafMassThreshold)) {
            this.pointInsideBox = true;
            this.score = this.damp(leafNode.getMass(), this.treeMass) * this.scoreSeen(depthOfNode, leafNode.getMass());
        } else {
            this.score = this.scoreUnseen(depthOfNode, leafNode.getMass());
        }
    }

    protected abstract double scoreSeen(int var1, int var2);

    protected abstract double scoreUnseen(int var1, int var2);

    protected abstract double damp(int var1, int var2);

    protected double getProbabilityOfSeparation(BoundingBox boundingBox) {
        double sumOfNewRange = 0.0;
        double sumOfDifferenceInRange = 0.0;
        for (int i = 0; i < this.pointToScore.length; ++i) {
            double maxVal = boundingBox.getMaxValue(i);
            double minVal = boundingBox.getMinValue(i);
            double oldRange = maxVal - minVal;
            if (!this.coordInsideBox[i]) {
                if (maxVal < this.pointToScore[i]) {
                    maxVal = this.pointToScore[i];
                } else if (minVal > this.pointToScore[i]) {
                    minVal = this.pointToScore[i];
                } else if (!this.ignoreLeafEquals) {
                    sumOfNewRange += oldRange;
                    this.coordInsideBox[i] = true;
                    continue;
                }
                double newRange = maxVal - minVal;
                sumOfNewRange += newRange;
                sumOfDifferenceInRange += newRange - oldRange;
                continue;
            }
            sumOfNewRange += oldRange;
        }
        if (sumOfNewRange <= 0.0) {
            throw new IllegalStateException("Sum of new range of merged box in scoring function is smaller than 0 for a non-leaf node. The sum of range of new bounding box is: " + sumOfNewRange);
        }
        return sumOfDifferenceInRange / sumOfNewRange;
    }
}

