/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;

public abstract class OneSidedStDevAccumulator<R>
implements ConvergingAccumulator<R> {
    private static final double ALPHA = 0.5;
    private final int minValuesAccepted;
    private final int convergenceThreshold;
    private final boolean highIsCritical;
    private final int sign;
    protected R accumulatedValue;
    private int valuesAccepted;
    private int witnesses;
    private double sumConvergeVal;
    private double sumSqConvergeVal;

    public OneSidedStDevAccumulator(boolean highIsCritical, double precision, int minValuesAccepted, int maxValuesAccepted) {
        this.highIsCritical = highIsCritical;
        this.convergenceThreshold = precision < 1.0 / (double)maxValuesAccepted ? maxValuesAccepted : (int)(1.0 / precision);
        this.minValuesAccepted = Math.min(minValuesAccepted, maxValuesAccepted);
        this.valuesAccepted = 0;
        this.witnesses = 0;
        this.sumConvergeVal = 0.0;
        this.sumSqConvergeVal = 0.0;
        this.sign = highIsCritical ? 1 : -1;
        this.accumulatedValue = null;
    }

    @Override
    public void accept(R result) {
        this.accumulateValue(result);
        double value = this.getConvergingValue(result);
        this.sumConvergeVal += value;
        this.sumSqConvergeVal += value * value;
        ++this.valuesAccepted;
        if (this.valuesAccepted >= this.minValuesAccepted) {
            double mean = this.sumConvergeVal / (double)this.valuesAccepted;
            double stdev = this.sumSqConvergeVal / (double)this.valuesAccepted - mean * mean;
            double d = stdev = stdev < 0.0 ? 0.0 : Math.sqrt(stdev);
            if ((double)this.sign * (value - mean) > 0.5 * stdev) {
                ++this.witnesses;
            }
        }
    }

    @Override
    public int getValuesAccepted() {
        return this.valuesAccepted;
    }

    @Override
    public boolean isConverged() {
        return this.witnesses >= this.convergenceThreshold;
    }

    @Override
    public R getAccumulatedValue() {
        return this.accumulatedValue;
    }

    protected abstract double getConvergingValue(R var1);

    protected abstract void accumulateValue(R var1);
}

