"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaWebSocketIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Lambda WebSocket Integration.
 *
 * @experimental
 */
class LambdaWebSocketIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_LambdaWebSocketIntegrationProps(props);
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        const route = options.route;
        this.props.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = aws_cdk_lib_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.props.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.LambdaWebSocketIntegration = LambdaWebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaWebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.LambdaWebSocketIntegration", version: "2.0.0-alpha.8" };
//# sourceMappingURL=data:application/json;base64,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