"""Tests for pysma."""
import pytest
from aioresponses import aioresponses

MOCK_DEVICE = {
    "manufacturer": "SMA",
    "name": "SMA Device Name",
    "type": "Sunny Boy 3.6",
    "serial": "123456789",
    "sw_version": "",
}
MOCK_L10N = {"461": "SMA", "9402": "Sunny Boy 3.6"}


@pytest.fixture
def mock_aioresponse():
    """Yield a mock aioresponses."""
    with aioresponses() as m:
        yield m


# Testdata based on actual devices
# Instances of pytest.param(getAllOnlValues.json, getAllParamValues.json, number_of_sensors_expected, id=XX)
SMA_TESTDATA = [
    pytest.param(
        {
            "result": {
                "0199-xxxxx385": {
                    "6100_40263F00": {"1": [{"val": 2460}]},
                    "6100_00411E00": {"1": [{"val": 3680}]},
                    "6100_00411F00": {"1": [{"val": 0}]},
                    "6100_00412000": {"1": [{"val": 0}]},
                    "6100_00416600": {"1": [{"val": None}]},
                    "6100_00418000": {"1": [{"val": None}]},
                    "6100_40463600": {"1": [{"val": None}]},
                    "6100_40463700": {"1": [{"val": None}]},
                    "6100_40464000": {"1": [{"val": 2460}]},
                    "6100_40464100": {"1": [{"val": None}]},
                    "6100_40464200": {"1": [{"val": None}]},
                    "6100_00464800": {"1": [{"val": 24206}]},
                    "6100_00464900": {"1": [{"val": None}]},
                    "6100_00464A00": {"1": [{"val": None}]},
                    "6100_00464B00": {"1": [{"val": None}]},
                    "6100_00464C00": {"1": [{"val": None}]},
                    "6100_00464D00": {"1": [{"val": None}]},
                    "6100_00464E00": {"1": [{"val": None}]},
                    "6100_40465300": {"1": [{"val": 10204}]},
                    "6100_40465400": {"1": [{"val": None}]},
                    "6100_40465500": {"1": [{"val": None}]},
                    "6100_00465700": {"1": [{"val": 5000}]},
                    "6100_40466500": {"1": [{"val": None}]},
                    "6100_40466600": {"1": [{"val": None}]},
                    "6100_40466B00": {"1": [{"val": None}]},
                    "6100_40466C00": {"1": [{"val": None}]},
                    "6100_40466D00": {"1": [{"val": None}]},
                    "6100_40466E00": {"1": [{"val": None}]},
                    "6100_00467700": {"1": [{"val": None}]},
                    "6100_00467800": {"1": [{"val": None}]},
                    "6100_00467900": {"1": [{"val": None}]},
                    "6100_00468100": {"1": [{"val": None}]},
                    "6100_40468F00": {"1": [{"val": None}]},
                    "6100_40469900": {"1": [{"val": None}]},
                    "6100_0046C200": {"1": [{"val": 2460}]},
                    "6100_0046E500": {"1": [{"val": None}]},
                    "6100_0046E600": {"1": [{"val": None}]},
                    "6100_0046E700": {"1": [{"val": None}]},
                    "6100_0046E800": {"1": [{"val": None}]},
                    "6100_0046E900": {"1": [{"val": None}]},
                    "6100_0046EA00": {"1": [{"val": None}]},
                    "6100_0046EB00": {"1": [{"val": None}]},
                    "6100_0046EC00": {"1": [{"val": None}]},
                    "6100_0046ED00": {"1": [{"val": None}]},
                    "6100_4046EE00": {"1": [{"val": None}]},
                    "6100_4046EF00": {"1": [{"val": None}]},
                    "6100_4046F000": {"1": [{"val": None}]},
                    "6100_4046F100": {"1": [{"val": None}]},
                    "6100_004AB600": {"1": [{"val": 100}]},
                    "6100_40571F00": {"1": [{"val": None}]},
                    "6100_40652800": {
                        "1": [
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652900": {
                        "1": [
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652A00": {
                        "1": [
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652B00": {
                        "1": [
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_00652C00": {
                        "1": [
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_00653100": {"1": [{"val": None}]},
                    "6100_00653200": {"1": [{"val": None}]},
                    "6100_00664F00": {"1": [{"val": 10204}]},
                    "6100_00665900": {"1": [{"val": 1000}]},
                    "6100_40665B00": {"1": [{"val": -1000}]},
                    "6100_40665F00": {"1": [{"val": 81}]},
                    "6100_40666000": {"1": [{"val": 81}]},
                    "6100_40666100": {"1": [{"val": None}]},
                    "6100_40666200": {"1": [{"val": None}]},
                    "6100_40666700": {"1": [{"val": 2469}]},
                    "6100_40666800": {"1": [{"val": 2469}]},
                    "6100_40666900": {"1": [{"val": None}]},
                    "6100_40666A00": {"1": [{"val": None}]},
                    "6180_08214800": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_08412800": {"1": [{"val": [{"tag": 295}]}]},
                    "6180_08412900": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_08413200": {"1": [{"val": [{"tag": 308}]}]},
                    "6180_08413300": {"1": [{"val": [{"tag": 303}]}]},
                    "6180_08414900": {"1": [{"val": [{"tag": 886}]}]},
                    "6180_08414A00": {"1": [{"val": [{"tag": 887}]}]},
                    "6180_08414B00": {"1": [{"val": [{"tag": 885}]}]},
                    "6180_08414C00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_08416400": {"1": [{"val": [{"tag": 51}]}]},
                    "6180_08416500": {"1": [{"val": [{"tag": 884}]}]},
                    "6180_08436800": {"1": [{"val": [{"tag": 1440}]}]},
                    "6180_08465A00": {"1": [{"val": [{"tag": 1041}]}]},
                    "6180_0846A600": {"1": [{"val": [{"tag": 1780}]}]},
                    "6180_084A2C00": {"1": [{"val": [{"tag": 9327}]}]},
                    "6180_084A2E00": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_084A6400": {"1": [{"val": [{"tag": 303}]}]},
                    "6180_084A9600": {"1": [{"val": [{"tag": 1725}]}]},
                    "6180_084A9700": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_104A9A00": {"1": [{"val": ""}]},
                    "6180_104A9B00": {"1": [{"val": ""}]},
                    "6180_104A9C00": {"1": [{"val": ""}]},
                    "6180_104A9D00": {"1": [{"val": ""}]},
                    "6180_084AAA00": {"1": [{"val": [{"tag": 1719}]}]},
                    "6180_104AB700": {"1": [{"val": "192.168.30.178"}]},
                    "6180_104AB800": {"1": [{"val": "255.255.255.0"}]},
                    "6180_104AB900": {"1": [{"val": "192.168.30.1"}]},
                    "6180_104ABA00": {"1": [{"val": "192.168.30.1"}]},
                    "6180_084ABB00": {"1": [{"val": [{"tag": 3369}]}]},
                    "6180_084ABC00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_084B1E00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_00522700": {"1": [{"low": 0, "high": 7730, "val": None}]},
                    "6180_40522800": {"1": [{"low": 0, "high": 7730, "val": None}]},
                    "6180_00522900": {"1": [{"low": 0, "high": 10000, "val": None}]},
                    "6180_08522A00": {"1": [{"val": [{"tag": 16777213}]}]},
                    "6180_08522F00": {"1": [{"val": [{"tag": 308}]}]},
                    "6180_08652400": {
                        "1": [
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                        ]
                    },
                    "6180_08652500": {"1": [{"val": [{"tag": 303}]}]},
                    "6180_08652600": {
                        "1": [
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                        ]
                    },
                    "6180_08653A00": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_08671E00": {"1": [{"val": [{"tag": 7533}]}]},
                    "6380_40251E00": {"1": [{"val": 2570}, {"val": 0}]},
                    "6380_40451F00": {"1": [{"val": 31022}, {"val": 0}]},
                    "6380_40452100": {"1": [{"val": 8287}, {"val": 0}]},
                    "6400_00260100": {"1": [{"val": 9796572}]},
                    "6400_00262200": {"1": [{"val": 8831}]},
                    "6400_00462400": {"1": [{"val": None}]},
                    "6400_00462500": {"1": [{"val": None}]},
                    "6400_00462E00": {"1": [{"val": 39949345}]},
                    "6400_00462F00": {"1": [{"val": 37709850}]},
                    "6400_00469100": {"1": [{"val": None}]},
                    "6400_00469200": {"1": [{"val": None}]},
                    "6400_0046C300": {"1": [{"val": 9796572}]},
                    "6400_00618C00": {"1": [{"val": 1413}]},
                }
            }
        },
        {
            "result": {
                "0199-xxxxx385": {
                    "6800_08811F00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_10821E00": {"1": [{"val": "SB3.6-1AV-41 981"}]},
                    "6800_08821F00": {
                        "1": [{"validVals": [8001], "val": [{"tag": 8001}]}]
                    },
                    "6800_08822000": {
                        "1": [
                            {
                                "validVals": [9401, 9402, 9403, 9404, 9405],
                                "val": [{"tag": 9402}],
                            }
                        ]
                    },
                    "6800_08822100": {
                        "1": [
                            {
                                "validVals": [
                                    601,
                                    603,
                                    605,
                                    606,
                                    607,
                                    610,
                                    611,
                                    618,
                                    623,
                                    632,
                                    633,
                                    634,
                                    635,
                                    636,
                                    637,
                                    640,
                                    641,
                                    647,
                                    648,
                                ],
                                "val": [
                                    {"tag": 601},
                                    {"tag": 603},
                                    {"tag": 605},
                                    {"tag": 606},
                                    {"tag": 610},
                                    {"tag": 611},
                                    {"tag": 618},
                                    {"tag": 623},
                                    {"tag": 632},
                                    {"tag": 633},
                                    {"tag": 634},
                                    {"tag": 635},
                                    {"tag": 636},
                                    {"tag": 637},
                                    {"tag": 640},
                                    {"tag": 641},
                                    {"tag": 647},
                                    {"tag": 648},
                                ],
                            }
                        ]
                    },
                    "6800_00822500": {
                        "1": [{"low": 0, "high": 4294967000, "val": 16000}]
                    },
                    "6800_08822800": {
                        "1": [{"validVals": [302, 1129, 1130], "val": [{"tag": 302}]}]
                    },
                    "6800_08822B00": {
                        "1": [{"validVals": [461], "val": [{"tag": 461}]}]
                    },
                    "6800_00823400": {
                        "1": [{"low": 0, "high": 4294967294, "val": 51389444}]
                    },
                    "6800_08831900": {
                        "1": [{"validVals": [4145, 4146, 4154, 4289], "val": []}]
                    },
                    "6800_08831E00": {
                        "1": [
                            {"validVals": [295, 381, 443, 1855], "val": [{"tag": 295}]}
                        ]
                    },
                    "6800_00832A00": {"1": [{"low": 3680, "high": 3680, "val": 3680}]},
                    "6800_08834300": {
                        "1": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6800_08836E00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08836F00": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_08837800": {
                        "1": [
                            {
                                "validVals": [
                                    777,
                                    778,
                                    779,
                                    780,
                                    781,
                                    782,
                                    783,
                                    784,
                                    785,
                                    786,
                                    796,
                                    797,
                                    798,
                                    799,
                                ],
                                "val": [{"tag": 778}],
                            }
                        ]
                    },
                    "6800_08838B00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08838C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08838D00": {
                        "1": [
                            {
                                "validVals": [
                                    9499,
                                    9500,
                                    9501,
                                    9502,
                                    9503,
                                    9504,
                                    9505,
                                    9506,
                                    9507,
                                    9508,
                                    9509,
                                    9511,
                                    9512,
                                    9513,
                                    9514,
                                    9515,
                                    9516,
                                    9517,
                                    9518,
                                    9519,
                                    9520,
                                    9522,
                                    9523,
                                    9524,
                                    9525,
                                    9528,
                                    9529,
                                    9530,
                                    9531,
                                    9532,
                                    9533,
                                    9534,
                                    9535,
                                    9536,
                                    9537,
                                    9538,
                                    9539,
                                    9541,
                                    9542,
                                    9543,
                                    9544,
                                    9545,
                                    9546,
                                    9547,
                                    9549,
                                    9551,
                                    9552,
                                    9553,
                                    9554,
                                    9555,
                                    9556,
                                    9557,
                                    9558,
                                    9559,
                                    9560,
                                    9561,
                                    9562,
                                    9563,
                                    9565,
                                    9566,
                                    9567,
                                    9568,
                                    9569,
                                    9570,
                                    9571,
                                    9572,
                                    9573,
                                    9574,
                                    9575,
                                    9576,
                                    9577,
                                    9578,
                                    9579,
                                    9580,
                                    9581,
                                    9582,
                                    9583,
                                    9584,
                                    9586,
                                    9587,
                                    9588,
                                    9589,
                                    9590,
                                    9591,
                                    9592,
                                    9593,
                                    9594,
                                    9595,
                                    9596,
                                    9597,
                                    9598,
                                ],
                                "val": [{"tag": 9578}],
                            }
                        ]
                    },
                    "6800_10838F00": {"1": [{"val": "ntp.sunny-portal.com"}]},
                    "6800_08839500": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08839700": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_10841E00": {"0": [{"val": ""}]},
                    "6800_10852100": {"1": [{"val": ""}]},
                    "6800_40852200": {
                        "1": [{"low": -1, "high": 2147483647, "val": -1}]
                    },
                    "6800_00852300": {"1": [{"low": 0, "high": None, "val": None}]},
                    "6800_10852400": {
                        "1": [{"val": ""}, {"val": ""}, {"val": ""}, {"val": ""}]
                    },
                    "6800_10852500": {
                        "1": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10852600": {
                        "1": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_08852700": {
                        "1": [
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                        ]
                    },
                    "6800_08852800": {
                        "1": [
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                        ]
                    },
                    "6800_10852900": {
                        "1": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_00852A00": {"1": [{"low": 0, "high": 500000, "val": 3680}]},
                    "6800_08852C00": {
                        "1": [{"validVals": [303, 308, 4127], "val": [{"tag": 303}]}]
                    },
                    "6800_00852E00": {
                        "1": [
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                        ]
                    },
                    "6800_00852F00": {
                        "1": [
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                        ]
                    },
                    "6800_08853000": {
                        "1": [{"validVals": [302, 4155], "val": [{"tag": 302}]}]
                    },
                    "6800_08853100": {
                        "1": [
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                        ]
                    },
                    "6800_10853200": {
                        "1": [{"val": ""}, {"val": ""}, {"val": ""}, {"val": ""}]
                    },
                    "6800_10853300": {
                        "1": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_00853400": {"1": [{"low": 0, "high": 3, "val": 0}]},
                    "6800_10853600": {
                        "1": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10853700": {
                        "1": [{"val": ""}, {"val": ""}, {"val": ""}, {"val": ""}]
                    },
                    "6800_08855C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_0086A300": {"1": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_08871E00": {
                        "1": [
                            {
                                "validVals": [
                                    27,
                                    306,
                                    313,
                                    333,
                                    438,
                                    1199,
                                    7510,
                                    7513,
                                    7514,
                                    7517,
                                    7518,
                                    7523,
                                    7527,
                                    7532,
                                    7533,
                                    7536,
                                    7538,
                                    7539,
                                    7549,
                                    7550,
                                    7551,
                                    7556,
                                    7557,
                                    7565,
                                    7566,
                                    7567,
                                    7568,
                                    7569,
                                    7573,
                                    7574,
                                    16777213,
                                ],
                                "val": [{"tag": 7533}],
                            }
                        ]
                    },
                    "6800_088A2900": {
                        "1": [
                            {
                                "validVals": [302, 9327, 9375, 9376, 9437, 19043],
                                "val": [{"tag": 9327}],
                            }
                        ]
                    },
                    "6800_008A2A00": {"1": [{"low": 5, "high": 1500, "val": 100}]},
                    "6800_108A2B00": {"1": [{"val": ""}]},
                    "6800_108A3200": {"1": [{"val": ""}]},
                    "6800_088A3300": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4D00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088A5100": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_088A5200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_108A5300": {"1": [{"val": "192.168.0.173"}]},
                    "6800_108A5400": {"1": [{"val": "255.255.255.0"}]},
                    "6800_108A5500": {"1": [{"val": "192.168.0.1"}]},
                    "6800_108A5600": {"1": [{"val": "192.168.0.1"}]},
                    "6800_108A5900": {"1": [{"val": "NetworkSSID"}]},
                    "6800_108A5A00": {"1": [{"val": ""}]},
                    "6800_088A5B00": {
                        "1": [{"validVals": [3323, 3324], "val": [{"tag": 3324}]}]
                    },
                    "6800_088A7700": {
                        "1": [{"validVals": [4330, 4331, 4332], "val": [{"tag": 4330}]}]
                    },
                    "6800_088A8A00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_008AA200": {"1": [{"low": 0, "high": None, "val": 0}]},
                    "6800_008AA300": {"1": [{"low": 0, "high": None, "val": None}]},
                    "6800_108AA400": {
                        "1": [
                            {"val": "NetworkSSID"},
                            {
                                "val": "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x0"
                            },
                        ]
                    },
                    "6800_088AA500": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_088B1E00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B1F00": {"1": [{"low": 1, "high": 65535, "val": 80}]},
                    "6800_108B2000": {"1": [{"val": "255.255.255.255"}]},
                    "6800_108B2100": {"1": [{"val": ""}]},
                    "6800_108B2200": {"1": [{"val": ""}]},
                    "6800_008B2E00": {"1": [{"low": 0, "high": None, "val": 17105412}]},
                    "6800_088B5200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088B7000": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7100": {"1": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_088B7200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7300": {"1": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_008B7400": {"1": [{"low": 3, "high": 123, "val": 3}]},
                    "6800_088E7B00": {
                        "1": [
                            {
                                "validVals": [2109, 3174, 3237, 3312],
                                "val": [
                                    {"tag": 2109},
                                    {"tag": 3174},
                                    {"tag": 3237},
                                    {"tag": 3312},
                                ],
                            }
                        ]
                    },
                    "6800_00912100": {
                        "1": [{"low": 0, "high": 4294967294, "val": 16859652}]
                    },
                    "6800_00922500": {"1": [{"low": 0, "high": 3680, "val": 3680}]},
                    "6800_00922600": {"1": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_0892D600": {
                        "1": [{"validVals": [303, 2137, 2138], "val": [{"tag": 303}]}]
                    },
                    "6800_0092D700": {"1": [{"low": 0, "high": 50000, "val": 3680}]},
                    "6800_0092D800": {"1": [{"low": 0, "high": 100, "val": 100}]},
                    "6800_00A21E00": {
                        "1": [{"low": 0, "high": None, "val": 3006894981}]
                    },
                    "6800_10A22F00": {"1": [{"val": ""}]},
                    "6800_10A23000": {"1": [{"val": "A8:E2:C1:84:C5:31"}]},
                    "6800_00A63500": {"1": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_40A63A00": {
                        "1": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_40A63B00": {
                        "1": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_10AA6100": {"1": [{"val": "192.168.0.170"}]},
                    "6800_10AA6200": {"1": [{"val": "255.255.255.0"}]},
                    "6800_10AA6300": {"1": [{"val": "192.168.0.1"}]},
                    "6800_10AA6400": {"1": [{"val": "192.168.0.1"}]},
                }
            }
        },
        37,
        id="SB 3.6, no energy meter, no optimizers",
    ),
    pytest.param(
        {
            "result": {
                "017A-xxxxxB1A": {
                    "6100_40263F00": {"1": [{"val": 652}]},
                    "6100_00411E00": {"1": [{"val": 3000}]},
                    "6100_00411F00": {"1": [{"val": 0}]},
                    "6100_00412000": {"1": [{"val": 0}]},
                    "6100_00416600": {"1": [{"val": None}]},
                    "6100_00418000": {"1": [{"val": None}]},
                    "6100_40463600": {"1": [{"val": None}]},
                    "6100_40463700": {"1": [{"val": None}]},
                    "6100_40464000": {"1": [{"val": 218}]},
                    "6100_40464100": {"1": [{"val": 214}]},
                    "6100_40464200": {"1": [{"val": 220}]},
                    "6100_00464800": {"1": [{"val": 23103}]},
                    "6100_00464900": {"1": [{"val": 22281}]},
                    "6100_00464A00": {"1": [{"val": 22956}]},
                    "6100_00464B00": {"1": [{"val": 39351}]},
                    "6100_00464C00": {"1": [{"val": 39293}]},
                    "6100_00464D00": {"1": [{"val": 39715}]},
                    "6100_00464E00": {"1": [{"val": None}]},
                    "6100_40465300": {"1": [{"val": 956}]},
                    "6100_40465400": {"1": [{"val": 976}]},
                    "6100_40465500": {"1": [{"val": 977}]},
                    "6100_00465700": {"1": [{"val": 5003}]},
                    "6100_40466500": {"1": [{"val": None}]},
                    "6100_40466600": {"1": [{"val": None}]},
                    "6100_40466B00": {"1": [{"val": None}]},
                    "6100_40466C00": {"1": [{"val": None}]},
                    "6100_40466D00": {"1": [{"val": None}]},
                    "6100_40466E00": {"1": [{"val": None}]},
                    "6100_00467700": {"1": [{"val": None}]},
                    "6100_00467800": {"1": [{"val": None}]},
                    "6100_00467900": {"1": [{"val": None}]},
                    "6100_00468100": {"1": [{"val": None}]},
                    "6100_40468F00": {"1": [{"val": None}]},
                    "6100_40469900": {"1": [{"val": None}]},
                    "6100_0046C200": {"1": [{"val": 652}]},
                    "6100_0046E500": {"1": [{"val": None}]},
                    "6100_0046E600": {"1": [{"val": None}]},
                    "6100_0046E700": {"1": [{"val": None}]},
                    "6100_0046E800": {"1": [{"val": None}]},
                    "6100_0046E900": {"1": [{"val": None}]},
                    "6100_0046EA00": {"1": [{"val": None}]},
                    "6100_0046EB00": {"1": [{"val": None}]},
                    "6100_0046EC00": {"1": [{"val": None}]},
                    "6100_0046ED00": {"1": [{"val": None}]},
                    "6100_4046EE00": {"1": [{"val": None}]},
                    "6100_4046EF00": {"1": [{"val": None}]},
                    "6100_4046F000": {"1": [{"val": None}]},
                    "6100_4046F100": {"1": [{"val": None}]},
                    "6100_004AB600": {"1": [{"val": 100}]},
                    "6100_40571F00": {"1": [{"val": None}]},
                    "6100_40652800": {
                        "1": [
                            {"val": 3085},
                            {"val": 3190},
                            {"val": 3125},
                            {"val": 3190},
                            {"val": 3045},
                            {"val": 3065},
                            {"val": 2965},
                            {"val": 3160},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652900": {
                        "1": [
                            {"val": 3085},
                            {"val": 3015},
                            {"val": 3090},
                            {"val": 3095},
                            {"val": 3100},
                            {"val": 3095},
                            {"val": 3095},
                            {"val": 3035},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652A00": {
                        "1": [
                            {"val": 95},
                            {"val": 96},
                            {"val": 96},
                            {"val": 98},
                            {"val": 94},
                            {"val": 94},
                            {"val": 91},
                            {"val": 95},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_40652B00": {
                        "1": [
                            {"val": 330},
                            {"val": 321},
                            {"val": 306},
                            {"val": 298},
                            {"val": 334},
                            {"val": 313},
                            {"val": 320},
                            {"val": 323},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_00652C00": {
                        "1": [
                            {"val": 85},
                            {"val": 70},
                            {"val": 55},
                            {"val": 56},
                            {"val": 32},
                            {"val": 61},
                            {"val": 43},
                            {"val": 34},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                            {"val": None},
                        ]
                    },
                    "6100_00653100": {"1": [{"val": 0}]},
                    "6100_00653200": {"1": [{"val": 0}]},
                    "6100_00664F00": {"1": [{"val": 2909}]},
                    "6100_00665900": {"1": [{"val": 995}]},
                    "6100_40665B00": {"1": [{"val": -995}]},
                    "6100_40665F00": {"1": [{"val": 57}]},
                    "6100_40666000": {"1": [{"val": 21}]},
                    "6100_40666100": {"1": [{"val": 18}]},
                    "6100_40666200": {"1": [{"val": 18}]},
                    "6100_40666700": {"1": [{"val": 654}]},
                    "6100_40666800": {"1": [{"val": 221}]},
                    "6100_40666900": {"1": [{"val": 217}]},
                    "6100_40666A00": {"1": [{"val": 224}]},
                    "6180_08214800": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_08412800": {"1": [{"val": [{"tag": 2119}]}]},
                    "6180_08412900": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_08413200": {"1": [{"val": [{"tag": 308}]}]},
                    "6180_08413300": {"1": [{"val": [{"tag": 308}]}]},
                    "6180_08414900": {"1": [{"val": [{"tag": 886}]}]},
                    "6180_08414A00": {"1": [{"val": [{"tag": 887}]}]},
                    "6180_08414B00": {"1": [{"val": [{"tag": 885}]}]},
                    "6180_08414C00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_08416400": {"1": [{"val": [{"tag": 51}]}]},
                    "6180_08416500": {"1": [{"val": [{"tag": 884}]}]},
                    "6180_0846A600": {"1": [{"val": [{"tag": 1780}]}]},
                    "6180_084A2C00": {"1": [{"val": [{"tag": 9327}]}]},
                    "6180_084A2E00": {"1": [{"val": [{"tag": 302}]}]},
                    "6180_084A6400": {"1": [{"val": [{"tag": 303}]}]},
                    "6180_084A9600": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_084A9700": {"1": [{"val": [{"tag": 1721}]}]},
                    "6180_104A9A00": {"1": [{"val": "10.0.8.3"}]},
                    "6180_104A9B00": {"1": [{"val": "255.255.255.0"}]},
                    "6180_104A9C00": {"1": [{"val": "10.0.8.100"}]},
                    "6180_104A9D00": {"1": [{"val": "10.0.8.100"}]},
                    "6180_084AAA00": {"1": [{"val": [{"tag": 1719}]}]},
                    "6180_104AB700": {"1": [{"val": "10.0.8.4"}]},
                    "6180_104AB800": {"1": [{"val": "255.255.255.0"}]},
                    "6180_104AB900": {"1": [{"val": "10.0.8.100"}]},
                    "6180_104ABA00": {"1": [{"val": "10.0.8.100"}]},
                    "6180_084ABB00": {"1": [{"val": [{"tag": 3369}]}]},
                    "6180_084ABC00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_084B1E00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_00522700": {"1": [{"low": 0, "high": 0, "val": 3000}]},
                    "6180_40522800": {"1": [{"low": 0, "high": 0, "val": None}]},
                    "6180_00522900": {"1": [{"low": 0, "high": 0, "val": None}]},
                    "6180_08522A00": {"1": [{"val": [{"tag": 16777213}]}]},
                    "6180_08522F00": {"1": [{"val": [{"tag": 308}]}]},
                    "6180_08652400": {
                        "1": [
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                            {"val": [{"tag": 302}]},
                        ]
                    },
                    "6180_08652500": {"1": [{"val": [{"tag": 303}]}]},
                    "6180_08652600": {
                        "1": [
                            {"val": [{"tag": 307}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                            {"val": [{"tag": 303}]},
                        ]
                    },
                    "6180_08653A00": {"1": [{"val": [{"tag": 307}]}]},
                    "6180_08671E00": {"1": [{"val": [{"tag": 7533}]}]},
                    "6380_40251E00": {"1": [{"val": 691}, {"val": 0}]},
                    "6380_40451F00": {"1": [{"val": 24185}, {"val": 0}]},
                    "6380_40452100": {"1": [{"val": 2861}, {"val": 0}]},
                    "6400_00260100": {"1": [{"val": 2817372}]},
                    "6400_00262200": {"1": [{"val": 9860}]},
                    "6400_00462400": {"1": [{"val": None}]},
                    "6400_00462500": {"1": [{"val": None}]},
                    "6400_00462E00": {"1": [{"val": 17223506}]},
                    "6400_00462F00": {"1": [{"val": 15670689}]},
                    "6400_00469100": {"1": [{"val": None}]},
                    "6400_00469200": {"1": [{"val": None}]},
                    "6400_0046C300": {"1": [{"val": 2817372}]},
                    "6400_00618C00": {"1": [{"val": 2085}]},
                }
            }
        },
        {
            "result": {
                "017A-xxxxxB1A": {
                    "6800_08811F00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_10821E00": {"1": [{"val": "STP3.0-3AV-40 762"}]},
                    "6800_08821F00": {
                        "1": [{"validVals": [8001], "val": [{"tag": 8001}]}]
                    },
                    "6800_08822000": {
                        "1": [
                            {
                                "validVals": [9366, 9344, 9345, 9346],
                                "val": [{"tag": 9366}],
                            }
                        ]
                    },
                    "6800_08822100": {
                        "1": [
                            {
                                "validVals": [
                                    601,
                                    605,
                                    606,
                                    607,
                                    610,
                                    611,
                                    618,
                                    623,
                                    632,
                                    633,
                                    634,
                                    635,
                                    636,
                                    637,
                                    640,
                                    641,
                                    647,
                                    648,
                                ],
                                "val": [
                                    {"tag": 601},
                                    {"tag": 605},
                                    {"tag": 606},
                                    {"tag": 610},
                                    {"tag": 611},
                                    {"tag": 618},
                                    {"tag": 623},
                                    {"tag": 632},
                                    {"tag": 633},
                                    {"tag": 634},
                                    {"tag": 635},
                                    {"tag": 636},
                                    {"tag": 637},
                                    {"tag": 640},
                                    {"tag": 641},
                                    {"tag": 647},
                                    {"tag": 648},
                                ],
                            }
                        ]
                    },
                    "6800_00822500": {"1": [{"low": 0, "high": 4500, "val": 4300}]},
                    "6800_08822800": {
                        "1": [{"validVals": [302, 1129, 1130], "val": [{"tag": 302}]}]
                    },
                    "6800_08822B00": {
                        "1": [{"validVals": [461], "val": [{"tag": 461}]}]
                    },
                    "6800_00823400": {
                        "1": [{"low": 0, "high": 4294967294, "val": 51384324}]
                    },
                    "6800_08831900": {
                        "1": [{"validVals": [4145, 4146, 4154, 4289], "val": []}]
                    },
                    "6800_08831E00": {
                        "1": [{"validVals": [295, 381, 443], "val": [{"tag": 295}]}]
                    },
                    "6800_00832A00": {"1": [{"low": 3000, "high": 3000, "val": 3000}]},
                    "6800_08834300": {
                        "1": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6800_08836E00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08836F00": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_08837800": {
                        "1": [
                            {
                                "validVals": [
                                    777,
                                    778,
                                    779,
                                    780,
                                    781,
                                    782,
                                    783,
                                    784,
                                    785,
                                    786,
                                    796,
                                    797,
                                    798,
                                    799,
                                ],
                                "val": [{"tag": 778}],
                            }
                        ]
                    },
                    "6800_08838B00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08838C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08838D00": {
                        "1": [
                            {
                                "validVals": [
                                    9499,
                                    9500,
                                    9501,
                                    9502,
                                    9503,
                                    9504,
                                    9505,
                                    9506,
                                    9507,
                                    9508,
                                    9509,
                                    9511,
                                    9512,
                                    9513,
                                    9514,
                                    9515,
                                    9516,
                                    9517,
                                    9518,
                                    9519,
                                    9520,
                                    9522,
                                    9523,
                                    9524,
                                    9525,
                                    9528,
                                    9529,
                                    9530,
                                    9531,
                                    9532,
                                    9533,
                                    9534,
                                    9535,
                                    9536,
                                    9537,
                                    9538,
                                    9539,
                                    9541,
                                    9542,
                                    9543,
                                    9544,
                                    9545,
                                    9546,
                                    9547,
                                    9549,
                                    9551,
                                    9552,
                                    9553,
                                    9554,
                                    9555,
                                    9556,
                                    9557,
                                    9558,
                                    9559,
                                    9560,
                                    9561,
                                    9562,
                                    9563,
                                    9565,
                                    9566,
                                    9567,
                                    9568,
                                    9569,
                                    9570,
                                    9571,
                                    9572,
                                    9573,
                                    9574,
                                    9575,
                                    9576,
                                    9577,
                                    9578,
                                    9579,
                                    9580,
                                    9581,
                                    9582,
                                    9583,
                                    9584,
                                    9586,
                                    9587,
                                    9588,
                                    9589,
                                    9590,
                                    9591,
                                    9592,
                                    9593,
                                    9594,
                                    9595,
                                    9596,
                                    9597,
                                    9598,
                                ],
                                "val": [{"tag": 9578}],
                            }
                        ]
                    },
                    "6800_10838F00": {"1": [{"val": "10.0.8.1"}]},
                    "6800_08839500": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08839700": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_10841E00": {"0": [{"val": ""}]},
                    "6800_10852100": {"1": [{"val": "XXXXXXXXXXXX"}]},
                    "6800_40852200": {
                        "1": [{"low": -1, "high": 2147483647, "val": 45037}]
                    },
                    "6800_00852300": {"1": [{"low": 0, "high": None, "val": 34085636}]},
                    "6800_10852400": {
                        "1": [
                            {"val": "04C05B300000XXXX"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10852500": {
                        "1": [
                            {"val": "AA1"},
                            {"val": "AA2"},
                            {"val": "AA3"},
                            {"val": "AA4"},
                            {"val": "AA5"},
                            {"val": "AA6"},
                            {"val": "AA7"},
                            {"val": "AA8"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10852600": {
                        "1": [
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": "04C05B4000XXXXXX"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_08852700": {
                        "1": [
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 4070}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                            {"validVals": [302, 4070, 4071], "val": [{"tag": 302}]},
                        ]
                    },
                    "6800_08852800": {
                        "1": [
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 9370}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                            {
                                "validVals": [
                                    302,
                                    9368,
                                    9369,
                                    9370,
                                    9371,
                                    9372,
                                    9373,
                                    9374,
                                ],
                                "val": [{"tag": 302}],
                            },
                        ]
                    },
                    "6800_10852900": {
                        "1": [
                            {"val": "AA"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_00852A00": {"1": [{"low": 0, "high": 500000, "val": 2720}]},
                    "6800_00852E00": {
                        "1": [
                            {"low": 0, "high": 60, "val": 8},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                        ]
                    },
                    "6800_00852F00": {
                        "1": [
                            {"low": 0, "high": 60, "val": 8},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                            {"low": 0, "high": 60, "val": 0},
                        ]
                    },
                    "6800_08853000": {
                        "1": [{"validVals": [302, 4155], "val": [{"tag": 4155}]}]
                    },
                    "6800_08853100": {
                        "1": [
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 9394}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                            {"validVals": [302, 9394, 9395], "val": [{"tag": 302}]},
                        ]
                    },
                    "6800_10853200": {
                        "1": [
                            {"val": "G5.27 Jul 26 2017 17:51:45"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10853300": {
                        "1": [
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": "K6.3112"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_00853400": {"1": [{"low": 0, "high": 3, "val": 1}]},
                    "6800_10853600": {
                        "1": [
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": "!ESO075V475W-H451.9.40S0.12"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_10853700": {
                        "1": [
                            {"val": "GW-H158.4.3S0.12"},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6800_08855C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_0086A300": {"1": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_08871E00": {
                        "1": [
                            {
                                "validVals": [
                                    27,
                                    306,
                                    313,
                                    333,
                                    438,
                                    1199,
                                    7510,
                                    7513,
                                    7514,
                                    7517,
                                    7518,
                                    7523,
                                    7527,
                                    7532,
                                    7533,
                                    7536,
                                    7538,
                                    7539,
                                    7549,
                                    7569,
                                    7573,
                                    7574,
                                    16777213,
                                ],
                                "val": [{"tag": 7533}],
                            }
                        ]
                    },
                    "6800_088A2900": {
                        "1": [
                            {
                                "validVals": [302, 9327, 9375, 9376, 9437, 19043],
                                "val": [{"tag": 9327}],
                            }
                        ]
                    },
                    "6800_008A2A00": {"1": [{"low": 5, "high": 1500, "val": 100}]},
                    "6800_108A2B00": {"1": [{"val": ""}]},
                    "6800_108A3200": {"1": [{"val": ""}]},
                    "6800_088A3300": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4C00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4D00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088A5100": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_088A5200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_108A5300": {"1": [{"val": "192.168.0.173"}]},
                    "6800_108A5400": {"1": [{"val": "255.255.255.0"}]},
                    "6800_108A5500": {"1": [{"val": "192.168.0.1"}]},
                    "6800_108A5600": {"1": [{"val": "192.168.0.1"}]},
                    "6800_108A5900": {"1": [{"val": "wifinetwork"}]},
                    "6800_108A5A00": {"1": [{"val": ""}]},
                    "6800_088A5B00": {
                        "1": [{"validVals": [3323, 3324], "val": [{"tag": 3324}]}]
                    },
                    "6800_088A7700": {
                        "1": [{"validVals": [4330, 4331, 4332], "val": [{"tag": 4330}]}]
                    },
                    "6800_088A8A00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_008AA200": {"1": [{"low": 0, "high": None, "val": 0}]},
                    "6800_008AA300": {"1": [{"low": 0, "high": None, "val": None}]},
                    "6800_108AA400": {
                        "1": [
                            {"val": "wifinetwork"},
                            {"val": "Ziggo-ap-3685756"},
                            {"val": "H368NAFB1C3"},
                            {"val": "Tuoro"},
                            {"val": "Recover.Me-008480"},
                            {"val": "KPN627B06"},
                            {"val": "KPN"},
                            {"val": "Ziggo"},
                            {"val": "wifinetwork2"},
                            {"val": "Maurice"},
                        ]
                    },
                    "6800_088AA500": {"1": [{"validVals": [1146], "val": []}]},
                    "6800_088B1E00": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B1F00": {"1": [{"low": 1, "high": 65535, "val": 80}]},
                    "6800_108B2000": {"1": [{"val": "255.255.255.255"}]},
                    "6800_108B2100": {"1": [{"val": ""}]},
                    "6800_108B2200": {"1": [{"val": ""}]},
                    "6800_008B2E00": {"1": [{"low": 0, "high": None, "val": 17105412}]},
                    "6800_088B5200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088B7000": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7100": {"1": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_088B7200": {
                        "1": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7300": {"1": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_008B7400": {"1": [{"low": 3, "high": 123, "val": 3}]},
                    "6800_088E7B00": {
                        "1": [
                            {
                                "validVals": [2109, 3174, 3237, 3312],
                                "val": [
                                    {"tag": 2109},
                                    {"tag": 3174},
                                    {"tag": 3237},
                                    {"tag": 3312},
                                ],
                            }
                        ]
                    },
                    "6800_00912100": {
                        "1": [{"low": 0, "high": 4294967294, "val": 33695748}]
                    },
                    "6800_00922500": {"1": [{"low": 0, "high": 3050, "val": 3000}]},
                    "6800_00922600": {"1": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_0892D600": {
                        "1": [{"validVals": [303, 2137, 2138], "val": [{"tag": 303}]}]
                    },
                    "6800_0092D700": {"1": [{"low": 0, "high": 500000, "val": 3000}]},
                    "6800_0092D800": {"1": [{"low": 0, "high": 100, "val": 100}]},
                    "6800_00A21E00": {
                        "1": [{"low": 0, "high": None, "val": 1001234567}]
                    },
                    "6800_10A22F00": {"1": [{"val": "AA:BB:CC:DD:EE:FF"}]},
                    "6800_10A23000": {"1": [{"val": "AA:BB:CC:DD:EE:FF"}]},
                    "6800_00A63500": {"1": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_40A63A00": {
                        "1": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_40A63B00": {
                        "1": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_10AA6100": {"1": [{"val": "192.168.0.170"}]},
                    "6800_10AA6200": {"1": [{"val": "255.255.255.0"}]},
                    "6800_10AA6300": {"1": [{"val": "192.168.0.1"}]},
                    "6800_10AA6400": {"1": [{"val": "192.168.0.1"}]},
                }
            }
        },
        68,
        id="STP 3.0, no energy meter, with 8 optimizers",
    ),
    pytest.param(
        {
            "result": {
                "01B8-xxxxxB10": {
                    "6100_40263F00": {"9": [{"val": 3490}]},
                    "6100_40265F00": {"9": [{"val": 0}]},
                    "6100_00295A00": {"9": [{"val": 0}]},
                    "6100_00411E00": {"9": [{"val": 10000}]},
                    "6100_00411F00": {"9": [{"val": 0}]},
                    "6100_00412000": {"9": [{"val": 0}]},
                    "6100_00416600": {"9": [{"val": None}]},
                    "6100_00418000": {"9": [{"val": 0}]},
                    "6100_40463600": {"9": [{"val": None}]},
                    "6100_40463700": {"9": [{"val": None}]},
                    "6100_40464000": {"9": [{"val": 1156}]},
                    "6100_40464100": {"9": [{"val": 1166}]},
                    "6100_40464200": {"9": [{"val": 1160}]},
                    "6100_00464800": {"9": [{"val": 24360}]},
                    "6100_00464900": {"9": [{"val": 24480}]},
                    "6100_00464A00": {"9": [{"val": 24360}]},
                    "6100_00464B00": {"9": [{"val": 42190}]},
                    "6100_00464C00": {"9": [{"val": 42390}]},
                    "6100_00464D00": {"9": [{"val": 42190}]},
                    "6100_00464E00": {"9": [{"val": None}]},
                    "6100_40465300": {"9": [{"val": 4700}]},
                    "6100_40465400": {"9": [{"val": 4700}]},
                    "6100_40465500": {"9": [{"val": 4700}]},
                    "6100_00465700": {"9": [{"val": 4997}]},
                    "6100_40466500": {"9": [{"val": None}]},
                    "6100_40466600": {"9": [{"val": None}]},
                    "6100_40466B00": {"9": [{"val": None}]},
                    "6100_40466C00": {"9": [{"val": None}]},
                    "6100_40466D00": {"9": [{"val": None}]},
                    "6100_40466E00": {"9": [{"val": None}]},
                    "6100_00467700": {"9": []},
                    "6100_00467800": {"9": []},
                    "6100_00467900": {"9": []},
                    "6100_00468100": {"9": [{"val": None}]},
                    "6100_40468F00": {"9": [{"val": None}]},
                    "6100_40469900": {"9": [{"val": None}]},
                    "6100_0046C200": {"9": [{"val": 3490}]},
                    "6100_0046E500": {"9": [{"val": None}]},
                    "6100_0046E600": {"9": [{"val": None}]},
                    "6100_0046E700": {"9": [{"val": None}]},
                    "6100_0046E800": {"9": [{"val": None}]},
                    "6100_0046E900": {"9": [{"val": None}]},
                    "6100_0046EA00": {"9": [{"val": None}]},
                    "6100_0046EB00": {"9": [{"val": None}]},
                    "6100_0046EC00": {"9": [{"val": None}]},
                    "6100_0046ED00": {"9": [{"val": None}]},
                    "6100_4046EE00": {"9": [{"val": None}]},
                    "6100_4046EF00": {"9": [{"val": None}]},
                    "6100_4046F000": {"9": [{"val": None}]},
                    "6100_4046F100": {"9": [{"val": None}]},
                    "6100_40495B00": {"9": [{"val": 0}]},
                    "6100_00495C00": {"9": [{"val": 0}]},
                    "6100_40495D00": {"9": [{"val": 0}]},
                    "6100_00496900": {"9": [{"val": 0}]},
                    "6100_00496A00": {"9": [{"val": 0}]},
                    "6100_004AB600": {"9": [{"val": 0}]},
                    "6100_40574600": {"9": [{"val": 0}]},
                    "6100_40574700": {"9": [{"val": 0}]},
                    "6100_40574800": {"9": [{"val": 0}]},
                    "6100_00664F00": {"9": [{"val": 14100}]},
                    "6100_00665900": {"9": [{"val": 0}]},
                    "6100_40665B00": {"9": [{"val": -999}]},
                    "6100_40666000": {"9": [{"val": -1}]},
                    "6100_40666100": {"9": [{"val": -1}]},
                    "6100_40666200": {"9": [{"val": -1}]},
                    "6100_40666700": {"9": [{"val": 3490}]},
                    "6100_40666800": {"9": [{"val": 1161}]},
                    "6100_40666900": {"9": [{"val": 1161}]},
                    "6100_40666A00": {"9": [{"val": 1161}]},
                    "6100_00696E00": {"9": [{"val": 0}]},
                    "6180_08214800": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08412800": {"9": [{"val": [{"tag": 569}]}]},
                    "6180_08412900": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_08412B00": {"9": [{"val": [{"tag": 235}]}]},
                    "6180_08414900": {"9": [{"val": [{"tag": 886}]}]},
                    "6180_08414A00": {"9": [{"val": [{"tag": 887}]}]},
                    "6180_08414B00": {"9": [{"val": [{"tag": 885}]}]},
                    "6180_08414C00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08414D00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08414E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08416400": {"9": [{"val": [{"tag": 51}]}]},
                    "6180_08416900": {"9": [{"val": [{"tag": 16777213}]}]},
                    "6180_0846A600": {"9": [{"val": [{"tag": 1780}]}]},
                    "6180_08495E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_084A2C00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A2E00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A6400": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9600": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9700": {"9": [{"val": [{"tag": 1721}]}]},
                    "6180_084A9800": {"9": [{"val": [{"tag": 1725}]}]},
                    "6180_084A9900": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_104A9A00": {"9": [{"val": "10.10.0.169"}]},
                    "6180_104A9B00": {"9": [{"val": "255.255.252.0"}]},
                    "6180_104A9C00": {"9": [{"val": "10.10.0.1"}]},
                    "6180_104A9D00": {"9": [{"val": "10.10.0.1"}]},
                    "6180_084AAA00": {"9": [{"val": [{"tag": 1719}]}]},
                    "6180_104AB700": {"9": [{"val": ""}]},
                    "6180_104AB800": {"9": [{"val": ""}]},
                    "6180_104AB900": {"9": [{"val": ""}]},
                    "6180_104ABA00": {"9": [{"val": ""}]},
                    "6180_084ABB00": {"9": [{"val": [{"tag": 3369}]}]},
                    "6180_084ABC00": {"9": [{"val": [{"tag": 1725}]}]},
                    "6180_084ABD00": {"9": [{"val": [{"tag": 3326}]}]},
                    "6180_084B1E00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08521E00": {"9": [{"val": [{"tag": 2246}]}]},
                    "6180_08671E00": {"9": [{"val": []}]},
                    "6380_40251E00": {"1": [{"val": 854}, {"val": 2733}]},
                    "6380_40451F00": {"1": [{"val": 35350}, {"val": 43700}]},
                    "6380_40452100": {"1": [{"val": 2415}, {"val": 6254}]},
                    "6400_00260100": {"9": [{"val": 158956}]},
                    "6400_00262200": {"9": [{"val": 51398}]},
                    "6400_00462400": {"9": [{"val": None}]},
                    "6400_00462500": {"9": [{"val": None}]},
                    "6400_00462E00": {"9": [{"val": 0}]},
                    "6400_00469100": {"9": [{"val": None}]},
                    "6400_00469200": {"9": [{"val": None}]},
                    "6400_0046C300": {"9": [{"val": 159054}]},
                    "6400_00496700": {"9": [{"val": 0}]},
                    "6400_00496800": {"9": [{"val": 100}]},
                    "6400_00496D00": {"9": [{"val": None}]},
                    "6400_00618C00": {"9": [{"val": 30}]},
                }
            }
        },
        {
            "result": {
                "01B8-xxxxxB10": {
                    "6800_000E7C00": {"232": []},
                    "6800_08811F00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_10821E00": {"9": [{"val": "SN: 3012301234"}]},
                    "6800_08821F00": {
                        "9": [{"validVals": [8009], "val": [{"tag": 8009}]}]
                    },
                    "6800_08822000": {
                        "9": [
                            {
                                "validVals": [19048, 19049, 19050, 19051],
                                "val": [{"tag": 19051}],
                            }
                        ]
                    },
                    "6800_08822100": {
                        "9": [
                            {
                                "validVals": [
                                    601,
                                    605,
                                    606,
                                    607,
                                    609,
                                    610,
                                    611,
                                    618,
                                    623,
                                    632,
                                    633,
                                    634,
                                    635,
                                    636,
                                    637,
                                    639,
                                    640,
                                    641,
                                    642,
                                    647,
                                    648,
                                ],
                                "val": [
                                    {"tag": 601},
                                    {"tag": 605},
                                    {"tag": 606},
                                    {"tag": 609},
                                    {"tag": 610},
                                    {"tag": 611},
                                    {"tag": 618},
                                    {"tag": 623},
                                    {"tag": 632},
                                    {"tag": 633},
                                    {"tag": 634},
                                    {"tag": 635},
                                    {"tag": 636},
                                    {"tag": 637},
                                    {"tag": 639},
                                    {"tag": 640},
                                    {"tag": 641},
                                    {"tag": 642},
                                    {"tag": 647},
                                    {"tag": 648},
                                ],
                            }
                        ]
                    },
                    "6800_00822500": {
                        "9": [{"low": 0, "high": 4294967000, "val": 43500}]
                    },
                    "6800_08822800": {
                        "9": [{"validVals": [302, 1129, 1130], "val": [{"tag": 302}]}]
                    },
                    "6800_08822B00": {
                        "9": [{"validVals": [461], "val": [{"tag": 461}]}]
                    },
                    "6800_00823400": {
                        "9": [{"low": 0, "high": 4294967294, "val": 50332164}]
                    },
                    "6800_08831E00": {
                        "9": [{"validVals": [381, 1467], "val": [{"tag": 1467}]}]
                    },
                    "6800_00832A00": {
                        "9": [{"low": 10000, "high": 10000, "val": 10000}]
                    },
                    "6800_40833700": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6800_08836E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08836F00": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_08837800": {
                        "9": [
                            {
                                "validVals": [
                                    777,
                                    778,
                                    779,
                                    780,
                                    781,
                                    782,
                                    783,
                                    784,
                                    785,
                                    786,
                                    796,
                                    797,
                                    798,
                                    799,
                                ],
                                "val": [{"tag": 778}],
                            }
                        ]
                    },
                    "6800_08838B00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08838C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08838D00": {
                        "9": [
                            {
                                "validVals": [
                                    9499,
                                    9500,
                                    9501,
                                    9502,
                                    9503,
                                    9504,
                                    9505,
                                    9506,
                                    9507,
                                    9508,
                                    9509,
                                    9511,
                                    9512,
                                    9513,
                                    9514,
                                    9515,
                                    9516,
                                    9517,
                                    9518,
                                    9519,
                                    9520,
                                    9522,
                                    9523,
                                    9524,
                                    9525,
                                    9528,
                                    9529,
                                    9530,
                                    9531,
                                    9532,
                                    9533,
                                    9534,
                                    9535,
                                    9536,
                                    9537,
                                    9538,
                                    9539,
                                    9541,
                                    9542,
                                    9543,
                                    9544,
                                    9545,
                                    9546,
                                    9547,
                                    9549,
                                    9551,
                                    9552,
                                    9553,
                                    9554,
                                    9555,
                                    9556,
                                    9557,
                                    9558,
                                    9559,
                                    9560,
                                    9561,
                                    9562,
                                    9563,
                                    9565,
                                    9566,
                                    9567,
                                    9568,
                                    9569,
                                    9570,
                                    9571,
                                    9572,
                                    9573,
                                    9574,
                                    9575,
                                    9576,
                                    9577,
                                    9578,
                                    9579,
                                    9580,
                                    9581,
                                    9582,
                                    9583,
                                    9584,
                                    9586,
                                    9587,
                                    9588,
                                    9589,
                                    9590,
                                    9591,
                                    9592,
                                    9593,
                                    9594,
                                    9595,
                                    9596,
                                    9597,
                                    9598,
                                ],
                                "val": [{"tag": 9560}],
                            }
                        ]
                    },
                    "6800_10838F00": {"9": [{"val": "ntp.sunny-portal.com"}]},
                    "6800_08839500": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08839700": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_0883AA00": {
                        "9": [
                            {
                                "validVals": [303, 1341, 1342, 5304],
                                "val": [{"tag": 303}],
                            }
                        ]
                    },
                    "6800_0883AE00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_10841E00": {"0": [{"val": ""}]},
                    "6800_00852A00": {"9": [{"low": 0, "high": 50000, "val": 10000}]},
                    "6800_08855C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_0086A300": {"9": [{"low": 0, "high": 0, "val": 0}]},
                    "6800_08871E00": {
                        "9": [
                            {
                                "validVals": [
                                    27,
                                    438,
                                    7584,
                                    7590,
                                    7592,
                                    7602,
                                    7603,
                                    7615,
                                    16777213,
                                ],
                                "val": [{"tag": 7602}],
                            }
                        ]
                    },
                    "6800_00893700": {"9": [{"low": 0, "high": None, "val": 0}]},
                    "6800_08893B00": {
                        "9": [{"validVals": [1785], "val": [{"tag": 1785}]}]
                    },
                    "6800_08895A00": {
                        "9": [{"validVals": [5277, 5278], "val": [{"tag": 5277}]}]
                    },
                    "6800_088A2900": {
                        "9": [
                            {
                                "validVals": [302, 9327, 9375, 9376, 9437, 19043],
                                "val": [{"tag": 9327}],
                            }
                        ]
                    },
                    "6800_008A2A00": {"9": [{"low": 5, "high": 1500, "val": 100}]},
                    "6800_108A2B00": {"9": [{"val": ""}]},
                    "6800_108A3200": {"9": [{"val": ""}]},
                    "6800_088A3300": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4D00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A5100": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088A5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_108A5300": {"9": [{"val": "192.168.0.173"}]},
                    "6800_108A5400": {"9": [{"val": "255.255.255.0"}]},
                    "6800_108A5500": {"9": [{"val": "192.168.0.1"}]},
                    "6800_108A5600": {"9": [{"val": "192.168.0.1"}]},
                    "6800_088A5800": {
                        "9": [{"validVals": [1438, 3326, 3327], "val": [{"tag": 1438}]}]
                    },
                    "6800_108A5900": {"9": [{"val": ""}]},
                    "6800_108A5A00": {"9": [{"val": ""}]},
                    "6800_088A5B00": {
                        "9": [{"validVals": [3323, 3324], "val": [{"tag": 3324}]}]
                    },
                    "6800_088A7700": {
                        "9": [{"validVals": [4330, 4331, 4332], "val": [{"tag": 4330}]}]
                    },
                    "6800_088A8A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_008AA200": {
                        "9": [{"low": 0, "high": None, "val": 1901444353}]
                    },
                    "6800_008AA300": {"9": [{"low": 0, "high": None, "val": None}]},
                    "6800_108AA400": {
                        "9": [
                            {"val": "WIFINET"},
                            {"val": "Another WIFI"},
                            {"val": ""},
                        ]
                    },
                    "6800_088AA500": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088B1E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B1F00": {"9": [{"low": 1, "high": 65535, "val": 80}]},
                    "6800_108B2000": {"9": [{"val": "255.255.255.255"}]},
                    "6800_108B2100": {"9": [{"val": ""}]},
                    "6800_108B2200": {"9": [{"val": ""}]},
                    "6800_008B2E00": {"9": [{"low": 0, "high": None, "val": 17105924}]},
                    "6800_088B5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088B7000": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7100": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_088B7200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7300": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_008B7400": {"9": [{"low": 3, "high": 123, "val": 3}]},
                    "6800_088C2200": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_088E7B00": {
                        "9": [
                            {
                                "validVals": [2109, 3174, 3237, 3312, 4994, 5143],
                                "val": [
                                    {"tag": 2109},
                                    {"tag": 3174},
                                    {"tag": 3237},
                                    {"tag": 3312},
                                    {"tag": 4994},
                                ],
                            }
                        ]
                    },
                    "6800_00912100": {"9": [{"low": 0, "high": None, "val": 16782853}]},
                    "6800_00922500": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_00922600": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_0892AE00": {
                        "9": [{"validVals": [303, 582], "val": [{"tag": 303}]}]
                    },
                    "6800_0892D600": {
                        "9": [{"validVals": [303, 2137, 2138], "val": [{"tag": 303}]}]
                    },
                    "6800_0092D700": {"9": [{"low": 0, "high": 500000, "val": 10000}]},
                    "6800_0092D800": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6800_00A21E00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 3012401936}]
                    },
                    "6800_10A22F00": {"9": [{"val": "00:15:BB:04:1D:6A"}]},
                    "6800_10A23000": {"9": [{"val": "70:74:14:9A:91:36"}]},
                    "6800_08A33A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_40A63A00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_40A63B00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_10AA6100": {"9": [{"val": "192.168.0.170"}]},
                    "6800_10AA6200": {"9": [{"val": "255.255.255.0"}]},
                    "6800_10AA6300": {"9": [{"val": "192.168.0.1"}]},
                    "6800_10AA6400": {"9": [{"val": "192.168.0.1"}]},
                }
            }
        },
        47,
        id="STP 10.0 SE, no energy meter, no optimizers",
    ),
    pytest.param(
        {
            "result": {
                "01B8-xxxxxBA3": {
                    "6100_40263F00": {"9": [{"val": 320}]},
                    "6100_40265F00": {"9": [{"val": 0}]},
                    "6100_00295A00": {"9": [{"val": 18}]},
                    "6100_00411E00": {"9": [{"val": 6000}]},
                    "6100_00411F00": {"9": [{"val": 0}]},
                    "6100_00412000": {"9": [{"val": 0}]},
                    "6100_00416600": {"9": [{"val": None}]},
                    "6100_00418000": {"9": [{"val": 0}]},
                    "6100_40463600": {"9": [{"val": 44}]},
                    "6100_40463700": {"9": [{"val": 0}]},
                    "6100_40464000": {"9": [{"val": 151}]},
                    "6100_40464100": {"9": [{"val": 152}]},
                    "6100_40464200": {"9": [{"val": 151}]},
                    "6100_00464800": {"9": [{"val": 23410}]},
                    "6100_00464900": {"9": [{"val": 23360}]},
                    "6100_00464A00": {"9": [{"val": 23430}]},
                    "6100_00464B00": {"9": [{"val": 40540}]},
                    "6100_00464C00": {"9": [{"val": 40450}]},
                    "6100_00464D00": {"9": [{"val": 40580}]},
                    "6100_00464E00": {"9": [{"val": 27}]},
                    "6100_40465300": {"9": [{"val": 600}]},
                    "6100_40465400": {"9": [{"val": 600}]},
                    "6100_40465500": {"9": [{"val": 600}]},
                    "6100_00465700": {"9": [{"val": 5000}]},
                    "6100_40466500": {"9": [{"val": 928}]},
                    "6100_40466600": {"9": [{"val": 575}]},
                    "6100_40466B00": {"9": [{"val": 609}]},
                    "6100_40466C00": {"9": [{"val": 162}]},
                    "6100_40466D00": {"9": [{"val": 125}]},
                    "6100_40466E00": {"9": [{"val": 36}]},
                    "6100_00467700": {"9": []},
                    "6100_00467800": {"9": []},
                    "6100_00467900": {"9": []},
                    "6100_00468100": {"9": [{"val": 5001}]},
                    "6100_40468F00": {"9": [{"val": 164}]},
                    "6100_40469900": {"9": [{"val": None}]},
                    "6100_0046C200": {"9": [{"val": 2368}]},
                    "6100_0046E500": {"9": [{"val": 23371}]},
                    "6100_0046E600": {"9": [{"val": 23315}]},
                    "6100_0046E700": {"9": [{"val": 23292}]},
                    "6100_0046E800": {"9": [{"val": 0}]},
                    "6100_0046E900": {"9": [{"val": 113}]},
                    "6100_0046EA00": {"9": [{"val": 26}]},
                    "6100_0046EB00": {"9": [{"val": 96}]},
                    "6100_0046EC00": {"9": [{"val": 0}]},
                    "6100_0046ED00": {"9": [{"val": 0}]},
                    "6100_4046EE00": {"9": [{"val": 130}]},
                    "6100_4046EF00": {"9": [{"val": 52}]},
                    "6100_4046F000": {"9": [{"val": 24}]},
                    "6100_4046F100": {"9": [{"val": 158}]},
                    "6100_40495B00": {"9": [{"val": 170}]},
                    "6100_00495C00": {"9": [{"val": 42900}]},
                    "6100_40495D00": {"9": [{"val": -4773}]},
                    "6100_00496900": {"9": [{"val": 2048}]},
                    "6100_00496A00": {"9": [{"val": 0}]},
                    "6100_004AB600": {"9": [{"val": 0}]},
                    "6100_40574600": {"9": [{"val": 100}]},
                    "6100_40574700": {"9": [{"val": 0}]},
                    "6100_40574800": {"9": [{"val": 0}]},
                    "6100_00664F00": {"9": [{"val": 1800}]},
                    "6100_00665900": {"9": [{"val": 0}]},
                    "6100_40665B00": {"9": [{"val": -998}]},
                    "6100_40666000": {"9": [{"val": -2}]},
                    "6100_40666100": {"9": [{"val": -2}]},
                    "6100_40666200": {"9": [{"val": -2}]},
                    "6100_40666700": {"9": [{"val": 320}]},
                    "6100_40666800": {"9": [{"val": 110}]},
                    "6100_40666900": {"9": [{"val": 110}]},
                    "6100_40666A00": {"9": [{"val": 110}]},
                    "6100_00696E00": {"9": [{"val": 100}]},
                    "6102_40254E00": {"9": [{"val": 29}]},
                    "6102_00254F00": {"9": [{"val": 3409000}]},
                    "6102_00493700": {"9": [{"val": 25000}]},
                    "6102_00493800": {"9": [{"val": 25000}]},
                    "6102_00495100": {"9": [{"val": 0}]},
                    "6102_004B2D00": {"9": [{"val": 835301}]},
                    "6180_08214800": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08412500": {"9": [{"val": [{"tag": 311}]}]},
                    "6180_08412800": {"9": [{"val": [{"tag": 569}]}]},
                    "6180_08412900": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_08412B00": {"9": [{"val": [{"tag": 235}]}]},
                    "6180_08414900": {"9": [{"val": [{"tag": 886}]}]},
                    "6180_08414A00": {"9": [{"val": [{"tag": 887}]}]},
                    "6180_08414B00": {"9": [{"val": [{"tag": 885}]}]},
                    "6180_08414C00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08414D00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08414E00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08416400": {"9": [{"val": [{"tag": 51}]}]},
                    "6180_08416900": {"9": [{"val": [{"tag": 16777213}]}]},
                    "6180_0846A600": {"9": [{"val": [{"tag": 1780}]}]},
                    "6180_08495E00": {"9": [{"val": [{"tag": 2292}]}]},
                    "6180_084A2C00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A2E00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A6400": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9600": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9700": {"9": [{"val": [{"tag": 1721}]}]},
                    "6180_084A9800": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9900": {"9": [{"val": [{"tag": 1721}]}]},
                    "6180_104A9A00": {"9": [{"val": "192.168.0.71"}]},
                    "6180_104A9B00": {"9": [{"val": "255.255.255.0"}]},
                    "6180_104A9C00": {"9": [{"val": "192.168.0.1"}]},
                    "6180_104A9D00": {"9": [{"val": "192.168.0.20"}]},
                    "6180_084AAA00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_104AB700": {"9": [{"val": ""}]},
                    "6180_104AB800": {"9": [{"val": ""}]},
                    "6180_104AB900": {"9": [{"val": ""}]},
                    "6180_104ABA00": {"9": [{"val": ""}]},
                    "6180_084ABB00": {"9": [{"val": [{"tag": 3369}]}]},
                    "6180_084ABC00": {"9": [{"val": [{"tag": 1725}]}]},
                    "6180_084ABD00": {"9": [{"val": [{"tag": 3326}]}]},
                    "6180_084B1E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08521E00": {"9": [{"val": [{"tag": 2246}]}]},
                    "6180_08671E00": {"9": [{"val": []}]},
                    "6182_08412B00": {"9": [{"val": [{"tag": 235}]}]},
                    "6182_08495600": {"9": [{"val": [{"tag": 1129}]}]},
                    "6182_08497600": {"9": [{"val": [{"tag": 2614}]}]},
                    "6182_08498A00": {"9": [{"val": []}]},
                    "6182_084A9E00": {"9": [{"val": [{"tag": 1727}]}]},
                    "6182_084A9F00": {"9": [{"val": [{"tag": 1727}]}]},
                    "6182_08636900": {"9": [{"val": [{"tag": 303}]}]},
                    "6380_40251E00": {"1": [{"val": 1681}, {"val": 826}]},
                    "6380_40451F00": {"1": [{"val": 34110}, {"val": 17050}]},
                    "6380_40452100": {"1": [{"val": 4928}, {"val": 4844}]},
                    "6400_00260100": {"9": [{"val": 119103}]},
                    "6400_00262200": {"9": [{"val": 1485}]},
                    "6400_00462400": {"9": [{"val": 87240}]},
                    "6400_00462500": {"9": [{"val": 63853}]},
                    "6400_00462E00": {"9": []},
                    "6400_00469100": {"9": [{"val": 87240}]},
                    "6400_00469200": {"9": [{"val": 63853}]},
                    "6400_0046C300": {"9": [{"val": 135097}]},
                    "6400_00496700": {"9": [{"val": 48662}]},
                    "6400_00496800": {"9": [{"val": 32539}]},
                    "6400_00496D00": {"9": [{"val": 41}]},
                    "6400_00497E00": {"9": [{"val": 50}]},
                    "6400_00618C00": {"9": [{"val": 41}]},
                    "6402_00618D00": {"9": [{"val": 32}]},
                }
            }
        },
        {
            "result": {
                "01B8-xxxxxBA3": {
                    "6800_000EA900": {"188": []},
                    "6800_08811F00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_10821E00": {"9": [{"val": "STP6.0-3SE-40 411"}]},
                    "6800_08821F00": {
                        "9": [{"validVals": [8009], "val": [{"tag": 8009}]}]
                    },
                    "6800_08822000": {
                        "9": [
                            {
                                "validVals": [19048, 19049, 19050, 19051],
                                "val": [{"tag": 19049}],
                            }
                        ]
                    },
                    "6800_08822100": {
                        "9": [
                            {
                                "validVals": [
                                    601,
                                    605,
                                    606,
                                    607,
                                    609,
                                    610,
                                    611,
                                    618,
                                    623,
                                    632,
                                    633,
                                    634,
                                    635,
                                    636,
                                    637,
                                    639,
                                    640,
                                    641,
                                    642,
                                    647,
                                    648,
                                ],
                                "val": [
                                    {"tag": 601},
                                    {"tag": 605},
                                    {"tag": 606},
                                    {"tag": 609},
                                    {"tag": 610},
                                    {"tag": 611},
                                    {"tag": 618},
                                    {"tag": 623},
                                    {"tag": 632},
                                    {"tag": 633},
                                    {"tag": 634},
                                    {"tag": 635},
                                    {"tag": 636},
                                    {"tag": 637},
                                    {"tag": 639},
                                    {"tag": 640},
                                    {"tag": 641},
                                    {"tag": 642},
                                    {"tag": 647},
                                    {"tag": 648},
                                ],
                            }
                        ]
                    },
                    "6800_00822500": {
                        "9": [{"low": 0, "high": 4294967000, "val": 26100}]
                    },
                    "6800_08822800": {
                        "9": [{"validVals": [302, 1129, 1130], "val": [{"tag": 302}]}]
                    },
                    "6800_08822B00": {
                        "9": [{"validVals": [461], "val": [{"tag": 461}]}]
                    },
                    "6800_00823400": {
                        "9": [{"low": 0, "high": 4294967294, "val": 50398724}]
                    },
                    "6800_08831E00": {
                        "9": [{"validVals": [381, 1467], "val": [{"tag": 1467}]}]
                    },
                    "6800_00832A00": {"9": [{"low": 6000, "high": 6000, "val": 6000}]},
                    "6800_40833700": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6800_08836E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08836F00": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_08837800": {
                        "9": [
                            {
                                "validVals": [
                                    777,
                                    778,
                                    779,
                                    780,
                                    781,
                                    782,
                                    783,
                                    784,
                                    785,
                                    786,
                                    796,
                                    797,
                                    798,
                                    799,
                                ],
                                "val": [{"tag": 778}],
                            }
                        ]
                    },
                    "6800_08838B00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08838C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08838D00": {
                        "9": [
                            {
                                "validVals": [
                                    9499,
                                    9500,
                                    9501,
                                    9502,
                                    9503,
                                    9504,
                                    9505,
                                    9506,
                                    9507,
                                    9508,
                                    9509,
                                    9511,
                                    9512,
                                    9513,
                                    9514,
                                    9515,
                                    9516,
                                    9517,
                                    9518,
                                    9519,
                                    9520,
                                    9522,
                                    9523,
                                    9524,
                                    9525,
                                    9528,
                                    9529,
                                    9530,
                                    9531,
                                    9532,
                                    9533,
                                    9534,
                                    9535,
                                    9536,
                                    9537,
                                    9538,
                                    9539,
                                    9541,
                                    9542,
                                    9543,
                                    9544,
                                    9545,
                                    9546,
                                    9547,
                                    9549,
                                    9551,
                                    9552,
                                    9553,
                                    9554,
                                    9555,
                                    9556,
                                    9557,
                                    9558,
                                    9559,
                                    9560,
                                    9561,
                                    9562,
                                    9563,
                                    9565,
                                    9566,
                                    9567,
                                    9568,
                                    9569,
                                    9570,
                                    9571,
                                    9572,
                                    9573,
                                    9574,
                                    9575,
                                    9576,
                                    9577,
                                    9578,
                                    9579,
                                    9580,
                                    9581,
                                    9582,
                                    9583,
                                    9584,
                                    9586,
                                    9587,
                                    9588,
                                    9589,
                                    9590,
                                    9591,
                                    9592,
                                    9593,
                                    9594,
                                    9595,
                                    9596,
                                    9597,
                                    9598,
                                ],
                                "val": [{"tag": 9499}],
                            }
                        ]
                    },
                    "6800_10838F00": {"9": [{"val": "ntp.sunny-portal.com"}]},
                    "6800_08839500": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08839700": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_0883AA00": {
                        "9": [
                            {
                                "validVals": [303, 1341, 1342, 5304],
                                "val": [{"tag": 303}],
                            }
                        ]
                    },
                    "6800_0883AE00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_10841E00": {"0": [{"val": ""}]},
                    "6800_00852A00": {"9": [{"low": 0, "high": 50000, "val": 6000}]},
                    "6800_08855C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_0086A300": {"9": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_08871E00": {
                        "9": [
                            {
                                "validVals": [
                                    27,
                                    438,
                                    7539,
                                    7550,
                                    7584,
                                    7590,
                                    7592,
                                    7594,
                                    7595,
                                    7602,
                                    7603,
                                    7615,
                                    7637,
                                    16777213,
                                ],
                                "val": [{"tag": 7602}],
                            }
                        ]
                    },
                    "6800_00893700": {"9": [{"low": 0, "high": None, "val": 10200}]},
                    "6800_08893B00": {
                        "9": [{"validVals": [1785], "val": [{"tag": 1785}]}]
                    },
                    "6800_08895A00": {
                        "9": [{"validVals": [5277, 5278], "val": [{"tag": 5277}]}]
                    },
                    "6800_088A2900": {
                        "9": [
                            {
                                "validVals": [302, 9327, 9375, 9376, 9437, 19043],
                                "val": [{"tag": 9327}],
                            }
                        ]
                    },
                    "6800_008A2A00": {"9": [{"low": 5, "high": 1500, "val": 100}]},
                    "6800_108A2B00": {"9": [{"val": ""}]},
                    "6800_108A3200": {"9": [{"val": ""}]},
                    "6800_088A3300": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088A4C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4D00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A5100": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088A5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_108A5300": {"9": [{"val": "192.168.0.173"}]},
                    "6800_108A5400": {"9": [{"val": "255.255.255.0"}]},
                    "6800_108A5500": {"9": [{"val": "192.168.0.1"}]},
                    "6800_108A5600": {"9": [{"val": "192.168.0.1"}]},
                    "6800_088A5800": {
                        "9": [{"validVals": [1438, 3326, 3327], "val": [{"tag": 1438}]}]
                    },
                    "6800_108A5900": {"9": [{"val": ""}]},
                    "6800_108A5A00": {"9": [{"val": ""}]},
                    "6800_088A5B00": {
                        "9": [{"validVals": [3323, 3324], "val": [{"tag": 3324}]}]
                    },
                    "6800_088A7700": {
                        "9": [{"validVals": [4330, 4331, 4332], "val": [{"tag": 4330}]}]
                    },
                    "6800_088A8A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_008AA200": {
                        "9": [{"low": 0, "high": None, "val": 3014931446}]
                    },
                    "6800_008AA300": {
                        "9": [{"low": 0, "high": None, "val": 3014931446}]
                    },
                    "6800_108AA400": {
                        "9": [
                            {"val": "SomeWifiNetwork"},
                            {"val": "WiFiNetwork2"},
                        ]
                    },
                    "6800_088AA500": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088B1E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B1F00": {"9": [{"low": 1, "high": 65535, "val": 80}]},
                    "6800_108B2000": {"9": [{"val": "255.255.255.255"}]},
                    "6800_108B2100": {"9": [{"val": ""}]},
                    "6800_108B2200": {"9": [{"val": ""}]},
                    "6800_008B2E00": {"9": [{"low": 0, "high": None, "val": 17105924}]},
                    "6800_088B5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088B7000": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7100": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_088B7200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7300": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_008B7400": {"9": [{"low": 3, "high": 123, "val": 3}]},
                    "6800_088C2300": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_088E7B00": {
                        "9": [
                            {
                                "validVals": [2109, 3174, 3237, 3312, 4994, 5143],
                                "val": [
                                    {"tag": 2109},
                                    {"tag": 3174},
                                    {"tag": 3312},
                                    {"tag": 4994},
                                ],
                            }
                        ]
                    },
                    "6800_00912100": {"9": [{"low": 0, "high": None, "val": 16784133}]},
                    "6800_00922500": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_00922600": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_0892AE00": {
                        "9": [{"validVals": [303, 582], "val": [{"tag": 303}]}]
                    },
                    "6800_0892D600": {
                        "9": [{"validVals": [303, 2137, 2138], "val": [{"tag": 303}]}]
                    },
                    "6800_0092D700": {"9": [{"low": 0, "high": 500000, "val": 10000}]},
                    "6800_0092D800": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6800_00A21E00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 3012373411}]
                    },
                    "6800_10A22F00": {"9": [{"val": "00:15:BB:03:47:3C"}]},
                    "6800_10A23000": {"9": [{"val": "74:7A:90:69:2B:DE"}]},
                    "6800_08A33A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_40A63A00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_40A63B00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_10AA6100": {"9": [{"val": "192.168.0.170"}]},
                    "6800_10AA6200": {"9": [{"val": "255.255.255.0"}]},
                    "6800_10AA6300": {"9": [{"val": "192.168.0.1"}]},
                    "6800_10AA6400": {"9": [{"val": "192.168.0.1"}]},
                    "6802_08822200": {
                        "9": [{"validVals": [603, 651], "val": [{"tag": 651}]}]
                    },
                    "6802_08822C00": {
                        "9": [
                            {
                                "validVals": [2340, 8605, 8620, 16777213],
                                "val": [{"tag": 8620}],
                            }
                        ]
                    },
                    "6802_00822D00": {"9": [{"low": 0, "high": None, "val": 0}]},
                    "6802_00823300": {
                        "9": [{"low": 0, "high": 4294967294, "val": 16843010}]
                    },
                    "6802_00830800": {"9": [{"low": 20, "high": 10000, "val": 20}]},
                    "6802_08831700": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6802_08831800": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6802_00832B00": {"9": [{"low": 3000, "high": 6050, "val": 6000}]},
                    "6802_00832E00": {"9": [{"low": 3000, "high": 6050, "val": 6000}]},
                    "6802_00832F00": {"9": [{"low": 6000, "high": 6000, "val": 6000}]},
                    "6802_08833900": {
                        "9": [{"validVals": [3585, 7517], "val": [{"tag": 3585}]}]
                    },
                    "6802_08833A00": {"9": [{"validVals": [1146], "val": []}]},
                    "6802_08834500": {
                        "9": [{"validVals": [303, 1438], "val": [{"tag": 303}]}]
                    },
                    "6802_08834D00": {
                        "9": [
                            {
                                "validVals": [237, 353, 355, 409, 411, 418, 568, 720],
                                "val": [],
                            }
                        ]
                    },
                    "6802_08837300": {"9": [{"validVals": [72], "val": []}]},
                    "6802_08838800": {"9": [{"validVals": [1146], "val": []}]},
                    "6802_00839B00": {"9": [{"low": 0, "high": None, "val": 0}]},
                    "6802_00839E00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 18940420}]
                    },
                    "6802_00839F00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 16908292}]
                    },
                    "6802_4083DB00": {"9": [{"low": -1, "high": 100, "val": 100}]},
                    "6802_4083DC00": {"9": [{"low": -1, "high": 100, "val": 0}]},
                    "6802_4083DD00": {"9": [{"low": -1, "high": 100, "val": 30}]},
                    "6802_4083DE00": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083DF00": {"9": [{"low": -1, "high": 100, "val": 60}]},
                    "6802_4083E000": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E100": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E200": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E300": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E400": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E500": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E600": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E700": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E800": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083E900": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_4083EA00": {"9": [{"low": -1, "high": 100, "val": -1}]},
                    "6802_0083EB00": {"9": [{"low": 0, "high": 99, "val": 0}]},
                    "6802_4083EC00": {"9": [{"low": -1, "high": 100, "val": 100}]},
                    "6802_0083ED00": {"9": [{"low": 1, "high": 60, "val": 5}]},
                    "6802_4083F300": {"9": [{"low": 0, "high": 10000, "val": 3600}]},
                    "6802_4083F600": {"9": [{"low": 0, "high": 10000, "val": -3600}]},
                    "6802_4083F700": {"9": [{"low": 800, "high": 1000, "val": -800}]},
                    "6802_4083FA00": {"9": [{"low": 800, "high": 1000, "val": 800}]},
                    "6802_10841F00": {"0": [{"val": ""}]},
                    "6802_00855D00": {"9": [{"low": 360, "high": 1800, "val": 360}]},
                    "6802_00865F00": {"9": [{"low": 80, "high": 245, "val": 230}]},
                    "6802_40866000": {"9": [{"low": -20, "high": 20, "val": 0}]},
                    "6802_08871F00": {
                        "9": [
                            {
                                "validVals": [
                                    438,
                                    7539,
                                    7550,
                                    7584,
                                    7590,
                                    7592,
                                    7594,
                                    7595,
                                    7602,
                                    7603,
                                    7615,
                                    7637,
                                ],
                                "val": [],
                            }
                        ]
                    },
                    "6802_08872000": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6802_08872200": {
                        "9": [
                            {
                                "validVals": [
                                    438,
                                    7539,
                                    7550,
                                    7584,
                                    7590,
                                    7592,
                                    7594,
                                    7595,
                                    7602,
                                    7603,
                                    7615,
                                    7637,
                                ],
                                "val": [{"tag": 7602}],
                            }
                        ]
                    },
                    "6802_08872900": {
                        "9": [{"validVals": [43, 4546, 4547, 4548], "val": []}]
                    },
                    "6802_00872A00": {
                        "9": [{"low": 20000, "high": 3000000, "val": 200000}]
                    },
                    "6802_08872B00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6802_00873700": {"9": [{"low": 0, "high": 3600000, "val": 60000}]},
                    "6802_00873800": {
                        "9": [{"low": 10000, "high": 900000, "val": 20000}]
                    },
                    "6802_00873B00": {"9": [{"low": 1000, "high": 2000, "val": 1150}]},
                    "6802_00873C00": {"9": [{"low": 1000, "high": 2000, "val": 1150}]},
                    "6802_00873D00": {"9": [{"low": 1000, "high": 2000, "val": 1150}]},
                    "6802_00873E00": {"9": [{"low": 200, "high": 1000, "val": 800}]},
                    "6802_00873F00": {"9": [{"low": 150, "high": 1000, "val": 800}]},
                    "6802_00874000": {"9": [{"low": 200, "high": 1000, "val": 800}]},
                    "6802_00874100": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00874200": {"9": [{"low": 1000, "high": 2000, "val": 2000}]},
                    "6802_00874300": {"9": [{"low": 1000, "high": 2000, "val": 1100}]},
                    "6802_00874400": {"9": [{"low": 0, "high": 1000, "val": 850}]},
                    "6802_00875100": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00875300": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00875500": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00875700": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00875900": {"9": [{"low": 0, "high": 1000000, "val": 200}]},
                    "6802_00877F00": {"9": [{"low": 4500, "high": 5500, "val": 5000}]},
                    "6802_00878000": {"9": [{"low": 5001, "high": 5500, "val": 5150}]},
                    "6802_00878100": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878200": {"9": [{"low": 5001, "high": 5500, "val": 5150}]},
                    "6802_00878300": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878400": {"9": [{"low": 5001, "high": 5500, "val": 5150}]},
                    "6802_00878500": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878600": {"9": [{"low": 4500, "high": 4996, "val": 4750}]},
                    "6802_00878700": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878800": {"9": [{"low": 4500, "high": 4996, "val": 4750}]},
                    "6802_00878900": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878A00": {"9": [{"low": 4500, "high": 4996, "val": 4750}]},
                    "6802_00878B00": {"9": [{"low": 0, "high": 600000, "val": 200}]},
                    "6802_00878C00": {"9": [{"low": 0, "high": 1000, "val": 1000}]},
                    "6802_00878D00": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6802_00878E00": {"9": [{"low": 4400, "high": 5000, "val": 4990}]},
                    "6802_00878F00": {"9": [{"low": 5000, "high": 5500, "val": 5010}]},
                    "6802_00879000": {"9": [{"low": 5000, "high": 5500, "val": 5020}]},
                    "6802_00879100": {"9": [{"low": 40, "high": 90000, "val": 200}]},
                    "6802_00879200": {"9": [{"low": 4400, "high": 5000, "val": 4750}]},
                    "6802_00879300": {"9": [{"low": 40, "high": 300000, "val": 200}]},
                    "6802_08893600": {
                        "9": [{"validVals": [303, 2289, 2290], "val": [{"tag": 303}]}]
                    },
                    "6802_00895000": {"9": [{"low": 1, "high": 50, "val": 5}]},
                    "6802_00895100": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6802_00895600": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6802_00895700": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6802_08896800": {
                        "9": [
                            {
                                "validVals": [
                                    4333,
                                    8610,
                                    8623,
                                    8628,
                                    8629,
                                    8630,
                                    8634,
                                    8636,
                                    8638,
                                    19033,
                                    19034,
                                    19045,
                                    19046,
                                    19073,
                                ],
                                "val": [{"tag": 19046}],
                            }
                        ]
                    },
                    "6802_00897000": {"9": [{"low": 0, "high": 10600, "val": 9000}]},
                    "6802_00897100": {"9": [{"low": 0, "high": 2500, "val": 0}]},
                    "6802_00897200": {"9": [{"low": 0, "high": 10600, "val": 7200}]},
                    "6802_00897300": {"9": [{"low": 0, "high": 2650, "val": 0}]},
                    "6802_108A2300": {
                        "9": [
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                            {"val": ""},
                        ]
                    },
                    "6802_088A7500": {
                        "9": [{"validVals": [303, 4478, 4479], "val": [{"tag": 4479}]}]
                    },
                    "6802_008A7600": {"9": [{"low": 11, "high": 31744, "val": 125}]},
                    "6802_088B4300": {
                        "9": [{"validVals": [5181, 5182], "val": [{"tag": 5182}]}]
                    },
                    "6802_008B4500": {"9": [{"low": 0, "high": 4, "val": 0}]},
                    "6802_008B4600": {"9": [{"low": 0, "high": 4, "val": 0}]},
                    "6802_008B4700": {"9": [{"low": 0, "high": 4, "val": 0}]},
                    "6802_088B7500": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6802_008B8A00": {"9": [{"low": 0, "high": 16384, "val": 16384}]},
                    "6802_108B8B00": {"9": [{"val": "01:0C:CD:01:00:00"}]},
                    "6802_00912300": {"9": [{"low": 0, "high": 255, "val": 0}]},
                    "6802_00912600": {"9": [{"low": 0, "high": 4294967294, "val": 0}]},
                    "6802_00912900": {
                        "9": [{"low": 0, "high": 4294967294, "val": 38938372}]
                    },
                    "6802_00912A00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 4613}]
                    },
                    "6802_00916100": {
                        "9": [{"low": 0, "high": 4294967294, "val": 18022404}]
                    },
                    "6802_00918900": {"9": [{"low": 0, "high": None, "val": 51904516}]},
                    "6802_08918D00": {
                        "9": [
                            {
                                "validVals": [
                                    4333,
                                    8610,
                                    8623,
                                    8628,
                                    8629,
                                    8630,
                                    8634,
                                    8636,
                                    8638,
                                    19033,
                                    19034,
                                    19045,
                                    19046,
                                    19073,
                                ],
                                "val": [{"tag": 19046}],
                            }
                        ]
                    },
                    "6802_00921C00": {"9": [{"low": 0, "high": 3600, "val": 1800}]},
                    "6802_40921D00": {
                        "9": [{"low": -500000, "high": 500000, "val": 0}]
                    },
                    "6802_00922000": {"9": [{"low": 5, "high": 6000, "val": 10}]},
                    "6802_08922100": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6802_00922300": {"9": [{"low": 3, "high": 6000, "val": 20}]},
                    "6802_00922400": {"9": [{"low": 10, "high": 10000, "val": 10000}]},
                    "6802_08922900": {
                        "9": [
                            {
                                "validVals": [
                                    303,
                                    1069,
                                    1070,
                                    1071,
                                    1072,
                                    1074,
                                    1075,
                                    1076,
                                ],
                                "val": [{"tag": 303}],
                            }
                        ]
                    },
                    "6802_40922A00": {"9": [{"low": -3600, "high": 3600, "val": 0}]},
                    "6802_40922B00": {"9": [{"low": -600, "high": 600, "val": 0}]},
                    "6802_08924000": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6802_08924100": {
                        "9": [
                            {
                                "validVals": [303, 1077, 1078, 1079],
                                "val": [{"tag": 303}],
                            }
                        ]
                    },
                    "6802_00924200": {"9": [{"low": 0, "high": 6000, "val": 6000}]},
                    "6802_00924300": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6802_08925900": {
                        "9": [{"validVals": [303, 1132], "val": [{"tag": 303}]}]
                    },
                    "6802_00925A00": {"9": [{"low": 0, "high": 500, "val": 20}]},
                    "6802_00925B00": {"9": [{"low": 0, "high": 100, "val": 40}]},
                    "6802_00925C00": {"9": [{"low": 0, "high": 500, "val": 5}]},
                    "6802_08925D00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 308}]}]
                    },
                    "6802_00925E00": {"9": [{"low": 0, "high": 100, "val": 10}]},
                    "6802_00926300": {"9": [{"low": 80, "high": 120, "val": 100}]},
                    "6802_00926400": {"9": [{"low": 0, "high": 600, "val": 0}]},
                    "6802_00926500": {"9": [{"low": 0, "high": 200, "val": 0}]},
                    "6802_00926600": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6802_08926800": {
                        "9": [{"validVals": [1330, 1331], "val": [{"tag": 1330}]}]
                    },
                    "6802_00926D00": {"9": [{"low": 0, "high": 100, "val": 50}]},
                    "6802_00926E00": {"9": [{"low": 80, "high": 100, "val": 100}]},
                    "6802_08926F00": {
                        "9": [{"validVals": [1041, 1042], "val": [{"tag": 1041}]}]
                    },
                    "6802_00927000": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6802_00927100": {"9": [{"low": 80, "high": 100, "val": 95}]},
                    "6802_08927200": {
                        "9": [{"validVals": [1041, 1042], "val": [{"tag": 1042}]}]
                    },
                    "6802_00927300": {"9": [{"low": 1000, "high": 1100, "val": 1050}]},
                    "6802_00927400": {"9": [{"low": 900, "high": 1000, "val": 1000}]},
                    "6802_00927800": {"9": [{"low": 0, "high": 100, "val": None}]},
                    "6802_00927900": {"9": [{"low": 0, "high": 500, "val": None}]},
                    "6802_00927C00": {"9": [{"low": 0, "high": 100, "val": None}]},
                    "6802_4092A400": {
                        "9": [
                            {"low": 0, "high": 100000, "val": 20000},
                            {"low": 0, "high": 100000, "val": 50000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 100000},
                        ]
                    },
                    "6802_4092A500": {
                        "9": [
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -1000},
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -900},
                            {"low": -1000, "high": 1000, "val": -900},
                        ]
                    },
                    "6802_0092E100": {"9": [{"low": 1, "high": 8, "val": 8}]},
                    "6802_0892E500": {
                        "9": [{"validVals": [3053, 3547], "val": [{"tag": 3547}]}]
                    },
                    "6802_0892E600": {
                        "9": [{"validVals": [2506, 2507], "val": [{"tag": 2506}]}]
                    },
                    "6802_0092E700": {"9": [{"low": 5, "high": 32400, "val": 600}]},
                    "6802_0092E800": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6802_0892E900": {
                        "9": [{"validVals": [2506, 2507], "val": [{"tag": 2506}]}]
                    },
                    "6802_0092EA00": {"9": [{"low": 5, "high": 32400, "val": 600}]},
                    "6802_4092EB00": {"9": [{"low": -6000, "high": 6000, "val": 0}]},
                    "6802_0892EC00": {
                        "9": [{"validVals": [2506, 2507], "val": [{"tag": 2506}]}]
                    },
                    "6802_0092ED00": {"9": [{"low": 5, "high": 32400, "val": 600}]},
                    "6802_4092EE00": {
                        "9": [{"low": 8000, "high": 10000, "val": 10000}]
                    },
                    "6802_0892EF00": {
                        "9": [{"validVals": [1041, 1042], "val": [{"tag": 1042}]}]
                    },
                    "6802_00953000": {
                        "9": [
                            {"low": 800, "high": 1200, "val": 800},
                            {"low": 800, "high": 1200, "val": 950},
                            {"low": 800, "high": 1200, "val": 1050},
                            {"low": 800, "high": 1200, "val": 1150},
                            {"low": 800, "high": 1200, "val": 1150},
                            {"low": 800, "high": 1200, "val": 1050},
                            {"low": 800, "high": 1200, "val": 950},
                            {"low": 800, "high": 1200, "val": 800},
                        ]
                    },
                    "6802_40953100": {
                        "9": [
                            {"low": -66000, "high": 66000, "val": 25000},
                            {"low": -66000, "high": 66000, "val": 0},
                            {"low": -66000, "high": 66000, "val": 0},
                            {"low": -66000, "high": 66000, "val": -25000},
                            {"low": -66000, "high": 66000, "val": -25000},
                            {"low": -66000, "high": 66000, "val": 0},
                            {"low": -66000, "high": 66000, "val": 0},
                            {"low": -66000, "high": 66000, "val": 25000},
                        ]
                    },
                    "6802_08953A00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6802_00953B00": {"9": [{"low": 5, "high": 10000, "val": 42}]},
                    "6802_00953C00": {"9": [{"low": 5, "high": 10000, "val": 42}]},
                    "6802_00956700": {
                        "9": [{"low": 8000, "high": 10000, "val": 10000}]
                    },
                    "6802_08956800": {
                        "9": [{"validVals": [1041, 1042], "val": [{"tag": 1042}]}]
                    },
                    "6802_0095A500": {"9": [{"low": 0, "high": 8, "val": 8}]},
                    "6802_0095C300": {
                        "9": [{"low": 100, "high": 1000000, "val": 2000}]
                    },
                    "6802_0095C400": {
                        "9": [{"low": 100, "high": 1000000, "val": 2000}]
                    },
                    "6802_0095DA00": {
                        "9": [{"low": 100, "high": 1000000, "val": 1000}]
                    },
                    "6802_0095DB00": {
                        "9": [{"low": 100, "high": 1000000, "val": None}]
                    },
                    "6802_0895DE00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6802_0095E200": {"9": [{"low": 10, "high": 100000, "val": 1000}]},
                    "6802_0095E300": {"9": [{"low": 10, "high": 100000, "val": 1000}]},
                    "6802_0095E600": {"9": [{"low": 0, "high": 8, "val": 8}]},
                    "6802_0095E700": {
                        "9": [
                            {"low": 800, "high": 1400, "val": 800},
                            {"low": 800, "high": 1400, "val": 850},
                            {"low": 800, "high": 1400, "val": 900},
                            {"low": 800, "high": 1400, "val": 947},
                            {"low": 800, "high": 1400, "val": 1000},
                            {"low": 800, "high": 1400, "val": 1000},
                            {"low": 800, "high": 1400, "val": 1108},
                            {"low": 800, "high": 1400, "val": 1152},
                        ]
                    },
                    "6802_4095E800": {
                        "9": [
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 75000},
                            {"low": 0, "high": 100000, "val": 50000},
                            {"low": 0, "high": 100000, "val": 25000},
                            {"low": 0, "high": 100000, "val": 100000},
                            {"low": 0, "high": 100000, "val": 75000},
                            {"low": 0, "high": 100000, "val": 50000},
                            {"low": 0, "high": 100000, "val": 25000},
                        ]
                    },
                    "6802_0895FD00": {
                        "9": [{"validVals": [4405, 4443], "val": [{"tag": 4405}]}]
                    },
                    "6802_08A33B00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6802_00B12100": {
                        "9": [{"low": 0, "high": 4294967294, "val": 3012373411}]
                    },
                    "6802_00B12200": {
                        "9": [{"low": 0, "high": 4294967294, "val": 451}]
                    },
                    "6802_00B12900": {
                        "9": [{"low": 0, "high": 4294967294, "val": 3011973023}]
                    },
                    "6802_00B12A00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 440}]
                    },
                    "6802_00B18900": {"9": [{"low": 0, "high": 0, "val": 206170139}]},
                    "6802_00B22400": {"9": [{"low": 0, "high": None, "val": 0}]},
                    "6802_00B22500": {"9": [{"low": 0, "high": None, "val": 0}]},
                }
            }
        },
        68,
        id="STP 6.0 SE, with energy meter, no optimizers",
    ),
    pytest.param(
        {
            "result": {
                "01B8-xxxxx099": {
                    "6100_40263F00": {"9": [{"val": -10}]},
                    "6100_40265F00": {"9": [{"val": 0}]},
                    "6100_00295A00": {"9": [{"val": 0}]},
                    "6100_00411E00": {"9": [{"val": 10000}]},
                    "6100_00411F00": {"9": [{"val": 0}]},
                    "6100_00412000": {"9": [{"val": 0}]},
                    "6100_00416600": {"9": [{"val": None}]},
                    "6100_00418000": {"9": [{"val": 0}]},
                    "6100_40463600": {"9": [{"val": 0}]},
                    "6100_40463700": {"9": [{"val": 2812}]},
                    "6100_40464000": {"9": [{"val": -9}]},
                    "6100_40464100": {"9": [{"val": -7}]},
                    "6100_40464200": {"9": [{"val": -4}]},
                    "6100_00464800": {"9": [{"val": 23430}]},
                    "6100_00464900": {"9": [{"val": 23250}]},
                    "6100_00464A00": {"9": [{"val": 23430}]},
                    "6100_00464B00": {"9": [{"val": 40580}]},
                    "6100_00464C00": {"9": [{"val": 40260}]},
                    "6100_00464D00": {"9": [{"val": 40580}]},
                    "6100_00464E00": {"9": [{"val": 99}]},
                    "6100_40465300": {"9": [{"val": 400}]},
                    "6100_40465400": {"9": [{"val": 400}]},
                    "6100_40465500": {"9": [{"val": 400}]},
                    "6100_00465700": {"9": [{"val": 4997}]},
                    "6100_40466500": {"9": [{"val": 3936}]},
                    "6100_40466600": {"9": [{"val": 5560}]},
                    "6100_40466B00": {"9": [{"val": 4043}]},
                    "6100_40466C00": {"9": [{"val": 791}]},
                    "6100_40466D00": {"9": [{"val": 1204}]},
                    "6100_40466E00": {"9": [{"val": 844}]},
                    "6100_00467700": {"9": []},
                    "6100_00467800": {"9": []},
                    "6100_00467900": {"9": []},
                    "6100_00468100": {"9": [{"val": 4996}]},
                    "6100_40468F00": {"9": [{"val": 2817}]},
                    "6100_40469900": {"9": [{"val": None}]},
                    "6100_0046C200": {"9": [{"val": 0}]},
                    "6100_0046E500": {"9": [{"val": 23292}]},
                    "6100_0046E600": {"9": [{"val": 23223}]},
                    "6100_0046E700": {"9": [{"val": 23322}]},
                    "6100_0046E800": {"9": [{"val": 0}]},
                    "6100_0046E900": {"9": [{"val": 0}]},
                    "6100_0046EA00": {"9": [{"val": 0}]},
                    "6100_0046EB00": {"9": [{"val": 791}]},
                    "6100_0046EC00": {"9": [{"val": 1181}]},
                    "6100_0046ED00": {"9": [{"val": 839}]},
                    "6100_4046EE00": {"9": [{"val": 17}]},
                    "6100_4046EF00": {"9": [{"val": 231}]},
                    "6100_4046F000": {"9": [{"val": 83}]},
                    "6100_4046F100": {"9": [{"val": 166}]},
                    "6100_40495B00": {"9": [{"val": 0}]},
                    "6100_00495C00": {"9": [{"val": 0}]},
                    "6100_40495D00": {"9": [{"val": 0}]},
                    "6100_00496900": {"9": [{"val": 0}]},
                    "6100_00496A00": {"9": [{"val": 0}]},
                    "6100_004AB600": {"9": [{"val": 0}]},
                    "6100_40574600": {"9": [{"val": 0}]},
                    "6100_40574700": {"9": [{"val": 0}]},
                    "6100_40574800": {"9": [{"val": 0}]},
                    "6100_00664F00": {"9": [{"val": 1200}]},
                    "6100_00665900": {"9": [{"val": 0}]},
                    "6100_40665B00": {"9": [{"val": -977}]},
                    "6100_40666000": {"9": [{"val": -2}]},
                    "6100_40666100": {"9": [{"val": -2}]},
                    "6100_40666200": {"9": [{"val": -2}]},
                    "6100_40666700": {"9": [{"val": 10}]},
                    "6100_40666800": {"9": [{"val": 6}]},
                    "6100_40666900": {"9": [{"val": 6}]},
                    "6100_40666A00": {"9": [{"val": 6}]},
                    "6100_00696E00": {"9": [{"val": 0}]},
                    "6180_08214800": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08412500": {"9": [{"val": [{"tag": 311}]}]},
                    "6180_08412800": {"9": [{"val": [{"tag": 569}]}]},
                    "6180_08412900": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_08412B00": {"9": [{"val": [{"tag": 235}]}]},
                    "6180_08414900": {"9": [{"val": [{"tag": 886}]}]},
                    "6180_08414A00": {"9": [{"val": [{"tag": 887}]}]},
                    "6180_08414B00": {"9": [{"val": [{"tag": 885}]}]},
                    "6180_08414C00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_08414D00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08414E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08416400": {"9": [{"val": [{"tag": 51}]}]},
                    "6180_08416900": {"9": [{"val": [{"tag": 16777213}]}]},
                    "6180_0846A600": {"9": [{"val": [{"tag": 1780}]}]},
                    "6180_08495E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_084A2C00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A2E00": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_084A6400": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_084A9600": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_084A9700": {"9": [{"val": [{"tag": 1721}]}]},
                    "6180_084A9800": {"9": [{"val": [{"tag": 1725}]}]},
                    "6180_084A9900": {"9": [{"val": [{"tag": 302}]}]},
                    "6180_104A9A00": {"9": [{"val": "192.168.2.107"}]},
                    "6180_104A9B00": {"9": [{"val": "255.255.255.0"}]},
                    "6180_104A9C00": {"9": [{"val": "192.168.2.1"}]},
                    "6180_104A9D00": {"9": [{"val": "192.168.2.1"}]},
                    "6180_084AAA00": {"9": [{"val": [{"tag": 307}]}]},
                    "6180_104AB700": {"9": [{"val": ""}]},
                    "6180_104AB800": {"9": [{"val": ""}]},
                    "6180_104AB900": {"9": [{"val": ""}]},
                    "6180_104ABA00": {"9": [{"val": ""}]},
                    "6180_084ABB00": {"9": [{"val": [{"tag": 3366}]}]},
                    "6180_084ABC00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_084ABD00": {"9": [{"val": [{"tag": 3326}]}]},
                    "6180_084B1E00": {"9": [{"val": [{"tag": 303}]}]},
                    "6180_08521E00": {"9": [{"val": [{"tag": 2246}]}]},
                    "6180_08671E00": {"9": [{"val": []}]},
                    "6380_40251E00": {"1": [{"val": 5}, {"val": 58}]},
                    "6380_40451F00": {"1": [{"val": 31180}, {"val": 59180}]},
                    "6380_40452100": {"1": [{"val": 16}, {"val": 98}]},
                    "6400_00260100": {"9": [{"val": 3662679}]},
                    "6400_00262200": {"9": [{"val": 24847}]},
                    "6400_00462400": {"9": [{"val": 2134875}]},
                    "6400_00462500": {"9": [{"val": 550848}]},
                    "6400_00462E00": {"9": []},
                    "6400_00469100": {"9": [{"val": 2134875}]},
                    "6400_00469200": {"9": [{"val": 550848}]},
                    "6400_0046C300": {"9": [{"val": 3662347}]},
                    "6400_00496700": {"9": [{"val": 0}]},
                    "6400_00496800": {"9": [{"val": 0}]},
                    "6400_00496D00": {"9": [{"val": None}]},
                    "6400_00497E00": {"9": [{"val": None}]},
                    "6400_00618C00": {"9": [{"val": 84}]},
                }
            }
        },
        {
            "result": {
                "01B8-xxxxx099": {
                    "6800_000EA900": {"188": []},
                    "6800_08811F00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_10821E00": {"9": [{"val": "SN: 3012000000"}]},
                    "6800_08821F00": {
                        "9": [{"validVals": [8009], "val": [{"tag": 8009}]}]
                    },
                    "6800_08822000": {
                        "9": [
                            {
                                "validVals": [19048, 19049, 19050, 19051],
                                "val": [{"tag": 19051}],
                            }
                        ]
                    },
                    "6800_08822100": {
                        "9": [
                            {
                                "validVals": [
                                    601,
                                    605,
                                    606,
                                    607,
                                    609,
                                    610,
                                    611,
                                    618,
                                    623,
                                    632,
                                    633,
                                    634,
                                    635,
                                    636,
                                    637,
                                    639,
                                    640,
                                    641,
                                    642,
                                    647,
                                    648,
                                ],
                                "val": [
                                    {"tag": 601},
                                    {"tag": 605},
                                    {"tag": 606},
                                    {"tag": 609},
                                    {"tag": 610},
                                    {"tag": 611},
                                    {"tag": 618},
                                    {"tag": 623},
                                    {"tag": 632},
                                    {"tag": 633},
                                    {"tag": 634},
                                    {"tag": 635},
                                    {"tag": 636},
                                    {"tag": 637},
                                    {"tag": 639},
                                    {"tag": 640},
                                    {"tag": 641},
                                    {"tag": 642},
                                    {"tag": 647},
                                    {"tag": 648},
                                ],
                            }
                        ]
                    },
                    "6800_00822500": {
                        "9": [{"low": 0, "high": 4294967000, "val": 43500}]
                    },
                    "6800_08822800": {
                        "9": [{"validVals": [302, 1129, 1130], "val": [{"tag": 302}]}]
                    },
                    "6800_08822B00": {
                        "9": [{"validVals": [461], "val": [{"tag": 461}]}]
                    },
                    "6800_00823400": {
                        "9": [{"low": 0, "high": 4294967294, "val": 50398468}]
                    },
                    "6800_08831E00": {
                        "9": [{"validVals": [381, 1467], "val": [{"tag": 1467}]}]
                    },
                    "6800_00832A00": {
                        "9": [{"low": 10000, "high": 10000, "val": 10000}]
                    },
                    "6800_40833700": {"9": [{"low": 0, "high": 100, "val": 0}]},
                    "6800_08836E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08836F00": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_08837800": {
                        "9": [
                            {
                                "validVals": [
                                    777,
                                    778,
                                    779,
                                    780,
                                    781,
                                    782,
                                    783,
                                    784,
                                    785,
                                    786,
                                    796,
                                    797,
                                    798,
                                    799,
                                ],
                                "val": [{"tag": 777}],
                            }
                        ]
                    },
                    "6800_08838B00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08838C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_08838D00": {
                        "9": [
                            {
                                "validVals": [
                                    9499,
                                    9500,
                                    9501,
                                    9502,
                                    9503,
                                    9504,
                                    9505,
                                    9506,
                                    9507,
                                    9508,
                                    9509,
                                    9511,
                                    9512,
                                    9513,
                                    9514,
                                    9515,
                                    9516,
                                    9517,
                                    9518,
                                    9519,
                                    9520,
                                    9522,
                                    9523,
                                    9524,
                                    9525,
                                    9528,
                                    9529,
                                    9530,
                                    9531,
                                    9532,
                                    9533,
                                    9534,
                                    9535,
                                    9536,
                                    9537,
                                    9538,
                                    9539,
                                    9541,
                                    9542,
                                    9543,
                                    9544,
                                    9545,
                                    9546,
                                    9547,
                                    9549,
                                    9551,
                                    9552,
                                    9553,
                                    9554,
                                    9555,
                                    9556,
                                    9557,
                                    9558,
                                    9559,
                                    9560,
                                    9561,
                                    9562,
                                    9563,
                                    9565,
                                    9566,
                                    9567,
                                    9568,
                                    9569,
                                    9570,
                                    9571,
                                    9572,
                                    9573,
                                    9574,
                                    9575,
                                    9576,
                                    9577,
                                    9578,
                                    9579,
                                    9580,
                                    9581,
                                    9582,
                                    9583,
                                    9584,
                                    9586,
                                    9587,
                                    9588,
                                    9589,
                                    9590,
                                    9591,
                                    9592,
                                    9593,
                                    9594,
                                    9595,
                                    9596,
                                    9597,
                                    9598,
                                ],
                                "val": [{"tag": 9499}],
                            }
                        ]
                    },
                    "6800_10838F00": {"9": [{"val": "ntp.sunny-portal.com"}]},
                    "6800_08839500": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_08839700": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_0883AA00": {
                        "9": [
                            {
                                "validVals": [303, 1341, 1342, 5304],
                                "val": [{"tag": 303}],
                            }
                        ]
                    },
                    "6800_0883AE00": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_10841E00": {"0": [{"val": ""}]},
                    "6800_00852A00": {"9": [{"low": 0, "high": 50000, "val": 10000}]},
                    "6800_08855C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_0086A300": {"9": [{"low": 0, "high": 4000000, "val": 0}]},
                    "6800_08871E00": {
                        "9": [
                            {
                                "validVals": [
                                    27,
                                    438,
                                    7539,
                                    7550,
                                    7584,
                                    7590,
                                    7592,
                                    7594,
                                    7595,
                                    7602,
                                    7603,
                                    7615,
                                    7637,
                                    16777213,
                                ],
                                "val": [{"tag": 7584}],
                            }
                        ]
                    },
                    "6800_00893700": {"9": [{"low": 0, "high": None, "val": 0}]},
                    "6800_08893B00": {
                        "9": [{"validVals": [1785], "val": [{"tag": 1785}]}]
                    },
                    "6800_08895A00": {
                        "9": [{"validVals": [5277, 5278], "val": [{"tag": 5277}]}]
                    },
                    "6800_088A2900": {
                        "9": [
                            {
                                "validVals": [302, 9327, 9375, 9376, 9437, 19043],
                                "val": [{"tag": 9327}],
                            }
                        ]
                    },
                    "6800_008A2A00": {"9": [{"low": 5, "high": 1500, "val": 100}]},
                    "6800_108A2B00": {"9": [{"val": ""}]},
                    "6800_108A3200": {"9": [{"val": ""}]},
                    "6800_088A3300": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_088A4C00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088A4D00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088A5100": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088A5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_108A5300": {"9": [{"val": "192.168.0.173"}]},
                    "6800_108A5400": {"9": [{"val": "255.255.255.0"}]},
                    "6800_108A5500": {"9": [{"val": "192.168.0.1"}]},
                    "6800_108A5600": {"9": [{"val": "192.168.0.1"}]},
                    "6800_088A5800": {
                        "9": [{"validVals": [1438, 3326, 3327], "val": [{"tag": 1438}]}]
                    },
                    "6800_108A5900": {"9": [{"val": ""}]},
                    "6800_108A5A00": {"9": [{"val": ""}]},
                    "6800_088A5B00": {
                        "9": [{"validVals": [3323, 3324], "val": [{"tag": 3324}]}]
                    },
                    "6800_088A7700": {
                        "9": [{"validVals": [4330, 4331, 4332], "val": [{"tag": 4330}]}]
                    },
                    "6800_088A8A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_008AA200": {
                        "9": [{"low": 0, "high": None, "val": 3013357833}]
                    },
                    "6800_008AA300": {
                        "9": [{"low": 0, "high": None, "val": 3013357833}]
                    },
                    "6800_108AA400": {"9": [{"val": ""}]},
                    "6800_088AA500": {"9": [{"validVals": [1146], "val": []}]},
                    "6800_088B1E00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B1F00": {"9": [{"low": 1, "high": 65535, "val": 80}]},
                    "6800_108B2000": {"9": [{"val": "255.255.255.255"}]},
                    "6800_108B2100": {"9": [{"val": ""}]},
                    "6800_108B2200": {"9": [{"val": "password"}]},
                    "6800_008B2E00": {"9": [{"low": 0, "high": None, "val": 17105924}]},
                    "6800_088B5200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_088B7000": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7100": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_088B7200": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1130}]}]
                    },
                    "6800_008B7300": {"9": [{"low": 1, "high": 65535, "val": 502}]},
                    "6800_008B7400": {"9": [{"low": 3, "high": 123, "val": 3}]},
                    "6800_088C2300": {
                        "9": [{"validVals": [303, 308], "val": [{"tag": 303}]}]
                    },
                    "6800_088E7B00": {
                        "9": [
                            {
                                "validVals": [2109, 3174, 3237, 3312, 4994, 5143],
                                "val": [
                                    {"tag": 2109},
                                    {"tag": 3174},
                                    {"tag": 3312},
                                    {"tag": 4994},
                                ],
                            }
                        ]
                    },
                    "6800_00912100": {"9": [{"low": 0, "high": None, "val": 16783877}]},
                    "6800_00922500": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_00922600": {"9": [{"low": 0, "high": 10000, "val": 10000}]},
                    "6800_0892AE00": {
                        "9": [{"validVals": [303, 582], "val": [{"tag": 303}]}]
                    },
                    "6800_0892D600": {
                        "9": [{"validVals": [303, 2137, 2138], "val": [{"tag": 303}]}]
                    },
                    "6800_0092D700": {"9": [{"low": 0, "high": 500000, "val": 10000}]},
                    "6800_0092D800": {"9": [{"low": 0, "high": 100, "val": 100}]},
                    "6800_00A21E00": {
                        "9": [{"low": 0, "high": 4294967294, "val": 3012395161}]
                    },
                    "6800_10A22F00": {"9": [{"val": "DE:DE:DE:DE:DE:DE"}]},
                    "6800_10A23000": {"9": [{"val": "DE:DE:DE:DE:DE:DE"}]},
                    "6800_08A33A00": {
                        "9": [{"validVals": [1129, 1130], "val": [{"tag": 1129}]}]
                    },
                    "6800_40A63A00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_40A63B00": {
                        "9": [{"low": -4000000, "high": 4000000, "val": 0}]
                    },
                    "6800_10AA6100": {"9": [{"val": "192.168.0.170"}]},
                    "6800_10AA6200": {"9": [{"val": "255.255.255.0"}]},
                    "6800_10AA6300": {"9": [{"val": "192.168.0.1"}]},
                    "6800_10AA6400": {"9": [{"val": "192.168.0.1"}]},
                }
            }
        },
        66,
        id="STP 10.0 SE, with energy meter, no optimizers",
    ),
    pytest.param(
        {
            "result": {
                "012F-7309D11A": {
                    "6100_40263F00": {"val": 46},
                    "6100_00411E00": {"val": 1500},
                    "6100_00411F00": {"val": 0},
                    "6100_00412000": {"val": 0},
                    "6100_00416600": {"val": None},
                    "6100_00418000": {"val": None},
                    "6100_40463600": {"val": None},
                    "6100_40463700": {"val": None},
                    "6100_40464000": {"val": 46},
                    "6100_40464100": {"val": None},
                    "6100_40464200": {"val": None},
                    "6100_00464800": {"val": 22935},
                    "6100_00464900": {"val": None},
                    "6100_00464A00": {"val": None},
                    "6100_00464B00": {"val": None},
                    "6100_00464C00": {"val": None},
                    "6100_00464D00": {"val": None},
                    "6100_40465300": {"val": 202},
                    "6100_40465400": {"val": None},
                    "6100_40465500": {"val": None},
                    "6100_00465700": {"val": 4999},
                    "6100_0046C200": {"val": 46},
                    "6100_004AB600": {"val": 81},
                    "6100_00543100": {"val": None},
                    "6100_00543200": {"val": None},
                    "6100_00543300": {"val": None},
                    "6100_00543400": {"val": None},
                    "6100_00543600": {"val": None},
                    "6100_00543800": {"val": None},
                    "6100_00543E00": {"val": None},
                    "6100_00665900": {"val": 988},
                    "6100_40665F00": {"val": -7},
                    "6100_40666000": {"val": -7},
                    "6100_40666100": {"val": None},
                    "6100_40666200": {"val": None},
                    "6100_40666700": {"val": 46},
                    "6100_40666800": {"val": 46},
                    "6100_40666900": {"val": None},
                    "6100_40666A00": {"val": None},
                    "6102_40254E00": {"val": 3},
                    "6102_00254F00": {"val": 3000000},
                    "6180_08214800": {"val": [{"tag": 307}]},
                    "6180_08412900": {"val": [{"tag": 302}]},
                    "6180_08413200": {"val": [{"tag": 308}]},
                    "6180_08413300": {"val": [{"tag": 303}]},
                    "6180_08414900": {"val": [{"tag": 302}]},
                    "6180_08414A00": {"val": [{"tag": 887}]},
                    "6180_08414B00": {"val": [{"tag": 302}]},
                    "6180_08416400": {"val": [{"tag": 51}]},
                    "6180_08416500": {"val": [{"tag": 884}]},
                    "6180_0846A600": {"val": []},
                    "6180_084A9600": {"val": [{"tag": 1725}]},
                    "6180_084A9700": {"val": [{"tag": 302}]},
                    "6180_104A9A00": {"val": ""},
                    "6180_104A9B00": {"val": ""},
                    "6180_104A9C00": {"val": ""},
                    "6180_104A9D00": {"val": ""},
                    "6180_084AAA00": {"val": [{"tag": 1725}]},
                    "6180_104AB700": {"val": "192.168.1.125"},
                    "6180_104AB800": {"val": "255.255.255.0"},
                    "6180_104AB900": {"val": "192.168.1.1"},
                    "6180_104ABA00": {"val": "192.168.1.11"},
                    "6180_084ABB00": {"val": [{"tag": 3369}]},
                    "6180_084ABC00": {"val": [{"tag": 307}]},
                    "6180_084B1E00": {"val": [{"tag": 307}]},
                    "6180_00522700": {"val": None, "min": 0, "max": 0},
                    "6180_40522800": {"val": None, "min": 0, "max": 0},
                    "6180_00522900": {"val": None, "min": 0, "max": 0},
                    "6180_08522A00": {"val": [{"tag": 16777213}]},
                    "6180_08522F00": {"val": [{"tag": 308}]},
                    "6180_08671E00": {"val": [{"tag": 7517}]},
                    "6182_084A9E00": {"val": [{"tag": 302}]},
                    "6380_40251E00": [{"str": 1, "val": 57}],
                    "6380_40451F00": [{"str": 1, "val": 11356}],
                    "6380_40452100": [{"str": 1, "val": 502}],
                    "6400_00260100": {"val": 5736656},
                    "6400_00262200": {"val": 37},
                    "6400_00462400": {"val": None},
                    "6400_00462500": {"val": None},
                    "6400_00462E00": {"val": 71636106},
                    "6400_00462F00": {"val": 67130459},
                    "6400_0046C300": {"val": 5736656},
                    "6400_00543A00": {"val": 0},
                    "6400_00543B00": {"val": 0},
                    "6400_00543C00": {"val": 0},
                    "6400_00543D00": {"val": 0},
                    "6400_00618C00": {"val": 817},
                    "6402_00618D00": {"val": 923},
                    "6402_00666F00": {"val": 2426},
                }
            }
        },
        {
            "result": {
                "012F-7309D11A": {
                    "6322_00851E00": [
                        {"str": 1, "val": 6500, "min": 5000, "max": 50000}
                    ],
                    "6322_00851F00": [{"str": 1, "val": 1, "min": 1, "max": 4}],
                    "6322_00854D00": [
                        {"str": 1, "val": 50000, "min": 5000, "max": 50000}
                    ],
                    "6800_08811F00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_10821E00": {"val": "SN: 1930023194"},
                    "6800_08821F00": {"val": [{"tag": 8001}], "validVals": [8001]},
                    "6800_08822000": {
                        "val": [{"tag": 9301}],
                        "validVals": [9301, 9303, 9302],
                    },
                    "6800_08822100": {
                        "val": [
                            {"tag": 601},
                            {"tag": 603},
                            {"tag": 605},
                            {"tag": 606},
                            {"tag": 610},
                            {"tag": 611},
                            {"tag": 618},
                            {"tag": 620},
                            {"tag": 632},
                            {"tag": 633},
                            {"tag": 634},
                            {"tag": 635},
                            {"tag": 637},
                            {"tag": 640},
                            {"tag": 641},
                            {"tag": 647},
                            {"tag": 648},
                        ],
                        "validVals": [
                            601,
                            603,
                            605,
                            606,
                            607,
                            610,
                            611,
                            618,
                            620,
                            632,
                            633,
                            634,
                            635,
                            636,
                            637,
                            640,
                            641,
                            647,
                            648,
                        ],
                    },
                    "6800_00822500": {"val": 7000, "min": 0, "max": 7000},
                    "6800_00823400": {"val": 33751296, "min": 0, "max": 4294967294},
                    "6800_08831E00": {
                        "val": [{"tag": 295}],
                        "validVals": [295, 381, 443],
                    },
                    "6800_00832A00": {"val": 1500, "min": 1500, "max": 1500},
                    "6800_08834300": {"val": [{"tag": 303}], "validVals": [303, 308]},
                    "6800_08836E00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_08837800": {
                        "val": [{"tag": 778}],
                        "validVals": [
                            777,
                            778,
                            779,
                            780,
                            781,
                            782,
                            783,
                            784,
                            785,
                            786,
                            798,
                            801,
                        ],
                    },
                    "6800_08838B00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_08838C00": {
                        "val": [{"tag": 1130}],
                        "validVals": [1129, 1130],
                    },
                    "6800_08838D00": {
                        "val": [{"tag": 9560}],
                        "validVals": [
                            302,
                            9500,
                            9501,
                            9502,
                            9503,
                            9504,
                            9505,
                            9506,
                            9507,
                            9508,
                            9509,
                            9510,
                            9511,
                            9512,
                            9513,
                            9515,
                            9516,
                            9517,
                            9518,
                            9519,
                            9520,
                            9522,
                            9523,
                            9524,
                            9525,
                            9528,
                            9530,
                            9531,
                            9532,
                            9533,
                            9534,
                            9535,
                            9536,
                            9537,
                            9538,
                            9539,
                            9541,
                            9542,
                            9543,
                            9544,
                            9545,
                            9546,
                            9547,
                            9549,
                            9550,
                            9551,
                            9552,
                            9553,
                            9554,
                            9555,
                            9556,
                            9557,
                            9558,
                            9559,
                            9560,
                            9561,
                            9562,
                            9563,
                            9564,
                            9565,
                            9566,
                            9567,
                            9568,
                            9569,
                            9570,
                            9571,
                            9572,
                            9573,
                            9574,
                            9575,
                            9576,
                            9577,
                            9578,
                            9579,
                            9580,
                            9581,
                            9582,
                            9583,
                            9584,
                            9586,
                            9587,
                            9588,
                            9589,
                            9591,
                            9592,
                            9593,
                            9594,
                            9595,
                            9596,
                        ],
                    },
                    "6800_10838F00": {"val": "ntp.sunny-portal.com"},
                    "6800_10841E00": {"val": ""},
                    "6800_00852A00": {"val": 1500, "min": 0, "max": 50000},
                    "6800_08855C00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_08871E00": {
                        "val": [{"tag": 7517}],
                        "validVals": [
                            27,
                            42,
                            438,
                            7510,
                            7517,
                            7523,
                            7525,
                            7527,
                            7532,
                            7533,
                            7536,
                            16777213,
                        ],
                    },
                    "6800_088A4C00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_088A4D00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_108A4E00": {"val": "TIM-69890546"},
                    "6800_108A4F00": {"val": ""},
                    "6800_088A5000": {
                        "val": [{"tag": 3397}],
                        "validVals": [1831, 3322, 3394, 3395, 3396, 3397],
                    },
                    "6800_088A5100": {"val": [], "validVals": [3321]},
                    "6800_088A5200": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_108A5300": {"val": "192.168.1.30"},
                    "6800_108A5400": {"val": "255.255.255.0"},
                    "6800_108A5500": {"val": "192.168.1.1"},
                    "6800_108A5600": {"val": "192.168.1.1"},
                    "6800_008A5700": {"val": 1, "min": 1, "max": 4},
                    "6800_088A8A00": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_008AA200": {"val": 0, "min": 0, "max": 4294967294},
                    "6800_008AA300": [
                        {"str": 1, "val": None, "min": 0, "max": 4294967294},
                        {"str": 2, "val": None, "min": 0, "max": 4294967294},
                        {"str": 3, "val": None, "min": 0, "max": 4294967294},
                    ],
                    "6800_108AA400": [
                        {"str": 1, "val": "SMA1930022724"},
                        {"str": 2, "val": "TIM-69890546"},
                    ],
                    "6800_088AA500": {"val": [], "validVals": [11621]},
                    "6800_088B5200": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6800_088B7000": {
                        "val": [{"tag": 1130}],
                        "validVals": [1129, 1130],
                    },
                    "6800_008B7100": {"val": 502, "min": 1, "max": 65535},
                    "6800_088B7200": {
                        "val": [{"tag": 1130}],
                        "validVals": [1129, 1130],
                    },
                    "6800_008B7300": {"val": 502, "min": 1, "max": 65535},
                    "6800_088E7B00": {
                        "val": [{"tag": 2109}, {"tag": 3174}, {"tag": 3237}],
                        "validVals": [2109, 3174, 3237],
                    },
                    "6800_00912100": {"val": 33751300, "min": 0, "max": 4294967294},
                    "6800_00922500": {"val": 1500, "min": 0, "max": 2550},
                    "6800_00922600": {"val": 10000, "min": 0, "max": 10000},
                    "6800_0892D600": {
                        "val": [{"tag": 303}],
                        "validVals": [303, 2137, 2138],
                    },
                    "6800_0092D700": {"val": 1500, "min": 0, "max": 50000},
                    "6800_0092D800": {"val": 100, "min": 0, "max": 100},
                    "6800_00A21E00": {"val": 1930023194, "min": 0, "max": 4294967294},
                    "6800_10A22F00": {"val": "00:40:AD:96:B8:10"},
                    "6800_10A23000": {"val": "00:AE:FA:06:F0:5E"},
                    "6800_00A63500": {"val": 0, "min": 0, "max": 4000000},
                    "6800_40A63A00": {"val": 0, "min": -4000000, "max": 4000000},
                    "6800_40A63B00": {"val": 0, "min": -4000000, "max": 4000000},
                    "6800_10AA6100": {"val": "192.168.0.170"},
                    "6800_10AA6200": {"val": "255.255.255.0"},
                    "6800_10AA6300": {"val": "192.168.0.170"},
                    "6800_10AA6400": {"val": "192.168.0.170"},
                    "6802_08822200": {"val": [{"tag": 636}], "validVals": [636]},
                    "6802_00823300": {"val": 16909570, "min": 0, "max": 4294967294},
                    "6802_00832B00": {"val": 1500, "min": 0, "max": 1550},
                    "6802_00832E00": {"val": 1500, "min": 0, "max": 1550},
                    "6802_00832F00": {"val": 1500, "min": 1500, "max": 1500},
                    "6802_00833300": {"val": 2, "min": 1, "max": 3600},
                    "6802_08833900": {"val": [{"tag": 7517}], "validVals": [302, 7517]},
                    "6802_08833A00": {"val": [], "validVals": [7517]},
                    "6802_08834D00": {
                        "val": [],
                        "validVals": [237, 353, 355, 356, 409, 411, 418, 568],
                    },
                    "6802_08837300": {"val": [], "validVals": [72]},
                    "6802_00839C00": {"val": 16843780, "min": 0, "max": 4294967294},
                    "6802_00839E00": {"val": 16850948, "min": 0, "max": 4294967294},
                    "6802_00839F00": {"val": 16777476, "min": 0, "max": 4294967294},
                    "6802_10841F00": {"val": ""},
                    "6802_00855D00": {"val": 360, "min": 360, "max": 1800},
                    "6802_08861E00": {
                        "val": [{"tag": 325}],
                        "validVals": [325, 327, 329],
                    },
                    "6802_00864000": {"val": 100, "min": 0, "max": 500},
                    "6802_00864100": {"val": 200, "min": 0, "max": 500},
                    "6802_00865F00": {"val": 230, "min": 80, "max": 245},
                    "6802_40866000": {"val": 0, "min": -20, "max": 20},
                    "6802_08871F00": {
                        "val": [],
                        "validVals": [
                            42,
                            438,
                            7510,
                            7517,
                            7523,
                            7525,
                            7527,
                            7532,
                            7533,
                            7536,
                        ],
                    },
                    "6802_08872000": {
                        "val": [{"tag": 1129}],
                        "validVals": [1129, 1130],
                    },
                    "6802_00872A00": {"val": 20000, "min": 20000, "max": 3000000},
                    "6802_08872B00": {"val": [{"tag": 308}], "validVals": [303, 308]},
                    "6802_00873500": {"val": 0, "min": 0, "max": 400000},
                    "6802_00873600": {"val": 300000, "min": 0, "max": 1600000},
                    "6802_00873700": {"val": 300000, "min": 0, "max": 1600000},
                    "6802_00873800": {"val": 30000, "min": 0, "max": 1600000},
                    "6802_00874D00": {"val": 230, "min": 100, "max": 280},
                    "6802_00874E00": {"val": 40000, "min": 30000, "max": 42000},
                    "6802_00874F00": {"val": 312, "min": 100, "max": 5000},
                    "6802_00875000": {"val": 28000, "min": 10000, "max": 30000},
                    "6802_00875100": {"val": 10000, "min": 0, "max": 60000},
                    "6802_00875200": {"val": 26450, "min": 10000, "max": 28000},
                    "6802_00875300": {"val": 200, "min": 0, "max": 60000},
                    "6802_00875400": {"val": 19550, "min": 4500, "max": 23000},
                    "6802_00875500": {"val": 400, "min": 0, "max": 10000},
                    "6802_00875600": {"val": 9200, "min": 4500, "max": 23000},
                    "6802_00875700": {"val": 200, "min": 0, "max": 10000},
                    "6802_00877500": {"val": 2000, "min": 40, "max": 10000},
                    "6802_00877600": {"val": 25300, "min": 10000, "max": 28000},
                    "6802_00877800": {"val": 19550, "min": 4500, "max": 24000},
                    "6802_00877900": {"val": 25300, "min": 10000, "max": 28000},
                    "6802_00877F00": {"val": 5000, "min": 4400, "max": 6500},
                    "6802_00878200": {"val": 6500, "min": 5000, "max": 6500},
                    "6802_00878300": {"val": 10000, "min": 0, "max": 10000},
                    "6802_00878400": {"val": 5150, "min": 5000, "max": 6500},
                    "6802_00878500": {"val": 100, "min": 0, "max": 90000},
                    "6802_00878600": {"val": 4750, "min": 4400, "max": 6000},
                    "6802_00878700": {"val": 100, "min": 0, "max": 300000},
                    "6802_00878800": {"val": 4400, "min": 4400, "max": 6000},
                    "6802_00878900": {"val": 300000, "min": 0, "max": 300000},
                    "6802_00878C00": {"val": 1000, "min": 0, "max": 1000},
                    "6802_00878D00": {"val": 10000, "min": 0, "max": 10000},
                    "6802_00878E00": {"val": 4990, "min": 4400, "max": 6000},
                    "6802_00878F00": {"val": 5010, "min": 5000, "max": 6500},
                    "6802_00879000": {"val": 5050, "min": 5000, "max": 6500},
                    "6802_00879100": {"val": 100, "min": 40, "max": 90000},
                    "6802_00879200": {"val": 4950, "min": 4400, "max": 6000},
                    "6802_00879300": {"val": 100, "min": 40, "max": 300000},
                    "6802_40879400": {"val": 35, "min": 18, "max": 2000},
                    "6802_00879500": {"val": 200, "min": 0, "max": 10000},
                    "6802_08879900": {"val": [{"tag": 303}], "validVals": [303, 308]},
                    "6802_00879A00": {"val": 10000, "min": 0, "max": 10000},
                    "6802_008B8A00": {"val": 16384, "min": 0, "max": 16384},
                    "6802_108B8B00": {"val": "01:0C:CD:01:00:00"},
                    "6802_00912200": {"val": 2, "min": 0, "max": 4294967294},
                    "6802_00912300": {"val": 0, "min": 0, "max": 255},
                    "6802_00912900": {"val": 33751300, "min": 0, "max": 4294967294},
                    "6802_00912A00": {"val": 257, "min": 0, "max": 4294967294},
                    "6802_00912B00": {"val": 0, "min": 0, "max": 255},
                    "6802_00919900": {"val": 16777220, "min": 0, "max": 4294967294},
                    "6802_00921E00": {"val": 20, "min": 1, "max": 1000},
                    "6802_00922000": {"val": 20, "min": 1, "max": 10000},
                    "6802_08922100": {"val": [{"tag": 308}], "validVals": [303, 308]},
                    "6802_00922200": {"val": 20, "min": 1, "max": 50},
                    "6802_00922300": {"val": 20, "min": 1, "max": 10000},
                    "6802_08922900": {
                        "val": [{"tag": 1074}],
                        "validVals": [303, 1069, 1070, 1072, 1074, 1075, 1076, 2270],
                    },
                    "6802_40922B00": {"val": 0, "min": -500, "max": 500},
                    "6802_40923100": {"val": 100, "min": 80, "max": 100},
                    "6802_08923200": {
                        "val": [{"tag": 1042}],
                        "validVals": [1041, 1042],
                    },
                    "6802_08924000": {
                        "val": [{"tag": 1130}],
                        "validVals": [1129, 1130],
                    },
                    "6802_08924100": {
                        "val": [{"tag": 303}],
                        "validVals": [303, 1077, 1078, 1079],
                    },
                    "6802_00924200": {"val": 1500, "min": 0, "max": 1550},
                    "6802_00924300": {"val": 100, "min": 0, "max": 100},
                    "6802_08925900": {
                        "val": [{"tag": 1132}],
                        "validVals": [303, 1132, 3175],
                    },
                    "6802_00925A00": {"val": 30, "min": 0, "max": 500},
                    "6802_00925B00": {"val": 83, "min": 10, "max": 130},
                    "6802_00925C00": {"val": 10, "min": 0, "max": 500},
                    "6802_08925D00": {"val": [{"tag": 308}], "validVals": [303, 308]},
                    "6802_00925E00": {"val": 5, "min": 1, "max": 10000},
                    "6802_00925F00": {"val": 300, "min": 0, "max": 1600},
                    "6802_40926000": {"val": -10, "min": -500, "max": 0},
                    "6802_40926100": {"val": 10, "min": 0, "max": 500},
                    "6802_00926200": {"val": 0, "min": 0, "max": 60000},
                    "6802_00926300": {"val": 100, "min": 80, "max": 120},
                    "6802_00926400": {"val": 0, "min": 0, "max": 500},
                    "6802_00926500": {"val": 0, "min": 0, "max": 200},
                    "6802_00926600": {"val": 0, "min": 0, "max": 100},
                    "6802_00926700": {"val": 10, "min": 2, "max": 60},
                    "6802_08926800": {
                        "val": [{"tag": 1330}],
                        "validVals": [1330, 1331],
                    },
                    "6802_00926D00": {"val": 50, "min": 0, "max": 100},
                    "6802_00926E00": {"val": 100, "min": 80, "max": 100},
                    "6802_08926F00": {
                        "val": [{"tag": 1041}],
                        "validVals": [1041, 1042],
                    },
                    "6802_00927000": {"val": 100, "min": 0, "max": 100},
                    "6802_00927100": {"val": 95, "min": 80, "max": 100},
                    "6802_08927200": {
                        "val": [{"tag": 1042}],
                        "validVals": [1041, 1042],
                    },
                    "6802_00927300": {"val": 1050, "min": 0, "max": 1200},
                    "6802_00927400": {"val": 1000, "min": 0, "max": 1200},
                    "6802_00927800": {"val": 70, "min": 0, "max": 100},
                    "6802_00927C00": {"val": 5, "min": 0, "max": 100},
                    "6802_08927F00": {
                        "val": [{"tag": 1265}],
                        "validVals": [1264, 1265],
                    },
                    "6802_00928700": {"val": 1800, "min": 60, "max": 86400},
                    "6802_0892E600": {
                        "val": [{"tag": 2506}],
                        "validVals": [2506, 2507],
                    },
                    "6802_0092E700": {"val": 600, "min": 5, "max": 86400},
                    "6802_0092E800": {"val": 10000, "min": 0, "max": 10000},
                    "6802_0892E900": {
                        "val": [{"tag": 2506}],
                        "validVals": [2506, 2507],
                    },
                    "6802_0092EA00": {"val": 600, "min": 5, "max": 86400},
                    "6802_4092EB00": {"val": 0, "min": -5000, "max": 5000},
                    "6802_0892EC00": {
                        "val": [{"tag": 2506}],
                        "validVals": [2506, 2507],
                    },
                    "6802_0092ED00": {"val": 600, "min": 5, "max": 86400},
                    "6802_4092EE00": {"val": 10000, "min": 8000, "max": 10000},
                    "6802_0892EF00": {
                        "val": [{"tag": 1042}],
                        "validVals": [1041, 1042],
                    },
                    "6802_00A62A00": {"val": 0, "min": 0, "max": 440000},
                    "6802_00A62B00": {"val": 0, "min": 0, "max": 440000},
                    "6802_00B12100": {"val": 1930023194, "min": 0, "max": 4294967294},
                    "6802_00B12200": {"val": 302, "min": 0, "max": 4294967294},
                    "6802_00B12900": {"val": 23194, "min": 0, "max": 4294967294},
                    "6802_00B12A00": {"val": 303, "min": 0, "max": 4294967294},
                }
            }
        },
        32,
        id="Sunny Boy 1.5, no energy meter, no optimizers",
    ),
]
