# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mg_file',
 'mg_file.file',
 'mg_file.file.test',
 'mg_file.sqllite_orm',
 'mg_file.sqllite_orm.test']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'prettytable>=3.0.0,<4.0.0']

setup_kwargs = {
    'name': 'mg-file',
    'version': '0.1.3',
    'description': 'Удобное пользование файлами',
    'long_description': '# Что это ?\n\nЭто встраемовая библиотека для работы с файлами формата\n\n- txt = [TxtFile](#txtfile)\n- csv = [CsvFile](#csvFile)\n- json = [JsonFile](#jsonfile)\n- pick = [PickleFile](#picklefile)\n- SqlLite = [SqlLiteQrm](#sqlLiteqrm)\n\n# Описание функционала библиотеки\n\n## TxtFile\n\nСначала создаем экземпляр класса `TxtFile` а потом работаем с его методами\n\n```python\ntxt_obj = TxtFile("test.txt")\n```\n\n---\n\n- `readFileToResDict(*args: str, separator: str = \'\\n\')-> Dict[str, str]` = Считывает файл и возвращает Dict с ключами\n  заданными в параметры `*args` разграничение происходит по параметру\n  `separator`\n\n> Пример\n\n```python\ntxt_obj.writeFile("my name\\nmy passwd\\nmy token")\nres = txt_obj.readFileToResDict("name", "passwd", "token")\nassert res == {\'name\': \'my name\', \'passwd\': \'my passwd\', \'token\': \'my token\'}\n```\n\n---\n\n- `readFile(limit: int = 0, *, encoding: str = None)-> str` = Обычное чтение `.txt` файла. Можно указать лимит по чтение\n  строчек `limit`. И кодировку чтения `encoding` значения такие же как и стандартной функции `open()`\n\n> Пример\n\n```python\ntest_text = "123123\\n3123133\\n12312d1d12313"\ntxt_obj.writeFile(test_text)\nassert txt_obj.readFile() == "123123\\n3123133\\n"\n```\n\n---\n\n- `searchFile(name_find:str) -> bool` = Поиск слова `name_find` в тексте\n\n> Пример\n\n```python\ntest_text = "Optional. If the number of \\n bytes returned exceed the hint number, \\n no more lines will be returned. Default value is  -1, which means all lines will be returned."\ntxt_obj.writeFile(test_text)\nassert txt_obj.searchFile("more") == True\n```\n\n---\n\n- `readBinaryFile()->bytes` = Чтение бинарного файла\n\n> Пример\n\n```python\ntest_str = \'123\'\ntxt_obj.writeBinaryFile(test_str.encode())\nassert test_str.encode() == txt_obj.readBinaryFile()\n```\n\n---\n\n- `writeFile(data:str)` = Запись в тактовом режиме\n\n---\n\n- `appendFile(data: str)` = Добавление в текстовом режиме\n\n---\n\n- `writeBinaryFile(data: Union[bytes, memoryview])` = Запись в бинарном режиме\n\n---\n\n- `appendBinaryFile(data: bytes)` = Добавление данных в бинарный файл\n\n---\n\n## CsvFile\n\nСначала создаем экземпляр класса `CsvFile` а потом работаем с его методами\n\n```python\ncsv_obj = CsvFile("test.csv")\n```\n\n- `readFile(encoding: str = "utf-8", newline: str = "", limit: int = None, miss_get_head=False) -> List[List[str]]` =\n  чтение cvs файла. `encodin newline` стандартной функции `open()`. `limit` сколько строк считать с начало.\n  `miss_get_head` вернуть данные без заголовков\n\n> Пример\n\n```python\ncsv_obj.writeFile(\n    [[1, 23, 41, 5],\n     [21, 233, 46, 35],\n     [13, 233, 26, 45],\n     [12, 213, 43, 56]], FlagDataConferToStr=True, header=("Данные", "Data", "Числа", "Num"))\n\nassert csv_obj.readFile() == [[\'Данные\', \'Data\', \'Числа\', \'Num\'],\n                              [\'1\', \'23\', \'41\', \'5\'],\n                              [\'21\', \'233\', \'46\', \'35\'],\n                              [\'13\', \'233\', \'26\', \'45\'],\n                              [\'12\', \'213\', \'43\', \'56\']]\n```\n\n---\n\n- `readFileAndFindDifferences(new_data_find: List[List], funIter) -> bool` = Чтение csv файла, с проверкой различий\n  входных данных с данными в файле, если такие различия найдены то выполняется переданная функция `funIter`.\n\n> Пример\n\n```python\ndata_file = [[\'1\', \'2\'], [\'3\', \'2\'], ["today", "Saturday"]]\nnew_data = [[\'1\', \'2\'], [\'3\', \'2\'], ["today", "Monday"]]\nDifferenceList = []\ncsv_obj.writeFile(data_file, header=("h1", "h2"))\ncsv_obj.readFileAndFindDifferences(new_data, DifferenceList.append)\nassert DifferenceList == [["today", "Saturday"]]\n```\n\n---\n\n- `readFileRevers(limit: int = None, encoding: str = "utf-8", newline: str = "") ->  List[List[str]]` = Чтение cvs файла\n  с конца в начало.\n  `encodin newline` стандартной функции `open()`. `limit` сколько строк считать с конца.\n\n> Пример\n\n```python\ncsv_obj.writeFile(\n    [[1, 23, 41, 5],\n     [21, 233, 46, 35],\n     [13, 233, 26, 45],\n     [12, 213, 43, 56]], FlagDataConferToStr=True, header=("Данные", "Data", "Числа", "Num"))\nassert csv_obj.readFileRevers() == [[\'12\', \'213\', \'43\', \'56\'],\n                                    [\'13\', \'233\', \'26\', \'45\'],\n                                    [\'21\', \'233\', \'46\', \'35\'],\n                                    [\'1\', \'23\', \'41\', \'5\'],\n                                    [\'Данные\', \'Data\', \'Числа\', \'Num\']]\n```\n\n---\n\n- `writeFile(data: Union[List[Union[str, int, float]], List[List[Union[str, int, float]]]], *, header: tuple = None, FlagDataConferToStr: bool = False, encoding: str = "utf-8", newline: str = "")`\n  = Запись данных в csv файл. `encodin newline` стандартной функции `open()`.\n  `FlagDataConferToStr` Проверять все входнее данные и конвертировать их в тип `str`. `header` = Задать заголовки\n  столбцам.\n\n---\n\n- `appendFile(data: Union[List[Union[str, int, float]], List[List[Union[str, int, float]]]], *, FlagDataConferToStr: bool = False, encoding: str = "utf-8", newline: str = ""\n  )` = Добавить данные в конец csv файла. Такие же параметры как у `writeFile.\n\n> Пример\n\n```python\ncsv_obj.writeFile(\n    [[1, 23, 41, 5],\n     [21, 233, 46, 35],\n     [13, 233, 26, 45],\n     [12, 213, 43, 56]], FlagDataConferToStr=True, header=("Данные", "Data", "Числа", "Num"))\n\ncsv_obj.appendFile([[\'2323\', \'23233\', \'23\']])\n\nassert csv_obj.readFile() == [[\'Данные\', \'Data\', \'Числа\', \'Num\'],\n                              [\'1\', \'23\', \'41\', \'5\'],\n                              [\'21\', \'233\', \'46\', \'35\'],\n                              [\'13\', \'233\', \'26\', \'45\'],\n                              [\'12\', \'213\', \'43\', \'56\'],\n                              [\'2323\', \'23233\', \'23\']]\n```\n\n---\n\n## JsonFile\n\nСначала создаем экземпляр класса `JsonFile` а потом работаем с его методами\n> Пример\n\n```python\njson_obj = JsonFile("test.json")\n```\n\n---\n\n- `readFile()` = Чтение данных из json файла\n\n---\n\n- `writeFile(data: Union[List, Dict], *, indent=4, ensure_ascii: bool = False)` = Запись данных в файл, входные\n  параметры такие же как у стандартной функции `open()`\n\n---\n\n- `appendFile(data: Union[List, Dict], *, ensure_ascii: bool = False)` = Добавить данные в файл\n\n> Пример\n\n```python\n# List\ntempers: List = [1, 2, 3, 4]\n\njson_obj.writeFile(tempers)\njson_obj.appendFile(tempers)\n\ntempers += tempers\nassert tempers == json_obj.readFile()\n\n# Dict\ntempers: Dict = {\'1\': 11, \'2\': 22, \'3\'::33}  # Все ключи должны быть типа str\n\njson_obj.writeFile(tempers)\njson_obj.appendFile(tempers)\n\ntempers.update(tempers)\nassert tempers == json_obj.readFile()\n```\n\n---\n\n## PickleFile\n\nСначала создаем экземпляр класса `PickleFile` а потом работаем с его методами\n> Пример\n\n```python\npick_obj = PickleFile("test.pkl")\n```\n\n---\n-`writeFile( data: Any, *, protocol: int = 3)` = Записать данные в pkl\n\n---\n-`readFile()` = Чтение данных phl\n> Пример\n\n```python\ntest_data = [\n    (1, 2, 3, 4),\n    [12, 23, 221],\n    ["1231", 12, (2, 22)],\n    {213123, 123213},\n    {\'s1\': \'213\'},\n]\nfor td in test_data:\n    pick_obj.writeFile(td)\n    assert pick_obj.readFile() == td\n    pick_obj.deleteFile()\n```\n\n---\n-`appendFile(data:  Union[Tuple, List, Dict, Set], *, protocol: int = 3)` = Добавить данные в pkl\n> Пример\n\n```python\ntest_data = [1, 2, 3, 4]\nnew_data = [98, 678, 88]\npick_obj.writeFile(test_data)\npick_obj.appendFile(new_data)\ntest_data += new_data\nassert pick_obj.readFile() == test_data\n```\n\n---\n\n## SqlLiteQrm\n\n```python\nsq = SqlLiteQrm(\'data_base.db\')\n```\n\n---\n\n- `.name_db` = Получить имя БД\n\n---\n\n- `.header_table[]` = Получить заголовок таблиц из БД\n\n---\n> Пример\n\n```python\ntest_header = {"id": PrimaryKey(int),\n               "name": toTypeSql(str),\n               "old": NotNullDefault(int, 5),\n               "salary": NotNull(float)}\nsq.CreateTable(\'name_table\', test_header)\nassert sq.header_table[\'name_table\'] == {\'id\': \'INTEGER PRIMARY KEY\',\n                                         \'name\': \'TEXT\',\n                                         \'old\': \'INTEGER NOT NULL DEFAULT 5\',\n                                         \'salary\': \'REAL NOT NULL\'}\n```\n\n---\n\n- `ListTables()` = Получить имена всех таблиц в БД\n\n---\n\n- `HeadTable(NameTable, width_table: int = 10)` = Выводи в консоль данные о таблицы из БД. `NameTable` имя таблицы,\n  `width_table` ширина столбцов.\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\', {"id": toTypeSql(int), "name": toTypeSql(str), "old": toTypeSql(int)})\nprint(sq.HeadTable(\'name_table\', 15))\n```\n\n---\n\n- `GetTable(NameTable: str, LIMIT: Tuple[int, int] = None, FlagPrint: int = 0)` = Получить данные из таблицы в\n  БД. `LIMIT(до, шаг)`, `FlagPrint` Указывает печатать ли результат в консоль\n\n> Пример\n\n```python\ntest_header = {"id": PrimaryKey(int),\n               "name": toTypeSql(str),\n               "old": NotNullDefault(int, 5),\n               "salary": NotNull(float)}\nsq.CreateTable(\'name_table\', test_header)\nassert sq.header_table[\'name_table\'],\n{\'id\': \'INTEGER PRIMARY KEY\', \'name\': \'TEXT\', \'old\': \'INTEGER NOT NULL DEFAULT 5\',\n \'salary\': \'REAL NOT NULL\'})\nsq.ExecuteTable(\'name_table\', {"id": 1, "name": "Anton", "old": 30, "salary": 3000.11})\nsq.ExecuteTable(\'name_table\', {"id": 2, "name": "Katy", "old": 22, "salary": 3200.23})\nassert sq.GetTable(\'name_table\') == [(1, \'Anton\', 30, 3000.11), (2, \'Katy\', 22, 3200.23)]\n```  \n\n--- \n\n- `GetColumn(NameTable: str, name_columns: str, LIMIT: Tuple[int, int] = None)` = Получить данные из столбца таблицы в\n  БД\n\n> Пример\n\n```python\nsq.CreateTable(self.name_table,\n               {"id": PrimaryKeyAutoincrement(int), "name": toTypeSql(str), "old": toTypeSql(int),\n                "sex": NotNullDefault(str, "_")})\nsq.ExecuteManyTableDict(self.name_table,\n                        [{"name": "Denis", "old": 21},\n                         {"name": "Katy", "old": 21, "sex": 1},\n                         {"name": "Svetha", "old": 24}]\n                        )\nassert self.sq.GetColumn(self.name_table, "name") == [\'Denis\', \'Katy\', \'Svetha\']\nassert self.sq.GetColumn(self.name_table, "old") == [21, 21, 24]\nassert self.sq.GetColumn(self.name_table, "old", LIMIT=(2, 0)) == [21, 21]\n```\n\n---\n\n- `DeleteTable(NameTable: Union[str, List[str]])` = Удалить одну таблицу или несколько таблиц\n\n---\n\n- `DeleteLineTable(NameTable: str, sqlWHERE: str = "")` = Удалить строки по условию `WHERE`\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\',\n               {"id": PrimaryKeyAutoincrement(int), "name": toTypeSql(str), "old": toTypeSql(int),\n                "sex": NotNullDefault(str, "_")})\nsq.ExecuteManyTableDict(\'name_table\', [{"name": "Denis", "old": 21},\n                                       {"name": "Katy", "old": 221, "sex": 1},\n                                       {"name": "Mush", "old": 321, "sex": 21},\n                                       {"name": "Patio", "old": 231, "sex": 21},\n                                       {"name": "Pvetha", "old": 24}])\nsq.DeleteLineTable(\'name_table\', "old > 25")\nassert sq.GetTable(\'name_table\') == [(1, \'Denis\', 21, \'_\'), (5, \'Pvetha\', 24, \'_\')]\n```\n\n---\n\n- `CreateTable(NameTable: str, columns: Union[str, Dict])` = Создать таблицу с заголовками столбцов `columns`.\n  Используйте вспомогательные функции из `sqlmodules` для удобного создание sql запросов\n\n> Пример\n\n```python\n# Должны содержать уникальные значения\nPrimaryKey = lambda TypeColumn: definition(TypeColumn) + " PRIMARY KEY"\n# Всегда должно быть заполнено\nNotNull = lambda TypeColumn: definition(TypeColumn) + " NOT NULL"\n# Все столбцы будут по умолчанию заполнены указанными значениями\nNotNullDefault = lambda TypeColumn, default: definition(TypeColumn) + f" NOT NULL DEFAULT {default}"\n# Значение по умолчанию\nDefault = lambda TypeColumn, default: definition(TypeColumn) + " DEFAULT {0}".format(default)\n# Авто заполнение строки. подходит для id\nPrimaryKeyAutoincrement = lambda TypeColumn: definition(TypeColumn) + " PRIMARY KEY AUTOINCREMENT"\n# Конвертация  типа данных python в SQLLite\ntoTypeSql = lambda TypeColumn: definition(TypeColumn)\n```\n\n- `ExecuteTable(NameTable: str, data: Union[str, int, float, List[Union[str, bytes, int, float]], Tuple, Dict[str, Union[str, bytes, int, float]]] = None, sqlRequest: str = "", *, CheckBLOB: bool = False)`\n  = Добавить запись в таблицу из БД\n  `sqlRequest` вы можете добавить данные из sql запрос.`CheckBLOB` если вы записываете бинарные данные в таблицу\n  используйте этот флаг.\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\',\n               {"id": toTypeSql(int),\n                "old": toTypeSql(int)\n                })\ntest_table: str = \'test_table\'\nsq.CreateTable(test_table,\n               {"old": toTypeSql(int)})\n\nsq.ExecuteManyTable(\'name_table\',\n                    [[11, 24],\n                     [22, 31],\n                     [2312, 312],\n                     [231, 68],\n                     [344, 187]])\n\nresSQL = Select(\'name_table\', "id").Where("id < 30").Request\n\nsq.ExecuteTable(test_table, sqlRequest=resSQL)\n\nassert sq.GetTable(test_table) == [(11,), (22,)]\n```\n\n> Пример `CheckBLOB`\n\n```python\ntest_header = {"str": toTypeSql(str), "int": toTypeSql(int), "float": toTypeSql(float),\n               "bytes": toTypeSql(bytes)}\nsq.CreateTable(\'name_table\', test_header)\ntest_data = ("text", 123, 122.32, b"1011")\nsq.ExecuteTable(\'name_table\', test_data, CheckBLOB=True)\nassert sq.GetTable(\'name_table\')[0] == test_data\n```            \n\n- `ExecuteManyTable(NameTable: str, data: List[Union[List[Union[str, bytes, Binary, int, float]], Tuple]], head_data: Union[List[str], Tuple] = None, *, CheckBLOB: bool = False)`\n  = Добавить несколько записей в таблицу в формате List. `head_data` указывать когда длинна входных данных меньше чем\n  количество столбцов в таблице\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\', {\n    \'car_id\': PrimaryKeyAutoincrement(int),\n    "model": toTypeSql(str),\n    "price": toTypeSql(int)\n})\n\ncar = [\n    ("Audi", 432),\n    ("Maer", 424),\n    ("Skoda", 122)\n]\nsq.ExecuteManyTable(\'name_table\', car, head_data=("model", "price"))\nassert sq.GetTable(\'name_table\') == [(1, \'Audi\', 432), (2, \'Maer\', 424), (3, \'Skoda\', 122)]\n```\n\n- `ExecuteManyTableDict(NameTable: str, data: List[Dict])` = Добавить несколько записей в таблицу в формате Dict\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\',\n               {"id": PrimaryKeyAutoincrement(int), "name": toTypeSql(str), "old": toTypeSql(int),\n                "sex": NotNullDefault(str, "_")})\nsq.ExecuteManyTableDict(\'name_table\',\n                        [{"name": "Denis", "old": 21},\n                         {"name": "Katy", "old": 21, "sex": 1},\n                         {"name": "Svetha", "old": 24}]\n                        )\nassert sq.Search(Select(\'name_table\', "name").Where("old == 21")) == [(\'Denis\',), (\'Katy\',)]\n```\n\n- `UpdateColumne(NameTable: str, name_column: Union[str, List[str]], new_data: Union[str, bytes, int, float, List[Union[str, bytes, int, float]]], sqlWHERE: str = "")`\n  = Обновить данные в столбцах таблицы по условию `sqlWHERE`\n\n> Пример\n\n```python\nsq.CreateTable(\'name_table\',\n               {"id": PrimaryKeyAutoincrement(int), "name": toTypeSql(str), "old": toTypeSql(int),\n                "sex": NotNullDefault(str, "_")})\nsq.ExecuteManyTableDict(\'name_table\', [{"name": "Denis", "old": 21},\n                                       {"name": "Katy", "old": 221, "sex": 1},\n                                       {"name": "Mush", "old": 321, "sex": 21},\n                                       {"name": "Patio", "old": 231, "sex": 21},\n                                       {"name": "Svetha", "old": 24}])\n\nsq.UpdateColumne(\'name_table\', \'old\', 99)\nassert sq.GetTable(\'name_table\') == [(1, \'Denis\', 99, \'_\'),\n                                     (2, \'Katy\', 99, \'1\'),\n                                     (3, \'Mush\', 99, \'21\'),\n                                     (4, \'Patio\', 99, \'21\'),\n                                     (5, \'Svetha\', 99, \'_\')]\n```\n\n- `Search` = Поиск данных в таблице\n- `SaveDbToFile` = Сохранить БД в отдельный\n- `ReadFileToDb`\n- `DeleteDb` \n\n\n\n\n\n\n\n\n\n',
    'author': 'Ваше Имя',
    'author_email': 'denis-kustov@rambler.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/denisxab/mg_file',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
