# mypy-boto3-ce

[![PyPI - mypy-boto3-ce](https://img.shields.io/pypi/v/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CostExplorer 1.14.23](https://boto3.amazonaws.com/v1/documentation/api/1.14.23/reference/services/ce.html#CostExplorer) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CostExplorer` service.

```bash
python -m pip install boto3-stubs[ce]
```

## How to use

### Client annotations

`CostExplorerClient` provides annotations for `boto3.client("ce")`.

```python
import boto3

from mypy_boto3_ce import CostExplorerClient
from mypy_boto3_ce.type_defs import CostCategoryReferenceTypeDef, ...

client: CostExplorerClient = boto3.client("ce")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CostExplorerClient = session.client("ce")
```








### Typed dictionations

`mypy_boto3_ce.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> CostCategoryReferenceTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_ce` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("ce")

session_client = boto3.Session().client("ce")
```
