# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src', 'cattrs': 'src/cattrs', 'cattrs.preconf': 'src/cattrs/preconf'}

packages = \
['cattr', 'cattr.preconf', 'cattrs', 'cattrs.preconf']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=20']

extras_require = \
{':python_version < "3.11"': ['exceptiongroup'],
 ':python_version < "3.8"': ['typing_extensions']}

setup_kwargs = {
    'name': 'cattrs',
    'version': '22.2.0',
    'description': 'Composable complex class support for attrs and dataclasses.',
    'long_description': '======\ncattrs\n======\n\n\n.. image:: https://img.shields.io/pypi/v/cattrs.svg\n        :target: https://pypi.python.org/pypi/cattrs\n\n.. image:: https://github.com/python-attrs/cattrs/workflows/CI/badge.svg\n        :target: https://github.com/python-attrs/cattrs/actions?workflow=CI\n\n.. image:: https://readthedocs.org/projects/cattrs/badge/?version=latest\n        :target: https://cattrs.readthedocs.io/en/latest/?badge=latest\n        :alt: Documentation Status\n\n.. image:: https://img.shields.io/pypi/pyversions/cattrs.svg\n        :target: https://github.com/python-attrs/cattrs\n        :alt: Supported Python versions\n\n.. image:: https://codecov.io/gh/python-attrs/cattrs/branch/master/graph/badge.svg\n        :target: https://codecov.io/gh/python-attrs/cattrs/\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/ambv/black\n\n\n----\n\n``cattrs`` is an open source Python library for structuring and unstructuring\ndata. ``cattrs`` works best with ``attrs`` classes, dataclasses and the usual\nPython collections, but other kinds of classes are supported by manually\nregistering converters.\n\nPython has a rich set of powerful, easy to use, built-in data types like\ndictionaries, lists and tuples. These data types are also the lingua franca\nof most data serialization libraries, for formats like json, msgpack, yaml or\ntoml.\n\nData types like this, and mappings like ``dict`` s in particular, represent\nunstructured data. Your data is, in all likelihood, structured: not all\ncombinations of field names or values are valid inputs to your programs. In\nPython, structured data is better represented with classes and enumerations.\n``attrs`` is an excellent library for declaratively describing the structure of\nyour data, and validating it.\n\nWhen you\'re handed unstructured data (by your network, file system, database...),\n``cattrs`` helps to convert this data into structured data. When you have to\nconvert your structured data into data types other libraries can handle,\n``cattrs`` turns your classes and enumerations into dictionaries, integers and\nstrings.\n\nHere\'s a simple taste. The list containing a float, an int and a string\ngets converted into a tuple of three ints.\n\n.. code-block:: pycon\n\n    >>> import cattrs\n    >>>\n    >>> cattrs.structure([1.0, 2, "3"], tuple[int, int, int])\n    (1, 2, 3)\n\n``cattrs`` works well with ``attrs`` classes out of the box.\n\n.. code-block:: pycon\n\n    >>> from attrs import frozen\n    >>> import cattrs\n    >>>\n    >>> @frozen  # It works with non-frozen classes too.\n    ... class C:\n    ...     a: int\n    ...     b: str\n    ...\n    >>> instance = C(1, \'a\')\n    >>> cattrs.unstructure(instance)\n    {\'a\': 1, \'b\': \'a\'}\n    >>> cattrs.structure({\'a\': 1, \'b\': \'a\'}, C)\n    C(a=1, b=\'a\')\n\nHere\'s a much more complex example, involving ``attrs`` classes with type\nmetadata.\n\n.. code-block:: pycon\n\n    >>> from enum import unique, Enum\n    >>> from typing import Optional, Sequence, Union\n    >>> from cattrs import structure, unstructure\n    >>> from attrs import define, field\n    >>>\n    >>> @unique\n    ... class CatBreed(Enum):\n    ...     SIAMESE = "siamese"\n    ...     MAINE_COON = "maine_coon"\n    ...     SACRED_BIRMAN = "birman"\n    ...\n    >>> @define\n    ... class Cat:\n    ...     breed: CatBreed\n    ...     names: Sequence[str]\n    ...\n    >>> @define\n    ... class DogMicrochip:\n    ...     chip_id = field()  # Type annotations are optional, but recommended\n    ...     time_chipped: float = field()\n    ...\n    >>> @define\n    ... class Dog:\n    ...     cuteness: int\n    ...     chip: Optional[DogMicrochip] = None\n    ...\n    >>> p = unstructure([Dog(cuteness=1, chip=DogMicrochip(chip_id=1, time_chipped=10.0)),\n    ...                  Cat(breed=CatBreed.MAINE_COON, names=(\'Fluffly\', \'Fluffer\'))])\n    ...\n    >>> print(p)\n    [{\'cuteness\': 1, \'chip\': {\'chip_id\': 1, \'time_chipped\': 10.0}}, {\'breed\': \'maine_coon\', \'names\': (\'Fluffly\', \'Fluffer\')}]\n    >>> print(structure(p, list[Union[Dog, Cat]]))\n    [Dog(cuteness=1, chip=DogMicrochip(chip_id=1, time_chipped=10.0)), Cat(breed=<CatBreed.MAINE_COON: \'maine_coon\'>, names=[\'Fluffly\', \'Fluffer\'])]\n\nConsider unstructured data a low-level representation that needs to be converted\nto structured data to be handled, and use ``structure``. When you\'re done,\n``unstructure`` the data to its unstructured form and pass it along to another\nlibrary or module. Use `attrs type metadata <http://attrs.readthedocs.io/en/stable/examples.html#types>`_\nto add type metadata to attributes, so ``cattrs`` will know how to structure and\ndestructure them.\n\n* Free software: MIT license\n* Documentation: https://cattrs.readthedocs.io.\n* Python versions supported: 3.7 and up. (Older Python versions, like 2.7, 3.5 and 3.6 are supported by older versions; see the changelog.)\n\n\nFeatures\n--------\n\n* Converts structured data into unstructured data, recursively:\n\n  * ``attrs`` classes and dataclasses are converted into dictionaries in a way similar to ``attrs.asdict``, or into tuples in a way similar to ``attrs.astuple``.\n  * Enumeration instances are converted to their values.\n  * Other types are let through without conversion. This includes types such as\n    integers, dictionaries, lists and instances of non-``attrs`` classes.\n  * Custom converters for any type can be registered using ``register_unstructure_hook``.\n\n* Converts unstructured data into structured data, recursively, according to\n  your specification given as a type. The following types are supported:\n\n  * ``typing.Optional[T]``.\n  * ``typing.List[T]``, ``typing.MutableSequence[T]``, ``typing.Sequence[T]`` (converts to a list).\n  * ``typing.Tuple`` (both variants, ``Tuple[T, ...]`` and ``Tuple[X, Y, Z]``).\n  * ``typing.MutableSet[T]``, ``typing.Set[T]`` (converts to a set).\n  * ``typing.FrozenSet[T]`` (converts to a frozenset).\n  * ``typing.Dict[K, V]``, ``typing.MutableMapping[K, V]``, ``typing.Mapping[K, V]`` (converts to a dict).\n  * ``attrs`` classes with simple attributes and the usual ``__init__``.\n\n    * Simple attributes are attributes that can be assigned unstructured data,\n      like numbers, strings, and collections of unstructured data.\n\n  * All `attrs` classes and dataclasses with the usual ``__init__``, if their complex attributes have type metadata.\n  * ``typing.Union`` s of supported ``attrs`` classes, given that all of the classes have a unique field.\n  * ``typing.Union`` s of anything, given that you provide a disambiguation function for it.\n  * Custom converters for any type can be registered using ``register_structure_hook``.\n\n``cattrs`` comes with preconfigured converters for a number of serialization libraries, including json, msgpack, bson, yaml and toml.\nFor details, see the `cattr.preconf package <https://cattrs.readthedocs.io/en/latest/preconf.html>`_.\n\nAdditional documentation\n------------------------\n* `On structured and unstructured data, or the case for cattrs <https://threeofwands.com/on-structured-and-unstructured-data-or-the-case-for-cattrs/>`_\n* `Why I use attrs instead of pydantic <https://threeofwands.com/why-i-use-attrs-instead-of-pydantic/>`_\n* `cattrs I: un/structuring speed <https://threeofwands.com/why-cattrs-is-so-fast/>`_\n\nCredits\n-------\n\nMajor credits to Hynek Schlawack for creating attrs_ and its predecessor,\ncharacteristic_.\n\n``cattrs`` is tested with Hypothesis_, by David R. MacIver.\n\n``cattrs`` is benchmarked using perf_ and pytest-benchmark_.\n\nThis package was created with Cookiecutter_ and the `audreyr/cookiecutter-pypackage`_ project template.\n\n.. _attrs: https://github.com/hynek/attrs\n.. _characteristic: https://github.com/hynek/characteristic\n.. _Hypothesis: http://hypothesis.readthedocs.io/en/latest/\n.. _perf: https://github.com/haypo/perf\n.. _pytest-benchmark: https://pytest-benchmark.readthedocs.io/en/latest/index.html\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _`audreyr/cookiecutter-pypackage`: https://github.com/audreyr/cookiecutter-pypackage\n',
    'author': 'Tin Tvrtkovic',
    'author_email': 'tinchester@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/python-attrs/cattrs',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
