# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class LogAnalyticsOperations:
    """LogAnalyticsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.cdn.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def get_log_analytics_metrics(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[Union[str, "_models.Get4ItemsItem"]],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        granularity: Union[str, "_models.Enum31"],
        group_by: Optional[List[Union[str, "_models.Get8ItemsItem"]]] = None,
        continents: Optional[List[str]] = None,
        country_or_regions: Optional[List[str]] = None,
        custom_domains: Optional[List[str]] = None,
        protocols: Optional[List[str]] = None,
        **kwargs
    ) -> "_models.MetricsResponse":
        """Get log report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.Get4ItemsItem]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.Enum31
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.Get8ItemsItem]
        :param continents:
        :type continents: list[str]
        :param country_or_regions:
        :type country_or_regions: list[str]
        :param custom_domains:
        :type custom_domains: list[str]
        :param protocols:
        :type protocols: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.MetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.MetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_metrics.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = self._serialize.query("metrics", metrics, '[str]', div=',')
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['granularity'] = self._serialize.query("granularity", granularity, 'str')
        if group_by is not None:
            query_parameters['groupBy'] = self._serialize.query("group_by", group_by, '[str]', div=',')
        if continents is not None:
            query_parameters['continents'] = self._serialize.query("continents", continents, '[str]', div=',')
        if country_or_regions is not None:
            query_parameters['countryOrRegions'] = self._serialize.query("country_or_regions", country_or_regions, '[str]', div=',')
        if custom_domains is not None:
            query_parameters['customDomains'] = self._serialize.query("custom_domains", custom_domains, '[str]', div=',')
        if protocols is not None:
            query_parameters['protocols'] = self._serialize.query("protocols", protocols, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('MetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics'}  # type: ignore

    async def get_log_analytics_rankings(
        self,
        resource_group_name: str,
        profile_name: str,
        rankings: List[Union[str, "_models.Enum35"]],
        metrics: List[Union[str, "_models.Get5ItemsItem"]],
        max_ranking: float,
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        custom_domains: Optional[List[str]] = None,
        **kwargs
    ) -> "_models.RankingsResponse":
        """Get log analytics ranking report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.Enum35]
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.Get5ItemsItem]
        :param max_ranking:
        :type max_ranking: float
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param custom_domains:
        :type custom_domains: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.RankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_rankings.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['rankings'] = self._serialize.query("rankings", rankings, '[str]', div=',')
        query_parameters['metrics'] = self._serialize.query("metrics", metrics, '[str]', div=',')
        query_parameters['maxRanking'] = self._serialize.query("max_ranking", max_ranking, 'float')
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        if custom_domains is not None:
            query_parameters['customDomains'] = self._serialize.query("custom_domains", custom_domains, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings'}  # type: ignore

    async def get_log_analytics_locations(
        self,
        resource_group_name: str,
        profile_name: str,
        **kwargs
    ) -> "_models.ContinentsResponse":
        """Get all available location names for AFD log analytics report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContinentsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ContinentsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ContinentsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_locations.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ContinentsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_locations.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations'}  # type: ignore

    async def get_log_analytics_resources(
        self,
        resource_group_name: str,
        profile_name: str,
        **kwargs
    ) -> "_models.ResourcesResponse":
        """Get all endpoints and custom domains available for AFD log report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourcesResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ResourcesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourcesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_resources.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ResourcesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_resources.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources'}  # type: ignore

    async def get_waf_log_analytics_metrics(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[str],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        granularity: Union[str, "_models.Enum37"],
        actions: Optional[List[Union[str, "_models.Enum38"]]] = None,
        group_by: Optional[List[Union[str, "_models.Enum39"]]] = None,
        rule_types: Optional[List[Union[str, "_models.Enum40"]]] = None,
        **kwargs
    ) -> "_models.WafMetricsResponse":
        """Get Waf related log analytics report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.Enum37
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.Enum38]
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.Enum39]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.Enum40]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafMetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafMetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafMetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_waf_log_analytics_metrics.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = self._serialize.query("metrics", metrics, '[str]', div=',')
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['granularity'] = self._serialize.query("granularity", granularity, 'str')
        if actions is not None:
            query_parameters['actions'] = self._serialize.query("actions", actions, '[str]', div=',')
        if group_by is not None:
            query_parameters['groupBy'] = self._serialize.query("group_by", group_by, '[str]', div=',')
        if rule_types is not None:
            query_parameters['ruleTypes'] = self._serialize.query("rule_types", rule_types, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafMetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_waf_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics'}  # type: ignore

    async def get_waf_log_analytics_rankings(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[str],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        max_ranking: float,
        rankings: List[Union[str, "_models.Enum42"]],
        actions: Optional[List[Union[str, "_models.Enum43"]]] = None,
        rule_types: Optional[List[Union[str, "_models.Enum44"]]] = None,
        **kwargs
    ) -> "_models.WafRankingsResponse":
        """Get WAF log analytics charts for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param max_ranking:
        :type max_ranking: float
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.Enum42]
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.Enum43]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.Enum44]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafRankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafRankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafRankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_waf_log_analytics_rankings.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = self._serialize.query("metrics", metrics, '[str]', div=',')
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['maxRanking'] = self._serialize.query("max_ranking", max_ranking, 'float')
        query_parameters['rankings'] = self._serialize.query("rankings", rankings, '[str]', div=',')
        if actions is not None:
            query_parameters['actions'] = self._serialize.query("actions", actions, '[str]', div=',')
        if rule_types is not None:
            query_parameters['ruleTypes'] = self._serialize.query("rule_types", rule_types, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafRankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_waf_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings'}  # type: ignore
