# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, archived=None, default_branch=None, description=None, http_url_to_repo=None, id=None, issues_enabled=None, lfs_enabled=None, merge_requests_enabled=None, name=None, namespace_id=None, path=None, pipelines_enabled=None, remove_source_branch_after_merge=None, request_access_enabled=None, runners_token=None, snippets_enabled=None, ssh_url_to_repo=None, visibility_level=None, web_url=None, wiki_enabled=None):
        if archived and not isinstance(archived, bool):
            raise TypeError("Expected argument 'archived' to be a bool")
        __self__.archived = archived
        """
        Whether the project is in read-only mode (archived).
        """
        if default_branch and not isinstance(default_branch, str):
            raise TypeError("Expected argument 'default_branch' to be a str")
        __self__.default_branch = default_branch
        """
        The default branch for the project.
        """
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        __self__.description = description
        """
        A description of the project.
        """
        if http_url_to_repo and not isinstance(http_url_to_repo, str):
            raise TypeError("Expected argument 'http_url_to_repo' to be a str")
        __self__.http_url_to_repo = http_url_to_repo
        """
        URL that can be provided to `git clone` to clone the
        repository via HTTP.
        """
        if id and not isinstance(id, float):
            raise TypeError("Expected argument 'id' to be a float")
        __self__.id = id
        """
        Integer that uniquely identifies the project within the gitlab install.
        """
        if issues_enabled and not isinstance(issues_enabled, bool):
            raise TypeError("Expected argument 'issues_enabled' to be a bool")
        __self__.issues_enabled = issues_enabled
        """
        Enable issue tracking for the project.
        """
        if lfs_enabled and not isinstance(lfs_enabled, bool):
            raise TypeError("Expected argument 'lfs_enabled' to be a bool")
        __self__.lfs_enabled = lfs_enabled
        """
        Enable LFS for the project.
        """
        if merge_requests_enabled and not isinstance(merge_requests_enabled, bool):
            raise TypeError("Expected argument 'merge_requests_enabled' to be a bool")
        __self__.merge_requests_enabled = merge_requests_enabled
        """
        Enable merge requests for the project.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        if namespace_id and not isinstance(namespace_id, float):
            raise TypeError("Expected argument 'namespace_id' to be a float")
        __self__.namespace_id = namespace_id
        """
        The namespace (group or user) of the project. Defaults to your user.
        See `Group` for an example.
        """
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        __self__.path = path
        """
        The path of the repository.
        """
        if pipelines_enabled and not isinstance(pipelines_enabled, bool):
            raise TypeError("Expected argument 'pipelines_enabled' to be a bool")
        __self__.pipelines_enabled = pipelines_enabled
        """
        Enable pipelines for the project.
        """
        if remove_source_branch_after_merge and not isinstance(remove_source_branch_after_merge, bool):
            raise TypeError("Expected argument 'remove_source_branch_after_merge' to be a bool")
        __self__.remove_source_branch_after_merge = remove_source_branch_after_merge
        """
        Enable `Delete source branch` option by default for all new merge requests
        """
        if request_access_enabled and not isinstance(request_access_enabled, bool):
            raise TypeError("Expected argument 'request_access_enabled' to be a bool")
        __self__.request_access_enabled = request_access_enabled
        """
        Allow users to request member access.
        """
        if runners_token and not isinstance(runners_token, str):
            raise TypeError("Expected argument 'runners_token' to be a str")
        __self__.runners_token = runners_token
        """
        Registration token to use during runner setup.
        """
        if snippets_enabled and not isinstance(snippets_enabled, bool):
            raise TypeError("Expected argument 'snippets_enabled' to be a bool")
        __self__.snippets_enabled = snippets_enabled
        """
        Enable snippets for the project.
        """
        if ssh_url_to_repo and not isinstance(ssh_url_to_repo, str):
            raise TypeError("Expected argument 'ssh_url_to_repo' to be a str")
        __self__.ssh_url_to_repo = ssh_url_to_repo
        """
        URL that can be provided to `git clone` to clone the
        repository via SSH.
        """
        if visibility_level and not isinstance(visibility_level, str):
            raise TypeError("Expected argument 'visibility_level' to be a str")
        __self__.visibility_level = visibility_level
        """
        Repositories are created as private by default.
        """
        if web_url and not isinstance(web_url, str):
            raise TypeError("Expected argument 'web_url' to be a str")
        __self__.web_url = web_url
        """
        URL that can be used to find the project in a browser.
        """
        if wiki_enabled and not isinstance(wiki_enabled, bool):
            raise TypeError("Expected argument 'wiki_enabled' to be a bool")
        __self__.wiki_enabled = wiki_enabled
        """
        Enable wiki for the project.
        """
class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            archived=self.archived,
            default_branch=self.default_branch,
            description=self.description,
            http_url_to_repo=self.http_url_to_repo,
            id=self.id,
            issues_enabled=self.issues_enabled,
            lfs_enabled=self.lfs_enabled,
            merge_requests_enabled=self.merge_requests_enabled,
            name=self.name,
            namespace_id=self.namespace_id,
            path=self.path,
            pipelines_enabled=self.pipelines_enabled,
            remove_source_branch_after_merge=self.remove_source_branch_after_merge,
            request_access_enabled=self.request_access_enabled,
            runners_token=self.runners_token,
            snippets_enabled=self.snippets_enabled,
            ssh_url_to_repo=self.ssh_url_to_repo,
            visibility_level=self.visibility_level,
            web_url=self.web_url,
            wiki_enabled=self.wiki_enabled)

def get_project(archived=None,default_branch=None,description=None,http_url_to_repo=None,id=None,issues_enabled=None,lfs_enabled=None,merge_requests_enabled=None,name=None,namespace_id=None,path=None,pipelines_enabled=None,remove_source_branch_after_merge=None,request_access_enabled=None,runners_token=None,snippets_enabled=None,ssh_url_to_repo=None,visibility_level=None,web_url=None,wiki_enabled=None,opts=None):
    """
    Provides details about a specific project in the gitlab provider. The results include the name of the project, path, description, default branch, etc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_project(id=30)
    ```


    :param bool archived: Whether the project is in read-only mode (archived).
    :param str default_branch: The default branch for the project.
    :param str description: A description of the project.
    :param str http_url_to_repo: URL that can be provided to `git clone` to clone the
           repository via HTTP.
    :param float id: The integer that uniquely identifies the project within the gitlab install.
    :param bool issues_enabled: Enable issue tracking for the project.
    :param bool lfs_enabled: Enable LFS for the project.
    :param bool merge_requests_enabled: Enable merge requests for the project.
    :param float namespace_id: The namespace (group or user) of the project. Defaults to your user.
           See `Group` for an example.
    :param str path: The path of the repository.
    :param bool pipelines_enabled: Enable pipelines for the project.
    :param bool remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests
    :param bool request_access_enabled: Allow users to request member access.
    :param str runners_token: Registration token to use during runner setup.
    :param bool snippets_enabled: Enable snippets for the project.
    :param str ssh_url_to_repo: URL that can be provided to `git clone` to clone the
           repository via SSH.
    :param str visibility_level: Repositories are created as private by default.
    :param str web_url: URL that can be used to find the project in a browser.
    :param bool wiki_enabled: Enable wiki for the project.
    """
    __args__ = dict()


    __args__['archived'] = archived
    __args__['defaultBranch'] = default_branch
    __args__['description'] = description
    __args__['httpUrlToRepo'] = http_url_to_repo
    __args__['id'] = id
    __args__['issuesEnabled'] = issues_enabled
    __args__['lfsEnabled'] = lfs_enabled
    __args__['mergeRequestsEnabled'] = merge_requests_enabled
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['path'] = path
    __args__['pipelinesEnabled'] = pipelines_enabled
    __args__['removeSourceBranchAfterMerge'] = remove_source_branch_after_merge
    __args__['requestAccessEnabled'] = request_access_enabled
    __args__['runnersToken'] = runners_token
    __args__['snippetsEnabled'] = snippets_enabled
    __args__['sshUrlToRepo'] = ssh_url_to_repo
    __args__['visibilityLevel'] = visibility_level
    __args__['webUrl'] = web_url
    __args__['wikiEnabled'] = wiki_enabled
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProject:getProject', __args__, opts=opts).value

    return AwaitableGetProjectResult(
        archived=__ret__.get('archived'),
        default_branch=__ret__.get('defaultBranch'),
        description=__ret__.get('description'),
        http_url_to_repo=__ret__.get('httpUrlToRepo'),
        id=__ret__.get('id'),
        issues_enabled=__ret__.get('issuesEnabled'),
        lfs_enabled=__ret__.get('lfsEnabled'),
        merge_requests_enabled=__ret__.get('mergeRequestsEnabled'),
        name=__ret__.get('name'),
        namespace_id=__ret__.get('namespaceId'),
        path=__ret__.get('path'),
        pipelines_enabled=__ret__.get('pipelinesEnabled'),
        remove_source_branch_after_merge=__ret__.get('removeSourceBranchAfterMerge'),
        request_access_enabled=__ret__.get('requestAccessEnabled'),
        runners_token=__ret__.get('runnersToken'),
        snippets_enabled=__ret__.get('snippetsEnabled'),
        ssh_url_to_repo=__ret__.get('sshUrlToRepo'),
        visibility_level=__ret__.get('visibilityLevel'),
        web_url=__ret__.get('webUrl'),
        wiki_enabled=__ret__.get('wikiEnabled'))
