# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables


class ProjectPushRules(pulumi.CustomResource):
    author_email_regex: pulumi.Output[str]
    """
    All commit author emails must match this regex, e.g. "@my-company.com$"
    """
    branch_name_regex: pulumi.Output[str]
    """
    All branch names must match this regex, e.g. "(feature|hotfix)\/*"
    """
    commit_message_regex: pulumi.Output[str]
    """
    All commit messages must match this regex, e.g. "Fixed \d+\..*"
    """
    deny_delete_tag: pulumi.Output[bool]
    """
    Deny deleting a tag
    """
    file_name_regex: pulumi.Output[str]
    """
    All commited filenames must not match this regex, e.g. "(jar|exe)$"
    """
    max_file_size: pulumi.Output[float]
    """
    Maximum file size (MB)
    """
    member_check: pulumi.Output[bool]
    """
    Restrict commits by author (email) to existing GitLab users
    """
    prevent_secrets: pulumi.Output[bool]
    """
    GitLab will reject any files that are likely to contain secrets
    """
    project: pulumi.Output[str]
    """
    The name or id of the project to add the push rules to.
    """
    def __init__(__self__, resource_name, opts=None, author_email_regex=None, branch_name_regex=None, commit_message_regex=None, deny_delete_tag=None, file_name_regex=None, max_file_size=None, member_check=None, prevent_secrets=None, project=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to create and manage push rules for your GitLab projects.
        For further information on push rules, consult the [gitlab
        documentation](https://docs.gitlab.com/ce/push_rules/push_rules.html#push-rules).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. "@my-company.com$"
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. "(feature|hotfix)\/*"
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. "Fixed \d+\..*"
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag
        :param pulumi.Input[str] file_name_regex: All commited filenames must not match this regex, e.g. "(jar|exe)$"
        :param pulumi.Input[float] max_file_size: Maximum file size (MB)
        :param pulumi.Input[bool] member_check: Restrict commits by author (email) to existing GitLab users
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets
        :param pulumi.Input[str] project: The name or id of the project to add the push rules to.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['author_email_regex'] = author_email_regex
            __props__['branch_name_regex'] = branch_name_regex
            __props__['commit_message_regex'] = commit_message_regex
            __props__['deny_delete_tag'] = deny_delete_tag
            __props__['file_name_regex'] = file_name_regex
            __props__['max_file_size'] = max_file_size
            __props__['member_check'] = member_check
            __props__['prevent_secrets'] = prevent_secrets
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
        super(ProjectPushRules, __self__).__init__(
            'gitlab:index/projectPushRules:ProjectPushRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, author_email_regex=None, branch_name_regex=None, commit_message_regex=None, deny_delete_tag=None, file_name_regex=None, max_file_size=None, member_check=None, prevent_secrets=None, project=None):
        """
        Get an existing ProjectPushRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. "@my-company.com$"
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. "(feature|hotfix)\/*"
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. "Fixed \d+\..*"
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag
        :param pulumi.Input[str] file_name_regex: All commited filenames must not match this regex, e.g. "(jar|exe)$"
        :param pulumi.Input[float] max_file_size: Maximum file size (MB)
        :param pulumi.Input[bool] member_check: Restrict commits by author (email) to existing GitLab users
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets
        :param pulumi.Input[str] project: The name or id of the project to add the push rules to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["author_email_regex"] = author_email_regex
        __props__["branch_name_regex"] = branch_name_regex
        __props__["commit_message_regex"] = commit_message_regex
        __props__["deny_delete_tag"] = deny_delete_tag
        __props__["file_name_regex"] = file_name_regex
        __props__["max_file_size"] = max_file_size
        __props__["member_check"] = member_check
        __props__["prevent_secrets"] = prevent_secrets
        __props__["project"] = project
        return ProjectPushRules(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
