# -*- coding: utf-8 -*-
# BioSTEAM: The Biorefinery Simulation and Techno-Economic Analysis Modules
# Copyright (C) 2020-2021, Yoel Cortes-Pena <yoelcortes@gmail.com>
# 
# This module is under the UIUC open-source license. See 
# github.com/BioSTEAMDevelopmentGroup/biosteam/blob/master/LICENSE.txt
# for license details.
"""
"""
# DO NOT DELETE:
# chemicals' numba feature does not offer any benefit to speed
# but it may be used later
# def use_numba_chemicals():
#     import chemicals
#     import chemicals.numba as numba
#     Module = type(chemicals)
#     def update_module(module, other):
#         dct = module.__dict__
#         isa = isinstance
#         for i, j in other.__dict__.items():
#             if i[:2] != '__'  and i in dct:
#                 if isa(j, Module) and 'chemicals.' in j.__name__:
#                     update_module(dct[i], j)
#                 else:
#                     dct[i] = j
#     update_module(chemicals, numba)
# use_numba_chemicals()
# del use_numba_chemicals

from . import (constants,
               base,
               utils,
               chemicals,
               exceptions,
               functional,
               units_of_measure,
               separations,
               functors,
)
from ._chemical import Chemical
from ._chemicals import Chemicals, CompiledChemicals
from ._thermal_condition import ThermalCondition
from . import mixture
from .mixture import Mixture
from ._thermo import Thermo
from ._settings import settings
from ._thermo_data import ThermoData
from . import (indexer,
               reaction,
               equilibrium
)
from ._stream import Stream
from ._multi_stream import MultiStream
from .base import functor
from .reaction import *

__all__ = ('Chemical', 'Chemicals', 'CompiledChemicals', 'Mixture', 'Thermo', 'Stream',
           'MultiStream', 'ThermalCondition', 'mixture', 'ThermoData',
           *reaction.__all__, 'indexer', 'settings', 'functor', 'functors', 
           'chemicals', 'base', 'equilibrium', 'units_of_measure', 'exceptions',
           'functional', 'reaction', 'constants', 'utils', 'separations')

def speed_up():
    from warnings import warn
    warning = DeprecationWarning(
        "this function is deprecated; all functions are now automatically JIT "
        "compiled by numba when the libray is loaded"
    )
    warn(warning)

# Set number of digits displayed
import numpy as np
import pandas as pd
np.set_printoptions(suppress=False)
np.set_printoptions(precision=3) 
pd.options.display.float_format = '{:.3g}'.format
pd.set_option('display.max_rows', 35)
pd.set_option('display.max_columns', 10)
pd.set_option('max_colwidth', 35)
del np, pd

__version__ = "0.26.0"
