# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CustomCertificateArgs', 'CustomCertificate']

@pulumi.input_type
class CustomCertificateArgs:
    def __init__(__self__, *,
                 ca: pulumi.Input[_builtins.str],
                 cert: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.int],
                 private_key: pulumi.Input[_builtins.str],
                 sni_hosts: pulumi.Input[_builtins.str],
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a CustomCertificate resource.
        :param pulumi.Input[_builtins.str] ca: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded Certificate Authority (CA).
        :param pulumi.Input[_builtins.str] cert: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded server certificate.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] private_key: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded private key corresponding to the certificate.
        :param pulumi.Input[_builtins.str] sni_hosts: A hostname (Server Name Indication) that this certificate applies to.
        :param pulumi.Input[_builtins.str] key_id: A string based argument to trigger force new (default: "").
        :param pulumi.Input[_builtins.int] version: An integer based argument to trigger force new (default: 1).
        """
        pulumi.set(__self__, "ca", ca)
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "sni_hosts", sni_hosts)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def ca(self) -> pulumi.Input[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded Certificate Authority (CA).
        """
        return pulumi.get(self, "ca")

    @ca.setter
    def ca(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ca", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Input[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded server certificate.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded private key corresponding to the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="sniHosts")
    def sni_hosts(self) -> pulumi.Input[_builtins.str]:
        """
        A hostname (Server Name Indication) that this certificate applies to.
        """
        return pulumi.get(self, "sni_hosts")

    @sni_hosts.setter
    def sni_hosts(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sni_hosts", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string based argument to trigger force new (default: "").
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer based argument to trigger force new (default: 1).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _CustomCertificateState:
    def __init__(__self__, *,
                 ca: Optional[pulumi.Input[_builtins.str]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_hosts: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CustomCertificate resources.
        :param pulumi.Input[_builtins.str] ca: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded Certificate Authority (CA).
        :param pulumi.Input[_builtins.str] cert: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded server certificate.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] key_id: A string based argument to trigger force new (default: "").
        :param pulumi.Input[_builtins.str] private_key: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded private key corresponding to the certificate.
        :param pulumi.Input[_builtins.str] sni_hosts: A hostname (Server Name Indication) that this certificate applies to.
        :param pulumi.Input[_builtins.int] version: An integer based argument to trigger force new (default: 1).
        """
        if ca is not None:
            pulumi.set(__self__, "ca", ca)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if sni_hosts is not None:
            pulumi.set(__self__, "sni_hosts", sni_hosts)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded Certificate Authority (CA).
        """
        return pulumi.get(self, "ca")

    @ca.setter
    def ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded server certificate.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string based argument to trigger force new (default: "").
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded private key corresponding to the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="sniHosts")
    def sni_hosts(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A hostname (Server Name Indication) that this certificate applies to.
        """
        return pulumi.get(self, "sni_hosts")

    @sni_hosts.setter
    def sni_hosts(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_hosts", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer based argument to trigger force new (default: 1).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("cloudamqp:index/customCertificate:CustomCertificate")
class CustomCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca: Optional[pulumi.Input[_builtins.str]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_hosts: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource allows you to upload a custom certificate to all servers in your cluster. Update is
        not supported, all changes require replacement. `ca`, `cert` and `private_key` all use **WriteOnly**,
        meaning no information is present in plan phase, logs or stored in the state for security purposes.

        > **WARNING:** Please note that when uploading a custom certificate or restoring to default certificate,
        all current connections will be closed.

        > **Note:** Destroying this resource will restore the cluster to use the default CloudAMQP certificate.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ca: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded Certificate Authority (CA).
        :param pulumi.Input[_builtins.str] cert: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded server certificate.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] key_id: A string based argument to trigger force new (default: "").
        :param pulumi.Input[_builtins.str] private_key: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded private key corresponding to the certificate.
        :param pulumi.Input[_builtins.str] sni_hosts: A hostname (Server Name Indication) that this certificate applies to.
        :param pulumi.Input[_builtins.int] version: An integer based argument to trigger force new (default: 1).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to upload a custom certificate to all servers in your cluster. Update is
        not supported, all changes require replacement. `ca`, `cert` and `private_key` all use **WriteOnly**,
        meaning no information is present in plan phase, logs or stored in the state for security purposes.

        > **WARNING:** Please note that when uploading a custom certificate or restoring to default certificate,
        all current connections will be closed.

        > **Note:** Destroying this resource will restore the cluster to use the default CloudAMQP certificate.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        :param str resource_name: The name of the resource.
        :param CustomCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca: Optional[pulumi.Input[_builtins.str]] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_hosts: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomCertificateArgs.__new__(CustomCertificateArgs)

            if ca is None and not opts.urn:
                raise TypeError("Missing required property 'ca'")
            __props__.__dict__["ca"] = None if ca is None else pulumi.Output.secret(ca)
            if cert is None and not opts.urn:
                raise TypeError("Missing required property 'cert'")
            __props__.__dict__["cert"] = None if cert is None else pulumi.Output.secret(cert)
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["key_id"] = key_id
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if sni_hosts is None and not opts.urn:
                raise TypeError("Missing required property 'sni_hosts'")
            __props__.__dict__["sni_hosts"] = sni_hosts
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["ca", "cert", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CustomCertificate, __self__).__init__(
            'cloudamqp:index/customCertificate:CustomCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca: Optional[pulumi.Input[_builtins.str]] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            sni_hosts: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CustomCertificate':
        """
        Get an existing CustomCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ca: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded Certificate Authority (CA).
        :param pulumi.Input[_builtins.str] cert: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded server certificate.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] key_id: A string based argument to trigger force new (default: "").
        :param pulumi.Input[_builtins.str] private_key: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The PEM-encoded private key corresponding to the certificate.
        :param pulumi.Input[_builtins.str] sni_hosts: A hostname (Server Name Indication) that this certificate applies to.
        :param pulumi.Input[_builtins.int] version: An integer based argument to trigger force new (default: 1).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomCertificateState.__new__(_CustomCertificateState)

        __props__.__dict__["ca"] = ca
        __props__.__dict__["cert"] = cert
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["sni_hosts"] = sni_hosts
        __props__.__dict__["version"] = version
        return CustomCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ca(self) -> pulumi.Output[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded Certificate Authority (CA).
        """
        return pulumi.get(self, "ca")

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded server certificate.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        A string based argument to trigger force new (default: "").
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The PEM-encoded private key corresponding to the certificate.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="sniHosts")
    def sni_hosts(self) -> pulumi.Output[_builtins.str]:
        """
        A hostname (Server Name Indication) that this certificate applies to.
        """
        return pulumi.get(self, "sni_hosts")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        An integer based argument to trigger force new (default: 1).
        """
        return pulumi.get(self, "version")

