# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExtraDiskSizeArgs', 'ExtraDiskSize']

@pulumi.input_type
class ExtraDiskSizeArgs:
    def __init__(__self__, *,
                 extra_disk_size: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.int],
                 allow_downtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ExtraDiskSize resource.
        :param pulumi.Input[_builtins.int] extra_disk_size: Extra disk size in GB. Supported values: 0, 25, 50, 100,
               250, 500, 1000, 2000
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.bool] allow_downtime: When resizing the disk, allow cluster downtime if necessary.
               Default set to false.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for resizing the
               disk. Default set to 30 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for resizing the disk. Default
               set to 1800 seconds.
               
               ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        pulumi.set(__self__, "extra_disk_size", extra_disk_size)
        pulumi.set(__self__, "instance_id", instance_id)
        if allow_downtime is not None:
            pulumi.set(__self__, "allow_downtime", allow_downtime)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> pulumi.Input[_builtins.int]:
        """
        Extra disk size in GB. Supported values: 0, 25, 50, 100,
        250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @extra_disk_size.setter
    def extra_disk_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "extra_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="allowDowntime")
    def allow_downtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When resizing the disk, allow cluster downtime if necessary.
        Default set to false.
        """
        return pulumi.get(self, "allow_downtime")

    @allow_downtime.setter
    def allow_downtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_downtime", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for resizing the
        disk. Default set to 30 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for resizing the disk. Default
        set to 1800 seconds.

        ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _ExtraDiskSizeState:
    def __init__(__self__, *,
                 allow_downtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ExtraDiskSizeNodeArgs']]]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ExtraDiskSize resources.
        :param pulumi.Input[_builtins.bool] allow_downtime: When resizing the disk, allow cluster downtime if necessary.
               Default set to false.
        :param pulumi.Input[_builtins.int] extra_disk_size: Extra disk size in GB. Supported values: 0, 25, 50, 100,
               250, 500, 1000, 2000
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[Sequence[pulumi.Input['ExtraDiskSizeNodeArgs']]] nodes: An array of node information. Each `nodes` block consists of the fields documented below.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for resizing the
               disk. Default set to 30 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for resizing the disk. Default
               set to 1800 seconds.
               
               ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        if allow_downtime is not None:
            pulumi.set(__self__, "allow_downtime", allow_downtime)
        if extra_disk_size is not None:
            pulumi.set(__self__, "extra_disk_size", extra_disk_size)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="allowDowntime")
    def allow_downtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When resizing the disk, allow cluster downtime if necessary.
        Default set to false.
        """
        return pulumi.get(self, "allow_downtime")

    @allow_downtime.setter
    def allow_downtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_downtime", value)

    @_builtins.property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Extra disk size in GB. Supported values: 0, 25, 50, 100,
        250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @extra_disk_size.setter
    def extra_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extra_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtraDiskSizeNodeArgs']]]]:
        """
        An array of node information. Each `nodes` block consists of the fields documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtraDiskSizeNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for resizing the
        disk. Default set to 30 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for resizing the disk. Default
        set to 1800 seconds.

        ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("cloudamqp:index/extraDiskSize:ExtraDiskSize")
class ExtraDiskSize(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_downtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource allows you to resize the disk with additional storage capacity.

        ***Before v1.25.0***: Only available for Amazon Web Services (AWS) without downtime.

        ***From v1.25.0***: Google Compute Engine (GCE) and Azure available.

        Introducing a new optional argument called `allow_downtime`. Leaving it out or set it to false will
        proceed to try and resize the disk without downtime, available for *AWS*, *GCE* and *Azure*.

        `allow_downtime` also makes it possible to circumvent the time rate limit or shrinking the disk.

        | Cloud Platform        | allow_downtime=false | allow_downtime=true           | Possible to resize |
        |-----------------------|----------------------|-------------------------------|--------------------|
        | amazon-web-services   | Expand current disk* | Try to expand, otherwise swap | Every 6 hour       |
        | google-compute-engine | Expand current disk* | Try to expand, otherwise swap | Every 4 hour       |
        | azure-arm             | Expand current disk* | Expand current disk           | No time rate limit |

        *Preferable method to use.

        > **Note:** Due to restrictions from cloud providers, it's only possible to resize the disk after
        the rate time limit. See `Possible to resize` column above for the different cloud platforms.

        > **Note:** Shrinking the disk will always need to swap the old disk to a new one and require
        `allow_downtime` set to *true*.

        Pricing is available at [CloudAMQP] and only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>AWS extra disk size (before v1.25.0)</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-2")
        # Resize disk with 25 extra GB
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>AWS extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-2")
        # Resize disk with 25 extra GB, without downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>GCE extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="google-compute-engine::us-central1")
        # Resize disk with 25 extra GB, without downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Azure extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="azure-arm::centralus")
        # Resize disk with 25 extra GB, with downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        ## Dependency

        This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        Not possible to import this resource.

        [CloudAMQP]: https://www.cloudamqp.com/

        [v1.25.0]: https://github.com/cloudamqp/terraform-provider-cloudamqp/releases/tag/v1.25.0

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_downtime: When resizing the disk, allow cluster downtime if necessary.
               Default set to false.
        :param pulumi.Input[_builtins.int] extra_disk_size: Extra disk size in GB. Supported values: 0, 25, 50, 100,
               250, 500, 1000, 2000
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for resizing the
               disk. Default set to 30 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for resizing the disk. Default
               set to 1800 seconds.
               
               ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtraDiskSizeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to resize the disk with additional storage capacity.

        ***Before v1.25.0***: Only available for Amazon Web Services (AWS) without downtime.

        ***From v1.25.0***: Google Compute Engine (GCE) and Azure available.

        Introducing a new optional argument called `allow_downtime`. Leaving it out or set it to false will
        proceed to try and resize the disk without downtime, available for *AWS*, *GCE* and *Azure*.

        `allow_downtime` also makes it possible to circumvent the time rate limit or shrinking the disk.

        | Cloud Platform        | allow_downtime=false | allow_downtime=true           | Possible to resize |
        |-----------------------|----------------------|-------------------------------|--------------------|
        | amazon-web-services   | Expand current disk* | Try to expand, otherwise swap | Every 6 hour       |
        | google-compute-engine | Expand current disk* | Try to expand, otherwise swap | Every 4 hour       |
        | azure-arm             | Expand current disk* | Expand current disk           | No time rate limit |

        *Preferable method to use.

        > **Note:** Due to restrictions from cloud providers, it's only possible to resize the disk after
        the rate time limit. See `Possible to resize` column above for the different cloud platforms.

        > **Note:** Shrinking the disk will always need to swap the old disk to a new one and require
        `allow_downtime` set to *true*.

        Pricing is available at [CloudAMQP] and only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>AWS extra disk size (before v1.25.0)</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-2")
        # Resize disk with 25 extra GB
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>AWS extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-2")
        # Resize disk with 25 extra GB, without downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>GCE extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="google-compute-engine::us-central1")
        # Resize disk with 25 extra GB, without downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Azure extra disk size without downtime</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            name="Instance",
            plan="penguin-1",
            region="azure-arm::centralus")
        # Resize disk with 25 extra GB, with downtime
        resize_disk = cloudamqp.ExtraDiskSize("resize_disk",
            instance_id=instance.id,
            extra_disk_size=25)
        # Optional, refresh nodes info after disk resize by adding dependency
        # to cloudamqp_extra_disk_size.resize_disk resource
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        </details>

        ## Dependency

        This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        Not possible to import this resource.

        [CloudAMQP]: https://www.cloudamqp.com/

        [v1.25.0]: https://github.com/cloudamqp/terraform-provider-cloudamqp/releases/tag/v1.25.0

        :param str resource_name: The name of the resource.
        :param ExtraDiskSizeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtraDiskSizeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_downtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtraDiskSizeArgs.__new__(ExtraDiskSizeArgs)

            __props__.__dict__["allow_downtime"] = allow_downtime
            if extra_disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'extra_disk_size'")
            __props__.__dict__["extra_disk_size"] = extra_disk_size
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["nodes"] = None
        super(ExtraDiskSize, __self__).__init__(
            'cloudamqp:index/extraDiskSize:ExtraDiskSize',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_downtime: Optional[pulumi.Input[_builtins.bool]] = None,
            extra_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExtraDiskSizeNodeArgs', 'ExtraDiskSizeNodeArgsDict']]]]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'ExtraDiskSize':
        """
        Get an existing ExtraDiskSize resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_downtime: When resizing the disk, allow cluster downtime if necessary.
               Default set to false.
        :param pulumi.Input[_builtins.int] extra_disk_size: Extra disk size in GB. Supported values: 0, 25, 50, 100,
               250, 500, 1000, 2000
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExtraDiskSizeNodeArgs', 'ExtraDiskSizeNodeArgsDict']]]] nodes: An array of node information. Each `nodes` block consists of the fields documented below.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for resizing the
               disk. Default set to 30 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for resizing the disk. Default
               set to 1800 seconds.
               
               ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtraDiskSizeState.__new__(_ExtraDiskSizeState)

        __props__.__dict__["allow_downtime"] = allow_downtime
        __props__.__dict__["extra_disk_size"] = extra_disk_size
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["timeout"] = timeout
        return ExtraDiskSize(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowDowntime")
    def allow_downtime(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When resizing the disk, allow cluster downtime if necessary.
        Default set to false.
        """
        return pulumi.get(self, "allow_downtime")

    @_builtins.property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Extra disk size in GB. Supported values: 0, 25, 50, 100,
        250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.ExtraDiskSizeNode']]:
        """
        An array of node information. Each `nodes` block consists of the fields documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for resizing the
        disk. Default set to 30 seconds.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable timeout time in seconds for resizing the disk. Default
        set to 1800 seconds.

        ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from [v1.25.0].
        """
        return pulumi.get(self, "timeout")

