# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNotificationsResult',
    'AwaitableGetNotificationsResult',
    'get_notifications',
    'get_notifications_output',
]

@pulumi.output_type
class GetNotificationsResult:
    """
    A collection of values returned by getNotifications.
    """
    def __init__(__self__, id=None, instance_id=None, recipients=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, int):
            raise TypeError("Expected argument 'instance_id' to be a int")
        pulumi.set(__self__, "instance_id", instance_id)
        if recipients and not isinstance(recipients, list):
            raise TypeError("Expected argument 'recipients' to be a list")
        pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.int:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Sequence['outputs.GetNotificationsRecipientResult']:
        """
        List of alarms (see below for nested schema)
        """
        return pulumi.get(self, "recipients")


class AwaitableGetNotificationsResult(GetNotificationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationsResult(
            id=self.id,
            instance_id=self.instance_id,
            recipients=self.recipients)


def get_notifications(instance_id: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationsResult:
    """
    Use this data source to retrieve information about all notification recipients. Each recipient will
    receive notifications assigned to an alarm that has triggered.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    default_recipient = cloudamqp.get_notifications(instance_id=instance["id"])
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudamqp:index/getNotifications:getNotifications', __args__, opts=opts, typ=GetNotificationsResult).value

    return AwaitableGetNotificationsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        recipients=pulumi.get(__ret__, 'recipients'))
def get_notifications_output(instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotificationsResult]:
    """
    Use this data source to retrieve information about all notification recipients. Each recipient will
    receive notifications assigned to an alarm that has triggered.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    default_recipient = cloudamqp.get_notifications(instance_id=instance["id"])
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudamqp:index/getNotifications:getNotifications', __args__, opts=opts, typ=GetNotificationsResult)
    return __ret__.apply(lambda __response__: GetNotificationsResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        recipients=pulumi.get(__response__, 'recipients')))
