# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPluginsResult',
    'AwaitableGetPluginsResult',
    'get_plugins',
    'get_plugins_output',
]

@pulumi.output_type
class GetPluginsResult:
    """
    A collection of values returned by getPlugins.
    """
    def __init__(__self__, id=None, instance_id=None, plugins=None, sleep=None, timeout=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, int):
            raise TypeError("Expected argument 'instance_id' to be a int")
        pulumi.set(__self__, "instance_id", instance_id)
        if plugins and not isinstance(plugins, list):
            raise TypeError("Expected argument 'plugins' to be a list")
        pulumi.set(__self__, "plugins", plugins)
        if sleep and not isinstance(sleep, int):
            raise TypeError("Expected argument 'sleep' to be a int")
        pulumi.set(__self__, "sleep", sleep)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.int:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Sequence['outputs.GetPluginsPluginResult']:
        """
        An array of plugins. Each `plugins` block consists of the fields documented below.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "timeout")


class AwaitableGetPluginsResult(GetPluginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluginsResult(
            id=self.id,
            instance_id=self.instance_id,
            plugins=self.plugins,
            sleep=self.sleep,
            timeout=self.timeout)


def get_plugins(instance_id: Optional[_builtins.int] = None,
                sleep: Optional[_builtins.int] = None,
                timeout: Optional[_builtins.int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluginsResult:
    """
    Use this data source to retrieve information about installed and available plugins for the CloudAMQP
    instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    plugins = cloudamqp.get_plugins(instance_id=instance["id"])
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    :param _builtins.int sleep: Configurable sleep time (seconds) for retries when requesting
           information about plugins. Default set to 10 seconds.
    :param _builtins.int timeout: Configurable timeout time (seconds) for retries when requesting
           information about plugins. Default set to 1800 seconds.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['sleep'] = sleep
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudamqp:index/getPlugins:getPlugins', __args__, opts=opts, typ=GetPluginsResult).value

    return AwaitableGetPluginsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        plugins=pulumi.get(__ret__, 'plugins'),
        sleep=pulumi.get(__ret__, 'sleep'),
        timeout=pulumi.get(__ret__, 'timeout'))
def get_plugins_output(instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                       sleep: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       timeout: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluginsResult]:
    """
    Use this data source to retrieve information about installed and available plugins for the CloudAMQP
    instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    plugins = cloudamqp.get_plugins(instance_id=instance["id"])
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    :param _builtins.int sleep: Configurable sleep time (seconds) for retries when requesting
           information about plugins. Default set to 10 seconds.
    :param _builtins.int timeout: Configurable timeout time (seconds) for retries when requesting
           information about plugins. Default set to 1800 seconds.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['sleep'] = sleep
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudamqp:index/getPlugins:getPlugins', __args__, opts=opts, typ=GetPluginsResult)
    return __ret__.apply(lambda __response__: GetPluginsResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        plugins=pulumi.get(__response__, 'plugins'),
        sleep=pulumi.get(__response__, 'sleep'),
        timeout=pulumi.get(__response__, 'timeout')))
