# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]] = None,
                 keep_associated_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_alarms: Optional[pulumi.Input[_builtins.bool]] = None,
                 nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rmq_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_subnet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] plan: The subscription plan. See available [plans].
        :param pulumi.Input[_builtins.str] region: The region to host the instance in. See available [regions].
               
               ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
               region. All data will be lost and a new name assigned.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]] copy_settings: Copy settings from one CloudAMQP instance to a new. Consists of
               the block documented below.
        :param pulumi.Input[_builtins.bool] keep_associated_vpc: Keep associated VPC when deleting instance. Default set to
               false.
        :param pulumi.Input[_builtins.str] name: Name of the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] no_default_alarms: Set to true to not create default alarms
        :param pulumi.Input[_builtins.int] nodes: Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
               legacy plans, will otherwise be computed.
               
               ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
               New subscriptions plans use the plan to determine number of nodes. In order to
               change number of nodes the `plan` needs to be updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_azs: The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.
               
               ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
               * AWS: AZ id in [aws-availability-zones]
               * Azure: 1,2 or 3 in supported regions [azure-region-list]
               * GCP: zones in [gcp-region-zones]
               * Digital Ocean: Slug in [do-regional-availability]
               
               ___
               
               The `copy_settings` block consists of:
        :param pulumi.Input[_builtins.str] rmq_version: The Rabbit MQ version. Can be left out, will then be set to
               default value used by CloudAMQP API.
               
               ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
               in the initial creation, it will remain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: One or more tags for the CloudAMQP instance, makes it possible to
               categories multiple instances in console view. Default there is no tags assigned.
        :param pulumi.Input[_builtins.int] vpc_id: The VPC ID. Use this to create your instance in an existing
               VPC. See available [example].
        :param pulumi.Input[_builtins.str] vpc_subnet: Creates a dedicated VPC subnet, shouldn't overlap with other
               VPC subnet, default subnet used 10.56.72.0/24.
               
               ***Deprecated:*** Will be removed in next major version (v2.0)
               
               ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if copy_settings is not None:
            pulumi.set(__self__, "copy_settings", copy_settings)
        if keep_associated_vpc is not None:
            pulumi.set(__self__, "keep_associated_vpc", keep_associated_vpc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_default_alarms is not None:
            pulumi.set(__self__, "no_default_alarms", no_default_alarms)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if preferred_azs is not None:
            pulumi.set(__self__, "preferred_azs", preferred_azs)
        if rmq_version is not None:
            pulumi.set(__self__, "rmq_version", rmq_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_subnet is not None:
            pulumi.set(__self__, "vpc_subnet", vpc_subnet)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The subscription plan. See available [plans].
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region to host the instance in. See available [regions].

        ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
        region. All data will be lost and a new name assigned.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]]:
        """
        Copy settings from one CloudAMQP instance to a new. Consists of
        the block documented below.
        """
        return pulumi.get(self, "copy_settings")

    @copy_settings.setter
    def copy_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]]):
        pulumi.set(self, "copy_settings", value)

    @_builtins.property
    @pulumi.getter(name="keepAssociatedVpc")
    def keep_associated_vpc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Keep associated VPC when deleting instance. Default set to
        false.
        """
        return pulumi.get(self, "keep_associated_vpc")

    @keep_associated_vpc.setter
    def keep_associated_vpc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_associated_vpc", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CloudAMQP instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noDefaultAlarms")
    def no_default_alarms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to not create default alarms
        """
        return pulumi.get(self, "no_default_alarms")

    @no_default_alarms.setter
    def no_default_alarms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_default_alarms", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
        legacy plans, will otherwise be computed.

        ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
        New subscriptions plans use the plan to determine number of nodes. In order to
        change number of nodes the `plan` needs to be updated.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="preferredAzs")
    def preferred_azs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.

        ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
        * AWS: AZ id in [aws-availability-zones]
        * Azure: 1,2 or 3 in supported regions [azure-region-list]
        * GCP: zones in [gcp-region-zones]
        * Digital Ocean: Slug in [do-regional-availability]

        ___

        The `copy_settings` block consists of:
        """
        return pulumi.get(self, "preferred_azs")

    @preferred_azs.setter
    def preferred_azs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_azs", value)

    @_builtins.property
    @pulumi.getter(name="rmqVersion")
    def rmq_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rabbit MQ version. Can be left out, will then be set to
        default value used by CloudAMQP API.

        ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
        in the initial creation, it will remain.
        """
        return pulumi.get(self, "rmq_version")

    @rmq_version.setter
    def rmq_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rmq_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more tags for the CloudAMQP instance, makes it possible to
        categories multiple instances in console view. Default there is no tags assigned.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VPC ID. Use this to create your instance in an existing
        VPC. See available [example].
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcSubnet")
    def vpc_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a dedicated VPC subnet, shouldn't overlap with other
        VPC subnet, default subnet used 10.56.72.0/24.

        ***Deprecated:*** Will be removed in next major version (v2.0)

        ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        return pulumi.get(self, "vpc_subnet")

    @vpc_subnet.setter
    def vpc_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_subnet", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 apikey: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]] = None,
                 dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_internal: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_associated_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_alarms: Optional[pulumi.Input[_builtins.bool]] = None,
                 nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ready: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rmq_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_subnet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] apikey: API key needed to communicate to CloudAMQP's second API. The second API is used
               to manage alarms, integration and more, full description [CloudAMQP API].
        :param pulumi.Input[_builtins.str] backend: Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]] copy_settings: Copy settings from one CloudAMQP instance to a new. Consists of
               the block documented below.
        :param pulumi.Input[_builtins.bool] dedicated: Information if the CloudAMQP instance is shared or dedicated.
        :param pulumi.Input[_builtins.str] host: The external hostname for the CloudAMQP instance.
        :param pulumi.Input[_builtins.str] host_internal: The internal hostname for the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] keep_associated_vpc: Keep associated VPC when deleting instance. Default set to
               false.
        :param pulumi.Input[_builtins.str] name: Name of the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] no_default_alarms: Set to true to not create default alarms
        :param pulumi.Input[_builtins.int] nodes: Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
               legacy plans, will otherwise be computed.
               
               ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
               New subscriptions plans use the plan to determine number of nodes. In order to
               change number of nodes the `plan` needs to be updated.
        :param pulumi.Input[_builtins.str] plan: The subscription plan. See available [plans].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_azs: The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.
               
               ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
               * AWS: AZ id in [aws-availability-zones]
               * Azure: 1,2 or 3 in supported regions [azure-region-list]
               * GCP: zones in [gcp-region-zones]
               * Digital Ocean: Slug in [do-regional-availability]
               
               ___
               
               The `copy_settings` block consists of:
        :param pulumi.Input[_builtins.bool] ready: Flag describing if the resource is ready
        :param pulumi.Input[_builtins.str] region: The region to host the instance in. See available [regions].
               
               ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
               region. All data will be lost and a new name assigned.
        :param pulumi.Input[_builtins.str] rmq_version: The Rabbit MQ version. Can be left out, will then be set to
               default value used by CloudAMQP API.
               
               ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
               in the initial creation, it will remain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: One or more tags for the CloudAMQP instance, makes it possible to
               categories multiple instances in console view. Default there is no tags assigned.
        :param pulumi.Input[_builtins.str] url: The AMQP URL (uses the internal hostname if the instance was created with VPC).
               Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
        :param pulumi.Input[_builtins.str] vhost: The virtual host used by Rabbit MQ.
        :param pulumi.Input[_builtins.int] vpc_id: The VPC ID. Use this to create your instance in an existing
               VPC. See available [example].
        :param pulumi.Input[_builtins.str] vpc_subnet: Creates a dedicated VPC subnet, shouldn't overlap with other
               VPC subnet, default subnet used 10.56.72.0/24.
               
               ***Deprecated:*** Will be removed in next major version (v2.0)
               
               ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        if apikey is not None:
            pulumi.set(__self__, "apikey", apikey)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if copy_settings is not None:
            pulumi.set(__self__, "copy_settings", copy_settings)
        if dedicated is not None:
            pulumi.set(__self__, "dedicated", dedicated)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_internal is not None:
            pulumi.set(__self__, "host_internal", host_internal)
        if keep_associated_vpc is not None:
            pulumi.set(__self__, "keep_associated_vpc", keep_associated_vpc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_default_alarms is not None:
            pulumi.set(__self__, "no_default_alarms", no_default_alarms)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if preferred_azs is not None:
            pulumi.set(__self__, "preferred_azs", preferred_azs)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rmq_version is not None:
            pulumi.set(__self__, "rmq_version", rmq_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if vhost is not None:
            pulumi.set(__self__, "vhost", vhost)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_subnet is not None:
            pulumi.set(__self__, "vpc_subnet", vpc_subnet)

    @_builtins.property
    @pulumi.getter
    def apikey(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key needed to communicate to CloudAMQP's second API. The second API is used
        to manage alarms, integration and more, full description [CloudAMQP API].
        """
        return pulumi.get(self, "apikey")

    @apikey.setter
    def apikey(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apikey", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]]:
        """
        Copy settings from one CloudAMQP instance to a new. Consists of
        the block documented below.
        """
        return pulumi.get(self, "copy_settings")

    @copy_settings.setter
    def copy_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCopySettingArgs']]]]):
        pulumi.set(self, "copy_settings", value)

    @_builtins.property
    @pulumi.getter
    def dedicated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Information if the CloudAMQP instance is shared or dedicated.
        """
        return pulumi.get(self, "dedicated")

    @dedicated.setter
    def dedicated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dedicated", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external hostname for the CloudAMQP instance.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostInternal")
    def host_internal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal hostname for the CloudAMQP instance.
        """
        return pulumi.get(self, "host_internal")

    @host_internal.setter
    def host_internal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_internal", value)

    @_builtins.property
    @pulumi.getter(name="keepAssociatedVpc")
    def keep_associated_vpc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Keep associated VPC when deleting instance. Default set to
        false.
        """
        return pulumi.get(self, "keep_associated_vpc")

    @keep_associated_vpc.setter
    def keep_associated_vpc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_associated_vpc", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CloudAMQP instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noDefaultAlarms")
    def no_default_alarms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to not create default alarms
        """
        return pulumi.get(self, "no_default_alarms")

    @no_default_alarms.setter
    def no_default_alarms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_default_alarms", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
        legacy plans, will otherwise be computed.

        ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
        New subscriptions plans use the plan to determine number of nodes. In order to
        change number of nodes the `plan` needs to be updated.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription plan. See available [plans].
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="preferredAzs")
    def preferred_azs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.

        ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
        * AWS: AZ id in [aws-availability-zones]
        * Azure: 1,2 or 3 in supported regions [azure-region-list]
        * GCP: zones in [gcp-region-zones]
        * Digital Ocean: Slug in [do-regional-availability]

        ___

        The `copy_settings` block consists of:
        """
        return pulumi.get(self, "preferred_azs")

    @preferred_azs.setter
    def preferred_azs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_azs", value)

    @_builtins.property
    @pulumi.getter
    def ready(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag describing if the resource is ready
        """
        return pulumi.get(self, "ready")

    @ready.setter
    def ready(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ready", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to host the instance in. See available [regions].

        ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
        region. All data will be lost and a new name assigned.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rmqVersion")
    def rmq_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rabbit MQ version. Can be left out, will then be set to
        default value used by CloudAMQP API.

        ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
        in the initial creation, it will remain.
        """
        return pulumi.get(self, "rmq_version")

    @rmq_version.setter
    def rmq_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rmq_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more tags for the CloudAMQP instance, makes it possible to
        categories multiple instances in console view. Default there is no tags assigned.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AMQP URL (uses the internal hostname if the instance was created with VPC).
        Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def vhost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual host used by Rabbit MQ.
        """
        return pulumi.get(self, "vhost")

    @vhost.setter
    def vhost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VPC ID. Use this to create your instance in an existing
        VPC. See available [example].
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcSubnet")
    def vpc_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a dedicated VPC subnet, shouldn't overlap with other
        VPC subnet, default subnet used 10.56.72.0/24.

        ***Deprecated:*** Will be removed in next major version (v2.0)

        ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        return pulumi.get(self, "vpc_subnet")

    @vpc_subnet.setter
    def vpc_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_subnet", value)


@pulumi.type_token("cloudamqp:index/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCopySettingArgs', 'InstanceCopySettingArgsDict']]]]] = None,
                 keep_associated_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_alarms: Optional[pulumi.Input[_builtins.bool]] = None,
                 nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rmq_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage a CloudAMQP instance running either [**RabbitMQ**] or
        [**LavinMQ**] and can be deployed to multiple cloud platforms provider and regions, see
        [instance regions] for more information.

        Once the instance is created it will be assigned a unique identifier. All other resources and data
        sources created for this instance needs to reference this unique instance identifier.

        Pricing is available at [CloudAMQP plans].

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Shared and dedicated instances running LavinMQ</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Minimum free lemming instance running LavinMQ
        lemur_instance = cloudamqp.Instance("lemur_instance",
            name="cloudamqp-free-instance-01",
            plan="lemming",
            region="amazon-web-services::us-west-1",
            tags=["lavinmq"])
        # Minimum free lemur instance running RabbitMQ
        lemming_instance = cloudamqp.Instance("lemming_instance",
            name="cloudamqp-free-instance-02",
            plan="lemur",
            region="amazon-web-services::us-west-1",
            tags=["rabbitmq"])
        # Dedicated penguin instance running LavinMQ
        penguin_instance = cloudamqp.Instance("penguin_instance",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["lavinmq"])
        # Dedicated bunny instance running RabbitMQ
        bunny_instance = cloudamqp.Instance("bunny_instance",
            name="terraform-cloudamqp-instance-02",
            plan="bunny-1",
            region="amazon-web-services::us-west-1",
            tags=["rabbitmq"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instance using attribute vpc_subnet to create VPC, before v1.16.0</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="terraform-cloudamqp-instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_subnet="10.56.72.0/24")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>
                Dedicated instance using attribute vpc_subnet to create VPC and then import managed VPC,
                from v1.16.0 (Managed VPC)
              </i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Dedicated instance that also creates VPC
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_subnet="10.56.72.0/24")
        ```

        Once the instance and the VPC are created, the VPC can be imported as managed VPC and added to the
        configuration file. Set attribute `vpc_id` to the managed VPC identifier. To keep the managed VPC
        when deleting the instance, set attribute `keep_associated_vpc` to true. For more information see
        guide [Managed VPC].

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Imported managed VPC
        vpc = cloudamqp.Vpc("vpc",
            name="<vpc-name>",
            region="amazon-web-services::us-east-1",
            subnet="10.56.72.0/24",
            tags=[])
        # Add vpc_id and keep_associated_vpc attributes
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instances and managed VPC, from v1.16.0 (Managed VPC)</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Managed VPC
        vpc = cloudamqp.Vpc("vpc",
            name="<vpc-name>",
            region="amazon-web-services::us-east-1",
            subnet="10.56.72.0/24",
            tags=[])
        # First instance added to managed VPC
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        # Second instance added to managed VPC
        instance02 = cloudamqp.Instance("instance_02",
            name="terraform-cloudamqp-instance-02",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        ```

        Set attribute `keep_associated_vpc` to true, will keep managed VPC when deleting the instances.

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instance with preferred AZs</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="terraform-cloudamqp-instance",
            plan="penguin-3",
            region="amazon-web-services::us-east-1",
            tags=["terraform"],
            preferred_azs=[
                "use1-az1",
                "use1-az2",
                "use1-az3",
            ])
        ```

        </details>

        ### Settings supported by LavinMQ

        ***Allowed values:*** alarms, definitions, firewall, metrics

        <details>
          <summary>
            <b>
              <i>Copy settings from a dedicated instance to a new dedicated instance</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        penguin_instance = cloudamqp.Instance("penguin_instance",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            rmq_version="2.2.0",
            tags=["terraform"],
            copy_settings=[{
                "subscription_id": instance_id,
                "settings": [
                    "alarms",
                    "definitions",
                    "firewall",
                    "metrics",
                ],
            }])
        ```

        </details>

        ### Settings supported by RabbitMQ

        ***Allowed values:*** alarms, config, definitions, firewall, logs, metrics, plugins

        <details>
          <summary>
            <b>
              <i>Copy settings from a dedicated instance to a new dedicated instance</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        bunny_instance = cloudamqp.Instance("bunny_instance",
            name="terraform-cloudamqp-instance-02",
            plan="bunny-1",
            region="amazon-web-services::us-west-1",
            rmq_version="3.12.2",
            tags=["terraform"],
            copy_settings=[{
                "subscription_id": instance_id,
                "settings": [
                    "alarms",
                    "config",
                    "definitions",
                    "firewall",
                    "logs",
                    "metrics",
                    "plugins",
                ],
            }])
        ```

        </details>

        [CloudAMQP]: https://cloudamqp.com
        [CloudAMQP API]: https://docs.cloudamqp.com/instance-api.html
        [CloudAMQP API list instances]: https://docs.cloudamqp.com/index.html#tag/instances/get/instances
        [CloudAMQP plans]: https://www.cloudamqp.com/plans.html
        [copy settings]: #copy-settings-to-a-new-dedicated-instance
        [example]: ../guides/info_vpc_existing.md
        [regions]: ../guides/info_region.md
        [**LavinMQ**]: https://lavinmq.com
        [Managed VPC]: ../guides/info_managed_vpc#dedicated-instance-and-vpc_subnet
        [plans]: ../guides/info_plan.md
        [**RabbitMQ**]: https://www.rabbitmq.com
        [instance regions]: ../guides/info_region.md
        [aws-availability-zones]: https://docs.aws.amazon.com/global-infrastructure/latest/regions/aws-availability-zones.html
        [azure-region-list]: https://learn.microsoft.com/en-us/azure/reliability/regions-list
        [gcp-region-zones]: https://cloud.google.com/compute/docs/regions-zones#available
        [do-regional-availability]: https://docs.digitalocean.com/platform/regional-availability/

        ## Import

        `cloudamqp_instance`can be imported using resource identifier. To retrieve the resource identifier,

        use [CloudAMQP API list instances]

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_instance.instance

          id = <id>

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/instance:Instance instance <id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceCopySettingArgs', 'InstanceCopySettingArgsDict']]]] copy_settings: Copy settings from one CloudAMQP instance to a new. Consists of
               the block documented below.
        :param pulumi.Input[_builtins.bool] keep_associated_vpc: Keep associated VPC when deleting instance. Default set to
               false.
        :param pulumi.Input[_builtins.str] name: Name of the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] no_default_alarms: Set to true to not create default alarms
        :param pulumi.Input[_builtins.int] nodes: Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
               legacy plans, will otherwise be computed.
               
               ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
               New subscriptions plans use the plan to determine number of nodes. In order to
               change number of nodes the `plan` needs to be updated.
        :param pulumi.Input[_builtins.str] plan: The subscription plan. See available [plans].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_azs: The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.
               
               ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
               * AWS: AZ id in [aws-availability-zones]
               * Azure: 1,2 or 3 in supported regions [azure-region-list]
               * GCP: zones in [gcp-region-zones]
               * Digital Ocean: Slug in [do-regional-availability]
               
               ___
               
               The `copy_settings` block consists of:
        :param pulumi.Input[_builtins.str] region: The region to host the instance in. See available [regions].
               
               ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
               region. All data will be lost and a new name assigned.
        :param pulumi.Input[_builtins.str] rmq_version: The Rabbit MQ version. Can be left out, will then be set to
               default value used by CloudAMQP API.
               
               ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
               in the initial creation, it will remain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: One or more tags for the CloudAMQP instance, makes it possible to
               categories multiple instances in console view. Default there is no tags assigned.
        :param pulumi.Input[_builtins.int] vpc_id: The VPC ID. Use this to create your instance in an existing
               VPC. See available [example].
        :param pulumi.Input[_builtins.str] vpc_subnet: Creates a dedicated VPC subnet, shouldn't overlap with other
               VPC subnet, default subnet used 10.56.72.0/24.
               
               ***Deprecated:*** Will be removed in next major version (v2.0)
               
               ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage a CloudAMQP instance running either [**RabbitMQ**] or
        [**LavinMQ**] and can be deployed to multiple cloud platforms provider and regions, see
        [instance regions] for more information.

        Once the instance is created it will be assigned a unique identifier. All other resources and data
        sources created for this instance needs to reference this unique instance identifier.

        Pricing is available at [CloudAMQP plans].

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Shared and dedicated instances running LavinMQ</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Minimum free lemming instance running LavinMQ
        lemur_instance = cloudamqp.Instance("lemur_instance",
            name="cloudamqp-free-instance-01",
            plan="lemming",
            region="amazon-web-services::us-west-1",
            tags=["lavinmq"])
        # Minimum free lemur instance running RabbitMQ
        lemming_instance = cloudamqp.Instance("lemming_instance",
            name="cloudamqp-free-instance-02",
            plan="lemur",
            region="amazon-web-services::us-west-1",
            tags=["rabbitmq"])
        # Dedicated penguin instance running LavinMQ
        penguin_instance = cloudamqp.Instance("penguin_instance",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["lavinmq"])
        # Dedicated bunny instance running RabbitMQ
        bunny_instance = cloudamqp.Instance("bunny_instance",
            name="terraform-cloudamqp-instance-02",
            plan="bunny-1",
            region="amazon-web-services::us-west-1",
            tags=["rabbitmq"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instance using attribute vpc_subnet to create VPC, before v1.16.0</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="terraform-cloudamqp-instance",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_subnet="10.56.72.0/24")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>
                Dedicated instance using attribute vpc_subnet to create VPC and then import managed VPC,
                from v1.16.0 (Managed VPC)
              </i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Dedicated instance that also creates VPC
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_subnet="10.56.72.0/24")
        ```

        Once the instance and the VPC are created, the VPC can be imported as managed VPC and added to the
        configuration file. Set attribute `vpc_id` to the managed VPC identifier. To keep the managed VPC
        when deleting the instance, set attribute `keep_associated_vpc` to true. For more information see
        guide [Managed VPC].

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Imported managed VPC
        vpc = cloudamqp.Vpc("vpc",
            name="<vpc-name>",
            region="amazon-web-services::us-east-1",
            subnet="10.56.72.0/24",
            tags=[])
        # Add vpc_id and keep_associated_vpc attributes
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instances and managed VPC, from v1.16.0 (Managed VPC)</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Managed VPC
        vpc = cloudamqp.Vpc("vpc",
            name="<vpc-name>",
            region="amazon-web-services::us-east-1",
            subnet="10.56.72.0/24",
            tags=[])
        # First instance added to managed VPC
        instance01 = cloudamqp.Instance("instance_01",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        # Second instance added to managed VPC
        instance02 = cloudamqp.Instance("instance_02",
            name="terraform-cloudamqp-instance-02",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            tags=["terraform"],
            vpc_id=vpc.id,
            keep_associated_vpc=True)
        ```

        Set attribute `keep_associated_vpc` to true, will keep managed VPC when deleting the instances.

        </details>

        <details>
          <summary>
            <b>
              <i>Dedicated instance with preferred AZs</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="terraform-cloudamqp-instance",
            plan="penguin-3",
            region="amazon-web-services::us-east-1",
            tags=["terraform"],
            preferred_azs=[
                "use1-az1",
                "use1-az2",
                "use1-az3",
            ])
        ```

        </details>

        ### Settings supported by LavinMQ

        ***Allowed values:*** alarms, definitions, firewall, metrics

        <details>
          <summary>
            <b>
              <i>Copy settings from a dedicated instance to a new dedicated instance</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        penguin_instance = cloudamqp.Instance("penguin_instance",
            name="terraform-cloudamqp-instance-01",
            plan="penguin-1",
            region="amazon-web-services::us-west-1",
            rmq_version="2.2.0",
            tags=["terraform"],
            copy_settings=[{
                "subscription_id": instance_id,
                "settings": [
                    "alarms",
                    "definitions",
                    "firewall",
                    "metrics",
                ],
            }])
        ```

        </details>

        ### Settings supported by RabbitMQ

        ***Allowed values:*** alarms, config, definitions, firewall, logs, metrics, plugins

        <details>
          <summary>
            <b>
              <i>Copy settings from a dedicated instance to a new dedicated instance</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        bunny_instance = cloudamqp.Instance("bunny_instance",
            name="terraform-cloudamqp-instance-02",
            plan="bunny-1",
            region="amazon-web-services::us-west-1",
            rmq_version="3.12.2",
            tags=["terraform"],
            copy_settings=[{
                "subscription_id": instance_id,
                "settings": [
                    "alarms",
                    "config",
                    "definitions",
                    "firewall",
                    "logs",
                    "metrics",
                    "plugins",
                ],
            }])
        ```

        </details>

        [CloudAMQP]: https://cloudamqp.com
        [CloudAMQP API]: https://docs.cloudamqp.com/instance-api.html
        [CloudAMQP API list instances]: https://docs.cloudamqp.com/index.html#tag/instances/get/instances
        [CloudAMQP plans]: https://www.cloudamqp.com/plans.html
        [copy settings]: #copy-settings-to-a-new-dedicated-instance
        [example]: ../guides/info_vpc_existing.md
        [regions]: ../guides/info_region.md
        [**LavinMQ**]: https://lavinmq.com
        [Managed VPC]: ../guides/info_managed_vpc#dedicated-instance-and-vpc_subnet
        [plans]: ../guides/info_plan.md
        [**RabbitMQ**]: https://www.rabbitmq.com
        [instance regions]: ../guides/info_region.md
        [aws-availability-zones]: https://docs.aws.amazon.com/global-infrastructure/latest/regions/aws-availability-zones.html
        [azure-region-list]: https://learn.microsoft.com/en-us/azure/reliability/regions-list
        [gcp-region-zones]: https://cloud.google.com/compute/docs/regions-zones#available
        [do-regional-availability]: https://docs.digitalocean.com/platform/regional-availability/

        ## Import

        `cloudamqp_instance`can be imported using resource identifier. To retrieve the resource identifier,

        use [CloudAMQP API list instances]

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_instance.instance

          id = <id>

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/instance:Instance instance <id>`
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCopySettingArgs', 'InstanceCopySettingArgsDict']]]]] = None,
                 keep_associated_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_alarms: Optional[pulumi.Input[_builtins.bool]] = None,
                 nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rmq_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["copy_settings"] = copy_settings
            __props__.__dict__["keep_associated_vpc"] = keep_associated_vpc
            __props__.__dict__["name"] = name
            __props__.__dict__["no_default_alarms"] = no_default_alarms
            __props__.__dict__["nodes"] = nodes
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["preferred_azs"] = preferred_azs
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["rmq_version"] = rmq_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpc_subnet"] = vpc_subnet
            __props__.__dict__["apikey"] = None
            __props__.__dict__["backend"] = None
            __props__.__dict__["dedicated"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["host_internal"] = None
            __props__.__dict__["ready"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["vhost"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apikey", "url"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'cloudamqp:index/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apikey: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCopySettingArgs', 'InstanceCopySettingArgsDict']]]]] = None,
            dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            host_internal: Optional[pulumi.Input[_builtins.str]] = None,
            keep_associated_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            no_default_alarms: Optional[pulumi.Input[_builtins.bool]] = None,
            nodes: Optional[pulumi.Input[_builtins.int]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_azs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ready: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rmq_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            vhost: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_subnet: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] apikey: API key needed to communicate to CloudAMQP's second API. The second API is used
               to manage alarms, integration and more, full description [CloudAMQP API].
        :param pulumi.Input[_builtins.str] backend: Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceCopySettingArgs', 'InstanceCopySettingArgsDict']]]] copy_settings: Copy settings from one CloudAMQP instance to a new. Consists of
               the block documented below.
        :param pulumi.Input[_builtins.bool] dedicated: Information if the CloudAMQP instance is shared or dedicated.
        :param pulumi.Input[_builtins.str] host: The external hostname for the CloudAMQP instance.
        :param pulumi.Input[_builtins.str] host_internal: The internal hostname for the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] keep_associated_vpc: Keep associated VPC when deleting instance. Default set to
               false.
        :param pulumi.Input[_builtins.str] name: Name of the CloudAMQP instance.
        :param pulumi.Input[_builtins.bool] no_default_alarms: Set to true to not create default alarms
        :param pulumi.Input[_builtins.int] nodes: Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
               legacy plans, will otherwise be computed.
               
               ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
               New subscriptions plans use the plan to determine number of nodes. In order to
               change number of nodes the `plan` needs to be updated.
        :param pulumi.Input[_builtins.str] plan: The subscription plan. See available [plans].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_azs: The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.
               
               ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
               * AWS: AZ id in [aws-availability-zones]
               * Azure: 1,2 or 3 in supported regions [azure-region-list]
               * GCP: zones in [gcp-region-zones]
               * Digital Ocean: Slug in [do-regional-availability]
               
               ___
               
               The `copy_settings` block consists of:
        :param pulumi.Input[_builtins.bool] ready: Flag describing if the resource is ready
        :param pulumi.Input[_builtins.str] region: The region to host the instance in. See available [regions].
               
               ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
               region. All data will be lost and a new name assigned.
        :param pulumi.Input[_builtins.str] rmq_version: The Rabbit MQ version. Can be left out, will then be set to
               default value used by CloudAMQP API.
               
               ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
               in the initial creation, it will remain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: One or more tags for the CloudAMQP instance, makes it possible to
               categories multiple instances in console view. Default there is no tags assigned.
        :param pulumi.Input[_builtins.str] url: The AMQP URL (uses the internal hostname if the instance was created with VPC).
               Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
        :param pulumi.Input[_builtins.str] vhost: The virtual host used by Rabbit MQ.
        :param pulumi.Input[_builtins.int] vpc_id: The VPC ID. Use this to create your instance in an existing
               VPC. See available [example].
        :param pulumi.Input[_builtins.str] vpc_subnet: Creates a dedicated VPC subnet, shouldn't overlap with other
               VPC subnet, default subnet used 10.56.72.0/24.
               
               ***Deprecated:*** Will be removed in next major version (v2.0)
               
               ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["apikey"] = apikey
        __props__.__dict__["backend"] = backend
        __props__.__dict__["copy_settings"] = copy_settings
        __props__.__dict__["dedicated"] = dedicated
        __props__.__dict__["host"] = host
        __props__.__dict__["host_internal"] = host_internal
        __props__.__dict__["keep_associated_vpc"] = keep_associated_vpc
        __props__.__dict__["name"] = name
        __props__.__dict__["no_default_alarms"] = no_default_alarms
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["plan"] = plan
        __props__.__dict__["preferred_azs"] = preferred_azs
        __props__.__dict__["ready"] = ready
        __props__.__dict__["region"] = region
        __props__.__dict__["rmq_version"] = rmq_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["url"] = url
        __props__.__dict__["vhost"] = vhost
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_subnet"] = vpc_subnet
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def apikey(self) -> pulumi.Output[_builtins.str]:
        """
        API key needed to communicate to CloudAMQP's second API. The second API is used
        to manage alarms, integration and more, full description [CloudAMQP API].
        """
        return pulumi.get(self, "apikey")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceCopySetting']]]:
        """
        Copy settings from one CloudAMQP instance to a new. Consists of
        the block documented below.
        """
        return pulumi.get(self, "copy_settings")

    @_builtins.property
    @pulumi.getter
    def dedicated(self) -> pulumi.Output[_builtins.bool]:
        """
        Information if the CloudAMQP instance is shared or dedicated.
        """
        return pulumi.get(self, "dedicated")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The external hostname for the CloudAMQP instance.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostInternal")
    def host_internal(self) -> pulumi.Output[_builtins.str]:
        """
        The internal hostname for the CloudAMQP instance.
        """
        return pulumi.get(self, "host_internal")

    @_builtins.property
    @pulumi.getter(name="keepAssociatedVpc")
    def keep_associated_vpc(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Keep associated VPC when deleting instance. Default set to
        false.
        """
        return pulumi.get(self, "keep_associated_vpc")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the CloudAMQP instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noDefaultAlarms")
    def no_default_alarms(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to true to not create default alarms
        """
        return pulumi.get(self, "no_default_alarms")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes, 1, 3 or 5 depending on plan used. Only needed for
        legacy plans, will otherwise be computed.

        ***Deprecated:*** Legacy subscriptions plan can still change this to scale up or down the instance.
        New subscriptions plans use the plan to determine number of nodes. In order to
        change number of nodes the `plan` needs to be updated.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The subscription plan. See available [plans].
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="preferredAzs")
    def preferred_azs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The AZs to place your nodes in. Each entry corresponds to a server in your cluster, so for a 3 node cluster, provide 3 AZs in the list.

        ***Note:*** `preferred_az` can only be set upon instance creation as of now and the result is not guaranteed. On eventual failed resource allocation in the zone, CloudAMQP will fallback to a different zone.
        * AWS: AZ id in [aws-availability-zones]
        * Azure: 1,2 or 3 in supported regions [azure-region-list]
        * GCP: zones in [gcp-region-zones]
        * Digital Ocean: Slug in [do-regional-availability]

        ___

        The `copy_settings` block consists of:
        """
        return pulumi.get(self, "preferred_azs")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag describing if the resource is ready
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to host the instance in. See available [regions].

        ***Note:*** Changing region will force the instance to be destroyed and a new created in the new
        region. All data will be lost and a new name assigned.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rmqVersion")
    def rmq_version(self) -> pulumi.Output[_builtins.str]:
        """
        The Rabbit MQ version. Can be left out, will then be set to
        default value used by CloudAMQP API.

        ***Note:*** There is not yet any support in the provider to change the RMQ version. Once it's set
        in the initial creation, it will remain.
        """
        return pulumi.get(self, "rmq_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        One or more tags for the CloudAMQP instance, makes it possible to
        categories multiple instances in console view. Default there is no tags assigned.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The AMQP URL (uses the internal hostname if the instance was created with VPC).
        Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def vhost(self) -> pulumi.Output[_builtins.str]:
        """
        The virtual host used by Rabbit MQ.
        """
        return pulumi.get(self, "vhost")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.int]:
        """
        The VPC ID. Use this to create your instance in an existing
        VPC. See available [example].
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcSubnet")
    def vpc_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a dedicated VPC subnet, shouldn't overlap with other
        VPC subnet, default subnet used 10.56.72.0/24.

        ***Deprecated:*** Will be removed in next major version (v2.0)

        ***Note:*** Extra fee will be charged when using VPC, see [CloudAMQP] for more information.
        """
        return pulumi.get(self, "vpc_subnet")

