# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntegrationLogArgs', 'IntegrationLog']

@pulumi.input_type
class IntegrationLogArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 dce_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 dcr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_port: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 subsystem: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationLog resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
               
               Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
               found here [CloudAMQP API add integration].
               
               <details>
               <summary>
               <b>Azure monitoring</b>
               </summary>
               
               The following arguments used by Azure monitoring.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier.
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Datadog)
        :param pulumi.Input[_builtins.str] application: The name of the application. (Azure Monitor)
        :param pulumi.Input[_builtins.str] application_id: The application identifier.
        :param pulumi.Input[_builtins.str] application_secret: The application secret.
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] dce_uri: The data collection endpoint.
        :param pulumi.Input[_builtins.str] dcr_id: ID of data collection rule that your DCE is linked to.
        :param pulumi.Input[_builtins.str] endpoint: The syslog destination to send the logs to. (Papertrail)
        :param pulumi.Input[_builtins.str] host: The host information. (Scalyr)
        :param pulumi.Input[_builtins.str] host_port: Destination to send the logs. (Splunk)
        :param pulumi.Input[_builtins.str] name: The name of the third party log integration (`cloudwatchlog`).
        :param pulumi.Input[_builtins.str] private_key: The private API key used for authentication. (Stackdriver, Coralogix)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: The project ID for the integration service. (Stackdriver)
        :param pulumi.Input[_builtins.str] region: AWS region hosting the integration service.
               
               Optional arguments introduced in version [v1.38.0].
        :param pulumi.Input[_builtins.int] retention: Number of days to retain log events in `CloudAMQP` log group.
               
               ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
               the [Cloudwatch Log retention].
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret access key.
        :param pulumi.Input[_builtins.str] sourcetype: Assign source type to the data exported, eg. generic_single_line. (Splunk)
        :param pulumi.Input[_builtins.str] subsystem: The name of the subsystem. (Azure Monitor)
        :param pulumi.Input[_builtins.str] table: The table name.
               
               Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]
               
               </details>
               
               <details>
               <summary>
               <b>Cloudwatch</b>
               </summary>
               
               The following arguments used by CloudWatch.
        :param pulumi.Input[_builtins.str] tags: Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.
               
               ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
               Read more about tags format in the [Cloudwatch Log tags]
        :param pulumi.Input[_builtins.str] tenant_id: The tenant identifier.
        :param pulumi.Input[_builtins.str] token: The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        :param pulumi.Input[_builtins.str] url: The URL to push the logs to. (Papertrail)
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if dce_uri is not None:
            pulumi.set(__self__, "dce_uri", dce_uri)
        if dcr_id is not None:
            pulumi.set(__self__, "dcr_id", dcr_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if sourcetype is not None:
            pulumi.set(__self__, "sourcetype", sourcetype)
        if subsystem is not None:
            pulumi.set(__self__, "subsystem", subsystem)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        Instance identifier for the CloudAMQP instance.

        Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
        found here [CloudAMQP API add integration].

        <details>
        <summary>
        <b>Azure monitoring</b>
        </summary>

        The following arguments used by Azure monitoring.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Datadog)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application. (Azure Monitor)
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application identifier.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application secret.
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_secret", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="dceUri")
    def dce_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data collection endpoint.
        """
        return pulumi.get(self, "dce_uri")

    @dce_uri.setter
    def dce_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dce_uri", value)

    @_builtins.property
    @pulumi.getter(name="dcrId")
    def dcr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of data collection rule that your DCE is linked to.
        """
        return pulumi.get(self, "dcr_id")

    @dcr_id.setter
    def dcr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dcr_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The syslog destination to send the logs to. (Papertrail)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host information. (Scalyr)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination to send the logs. (Splunk)
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_port", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the third party log integration (`cloudwatchlog`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private API key used for authentication. (Stackdriver, Coralogix)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID for the integration service. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region hosting the integration service.

        Optional arguments introduced in version [v1.38.0].
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days to retain log events in `CloudAMQP` log group.

        ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
        the [Cloudwatch Log retention].
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign source type to the data exported, eg. generic_single_line. (Splunk)
        """
        return pulumi.get(self, "sourcetype")

    @sourcetype.setter
    def sourcetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sourcetype", value)

    @_builtins.property
    @pulumi.getter
    def subsystem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subsystem. (Azure Monitor)
        """
        return pulumi.get(self, "subsystem")

    @subsystem.setter
    def subsystem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subsystem", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The table name.

        Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]

        </details>

        <details>
        <summary>
        <b>Cloudwatch</b>
        </summary>

        The following arguments used by CloudWatch.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.

        ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
        Read more about tags format in the [Cloudwatch Log tags]
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant identifier.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to push the logs to. (Papertrail)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _IntegrationLogState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 dce_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 dcr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_port: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 subsystem: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationLog resources.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier.
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Datadog)
        :param pulumi.Input[_builtins.str] application: The name of the application. (Azure Monitor)
        :param pulumi.Input[_builtins.str] application_id: The application identifier.
        :param pulumi.Input[_builtins.str] application_secret: The application secret.
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] dce_uri: The data collection endpoint.
        :param pulumi.Input[_builtins.str] dcr_id: ID of data collection rule that your DCE is linked to.
        :param pulumi.Input[_builtins.str] endpoint: The syslog destination to send the logs to. (Papertrail)
        :param pulumi.Input[_builtins.str] host: The host information. (Scalyr)
        :param pulumi.Input[_builtins.str] host_port: Destination to send the logs. (Splunk)
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
               
               Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
               found here [CloudAMQP API add integration].
               
               <details>
               <summary>
               <b>Azure monitoring</b>
               </summary>
               
               The following arguments used by Azure monitoring.
        :param pulumi.Input[_builtins.str] name: The name of the third party log integration (`cloudwatchlog`).
        :param pulumi.Input[_builtins.str] private_key: The private API key used for authentication. (Stackdriver, Coralogix)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: The project ID for the integration service. (Stackdriver)
        :param pulumi.Input[_builtins.str] region: AWS region hosting the integration service.
               
               Optional arguments introduced in version [v1.38.0].
        :param pulumi.Input[_builtins.int] retention: Number of days to retain log events in `CloudAMQP` log group.
               
               ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
               the [Cloudwatch Log retention].
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret access key.
        :param pulumi.Input[_builtins.str] sourcetype: Assign source type to the data exported, eg. generic_single_line. (Splunk)
        :param pulumi.Input[_builtins.str] subsystem: The name of the subsystem. (Azure Monitor)
        :param pulumi.Input[_builtins.str] table: The table name.
               
               Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]
               
               </details>
               
               <details>
               <summary>
               <b>Cloudwatch</b>
               </summary>
               
               The following arguments used by CloudWatch.
        :param pulumi.Input[_builtins.str] tags: Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.
               
               ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
               Read more about tags format in the [Cloudwatch Log tags]
        :param pulumi.Input[_builtins.str] tenant_id: The tenant identifier.
        :param pulumi.Input[_builtins.str] token: The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        :param pulumi.Input[_builtins.str] url: The URL to push the logs to. (Papertrail)
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if dce_uri is not None:
            pulumi.set(__self__, "dce_uri", dce_uri)
        if dcr_id is not None:
            pulumi.set(__self__, "dcr_id", dcr_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if sourcetype is not None:
            pulumi.set(__self__, "sourcetype", sourcetype)
        if subsystem is not None:
            pulumi.set(__self__, "subsystem", subsystem)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Datadog)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application. (Azure Monitor)
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application identifier.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application secret.
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_secret", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="dceUri")
    def dce_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data collection endpoint.
        """
        return pulumi.get(self, "dce_uri")

    @dce_uri.setter
    def dce_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dce_uri", value)

    @_builtins.property
    @pulumi.getter(name="dcrId")
    def dcr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of data collection rule that your DCE is linked to.
        """
        return pulumi.get(self, "dcr_id")

    @dcr_id.setter
    def dcr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dcr_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The syslog destination to send the logs to. (Papertrail)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host information. (Scalyr)
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination to send the logs. (Splunk)
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_port", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance identifier for the CloudAMQP instance.

        Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
        found here [CloudAMQP API add integration].

        <details>
        <summary>
        <b>Azure monitoring</b>
        </summary>

        The following arguments used by Azure monitoring.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the third party log integration (`cloudwatchlog`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private API key used for authentication. (Stackdriver, Coralogix)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID for the integration service. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region hosting the integration service.

        Optional arguments introduced in version [v1.38.0].
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days to retain log events in `CloudAMQP` log group.

        ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
        the [Cloudwatch Log retention].
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign source type to the data exported, eg. generic_single_line. (Splunk)
        """
        return pulumi.get(self, "sourcetype")

    @sourcetype.setter
    def sourcetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sourcetype", value)

    @_builtins.property
    @pulumi.getter
    def subsystem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subsystem. (Azure Monitor)
        """
        return pulumi.get(self, "subsystem")

    @subsystem.setter
    def subsystem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subsystem", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The table name.

        Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]

        </details>

        <details>
        <summary>
        <b>Cloudwatch</b>
        </summary>

        The following arguments used by CloudWatch.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.

        ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
        Read more about tags format in the [Cloudwatch Log tags]
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant identifier.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to push the logs to. (Papertrail)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("cloudamqp:index/integrationLog:IntegrationLog")
class IntegrationLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 dce_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 dcr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_port: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 subsystem: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage third party log integrations for a CloudAMQP instance.
        Once configured, the logs produced will be forward to corresponding integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Azure monitor log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        azure_monitor = cloudamqp.IntegrationLog("azure_monitor",
            instance_id=instance["id"],
            name="azure_monitor",
            tenant_id=azm_tentant_id,
            application_id=azm_application_id,
            application_secret=azm_application_secret,
            dce_uri=azm_dce_uri,
            table=azm_table,
            dcr_id=azm_dcr_id)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Cloudwatch log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationLog("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatchlog",
            access_key_id=aws_access_key_id,
            secret_access_key=aws_secret_access_key,
            region=aws_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Cloudwatch log integration with retention and tags (from [v1.38.0])</i>
            </b>
          </summary>

        Use retention and/or tags on the integration to make changes to `CloudAMQP` Log Group.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationLog("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatchlog",
            access_key_id=aws_access_key_id,
            secret_access_key=aws_secret_access_key,
            region=aws_region,
            retention=14,
            tags="Project=A,Environment=Development")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Coralogix log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        coralogix = cloudamqp.IntegrationLog("coralogix",
            instance_id=instance["id"],
            name="coralogix",
            private_key=coralogix_send_data_key,
            endpoint=coralogix_endpoint,
            application=coralogix_application,
            subsystem=instance["host"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationLog("datadog",
            instance_id=instance["id"],
            name="datadog",
            region=datadog_region,
            api_key=datadog_api_key,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Log entries log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        logentries = cloudamqp.IntegrationLog("logentries",
            instance_id=instance["id"],
            name="logentries",
            token=logentries_token)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Loggly log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        loggly = cloudamqp.IntegrationLog("loggly",
            instance_id=instance["id"],
            name="loggly",
            token=loggly_token)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Papertrail log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        papertrail = cloudamqp.IntegrationLog("papertrail",
            instance_id=instance["id"],
            name="papertrail",
            url=papertrail_url)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Scalyr log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        scalyr = cloudamqp.IntegrationLog("scalyr",
            instance_id=instance["id"],
            name="scalyr",
            token=scalyr_token,
            host=scalyr_host)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Splunk log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        splunk = cloudamqp.IntegrationLog("splunk",
            instance_id=instance["id"],
            name="splunk",
            token=splunk_token,
            host_port=splunk_host_port,
            source_type="generic_single_line")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver log integration (v1.20.2 or older versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackdriver_client_email)
        ```

        or by using google_service_account_key resource from Google provider

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver log integration (v1.21.0 or newer versions)</i>
            </b>
          </summary>

        Use credentials argument and let the provider do the Base64decode and internally populate,
        *project_id, client_name, private_key*

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            credentials=service_account_key["privateKey"])
        ```

        or use the same as earlier version and decode the google service account key

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_integration_log`can be imported using the resource identifier together with CloudAMQP

        instance identifier. The identifiers are CSV separated, see example below. To retrieve the resource,

        use [CloudAMQP API list integration].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_integration_log.this

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        ```sh
        $ pulumi import cloudamqp:index/integrationLog:IntegrationLog this <id>,<instance_id>`
        ```

        [v1.38.0]: https://github.com/cloudamqp/terraform-provider-cloudamqp/releases/tag/v1.38.0

        [CloudAMQP API add integration]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/post/integrations/logs/{system}

        [Tutorial to find/create all arguments]: https://learn.microsoft.com/en-us/azure/azure-monitor/logs/tutorial-logs-ingestion-portal

        [Cloudwatch Log retention]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html#API_PutRetentionPolicy_RequestSyntax

        [Cloudwatch Log tags]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagLogGroup.html#API_TagLogGroup_RequestSyntax

        [Coralogix documentation]: https://coralogix.com/docs/send-your-data-api-key/

        [app.datadoghq.com]: https://app.datadoghq.com/

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [logentries add-log]: https://logentries.com/app#/add-log/manual

        [CloudAMQP API list integration]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/get/integrations/logs

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier.
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Datadog)
        :param pulumi.Input[_builtins.str] application: The name of the application. (Azure Monitor)
        :param pulumi.Input[_builtins.str] application_id: The application identifier.
        :param pulumi.Input[_builtins.str] application_secret: The application secret.
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] dce_uri: The data collection endpoint.
        :param pulumi.Input[_builtins.str] dcr_id: ID of data collection rule that your DCE is linked to.
        :param pulumi.Input[_builtins.str] endpoint: The syslog destination to send the logs to. (Papertrail)
        :param pulumi.Input[_builtins.str] host: The host information. (Scalyr)
        :param pulumi.Input[_builtins.str] host_port: Destination to send the logs. (Splunk)
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
               
               Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
               found here [CloudAMQP API add integration].
               
               <details>
               <summary>
               <b>Azure monitoring</b>
               </summary>
               
               The following arguments used by Azure monitoring.
        :param pulumi.Input[_builtins.str] name: The name of the third party log integration (`cloudwatchlog`).
        :param pulumi.Input[_builtins.str] private_key: The private API key used for authentication. (Stackdriver, Coralogix)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: The project ID for the integration service. (Stackdriver)
        :param pulumi.Input[_builtins.str] region: AWS region hosting the integration service.
               
               Optional arguments introduced in version [v1.38.0].
        :param pulumi.Input[_builtins.int] retention: Number of days to retain log events in `CloudAMQP` log group.
               
               ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
               the [Cloudwatch Log retention].
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret access key.
        :param pulumi.Input[_builtins.str] sourcetype: Assign source type to the data exported, eg. generic_single_line. (Splunk)
        :param pulumi.Input[_builtins.str] subsystem: The name of the subsystem. (Azure Monitor)
        :param pulumi.Input[_builtins.str] table: The table name.
               
               Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]
               
               </details>
               
               <details>
               <summary>
               <b>Cloudwatch</b>
               </summary>
               
               The following arguments used by CloudWatch.
        :param pulumi.Input[_builtins.str] tags: Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.
               
               ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
               Read more about tags format in the [Cloudwatch Log tags]
        :param pulumi.Input[_builtins.str] tenant_id: The tenant identifier.
        :param pulumi.Input[_builtins.str] token: The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        :param pulumi.Input[_builtins.str] url: The URL to push the logs to. (Papertrail)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage third party log integrations for a CloudAMQP instance.
        Once configured, the logs produced will be forward to corresponding integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Azure monitor log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        azure_monitor = cloudamqp.IntegrationLog("azure_monitor",
            instance_id=instance["id"],
            name="azure_monitor",
            tenant_id=azm_tentant_id,
            application_id=azm_application_id,
            application_secret=azm_application_secret,
            dce_uri=azm_dce_uri,
            table=azm_table,
            dcr_id=azm_dcr_id)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Cloudwatch log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationLog("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatchlog",
            access_key_id=aws_access_key_id,
            secret_access_key=aws_secret_access_key,
            region=aws_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Cloudwatch log integration with retention and tags (from [v1.38.0])</i>
            </b>
          </summary>

        Use retention and/or tags on the integration to make changes to `CloudAMQP` Log Group.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationLog("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatchlog",
            access_key_id=aws_access_key_id,
            secret_access_key=aws_secret_access_key,
            region=aws_region,
            retention=14,
            tags="Project=A,Environment=Development")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Coralogix log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        coralogix = cloudamqp.IntegrationLog("coralogix",
            instance_id=instance["id"],
            name="coralogix",
            private_key=coralogix_send_data_key,
            endpoint=coralogix_endpoint,
            application=coralogix_application,
            subsystem=instance["host"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationLog("datadog",
            instance_id=instance["id"],
            name="datadog",
            region=datadog_region,
            api_key=datadog_api_key,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Log entries log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        logentries = cloudamqp.IntegrationLog("logentries",
            instance_id=instance["id"],
            name="logentries",
            token=logentries_token)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Loggly log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        loggly = cloudamqp.IntegrationLog("loggly",
            instance_id=instance["id"],
            name="loggly",
            token=loggly_token)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Papertrail log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        papertrail = cloudamqp.IntegrationLog("papertrail",
            instance_id=instance["id"],
            name="papertrail",
            url=papertrail_url)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Scalyr log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        scalyr = cloudamqp.IntegrationLog("scalyr",
            instance_id=instance["id"],
            name="scalyr",
            token=scalyr_token,
            host=scalyr_host)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Splunk log integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        splunk = cloudamqp.IntegrationLog("splunk",
            instance_id=instance["id"],
            name="splunk",
            token=splunk_token,
            host_port=splunk_host_port,
            source_type="generic_single_line")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver log integration (v1.20.2 or older versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackdriver_client_email)
        ```

        or by using google_service_account_key resource from Google provider

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver log integration (v1.21.0 or newer versions)</i>
            </b>
          </summary>

        Use credentials argument and let the provider do the Base64decode and internally populate,
        *project_id, client_name, private_key*

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            credentials=service_account_key["privateKey"])
        ```

        or use the same as earlier version and decode the google service account key

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationLog("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_integration_log`can be imported using the resource identifier together with CloudAMQP

        instance identifier. The identifiers are CSV separated, see example below. To retrieve the resource,

        use [CloudAMQP API list integration].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_integration_log.this

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        ```sh
        $ pulumi import cloudamqp:index/integrationLog:IntegrationLog this <id>,<instance_id>`
        ```

        [v1.38.0]: https://github.com/cloudamqp/terraform-provider-cloudamqp/releases/tag/v1.38.0

        [CloudAMQP API add integration]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/post/integrations/logs/{system}

        [Tutorial to find/create all arguments]: https://learn.microsoft.com/en-us/azure/azure-monitor/logs/tutorial-logs-ingestion-portal

        [Cloudwatch Log retention]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html#API_PutRetentionPolicy_RequestSyntax

        [Cloudwatch Log tags]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagLogGroup.html#API_TagLogGroup_RequestSyntax

        [Coralogix documentation]: https://coralogix.com/docs/send-your-data-api-key/

        [app.datadoghq.com]: https://app.datadoghq.com/

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [logentries add-log]: https://logentries.com/app#/add-log/manual

        [CloudAMQP API list integration]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/get/integrations/logs

        :param str resource_name: The name of the resource.
        :param IntegrationLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 dce_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 dcr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_port: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 subsystem: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationLogArgs.__new__(IntegrationLogArgs)

            __props__.__dict__["access_key_id"] = None if access_key_id is None else pulumi.Output.secret(access_key_id)
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["application"] = application
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["application_secret"] = None if application_secret is None else pulumi.Output.secret(application_secret)
            __props__.__dict__["client_email"] = client_email
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["dce_uri"] = dce_uri
            __props__.__dict__["dcr_id"] = dcr_id
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["host"] = host
            __props__.__dict__["host_port"] = host_port
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["private_key_id"] = None if private_key_id is None else pulumi.Output.secret(private_key_id)
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["retention"] = retention
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            __props__.__dict__["sourcetype"] = sourcetype
            __props__.__dict__["subsystem"] = subsystem
            __props__.__dict__["table"] = table
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["url"] = url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKeyId", "apiKey", "applicationSecret", "credentials", "privateKey", "privateKeyId", "secretAccessKey", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationLog, __self__).__init__(
            'cloudamqp:index/integrationLog:IntegrationLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            application: Optional[pulumi.Input[_builtins.str]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            application_secret: Optional[pulumi.Input[_builtins.str]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            dce_uri: Optional[pulumi.Input[_builtins.str]] = None,
            dcr_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            host_port: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retention: Optional[pulumi.Input[_builtins.int]] = None,
            secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
            subsystem: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationLog':
        """
        Get an existing IntegrationLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier.
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Datadog)
        :param pulumi.Input[_builtins.str] application: The name of the application. (Azure Monitor)
        :param pulumi.Input[_builtins.str] application_id: The application identifier.
        :param pulumi.Input[_builtins.str] application_secret: The application secret.
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] dce_uri: The data collection endpoint.
        :param pulumi.Input[_builtins.str] dcr_id: ID of data collection rule that your DCE is linked to.
        :param pulumi.Input[_builtins.str] endpoint: The syslog destination to send the logs to. (Papertrail)
        :param pulumi.Input[_builtins.str] host: The host information. (Scalyr)
        :param pulumi.Input[_builtins.str] host_port: Destination to send the logs. (Splunk)
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
               
               Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
               found here [CloudAMQP API add integration].
               
               <details>
               <summary>
               <b>Azure monitoring</b>
               </summary>
               
               The following arguments used by Azure monitoring.
        :param pulumi.Input[_builtins.str] name: The name of the third party log integration (`cloudwatchlog`).
        :param pulumi.Input[_builtins.str] private_key: The private API key used for authentication. (Stackdriver, Coralogix)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: The project ID for the integration service. (Stackdriver)
        :param pulumi.Input[_builtins.str] region: AWS region hosting the integration service.
               
               Optional arguments introduced in version [v1.38.0].
        :param pulumi.Input[_builtins.int] retention: Number of days to retain log events in `CloudAMQP` log group.
               
               ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
               the [Cloudwatch Log retention].
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret access key.
        :param pulumi.Input[_builtins.str] sourcetype: Assign source type to the data exported, eg. generic_single_line. (Splunk)
        :param pulumi.Input[_builtins.str] subsystem: The name of the subsystem. (Azure Monitor)
        :param pulumi.Input[_builtins.str] table: The table name.
               
               Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]
               
               </details>
               
               <details>
               <summary>
               <b>Cloudwatch</b>
               </summary>
               
               The following arguments used by CloudWatch.
        :param pulumi.Input[_builtins.str] tags: Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.
               
               ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
               Read more about tags format in the [Cloudwatch Log tags]
        :param pulumi.Input[_builtins.str] tenant_id: The tenant identifier.
        :param pulumi.Input[_builtins.str] token: The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        :param pulumi.Input[_builtins.str] url: The URL to push the logs to. (Papertrail)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationLogState.__new__(_IntegrationLogState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["application"] = application
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_secret"] = application_secret
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["dce_uri"] = dce_uri
        __props__.__dict__["dcr_id"] = dcr_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["host"] = host
        __props__.__dict__["host_port"] = host_port
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["retention"] = retention
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["sourcetype"] = sourcetype
        __props__.__dict__["subsystem"] = subsystem
        __props__.__dict__["table"] = table
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["token"] = token
        __props__.__dict__["url"] = url
        return IntegrationLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS access key identifier.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API key for the integration service. (Datadog)
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def application(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the application. (Azure Monitor)
        """
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application identifier.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application secret.
        """
        return pulumi.get(self, "application_secret")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="dceUri")
    def dce_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data collection endpoint.
        """
        return pulumi.get(self, "dce_uri")

    @_builtins.property
    @pulumi.getter(name="dcrId")
    def dcr_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of data collection rule that your DCE is linked to.
        """
        return pulumi.get(self, "dcr_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The syslog destination to send the logs to. (Papertrail)
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The host information. (Scalyr)
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Destination to send the logs. (Splunk)
        """
        return pulumi.get(self, "host_port")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        Instance identifier for the CloudAMQP instance.

        Valid arguments for each third party log integrations below. Corresponding API backend documentation can be
        found here [CloudAMQP API add integration].

        <details>
        <summary>
        <b>Azure monitoring</b>
        </summary>

        The following arguments used by Azure monitoring.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the third party log integration (`cloudwatchlog`).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private API key used for authentication. (Stackdriver, Coralogix)
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID for the integration service. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS region hosting the integration service.

        Optional arguments introduced in version [v1.38.0].
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of days to retain log events in `CloudAMQP` log group.

        ***Note:*** Possible values are: 0 (never expire) or between 1-3653, read more about valid values in
        the [Cloudwatch Log retention].
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "secret_access_key")

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assign source type to the data exported, eg. generic_single_line. (Splunk)
        """
        return pulumi.get(self, "sourcetype")

    @_builtins.property
    @pulumi.getter
    def subsystem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the subsystem. (Azure Monitor)
        """
        return pulumi.get(self, "subsystem")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The table name.

        Use Azure portal to configure external access for Azure Monitor. [Tutorial to find/create all arguments]

        </details>

        <details>
        <summary>
        <b>Cloudwatch</b>
        </summary>

        The following arguments used by CloudWatch.
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enter tags to `CloudAMQP` log group like this: `Project=A,Environment=Development`.

        ***Note:*** Tags are only added, unwanted tags needs to be removed manually in the AWS console.
        Read more about tags format in the [Cloudwatch Log tags]
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The tenant identifier.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The token used for authentication. (Loggly, Logentries, Splunk, Scalyr)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL to push the logs to. (Papertrail)
        """
        return pulumi.get(self, "url")

