# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntegrationMetricArgs', 'IntegrationMetric']

@pulumi.input_type
class IntegrationMetricArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationMetric resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.str] name: The name of log integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if iam_external_id is not None:
            pulumi.set(__self__, "iam_external_id", iam_external_id)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if include_ad_queues is not None:
            pulumi.set(__self__, "include_ad_queues", include_ad_queues)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if queue_allowlist is not None:
            pulumi.set(__self__, "queue_allowlist", queue_allowlist)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vhost_allowlist is not None:
            pulumi.set(__self__, "vhost_allowlist", vhost_allowlist)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Librato, Data Dog, New Relic)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @iam_external_id.setter
    def iam_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @include_ad_queues.setter
    def include_ad_queues(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_ad_queues", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of log integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @queue_allowlist.setter
    def queue_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_allowlist", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @vhost_allowlist.setter
    def vhost_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_allowlist", value)


@pulumi.input_type
class _IntegrationMetricState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationMetric resources.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] name: The name of log integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if iam_external_id is not None:
            pulumi.set(__self__, "iam_external_id", iam_external_id)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if include_ad_queues is not None:
            pulumi.set(__self__, "include_ad_queues", include_ad_queues)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if queue_allowlist is not None:
            pulumi.set(__self__, "queue_allowlist", queue_allowlist)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vhost_allowlist is not None:
            pulumi.set(__self__, "vhost_allowlist", vhost_allowlist)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for the integration service. (Librato, Data Dog, New Relic)
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @iam_external_id.setter
    def iam_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @include_ad_queues.setter
    def include_ad_queues(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_ad_queues", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of log integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @queue_allowlist.setter
    def queue_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_allowlist", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @vhost_allowlist.setter
    def vhost_allowlist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost_allowlist", value)


@pulumi.type_token("cloudamqp:index/integrationMetric:IntegrationMetric")
class IntegrationMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage, forwarding metrics to third party integrations for a
        CloudAMQP instance. Once configured, the metrics produced will be forward to corresponding
        integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Cloudwatch v1 and v2 metric integration</i>
            </b>
          </summary>

        ***Access key***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        ```

        ***Assume role***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        ```

        * AWS IAM role: arn:aws:iam::ACCOUNT-ID:role/ROLE-NAME
        * External id: Create own external identifier that match the role created. E.g. "cloudamqp-abc123".

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog v1 and v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationMetric("datadog",
            instance_id=instance["id"],
            name="datadog",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        datadog_v2 = cloudamqp.IntegrationMetric("datadog_v2",
            instance_id=instance["id"],
            name="datadog_v2",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Librato metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        librato = cloudamqp.IntegrationMetric("librato",
            instance_id=instance["id"],
            name="librato",
            email=librato_email,
            api_key=librato_api_key)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>New relic v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic = cloudamqp.IntegrationMetric("newrelic",
            instance_id=instance["id"],
            name="newrelic_v2",
            api_key=newrelic_api_key,
            region=newrelic_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.20.2 or earlier versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackriver_email)
        ```

        or by using google_service_account_key resource from Google provider

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.21.0 or newer versions)</i>
            </b>
          </summary>

        Use credentials argument and let the provider do the Base64decode and internally populate,
        *project_id, client_name, private_key*

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            credentials=service_account_key["privateKey"])
        ```

        or use the same as earlier version and decode the google service account key

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        ## Argument References

        The following arguments are supported:

        * `name`              - (Required) The name of the third party log integration. See
                              `Integration service reference`
        * `region`            - (Optional) Region hosting the integration service.
        * `access_key_id`     - (Optional) AWS access key identifier.
        * `secret_access_key` - (Optional) AWS secret access key.
        * `iam_role`          - (Optional) The ARN of the role to be assumed when publishing metrics.
        * `iam_external_id`   - (Optional) External identifier that match the role you created.
        * `api_key`           - (Optional) The API key for the integration service.
        * `email`             - (Optional) The email address registred for the integration service.
        * `credentials`       - (Optional) Google Service Account private key credentials.
        * `project_id`        - (Optional/Computed) The project identifier.
        * `private_key`       - (Optional/Computed) The private access key.
        * `client_email`      - (Optional/Computed) The client email registered for the integration service.
        * `tags`              - (Optional) Tags. e.g. `env=prod,region=europe`.
          
          ***Note:*** If tags are used with Datadog. The value part (prod, europe, ...) must start with a
                    letter, read more about tags format in the [Datadog documentation].

        * `queue_allowlist`   - (Optional) Allowlist queues using regular expression. Leave empty to include
                              all queues.
        * `vhost_allowlist`   - (Optional) Allowlist vhost using regular expression. Leave empty to include
                              all vhosts.
        * `queue_whitelist`   - **Deprecated** Use queue_allowlist instead
        * `vhost_whitelist`   - **Deprecated** Use vhost_allowlist instead
        * `include_ad_queues` - (Optional) Include auto delete queues.

        This is the full list of all arguments. Only a subset of arguments are used based on which type of
        integration used. See [integration type reference] below for more information.

        ## Integration service references

        Valid names for third party log integration.

        | Name          | Description |
        |---------------|---------------------------------------------------------------|
        | cloudwatch    | Access key: Create an IAM user with permission to `PutMetricData` |
        | cloudwatch_v2 | Access key: Create an IAM user with permission to `PutMetricData` |
        | cloudwatch    | Assume role: Create a IAM role with the permission to `PutMetricData` |
        | cloudwatch_v2 | Assume role: Create a IAM role with the permission to `PutMetricData` |
        | datadog       | Create a Datadog API key at app.datadoghq.com |
        | datadog_v2    | Create a Datadog API key at app.datadoghq.com |
        | librato       | Create a new API token (with record only permissions) here: https://metrics.librato.com/tokens |
        | newrelic      | Deprecated! |
        | newrelic_v2   | Find or register an Insert API key for your account: Go to insights.newrelic.com > Manage data > API keys. |
        | stackdriver   | Create a service account and add 'monitor metrics writer' role from your Google Cloud Account |

        ## Integration type reference

        Valid arguments for third party metrics integrations. See more information at
        [CloudAMQP API add integrations].

        Required arguments for all integrations: *name*</br>
        Optional arguments for all integrations: *tags*, *queue_allowlist*, *vhost_allowlist*

        | Name                   | Type           | Required arguments                                   |
        |------------------------|----------------|------------------------------------------------------|
        | Cloudwatch             | cloudwatch     | Access key: region, access_key_id, secret_access_key |
        | Cloudwatch v2          | cloudwatch_v2  | Access key: region, access_key_id, secret_access_key |
        | Cloudwatch             | cloudwatch     | Assume role: region, iam_role, iam_external_id       |
        | Cloudwatch v2          | cloudwatch_v2  | Assume role: region, iam_role, iam_external_id       |
        | Datadog                | datadog        | api_key, region                                      |
        | Datadog v2             | datadog_v2     | api_key, region                                      |
        | Librato                | librato        | email, api_key                                       |
        | New relic (deprecated) | newrelic       | -                                                    |
        | New relic v2           | newrelic_v2    | api_key, region                                      |
        | Stackdriver            | stackdriver    | credentials                                          |

        ***Note:*** Stackdriver (v1.20.2 or earlier versions) required arguments: project_id, private_key,
        client_email

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_integration_metric`can be imported using the resource identifier together with CloudAMQP

        instance identifier (CSV separated). To retrieve the resource identifier, use

        [CloudAMQP API list integrations].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetric:IntegrationMetric <resource_name> <resource_id>,<instance_id>`
        ```

        [CloudAMQP API add integrations]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/post/integrations/metrics/{system}

        [CloudAMQP API list integrations]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/get/integrations/metrics

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [integration type reference]: #integration-type-reference

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] name: The name of log integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage, forwarding metrics to third party integrations for a
        CloudAMQP instance. Once configured, the metrics produced will be forward to corresponding
        integration.

        Only available for dedicated subscription plans.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Cloudwatch v1 and v2 metric integration</i>
            </b>
          </summary>

        ***Access key***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            access_key_id=aws_access_key_id,
            secret_access_key=var_aws_secret_acccess_key,
            region=aws_region)
        ```

        ***Assume role***

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch = cloudamqp.IntegrationMetric("cloudwatch",
            instance_id=instance["id"],
            name="cloudwatch",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        cloudwatch_v2 = cloudamqp.IntegrationMetric("cloudwatch_v2",
            instance_id=instance["id"],
            name="cloudwatch_v2",
            iam_role=aws_iam_role,
            iam_external_id=external_id,
            region=aws_region)
        ```

        * AWS IAM role: arn:aws:iam::ACCOUNT-ID:role/ROLE-NAME
        * External id: Create own external identifier that match the role created. E.g. "cloudamqp-abc123".

        </details>

        <details>
          <summary>
            <b>
              <i>Datadog v1 and v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog = cloudamqp.IntegrationMetric("datadog",
            instance_id=instance["id"],
            name="datadog",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        datadog_v2 = cloudamqp.IntegrationMetric("datadog_v2",
            instance_id=instance["id"],
            name="datadog_v2",
            api_key=datadog_api_key,
            region=datadog_region,
            tags="env=prod,region=us1,version=v1.0")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Librato metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        librato = cloudamqp.IntegrationMetric("librato",
            instance_id=instance["id"],
            name="librato",
            email=librato_email,
            api_key=librato_api_key)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>New relic v2 metric integration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic = cloudamqp.IntegrationMetric("newrelic",
            instance_id=instance["id"],
            name="newrelic_v2",
            api_key=newrelic_api_key,
            region=newrelic_region)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.20.2 or earlier versions)</i>
            </b>
          </summary>

        Use variable file populated with project_id, private_key and client_email

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=stackdriver_project_id,
            private_key=stackdriver_private_key,
            client_email=stackriver_email)
        ```

        or by using google_service_account_key resource from Google provider

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Stackdriver metric integration (v1.21.0 or newer versions)</i>
            </b>
          </summary>

        Use credentials argument and let the provider do the Base64decode and internally populate,
        *project_id, client_name, private_key*

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            credentials=service_account_key["privateKey"])
        ```

        or use the same as earlier version and decode the google service account key

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp
        import pulumi_google as google
        import pulumi_std as std

        service_account = google.index.ServiceAccount("service_account",
            account_id=<account_id>,
            description=<description>,
            display_name=<display_name>)
        service_account_key = google.index.ServiceAccountKey("service_account_key", service_account_id=service_account.name)
        stackdriver = cloudamqp.IntegrationMetric("stackdriver",
            instance_id=instance["id"],
            name="stackdriver",
            project_id=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["projectId"],
            private_key=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["privateKey"],
            client_email=std.index.jsondecode(input=std.index.base64decode(input=service_account_key["privateKey"])["result"])["result"]["clientEmail"])
        ```

        </details>

        ## Argument References

        The following arguments are supported:

        * `name`              - (Required) The name of the third party log integration. See
                              `Integration service reference`
        * `region`            - (Optional) Region hosting the integration service.
        * `access_key_id`     - (Optional) AWS access key identifier.
        * `secret_access_key` - (Optional) AWS secret access key.
        * `iam_role`          - (Optional) The ARN of the role to be assumed when publishing metrics.
        * `iam_external_id`   - (Optional) External identifier that match the role you created.
        * `api_key`           - (Optional) The API key for the integration service.
        * `email`             - (Optional) The email address registred for the integration service.
        * `credentials`       - (Optional) Google Service Account private key credentials.
        * `project_id`        - (Optional/Computed) The project identifier.
        * `private_key`       - (Optional/Computed) The private access key.
        * `client_email`      - (Optional/Computed) The client email registered for the integration service.
        * `tags`              - (Optional) Tags. e.g. `env=prod,region=europe`.
          
          ***Note:*** If tags are used with Datadog. The value part (prod, europe, ...) must start with a
                    letter, read more about tags format in the [Datadog documentation].

        * `queue_allowlist`   - (Optional) Allowlist queues using regular expression. Leave empty to include
                              all queues.
        * `vhost_allowlist`   - (Optional) Allowlist vhost using regular expression. Leave empty to include
                              all vhosts.
        * `queue_whitelist`   - **Deprecated** Use queue_allowlist instead
        * `vhost_whitelist`   - **Deprecated** Use vhost_allowlist instead
        * `include_ad_queues` - (Optional) Include auto delete queues.

        This is the full list of all arguments. Only a subset of arguments are used based on which type of
        integration used. See [integration type reference] below for more information.

        ## Integration service references

        Valid names for third party log integration.

        | Name          | Description |
        |---------------|---------------------------------------------------------------|
        | cloudwatch    | Access key: Create an IAM user with permission to `PutMetricData` |
        | cloudwatch_v2 | Access key: Create an IAM user with permission to `PutMetricData` |
        | cloudwatch    | Assume role: Create a IAM role with the permission to `PutMetricData` |
        | cloudwatch_v2 | Assume role: Create a IAM role with the permission to `PutMetricData` |
        | datadog       | Create a Datadog API key at app.datadoghq.com |
        | datadog_v2    | Create a Datadog API key at app.datadoghq.com |
        | librato       | Create a new API token (with record only permissions) here: https://metrics.librato.com/tokens |
        | newrelic      | Deprecated! |
        | newrelic_v2   | Find or register an Insert API key for your account: Go to insights.newrelic.com > Manage data > API keys. |
        | stackdriver   | Create a service account and add 'monitor metrics writer' role from your Google Cloud Account |

        ## Integration type reference

        Valid arguments for third party metrics integrations. See more information at
        [CloudAMQP API add integrations].

        Required arguments for all integrations: *name*</br>
        Optional arguments for all integrations: *tags*, *queue_allowlist*, *vhost_allowlist*

        | Name                   | Type           | Required arguments                                   |
        |------------------------|----------------|------------------------------------------------------|
        | Cloudwatch             | cloudwatch     | Access key: region, access_key_id, secret_access_key |
        | Cloudwatch v2          | cloudwatch_v2  | Access key: region, access_key_id, secret_access_key |
        | Cloudwatch             | cloudwatch     | Assume role: region, iam_role, iam_external_id       |
        | Cloudwatch v2          | cloudwatch_v2  | Assume role: region, iam_role, iam_external_id       |
        | Datadog                | datadog        | api_key, region                                      |
        | Datadog v2             | datadog_v2     | api_key, region                                      |
        | Librato                | librato        | email, api_key                                       |
        | New relic (deprecated) | newrelic       | -                                                    |
        | New relic v2           | newrelic_v2    | api_key, region                                      |
        | Stackdriver            | stackdriver    | credentials                                          |

        ***Note:*** Stackdriver (v1.20.2 or earlier versions) required arguments: project_id, private_key,
        client_email

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_integration_metric`can be imported using the resource identifier together with CloudAMQP

        instance identifier (CSV separated). To retrieve the resource identifier, use

        [CloudAMQP API list integrations].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_alarm.alarm

          id = format("<id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetric:IntegrationMetric <resource_name> <resource_id>,<instance_id>`
        ```

        [CloudAMQP API add integrations]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/post/integrations/metrics/{system}

        [CloudAMQP API list integrations]: https://docs.cloudamqp.com/instance-api.html#tag/integrations/get/integrations/metrics

        [Datadog documentation]: https://docs.datadoghq.com/getting_started/tagging/#define-tags

        [integration type reference]: #integration-type-reference

        :param str resource_name: The name of the resource.
        :param IntegrationMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationMetricArgs.__new__(IntegrationMetricArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["client_email"] = client_email
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["email"] = email
            __props__.__dict__["iam_external_id"] = iam_external_id
            __props__.__dict__["iam_role"] = iam_role
            __props__.__dict__["include_ad_queues"] = include_ad_queues
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["private_key_id"] = None if private_key_id is None else pulumi.Output.secret(private_key_id)
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["queue_allowlist"] = queue_allowlist
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vhost_allowlist"] = vhost_allowlist
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "credentials", "privateKey", "privateKeyId", "secretAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationMetric, __self__).__init__(
            'cloudamqp:index/integrationMetric:IntegrationMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            iam_external_id: Optional[pulumi.Input[_builtins.str]] = None,
            iam_role: Optional[pulumi.Input[_builtins.str]] = None,
            include_ad_queues: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            queue_allowlist: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[_builtins.str]] = None,
            vhost_allowlist: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationMetric':
        """
        Get an existing IntegrationMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[_builtins.str] api_key: The API key for the integration service. (Librato, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[_builtins.str] credentials: Base64Encoded credentials. (Stackdriver)
        :param pulumi.Input[_builtins.str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[_builtins.str] iam_external_id: External identifier that match the role you created. (Cloudwatch)
        :param pulumi.Input[_builtins.str] iam_role: The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        :param pulumi.Input[_builtins.bool] include_ad_queues: (optional) Include Auto-Delete queues
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier
        :param pulumi.Input[_builtins.str] name: The name of log integration
        :param pulumi.Input[_builtins.str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[_builtins.str] private_key_id: Private key identifier. (Stackdriver)
        :param pulumi.Input[_builtins.str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[_builtins.str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[_builtins.str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[_builtins.str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[_builtins.str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[_builtins.str] vhost_allowlist: (optional) allowlist using regular expression
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationMetricState.__new__(_IntegrationMetricState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["email"] = email
        __props__.__dict__["iam_external_id"] = iam_external_id
        __props__.__dict__["iam_role"] = iam_role
        __props__.__dict__["include_ad_queues"] = include_ad_queues
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["queue_allowlist"] = queue_allowlist
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vhost_allowlist"] = vhost_allowlist
        return IntegrationMetric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API key for the integration service. (Librato, Data Dog, New Relic)
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64Encoded credentials. (Stackdriver)
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External identifier that match the role you created. (Cloudwatch)
        """
        return pulumi.get(self, "iam_external_id")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the role to be assumed when publishing metrics. (Cloudwatch)
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter(name="includeAdQueues")
    def include_ad_queues(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (optional) Include Auto-Delete queues
        """
        return pulumi.get(self, "include_ad_queues")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of log integration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Private key identifier. (Stackdriver)
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

