# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationMetricPrometheusArgs', 'IntegrationMetricPrometheus']

@pulumi.input_type
class IntegrationMetricPrometheusArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 azure_monitor: Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']] = None,
                 cloudwatch_v3: Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']] = None,
                 datadog_v3: Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']] = None,
                 dynatrace: Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']] = None,
                 metrics_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 newrelic_v3: Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']] = None,
                 splunk_v2: Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']] = None,
                 stackdriver_v2: Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']] = None):
        """
        The set of arguments for constructing a IntegrationMetricPrometheus resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metrics_filters: List of metrics to include in the integration. If not specified, default metrics are included.
               For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).
               
               Exactly one of the following integration blocks must be specified:
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if azure_monitor is not None:
            pulumi.set(__self__, "azure_monitor", azure_monitor)
        if cloudwatch_v3 is not None:
            pulumi.set(__self__, "cloudwatch_v3", cloudwatch_v3)
        if datadog_v3 is not None:
            pulumi.set(__self__, "datadog_v3", datadog_v3)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if metrics_filters is not None:
            pulumi.set(__self__, "metrics_filters", metrics_filters)
        if newrelic_v3 is not None:
            pulumi.set(__self__, "newrelic_v3", newrelic_v3)
        if splunk_v2 is not None:
            pulumi.set(__self__, "splunk_v2", splunk_v2)
        if stackdriver_v2 is not None:
            pulumi.set(__self__, "stackdriver_v2", stackdriver_v2)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        Instance identifier for the CloudAMQP instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="azureMonitor")
    def azure_monitor(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']]:
        return pulumi.get(self, "azure_monitor")

    @azure_monitor.setter
    def azure_monitor(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']]):
        pulumi.set(self, "azure_monitor", value)

    @_builtins.property
    @pulumi.getter(name="cloudwatchV3")
    def cloudwatch_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']]:
        return pulumi.get(self, "cloudwatch_v3")

    @cloudwatch_v3.setter
    def cloudwatch_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']]):
        pulumi.set(self, "cloudwatch_v3", value)

    @_builtins.property
    @pulumi.getter(name="datadogV3")
    def datadog_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']]:
        return pulumi.get(self, "datadog_v3")

    @datadog_v3.setter
    def datadog_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']]):
        pulumi.set(self, "datadog_v3", value)

    @_builtins.property
    @pulumi.getter
    def dynatrace(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']]:
        return pulumi.get(self, "dynatrace")

    @dynatrace.setter
    def dynatrace(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']]):
        pulumi.set(self, "dynatrace", value)

    @_builtins.property
    @pulumi.getter(name="metricsFilters")
    def metrics_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of metrics to include in the integration. If not specified, default metrics are included.
        For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).

        Exactly one of the following integration blocks must be specified:
        """
        return pulumi.get(self, "metrics_filters")

    @metrics_filters.setter
    def metrics_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metrics_filters", value)

    @_builtins.property
    @pulumi.getter(name="newrelicV3")
    def newrelic_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']]:
        return pulumi.get(self, "newrelic_v3")

    @newrelic_v3.setter
    def newrelic_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']]):
        pulumi.set(self, "newrelic_v3", value)

    @_builtins.property
    @pulumi.getter(name="splunkV2")
    def splunk_v2(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']]:
        return pulumi.get(self, "splunk_v2")

    @splunk_v2.setter
    def splunk_v2(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']]):
        pulumi.set(self, "splunk_v2", value)

    @_builtins.property
    @pulumi.getter(name="stackdriverV2")
    def stackdriver_v2(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']]:
        return pulumi.get(self, "stackdriver_v2")

    @stackdriver_v2.setter
    def stackdriver_v2(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']]):
        pulumi.set(self, "stackdriver_v2", value)


@pulumi.input_type
class _IntegrationMetricPrometheusState:
    def __init__(__self__, *,
                 azure_monitor: Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']] = None,
                 cloudwatch_v3: Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']] = None,
                 datadog_v3: Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']] = None,
                 dynatrace: Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 newrelic_v3: Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']] = None,
                 splunk_v2: Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']] = None,
                 stackdriver_v2: Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']] = None):
        """
        Input properties used for looking up and filtering IntegrationMetricPrometheus resources.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metrics_filters: List of metrics to include in the integration. If not specified, default metrics are included.
               For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).
               
               Exactly one of the following integration blocks must be specified:
        """
        if azure_monitor is not None:
            pulumi.set(__self__, "azure_monitor", azure_monitor)
        if cloudwatch_v3 is not None:
            pulumi.set(__self__, "cloudwatch_v3", cloudwatch_v3)
        if datadog_v3 is not None:
            pulumi.set(__self__, "datadog_v3", datadog_v3)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if metrics_filters is not None:
            pulumi.set(__self__, "metrics_filters", metrics_filters)
        if newrelic_v3 is not None:
            pulumi.set(__self__, "newrelic_v3", newrelic_v3)
        if splunk_v2 is not None:
            pulumi.set(__self__, "splunk_v2", splunk_v2)
        if stackdriver_v2 is not None:
            pulumi.set(__self__, "stackdriver_v2", stackdriver_v2)

    @_builtins.property
    @pulumi.getter(name="azureMonitor")
    def azure_monitor(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']]:
        return pulumi.get(self, "azure_monitor")

    @azure_monitor.setter
    def azure_monitor(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusAzureMonitorArgs']]):
        pulumi.set(self, "azure_monitor", value)

    @_builtins.property
    @pulumi.getter(name="cloudwatchV3")
    def cloudwatch_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']]:
        return pulumi.get(self, "cloudwatch_v3")

    @cloudwatch_v3.setter
    def cloudwatch_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusCloudwatchV3Args']]):
        pulumi.set(self, "cloudwatch_v3", value)

    @_builtins.property
    @pulumi.getter(name="datadogV3")
    def datadog_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']]:
        return pulumi.get(self, "datadog_v3")

    @datadog_v3.setter
    def datadog_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusDatadogV3Args']]):
        pulumi.set(self, "datadog_v3", value)

    @_builtins.property
    @pulumi.getter
    def dynatrace(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']]:
        return pulumi.get(self, "dynatrace")

    @dynatrace.setter
    def dynatrace(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusDynatraceArgs']]):
        pulumi.set(self, "dynatrace", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance identifier for the CloudAMQP instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsFilters")
    def metrics_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of metrics to include in the integration. If not specified, default metrics are included.
        For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).

        Exactly one of the following integration blocks must be specified:
        """
        return pulumi.get(self, "metrics_filters")

    @metrics_filters.setter
    def metrics_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metrics_filters", value)

    @_builtins.property
    @pulumi.getter(name="newrelicV3")
    def newrelic_v3(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']]:
        return pulumi.get(self, "newrelic_v3")

    @newrelic_v3.setter
    def newrelic_v3(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusNewrelicV3Args']]):
        pulumi.set(self, "newrelic_v3", value)

    @_builtins.property
    @pulumi.getter(name="splunkV2")
    def splunk_v2(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']]:
        return pulumi.get(self, "splunk_v2")

    @splunk_v2.setter
    def splunk_v2(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusSplunkV2Args']]):
        pulumi.set(self, "splunk_v2", value)

    @_builtins.property
    @pulumi.getter(name="stackdriverV2")
    def stackdriver_v2(self) -> Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']]:
        return pulumi.get(self, "stackdriver_v2")

    @stackdriver_v2.setter
    def stackdriver_v2(self, value: Optional[pulumi.Input['IntegrationMetricPrometheusStackdriverV2Args']]):
        pulumi.set(self, "stackdriver_v2", value)


@pulumi.type_token("cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus")
class IntegrationMetricPrometheus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_monitor: Optional[pulumi.Input[Union['IntegrationMetricPrometheusAzureMonitorArgs', 'IntegrationMetricPrometheusAzureMonitorArgsDict']]] = None,
                 cloudwatch_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusCloudwatchV3Args', 'IntegrationMetricPrometheusCloudwatchV3ArgsDict']]] = None,
                 datadog_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDatadogV3Args', 'IntegrationMetricPrometheusDatadogV3ArgsDict']]] = None,
                 dynatrace: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDynatraceArgs', 'IntegrationMetricPrometheusDynatraceArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 newrelic_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusNewrelicV3Args', 'IntegrationMetricPrometheusNewrelicV3ArgsDict']]] = None,
                 splunk_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusSplunkV2Args', 'IntegrationMetricPrometheusSplunkV2ArgsDict']]] = None,
                 stackdriver_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusStackdriverV2Args', 'IntegrationMetricPrometheusStackdriverV2ArgsDict']]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage Prometheus-compatible metric integrations for CloudAMQP instances. Currently supported integrations include New Relic v3, Datadog v3, Azure Monitor, Splunk v2, Dynatrace, CloudWatch v3, and Stackdriver v2.

        ## Example Usage

        ### New Relic v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic_v3 = cloudamqp.IntegrationMetricPrometheus("newrelic_v3",
            instance_id=instance["id"],
            newrelic_v3={
                "api_key": newrelic_api_key,
                "region": "us",
                "tags": "key=value,key2=value2",
            })
        ```

        ### Datadog v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog_v3 = cloudamqp.IntegrationMetricPrometheus("datadog_v3",
            instance_id=instance["id"],
            datadog_v3={
                "api_key": datadog_api_key,
                "region": "us1",
                "tags": "key=value,key2=value2",
                "rabbitmq_dashboard_metrics_format": True,
            })
        ```

        ### Azure Monitor

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        azure_monitor = cloudamqp.IntegrationMetricPrometheus("azure_monitor",
            instance_id=instance["id"],
            azure_monitor={
                "connection_string": azure_monitor_connection_string,
            })
        ```

        ### Splunk v2

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        splunk_v2 = cloudamqp.IntegrationMetricPrometheus("splunk_v2",
            instance_id=instance["id"],
            splunk_v2={
                "token": splunk_token,
                "endpoint": splunk_endpoint,
                "tags": "key=value,key2=value2",
            })
        ```

        ### Dynatrace

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        dynatrace = cloudamqp.IntegrationMetricPrometheus("dynatrace",
            instance_id=instance["id"],
            dynatrace={
                "environment_id": dynatrace_environment_id,
                "access_token": dynatrace_access_token,
                "tags": "key=value,key2=value2",
            })
        ```

        ### CloudWatch v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch_v3 = cloudamqp.IntegrationMetricPrometheus("cloudwatch_v3",
            instance_id=instance["id"],
            cloudwatch_v3={
                "iam_role": cloudwatch_iam_role,
                "iam_external_id": cloudwatch_iam_external_id,
                "region": cloudwatch_region,
                "tags": "key=value,key2=value2",
            })
        ```

        ### Stackdriver v2

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver_v2 = cloudamqp.IntegrationMetricPrometheus("stackdriver_v2",
            instance_id=instance["id"],
            stackdriver_v2={
                "credentials_file": google_service_account_key,
                "tags": "key=value,key2=value2",
            })
        ```

        **Note:** The `credentials_file` should contain a Base64-encoded Google service account key JSON file. You can create a service account in Google Cloud Console with the "Monitoring Metric Writer" role and download the key file. Then encode it with:

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        ### Stackdriver v2

        hcl

        import {

          to = cloudamqp_integration_metric_prometheus.stackdriver_v2

          id = format("<integration_id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus newrelic_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus datadog_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus azure_monitor <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus splunk_v2 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus dynatrace <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus cloudwatch_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus stackdriver_v2 <integration_id>,<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metrics_filters: List of metrics to include in the integration. If not specified, default metrics are included.
               For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).
               
               Exactly one of the following integration blocks must be specified:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationMetricPrometheusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage Prometheus-compatible metric integrations for CloudAMQP instances. Currently supported integrations include New Relic v3, Datadog v3, Azure Monitor, Splunk v2, Dynatrace, CloudWatch v3, and Stackdriver v2.

        ## Example Usage

        ### New Relic v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        newrelic_v3 = cloudamqp.IntegrationMetricPrometheus("newrelic_v3",
            instance_id=instance["id"],
            newrelic_v3={
                "api_key": newrelic_api_key,
                "region": "us",
                "tags": "key=value,key2=value2",
            })
        ```

        ### Datadog v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        datadog_v3 = cloudamqp.IntegrationMetricPrometheus("datadog_v3",
            instance_id=instance["id"],
            datadog_v3={
                "api_key": datadog_api_key,
                "region": "us1",
                "tags": "key=value,key2=value2",
                "rabbitmq_dashboard_metrics_format": True,
            })
        ```

        ### Azure Monitor

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        azure_monitor = cloudamqp.IntegrationMetricPrometheus("azure_monitor",
            instance_id=instance["id"],
            azure_monitor={
                "connection_string": azure_monitor_connection_string,
            })
        ```

        ### Splunk v2

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        splunk_v2 = cloudamqp.IntegrationMetricPrometheus("splunk_v2",
            instance_id=instance["id"],
            splunk_v2={
                "token": splunk_token,
                "endpoint": splunk_endpoint,
                "tags": "key=value,key2=value2",
            })
        ```

        ### Dynatrace

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        dynatrace = cloudamqp.IntegrationMetricPrometheus("dynatrace",
            instance_id=instance["id"],
            dynatrace={
                "environment_id": dynatrace_environment_id,
                "access_token": dynatrace_access_token,
                "tags": "key=value,key2=value2",
            })
        ```

        ### CloudWatch v3

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        cloudwatch_v3 = cloudamqp.IntegrationMetricPrometheus("cloudwatch_v3",
            instance_id=instance["id"],
            cloudwatch_v3={
                "iam_role": cloudwatch_iam_role,
                "iam_external_id": cloudwatch_iam_external_id,
                "region": cloudwatch_region,
                "tags": "key=value,key2=value2",
            })
        ```

        ### Stackdriver v2

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        stackdriver_v2 = cloudamqp.IntegrationMetricPrometheus("stackdriver_v2",
            instance_id=instance["id"],
            stackdriver_v2={
                "credentials_file": google_service_account_key,
                "tags": "key=value,key2=value2",
            })
        ```

        **Note:** The `credentials_file` should contain a Base64-encoded Google service account key JSON file. You can create a service account in Google Cloud Console with the "Monitoring Metric Writer" role and download the key file. Then encode it with:

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        ### Stackdriver v2

        hcl

        import {

          to = cloudamqp_integration_metric_prometheus.stackdriver_v2

          id = format("<integration_id>,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus newrelic_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus datadog_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus azure_monitor <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus splunk_v2 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus dynatrace <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus cloudwatch_v3 <integration_id>,<instance_id>
        ```

        ```sh
        $ pulumi import cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus stackdriver_v2 <integration_id>,<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationMetricPrometheusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationMetricPrometheusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_monitor: Optional[pulumi.Input[Union['IntegrationMetricPrometheusAzureMonitorArgs', 'IntegrationMetricPrometheusAzureMonitorArgsDict']]] = None,
                 cloudwatch_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusCloudwatchV3Args', 'IntegrationMetricPrometheusCloudwatchV3ArgsDict']]] = None,
                 datadog_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDatadogV3Args', 'IntegrationMetricPrometheusDatadogV3ArgsDict']]] = None,
                 dynatrace: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDynatraceArgs', 'IntegrationMetricPrometheusDynatraceArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 newrelic_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusNewrelicV3Args', 'IntegrationMetricPrometheusNewrelicV3ArgsDict']]] = None,
                 splunk_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusSplunkV2Args', 'IntegrationMetricPrometheusSplunkV2ArgsDict']]] = None,
                 stackdriver_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusStackdriverV2Args', 'IntegrationMetricPrometheusStackdriverV2ArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationMetricPrometheusArgs.__new__(IntegrationMetricPrometheusArgs)

            __props__.__dict__["azure_monitor"] = azure_monitor
            __props__.__dict__["cloudwatch_v3"] = cloudwatch_v3
            __props__.__dict__["datadog_v3"] = datadog_v3
            __props__.__dict__["dynatrace"] = dynatrace
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["metrics_filters"] = metrics_filters
            __props__.__dict__["newrelic_v3"] = newrelic_v3
            __props__.__dict__["splunk_v2"] = splunk_v2
            __props__.__dict__["stackdriver_v2"] = stackdriver_v2
        super(IntegrationMetricPrometheus, __self__).__init__(
            'cloudamqp:index/integrationMetricPrometheus:IntegrationMetricPrometheus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_monitor: Optional[pulumi.Input[Union['IntegrationMetricPrometheusAzureMonitorArgs', 'IntegrationMetricPrometheusAzureMonitorArgsDict']]] = None,
            cloudwatch_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusCloudwatchV3Args', 'IntegrationMetricPrometheusCloudwatchV3ArgsDict']]] = None,
            datadog_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDatadogV3Args', 'IntegrationMetricPrometheusDatadogV3ArgsDict']]] = None,
            dynatrace: Optional[pulumi.Input[Union['IntegrationMetricPrometheusDynatraceArgs', 'IntegrationMetricPrometheusDynatraceArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            metrics_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            newrelic_v3: Optional[pulumi.Input[Union['IntegrationMetricPrometheusNewrelicV3Args', 'IntegrationMetricPrometheusNewrelicV3ArgsDict']]] = None,
            splunk_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusSplunkV2Args', 'IntegrationMetricPrometheusSplunkV2ArgsDict']]] = None,
            stackdriver_v2: Optional[pulumi.Input[Union['IntegrationMetricPrometheusStackdriverV2Args', 'IntegrationMetricPrometheusStackdriverV2ArgsDict']]] = None) -> 'IntegrationMetricPrometheus':
        """
        Get an existing IntegrationMetricPrometheus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] instance_id: Instance identifier for the CloudAMQP instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metrics_filters: List of metrics to include in the integration. If not specified, default metrics are included.
               For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).
               
               Exactly one of the following integration blocks must be specified:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationMetricPrometheusState.__new__(_IntegrationMetricPrometheusState)

        __props__.__dict__["azure_monitor"] = azure_monitor
        __props__.__dict__["cloudwatch_v3"] = cloudwatch_v3
        __props__.__dict__["datadog_v3"] = datadog_v3
        __props__.__dict__["dynatrace"] = dynatrace
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["metrics_filters"] = metrics_filters
        __props__.__dict__["newrelic_v3"] = newrelic_v3
        __props__.__dict__["splunk_v2"] = splunk_v2
        __props__.__dict__["stackdriver_v2"] = stackdriver_v2
        return IntegrationMetricPrometheus(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azureMonitor")
    def azure_monitor(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusAzureMonitor']]:
        return pulumi.get(self, "azure_monitor")

    @_builtins.property
    @pulumi.getter(name="cloudwatchV3")
    def cloudwatch_v3(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusCloudwatchV3']]:
        return pulumi.get(self, "cloudwatch_v3")

    @_builtins.property
    @pulumi.getter(name="datadogV3")
    def datadog_v3(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusDatadogV3']]:
        return pulumi.get(self, "datadog_v3")

    @_builtins.property
    @pulumi.getter
    def dynatrace(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusDynatrace']]:
        return pulumi.get(self, "dynatrace")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        Instance identifier for the CloudAMQP instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="metricsFilters")
    def metrics_filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of metrics to include in the integration. If not specified, default metrics are included.
        For more information about metrics filtering, see the [metrics filtering documentation](https://www.cloudamqp.com/docs/monitoring_metrics_splunk_v2.html#metrics-filtering).

        Exactly one of the following integration blocks must be specified:
        """
        return pulumi.get(self, "metrics_filters")

    @_builtins.property
    @pulumi.getter(name="newrelicV3")
    def newrelic_v3(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusNewrelicV3']]:
        return pulumi.get(self, "newrelic_v3")

    @_builtins.property
    @pulumi.getter(name="splunkV2")
    def splunk_v2(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusSplunkV2']]:
        return pulumi.get(self, "splunk_v2")

    @_builtins.property
    @pulumi.getter(name="stackdriverV2")
    def stackdriver_v2(self) -> pulumi.Output[Optional['outputs.IntegrationMetricPrometheusStackdriverV2']]:
        return pulumi.get(self, "stackdriver_v2")

