# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['Oauth2ConfigurationArgs', 'Oauth2Configuration']

@pulumi.input_type
class Oauth2ConfigurationArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 issuer: pulumi.Input[_builtins.str],
                 resource_server_id: pulumi.Input[_builtins.str],
                 additional_scopes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_username_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scope_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 scope_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 verify_aud: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Oauth2Configuration resource.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] issuer: The issuer URL of the OAuth2 provider. This is typically
               the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        :param pulumi.Input[_builtins.str] resource_server_id: Resource server identifier used to identify the resource
               server in OAuth2 tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_scopes_keys: List of additional JWT claim keys to extract OAuth2
               scopes from.
        :param pulumi.Input[_builtins.str] audience: The audience to be passed along to the Oauth2 provider when
               logging in to the management interface. Must be configured for Auth0,
               cannot be configured for Entra ID v2.
        :param pulumi.Input[_builtins.str] oauth_client_id: OAuth2 client ID used for token validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oauth_scopes: List of OAuth2 scopes to request. These scopes will be
               used when obtaining access tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_username_claims: List of JWT claims to use as the preferred username.
               The first claim found in the token will be used as the username.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] scope_aliases: Map of scope aliases to translate scope names. This allows
               mapping OAuth2 scopes to RabbitMQ permission tags.
        :param pulumi.Input[_builtins.str] scope_prefix: Prefix to add to scopes. This is useful when scopes in
               the JWT token need to be prefixed for RabbitMQ permissions.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               OAuth2 configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for OAuth2
               configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.bool] verify_aud: Whether to verify the audience claim in the JWT
               token. Defaults to true.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "resource_server_id", resource_server_id)
        if additional_scopes_keys is not None:
            pulumi.set(__self__, "additional_scopes_keys", additional_scopes_keys)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preferred_username_claims is not None:
            pulumi.set(__self__, "preferred_username_claims", preferred_username_claims)
        if scope_aliases is not None:
            pulumi.set(__self__, "scope_aliases", scope_aliases)
        if scope_prefix is not None:
            pulumi.set(__self__, "scope_prefix", scope_prefix)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if verify_aud is not None:
            pulumi.set(__self__, "verify_aud", verify_aud)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[_builtins.str]:
        """
        The issuer URL of the OAuth2 provider. This is typically
        the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter(name="resourceServerId")
    def resource_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource server identifier used to identify the resource
        server in OAuth2 tokens.
        """
        return pulumi.get(self, "resource_server_id")

    @resource_server_id.setter
    def resource_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_server_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalScopesKeys")
    def additional_scopes_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional JWT claim keys to extract OAuth2
        scopes from.
        """
        return pulumi.get(self, "additional_scopes_keys")

    @additional_scopes_keys.setter
    def additional_scopes_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_scopes_keys", value)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience to be passed along to the Oauth2 provider when
        logging in to the management interface. Must be configured for Auth0,
        cannot be configured for Entra ID v2.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client ID used for token validation.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_id", value)

    @_builtins.property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of OAuth2 scopes to request. These scopes will be
        used when obtaining access tokens.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @_builtins.property
    @pulumi.getter(name="preferredUsernameClaims")
    def preferred_username_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of JWT claims to use as the preferred username.
        The first claim found in the token will be used as the username.
        """
        return pulumi.get(self, "preferred_username_claims")

    @preferred_username_claims.setter
    def preferred_username_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_username_claims", value)

    @_builtins.property
    @pulumi.getter(name="scopeAliases")
    def scope_aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of scope aliases to translate scope names. This allows
        mapping OAuth2 scopes to RabbitMQ permission tags.
        """
        return pulumi.get(self, "scope_aliases")

    @scope_aliases.setter
    def scope_aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_aliases", value)

    @_builtins.property
    @pulumi.getter(name="scopePrefix")
    def scope_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix to add to scopes. This is useful when scopes in
        the JWT token need to be prefixed for RabbitMQ permissions.
        """
        return pulumi.get(self, "scope_prefix")

    @scope_prefix.setter
    def scope_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_prefix", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for
        OAuth2 configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for OAuth2
        configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="verifyAud")
    def verify_aud(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to verify the audience claim in the JWT
        token. Defaults to true.
        """
        return pulumi.get(self, "verify_aud")

    @verify_aud.setter
    def verify_aud(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_aud", value)


@pulumi.input_type
class _Oauth2ConfigurationState:
    def __init__(__self__, *,
                 additional_scopes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_username_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 scope_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 verify_aud: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Oauth2Configuration resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_scopes_keys: List of additional JWT claim keys to extract OAuth2
               scopes from.
        :param pulumi.Input[_builtins.str] audience: The audience to be passed along to the Oauth2 provider when
               logging in to the management interface. Must be configured for Auth0,
               cannot be configured for Entra ID v2.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] issuer: The issuer URL of the OAuth2 provider. This is typically
               the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        :param pulumi.Input[_builtins.str] oauth_client_id: OAuth2 client ID used for token validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oauth_scopes: List of OAuth2 scopes to request. These scopes will be
               used when obtaining access tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_username_claims: List of JWT claims to use as the preferred username.
               The first claim found in the token will be used as the username.
        :param pulumi.Input[_builtins.str] resource_server_id: Resource server identifier used to identify the resource
               server in OAuth2 tokens.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] scope_aliases: Map of scope aliases to translate scope names. This allows
               mapping OAuth2 scopes to RabbitMQ permission tags.
        :param pulumi.Input[_builtins.str] scope_prefix: Prefix to add to scopes. This is useful when scopes in
               the JWT token need to be prefixed for RabbitMQ permissions.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               OAuth2 configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for OAuth2
               configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.bool] verify_aud: Whether to verify the audience claim in the JWT
               token. Defaults to true.
        """
        if additional_scopes_keys is not None:
            pulumi.set(__self__, "additional_scopes_keys", additional_scopes_keys)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preferred_username_claims is not None:
            pulumi.set(__self__, "preferred_username_claims", preferred_username_claims)
        if resource_server_id is not None:
            pulumi.set(__self__, "resource_server_id", resource_server_id)
        if scope_aliases is not None:
            pulumi.set(__self__, "scope_aliases", scope_aliases)
        if scope_prefix is not None:
            pulumi.set(__self__, "scope_prefix", scope_prefix)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if verify_aud is not None:
            pulumi.set(__self__, "verify_aud", verify_aud)

    @_builtins.property
    @pulumi.getter(name="additionalScopesKeys")
    def additional_scopes_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional JWT claim keys to extract OAuth2
        scopes from.
        """
        return pulumi.get(self, "additional_scopes_keys")

    @additional_scopes_keys.setter
    def additional_scopes_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_scopes_keys", value)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience to be passed along to the Oauth2 provider when
        logging in to the management interface. Must be configured for Auth0,
        cannot be configured for Entra ID v2.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuer URL of the OAuth2 provider. This is typically
        the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client ID used for token validation.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_id", value)

    @_builtins.property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of OAuth2 scopes to request. These scopes will be
        used when obtaining access tokens.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @_builtins.property
    @pulumi.getter(name="preferredUsernameClaims")
    def preferred_username_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of JWT claims to use as the preferred username.
        The first claim found in the token will be used as the username.
        """
        return pulumi.get(self, "preferred_username_claims")

    @preferred_username_claims.setter
    def preferred_username_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_username_claims", value)

    @_builtins.property
    @pulumi.getter(name="resourceServerId")
    def resource_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource server identifier used to identify the resource
        server in OAuth2 tokens.
        """
        return pulumi.get(self, "resource_server_id")

    @resource_server_id.setter
    def resource_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_server_id", value)

    @_builtins.property
    @pulumi.getter(name="scopeAliases")
    def scope_aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of scope aliases to translate scope names. This allows
        mapping OAuth2 scopes to RabbitMQ permission tags.
        """
        return pulumi.get(self, "scope_aliases")

    @scope_aliases.setter
    def scope_aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_aliases", value)

    @_builtins.property
    @pulumi.getter(name="scopePrefix")
    def scope_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix to add to scopes. This is useful when scopes in
        the JWT token need to be prefixed for RabbitMQ permissions.
        """
        return pulumi.get(self, "scope_prefix")

    @scope_prefix.setter
    def scope_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_prefix", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for
        OAuth2 configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for OAuth2
        configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="verifyAud")
    def verify_aud(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to verify the audience claim in the JWT
        token. Defaults to true.
        """
        return pulumi.get(self, "verify_aud")

    @verify_aud.setter
    def verify_aud(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_aud", value)


@pulumi.type_token("cloudamqp:index/oauth2Configuration:Oauth2Configuration")
class Oauth2Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_scopes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_username_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 scope_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 verify_aud: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource allows you to configure OAuth2 authentication for your RabbitMQ instance.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Basic OAuth2 configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com",
            verify_aud=True,
            oauth_client_id="test-client-id",
            oauth_scopes=[
                "read",
                "write",
            ])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>OAuth2 configuration with all optional fields</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com",
            preferred_username_claims=[
                "preferred_username",
                "username",
            ],
            additional_scopes_keys=["admin"],
            scope_prefix="cloudamqp",
            scope_aliases={
                "read": "read:all",
                "write": "write:all",
            },
            verify_aud=True,
            oauth_client_id="test-client-id",
            oauth_scopes=[
                "read",
                "write",
                "admin",
            ],
            audience="https://test-audience.example.com")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Minimal OAuth2 configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com")
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Notes

        * Changes to `instance_id` will force recreation of the resource.
        * OAuth2 configuration changes are applied asynchronously and may take some time to complete. The
          resource will poll for job completion using the configured `sleep` and `timeout` values.
        * Only one OAuth2 configuration can exist per instance. Creating a new configuration will replace
          any existing configuration.
        * After a configuration has been applied, a restart of RabbitMQ is required for the changes to take effect.

        ## Import

        `cloudamqp_oauth2_configuration` can be imported using the CloudAMQP instance identifier.

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_oauth2_configuration.oauth2_config

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/oauth2Configuration:Oauth2Configuration oauth2_config <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_scopes_keys: List of additional JWT claim keys to extract OAuth2
               scopes from.
        :param pulumi.Input[_builtins.str] audience: The audience to be passed along to the Oauth2 provider when
               logging in to the management interface. Must be configured for Auth0,
               cannot be configured for Entra ID v2.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] issuer: The issuer URL of the OAuth2 provider. This is typically
               the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        :param pulumi.Input[_builtins.str] oauth_client_id: OAuth2 client ID used for token validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oauth_scopes: List of OAuth2 scopes to request. These scopes will be
               used when obtaining access tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_username_claims: List of JWT claims to use as the preferred username.
               The first claim found in the token will be used as the username.
        :param pulumi.Input[_builtins.str] resource_server_id: Resource server identifier used to identify the resource
               server in OAuth2 tokens.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] scope_aliases: Map of scope aliases to translate scope names. This allows
               mapping OAuth2 scopes to RabbitMQ permission tags.
        :param pulumi.Input[_builtins.str] scope_prefix: Prefix to add to scopes. This is useful when scopes in
               the JWT token need to be prefixed for RabbitMQ permissions.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               OAuth2 configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for OAuth2
               configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.bool] verify_aud: Whether to verify the audience claim in the JWT
               token. Defaults to true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Oauth2ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to configure OAuth2 authentication for your RabbitMQ instance.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Basic OAuth2 configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com",
            verify_aud=True,
            oauth_client_id="test-client-id",
            oauth_scopes=[
                "read",
                "write",
            ])
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>OAuth2 configuration with all optional fields</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com",
            preferred_username_claims=[
                "preferred_username",
                "username",
            ],
            additional_scopes_keys=["admin"],
            scope_prefix="cloudamqp",
            scope_aliases={
                "read": "read:all",
                "write": "write:all",
            },
            verify_aud=True,
            oauth_client_id="test-client-id",
            oauth_scopes=[
                "read",
                "write",
                "admin",
            ],
            audience="https://test-audience.example.com")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Minimal OAuth2 configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        oauth2_config = cloudamqp.Oauth2Configuration("oauth2_config",
            instance_id=instance["id"],
            resource_server_id="test-resource-server",
            issuer="https://test-issuer.example.com")
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Notes

        * Changes to `instance_id` will force recreation of the resource.
        * OAuth2 configuration changes are applied asynchronously and may take some time to complete. The
          resource will poll for job completion using the configured `sleep` and `timeout` values.
        * Only one OAuth2 configuration can exist per instance. Creating a new configuration will replace
          any existing configuration.
        * After a configuration has been applied, a restart of RabbitMQ is required for the changes to take effect.

        ## Import

        `cloudamqp_oauth2_configuration` can be imported using the CloudAMQP instance identifier.

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_oauth2_configuration.oauth2_config

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/oauth2Configuration:Oauth2Configuration oauth2_config <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param Oauth2ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Oauth2ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_scopes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_username_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 scope_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 verify_aud: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Oauth2ConfigurationArgs.__new__(Oauth2ConfigurationArgs)

            __props__.__dict__["additional_scopes_keys"] = additional_scopes_keys
            __props__.__dict__["audience"] = audience
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["oauth_client_id"] = oauth_client_id
            __props__.__dict__["oauth_scopes"] = oauth_scopes
            __props__.__dict__["preferred_username_claims"] = preferred_username_claims
            if resource_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_server_id'")
            __props__.__dict__["resource_server_id"] = resource_server_id
            __props__.__dict__["scope_aliases"] = scope_aliases
            __props__.__dict__["scope_prefix"] = scope_prefix
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["verify_aud"] = verify_aud
        super(Oauth2Configuration, __self__).__init__(
            'cloudamqp:index/oauth2Configuration:Oauth2Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_scopes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audience: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preferred_username_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            scope_aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            scope_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            verify_aud: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Oauth2Configuration':
        """
        Get an existing Oauth2Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_scopes_keys: List of additional JWT claim keys to extract OAuth2
               scopes from.
        :param pulumi.Input[_builtins.str] audience: The audience to be passed along to the Oauth2 provider when
               logging in to the management interface. Must be configured for Auth0,
               cannot be configured for Entra ID v2.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] issuer: The issuer URL of the OAuth2 provider. This is typically
               the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        :param pulumi.Input[_builtins.str] oauth_client_id: OAuth2 client ID used for token validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oauth_scopes: List of OAuth2 scopes to request. These scopes will be
               used when obtaining access tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_username_claims: List of JWT claims to use as the preferred username.
               The first claim found in the token will be used as the username.
        :param pulumi.Input[_builtins.str] resource_server_id: Resource server identifier used to identify the resource
               server in OAuth2 tokens.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] scope_aliases: Map of scope aliases to translate scope names. This allows
               mapping OAuth2 scopes to RabbitMQ permission tags.
        :param pulumi.Input[_builtins.str] scope_prefix: Prefix to add to scopes. This is useful when scopes in
               the JWT token need to be prefixed for RabbitMQ permissions.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               OAuth2 configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for OAuth2
               configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.bool] verify_aud: Whether to verify the audience claim in the JWT
               token. Defaults to true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Oauth2ConfigurationState.__new__(_Oauth2ConfigurationState)

        __props__.__dict__["additional_scopes_keys"] = additional_scopes_keys
        __props__.__dict__["audience"] = audience
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["oauth_client_id"] = oauth_client_id
        __props__.__dict__["oauth_scopes"] = oauth_scopes
        __props__.__dict__["preferred_username_claims"] = preferred_username_claims
        __props__.__dict__["resource_server_id"] = resource_server_id
        __props__.__dict__["scope_aliases"] = scope_aliases
        __props__.__dict__["scope_prefix"] = scope_prefix
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["verify_aud"] = verify_aud
        return Oauth2Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalScopesKeys")
    def additional_scopes_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of additional JWT claim keys to extract OAuth2
        scopes from.
        """
        return pulumi.get(self, "additional_scopes_keys")

    @_builtins.property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audience to be passed along to the Oauth2 provider when
        logging in to the management interface. Must be configured for Auth0,
        cannot be configured for Entra ID v2.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        The issuer URL of the OAuth2 provider. This is typically
        the base URL of your OAuth2 provider (e.g., Auth0, Keycloak, etc.).
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OAuth2 client ID used for token validation.
        """
        return pulumi.get(self, "oauth_client_id")

    @_builtins.property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of OAuth2 scopes to request. These scopes will be
        used when obtaining access tokens.
        """
        return pulumi.get(self, "oauth_scopes")

    @_builtins.property
    @pulumi.getter(name="preferredUsernameClaims")
    def preferred_username_claims(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of JWT claims to use as the preferred username.
        The first claim found in the token will be used as the username.
        """
        return pulumi.get(self, "preferred_username_claims")

    @_builtins.property
    @pulumi.getter(name="resourceServerId")
    def resource_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource server identifier used to identify the resource
        server in OAuth2 tokens.
        """
        return pulumi.get(self, "resource_server_id")

    @_builtins.property
    @pulumi.getter(name="scopeAliases")
    def scope_aliases(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of scope aliases to translate scope names. This allows
        mapping OAuth2 scopes to RabbitMQ permission tags.
        """
        return pulumi.get(self, "scope_aliases")

    @_builtins.property
    @pulumi.getter(name="scopePrefix")
    def scope_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Prefix to add to scopes. This is useful when scopes in
        the JWT token need to be prefixed for RabbitMQ permissions.
        """
        return pulumi.get(self, "scope_prefix")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable sleep time in seconds between retries for
        OAuth2 configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable timeout time in seconds for OAuth2
        configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="verifyAud")
    def verify_aud(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to verify the audience claim in the JWT
        token. Defaults to true.
        """
        return pulumi.get(self, "verify_aud")

