# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'ExtraDiskSizeNode',
    'InstanceCopySetting',
    'IntegrationMetricPrometheusAzureMonitor',
    'IntegrationMetricPrometheusCloudwatchV3',
    'IntegrationMetricPrometheusDatadogV3',
    'IntegrationMetricPrometheusDynatrace',
    'IntegrationMetricPrometheusNewrelicV3',
    'IntegrationMetricPrometheusSplunkV2',
    'IntegrationMetricPrometheusStackdriverV2',
    'NotificationResponder',
    'SecurityFirewallRule',
    'TrustStoreHttp',
    'GetAccountInstanceResult',
    'GetAccountVpcsVpcResult',
    'GetAlarmsAlarmResult',
    'GetNodesNodeResult',
    'GetNotificationsRecipientResult',
    'GetPluginsCommunityPluginResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class ExtraDiskSizeNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDiskSize":
            suggest = "additional_disk_size"
        elif key == "diskSize":
            suggest = "disk_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtraDiskSizeNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtraDiskSizeNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_disk_size: Optional[_builtins.int] = None,
                 disk_size: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.int additional_disk_size: Additional added disk size
        :param _builtins.int disk_size: Subscription plan disk size
        :param _builtins.str name: Name of the node.
        """
        if additional_disk_size is not None:
            pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> Optional[_builtins.int]:
        """
        Additional added disk size
        """
        return pulumi.get(self, "additional_disk_size")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[_builtins.int]:
        """
        Subscription plan disk size
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceCopySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCopySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCopySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 settings: Sequence[_builtins.str],
                 subscription_id: _builtins.str):
        """
        :param Sequence[_builtins.str] settings: Array of one or more settings to be copied. Allowed values:
               [alarms, config, definitions, firewall, logs, metrics, plugins]
               
               See more below, [copy settings].
        :param _builtins.str subscription_id: Instance identifier of the CloudAMQP instance to copy the settings
               from.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Sequence[_builtins.str]:
        """
        Array of one or more settings to be copied. Allowed values:
        [alarms, config, definitions, firewall, logs, metrics, plugins]

        See more below, [copy settings].
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        Instance identifier of the CloudAMQP instance to copy the settings
        from.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class IntegrationMetricPrometheusAzureMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusAzureMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusAzureMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusAzureMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: _builtins.str):
        """
        :param _builtins.str connection_string: Azure Application Insights Connection String for authentication.
        """
        pulumi.set(__self__, "connection_string", connection_string)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        Azure Application Insights Connection String for authentication.
        """
        return pulumi.get(self, "connection_string")


@pulumi.output_type
class IntegrationMetricPrometheusCloudwatchV3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamExternalId":
            suggest = "iam_external_id"
        elif key == "iamRole":
            suggest = "iam_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusCloudwatchV3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusCloudwatchV3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusCloudwatchV3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_external_id: _builtins.str,
                 iam_role: _builtins.str,
                 region: _builtins.str,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str iam_external_id: AWS IAM external ID for role assumption.
        :param _builtins.str iam_role: AWS IAM role ARN with PutMetricData permission for CloudWatch integration.
        :param _builtins.str region: AWS region for CloudWatch metrics.
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        pulumi.set(__self__, "iam_external_id", iam_external_id)
        pulumi.set(__self__, "iam_role", iam_role)
        pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="iamExternalId")
    def iam_external_id(self) -> _builtins.str:
        """
        AWS IAM external ID for role assumption.
        """
        return pulumi.get(self, "iam_external_id")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> _builtins.str:
        """
        AWS IAM role ARN with PutMetricData permission for CloudWatch integration.
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        AWS region for CloudWatch metrics.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IntegrationMetricPrometheusDatadogV3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "rabbitmqDashboardMetricsFormat":
            suggest = "rabbitmq_dashboard_metrics_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusDatadogV3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusDatadogV3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusDatadogV3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: _builtins.str,
                 region: _builtins.str,
                 rabbitmq_dashboard_metrics_format: Optional[_builtins.bool] = None,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_key: Datadog API key for authentication.
        :param _builtins.str region: Datadog region code. Valid values: `us1`, `us3`, `us5`, `eu1`.
        :param _builtins.bool rabbitmq_dashboard_metrics_format: Enable metric name transformation to match Datadog's RabbitMQ dashboard format. Default: `false`. **Note:** This option is only available for RabbitMQ clusters, not LavinMQ clusters.
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "region", region)
        if rabbitmq_dashboard_metrics_format is not None:
            pulumi.set(__self__, "rabbitmq_dashboard_metrics_format", rabbitmq_dashboard_metrics_format)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        Datadog API key for authentication.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Datadog region code. Valid values: `us1`, `us3`, `us5`, `eu1`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rabbitmqDashboardMetricsFormat")
    def rabbitmq_dashboard_metrics_format(self) -> Optional[_builtins.bool]:
        """
        Enable metric name transformation to match Datadog's RabbitMQ dashboard format. Default: `false`. **Note:** This option is only available for RabbitMQ clusters, not LavinMQ clusters.
        """
        return pulumi.get(self, "rabbitmq_dashboard_metrics_format")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IntegrationMetricPrometheusDynatrace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusDynatrace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusDynatrace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusDynatrace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: _builtins.str,
                 environment_id: _builtins.str,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_token: Dynatrace access token with 'Ingest metrics' permission.
        :param _builtins.str environment_id: Dynatrace environment ID.
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "environment_id", environment_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> _builtins.str:
        """
        Dynatrace access token with 'Ingest metrics' permission.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        Dynatrace environment ID.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IntegrationMetricPrometheusNewrelicV3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusNewrelicV3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusNewrelicV3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusNewrelicV3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: _builtins.str,
                 region: _builtins.str,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_key: New Relic API key for authentication.
        :param _builtins.str region: New Relic region code. Valid values: `eu`, `us`.
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        New Relic API key for authentication.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        New Relic region code. Valid values: `eu`, `us`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IntegrationMetricPrometheusSplunkV2(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 token: _builtins.str,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: Splunk HEC endpoint URL. Example: `https://your-instance-id.splunkcloud.com:8088/services/collector`.
        :param _builtins.str token: Splunk HEC (HTTP Event Collector) token for authentication.
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "token", token)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        Splunk HEC endpoint URL. Example: `https://your-instance-id.splunkcloud.com:8088/services/collector`.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        Splunk HEC (HTTP Event Collector) token for authentication.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IntegrationMetricPrometheusStackdriverV2(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsFile":
            suggest = "credentials_file"
        elif key == "clientEmail":
            suggest = "client_email"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyId":
            suggest = "private_key_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationMetricPrometheusStackdriverV2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationMetricPrometheusStackdriverV2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationMetricPrometheusStackdriverV2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_file: _builtins.str,
                 client_email: Optional[_builtins.str] = None,
                 private_key: Optional[_builtins.str] = None,
                 private_key_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str credentials_file: Base64-encoded Google service account key JSON file with 'Monitoring Metric Writer' permission.
        :param _builtins.str client_email: Google service account client email (extracted from credentials file).
        :param _builtins.str private_key: Google service account private key (extracted from credentials file).
        :param _builtins.str private_key_id: Google service account private key ID (extracted from credentials file).
        :param _builtins.str project_id: Google Cloud project ID (extracted from credentials file).
        :param _builtins.str tags: Additional tags to attach to metrics. Format: `key=value,key2=value2`.
               
               The following computed attributes are available:
        """
        pulumi.set(__self__, "credentials_file", credentials_file)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="credentialsFile")
    def credentials_file(self) -> _builtins.str:
        """
        Base64-encoded Google service account key JSON file with 'Monitoring Metric Writer' permission.
        """
        return pulumi.get(self, "credentials_file")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[_builtins.str]:
        """
        Google service account client email (extracted from credentials file).
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        Google service account private key (extracted from credentials file).
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[_builtins.str]:
        """
        Google service account private key ID (extracted from credentials file).
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Google Cloud project ID (extracted from credentials file).
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Additional tags to attach to metrics. Format: `key=value,key2=value2`.

        The following computed attributes are available:
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class NotificationResponder(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of responder. [`team`, `user`, `escalation`, `schedule`]
        :param _builtins.str id: Identifier in UUID format
        :param _builtins.str name: Name of the responder
        :param _builtins.str username: Username of the responder
               
               Responders of type `team`, `escalation` and `schedule` can use either id or name.
               While `user` can use either id or username.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of responder. [`team`, `user`, `escalation`, `schedule`]
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Identifier in UUID format
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the responder
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username of the responder

        Responders of type `team`, `escalation` and `schedule` can use either id or name.
        While `user` can use either id or username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityFirewallRule(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 ports: Optional[Sequence[_builtins.int]] = None,
                 services: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str ip: CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        :param _builtins.str description: Description name of the rule. e.g. Default.
               
               Pre-defined services for RabbitMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
               | MQTT         | 1883  |
               | MQTTS        | 8883  |
               | STOMP        | 61613 |
               | STOMPS       | 61614 |
               | STREAM       | 5552  |
               | STREAM_SSL   | 5551  |
               
               Pre-defined services for LavinMQ:
               
               | Service name | Port  |
               |--------------|-------|
               | AMQP         | 5672  |
               | AMQPS        | 5671  |
               | HTTPS        | 443   |
               | MQTT         | 1883  |
               | MQTTS        | 8883  |
        :param Sequence[_builtins.int] ports: Custom ports to be opened
        :param Sequence[_builtins.str] services: Pre-defined service ports, see table below
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        CIDR address: IP address with CIDR notation (e.g. 10.56.72.0/24)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description name of the rule. e.g. Default.

        Pre-defined services for RabbitMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        | MQTT         | 1883  |
        | MQTTS        | 8883  |
        | STOMP        | 61613 |
        | STOMPS       | 61614 |
        | STREAM       | 5552  |
        | STREAM_SSL   | 5551  |

        Pre-defined services for LavinMQ:

        | Service name | Port  |
        |--------------|-------|
        | AMQP         | 5672  |
        | AMQPS        | 5671  |
        | HTTPS        | 443   |
        | MQTT         | 1883  |
        | MQTTS        | 8883  |
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        Custom ports to be opened
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[Sequence[_builtins.str]]:
        """
        Pre-defined service ports, see table below
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class TrustStoreHttp(dict):
    def __init__(__self__, *,
                 url: _builtins.str,
                 cacert: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: URL to fetch trust store certificates from. RabbitMQ will periodically
               fetch CA certificates from this URL.
        :param _builtins.str cacert: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               PEM encoded CA certificates used to verify the HTTPS connection to the
               trust store URL. This is a write-only field - changes are only applied when `version`
               is incremented.
        """
        pulumi.set(__self__, "url", url)
        if cacert is not None:
            pulumi.set(__self__, "cacert", cacert)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to fetch trust store certificates from. RabbitMQ will periodically
        fetch CA certificates from this URL.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def cacert(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        PEM encoded CA certificates used to verify the HTTPS connection to the
        trust store URL. This is a write-only field - changes are only applied when `version`
        is incremented.
        """
        return pulumi.get(self, "cacert")


@pulumi.output_type
class GetAccountInstanceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 name: _builtins.str,
                 plan: _builtins.str,
                 region: _builtins.str,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int id: The instance identifier.
        :param _builtins.str name: The name of the instance.
        :param _builtins.str plan: The subscription plan used for the instance.
        :param _builtins.str region: The region were the instanece is located in.
        :param Sequence[_builtins.str] tags: Optional tags set for the instance.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The instance identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The subscription plan used for the instance.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region were the instanece is located in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional tags set for the instance.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAccountVpcsVpcResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 name: _builtins.str,
                 region: _builtins.str,
                 subnet: _builtins.str,
                 vpc_name: _builtins.str,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int id: The VPC identifier.
        :param _builtins.str name: The VPC instance name.
        :param _builtins.str region: The region the VPC is hosted in.
        :param _builtins.str subnet: The VPC subnet.
        :param _builtins.str vpc_name: VPC name given when hosted at the cloud provider.
        :param Sequence[_builtins.str] tags: Optional tags set for the VPC.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_name", vpc_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The VPC identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The VPC instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region the VPC is hosted in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The VPC subnet.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        VPC name given when hosted at the cloud provider.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional tags set for the VPC.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 message_type: _builtins.str,
                 queue_regex: _builtins.str,
                 recipients: Sequence[_builtins.int],
                 reminder_interval: _builtins.int,
                 time_threshold: _builtins.int,
                 value_threshold: _builtins.int,
                 vhost_regex: _builtins.str,
                 alarm_id: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value_calculation: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable/disable status of the alarm.
        :param _builtins.str message_type: Message type `(total, unacked, ready)` used by queue alarm type.
        :param _builtins.str queue_regex: Regular expression for which queue to check.
        :param Sequence[_builtins.int] recipients: Identifier for recipient to be notified.
        :param _builtins.int reminder_interval: The reminder interval (in seconds) to resend the alarm if not resolved.
               Set to 0 for no reminders.
        :param _builtins.int time_threshold: The time interval (in seconds) the `value_threshold` should be active
               before trigger an alarm.
        :param _builtins.int value_threshold: The value threshold that triggers the alarm.
        :param _builtins.str vhost_regex: Regular expression for which vhost to check
        :param _builtins.int alarm_id: The alarm identifier.
        :param _builtins.str type: The alarm type to filter for. Supported
               alarm types.
        :param _builtins.str value_calculation: Disk value threshold calculation, `(fixed, percentage)` of disk space
               remaining.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "message_type", message_type)
        pulumi.set(__self__, "queue_regex", queue_regex)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "reminder_interval", reminder_interval)
        pulumi.set(__self__, "time_threshold", time_threshold)
        pulumi.set(__self__, "value_threshold", value_threshold)
        pulumi.set(__self__, "vhost_regex", vhost_regex)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value_calculation is not None:
            pulumi.set(__self__, "value_calculation", value_calculation)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable/disable status of the alarm.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> _builtins.str:
        """
        Message type `(total, unacked, ready)` used by queue alarm type.
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter(name="queueRegex")
    def queue_regex(self) -> _builtins.str:
        """
        Regular expression for which queue to check.
        """
        return pulumi.get(self, "queue_regex")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Sequence[_builtins.int]:
        """
        Identifier for recipient to be notified.
        """
        return pulumi.get(self, "recipients")

    @_builtins.property
    @pulumi.getter(name="reminderInterval")
    def reminder_interval(self) -> _builtins.int:
        """
        The reminder interval (in seconds) to resend the alarm if not resolved.
        Set to 0 for no reminders.
        """
        return pulumi.get(self, "reminder_interval")

    @_builtins.property
    @pulumi.getter(name="timeThreshold")
    def time_threshold(self) -> _builtins.int:
        """
        The time interval (in seconds) the `value_threshold` should be active
        before trigger an alarm.
        """
        return pulumi.get(self, "time_threshold")

    @_builtins.property
    @pulumi.getter(name="valueThreshold")
    def value_threshold(self) -> _builtins.int:
        """
        The value threshold that triggers the alarm.
        """
        return pulumi.get(self, "value_threshold")

    @_builtins.property
    @pulumi.getter(name="vhostRegex")
    def vhost_regex(self) -> _builtins.str:
        """
        Regular expression for which vhost to check
        """
        return pulumi.get(self, "vhost_regex")

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[_builtins.int]:
        """
        The alarm identifier.
        """
        return pulumi.get(self, "alarm_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The alarm type to filter for. Supported
        alarm types.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="valueCalculation")
    def value_calculation(self) -> Optional[_builtins.str]:
        """
        Disk value threshold calculation, `(fixed, percentage)` of disk space
        remaining.
        """
        return pulumi.get(self, "value_calculation")


@pulumi.output_type
class GetNodesNodeResult(dict):
    def __init__(__self__, *,
                 additional_disk_size: _builtins.int,
                 availability_zone: _builtins.str,
                 configured: _builtins.bool,
                 disk_size: _builtins.int,
                 erlang_version: _builtins.str,
                 hipe: _builtins.bool,
                 hostname: _builtins.str,
                 hostname_internal: _builtins.str,
                 name: _builtins.str,
                 rabbitmq_version: _builtins.str,
                 running: _builtins.bool):
        """
        :param _builtins.int additional_disk_size: Additional added disk size
        :param _builtins.str availability_zone: Availability zone the node is hosted in.
        :param _builtins.bool configured: Is the node configured?
        :param _builtins.int disk_size: Subscription plan disk size
        :param _builtins.str erlang_version: Currently used Erlang version on the node.
        :param _builtins.bool hipe: Enable or disable High-performance Erlang.
        :param _builtins.str hostname: External hostname assigned to the node.
        :param _builtins.str hostname_internal: Internal hostname assigned to the node.
        :param _builtins.str name: Name of the node.
        :param _builtins.str rabbitmq_version: Currently configured Rabbit MQ version on the node.
        :param _builtins.bool running: Is the node running?
        """
        pulumi.set(__self__, "additional_disk_size", additional_disk_size)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "configured", configured)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "erlang_version", erlang_version)
        pulumi.set(__self__, "hipe", hipe)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "hostname_internal", hostname_internal)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rabbitmq_version", rabbitmq_version)
        pulumi.set(__self__, "running", running)

    @_builtins.property
    @pulumi.getter(name="additionalDiskSize")
    def additional_disk_size(self) -> _builtins.int:
        """
        Additional added disk size
        """
        return pulumi.get(self, "additional_disk_size")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Availability zone the node is hosted in.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def configured(self) -> _builtins.bool:
        """
        Is the node configured?
        """
        return pulumi.get(self, "configured")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        Subscription plan disk size
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="erlangVersion")
    def erlang_version(self) -> _builtins.str:
        """
        Currently used Erlang version on the node.
        """
        return pulumi.get(self, "erlang_version")

    @_builtins.property
    @pulumi.getter
    def hipe(self) -> _builtins.bool:
        """
        Enable or disable High-performance Erlang.
        """
        return pulumi.get(self, "hipe")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        External hostname assigned to the node.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameInternal")
    def hostname_internal(self) -> _builtins.str:
        """
        Internal hostname assigned to the node.
        """
        return pulumi.get(self, "hostname_internal")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rabbitmqVersion")
    def rabbitmq_version(self) -> _builtins.str:
        """
        Currently configured Rabbit MQ version on the node.
        """
        return pulumi.get(self, "rabbitmq_version")

    @_builtins.property
    @pulumi.getter
    def running(self) -> _builtins.bool:
        """
        Is the node running?
        """
        return pulumi.get(self, "running")


@pulumi.output_type
class GetNotificationsRecipientResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 options: Mapping[str, _builtins.str],
                 recipient_id: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the recipient.
        :param Mapping[str, _builtins.str] options: Options argument (e.g. `rk` used for VictorOps routing key).
        :param _builtins.int recipient_id: The identifier for the recipient.
        :param _builtins.str type: The type of the recipient.
        :param _builtins.str value: The notification endpoint, where to send the notification.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "recipient_id", recipient_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Mapping[str, _builtins.str]:
        """
        Options argument (e.g. `rk` used for VictorOps routing key).
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="recipientId")
    def recipient_id(self) -> _builtins.int:
        """
        The identifier for the recipient.
        """
        return pulumi.get(self, "recipient_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The notification endpoint, where to send the notification.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPluginsCommunityPluginResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str,
                 require: _builtins.str):
        """
        :param _builtins.str description: Description of what the plugin does.
        :param _builtins.str name: The type of the recipient.
        :param _builtins.str require: Min. required Rabbit MQ version to be used.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "require", require)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of what the plugin does.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def require(self) -> _builtins.str:
        """
        Min. required Rabbit MQ version to be used.
        """
        return pulumi.get(self, "require")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str description: Description of what the plugin does.
        :param _builtins.bool enabled: Enable or disable information for the plugin.
        :param _builtins.str name: The type of the recipient.
        :param _builtins.str version: Rabbit MQ version that the plugins are shipped with.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of what the plugin does.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable or disable information for the plugin.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The type of the recipient.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Rabbit MQ version that the plugins are shipped with.
        """
        return pulumi.get(self, "version")


