# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PluginCommunityArgs', 'PluginCommunity']

@pulumi.input_type
class PluginCommunityArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 instance_id: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PluginCommunity resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the plugins.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] name: The name of the Rabbit MQ community plugin.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) for retries when requesting
               information about community plugins. Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) for retries when requesting
               information about community plugins. Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Enable or disable the plugins.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Rabbit MQ community plugin.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time (seconds) for retries when requesting
        information about community plugins. Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time (seconds) for retries when requesting
        information about community plugins. Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _PluginCommunityState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 require: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PluginCommunity resources.
        :param pulumi.Input[_builtins.str] description: The description of the plugin.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the plugins.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] name: The name of the Rabbit MQ community plugin.
        :param pulumi.Input[_builtins.str] require: Required version of RabbitMQ.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) for retries when requesting
               information about community plugins. Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) for retries when requesting
               information about community plugins. Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require is not None:
            pulumi.set(__self__, "require", require)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the plugin.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the plugins.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Rabbit MQ community plugin.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def require(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required version of RabbitMQ.
        """
        return pulumi.get(self, "require")

    @require.setter
    def require(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "require", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time (seconds) for retries when requesting
        information about community plugins. Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time (seconds) for retries when requesting
        information about community plugins. Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("cloudamqp:index/pluginCommunity:PluginCommunity")
class PluginCommunity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        `cloudamqp_plugin_community` can be imported if it's has already been installed by using the name

        argument of the resource together with CloudAMQP instance identifier (CSV separated). To retrieve

        list of available community plugins, use [CloudAMQP API list community plugins].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_plugin_community.rabbitmq_delayed_message_exchange

          id = format("rabbitmq_delayed_message_exchange,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/pluginCommunity:PluginCommunity rabbitmq_delayed_message_exchange <plugin_name>,<instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the plugins.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] name: The name of the Rabbit MQ community plugin.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) for retries when requesting
               information about community plugins. Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) for retries when requesting
               information about community plugins. Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginCommunityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `cloudamqp_plugin_community` can be imported if it's has already been installed by using the name

        argument of the resource together with CloudAMQP instance identifier (CSV separated). To retrieve

        list of available community plugins, use [CloudAMQP API list community plugins].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_plugin_community.rabbitmq_delayed_message_exchange

          id = format("rabbitmq_delayed_message_exchange,%s", cloudamqp_instance.instance.id)

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/pluginCommunity:PluginCommunity rabbitmq_delayed_message_exchange <plugin_name>,<instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param PluginCommunityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginCommunityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginCommunityArgs.__new__(PluginCommunityArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["description"] = None
            __props__.__dict__["require"] = None
        super(PluginCommunity, __self__).__init__(
            'cloudamqp:index/pluginCommunity:PluginCommunity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            require: Optional[pulumi.Input[_builtins.str]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'PluginCommunity':
        """
        Get an existing PluginCommunity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the plugin.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable the plugins.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] name: The name of the Rabbit MQ community plugin.
        :param pulumi.Input[_builtins.str] require: Required version of RabbitMQ.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) for retries when requesting
               information about community plugins. Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) for retries when requesting
               information about community plugins. Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginCommunityState.__new__(_PluginCommunityState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["require"] = require
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["timeout"] = timeout
        return PluginCommunity(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the plugin.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable or disable the plugins.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Rabbit MQ community plugin.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def require(self) -> pulumi.Output[_builtins.str]:
        """
        Required version of RabbitMQ.
        """
        return pulumi.get(self, "require")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable sleep time (seconds) for retries when requesting
        information about community plugins. Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable timeout time (seconds) for retries when requesting
        information about community plugins. Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "timeout")

