# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PrivatelinkAwsArgs', 'PrivatelinkAws']

@pulumi.input_type
class PrivatelinkAwsArgs:
    def __init__(__self__, *,
                 allowed_principals: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 instance_id: pulumi.Input[_builtins.int],
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PrivatelinkAws resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principals: Allowed principals to access the endpoint service.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) when enable PrivateLink.
               Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) when enable PrivateLink.
               Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
               
               Allowed principals format: <br>
               `arn:aws:iam::aws-account-id:root` <br>
               `arn:aws:iam::aws-account-id:user/user-name` <br>
               `arn:aws:iam::aws-account-id:role/role-name`
        """
        pulumi.set(__self__, "allowed_principals", allowed_principals)
        pulumi.set(__self__, "instance_id", instance_id)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Allowed principals to access the endpoint service.
        """
        return pulumi.get(self, "allowed_principals")

    @allowed_principals.setter
    def allowed_principals(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_principals", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time (seconds) when enable PrivateLink.
        Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time (seconds) when enable PrivateLink.
        Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]

        Allowed principals format: <br>
        `arn:aws:iam::aws-account-id:root` <br>
        `arn:aws:iam::aws-account-id:user/user-name` <br>
        `arn:aws:iam::aws-account-id:role/role-name`
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _PrivatelinkAwsState:
    def __init__(__self__, *,
                 active_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PrivatelinkAws resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] active_zones: Covering availability zones used when creating an Endpoint from other VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principals: Allowed principals to access the endpoint service.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] service_name: Service name of the PrivateLink used when creating the endpoint from other VPC.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) when enable PrivateLink.
               Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.str] status: PrivateLink status [enable, pending, disable]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) when enable PrivateLink.
               Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
               
               Allowed principals format: <br>
               `arn:aws:iam::aws-account-id:root` <br>
               `arn:aws:iam::aws-account-id:user/user-name` <br>
               `arn:aws:iam::aws-account-id:role/role-name`
        """
        if active_zones is not None:
            pulumi.set(__self__, "active_zones", active_zones)
        if allowed_principals is not None:
            pulumi.set(__self__, "allowed_principals", allowed_principals)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="activeZones")
    def active_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Covering availability zones used when creating an Endpoint from other VPC.
        """
        return pulumi.get(self, "active_zones")

    @active_zones.setter
    def active_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "active_zones", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed principals to access the endpoint service.
        """
        return pulumi.get(self, "allowed_principals")

    @allowed_principals.setter
    def allowed_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_principals", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name of the PrivateLink used when creating the endpoint from other VPC.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time (seconds) when enable PrivateLink.
        Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PrivateLink status [enable, pending, disable]
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time (seconds) when enable PrivateLink.
        Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]

        Allowed principals format: <br>
        `arn:aws:iam::aws-account-id:root` <br>
        `arn:aws:iam::aws-account-id:user/user-name` <br>
        `arn:aws:iam::aws-account-id:role/role-name`
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("cloudamqp:index/privatelinkAws:PrivatelinkAws")
class PrivatelinkAws(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        `cloudamqp_privatelink_aws` can be imported using CloudAMQP instance identifier. To retrieve the

        identifier, use [CloudAMQP API list intances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_privatelink_aws.privatelink

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/privatelinkAws:PrivatelinkAws privatelink <id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principals: Allowed principals to access the endpoint service.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) when enable PrivateLink.
               Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) when enable PrivateLink.
               Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
               
               Allowed principals format: <br>
               `arn:aws:iam::aws-account-id:root` <br>
               `arn:aws:iam::aws-account-id:user/user-name` <br>
               `arn:aws:iam::aws-account-id:role/role-name`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivatelinkAwsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `cloudamqp_privatelink_aws` can be imported using CloudAMQP instance identifier. To retrieve the

        identifier, use [CloudAMQP API list intances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_privatelink_aws.privatelink

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/privatelinkAws:PrivatelinkAws privatelink <id>`
        ```

        :param str resource_name: The name of the resource.
        :param PrivatelinkAwsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivatelinkAwsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivatelinkAwsArgs.__new__(PrivatelinkAwsArgs)

            if allowed_principals is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_principals'")
            __props__.__dict__["allowed_principals"] = allowed_principals
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["active_zones"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["status"] = None
        super(PrivatelinkAws, __self__).__init__(
            'cloudamqp:index/privatelinkAws:PrivatelinkAws',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'PrivatelinkAws':
        """
        Get an existing PrivatelinkAws resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] active_zones: Covering availability zones used when creating an Endpoint from other VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principals: Allowed principals to access the endpoint service.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance identifier.
        :param pulumi.Input[_builtins.str] service_name: Service name of the PrivateLink used when creating the endpoint from other VPC.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time (seconds) when enable PrivateLink.
               Default set to 10 seconds.
               
               ***Note:*** Available from [v1.29.0]
        :param pulumi.Input[_builtins.str] status: PrivateLink status [enable, pending, disable]
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time (seconds) when enable PrivateLink.
               Default set to 1800 seconds.
               
               ***Note:*** Available from [v1.29.0]
               
               Allowed principals format: <br>
               `arn:aws:iam::aws-account-id:root` <br>
               `arn:aws:iam::aws-account-id:user/user-name` <br>
               `arn:aws:iam::aws-account-id:role/role-name`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivatelinkAwsState.__new__(_PrivatelinkAwsState)

        __props__.__dict__["active_zones"] = active_zones
        __props__.__dict__["allowed_principals"] = allowed_principals
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["status"] = status
        __props__.__dict__["timeout"] = timeout
        return PrivatelinkAws(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeZones")
    def active_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Covering availability zones used when creating an Endpoint from other VPC.
        """
        return pulumi.get(self, "active_zones")

    @_builtins.property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Allowed principals to access the endpoint service.
        """
        return pulumi.get(self, "allowed_principals")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance identifier.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name of the PrivateLink used when creating the endpoint from other VPC.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable sleep time (seconds) when enable PrivateLink.
        Default set to 10 seconds.

        ***Note:*** Available from [v1.29.0]
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        PrivateLink status [enable, pending, disable]
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configurable timeout time (seconds) when enable PrivateLink.
        Default set to 1800 seconds.

        ***Note:*** Available from [v1.29.0]

        Allowed principals format: <br>
        `arn:aws:iam::aws-account-id:root` <br>
        `arn:aws:iam::aws-account-id:user/user-name` <br>
        `arn:aws:iam::aws-account-id:role/role-name`
        """
        return pulumi.get(self, "timeout")

