# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RabbitConfigurationArgs', 'RabbitConfiguration']

@pulumi.input_type
class RabbitConfigurationArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 channel_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_partition_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_max: Optional[pulumi.Input[_builtins.int]] = None,
                 consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 heartbeat: Optional[pulumi.Input[_builtins.int]] = None,
                 log_exchange_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_interceptors_timestamp_overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_ssl_cert_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 mqtt_vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_index_embed_msgs_below: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_cert_login_from: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_options_fail_if_no_peer_cert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_options_verify: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_memory_high_watermark: Optional[pulumi.Input[_builtins.float]] = None):
        """
        The set of arguments for constructing a RabbitConfiguration resource.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.int] channel_max: Set the maximum permissible number of channels per connection.
        :param pulumi.Input[_builtins.str] cluster_partition_handling: Set how the cluster should handle network partition.
        :param pulumi.Input[_builtins.int] connection_max: Set the maximum permissible number of connection.
        :param pulumi.Input[_builtins.int] consumer_timeout: A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        :param pulumi.Input[_builtins.int] heartbeat: Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        :param pulumi.Input[_builtins.str] log_exchange_level: Log level for the logger used for log integrations and the CloudAMQP Console log view.
        :param pulumi.Input[_builtins.int] max_message_size: The largest allowed message payload size in bytes.
        :param pulumi.Input[_builtins.str] message_interceptors_timestamp_overwrite: Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        :param pulumi.Input[_builtins.str] mqtt_exchange: The exchange option determines which exchange messages from MQTT clients are published to.
        :param pulumi.Input[_builtins.bool] mqtt_ssl_cert_login: Enable SSL certificate-based authentication for MQTT connections.
        :param pulumi.Input[_builtins.str] mqtt_vhost: Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        :param pulumi.Input[_builtins.int] queue_index_embed_msgs_below: Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.str] ssl_cert_login_from: Determines which certificate field to use as the username for TLS-based authentication.
        :param pulumi.Input[_builtins.bool] ssl_options_fail_if_no_peer_cert: When set to true, TLS connections will fail if the client does not provide a certificate.
        :param pulumi.Input[_builtins.str] ssl_options_verify: Controls peer certificate verification for TLS connections.
               
               Configure sleep and timeout for API requests retries
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.float] vm_memory_high_watermark: When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if channel_max is not None:
            pulumi.set(__self__, "channel_max", channel_max)
        if cluster_partition_handling is not None:
            pulumi.set(__self__, "cluster_partition_handling", cluster_partition_handling)
        if connection_max is not None:
            pulumi.set(__self__, "connection_max", connection_max)
        if consumer_timeout is not None:
            pulumi.set(__self__, "consumer_timeout", consumer_timeout)
        if heartbeat is not None:
            pulumi.set(__self__, "heartbeat", heartbeat)
        if log_exchange_level is not None:
            pulumi.set(__self__, "log_exchange_level", log_exchange_level)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if message_interceptors_timestamp_overwrite is not None:
            pulumi.set(__self__, "message_interceptors_timestamp_overwrite", message_interceptors_timestamp_overwrite)
        if mqtt_exchange is not None:
            pulumi.set(__self__, "mqtt_exchange", mqtt_exchange)
        if mqtt_ssl_cert_login is not None:
            pulumi.set(__self__, "mqtt_ssl_cert_login", mqtt_ssl_cert_login)
        if mqtt_vhost is not None:
            pulumi.set(__self__, "mqtt_vhost", mqtt_vhost)
        if queue_index_embed_msgs_below is not None:
            pulumi.set(__self__, "queue_index_embed_msgs_below", queue_index_embed_msgs_below)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if ssl_cert_login_from is not None:
            pulumi.set(__self__, "ssl_cert_login_from", ssl_cert_login_from)
        if ssl_options_fail_if_no_peer_cert is not None:
            pulumi.set(__self__, "ssl_options_fail_if_no_peer_cert", ssl_options_fail_if_no_peer_cert)
        if ssl_options_verify is not None:
            pulumi.set(__self__, "ssl_options_verify", ssl_options_verify)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vm_memory_high_watermark is not None:
            pulumi.set(__self__, "vm_memory_high_watermark", vm_memory_high_watermark)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="channelMax")
    def channel_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the maximum permissible number of channels per connection.
        """
        return pulumi.get(self, "channel_max")

    @channel_max.setter
    def channel_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "channel_max", value)

    @_builtins.property
    @pulumi.getter(name="clusterPartitionHandling")
    def cluster_partition_handling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set how the cluster should handle network partition.
        """
        return pulumi.get(self, "cluster_partition_handling")

    @cluster_partition_handling.setter
    def cluster_partition_handling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_partition_handling", value)

    @_builtins.property
    @pulumi.getter(name="connectionMax")
    def connection_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the maximum permissible number of connection.
        """
        return pulumi.get(self, "connection_max")

    @connection_max.setter
    def connection_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_max", value)

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        """
        return pulumi.get(self, "consumer_timeout")

    @consumer_timeout.setter
    def consumer_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_timeout", value)

    @_builtins.property
    @pulumi.getter
    def heartbeat(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        """
        return pulumi.get(self, "heartbeat")

    @heartbeat.setter
    def heartbeat(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "heartbeat", value)

    @_builtins.property
    @pulumi.getter(name="logExchangeLevel")
    def log_exchange_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log level for the logger used for log integrations and the CloudAMQP Console log view.
        """
        return pulumi.get(self, "log_exchange_level")

    @log_exchange_level.setter
    def log_exchange_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_exchange_level", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The largest allowed message payload size in bytes.
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageInterceptorsTimestampOverwrite")
    def message_interceptors_timestamp_overwrite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        """
        return pulumi.get(self, "message_interceptors_timestamp_overwrite")

    @message_interceptors_timestamp_overwrite.setter
    def message_interceptors_timestamp_overwrite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_interceptors_timestamp_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="mqttExchange")
    def mqtt_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exchange option determines which exchange messages from MQTT clients are published to.
        """
        return pulumi.get(self, "mqtt_exchange")

    @mqtt_exchange.setter
    def mqtt_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_exchange", value)

    @_builtins.property
    @pulumi.getter(name="mqttSslCertLogin")
    def mqtt_ssl_cert_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSL certificate-based authentication for MQTT connections.
        """
        return pulumi.get(self, "mqtt_ssl_cert_login")

    @mqtt_ssl_cert_login.setter
    def mqtt_ssl_cert_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mqtt_ssl_cert_login", value)

    @_builtins.property
    @pulumi.getter(name="mqttVhost")
    def mqtt_vhost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        """
        return pulumi.get(self, "mqtt_vhost")

    @mqtt_vhost.setter
    def mqtt_vhost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_vhost", value)

    @_builtins.property
    @pulumi.getter(name="queueIndexEmbedMsgsBelow")
    def queue_index_embed_msgs_below(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        """
        return pulumi.get(self, "queue_index_embed_msgs_below")

    @queue_index_embed_msgs_below.setter
    def queue_index_embed_msgs_below(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_index_embed_msgs_below", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter(name="sslCertLoginFrom")
    def ssl_cert_login_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines which certificate field to use as the username for TLS-based authentication.
        """
        return pulumi.get(self, "ssl_cert_login_from")

    @ssl_cert_login_from.setter
    def ssl_cert_login_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_login_from", value)

    @_builtins.property
    @pulumi.getter(name="sslOptionsFailIfNoPeerCert")
    def ssl_options_fail_if_no_peer_cert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, TLS connections will fail if the client does not provide a certificate.
        """
        return pulumi.get(self, "ssl_options_fail_if_no_peer_cert")

    @ssl_options_fail_if_no_peer_cert.setter
    def ssl_options_fail_if_no_peer_cert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_options_fail_if_no_peer_cert", value)

    @_builtins.property
    @pulumi.getter(name="sslOptionsVerify")
    def ssl_options_verify(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls peer certificate verification for TLS connections.

        Configure sleep and timeout for API requests retries
        """
        return pulumi.get(self, "ssl_options_verify")

    @ssl_options_verify.setter
    def ssl_options_verify(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_options_verify", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="vmMemoryHighWatermark")
    def vm_memory_high_watermark(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        return pulumi.get(self, "vm_memory_high_watermark")

    @vm_memory_high_watermark.setter
    def vm_memory_high_watermark(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "vm_memory_high_watermark", value)


@pulumi.input_type
class _RabbitConfigurationState:
    def __init__(__self__, *,
                 channel_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_partition_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_max: Optional[pulumi.Input[_builtins.int]] = None,
                 consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 heartbeat: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 log_exchange_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_interceptors_timestamp_overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_ssl_cert_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 mqtt_vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_index_embed_msgs_below: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_cert_login_from: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_options_fail_if_no_peer_cert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_options_verify: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_memory_high_watermark: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering RabbitConfiguration resources.
        :param pulumi.Input[_builtins.int] channel_max: Set the maximum permissible number of channels per connection.
        :param pulumi.Input[_builtins.str] cluster_partition_handling: Set how the cluster should handle network partition.
        :param pulumi.Input[_builtins.int] connection_max: Set the maximum permissible number of connection.
        :param pulumi.Input[_builtins.int] consumer_timeout: A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        :param pulumi.Input[_builtins.int] heartbeat: Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] log_exchange_level: Log level for the logger used for log integrations and the CloudAMQP Console log view.
        :param pulumi.Input[_builtins.int] max_message_size: The largest allowed message payload size in bytes.
        :param pulumi.Input[_builtins.str] message_interceptors_timestamp_overwrite: Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        :param pulumi.Input[_builtins.str] mqtt_exchange: The exchange option determines which exchange messages from MQTT clients are published to.
        :param pulumi.Input[_builtins.bool] mqtt_ssl_cert_login: Enable SSL certificate-based authentication for MQTT connections.
        :param pulumi.Input[_builtins.str] mqtt_vhost: Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        :param pulumi.Input[_builtins.int] queue_index_embed_msgs_below: Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.str] ssl_cert_login_from: Determines which certificate field to use as the username for TLS-based authentication.
        :param pulumi.Input[_builtins.bool] ssl_options_fail_if_no_peer_cert: When set to true, TLS connections will fail if the client does not provide a certificate.
        :param pulumi.Input[_builtins.str] ssl_options_verify: Controls peer certificate verification for TLS connections.
               
               Configure sleep and timeout for API requests retries
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.float] vm_memory_high_watermark: When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        if channel_max is not None:
            pulumi.set(__self__, "channel_max", channel_max)
        if cluster_partition_handling is not None:
            pulumi.set(__self__, "cluster_partition_handling", cluster_partition_handling)
        if connection_max is not None:
            pulumi.set(__self__, "connection_max", connection_max)
        if consumer_timeout is not None:
            pulumi.set(__self__, "consumer_timeout", consumer_timeout)
        if heartbeat is not None:
            pulumi.set(__self__, "heartbeat", heartbeat)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if log_exchange_level is not None:
            pulumi.set(__self__, "log_exchange_level", log_exchange_level)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if message_interceptors_timestamp_overwrite is not None:
            pulumi.set(__self__, "message_interceptors_timestamp_overwrite", message_interceptors_timestamp_overwrite)
        if mqtt_exchange is not None:
            pulumi.set(__self__, "mqtt_exchange", mqtt_exchange)
        if mqtt_ssl_cert_login is not None:
            pulumi.set(__self__, "mqtt_ssl_cert_login", mqtt_ssl_cert_login)
        if mqtt_vhost is not None:
            pulumi.set(__self__, "mqtt_vhost", mqtt_vhost)
        if queue_index_embed_msgs_below is not None:
            pulumi.set(__self__, "queue_index_embed_msgs_below", queue_index_embed_msgs_below)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if ssl_cert_login_from is not None:
            pulumi.set(__self__, "ssl_cert_login_from", ssl_cert_login_from)
        if ssl_options_fail_if_no_peer_cert is not None:
            pulumi.set(__self__, "ssl_options_fail_if_no_peer_cert", ssl_options_fail_if_no_peer_cert)
        if ssl_options_verify is not None:
            pulumi.set(__self__, "ssl_options_verify", ssl_options_verify)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vm_memory_high_watermark is not None:
            pulumi.set(__self__, "vm_memory_high_watermark", vm_memory_high_watermark)

    @_builtins.property
    @pulumi.getter(name="channelMax")
    def channel_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the maximum permissible number of channels per connection.
        """
        return pulumi.get(self, "channel_max")

    @channel_max.setter
    def channel_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "channel_max", value)

    @_builtins.property
    @pulumi.getter(name="clusterPartitionHandling")
    def cluster_partition_handling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set how the cluster should handle network partition.
        """
        return pulumi.get(self, "cluster_partition_handling")

    @cluster_partition_handling.setter
    def cluster_partition_handling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_partition_handling", value)

    @_builtins.property
    @pulumi.getter(name="connectionMax")
    def connection_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the maximum permissible number of connection.
        """
        return pulumi.get(self, "connection_max")

    @connection_max.setter
    def connection_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_max", value)

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        """
        return pulumi.get(self, "consumer_timeout")

    @consumer_timeout.setter
    def consumer_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_timeout", value)

    @_builtins.property
    @pulumi.getter
    def heartbeat(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        """
        return pulumi.get(self, "heartbeat")

    @heartbeat.setter
    def heartbeat(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "heartbeat", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="logExchangeLevel")
    def log_exchange_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log level for the logger used for log integrations and the CloudAMQP Console log view.
        """
        return pulumi.get(self, "log_exchange_level")

    @log_exchange_level.setter
    def log_exchange_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_exchange_level", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The largest allowed message payload size in bytes.
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageInterceptorsTimestampOverwrite")
    def message_interceptors_timestamp_overwrite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        """
        return pulumi.get(self, "message_interceptors_timestamp_overwrite")

    @message_interceptors_timestamp_overwrite.setter
    def message_interceptors_timestamp_overwrite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_interceptors_timestamp_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="mqttExchange")
    def mqtt_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exchange option determines which exchange messages from MQTT clients are published to.
        """
        return pulumi.get(self, "mqtt_exchange")

    @mqtt_exchange.setter
    def mqtt_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_exchange", value)

    @_builtins.property
    @pulumi.getter(name="mqttSslCertLogin")
    def mqtt_ssl_cert_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSL certificate-based authentication for MQTT connections.
        """
        return pulumi.get(self, "mqtt_ssl_cert_login")

    @mqtt_ssl_cert_login.setter
    def mqtt_ssl_cert_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mqtt_ssl_cert_login", value)

    @_builtins.property
    @pulumi.getter(name="mqttVhost")
    def mqtt_vhost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        """
        return pulumi.get(self, "mqtt_vhost")

    @mqtt_vhost.setter
    def mqtt_vhost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_vhost", value)

    @_builtins.property
    @pulumi.getter(name="queueIndexEmbedMsgsBelow")
    def queue_index_embed_msgs_below(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        """
        return pulumi.get(self, "queue_index_embed_msgs_below")

    @queue_index_embed_msgs_below.setter
    def queue_index_embed_msgs_below(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_index_embed_msgs_below", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter(name="sslCertLoginFrom")
    def ssl_cert_login_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines which certificate field to use as the username for TLS-based authentication.
        """
        return pulumi.get(self, "ssl_cert_login_from")

    @ssl_cert_login_from.setter
    def ssl_cert_login_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_login_from", value)

    @_builtins.property
    @pulumi.getter(name="sslOptionsFailIfNoPeerCert")
    def ssl_options_fail_if_no_peer_cert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, TLS connections will fail if the client does not provide a certificate.
        """
        return pulumi.get(self, "ssl_options_fail_if_no_peer_cert")

    @ssl_options_fail_if_no_peer_cert.setter
    def ssl_options_fail_if_no_peer_cert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_options_fail_if_no_peer_cert", value)

    @_builtins.property
    @pulumi.getter(name="sslOptionsVerify")
    def ssl_options_verify(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls peer certificate verification for TLS connections.

        Configure sleep and timeout for API requests retries
        """
        return pulumi.get(self, "ssl_options_verify")

    @ssl_options_verify.setter
    def ssl_options_verify(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_options_verify", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="vmMemoryHighWatermark")
    def vm_memory_high_watermark(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        return pulumi.get(self, "vm_memory_high_watermark")

    @vm_memory_high_watermark.setter
    def vm_memory_high_watermark(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "vm_memory_high_watermark", value)


@pulumi.type_token("cloudamqp:index/rabbitConfiguration:RabbitConfiguration")
class RabbitConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_partition_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_max: Optional[pulumi.Input[_builtins.int]] = None,
                 consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 heartbeat: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 log_exchange_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_interceptors_timestamp_overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_ssl_cert_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 mqtt_vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_index_embed_msgs_below: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_cert_login_from: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_options_fail_if_no_peer_cert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_options_verify: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_memory_high_watermark: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        """
        ## Import

        `cloudamqp_rabbitmq_configuration` can be imported using the CloudAMQP instance identifier.  To

        retrieve the identifier, use [CloudAMQP API list intances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_rabbitmq_configuration.config

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/rabbitConfiguration:RabbitConfiguration config <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] channel_max: Set the maximum permissible number of channels per connection.
        :param pulumi.Input[_builtins.str] cluster_partition_handling: Set how the cluster should handle network partition.
        :param pulumi.Input[_builtins.int] connection_max: Set the maximum permissible number of connection.
        :param pulumi.Input[_builtins.int] consumer_timeout: A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        :param pulumi.Input[_builtins.int] heartbeat: Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] log_exchange_level: Log level for the logger used for log integrations and the CloudAMQP Console log view.
        :param pulumi.Input[_builtins.int] max_message_size: The largest allowed message payload size in bytes.
        :param pulumi.Input[_builtins.str] message_interceptors_timestamp_overwrite: Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        :param pulumi.Input[_builtins.str] mqtt_exchange: The exchange option determines which exchange messages from MQTT clients are published to.
        :param pulumi.Input[_builtins.bool] mqtt_ssl_cert_login: Enable SSL certificate-based authentication for MQTT connections.
        :param pulumi.Input[_builtins.str] mqtt_vhost: Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        :param pulumi.Input[_builtins.int] queue_index_embed_msgs_below: Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.str] ssl_cert_login_from: Determines which certificate field to use as the username for TLS-based authentication.
        :param pulumi.Input[_builtins.bool] ssl_options_fail_if_no_peer_cert: When set to true, TLS connections will fail if the client does not provide a certificate.
        :param pulumi.Input[_builtins.str] ssl_options_verify: Controls peer certificate verification for TLS connections.
               
               Configure sleep and timeout for API requests retries
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.float] vm_memory_high_watermark: When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RabbitConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `cloudamqp_rabbitmq_configuration` can be imported using the CloudAMQP instance identifier.  To

        retrieve the identifier, use [CloudAMQP API list intances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_rabbitmq_configuration.config

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/rabbitConfiguration:RabbitConfiguration config <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param RabbitConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RabbitConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_partition_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_max: Optional[pulumi.Input[_builtins.int]] = None,
                 consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 heartbeat: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 log_exchange_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_interceptors_timestamp_overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_ssl_cert_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 mqtt_vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_index_embed_msgs_below: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_cert_login_from: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_options_fail_if_no_peer_cert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_options_verify: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_memory_high_watermark: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RabbitConfigurationArgs.__new__(RabbitConfigurationArgs)

            __props__.__dict__["channel_max"] = channel_max
            __props__.__dict__["cluster_partition_handling"] = cluster_partition_handling
            __props__.__dict__["connection_max"] = connection_max
            __props__.__dict__["consumer_timeout"] = consumer_timeout
            __props__.__dict__["heartbeat"] = heartbeat
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["log_exchange_level"] = log_exchange_level
            __props__.__dict__["max_message_size"] = max_message_size
            __props__.__dict__["message_interceptors_timestamp_overwrite"] = message_interceptors_timestamp_overwrite
            __props__.__dict__["mqtt_exchange"] = mqtt_exchange
            __props__.__dict__["mqtt_ssl_cert_login"] = mqtt_ssl_cert_login
            __props__.__dict__["mqtt_vhost"] = mqtt_vhost
            __props__.__dict__["queue_index_embed_msgs_below"] = queue_index_embed_msgs_below
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["ssl_cert_login_from"] = ssl_cert_login_from
            __props__.__dict__["ssl_options_fail_if_no_peer_cert"] = ssl_options_fail_if_no_peer_cert
            __props__.__dict__["ssl_options_verify"] = ssl_options_verify
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["vm_memory_high_watermark"] = vm_memory_high_watermark
        super(RabbitConfiguration, __self__).__init__(
            'cloudamqp:index/rabbitConfiguration:RabbitConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_max: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_partition_handling: Optional[pulumi.Input[_builtins.str]] = None,
            connection_max: Optional[pulumi.Input[_builtins.int]] = None,
            consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            heartbeat: Optional[pulumi.Input[_builtins.int]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            log_exchange_level: Optional[pulumi.Input[_builtins.str]] = None,
            max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
            message_interceptors_timestamp_overwrite: Optional[pulumi.Input[_builtins.str]] = None,
            mqtt_exchange: Optional[pulumi.Input[_builtins.str]] = None,
            mqtt_ssl_cert_login: Optional[pulumi.Input[_builtins.bool]] = None,
            mqtt_vhost: Optional[pulumi.Input[_builtins.str]] = None,
            queue_index_embed_msgs_below: Optional[pulumi.Input[_builtins.int]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            ssl_cert_login_from: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_options_fail_if_no_peer_cert: Optional[pulumi.Input[_builtins.bool]] = None,
            ssl_options_verify: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            vm_memory_high_watermark: Optional[pulumi.Input[_builtins.float]] = None) -> 'RabbitConfiguration':
        """
        Get an existing RabbitConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] channel_max: Set the maximum permissible number of channels per connection.
        :param pulumi.Input[_builtins.str] cluster_partition_handling: Set how the cluster should handle network partition.
        :param pulumi.Input[_builtins.int] connection_max: Set the maximum permissible number of connection.
        :param pulumi.Input[_builtins.int] consumer_timeout: A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        :param pulumi.Input[_builtins.int] heartbeat: Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] log_exchange_level: Log level for the logger used for log integrations and the CloudAMQP Console log view.
        :param pulumi.Input[_builtins.int] max_message_size: The largest allowed message payload size in bytes.
        :param pulumi.Input[_builtins.str] message_interceptors_timestamp_overwrite: Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        :param pulumi.Input[_builtins.str] mqtt_exchange: The exchange option determines which exchange messages from MQTT clients are published to.
        :param pulumi.Input[_builtins.bool] mqtt_ssl_cert_login: Enable SSL certificate-based authentication for MQTT connections.
        :param pulumi.Input[_builtins.str] mqtt_vhost: Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        :param pulumi.Input[_builtins.int] queue_index_embed_msgs_below: Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        :param pulumi.Input[_builtins.str] ssl_cert_login_from: Determines which certificate field to use as the username for TLS-based authentication.
        :param pulumi.Input[_builtins.bool] ssl_options_fail_if_no_peer_cert: When set to true, TLS connections will fail if the client does not provide a certificate.
        :param pulumi.Input[_builtins.str] ssl_options_verify: Controls peer certificate verification for TLS connections.
               
               Configure sleep and timeout for API requests retries
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        :param pulumi.Input[_builtins.float] vm_memory_high_watermark: When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RabbitConfigurationState.__new__(_RabbitConfigurationState)

        __props__.__dict__["channel_max"] = channel_max
        __props__.__dict__["cluster_partition_handling"] = cluster_partition_handling
        __props__.__dict__["connection_max"] = connection_max
        __props__.__dict__["consumer_timeout"] = consumer_timeout
        __props__.__dict__["heartbeat"] = heartbeat
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["log_exchange_level"] = log_exchange_level
        __props__.__dict__["max_message_size"] = max_message_size
        __props__.__dict__["message_interceptors_timestamp_overwrite"] = message_interceptors_timestamp_overwrite
        __props__.__dict__["mqtt_exchange"] = mqtt_exchange
        __props__.__dict__["mqtt_ssl_cert_login"] = mqtt_ssl_cert_login
        __props__.__dict__["mqtt_vhost"] = mqtt_vhost
        __props__.__dict__["queue_index_embed_msgs_below"] = queue_index_embed_msgs_below
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["ssl_cert_login_from"] = ssl_cert_login_from
        __props__.__dict__["ssl_options_fail_if_no_peer_cert"] = ssl_options_fail_if_no_peer_cert
        __props__.__dict__["ssl_options_verify"] = ssl_options_verify
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["vm_memory_high_watermark"] = vm_memory_high_watermark
        return RabbitConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="channelMax")
    def channel_max(self) -> pulumi.Output[_builtins.int]:
        """
        Set the maximum permissible number of channels per connection.
        """
        return pulumi.get(self, "channel_max")

    @_builtins.property
    @pulumi.getter(name="clusterPartitionHandling")
    def cluster_partition_handling(self) -> pulumi.Output[_builtins.str]:
        """
        Set how the cluster should handle network partition.
        """
        return pulumi.get(self, "cluster_partition_handling")

    @_builtins.property
    @pulumi.getter(name="connectionMax")
    def connection_max(self) -> pulumi.Output[_builtins.int]:
        """
        Set the maximum permissible number of connection.
        """
        return pulumi.get(self, "connection_max")

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        A consumer that has received a message and does not acknowledge that message within the timeout in milliseconds
        """
        return pulumi.get(self, "consumer_timeout")

    @_builtins.property
    @pulumi.getter
    def heartbeat(self) -> pulumi.Output[_builtins.int]:
        """
        Set the server AMQP 0-9-1 heartbeat timeout in seconds.
        """
        return pulumi.get(self, "heartbeat")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="logExchangeLevel")
    def log_exchange_level(self) -> pulumi.Output[_builtins.str]:
        """
        Log level for the logger used for log integrations and the CloudAMQP Console log view.
        """
        return pulumi.get(self, "log_exchange_level")

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Output[_builtins.int]:
        """
        The largest allowed message payload size in bytes.
        """
        return pulumi.get(self, "max_message_size")

    @_builtins.property
    @pulumi.getter(name="messageInterceptorsTimestampOverwrite")
    def message_interceptors_timestamp_overwrite(self) -> pulumi.Output[_builtins.str]:
        """
        Sets a timestamp header on incoming messages. ***enabled_with_overwrite*** will overwrite any existing timestamps in the header.
        """
        return pulumi.get(self, "message_interceptors_timestamp_overwrite")

    @_builtins.property
    @pulumi.getter(name="mqttExchange")
    def mqtt_exchange(self) -> pulumi.Output[_builtins.str]:
        """
        The exchange option determines which exchange messages from MQTT clients are published to.
        """
        return pulumi.get(self, "mqtt_exchange")

    @_builtins.property
    @pulumi.getter(name="mqttSslCertLogin")
    def mqtt_ssl_cert_login(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable SSL certificate-based authentication for MQTT connections.
        """
        return pulumi.get(self, "mqtt_ssl_cert_login")

    @_builtins.property
    @pulumi.getter(name="mqttVhost")
    def mqtt_vhost(self) -> pulumi.Output[_builtins.str]:
        """
        Virtual host for MQTT connections. Default set to newly created vhost, same as `cloudamqp_instance.instance.vhost`.
        """
        return pulumi.get(self, "mqtt_vhost")

    @_builtins.property
    @pulumi.getter(name="queueIndexEmbedMsgsBelow")
    def queue_index_embed_msgs_below(self) -> pulumi.Output[_builtins.int]:
        """
        Size in bytes below which to embed messages in the queue index. 0 will turn off payload embedding in the queue index.
        """
        return pulumi.get(self, "queue_index_embed_msgs_below")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable sleep time in seconds between retries for RabbitMQ configuration. Default set to 60 seconds.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter(name="sslCertLoginFrom")
    def ssl_cert_login_from(self) -> pulumi.Output[_builtins.str]:
        """
        Determines which certificate field to use as the username for TLS-based authentication.
        """
        return pulumi.get(self, "ssl_cert_login_from")

    @_builtins.property
    @pulumi.getter(name="sslOptionsFailIfNoPeerCert")
    def ssl_options_fail_if_no_peer_cert(self) -> pulumi.Output[_builtins.bool]:
        """
        When set to true, TLS connections will fail if the client does not provide a certificate.
        """
        return pulumi.get(self, "ssl_options_fail_if_no_peer_cert")

    @_builtins.property
    @pulumi.getter(name="sslOptionsVerify")
    def ssl_options_verify(self) -> pulumi.Output[_builtins.str]:
        """
        Controls peer certificate verification for TLS connections.

        Configure sleep and timeout for API requests retries
        """
        return pulumi.get(self, "ssl_options_verify")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable timeout time in seconds for RabbitMQ configuration. Default set to 3600 seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="vmMemoryHighWatermark")
    def vm_memory_high_watermark(self) -> pulumi.Output[_builtins.float]:
        """
        When the server will enter memory based flow-control as relative to the maximum available memory.
        """
        return pulumi.get(self, "vm_memory_high_watermark")

