# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrustStoreArgs', 'TrustStore']

@pulumi.input_type
class TrustStoreArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 http: Optional[pulumi.Input['TrustStoreHttpArgs']] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a TrustStore resource.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input['TrustStoreHttpArgs'] http: HTTP trust store configuration block. See HTTP Block below.
        :param pulumi.Input[_builtins.int] refresh_interval: Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
               Defaults to 30 seconds.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               trust store operations. Defaults to 10 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for trust store
               operations. Defaults to 1800 seconds (30 minutes).
        :param pulumi.Input[_builtins.int] version: Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['TrustStoreHttpArgs']]:
        """
        HTTP trust store configuration block. See HTTP Block below.
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['TrustStoreHttpArgs']]):
        pulumi.set(self, "http", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
        Defaults to 30 seconds.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for
        trust store operations. Defaults to 10 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for trust store
        operations. Defaults to 1800 seconds (30 minutes).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _TrustStoreState:
    def __init__(__self__, *,
                 http: Optional[pulumi.Input['TrustStoreHttpArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering TrustStore resources.
        :param pulumi.Input['TrustStoreHttpArgs'] http: HTTP trust store configuration block. See HTTP Block below.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.int] refresh_interval: Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
               Defaults to 30 seconds.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               trust store operations. Defaults to 10 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for trust store
               operations. Defaults to 1800 seconds (30 minutes).
        :param pulumi.Input[_builtins.int] version: Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['TrustStoreHttpArgs']]:
        """
        HTTP trust store configuration block. See HTTP Block below.
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['TrustStoreHttpArgs']]):
        pulumi.set(self, "http", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
        Defaults to 30 seconds.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable sleep time in seconds between retries for
        trust store operations. Defaults to 10 seconds.
        """
        return pulumi.get(self, "sleep")

    @sleep.setter
    def sleep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sleep", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configurable timeout time in seconds for trust store
        operations. Defaults to 1800 seconds (30 minutes).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("cloudamqp:index/trustStore:TrustStore")
class TrustStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 http: Optional[pulumi.Input[Union['TrustStoreHttpArgs', 'TrustStoreHttpArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource allows you to configure a trust store for your RabbitMQ instance. The trust store enables RabbitMQ to fetch and use CA certificates from an external source for validating client certificates.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Basic trust store configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        trust_store = cloudamqp.TrustStore("trust_store",
            instance_id=instance["id"],
            http={
                "url": "https://example.com/trust-store-certs",
            },
            refresh_interval=30)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Trust store with CA certificate</i>
            </b>
          </summary>

        ## Import

        `cloudamqp_trust_store` can be imported using the CloudAMQP instance identifier.

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_trust_store.trust_store

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/trustStore:TrustStore trust_store <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TrustStoreHttpArgs', 'TrustStoreHttpArgsDict']] http: HTTP trust store configuration block. See HTTP Block below.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.int] refresh_interval: Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
               Defaults to 30 seconds.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               trust store operations. Defaults to 10 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for trust store
               operations. Defaults to 1800 seconds (30 minutes).
        :param pulumi.Input[_builtins.int] version: Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to configure a trust store for your RabbitMQ instance. The trust store enables RabbitMQ to fetch and use CA certificates from an external source for validating client certificates.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Basic trust store configuration</i>
            </b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        trust_store = cloudamqp.TrustStore("trust_store",
            instance_id=instance["id"],
            http={
                "url": "https://example.com/trust-store-certs",
            },
            refresh_interval=30)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Trust store with CA certificate</i>
            </b>
          </summary>

        ## Import

        `cloudamqp_trust_store` can be imported using the CloudAMQP instance identifier.

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_trust_store.trust_store

          id = cloudamqp_instance.instance.id

        }

        Or use Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/trustStore:TrustStore trust_store <instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param TrustStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 http: Optional[pulumi.Input[Union['TrustStoreHttpArgs', 'TrustStoreHttpArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sleep: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustStoreArgs.__new__(TrustStoreArgs)

            __props__.__dict__["http"] = http
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["sleep"] = sleep
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["version"] = version
        super(TrustStore, __self__).__init__(
            'cloudamqp:index/trustStore:TrustStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            http: Optional[pulumi.Input[Union['TrustStoreHttpArgs', 'TrustStoreHttpArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
            sleep: Optional[pulumi.Input[_builtins.int]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'TrustStore':
        """
        Get an existing TrustStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TrustStoreHttpArgs', 'TrustStoreHttpArgsDict']] http: HTTP trust store configuration block. See HTTP Block below.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.int] refresh_interval: Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
               Defaults to 30 seconds.
        :param pulumi.Input[_builtins.int] sleep: Configurable sleep time in seconds between retries for
               trust store operations. Defaults to 10 seconds.
        :param pulumi.Input[_builtins.int] timeout: Configurable timeout time in seconds for trust store
               operations. Defaults to 1800 seconds (30 minutes).
        :param pulumi.Input[_builtins.int] version: Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustStoreState.__new__(_TrustStoreState)

        __props__.__dict__["http"] = http
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["sleep"] = sleep
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["version"] = version
        return TrustStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def http(self) -> pulumi.Output[Optional['outputs.TrustStoreHttp']]:
        """
        HTTP trust store configuration block. See HTTP Block below.
        """
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Interval in seconds to refresh the trust store certificates. Defaults to 30 seconds.
        Defaults to 30 seconds.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable sleep time in seconds between retries for
        trust store operations. Defaults to 10 seconds.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Configurable timeout time in seconds for trust store
        operations. Defaults to 1800 seconds (30 minutes).
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        Version of write-only certificates. Increment this value to force an update of write-only fields like `cacert`. Defaults to 1.
        """
        return pulumi.get(self, "version")

