# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 db_pass: pulumi.Input[str],
                 kps_enabled: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 organization_id: pulumi.Input[str],
                 plan: pulumi.Input['Plan'],
                 region: pulumi.Input['Region']):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[str] db_pass: Postgres password of the project
        :param pulumi.Input[bool] kps_enabled: KPS Enabled on the project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] organization_id: Organization ID of the project
        :param pulumi.Input['Plan'] plan: Plan of the project
        :param pulumi.Input['Region'] region: Region of the project
        """
        pulumi.set(__self__, "db_pass", db_pass)
        pulumi.set(__self__, "kps_enabled", kps_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def db_pass(self) -> pulumi.Input[str]:
        """
        Postgres password of the project
        """
        return pulumi.get(self, "db_pass")

    @db_pass.setter
    def db_pass(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_pass", value)

    @property
    @pulumi.getter
    def kps_enabled(self) -> pulumi.Input[bool]:
        """
        KPS Enabled on the project
        """
        return pulumi.get(self, "kps_enabled")

    @kps_enabled.setter
    def kps_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "kps_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the project
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization_id(self) -> pulumi.Input[str]:
        """
        Organization ID of the project
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input['Plan']:
        """
        Plan of the project
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input['Plan']):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input['Region']:
        """
        Region of the project
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input['Region']):
        pulumi.set(self, "region", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_pass: Optional[pulumi.Input[str]] = None,
                 kps_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input['Plan']] = None,
                 region: Optional[pulumi.Input['Region']] = None,
                 __props__=None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_pass: Postgres password of the project
        :param pulumi.Input[bool] kps_enabled: KPS Enabled on the project
        :param pulumi.Input[str] name: Name of the project
        :param pulumi.Input[str] organization_id: Organization ID of the project
        :param pulumi.Input['Plan'] plan: Plan of the project
        :param pulumi.Input['Region'] region: Region of the project
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_pass: Optional[pulumi.Input[str]] = None,
                 kps_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input['Plan']] = None,
                 region: Optional[pulumi.Input['Region']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            if db_pass is None and not opts.urn:
                raise TypeError("Missing required property 'db_pass'")
            __props__.__dict__["db_pass"] = None if db_pass is None else pulumi.Output.secret(db_pass)
            if kps_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'kps_enabled'")
            __props__.__dict__["kps_enabled"] = kps_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["db_host"] = None
            __props__.__dict__["db_name"] = None
            __props__.__dict__["db_pooling_port"] = None
            __props__.__dict__["db_port"] = None
            __props__.__dict__["db_username"] = None
            __props__.__dict__["endpoint"] = None
        super(Project, __self__).__init__(
            'supabase:index:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProjectArgs.__new__(ProjectArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["db_host"] = None
        __props__.__dict__["db_name"] = None
        __props__.__dict__["db_pooling_port"] = None
        __props__.__dict__["db_port"] = None
        __props__.__dict__["db_username"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["organization_id"] = None
        __props__.__dict__["region"] = None
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created_at(self) -> pulumi.Output[str]:
        """
        Project creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dbHost")
    def db_host(self) -> pulumi.Output[str]:
        """
        DB Hostname
        """
        return pulumi.get(self, "db_host")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        DB Name
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPoolingPort")
    def db_pooling_port(self) -> pulumi.Output[int]:
        """
        DB Port for pooled connection
        """
        return pulumi.get(self, "db_pooling_port")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> pulumi.Output[int]:
        """
        DB Port
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> pulumi.Output[str]:
        """
        DB Username
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Supabase endpoint for client
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the project
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization_id(self) -> pulumi.Output[str]:
        """
        Organization ID of the project
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output['Region']:
        """
        Region of the project
        """
        return pulumi.get(self, "region")

