"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const rule_1 = require("../lib/rule");
class SomeTarget {
    constructor(input) {
        this.input = input;
    }
    bind() {
        return { id: 'T1', arn: 'ARN1', input: this.input };
    }
}
module.exports = {
    'json template': {
        'can just be a JSON object'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            const rule = new rule_1.Rule(stack, 'Rule', {
                schedule: lib_1.Schedule.rate(core_1.Duration.minutes(1)),
            });
            // WHEN
            rule.addTarget(new SomeTarget(lib_1.RuleTargetInput.fromObject({ SomeObject: 'withAValue' })));
            // THEN
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::Events::Rule', {
                Targets: [
                    {
                        Input: "{\"SomeObject\":\"withAValue\"}"
                    }
                ]
            }));
            test.done();
        },
    },
    'text templates': {
        'strings with newlines are serialized to a newline-delimited list of JSON strings'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            const rule = new rule_1.Rule(stack, 'Rule', {
                schedule: lib_1.Schedule.rate(core_1.Duration.minutes(1)),
            });
            // WHEN
            rule.addTarget(new SomeTarget(lib_1.RuleTargetInput.fromMultilineText('I have\nmultiple lines')));
            // THEN
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::Events::Rule', {
                Targets: [
                    {
                        Input: "\"I have\"\n\"multiple lines\""
                    }
                ]
            }));
            test.done();
        },
        'escaped newlines are not interpreted as newlines'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            const rule = new rule_1.Rule(stack, 'Rule', {
                schedule: lib_1.Schedule.rate(core_1.Duration.minutes(1)),
            });
            // WHEN
            rule.addTarget(new SomeTarget(lib_1.RuleTargetInput.fromMultilineText('this is not\\na real newline'))),
                // THEN
                assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::Events::Rule', {
                    Targets: [
                        {
                            Input: "\"this is not\\\\na real newline\""
                        }
                    ]
                }));
            test.done();
        },
        'can use Tokens in text templates'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            const rule = new rule_1.Rule(stack, 'Rule', {
                schedule: lib_1.Schedule.rate(core_1.Duration.minutes(1)),
            });
            const world = cdk.Lazy.stringValue({ produce: () => 'world' });
            // WHEN
            rule.addTarget(new SomeTarget(lib_1.RuleTargetInput.fromText(`hello ${world}`)));
            // THEN
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::Events::Rule', {
                Targets: [
                    {
                        Input: "\"hello world\""
                    }
                ]
            }));
            test.done();
        }
    },
};
//# sourceMappingURL=data:application/json;base64,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