###
### This file was automatically generated
###

from archinfo.arch import register_arch, Endness, Register

from .common import ArchPcode


class ArchPcode_PowerPC_BE_64_A2_32addr(ArchPcode):
    name = 'PowerPC:BE:64:A2-32addr'
    pcode_arch = 'PowerPC:BE:64:A2-32addr'
    description = 'Power ISA 3.0 Big Endian w/EVX and 32-bit Addressing'
    bits = 32
    ip_offset = 0x780
    sp_offset = 0x8
    bp_offset = sp_offset
    instruction_endness = Endness.BE
    register_list = [
        Register('r0', 8, 0x0),
        Register('r1', 8, 0x8),
        Register('r2', 8, 0x10),
        Register('r3', 8, 0x18),
        Register('r4', 8, 0x20),
        Register('r5', 8, 0x28),
        Register('r6', 8, 0x30),
        Register('r7', 8, 0x38),
        Register('r8', 8, 0x40),
        Register('r9', 8, 0x48),
        Register('r10', 8, 0x50),
        Register('r11', 8, 0x58),
        Register('r12', 8, 0x60),
        Register('r13', 8, 0x68),
        Register('r14', 8, 0x70),
        Register('r15', 8, 0x78),
        Register('r16', 8, 0x80),
        Register('r17', 8, 0x88),
        Register('r18', 8, 0x90),
        Register('r19', 8, 0x98),
        Register('r20', 8, 0xa0),
        Register('r21', 8, 0xa8),
        Register('r22', 8, 0xb0),
        Register('r23', 8, 0xb8),
        Register('r24', 8, 0xc0),
        Register('r25', 8, 0xc8),
        Register('r26', 8, 0xd0),
        Register('r27', 8, 0xd8),
        Register('r28', 8, 0xe0),
        Register('r29', 8, 0xe8),
        Register('r30', 8, 0xf0),
        Register('r31', 8, 0xf8),
        Register('xer_so', 1, 0x400),
        Register('xer_ov', 1, 0x401),
        Register('xer_ov32', 1, 0x402),
        Register('xer_ca', 1, 0x403),
        Register('xer_ca32', 1, 0x404),
        Register('xer_count', 1, 0x405),
        Register('fp_fx', 1, 0x500),
        Register('fp_fex', 1, 0x501),
        Register('fp_vx', 1, 0x502),
        Register('fp_ox', 1, 0x503),
        Register('fp_ux', 1, 0x504),
        Register('fp_zx', 1, 0x505),
        Register('fp_xx', 1, 0x506),
        Register('fp_vxsnan', 1, 0x507),
        Register('fp_vxisi', 1, 0x508),
        Register('fp_vxidi', 1, 0x509),
        Register('fp_vxzdz', 1, 0x50a),
        Register('fp_vximz', 1, 0x50b),
        Register('fp_vxvc', 1, 0x50c),
        Register('fp_fr', 1, 0x50d),
        Register('fp_fi', 1, 0x50e),
        Register('fp_c', 1, 0x50f),
        Register('fp_cc0', 1, 0x510),
        Register('fp_cc1', 1, 0x511),
        Register('fp_cc2', 1, 0x512),
        Register('fp_cc3', 1, 0x513),
        Register('fp_reserve1', 1, 0x514),
        Register('fp_vxsoft', 1, 0x515),
        Register('fp_vxsqrt', 1, 0x516),
        Register('fp_vxcvi', 1, 0x517),
        Register('fp_ve', 1, 0x518),
        Register('fp_oe', 1, 0x519),
        Register('fp_ue', 1, 0x51a),
        Register('fp_ze', 1, 0x51b),
        Register('fp_xe', 1, 0x51c),
        Register('fp_ni', 1, 0x51d),
        Register('fp_rn0', 1, 0x51e),
        Register('fp_rn1', 1, 0x51f),
        Register('spef_sovh', 1, 0x600),
        Register('spef_ovh', 1, 0x601),
        Register('spef_fgh', 1, 0x602),
        Register('spef_fxh', 1, 0x603),
        Register('spef_finvh', 1, 0x604),
        Register('spef_fdbzh', 1, 0x605),
        Register('spef_funfh', 1, 0x606),
        Register('spef_fovfh', 1, 0x607),
        Register('spef_reserved1', 1, 0x608),
        Register('spef_reserved2', 1, 0x609),
        Register('spef_finxs', 1, 0x60a),
        Register('spef_finvs', 1, 0x60b),
        Register('spef_fdbzs', 1, 0x60c),
        Register('spef_funfs', 1, 0x60d),
        Register('spef_fovfs', 1, 0x60e),
        Register('spef_reserved3', 1, 0x60f),
        Register('spef_sov', 1, 0x610),
        Register('spef_ov', 1, 0x611),
        Register('spef_fg', 1, 0x612),
        Register('spef_fx', 1, 0x613),
        Register('spef_finv', 1, 0x614),
        Register('spef_fdbz', 1, 0x615),
        Register('spef_funf', 1, 0x616),
        Register('spef_fovf', 1, 0x617),
        Register('spef_reserved4', 1, 0x618),
        Register('spef_finxe', 1, 0x619),
        Register('spef_finve', 1, 0x61a),
        Register('spef_fdbze', 1, 0x61b),
        Register('spef_funfe', 1, 0x61c),
        Register('spef_fovfe', 1, 0x61d),
        Register('spef_frmc0', 1, 0x61e),
        Register('spef_frmc1', 1, 0x61f),
        Register('msr', 8, 0x700),
        Register('reserve_address', 8, 0x720),
        Register('reserve', 1, 0x728),
        Register('reserve_length', 1, 0x730),
        Register('pc', 8, 0x780, alias_names=('ip',)),
        Register('sr0', 4, 0x800),
        Register('sr1', 4, 0x804),
        Register('sr2', 4, 0x808),
        Register('sr3', 4, 0x80c),
        Register('sr4', 4, 0x810),
        Register('sr5', 4, 0x814),
        Register('sr6', 4, 0x818),
        Register('sr7', 4, 0x81c),
        Register('sr8', 4, 0x820),
        Register('sr9', 4, 0x824),
        Register('sr10', 4, 0x828),
        Register('sr11', 4, 0x82c),
        Register('sr12', 4, 0x830),
        Register('sr13', 4, 0x834),
        Register('sr14', 4, 0x838),
        Register('sr15', 4, 0x83c),
        Register('crall', 8, 0x900),
        Register('cr0', 1, 0x900),
        Register('cr1', 1, 0x901),
        Register('cr2', 1, 0x902),
        Register('cr3', 1, 0x903),
        Register('cr4', 1, 0x904),
        Register('cr5', 1, 0x905),
        Register('cr6', 1, 0x906),
        Register('cr7', 1, 0x907),
        Register('tea', 8, 0x980),
        Register('r2save', 8, 0x988),
        Register('spr000', 8, 0x1000),
        Register('xer', 8, 0x1008),
        Register('spr002', 8, 0x1010),
        Register('spr003', 8, 0x1018),
        Register('spr004', 8, 0x1020),
        Register('spr005', 8, 0x1028),
        Register('spr006', 8, 0x1030),
        Register('spr007', 8, 0x1038),
        Register('lr', 8, 0x1040),
        Register('ctr', 8, 0x1048),
        Register('spr00a', 8, 0x1050),
        Register('spr00b', 8, 0x1058),
        Register('spr00c', 8, 0x1060),
        Register('spr00d', 8, 0x1068),
        Register('spr00e', 8, 0x1070),
        Register('spr00f', 8, 0x1078),
        Register('spr010', 8, 0x1080),
        Register('spr011', 8, 0x1088),
        Register('spr012', 8, 0x1090),
        Register('spr013', 8, 0x1098),
        Register('spr014', 8, 0x10a0),
        Register('spr015', 8, 0x10a8),
        Register('spr016', 8, 0x10b0),
        Register('spr017', 8, 0x10b8),
        Register('spr018', 8, 0x10c0),
        Register('spr019', 8, 0x10c8),
        Register('srr0', 8, 0x10d0),
        Register('srr1', 8, 0x10d8),
        Register('spr01c', 8, 0x10e0),
        Register('spr01d', 8, 0x10e8),
        Register('spr01e', 8, 0x10f0),
        Register('spr01f', 8, 0x10f8),
        Register('spr020', 8, 0x1100),
        Register('spr021', 8, 0x1108),
        Register('spr022', 8, 0x1110),
        Register('spr023', 8, 0x1118),
        Register('spr024', 8, 0x1120),
        Register('spr025', 8, 0x1128),
        Register('spr026', 8, 0x1130),
        Register('spr027', 8, 0x1138),
        Register('spr028', 8, 0x1140),
        Register('spr029', 8, 0x1148),
        Register('spr02a', 8, 0x1150),
        Register('spr02b', 8, 0x1158),
        Register('spr02c', 8, 0x1160),
        Register('spr02d', 8, 0x1168),
        Register('spr02e', 8, 0x1170),
        Register('spr02f', 8, 0x1178),
        Register('spr030', 8, 0x1180),
        Register('spr031', 8, 0x1188),
        Register('spr032', 8, 0x1190),
        Register('spr033', 8, 0x1198),
        Register('spr034', 8, 0x11a0),
        Register('spr035', 8, 0x11a8),
        Register('spr036', 8, 0x11b0),
        Register('spr037', 8, 0x11b8),
        Register('spr038', 8, 0x11c0),
        Register('spr039', 8, 0x11c8),
        Register('spr03a', 8, 0x11d0),
        Register('spr03b', 8, 0x11d8),
        Register('spr03c', 8, 0x11e0),
        Register('spr03d', 8, 0x11e8),
        Register('spr03e', 8, 0x11f0),
        Register('spr03f', 8, 0x11f8),
        Register('spr040', 8, 0x1200),
        Register('spr041', 8, 0x1208),
        Register('spr042', 8, 0x1210),
        Register('spr043', 8, 0x1218),
        Register('spr044', 8, 0x1220),
        Register('spr045', 8, 0x1228),
        Register('spr046', 8, 0x1230),
        Register('spr047', 8, 0x1238),
        Register('spr048', 8, 0x1240),
        Register('spr049', 8, 0x1248),
        Register('spr04a', 8, 0x1250),
        Register('spr04b', 8, 0x1258),
        Register('spr04c', 8, 0x1260),
        Register('spr04d', 8, 0x1268),
        Register('spr04e', 8, 0x1270),
        Register('spr04f', 8, 0x1278),
        Register('spr050', 8, 0x1280),
        Register('spr051', 8, 0x1288),
        Register('spr052', 8, 0x1290),
        Register('spr053', 8, 0x1298),
        Register('spr054', 8, 0x12a0),
        Register('spr055', 8, 0x12a8),
        Register('spr056', 8, 0x12b0),
        Register('spr057', 8, 0x12b8),
        Register('spr058', 8, 0x12c0),
        Register('spr059', 8, 0x12c8),
        Register('spr05a', 8, 0x12d0),
        Register('spr05b', 8, 0x12d8),
        Register('spr05c', 8, 0x12e0),
        Register('spr05d', 8, 0x12e8),
        Register('spr05e', 8, 0x12f0),
        Register('spr05f', 8, 0x12f8),
        Register('spr060', 8, 0x1300),
        Register('spr061', 8, 0x1308),
        Register('spr062', 8, 0x1310),
        Register('spr063', 8, 0x1318),
        Register('spr064', 8, 0x1320),
        Register('spr065', 8, 0x1328),
        Register('spr066', 8, 0x1330),
        Register('spr067', 8, 0x1338),
        Register('spr068', 8, 0x1340),
        Register('spr069', 8, 0x1348),
        Register('spr06a', 8, 0x1350),
        Register('spr06b', 8, 0x1358),
        Register('spr06c', 8, 0x1360),
        Register('spr06d', 8, 0x1368),
        Register('spr06e', 8, 0x1370),
        Register('spr06f', 8, 0x1378),
        Register('spr070', 8, 0x1380),
        Register('spr071', 8, 0x1388),
        Register('spr072', 8, 0x1390),
        Register('spr073', 8, 0x1398),
        Register('spr074', 8, 0x13a0),
        Register('spr075', 8, 0x13a8),
        Register('spr076', 8, 0x13b0),
        Register('spr077', 8, 0x13b8),
        Register('spr078', 8, 0x13c0),
        Register('spr079', 8, 0x13c8),
        Register('spr07a', 8, 0x13d0),
        Register('spr07b', 8, 0x13d8),
        Register('spr07c', 8, 0x13e0),
        Register('spr07d', 8, 0x13e8),
        Register('spr07e', 8, 0x13f0),
        Register('spr07f', 8, 0x13f8),
        Register('spr080', 8, 0x1400),
        Register('spr081', 8, 0x1408),
        Register('spr082', 8, 0x1410),
        Register('spr083', 8, 0x1418),
        Register('spr084', 8, 0x1420),
        Register('spr085', 8, 0x1428),
        Register('spr086', 8, 0x1430),
        Register('spr087', 8, 0x1438),
        Register('spr088', 8, 0x1440),
        Register('spr089', 8, 0x1448),
        Register('spr08a', 8, 0x1450),
        Register('spr08b', 8, 0x1458),
        Register('spr08c', 8, 0x1460),
        Register('spr08d', 8, 0x1468),
        Register('spr08e', 8, 0x1470),
        Register('spr08f', 8, 0x1478),
        Register('spr090', 8, 0x1480),
        Register('spr091', 8, 0x1488),
        Register('spr092', 8, 0x1490),
        Register('spr093', 8, 0x1498),
        Register('spr094', 8, 0x14a0),
        Register('spr095', 8, 0x14a8),
        Register('spr096', 8, 0x14b0),
        Register('spr097', 8, 0x14b8),
        Register('spr098', 8, 0x14c0),
        Register('spr099', 8, 0x14c8),
        Register('spr09a', 8, 0x14d0),
        Register('spr09b', 8, 0x14d8),
        Register('spr09c', 8, 0x14e0),
        Register('spr09d', 8, 0x14e8),
        Register('spr09e', 8, 0x14f0),
        Register('spr09f', 8, 0x14f8),
        Register('spr0a0', 8, 0x1500),
        Register('spr0a1', 8, 0x1508),
        Register('spr0a2', 8, 0x1510),
        Register('spr0a3', 8, 0x1518),
        Register('spr0a4', 8, 0x1520),
        Register('spr0a5', 8, 0x1528),
        Register('spr0a6', 8, 0x1530),
        Register('spr0a7', 8, 0x1538),
        Register('spr0a8', 8, 0x1540),
        Register('spr0a9', 8, 0x1548),
        Register('spr0aa', 8, 0x1550),
        Register('spr0ab', 8, 0x1558),
        Register('spr0ac', 8, 0x1560),
        Register('spr0ad', 8, 0x1568),
        Register('spr0ae', 8, 0x1570),
        Register('spr0af', 8, 0x1578),
        Register('spr0b0', 8, 0x1580),
        Register('spr0b1', 8, 0x1588),
        Register('spr0b2', 8, 0x1590),
        Register('spr0b3', 8, 0x1598),
        Register('spr0b4', 8, 0x15a0),
        Register('spr0b5', 8, 0x15a8),
        Register('spr0b6', 8, 0x15b0),
        Register('spr0b7', 8, 0x15b8),
        Register('spr0b8', 8, 0x15c0),
        Register('spr0b9', 8, 0x15c8),
        Register('spr0ba', 8, 0x15d0),
        Register('spr0bb', 8, 0x15d8),
        Register('spr0bc', 8, 0x15e0),
        Register('spr0bd', 8, 0x15e8),
        Register('spr0be', 8, 0x15f0),
        Register('spr0bf', 8, 0x15f8),
        Register('spr0c0', 8, 0x1600),
        Register('spr0c1', 8, 0x1608),
        Register('spr0c2', 8, 0x1610),
        Register('spr0c3', 8, 0x1618),
        Register('spr0c4', 8, 0x1620),
        Register('spr0c5', 8, 0x1628),
        Register('spr0c6', 8, 0x1630),
        Register('spr0c7', 8, 0x1638),
        Register('spr0c8', 8, 0x1640),
        Register('spr0c9', 8, 0x1648),
        Register('spr0ca', 8, 0x1650),
        Register('spr0cb', 8, 0x1658),
        Register('spr0cc', 8, 0x1660),
        Register('spr0cd', 8, 0x1668),
        Register('spr0ce', 8, 0x1670),
        Register('spr0cf', 8, 0x1678),
        Register('spr0d0', 8, 0x1680),
        Register('spr0d1', 8, 0x1688),
        Register('spr0d2', 8, 0x1690),
        Register('spr0d3', 8, 0x1698),
        Register('spr0d4', 8, 0x16a0),
        Register('spr0d5', 8, 0x16a8),
        Register('spr0d6', 8, 0x16b0),
        Register('spr0d7', 8, 0x16b8),
        Register('spr0d8', 8, 0x16c0),
        Register('spr0d9', 8, 0x16c8),
        Register('spr0da', 8, 0x16d0),
        Register('spr0db', 8, 0x16d8),
        Register('spr0dc', 8, 0x16e0),
        Register('spr0dd', 8, 0x16e8),
        Register('spr0de', 8, 0x16f0),
        Register('spr0df', 8, 0x16f8),
        Register('spr0e0', 8, 0x1700),
        Register('spr0e1', 8, 0x1708),
        Register('spr0e2', 8, 0x1710),
        Register('spr0e3', 8, 0x1718),
        Register('spr0e4', 8, 0x1720),
        Register('spr0e5', 8, 0x1728),
        Register('spr0e6', 8, 0x1730),
        Register('spr0e7', 8, 0x1738),
        Register('spr0e8', 8, 0x1740),
        Register('spr0e9', 8, 0x1748),
        Register('spr0ea', 8, 0x1750),
        Register('spr0eb', 8, 0x1758),
        Register('spr0ec', 8, 0x1760),
        Register('spr0ed', 8, 0x1768),
        Register('spr0ee', 8, 0x1770),
        Register('spr0ef', 8, 0x1778),
        Register('spr0f0', 8, 0x1780),
        Register('spr0f1', 8, 0x1788),
        Register('spr0f2', 8, 0x1790),
        Register('spr0f3', 8, 0x1798),
        Register('spr0f4', 8, 0x17a0),
        Register('spr0f5', 8, 0x17a8),
        Register('spr0f6', 8, 0x17b0),
        Register('spr0f7', 8, 0x17b8),
        Register('spr0f8', 8, 0x17c0),
        Register('spr0f9', 8, 0x17c8),
        Register('spr0fa', 8, 0x17d0),
        Register('spr0fb', 8, 0x17d8),
        Register('spr0fc', 8, 0x17e0),
        Register('spr0fd', 8, 0x17e8),
        Register('spr0fe', 8, 0x17f0),
        Register('spr0ff', 8, 0x17f8),
        Register('spr100', 8, 0x1800),
        Register('spr101', 8, 0x1808),
        Register('spr102', 8, 0x1810),
        Register('spr103', 8, 0x1818),
        Register('spr104', 8, 0x1820),
        Register('spr105', 8, 0x1828),
        Register('spr106', 8, 0x1830),
        Register('spr107', 8, 0x1838),
        Register('spr108', 8, 0x1840),
        Register('spr109', 8, 0x1848),
        Register('spr10a', 8, 0x1850),
        Register('spr10b', 8, 0x1858),
        Register('tblr', 8, 0x1860),
        Register('tbur', 8, 0x1868),
        Register('spr10e', 8, 0x1870),
        Register('spr10f', 8, 0x1878),
        Register('spr110', 8, 0x1880),
        Register('spr111', 8, 0x1888),
        Register('spr112', 8, 0x1890),
        Register('spr113', 8, 0x1898),
        Register('spr114', 8, 0x18a0),
        Register('spr115', 8, 0x18a8),
        Register('spr116', 8, 0x18b0),
        Register('spr117', 8, 0x18b8),
        Register('spr118', 8, 0x18c0),
        Register('spr119', 8, 0x18c8),
        Register('spr11a', 8, 0x18d0),
        Register('spr11b', 8, 0x18d8),
        Register('tblw', 8, 0x18e0),
        Register('tbuw', 8, 0x18e8),
        Register('spr11e', 8, 0x18f0),
        Register('spr11f', 8, 0x18f8),
        Register('spr120', 8, 0x1900),
        Register('spr121', 8, 0x1908),
        Register('spr122', 8, 0x1910),
        Register('spr123', 8, 0x1918),
        Register('spr124', 8, 0x1920),
        Register('spr125', 8, 0x1928),
        Register('spr126', 8, 0x1930),
        Register('spr127', 8, 0x1938),
        Register('spr128', 8, 0x1940),
        Register('spr129', 8, 0x1948),
        Register('spr12a', 8, 0x1950),
        Register('spr12b', 8, 0x1958),
        Register('spr12c', 8, 0x1960),
        Register('spr12d', 8, 0x1968),
        Register('spr12e', 8, 0x1970),
        Register('spr12f', 8, 0x1978),
        Register('spr130', 8, 0x1980),
        Register('spr131', 8, 0x1988),
        Register('spr132', 8, 0x1990),
        Register('spr133', 8, 0x1998),
        Register('spr134', 8, 0x19a0),
        Register('spr135', 8, 0x19a8),
        Register('spr136', 8, 0x19b0),
        Register('spr137', 8, 0x19b8),
        Register('spr138', 8, 0x19c0),
        Register('spr139', 8, 0x19c8),
        Register('spr13a', 8, 0x19d0),
        Register('spr13b', 8, 0x19d8),
        Register('spr13c', 8, 0x19e0),
        Register('spr13d', 8, 0x19e8),
        Register('spr13e', 8, 0x19f0),
        Register('spr13f', 8, 0x19f8),
        Register('spr140', 8, 0x1a00),
        Register('spr141', 8, 0x1a08),
        Register('spr142', 8, 0x1a10),
        Register('spr143', 8, 0x1a18),
        Register('spr144', 8, 0x1a20),
        Register('spr145', 8, 0x1a28),
        Register('spr146', 8, 0x1a30),
        Register('spr147', 8, 0x1a38),
        Register('spr148', 8, 0x1a40),
        Register('spr149', 8, 0x1a48),
        Register('spr14a', 8, 0x1a50),
        Register('spr14b', 8, 0x1a58),
        Register('spr14c', 8, 0x1a60),
        Register('spr14d', 8, 0x1a68),
        Register('spr14e', 8, 0x1a70),
        Register('spr14f', 8, 0x1a78),
        Register('spr150', 8, 0x1a80),
        Register('spr151', 8, 0x1a88),
        Register('spr152', 8, 0x1a90),
        Register('spr153', 8, 0x1a98),
        Register('spr154', 8, 0x1aa0),
        Register('spr155', 8, 0x1aa8),
        Register('spr156', 8, 0x1ab0),
        Register('spr157', 8, 0x1ab8),
        Register('spr158', 8, 0x1ac0),
        Register('spr159', 8, 0x1ac8),
        Register('spr15a', 8, 0x1ad0),
        Register('spr15b', 8, 0x1ad8),
        Register('spr15c', 8, 0x1ae0),
        Register('spr15d', 8, 0x1ae8),
        Register('spr15e', 8, 0x1af0),
        Register('spr15f', 8, 0x1af8),
        Register('spr160', 8, 0x1b00),
        Register('spr161', 8, 0x1b08),
        Register('spr162', 8, 0x1b10),
        Register('spr163', 8, 0x1b18),
        Register('spr164', 8, 0x1b20),
        Register('spr165', 8, 0x1b28),
        Register('spr166', 8, 0x1b30),
        Register('spr167', 8, 0x1b38),
        Register('spr168', 8, 0x1b40),
        Register('spr169', 8, 0x1b48),
        Register('spr16a', 8, 0x1b50),
        Register('spr16b', 8, 0x1b58),
        Register('spr16c', 8, 0x1b60),
        Register('spr16d', 8, 0x1b68),
        Register('spr16e', 8, 0x1b70),
        Register('spr16f', 8, 0x1b78),
        Register('spr170', 8, 0x1b80),
        Register('spr171', 8, 0x1b88),
        Register('spr172', 8, 0x1b90),
        Register('spr173', 8, 0x1b98),
        Register('spr174', 8, 0x1ba0),
        Register('spr175', 8, 0x1ba8),
        Register('spr176', 8, 0x1bb0),
        Register('spr177', 8, 0x1bb8),
        Register('spr178', 8, 0x1bc0),
        Register('spr179', 8, 0x1bc8),
        Register('spr17a', 8, 0x1bd0),
        Register('spr17b', 8, 0x1bd8),
        Register('spr17c', 8, 0x1be0),
        Register('spr17d', 8, 0x1be8),
        Register('spr17e', 8, 0x1bf0),
        Register('spr17f', 8, 0x1bf8),
        Register('spr180', 8, 0x1c00),
        Register('spr181', 8, 0x1c08),
        Register('spr182', 8, 0x1c10),
        Register('spr183', 8, 0x1c18),
        Register('spr184', 8, 0x1c20),
        Register('spr185', 8, 0x1c28),
        Register('spr186', 8, 0x1c30),
        Register('spr187', 8, 0x1c38),
        Register('spr188', 8, 0x1c40),
        Register('spr189', 8, 0x1c48),
        Register('spr18a', 8, 0x1c50),
        Register('spr18b', 8, 0x1c58),
        Register('spr18c', 8, 0x1c60),
        Register('spr18d', 8, 0x1c68),
        Register('spr18e', 8, 0x1c70),
        Register('spr18f', 8, 0x1c78),
        Register('spr190', 8, 0x1c80),
        Register('spr191', 8, 0x1c88),
        Register('spr192', 8, 0x1c90),
        Register('spr193', 8, 0x1c98),
        Register('spr194', 8, 0x1ca0),
        Register('spr195', 8, 0x1ca8),
        Register('spr196', 8, 0x1cb0),
        Register('spr197', 8, 0x1cb8),
        Register('spr198', 8, 0x1cc0),
        Register('spr199', 8, 0x1cc8),
        Register('spr19a', 8, 0x1cd0),
        Register('spr19b', 8, 0x1cd8),
        Register('spr19c', 8, 0x1ce0),
        Register('spr19d', 8, 0x1ce8),
        Register('spr19e', 8, 0x1cf0),
        Register('spr19f', 8, 0x1cf8),
        Register('spr1a0', 8, 0x1d00),
        Register('spr1a1', 8, 0x1d08),
        Register('spr1a2', 8, 0x1d10),
        Register('spr1a3', 8, 0x1d18),
        Register('spr1a4', 8, 0x1d20),
        Register('spr1a5', 8, 0x1d28),
        Register('spr1a6', 8, 0x1d30),
        Register('spr1a7', 8, 0x1d38),
        Register('spr1a8', 8, 0x1d40),
        Register('spr1a9', 8, 0x1d48),
        Register('spr1aa', 8, 0x1d50),
        Register('spr1ab', 8, 0x1d58),
        Register('spr1ac', 8, 0x1d60),
        Register('spr1ad', 8, 0x1d68),
        Register('spr1ae', 8, 0x1d70),
        Register('spr1af', 8, 0x1d78),
        Register('spr1b0', 8, 0x1d80),
        Register('spr1b1', 8, 0x1d88),
        Register('spr1b2', 8, 0x1d90),
        Register('spr1b3', 8, 0x1d98),
        Register('spr1b4', 8, 0x1da0),
        Register('spr1b5', 8, 0x1da8),
        Register('spr1b6', 8, 0x1db0),
        Register('spr1b7', 8, 0x1db8),
        Register('spr1b8', 8, 0x1dc0),
        Register('spr1b9', 8, 0x1dc8),
        Register('spr1ba', 8, 0x1dd0),
        Register('spr1bb', 8, 0x1dd8),
        Register('spr1bc', 8, 0x1de0),
        Register('spr1bd', 8, 0x1de8),
        Register('spr1be', 8, 0x1df0),
        Register('spr1bf', 8, 0x1df8),
        Register('spr1c0', 8, 0x1e00),
        Register('spr1c1', 8, 0x1e08),
        Register('spr1c2', 8, 0x1e10),
        Register('spr1c3', 8, 0x1e18),
        Register('spr1c4', 8, 0x1e20),
        Register('spr1c5', 8, 0x1e28),
        Register('spr1c6', 8, 0x1e30),
        Register('spr1c7', 8, 0x1e38),
        Register('spr1c8', 8, 0x1e40),
        Register('spr1c9', 8, 0x1e48),
        Register('spr1ca', 8, 0x1e50),
        Register('spr1cb', 8, 0x1e58),
        Register('spr1cc', 8, 0x1e60),
        Register('spr1cd', 8, 0x1e68),
        Register('spr1ce', 8, 0x1e70),
        Register('spr1cf', 8, 0x1e78),
        Register('spr1d0', 8, 0x1e80),
        Register('spr1d1', 8, 0x1e88),
        Register('spr1d2', 8, 0x1e90),
        Register('spr1d3', 8, 0x1e98),
        Register('spr1d4', 8, 0x1ea0),
        Register('spr1d5', 8, 0x1ea8),
        Register('spr1d6', 8, 0x1eb0),
        Register('spr1d7', 8, 0x1eb8),
        Register('spr1d8', 8, 0x1ec0),
        Register('spr1d9', 8, 0x1ec8),
        Register('spr1da', 8, 0x1ed0),
        Register('spr1db', 8, 0x1ed8),
        Register('spr1dc', 8, 0x1ee0),
        Register('spr1dd', 8, 0x1ee8),
        Register('spr1de', 8, 0x1ef0),
        Register('spr1df', 8, 0x1ef8),
        Register('spr1e0', 8, 0x1f00),
        Register('spr1e1', 8, 0x1f08),
        Register('spr1e2', 8, 0x1f10),
        Register('spr1e3', 8, 0x1f18),
        Register('spr1e4', 8, 0x1f20),
        Register('spr1e5', 8, 0x1f28),
        Register('spr1e6', 8, 0x1f30),
        Register('spr1e7', 8, 0x1f38),
        Register('spr1e8', 8, 0x1f40),
        Register('spr1e9', 8, 0x1f48),
        Register('spr1ea', 8, 0x1f50),
        Register('spr1eb', 8, 0x1f58),
        Register('spr1ec', 8, 0x1f60),
        Register('spr1ed', 8, 0x1f68),
        Register('spr1ee', 8, 0x1f70),
        Register('spr1ef', 8, 0x1f78),
        Register('spr1f0', 8, 0x1f80),
        Register('spr1f1', 8, 0x1f88),
        Register('spr1f2', 8, 0x1f90),
        Register('spr1f3', 8, 0x1f98),
        Register('spr1f4', 8, 0x1fa0),
        Register('spr1f5', 8, 0x1fa8),
        Register('spr1f6', 8, 0x1fb0),
        Register('spr1f7', 8, 0x1fb8),
        Register('spr1f8', 8, 0x1fc0),
        Register('spr1f9', 8, 0x1fc8),
        Register('spr1fa', 8, 0x1fd0),
        Register('spr1fb', 8, 0x1fd8),
        Register('spr1fc', 8, 0x1fe0),
        Register('spr1fd', 8, 0x1fe8),
        Register('spr1fe', 8, 0x1ff0),
        Register('spr1ff', 8, 0x1ff8),
        Register('spr200', 8, 0x2000),
        Register('spr201', 8, 0x2008),
        Register('spr202', 8, 0x2010),
        Register('spr203', 8, 0x2018),
        Register('spr204', 8, 0x2020),
        Register('spr205', 8, 0x2028),
        Register('spr206', 8, 0x2030),
        Register('spr207', 8, 0x2038),
        Register('spr208', 8, 0x2040),
        Register('spr209', 8, 0x2048),
        Register('spr20a', 8, 0x2050),
        Register('spr20b', 8, 0x2058),
        Register('spr20c', 8, 0x2060),
        Register('spr20d', 8, 0x2068),
        Register('spr20e', 8, 0x2070),
        Register('spr20f', 8, 0x2078),
        Register('spr210', 8, 0x2080),
        Register('spr211', 8, 0x2088),
        Register('spr212', 8, 0x2090),
        Register('spr213', 8, 0x2098),
        Register('spr214', 8, 0x20a0),
        Register('spr215', 8, 0x20a8),
        Register('spr216', 8, 0x20b0),
        Register('spr217', 8, 0x20b8),
        Register('spr218', 8, 0x20c0),
        Register('spr219', 8, 0x20c8),
        Register('spr21a', 8, 0x20d0),
        Register('spr21b', 8, 0x20d8),
        Register('spr21c', 8, 0x20e0),
        Register('spr21d', 8, 0x20e8),
        Register('spr21e', 8, 0x20f0),
        Register('spr21f', 8, 0x20f8),
        Register('spr220', 8, 0x2100),
        Register('spr221', 8, 0x2108),
        Register('spr222', 8, 0x2110),
        Register('spr223', 8, 0x2118),
        Register('spr224', 8, 0x2120),
        Register('spr225', 8, 0x2128),
        Register('spr226', 8, 0x2130),
        Register('spr227', 8, 0x2138),
        Register('spr228', 8, 0x2140),
        Register('spr229', 8, 0x2148),
        Register('spr22a', 8, 0x2150),
        Register('spr22b', 8, 0x2158),
        Register('spr22c', 8, 0x2160),
        Register('spr22d', 8, 0x2168),
        Register('spr22e', 8, 0x2170),
        Register('spr22f', 8, 0x2178),
        Register('spr230', 8, 0x2180),
        Register('spr231', 8, 0x2188),
        Register('spr232', 8, 0x2190),
        Register('spr233', 8, 0x2198),
        Register('spr234', 8, 0x21a0),
        Register('spr235', 8, 0x21a8),
        Register('spr236', 8, 0x21b0),
        Register('spr237', 8, 0x21b8),
        Register('spr238', 8, 0x21c0),
        Register('spr239', 8, 0x21c8),
        Register('spr23a', 8, 0x21d0),
        Register('spr23b', 8, 0x21d8),
        Register('spr23c', 8, 0x21e0),
        Register('spr23d', 8, 0x21e8),
        Register('spr23e', 8, 0x21f0),
        Register('spr23f', 8, 0x21f8),
        Register('spr240', 8, 0x2200),
        Register('spr241', 8, 0x2208),
        Register('spr242', 8, 0x2210),
        Register('spr243', 8, 0x2218),
        Register('spr244', 8, 0x2220),
        Register('spr245', 8, 0x2228),
        Register('spr246', 8, 0x2230),
        Register('spr247', 8, 0x2238),
        Register('spr248', 8, 0x2240),
        Register('spr249', 8, 0x2248),
        Register('spr24a', 8, 0x2250),
        Register('spr24b', 8, 0x2258),
        Register('spr24c', 8, 0x2260),
        Register('spr24d', 8, 0x2268),
        Register('spr24e', 8, 0x2270),
        Register('spr24f', 8, 0x2278),
        Register('spr250', 8, 0x2280),
        Register('spr251', 8, 0x2288),
        Register('spr252', 8, 0x2290),
        Register('spr253', 8, 0x2298),
        Register('spr254', 8, 0x22a0),
        Register('spr255', 8, 0x22a8),
        Register('spr256', 8, 0x22b0),
        Register('spr257', 8, 0x22b8),
        Register('spr258', 8, 0x22c0),
        Register('spr259', 8, 0x22c8),
        Register('spr25a', 8, 0x22d0),
        Register('spr25b', 8, 0x22d8),
        Register('spr25c', 8, 0x22e0),
        Register('spr25d', 8, 0x22e8),
        Register('spr25e', 8, 0x22f0),
        Register('spr25f', 8, 0x22f8),
        Register('spr260', 8, 0x2300),
        Register('spr261', 8, 0x2308),
        Register('spr262', 8, 0x2310),
        Register('spr263', 8, 0x2318),
        Register('spr264', 8, 0x2320),
        Register('spr265', 8, 0x2328),
        Register('spr266', 8, 0x2330),
        Register('spr267', 8, 0x2338),
        Register('spr268', 8, 0x2340),
        Register('spr269', 8, 0x2348),
        Register('spr26a', 8, 0x2350),
        Register('spr26b', 8, 0x2358),
        Register('spr26c', 8, 0x2360),
        Register('spr26d', 8, 0x2368),
        Register('spr26e', 8, 0x2370),
        Register('spr26f', 8, 0x2378),
        Register('spr270', 8, 0x2380),
        Register('spr271', 8, 0x2388),
        Register('spr272', 8, 0x2390),
        Register('spr273', 8, 0x2398),
        Register('spr274', 8, 0x23a0),
        Register('spr275', 8, 0x23a8),
        Register('spr276', 8, 0x23b0),
        Register('spr277', 8, 0x23b8),
        Register('spr278', 8, 0x23c0),
        Register('spr279', 8, 0x23c8),
        Register('spr27a', 8, 0x23d0),
        Register('spr27b', 8, 0x23d8),
        Register('spr27c', 8, 0x23e0),
        Register('spr27d', 8, 0x23e8),
        Register('spr27e', 8, 0x23f0),
        Register('spr27f', 8, 0x23f8),
        Register('spr280', 8, 0x2400),
        Register('spr281', 8, 0x2408),
        Register('spr282', 8, 0x2410),
        Register('spr283', 8, 0x2418),
        Register('spr284', 8, 0x2420),
        Register('spr285', 8, 0x2428),
        Register('spr286', 8, 0x2430),
        Register('spr287', 8, 0x2438),
        Register('spr288', 8, 0x2440),
        Register('spr289', 8, 0x2448),
        Register('spr28a', 8, 0x2450),
        Register('spr28b', 8, 0x2458),
        Register('spr28c', 8, 0x2460),
        Register('spr28d', 8, 0x2468),
        Register('spr28e', 8, 0x2470),
        Register('spr28f', 8, 0x2478),
        Register('spr290', 8, 0x2480),
        Register('spr291', 8, 0x2488),
        Register('spr292', 8, 0x2490),
        Register('spr293', 8, 0x2498),
        Register('spr294', 8, 0x24a0),
        Register('spr295', 8, 0x24a8),
        Register('spr296', 8, 0x24b0),
        Register('spr297', 8, 0x24b8),
        Register('spr298', 8, 0x24c0),
        Register('spr299', 8, 0x24c8),
        Register('spr29a', 8, 0x24d0),
        Register('spr29b', 8, 0x24d8),
        Register('spr29c', 8, 0x24e0),
        Register('spr29d', 8, 0x24e8),
        Register('spr29e', 8, 0x24f0),
        Register('spr29f', 8, 0x24f8),
        Register('spr2a0', 8, 0x2500),
        Register('spr2a1', 8, 0x2508),
        Register('spr2a2', 8, 0x2510),
        Register('spr2a3', 8, 0x2518),
        Register('spr2a4', 8, 0x2520),
        Register('spr2a5', 8, 0x2528),
        Register('spr2a6', 8, 0x2530),
        Register('spr2a7', 8, 0x2538),
        Register('spr2a8', 8, 0x2540),
        Register('spr2a9', 8, 0x2548),
        Register('spr2aa', 8, 0x2550),
        Register('spr2ab', 8, 0x2558),
        Register('spr2ac', 8, 0x2560),
        Register('spr2ad', 8, 0x2568),
        Register('spr2ae', 8, 0x2570),
        Register('spr2af', 8, 0x2578),
        Register('spr2b0', 8, 0x2580),
        Register('spr2b1', 8, 0x2588),
        Register('spr2b2', 8, 0x2590),
        Register('spr2b3', 8, 0x2598),
        Register('spr2b4', 8, 0x25a0),
        Register('spr2b5', 8, 0x25a8),
        Register('spr2b6', 8, 0x25b0),
        Register('spr2b7', 8, 0x25b8),
        Register('spr2b8', 8, 0x25c0),
        Register('spr2b9', 8, 0x25c8),
        Register('spr2ba', 8, 0x25d0),
        Register('spr2bb', 8, 0x25d8),
        Register('spr2bc', 8, 0x25e0),
        Register('spr2bd', 8, 0x25e8),
        Register('spr2be', 8, 0x25f0),
        Register('spr2bf', 8, 0x25f8),
        Register('spr2c0', 8, 0x2600),
        Register('spr2c1', 8, 0x2608),
        Register('spr2c2', 8, 0x2610),
        Register('spr2c3', 8, 0x2618),
        Register('spr2c4', 8, 0x2620),
        Register('spr2c5', 8, 0x2628),
        Register('spr2c6', 8, 0x2630),
        Register('spr2c7', 8, 0x2638),
        Register('spr2c8', 8, 0x2640),
        Register('spr2c9', 8, 0x2648),
        Register('spr2ca', 8, 0x2650),
        Register('spr2cb', 8, 0x2658),
        Register('spr2cc', 8, 0x2660),
        Register('spr2cd', 8, 0x2668),
        Register('spr2ce', 8, 0x2670),
        Register('spr2cf', 8, 0x2678),
        Register('spr2d0', 8, 0x2680),
        Register('spr2d1', 8, 0x2688),
        Register('spr2d2', 8, 0x2690),
        Register('spr2d3', 8, 0x2698),
        Register('spr2d4', 8, 0x26a0),
        Register('spr2d5', 8, 0x26a8),
        Register('spr2d6', 8, 0x26b0),
        Register('spr2d7', 8, 0x26b8),
        Register('spr2d8', 8, 0x26c0),
        Register('spr2d9', 8, 0x26c8),
        Register('spr2da', 8, 0x26d0),
        Register('spr2db', 8, 0x26d8),
        Register('spr2dc', 8, 0x26e0),
        Register('spr2dd', 8, 0x26e8),
        Register('spr2de', 8, 0x26f0),
        Register('spr2df', 8, 0x26f8),
        Register('spr2e0', 8, 0x2700),
        Register('spr2e1', 8, 0x2708),
        Register('spr2e2', 8, 0x2710),
        Register('spr2e3', 8, 0x2718),
        Register('spr2e4', 8, 0x2720),
        Register('spr2e5', 8, 0x2728),
        Register('spr2e6', 8, 0x2730),
        Register('spr2e7', 8, 0x2738),
        Register('spr2e8', 8, 0x2740),
        Register('spr2e9', 8, 0x2748),
        Register('spr2ea', 8, 0x2750),
        Register('spr2eb', 8, 0x2758),
        Register('spr2ec', 8, 0x2760),
        Register('spr2ed', 8, 0x2768),
        Register('spr2ee', 8, 0x2770),
        Register('spr2ef', 8, 0x2778),
        Register('spr2f0', 8, 0x2780),
        Register('spr2f1', 8, 0x2788),
        Register('spr2f2', 8, 0x2790),
        Register('spr2f3', 8, 0x2798),
        Register('spr2f4', 8, 0x27a0),
        Register('spr2f5', 8, 0x27a8),
        Register('spr2f6', 8, 0x27b0),
        Register('spr2f7', 8, 0x27b8),
        Register('spr2f8', 8, 0x27c0),
        Register('spr2f9', 8, 0x27c8),
        Register('spr2fa', 8, 0x27d0),
        Register('spr2fb', 8, 0x27d8),
        Register('spr2fc', 8, 0x27e0),
        Register('spr2fd', 8, 0x27e8),
        Register('spr2fe', 8, 0x27f0),
        Register('spr2ff', 8, 0x27f8),
        Register('spr300', 8, 0x2800),
        Register('spr301', 8, 0x2808),
        Register('spr302', 8, 0x2810),
        Register('spr303', 8, 0x2818),
        Register('spr304', 8, 0x2820),
        Register('spr305', 8, 0x2828),
        Register('spr306', 8, 0x2830),
        Register('spr307', 8, 0x2838),
        Register('spr308', 8, 0x2840),
        Register('spr309', 8, 0x2848),
        Register('spr30a', 8, 0x2850),
        Register('spr30b', 8, 0x2858),
        Register('spr30c', 8, 0x2860),
        Register('spr30d', 8, 0x2868),
        Register('spr30e', 8, 0x2870),
        Register('spr30f', 8, 0x2878),
        Register('spr310', 8, 0x2880),
        Register('spr311', 8, 0x2888),
        Register('spr312', 8, 0x2890),
        Register('spr313', 8, 0x2898),
        Register('spr314', 8, 0x28a0),
        Register('spr315', 8, 0x28a8),
        Register('spr316', 8, 0x28b0),
        Register('spr317', 8, 0x28b8),
        Register('spr318', 8, 0x28c0),
        Register('spr319', 8, 0x28c8),
        Register('spr31a', 8, 0x28d0),
        Register('spr31b', 8, 0x28d8),
        Register('spr31c', 8, 0x28e0),
        Register('spr31d', 8, 0x28e8),
        Register('spr31e', 8, 0x28f0),
        Register('spr31f', 8, 0x28f8),
        Register('spr320', 8, 0x2900),
        Register('spr321', 8, 0x2908),
        Register('spr322', 8, 0x2910),
        Register('spr323', 8, 0x2918),
        Register('spr324', 8, 0x2920),
        Register('spr325', 8, 0x2928),
        Register('spr326', 8, 0x2930),
        Register('spr327', 8, 0x2938),
        Register('spr328', 8, 0x2940),
        Register('spr329', 8, 0x2948),
        Register('spr32a', 8, 0x2950),
        Register('spr32b', 8, 0x2958),
        Register('spr32c', 8, 0x2960),
        Register('spr32d', 8, 0x2968),
        Register('spr32e', 8, 0x2970),
        Register('tar', 8, 0x2978),
        Register('spr330', 8, 0x2980),
        Register('spr331', 8, 0x2988),
        Register('spr332', 8, 0x2990),
        Register('spr333', 8, 0x2998),
        Register('spr334', 8, 0x29a0),
        Register('spr335', 8, 0x29a8),
        Register('spr336', 8, 0x29b0),
        Register('spr337', 8, 0x29b8),
        Register('spr338', 8, 0x29c0),
        Register('spr339', 8, 0x29c8),
        Register('spr33a', 8, 0x29d0),
        Register('spr33b', 8, 0x29d8),
        Register('spr33c', 8, 0x29e0),
        Register('spr33d', 8, 0x29e8),
        Register('spr33e', 8, 0x29f0),
        Register('spr33f', 8, 0x29f8),
        Register('spr340', 8, 0x2a00),
        Register('spr341', 8, 0x2a08),
        Register('spr342', 8, 0x2a10),
        Register('spr343', 8, 0x2a18),
        Register('spr344', 8, 0x2a20),
        Register('spr345', 8, 0x2a28),
        Register('spr346', 8, 0x2a30),
        Register('spr347', 8, 0x2a38),
        Register('spr348', 8, 0x2a40),
        Register('spr349', 8, 0x2a48),
        Register('spr34a', 8, 0x2a50),
        Register('spr34b', 8, 0x2a58),
        Register('spr34c', 8, 0x2a60),
        Register('spr34d', 8, 0x2a68),
        Register('spr34e', 8, 0x2a70),
        Register('spr34f', 8, 0x2a78),
        Register('spr350', 8, 0x2a80),
        Register('spr351', 8, 0x2a88),
        Register('spr352', 8, 0x2a90),
        Register('spr353', 8, 0x2a98),
        Register('spr354', 8, 0x2aa0),
        Register('spr355', 8, 0x2aa8),
        Register('spr356', 8, 0x2ab0),
        Register('spr357', 8, 0x2ab8),
        Register('spr358', 8, 0x2ac0),
        Register('spr359', 8, 0x2ac8),
        Register('spr35a', 8, 0x2ad0),
        Register('spr35b', 8, 0x2ad8),
        Register('spr35c', 8, 0x2ae0),
        Register('spr35d', 8, 0x2ae8),
        Register('spr35e', 8, 0x2af0),
        Register('spr35f', 8, 0x2af8),
        Register('spr360', 8, 0x2b00),
        Register('spr361', 8, 0x2b08),
        Register('spr362', 8, 0x2b10),
        Register('spr363', 8, 0x2b18),
        Register('spr364', 8, 0x2b20),
        Register('spr365', 8, 0x2b28),
        Register('spr366', 8, 0x2b30),
        Register('spr367', 8, 0x2b38),
        Register('spr368', 8, 0x2b40),
        Register('spr369', 8, 0x2b48),
        Register('spr36a', 8, 0x2b50),
        Register('spr36b', 8, 0x2b58),
        Register('spr36c', 8, 0x2b60),
        Register('spr36d', 8, 0x2b68),
        Register('spr36e', 8, 0x2b70),
        Register('spr36f', 8, 0x2b78),
        Register('spr370', 8, 0x2b80),
        Register('spr371', 8, 0x2b88),
        Register('spr372', 8, 0x2b90),
        Register('spr373', 8, 0x2b98),
        Register('spr374', 8, 0x2ba0),
        Register('spr375', 8, 0x2ba8),
        Register('spr376', 8, 0x2bb0),
        Register('spr377', 8, 0x2bb8),
        Register('spr378', 8, 0x2bc0),
        Register('spr379', 8, 0x2bc8),
        Register('spr37a', 8, 0x2bd0),
        Register('spr37b', 8, 0x2bd8),
        Register('spr37c', 8, 0x2be0),
        Register('spr37d', 8, 0x2be8),
        Register('spr37e', 8, 0x2bf0),
        Register('spr37f', 8, 0x2bf8),
        Register('spr380', 8, 0x2c00),
        Register('spr381', 8, 0x2c08),
        Register('spr382', 8, 0x2c10),
        Register('spr383', 8, 0x2c18),
        Register('spr384', 8, 0x2c20),
        Register('spr385', 8, 0x2c28),
        Register('spr386', 8, 0x2c30),
        Register('spr387', 8, 0x2c38),
        Register('spr388', 8, 0x2c40),
        Register('spr389', 8, 0x2c48),
        Register('spr38a', 8, 0x2c50),
        Register('spr38b', 8, 0x2c58),
        Register('spr38c', 8, 0x2c60),
        Register('spr38d', 8, 0x2c68),
        Register('spr38e', 8, 0x2c70),
        Register('spr38f', 8, 0x2c78),
        Register('spr390', 8, 0x2c80),
        Register('spr391', 8, 0x2c88),
        Register('spr392', 8, 0x2c90),
        Register('spr393', 8, 0x2c98),
        Register('spr394', 8, 0x2ca0),
        Register('spr395', 8, 0x2ca8),
        Register('spr396', 8, 0x2cb0),
        Register('spr397', 8, 0x2cb8),
        Register('spr398', 8, 0x2cc0),
        Register('spr399', 8, 0x2cc8),
        Register('spr39a', 8, 0x2cd0),
        Register('spr39b', 8, 0x2cd8),
        Register('spr39c', 8, 0x2ce0),
        Register('spr39d', 8, 0x2ce8),
        Register('spr39e', 8, 0x2cf0),
        Register('spr39f', 8, 0x2cf8),
        Register('spr3a0', 8, 0x2d00),
        Register('spr3a1', 8, 0x2d08),
        Register('spr3a2', 8, 0x2d10),
        Register('spr3a3', 8, 0x2d18),
        Register('spr3a4', 8, 0x2d20),
        Register('spr3a5', 8, 0x2d28),
        Register('spr3a6', 8, 0x2d30),
        Register('spr3a7', 8, 0x2d38),
        Register('spr3a8', 8, 0x2d40),
        Register('spr3a9', 8, 0x2d48),
        Register('spr3aa', 8, 0x2d50),
        Register('spr3ab', 8, 0x2d58),
        Register('spr3ac', 8, 0x2d60),
        Register('spr3ad', 8, 0x2d68),
        Register('spr3ae', 8, 0x2d70),
        Register('spr3af', 8, 0x2d78),
        Register('spr3b0', 8, 0x2d80),
        Register('spr3b1', 8, 0x2d88),
        Register('spr3b2', 8, 0x2d90),
        Register('spr3b3', 8, 0x2d98),
        Register('spr3b4', 8, 0x2da0),
        Register('spr3b5', 8, 0x2da8),
        Register('spr3b6', 8, 0x2db0),
        Register('spr3b7', 8, 0x2db8),
        Register('spr3b8', 8, 0x2dc0),
        Register('spr3b9', 8, 0x2dc8),
        Register('spr3ba', 8, 0x2dd0),
        Register('spr3bb', 8, 0x2dd8),
        Register('spr3bc', 8, 0x2de0),
        Register('spr3bd', 8, 0x2de8),
        Register('spr3be', 8, 0x2df0),
        Register('spr3bf', 8, 0x2df8),
        Register('spr3c0', 8, 0x2e00),
        Register('spr3c1', 8, 0x2e08),
        Register('spr3c2', 8, 0x2e10),
        Register('spr3c3', 8, 0x2e18),
        Register('spr3c4', 8, 0x2e20),
        Register('spr3c5', 8, 0x2e28),
        Register('spr3c6', 8, 0x2e30),
        Register('spr3c7', 8, 0x2e38),
        Register('spr3c8', 8, 0x2e40),
        Register('spr3c9', 8, 0x2e48),
        Register('spr3ca', 8, 0x2e50),
        Register('spr3cb', 8, 0x2e58),
        Register('spr3cc', 8, 0x2e60),
        Register('spr3cd', 8, 0x2e68),
        Register('spr3ce', 8, 0x2e70),
        Register('spr3cf', 8, 0x2e78),
        Register('spr3d0', 8, 0x2e80),
        Register('spr3d1', 8, 0x2e88),
        Register('spr3d2', 8, 0x2e90),
        Register('spr3d3', 8, 0x2e98),
        Register('spr3d4', 8, 0x2ea0),
        Register('spr3d5', 8, 0x2ea8),
        Register('spr3d6', 8, 0x2eb0),
        Register('spr3d7', 8, 0x2eb8),
        Register('spr3d8', 8, 0x2ec0),
        Register('spr3d9', 8, 0x2ec8),
        Register('spr3da', 8, 0x2ed0),
        Register('spr3db', 8, 0x2ed8),
        Register('spr3dc', 8, 0x2ee0),
        Register('spr3dd', 8, 0x2ee8),
        Register('spr3de', 8, 0x2ef0),
        Register('spr3df', 8, 0x2ef8),
        Register('spr3e0', 8, 0x2f00),
        Register('spr3e1', 8, 0x2f08),
        Register('spr3e2', 8, 0x2f10),
        Register('spr3e3', 8, 0x2f18),
        Register('spr3e4', 8, 0x2f20),
        Register('spr3e5', 8, 0x2f28),
        Register('spr3e6', 8, 0x2f30),
        Register('spr3e7', 8, 0x2f38),
        Register('spr3e8', 8, 0x2f40),
        Register('spr3e9', 8, 0x2f48),
        Register('spr3ea', 8, 0x2f50),
        Register('spr3eb', 8, 0x2f58),
        Register('spr3ec', 8, 0x2f60),
        Register('spr3ed', 8, 0x2f68),
        Register('spr3ee', 8, 0x2f70),
        Register('spr3ef', 8, 0x2f78),
        Register('spr3f0', 8, 0x2f80),
        Register('spr3f1', 8, 0x2f88),
        Register('spr3f2', 8, 0x2f90),
        Register('spr3f3', 8, 0x2f98),
        Register('spr3f4', 8, 0x2fa0),
        Register('spr3f5', 8, 0x2fa8),
        Register('spr3f6', 8, 0x2fb0),
        Register('spr3f7', 8, 0x2fb8),
        Register('spr3f8', 8, 0x2fc0),
        Register('spr3f9', 8, 0x2fc8),
        Register('spr3fa', 8, 0x2fd0),
        Register('spr3fb', 8, 0x2fd8),
        Register('spr3fc', 8, 0x2fe0),
        Register('spr3fd', 8, 0x2fe8),
        Register('spr3fe', 8, 0x2ff0),
        Register('spr3ff', 8, 0x2ff8),
        Register('vs0', 16, 0x4000),
        Register('f0', 8, 0x4000),
        Register('vs1', 16, 0x4010),
        Register('f1', 8, 0x4010),
        Register('vs2', 16, 0x4020),
        Register('f2', 8, 0x4020),
        Register('vs3', 16, 0x4030),
        Register('f3', 8, 0x4030),
        Register('vs4', 16, 0x4040),
        Register('f4', 8, 0x4040),
        Register('vs5', 16, 0x4050),
        Register('f5', 8, 0x4050),
        Register('vs6', 16, 0x4060),
        Register('f6', 8, 0x4060),
        Register('vs7', 16, 0x4070),
        Register('f7', 8, 0x4070),
        Register('vs8', 16, 0x4080),
        Register('f8', 8, 0x4080),
        Register('vs9', 16, 0x4090),
        Register('f9', 8, 0x4090),
        Register('vs10', 16, 0x40a0),
        Register('f10', 8, 0x40a0),
        Register('vs11', 16, 0x40b0),
        Register('f11', 8, 0x40b0),
        Register('vs12', 16, 0x40c0),
        Register('f12', 8, 0x40c0),
        Register('vs13', 16, 0x40d0),
        Register('f13', 8, 0x40d0),
        Register('vs14', 16, 0x40e0),
        Register('f14', 8, 0x40e0),
        Register('vs15', 16, 0x40f0),
        Register('f15', 8, 0x40f0),
        Register('vs16', 16, 0x4100),
        Register('f16', 8, 0x4100),
        Register('vs17', 16, 0x4110),
        Register('f17', 8, 0x4110),
        Register('vs18', 16, 0x4120),
        Register('f18', 8, 0x4120),
        Register('vs19', 16, 0x4130),
        Register('f19', 8, 0x4130),
        Register('vs20', 16, 0x4140),
        Register('f20', 8, 0x4140),
        Register('vs21', 16, 0x4150),
        Register('f21', 8, 0x4150),
        Register('vs22', 16, 0x4160),
        Register('f22', 8, 0x4160),
        Register('vs23', 16, 0x4170),
        Register('f23', 8, 0x4170),
        Register('vs24', 16, 0x4180),
        Register('f24', 8, 0x4180),
        Register('vs25', 16, 0x4190),
        Register('f25', 8, 0x4190),
        Register('vs26', 16, 0x41a0),
        Register('f26', 8, 0x41a0),
        Register('vs27', 16, 0x41b0),
        Register('f27', 8, 0x41b0),
        Register('vs28', 16, 0x41c0),
        Register('f28', 8, 0x41c0),
        Register('vs29', 16, 0x41d0),
        Register('f29', 8, 0x41d0),
        Register('vs30', 16, 0x41e0),
        Register('f30', 8, 0x41e0),
        Register('vs31', 16, 0x41f0),
        Register('f31', 8, 0x41f0),
        Register('vs32', 16, 0x4200),
        Register('vr0_64_0', 8, 0x4200),
        Register('vr0_32_0', 4, 0x4200),
        Register('vr0_16_0', 2, 0x4200),
        Register('vr0_8_0', 1, 0x4200),
        Register('vr0_8_1', 1, 0x4201),
        Register('vr0_16_1', 2, 0x4202),
        Register('vr0_8_2', 1, 0x4202),
        Register('vr0_8_3', 1, 0x4203),
        Register('vr0_32_1', 4, 0x4204),
        Register('vr0_16_2', 2, 0x4204),
        Register('vr0_8_4', 1, 0x4204),
        Register('vr0_8_5', 1, 0x4205),
        Register('vr0_16_3', 2, 0x4206),
        Register('vr0_8_6', 1, 0x4206),
        Register('vr0_8_7', 1, 0x4207),
        Register('vr0_64_1', 8, 0x4208),
        Register('vr0_32_2', 4, 0x4208),
        Register('vr0_16_4', 2, 0x4208),
        Register('vr0_8_8', 1, 0x4208),
        Register('vr0_8_9', 1, 0x4209),
        Register('vr0_16_5', 2, 0x420a),
        Register('vr0_8_10', 1, 0x420a),
        Register('vr0_8_11', 1, 0x420b),
        Register('vr0_32_3', 4, 0x420c),
        Register('vr0_16_6', 2, 0x420c),
        Register('vr0_8_12', 1, 0x420c),
        Register('vr0_8_13', 1, 0x420d),
        Register('vr0_16_7', 2, 0x420e),
        Register('vr0_8_14', 1, 0x420e),
        Register('vr0_8_15', 1, 0x420f),
        Register('vs33', 16, 0x4210),
        Register('vr1_64_0', 8, 0x4210),
        Register('vr1_32_0', 4, 0x4210),
        Register('vr1_16_0', 2, 0x4210),
        Register('vr1_8_0', 1, 0x4210),
        Register('vr1_8_1', 1, 0x4211),
        Register('vr1_16_1', 2, 0x4212),
        Register('vr1_8_2', 1, 0x4212),
        Register('vr1_8_3', 1, 0x4213),
        Register('vr1_32_1', 4, 0x4214),
        Register('vr1_16_2', 2, 0x4214),
        Register('vr1_8_4', 1, 0x4214),
        Register('vr1_8_5', 1, 0x4215),
        Register('vr1_16_3', 2, 0x4216),
        Register('vr1_8_6', 1, 0x4216),
        Register('vr1_8_7', 1, 0x4217),
        Register('vr1_64_1', 8, 0x4218),
        Register('vr1_32_2', 4, 0x4218),
        Register('vr1_16_4', 2, 0x4218),
        Register('vr1_8_8', 1, 0x4218),
        Register('vr1_8_9', 1, 0x4219),
        Register('vr1_16_5', 2, 0x421a),
        Register('vr1_8_10', 1, 0x421a),
        Register('vr1_8_11', 1, 0x421b),
        Register('vr1_32_3', 4, 0x421c),
        Register('vr1_16_6', 2, 0x421c),
        Register('vr1_8_12', 1, 0x421c),
        Register('vr1_8_13', 1, 0x421d),
        Register('vr1_16_7', 2, 0x421e),
        Register('vr1_8_14', 1, 0x421e),
        Register('vr1_8_15', 1, 0x421f),
        Register('vs34', 16, 0x4220),
        Register('vr2_64_0', 8, 0x4220),
        Register('vr2_32_0', 4, 0x4220),
        Register('vr2_16_0', 2, 0x4220),
        Register('vr2_8_0', 1, 0x4220),
        Register('vr2_8_1', 1, 0x4221),
        Register('vr2_16_1', 2, 0x4222),
        Register('vr2_8_2', 1, 0x4222),
        Register('vr2_8_3', 1, 0x4223),
        Register('vr2_32_1', 4, 0x4224),
        Register('vr2_16_2', 2, 0x4224),
        Register('vr2_8_4', 1, 0x4224),
        Register('vr2_8_5', 1, 0x4225),
        Register('vr2_16_3', 2, 0x4226),
        Register('vr2_8_6', 1, 0x4226),
        Register('vr2_8_7', 1, 0x4227),
        Register('vr2_64_1', 8, 0x4228),
        Register('vr2_32_2', 4, 0x4228),
        Register('vr2_16_4', 2, 0x4228),
        Register('vr2_8_8', 1, 0x4228),
        Register('vr2_8_9', 1, 0x4229),
        Register('vr2_16_5', 2, 0x422a),
        Register('vr2_8_10', 1, 0x422a),
        Register('vr2_8_11', 1, 0x422b),
        Register('vr2_32_3', 4, 0x422c),
        Register('vr2_16_6', 2, 0x422c),
        Register('vr2_8_12', 1, 0x422c),
        Register('vr2_8_13', 1, 0x422d),
        Register('vr2_16_7', 2, 0x422e),
        Register('vr2_8_14', 1, 0x422e),
        Register('vr2_8_15', 1, 0x422f),
        Register('vs35', 16, 0x4230),
        Register('vr3_64_0', 8, 0x4230),
        Register('vr3_32_0', 4, 0x4230),
        Register('vr3_16_0', 2, 0x4230),
        Register('vr3_8_0', 1, 0x4230),
        Register('vr3_8_1', 1, 0x4231),
        Register('vr3_16_1', 2, 0x4232),
        Register('vr3_8_2', 1, 0x4232),
        Register('vr3_8_3', 1, 0x4233),
        Register('vr3_32_1', 4, 0x4234),
        Register('vr3_16_2', 2, 0x4234),
        Register('vr3_8_4', 1, 0x4234),
        Register('vr3_8_5', 1, 0x4235),
        Register('vr3_16_3', 2, 0x4236),
        Register('vr3_8_6', 1, 0x4236),
        Register('vr3_8_7', 1, 0x4237),
        Register('vr3_64_1', 8, 0x4238),
        Register('vr3_32_2', 4, 0x4238),
        Register('vr3_16_4', 2, 0x4238),
        Register('vr3_8_8', 1, 0x4238),
        Register('vr3_8_9', 1, 0x4239),
        Register('vr3_16_5', 2, 0x423a),
        Register('vr3_8_10', 1, 0x423a),
        Register('vr3_8_11', 1, 0x423b),
        Register('vr3_32_3', 4, 0x423c),
        Register('vr3_16_6', 2, 0x423c),
        Register('vr3_8_12', 1, 0x423c),
        Register('vr3_8_13', 1, 0x423d),
        Register('vr3_16_7', 2, 0x423e),
        Register('vr3_8_14', 1, 0x423e),
        Register('vr3_8_15', 1, 0x423f),
        Register('vs36', 16, 0x4240),
        Register('vr4_64_0', 8, 0x4240),
        Register('vr4_32_0', 4, 0x4240),
        Register('vr4_16_0', 2, 0x4240),
        Register('vr4_8_0', 1, 0x4240),
        Register('vr4_8_1', 1, 0x4241),
        Register('vr4_16_1', 2, 0x4242),
        Register('vr4_8_2', 1, 0x4242),
        Register('vr4_8_3', 1, 0x4243),
        Register('vr4_32_1', 4, 0x4244),
        Register('vr4_16_2', 2, 0x4244),
        Register('vr4_8_4', 1, 0x4244),
        Register('vr4_8_5', 1, 0x4245),
        Register('vr4_16_3', 2, 0x4246),
        Register('vr4_8_6', 1, 0x4246),
        Register('vr4_8_7', 1, 0x4247),
        Register('vr4_64_1', 8, 0x4248),
        Register('vr4_32_2', 4, 0x4248),
        Register('vr4_16_4', 2, 0x4248),
        Register('vr4_8_8', 1, 0x4248),
        Register('vr4_8_9', 1, 0x4249),
        Register('vr4_16_5', 2, 0x424a),
        Register('vr4_8_10', 1, 0x424a),
        Register('vr4_8_11', 1, 0x424b),
        Register('vr4_32_3', 4, 0x424c),
        Register('vr4_16_6', 2, 0x424c),
        Register('vr4_8_12', 1, 0x424c),
        Register('vr4_8_13', 1, 0x424d),
        Register('vr4_16_7', 2, 0x424e),
        Register('vr4_8_14', 1, 0x424e),
        Register('vr4_8_15', 1, 0x424f),
        Register('vs37', 16, 0x4250),
        Register('vr5_64_0', 8, 0x4250),
        Register('vr5_32_0', 4, 0x4250),
        Register('vr5_16_0', 2, 0x4250),
        Register('vr5_8_0', 1, 0x4250),
        Register('vr5_8_1', 1, 0x4251),
        Register('vr5_16_1', 2, 0x4252),
        Register('vr5_8_2', 1, 0x4252),
        Register('vr5_8_3', 1, 0x4253),
        Register('vr5_32_1', 4, 0x4254),
        Register('vr5_16_2', 2, 0x4254),
        Register('vr5_8_4', 1, 0x4254),
        Register('vr5_8_5', 1, 0x4255),
        Register('vr5_16_3', 2, 0x4256),
        Register('vr5_8_6', 1, 0x4256),
        Register('vr5_8_7', 1, 0x4257),
        Register('vr5_64_1', 8, 0x4258),
        Register('vr5_32_2', 4, 0x4258),
        Register('vr5_16_4', 2, 0x4258),
        Register('vr5_8_8', 1, 0x4258),
        Register('vr5_8_9', 1, 0x4259),
        Register('vr5_16_5', 2, 0x425a),
        Register('vr5_8_10', 1, 0x425a),
        Register('vr5_8_11', 1, 0x425b),
        Register('vr5_32_3', 4, 0x425c),
        Register('vr5_16_6', 2, 0x425c),
        Register('vr5_8_12', 1, 0x425c),
        Register('vr5_8_13', 1, 0x425d),
        Register('vr5_16_7', 2, 0x425e),
        Register('vr5_8_14', 1, 0x425e),
        Register('vr5_8_15', 1, 0x425f),
        Register('vs38', 16, 0x4260),
        Register('vr6_64_0', 8, 0x4260),
        Register('vr6_32_0', 4, 0x4260),
        Register('vr6_16_0', 2, 0x4260),
        Register('vr6_8_0', 1, 0x4260),
        Register('vr6_8_1', 1, 0x4261),
        Register('vr6_16_1', 2, 0x4262),
        Register('vr6_8_2', 1, 0x4262),
        Register('vr6_8_3', 1, 0x4263),
        Register('vr6_32_1', 4, 0x4264),
        Register('vr6_16_2', 2, 0x4264),
        Register('vr6_8_4', 1, 0x4264),
        Register('vr6_8_5', 1, 0x4265),
        Register('vr6_16_3', 2, 0x4266),
        Register('vr6_8_6', 1, 0x4266),
        Register('vr6_8_7', 1, 0x4267),
        Register('vr6_64_1', 8, 0x4268),
        Register('vr6_32_2', 4, 0x4268),
        Register('vr6_16_4', 2, 0x4268),
        Register('vr6_8_8', 1, 0x4268),
        Register('vr6_8_9', 1, 0x4269),
        Register('vr6_16_5', 2, 0x426a),
        Register('vr6_8_10', 1, 0x426a),
        Register('vr6_8_11', 1, 0x426b),
        Register('vr6_32_3', 4, 0x426c),
        Register('vr6_16_6', 2, 0x426c),
        Register('vr6_8_12', 1, 0x426c),
        Register('vr6_8_13', 1, 0x426d),
        Register('vr6_16_7', 2, 0x426e),
        Register('vr6_8_14', 1, 0x426e),
        Register('vr6_8_15', 1, 0x426f),
        Register('vs39', 16, 0x4270),
        Register('vr7_64_0', 8, 0x4270),
        Register('vr7_32_0', 4, 0x4270),
        Register('vr7_16_0', 2, 0x4270),
        Register('vr7_8_0', 1, 0x4270),
        Register('vr7_8_1', 1, 0x4271),
        Register('vr7_16_1', 2, 0x4272),
        Register('vr7_8_2', 1, 0x4272),
        Register('vr7_8_3', 1, 0x4273),
        Register('vr7_32_1', 4, 0x4274),
        Register('vr7_16_2', 2, 0x4274),
        Register('vr7_8_4', 1, 0x4274),
        Register('vr7_8_5', 1, 0x4275),
        Register('vr7_16_3', 2, 0x4276),
        Register('vr7_8_6', 1, 0x4276),
        Register('vr7_8_7', 1, 0x4277),
        Register('vr7_64_1', 8, 0x4278),
        Register('vr7_32_2', 4, 0x4278),
        Register('vr7_16_4', 2, 0x4278),
        Register('vr7_8_8', 1, 0x4278),
        Register('vr7_8_9', 1, 0x4279),
        Register('vr7_16_5', 2, 0x427a),
        Register('vr7_8_10', 1, 0x427a),
        Register('vr7_8_11', 1, 0x427b),
        Register('vr7_32_3', 4, 0x427c),
        Register('vr7_16_6', 2, 0x427c),
        Register('vr7_8_12', 1, 0x427c),
        Register('vr7_8_13', 1, 0x427d),
        Register('vr7_16_7', 2, 0x427e),
        Register('vr7_8_14', 1, 0x427e),
        Register('vr7_8_15', 1, 0x427f),
        Register('vs40', 16, 0x4280),
        Register('vr8_64_0', 8, 0x4280),
        Register('vr8_32_0', 4, 0x4280),
        Register('vr8_16_0', 2, 0x4280),
        Register('vr8_8_0', 1, 0x4280),
        Register('vr8_8_1', 1, 0x4281),
        Register('vr8_16_1', 2, 0x4282),
        Register('vr8_8_2', 1, 0x4282),
        Register('vr8_8_3', 1, 0x4283),
        Register('vr8_32_1', 4, 0x4284),
        Register('vr8_16_2', 2, 0x4284),
        Register('vr8_8_4', 1, 0x4284),
        Register('vr8_8_5', 1, 0x4285),
        Register('vr8_16_3', 2, 0x4286),
        Register('vr8_8_6', 1, 0x4286),
        Register('vr8_8_7', 1, 0x4287),
        Register('vr8_64_1', 8, 0x4288),
        Register('vr8_32_2', 4, 0x4288),
        Register('vr8_16_4', 2, 0x4288),
        Register('vr8_8_8', 1, 0x4288),
        Register('vr8_8_9', 1, 0x4289),
        Register('vr8_16_5', 2, 0x428a),
        Register('vr8_8_10', 1, 0x428a),
        Register('vr8_8_11', 1, 0x428b),
        Register('vr8_32_3', 4, 0x428c),
        Register('vr8_16_6', 2, 0x428c),
        Register('vr8_8_12', 1, 0x428c),
        Register('vr8_8_13', 1, 0x428d),
        Register('vr8_16_7', 2, 0x428e),
        Register('vr8_8_14', 1, 0x428e),
        Register('vr8_8_15', 1, 0x428f),
        Register('vs41', 16, 0x4290),
        Register('vr9_64_0', 8, 0x4290),
        Register('vr9_32_0', 4, 0x4290),
        Register('vr9_16_0', 2, 0x4290),
        Register('vr9_8_0', 1, 0x4290),
        Register('vr9_8_1', 1, 0x4291),
        Register('vr9_16_1', 2, 0x4292),
        Register('vr9_8_2', 1, 0x4292),
        Register('vr9_8_3', 1, 0x4293),
        Register('vr9_32_1', 4, 0x4294),
        Register('vr9_16_2', 2, 0x4294),
        Register('vr9_8_4', 1, 0x4294),
        Register('vr9_8_5', 1, 0x4295),
        Register('vr9_16_3', 2, 0x4296),
        Register('vr9_8_6', 1, 0x4296),
        Register('vr9_8_7', 1, 0x4297),
        Register('vr9_64_1', 8, 0x4298),
        Register('vr9_32_2', 4, 0x4298),
        Register('vr9_16_4', 2, 0x4298),
        Register('vr9_8_8', 1, 0x4298),
        Register('vr9_8_9', 1, 0x4299),
        Register('vr9_16_5', 2, 0x429a),
        Register('vr9_8_10', 1, 0x429a),
        Register('vr9_8_11', 1, 0x429b),
        Register('vr9_32_3', 4, 0x429c),
        Register('vr9_16_6', 2, 0x429c),
        Register('vr9_8_12', 1, 0x429c),
        Register('vr9_8_13', 1, 0x429d),
        Register('vr9_16_7', 2, 0x429e),
        Register('vr9_8_14', 1, 0x429e),
        Register('vr9_8_15', 1, 0x429f),
        Register('vs42', 16, 0x42a0),
        Register('vr10_64_0', 8, 0x42a0),
        Register('vr10_32_0', 4, 0x42a0),
        Register('vr10_16_0', 2, 0x42a0),
        Register('vr10_8_0', 1, 0x42a0),
        Register('vr10_8_1', 1, 0x42a1),
        Register('vr10_16_1', 2, 0x42a2),
        Register('vr10_8_2', 1, 0x42a2),
        Register('vr10_8_3', 1, 0x42a3),
        Register('vr10_32_1', 4, 0x42a4),
        Register('vr10_16_2', 2, 0x42a4),
        Register('vr10_8_4', 1, 0x42a4),
        Register('vr10_8_5', 1, 0x42a5),
        Register('vr10_16_3', 2, 0x42a6),
        Register('vr10_8_6', 1, 0x42a6),
        Register('vr10_8_7', 1, 0x42a7),
        Register('vr10_64_1', 8, 0x42a8),
        Register('vr10_32_2', 4, 0x42a8),
        Register('vr10_16_4', 2, 0x42a8),
        Register('vr10_8_8', 1, 0x42a8),
        Register('vr10_8_9', 1, 0x42a9),
        Register('vr10_16_5', 2, 0x42aa),
        Register('vr10_8_10', 1, 0x42aa),
        Register('vr10_8_11', 1, 0x42ab),
        Register('vr10_32_3', 4, 0x42ac),
        Register('vr10_16_6', 2, 0x42ac),
        Register('vr10_8_12', 1, 0x42ac),
        Register('vr10_8_13', 1, 0x42ad),
        Register('vr10_16_7', 2, 0x42ae),
        Register('vr10_8_14', 1, 0x42ae),
        Register('vr10_8_15', 1, 0x42af),
        Register('vs43', 16, 0x42b0),
        Register('vr11_64_0', 8, 0x42b0),
        Register('vr11_32_0', 4, 0x42b0),
        Register('vr11_16_0', 2, 0x42b0),
        Register('vr11_8_0', 1, 0x42b0),
        Register('vr11_8_1', 1, 0x42b1),
        Register('vr11_16_1', 2, 0x42b2),
        Register('vr11_8_2', 1, 0x42b2),
        Register('vr11_8_3', 1, 0x42b3),
        Register('vr11_32_1', 4, 0x42b4),
        Register('vr11_16_2', 2, 0x42b4),
        Register('vr11_8_4', 1, 0x42b4),
        Register('vr11_8_5', 1, 0x42b5),
        Register('vr11_16_3', 2, 0x42b6),
        Register('vr11_8_6', 1, 0x42b6),
        Register('vr11_8_7', 1, 0x42b7),
        Register('vr11_64_1', 8, 0x42b8),
        Register('vr11_32_2', 4, 0x42b8),
        Register('vr11_16_4', 2, 0x42b8),
        Register('vr11_8_8', 1, 0x42b8),
        Register('vr11_8_9', 1, 0x42b9),
        Register('vr11_16_5', 2, 0x42ba),
        Register('vr11_8_10', 1, 0x42ba),
        Register('vr11_8_11', 1, 0x42bb),
        Register('vr11_32_3', 4, 0x42bc),
        Register('vr11_16_6', 2, 0x42bc),
        Register('vr11_8_12', 1, 0x42bc),
        Register('vr11_8_13', 1, 0x42bd),
        Register('vr11_16_7', 2, 0x42be),
        Register('vr11_8_14', 1, 0x42be),
        Register('vr11_8_15', 1, 0x42bf),
        Register('vs44', 16, 0x42c0),
        Register('vr12_64_0', 8, 0x42c0),
        Register('vr12_32_0', 4, 0x42c0),
        Register('vr12_16_0', 2, 0x42c0),
        Register('vr12_8_0', 1, 0x42c0),
        Register('vr12_8_1', 1, 0x42c1),
        Register('vr12_16_1', 2, 0x42c2),
        Register('vr12_8_2', 1, 0x42c2),
        Register('vr12_8_3', 1, 0x42c3),
        Register('vr12_32_1', 4, 0x42c4),
        Register('vr12_16_2', 2, 0x42c4),
        Register('vr12_8_4', 1, 0x42c4),
        Register('vr12_8_5', 1, 0x42c5),
        Register('vr12_16_3', 2, 0x42c6),
        Register('vr12_8_6', 1, 0x42c6),
        Register('vr12_8_7', 1, 0x42c7),
        Register('vr12_64_1', 8, 0x42c8),
        Register('vr12_32_2', 4, 0x42c8),
        Register('vr12_16_4', 2, 0x42c8),
        Register('vr12_8_8', 1, 0x42c8),
        Register('vr12_8_9', 1, 0x42c9),
        Register('vr12_16_5', 2, 0x42ca),
        Register('vr12_8_10', 1, 0x42ca),
        Register('vr12_8_11', 1, 0x42cb),
        Register('vr12_32_3', 4, 0x42cc),
        Register('vr12_16_6', 2, 0x42cc),
        Register('vr12_8_12', 1, 0x42cc),
        Register('vr12_8_13', 1, 0x42cd),
        Register('vr12_16_7', 2, 0x42ce),
        Register('vr12_8_14', 1, 0x42ce),
        Register('vr12_8_15', 1, 0x42cf),
        Register('vs45', 16, 0x42d0),
        Register('vr13_64_0', 8, 0x42d0),
        Register('vr13_32_0', 4, 0x42d0),
        Register('vr13_16_0', 2, 0x42d0),
        Register('vr13_8_0', 1, 0x42d0),
        Register('vr13_8_1', 1, 0x42d1),
        Register('vr13_16_1', 2, 0x42d2),
        Register('vr13_8_2', 1, 0x42d2),
        Register('vr13_8_3', 1, 0x42d3),
        Register('vr13_32_1', 4, 0x42d4),
        Register('vr13_16_2', 2, 0x42d4),
        Register('vr13_8_4', 1, 0x42d4),
        Register('vr13_8_5', 1, 0x42d5),
        Register('vr13_16_3', 2, 0x42d6),
        Register('vr13_8_6', 1, 0x42d6),
        Register('vr13_8_7', 1, 0x42d7),
        Register('vr13_64_1', 8, 0x42d8),
        Register('vr13_32_2', 4, 0x42d8),
        Register('vr13_16_4', 2, 0x42d8),
        Register('vr13_8_8', 1, 0x42d8),
        Register('vr13_8_9', 1, 0x42d9),
        Register('vr13_16_5', 2, 0x42da),
        Register('vr13_8_10', 1, 0x42da),
        Register('vr13_8_11', 1, 0x42db),
        Register('vr13_32_3', 4, 0x42dc),
        Register('vr13_16_6', 2, 0x42dc),
        Register('vr13_8_12', 1, 0x42dc),
        Register('vr13_8_13', 1, 0x42dd),
        Register('vr13_16_7', 2, 0x42de),
        Register('vr13_8_14', 1, 0x42de),
        Register('vr13_8_15', 1, 0x42df),
        Register('vs46', 16, 0x42e0),
        Register('vr14_64_0', 8, 0x42e0),
        Register('vr14_32_0', 4, 0x42e0),
        Register('vr14_16_0', 2, 0x42e0),
        Register('vr14_8_0', 1, 0x42e0),
        Register('vr14_8_1', 1, 0x42e1),
        Register('vr14_16_1', 2, 0x42e2),
        Register('vr14_8_2', 1, 0x42e2),
        Register('vr14_8_3', 1, 0x42e3),
        Register('vr14_32_1', 4, 0x42e4),
        Register('vr14_16_2', 2, 0x42e4),
        Register('vr14_8_4', 1, 0x42e4),
        Register('vr14_8_5', 1, 0x42e5),
        Register('vr14_16_3', 2, 0x42e6),
        Register('vr14_8_6', 1, 0x42e6),
        Register('vr14_8_7', 1, 0x42e7),
        Register('vr14_64_1', 8, 0x42e8),
        Register('vr14_32_2', 4, 0x42e8),
        Register('vr14_16_4', 2, 0x42e8),
        Register('vr14_8_8', 1, 0x42e8),
        Register('vr14_8_9', 1, 0x42e9),
        Register('vr14_16_5', 2, 0x42ea),
        Register('vr14_8_10', 1, 0x42ea),
        Register('vr14_8_11', 1, 0x42eb),
        Register('vr14_32_3', 4, 0x42ec),
        Register('vr14_16_6', 2, 0x42ec),
        Register('vr14_8_12', 1, 0x42ec),
        Register('vr14_8_13', 1, 0x42ed),
        Register('vr14_16_7', 2, 0x42ee),
        Register('vr14_8_14', 1, 0x42ee),
        Register('vr14_8_15', 1, 0x42ef),
        Register('vs47', 16, 0x42f0),
        Register('vr15_64_0', 8, 0x42f0),
        Register('vr15_32_0', 4, 0x42f0),
        Register('vr15_16_0', 2, 0x42f0),
        Register('vr15_8_0', 1, 0x42f0),
        Register('vr15_8_1', 1, 0x42f1),
        Register('vr15_16_1', 2, 0x42f2),
        Register('vr15_8_2', 1, 0x42f2),
        Register('vr15_8_3', 1, 0x42f3),
        Register('vr15_32_1', 4, 0x42f4),
        Register('vr15_16_2', 2, 0x42f4),
        Register('vr15_8_4', 1, 0x42f4),
        Register('vr15_8_5', 1, 0x42f5),
        Register('vr15_16_3', 2, 0x42f6),
        Register('vr15_8_6', 1, 0x42f6),
        Register('vr15_8_7', 1, 0x42f7),
        Register('vr15_64_1', 8, 0x42f8),
        Register('vr15_32_2', 4, 0x42f8),
        Register('vr15_16_4', 2, 0x42f8),
        Register('vr15_8_8', 1, 0x42f8),
        Register('vr15_8_9', 1, 0x42f9),
        Register('vr15_16_5', 2, 0x42fa),
        Register('vr15_8_10', 1, 0x42fa),
        Register('vr15_8_11', 1, 0x42fb),
        Register('vr15_32_3', 4, 0x42fc),
        Register('vr15_16_6', 2, 0x42fc),
        Register('vr15_8_12', 1, 0x42fc),
        Register('vr15_8_13', 1, 0x42fd),
        Register('vr15_16_7', 2, 0x42fe),
        Register('vr15_8_14', 1, 0x42fe),
        Register('vr15_8_15', 1, 0x42ff),
        Register('vs48', 16, 0x4300),
        Register('vr16_64_0', 8, 0x4300),
        Register('vr16_32_0', 4, 0x4300),
        Register('vr16_16_0', 2, 0x4300),
        Register('vr16_8_0', 1, 0x4300),
        Register('vr16_8_1', 1, 0x4301),
        Register('vr16_16_1', 2, 0x4302),
        Register('vr16_8_2', 1, 0x4302),
        Register('vr16_8_3', 1, 0x4303),
        Register('vr16_32_1', 4, 0x4304),
        Register('vr16_16_2', 2, 0x4304),
        Register('vr16_8_4', 1, 0x4304),
        Register('vr16_8_5', 1, 0x4305),
        Register('vr16_16_3', 2, 0x4306),
        Register('vr16_8_6', 1, 0x4306),
        Register('vr16_8_7', 1, 0x4307),
        Register('vr16_64_1', 8, 0x4308),
        Register('vr16_32_2', 4, 0x4308),
        Register('vr16_16_4', 2, 0x4308),
        Register('vr16_8_8', 1, 0x4308),
        Register('vr16_8_9', 1, 0x4309),
        Register('vr16_16_5', 2, 0x430a),
        Register('vr16_8_10', 1, 0x430a),
        Register('vr16_8_11', 1, 0x430b),
        Register('vr16_32_3', 4, 0x430c),
        Register('vr16_16_6', 2, 0x430c),
        Register('vr16_8_12', 1, 0x430c),
        Register('vr16_8_13', 1, 0x430d),
        Register('vr16_16_7', 2, 0x430e),
        Register('vr16_8_14', 1, 0x430e),
        Register('vr16_8_15', 1, 0x430f),
        Register('vs49', 16, 0x4310),
        Register('vr17_64_0', 8, 0x4310),
        Register('vr17_32_0', 4, 0x4310),
        Register('vr17_16_0', 2, 0x4310),
        Register('vr17_8_0', 1, 0x4310),
        Register('vr17_8_1', 1, 0x4311),
        Register('vr17_16_1', 2, 0x4312),
        Register('vr17_8_2', 1, 0x4312),
        Register('vr17_8_3', 1, 0x4313),
        Register('vr17_32_1', 4, 0x4314),
        Register('vr17_16_2', 2, 0x4314),
        Register('vr17_8_4', 1, 0x4314),
        Register('vr17_8_5', 1, 0x4315),
        Register('vr17_16_3', 2, 0x4316),
        Register('vr17_8_6', 1, 0x4316),
        Register('vr17_8_7', 1, 0x4317),
        Register('vr17_64_1', 8, 0x4318),
        Register('vr17_32_2', 4, 0x4318),
        Register('vr17_16_4', 2, 0x4318),
        Register('vr17_8_8', 1, 0x4318),
        Register('vr17_8_9', 1, 0x4319),
        Register('vr17_16_5', 2, 0x431a),
        Register('vr17_8_10', 1, 0x431a),
        Register('vr17_8_11', 1, 0x431b),
        Register('vr17_32_3', 4, 0x431c),
        Register('vr17_16_6', 2, 0x431c),
        Register('vr17_8_12', 1, 0x431c),
        Register('vr17_8_13', 1, 0x431d),
        Register('vr17_16_7', 2, 0x431e),
        Register('vr17_8_14', 1, 0x431e),
        Register('vr17_8_15', 1, 0x431f),
        Register('vs50', 16, 0x4320),
        Register('vr18_64_0', 8, 0x4320),
        Register('vr18_32_0', 4, 0x4320),
        Register('vr18_16_0', 2, 0x4320),
        Register('vr18_8_0', 1, 0x4320),
        Register('vr18_8_1', 1, 0x4321),
        Register('vr18_16_1', 2, 0x4322),
        Register('vr18_8_2', 1, 0x4322),
        Register('vr18_8_3', 1, 0x4323),
        Register('vr18_32_1', 4, 0x4324),
        Register('vr18_16_2', 2, 0x4324),
        Register('vr18_8_4', 1, 0x4324),
        Register('vr18_8_5', 1, 0x4325),
        Register('vr18_16_3', 2, 0x4326),
        Register('vr18_8_6', 1, 0x4326),
        Register('vr18_8_7', 1, 0x4327),
        Register('vr18_64_1', 8, 0x4328),
        Register('vr18_32_2', 4, 0x4328),
        Register('vr18_16_4', 2, 0x4328),
        Register('vr18_8_8', 1, 0x4328),
        Register('vr18_8_9', 1, 0x4329),
        Register('vr18_16_5', 2, 0x432a),
        Register('vr18_8_10', 1, 0x432a),
        Register('vr18_8_11', 1, 0x432b),
        Register('vr18_32_3', 4, 0x432c),
        Register('vr18_16_6', 2, 0x432c),
        Register('vr18_8_12', 1, 0x432c),
        Register('vr18_8_13', 1, 0x432d),
        Register('vr18_16_7', 2, 0x432e),
        Register('vr18_8_14', 1, 0x432e),
        Register('vr18_8_15', 1, 0x432f),
        Register('vs51', 16, 0x4330),
        Register('vr19_64_0', 8, 0x4330),
        Register('vr19_32_0', 4, 0x4330),
        Register('vr19_16_0', 2, 0x4330),
        Register('vr19_8_0', 1, 0x4330),
        Register('vr19_8_1', 1, 0x4331),
        Register('vr19_16_1', 2, 0x4332),
        Register('vr19_8_2', 1, 0x4332),
        Register('vr19_8_3', 1, 0x4333),
        Register('vr19_32_1', 4, 0x4334),
        Register('vr19_16_2', 2, 0x4334),
        Register('vr19_8_4', 1, 0x4334),
        Register('vr19_8_5', 1, 0x4335),
        Register('vr19_16_3', 2, 0x4336),
        Register('vr19_8_6', 1, 0x4336),
        Register('vr19_8_7', 1, 0x4337),
        Register('vr19_64_1', 8, 0x4338),
        Register('vr19_32_2', 4, 0x4338),
        Register('vr19_16_4', 2, 0x4338),
        Register('vr19_8_8', 1, 0x4338),
        Register('vr19_8_9', 1, 0x4339),
        Register('vr19_16_5', 2, 0x433a),
        Register('vr19_8_10', 1, 0x433a),
        Register('vr19_8_11', 1, 0x433b),
        Register('vr19_32_3', 4, 0x433c),
        Register('vr19_16_6', 2, 0x433c),
        Register('vr19_8_12', 1, 0x433c),
        Register('vr19_8_13', 1, 0x433d),
        Register('vr19_16_7', 2, 0x433e),
        Register('vr19_8_14', 1, 0x433e),
        Register('vr19_8_15', 1, 0x433f),
        Register('vs52', 16, 0x4340),
        Register('vr20_64_0', 8, 0x4340),
        Register('vr20_32_0', 4, 0x4340),
        Register('vr20_16_0', 2, 0x4340),
        Register('vr20_8_0', 1, 0x4340),
        Register('vr20_8_1', 1, 0x4341),
        Register('vr20_16_1', 2, 0x4342),
        Register('vr20_8_2', 1, 0x4342),
        Register('vr20_8_3', 1, 0x4343),
        Register('vr20_32_1', 4, 0x4344),
        Register('vr20_16_2', 2, 0x4344),
        Register('vr20_8_4', 1, 0x4344),
        Register('vr20_8_5', 1, 0x4345),
        Register('vr20_16_3', 2, 0x4346),
        Register('vr20_8_6', 1, 0x4346),
        Register('vr20_8_7', 1, 0x4347),
        Register('vr20_64_1', 8, 0x4348),
        Register('vr20_32_2', 4, 0x4348),
        Register('vr20_16_4', 2, 0x4348),
        Register('vr20_8_8', 1, 0x4348),
        Register('vr20_8_9', 1, 0x4349),
        Register('vr20_16_5', 2, 0x434a),
        Register('vr20_8_10', 1, 0x434a),
        Register('vr20_8_11', 1, 0x434b),
        Register('vr20_32_3', 4, 0x434c),
        Register('vr20_16_6', 2, 0x434c),
        Register('vr20_8_12', 1, 0x434c),
        Register('vr20_8_13', 1, 0x434d),
        Register('vr20_16_7', 2, 0x434e),
        Register('vr20_8_14', 1, 0x434e),
        Register('vr20_8_15', 1, 0x434f),
        Register('vs53', 16, 0x4350),
        Register('vr21_64_0', 8, 0x4350),
        Register('vr21_32_0', 4, 0x4350),
        Register('vr21_16_0', 2, 0x4350),
        Register('vr21_8_0', 1, 0x4350),
        Register('vr21_8_1', 1, 0x4351),
        Register('vr21_16_1', 2, 0x4352),
        Register('vr21_8_2', 1, 0x4352),
        Register('vr21_8_3', 1, 0x4353),
        Register('vr21_32_1', 4, 0x4354),
        Register('vr21_16_2', 2, 0x4354),
        Register('vr21_8_4', 1, 0x4354),
        Register('vr21_8_5', 1, 0x4355),
        Register('vr21_16_3', 2, 0x4356),
        Register('vr21_8_6', 1, 0x4356),
        Register('vr21_8_7', 1, 0x4357),
        Register('vr21_64_1', 8, 0x4358),
        Register('vr21_32_2', 4, 0x4358),
        Register('vr21_16_4', 2, 0x4358),
        Register('vr21_8_8', 1, 0x4358),
        Register('vr21_8_9', 1, 0x4359),
        Register('vr21_16_5', 2, 0x435a),
        Register('vr21_8_10', 1, 0x435a),
        Register('vr21_8_11', 1, 0x435b),
        Register('vr21_32_3', 4, 0x435c),
        Register('vr21_16_6', 2, 0x435c),
        Register('vr21_8_12', 1, 0x435c),
        Register('vr21_8_13', 1, 0x435d),
        Register('vr21_16_7', 2, 0x435e),
        Register('vr21_8_14', 1, 0x435e),
        Register('vr21_8_15', 1, 0x435f),
        Register('vs54', 16, 0x4360),
        Register('vr22_64_0', 8, 0x4360),
        Register('vr22_32_0', 4, 0x4360),
        Register('vr22_16_0', 2, 0x4360),
        Register('vr22_8_0', 1, 0x4360),
        Register('vr22_8_1', 1, 0x4361),
        Register('vr22_16_1', 2, 0x4362),
        Register('vr22_8_2', 1, 0x4362),
        Register('vr22_8_3', 1, 0x4363),
        Register('vr22_32_1', 4, 0x4364),
        Register('vr22_16_2', 2, 0x4364),
        Register('vr22_8_4', 1, 0x4364),
        Register('vr22_8_5', 1, 0x4365),
        Register('vr22_16_3', 2, 0x4366),
        Register('vr22_8_6', 1, 0x4366),
        Register('vr22_8_7', 1, 0x4367),
        Register('vr22_64_1', 8, 0x4368),
        Register('vr22_32_2', 4, 0x4368),
        Register('vr22_16_4', 2, 0x4368),
        Register('vr22_8_8', 1, 0x4368),
        Register('vr22_8_9', 1, 0x4369),
        Register('vr22_16_5', 2, 0x436a),
        Register('vr22_8_10', 1, 0x436a),
        Register('vr22_8_11', 1, 0x436b),
        Register('vr22_32_3', 4, 0x436c),
        Register('vr22_16_6', 2, 0x436c),
        Register('vr22_8_12', 1, 0x436c),
        Register('vr22_8_13', 1, 0x436d),
        Register('vr22_16_7', 2, 0x436e),
        Register('vr22_8_14', 1, 0x436e),
        Register('vr22_8_15', 1, 0x436f),
        Register('vs55', 16, 0x4370),
        Register('vr23_64_0', 8, 0x4370),
        Register('vr23_32_0', 4, 0x4370),
        Register('vr23_16_0', 2, 0x4370),
        Register('vr23_8_0', 1, 0x4370),
        Register('vr23_8_1', 1, 0x4371),
        Register('vr23_16_1', 2, 0x4372),
        Register('vr23_8_2', 1, 0x4372),
        Register('vr23_8_3', 1, 0x4373),
        Register('vr23_32_1', 4, 0x4374),
        Register('vr23_16_2', 2, 0x4374),
        Register('vr23_8_4', 1, 0x4374),
        Register('vr23_8_5', 1, 0x4375),
        Register('vr23_16_3', 2, 0x4376),
        Register('vr23_8_6', 1, 0x4376),
        Register('vr23_8_7', 1, 0x4377),
        Register('vr23_64_1', 8, 0x4378),
        Register('vr23_32_2', 4, 0x4378),
        Register('vr23_16_4', 2, 0x4378),
        Register('vr23_8_8', 1, 0x4378),
        Register('vr23_8_9', 1, 0x4379),
        Register('vr23_16_5', 2, 0x437a),
        Register('vr23_8_10', 1, 0x437a),
        Register('vr23_8_11', 1, 0x437b),
        Register('vr23_32_3', 4, 0x437c),
        Register('vr23_16_6', 2, 0x437c),
        Register('vr23_8_12', 1, 0x437c),
        Register('vr23_8_13', 1, 0x437d),
        Register('vr23_16_7', 2, 0x437e),
        Register('vr23_8_14', 1, 0x437e),
        Register('vr23_8_15', 1, 0x437f),
        Register('vs56', 16, 0x4380),
        Register('vr24_64_0', 8, 0x4380),
        Register('vr24_32_0', 4, 0x4380),
        Register('vr24_16_0', 2, 0x4380),
        Register('vr24_8_0', 1, 0x4380),
        Register('vr24_8_1', 1, 0x4381),
        Register('vr24_16_1', 2, 0x4382),
        Register('vr24_8_2', 1, 0x4382),
        Register('vr24_8_3', 1, 0x4383),
        Register('vr24_32_1', 4, 0x4384),
        Register('vr24_16_2', 2, 0x4384),
        Register('vr24_8_4', 1, 0x4384),
        Register('vr24_8_5', 1, 0x4385),
        Register('vr24_16_3', 2, 0x4386),
        Register('vr24_8_6', 1, 0x4386),
        Register('vr24_8_7', 1, 0x4387),
        Register('vr24_64_1', 8, 0x4388),
        Register('vr24_32_2', 4, 0x4388),
        Register('vr24_16_4', 2, 0x4388),
        Register('vr24_8_8', 1, 0x4388),
        Register('vr24_8_9', 1, 0x4389),
        Register('vr24_16_5', 2, 0x438a),
        Register('vr24_8_10', 1, 0x438a),
        Register('vr24_8_11', 1, 0x438b),
        Register('vr24_32_3', 4, 0x438c),
        Register('vr24_16_6', 2, 0x438c),
        Register('vr24_8_12', 1, 0x438c),
        Register('vr24_8_13', 1, 0x438d),
        Register('vr24_16_7', 2, 0x438e),
        Register('vr24_8_14', 1, 0x438e),
        Register('vr24_8_15', 1, 0x438f),
        Register('vs57', 16, 0x4390),
        Register('vr25_64_0', 8, 0x4390),
        Register('vr25_32_0', 4, 0x4390),
        Register('vr25_16_0', 2, 0x4390),
        Register('vr25_8_0', 1, 0x4390),
        Register('vr25_8_1', 1, 0x4391),
        Register('vr25_16_1', 2, 0x4392),
        Register('vr25_8_2', 1, 0x4392),
        Register('vr25_8_3', 1, 0x4393),
        Register('vr25_32_1', 4, 0x4394),
        Register('vr25_16_2', 2, 0x4394),
        Register('vr25_8_4', 1, 0x4394),
        Register('vr25_8_5', 1, 0x4395),
        Register('vr25_16_3', 2, 0x4396),
        Register('vr25_8_6', 1, 0x4396),
        Register('vr25_8_7', 1, 0x4397),
        Register('vr25_64_1', 8, 0x4398),
        Register('vr25_32_2', 4, 0x4398),
        Register('vr25_16_4', 2, 0x4398),
        Register('vr25_8_8', 1, 0x4398),
        Register('vr25_8_9', 1, 0x4399),
        Register('vr25_16_5', 2, 0x439a),
        Register('vr25_8_10', 1, 0x439a),
        Register('vr25_8_11', 1, 0x439b),
        Register('vr25_32_3', 4, 0x439c),
        Register('vr25_16_6', 2, 0x439c),
        Register('vr25_8_12', 1, 0x439c),
        Register('vr25_8_13', 1, 0x439d),
        Register('vr25_16_7', 2, 0x439e),
        Register('vr25_8_14', 1, 0x439e),
        Register('vr25_8_15', 1, 0x439f),
        Register('vs58', 16, 0x43a0),
        Register('vr26_64_0', 8, 0x43a0),
        Register('vr26_32_0', 4, 0x43a0),
        Register('vr26_16_0', 2, 0x43a0),
        Register('vr26_8_0', 1, 0x43a0),
        Register('vr26_8_1', 1, 0x43a1),
        Register('vr26_16_1', 2, 0x43a2),
        Register('vr26_8_2', 1, 0x43a2),
        Register('vr26_8_3', 1, 0x43a3),
        Register('vr26_32_1', 4, 0x43a4),
        Register('vr26_16_2', 2, 0x43a4),
        Register('vr26_8_4', 1, 0x43a4),
        Register('vr26_8_5', 1, 0x43a5),
        Register('vr26_16_3', 2, 0x43a6),
        Register('vr26_8_6', 1, 0x43a6),
        Register('vr26_8_7', 1, 0x43a7),
        Register('vr26_64_1', 8, 0x43a8),
        Register('vr26_32_2', 4, 0x43a8),
        Register('vr26_16_4', 2, 0x43a8),
        Register('vr26_8_8', 1, 0x43a8),
        Register('vr26_8_9', 1, 0x43a9),
        Register('vr26_16_5', 2, 0x43aa),
        Register('vr26_8_10', 1, 0x43aa),
        Register('vr26_8_11', 1, 0x43ab),
        Register('vr26_32_3', 4, 0x43ac),
        Register('vr26_16_6', 2, 0x43ac),
        Register('vr26_8_12', 1, 0x43ac),
        Register('vr26_8_13', 1, 0x43ad),
        Register('vr26_16_7', 2, 0x43ae),
        Register('vr26_8_14', 1, 0x43ae),
        Register('vr26_8_15', 1, 0x43af),
        Register('vs59', 16, 0x43b0),
        Register('vr27_64_0', 8, 0x43b0),
        Register('vr27_32_0', 4, 0x43b0),
        Register('vr27_16_0', 2, 0x43b0),
        Register('vr27_8_0', 1, 0x43b0),
        Register('vr27_8_1', 1, 0x43b1),
        Register('vr27_16_1', 2, 0x43b2),
        Register('vr27_8_2', 1, 0x43b2),
        Register('vr27_8_3', 1, 0x43b3),
        Register('vr27_32_1', 4, 0x43b4),
        Register('vr27_16_2', 2, 0x43b4),
        Register('vr27_8_4', 1, 0x43b4),
        Register('vr27_8_5', 1, 0x43b5),
        Register('vr27_16_3', 2, 0x43b6),
        Register('vr27_8_6', 1, 0x43b6),
        Register('vr27_8_7', 1, 0x43b7),
        Register('vr27_64_1', 8, 0x43b8),
        Register('vr27_32_2', 4, 0x43b8),
        Register('vr27_16_4', 2, 0x43b8),
        Register('vr27_8_8', 1, 0x43b8),
        Register('vr27_8_9', 1, 0x43b9),
        Register('vr27_16_5', 2, 0x43ba),
        Register('vr27_8_10', 1, 0x43ba),
        Register('vr27_8_11', 1, 0x43bb),
        Register('vr27_32_3', 4, 0x43bc),
        Register('vr27_16_6', 2, 0x43bc),
        Register('vr27_8_12', 1, 0x43bc),
        Register('vr27_8_13', 1, 0x43bd),
        Register('vr27_16_7', 2, 0x43be),
        Register('vr27_8_14', 1, 0x43be),
        Register('vr27_8_15', 1, 0x43bf),
        Register('vs60', 16, 0x43c0),
        Register('vr28_64_0', 8, 0x43c0),
        Register('vr28_32_0', 4, 0x43c0),
        Register('vr28_16_0', 2, 0x43c0),
        Register('vr28_8_0', 1, 0x43c0),
        Register('vr28_8_1', 1, 0x43c1),
        Register('vr28_16_1', 2, 0x43c2),
        Register('vr28_8_2', 1, 0x43c2),
        Register('vr28_8_3', 1, 0x43c3),
        Register('vr28_32_1', 4, 0x43c4),
        Register('vr28_16_2', 2, 0x43c4),
        Register('vr28_8_4', 1, 0x43c4),
        Register('vr28_8_5', 1, 0x43c5),
        Register('vr28_16_3', 2, 0x43c6),
        Register('vr28_8_6', 1, 0x43c6),
        Register('vr28_8_7', 1, 0x43c7),
        Register('vr28_64_1', 8, 0x43c8),
        Register('vr28_32_2', 4, 0x43c8),
        Register('vr28_16_4', 2, 0x43c8),
        Register('vr28_8_8', 1, 0x43c8),
        Register('vr28_8_9', 1, 0x43c9),
        Register('vr28_16_5', 2, 0x43ca),
        Register('vr28_8_10', 1, 0x43ca),
        Register('vr28_8_11', 1, 0x43cb),
        Register('vr28_32_3', 4, 0x43cc),
        Register('vr28_16_6', 2, 0x43cc),
        Register('vr28_8_12', 1, 0x43cc),
        Register('vr28_8_13', 1, 0x43cd),
        Register('vr28_16_7', 2, 0x43ce),
        Register('vr28_8_14', 1, 0x43ce),
        Register('vr28_8_15', 1, 0x43cf),
        Register('vs61', 16, 0x43d0),
        Register('vr29_64_0', 8, 0x43d0),
        Register('vr29_32_0', 4, 0x43d0),
        Register('vr29_16_0', 2, 0x43d0),
        Register('vr29_8_0', 1, 0x43d0),
        Register('vr29_8_1', 1, 0x43d1),
        Register('vr29_16_1', 2, 0x43d2),
        Register('vr29_8_2', 1, 0x43d2),
        Register('vr29_8_3', 1, 0x43d3),
        Register('vr29_32_1', 4, 0x43d4),
        Register('vr29_16_2', 2, 0x43d4),
        Register('vr29_8_4', 1, 0x43d4),
        Register('vr29_8_5', 1, 0x43d5),
        Register('vr29_16_3', 2, 0x43d6),
        Register('vr29_8_6', 1, 0x43d6),
        Register('vr29_8_7', 1, 0x43d7),
        Register('vr29_64_1', 8, 0x43d8),
        Register('vr29_32_2', 4, 0x43d8),
        Register('vr29_16_4', 2, 0x43d8),
        Register('vr29_8_8', 1, 0x43d8),
        Register('vr29_8_9', 1, 0x43d9),
        Register('vr29_16_5', 2, 0x43da),
        Register('vr29_8_10', 1, 0x43da),
        Register('vr29_8_11', 1, 0x43db),
        Register('vr29_32_3', 4, 0x43dc),
        Register('vr29_16_6', 2, 0x43dc),
        Register('vr29_8_12', 1, 0x43dc),
        Register('vr29_8_13', 1, 0x43dd),
        Register('vr29_16_7', 2, 0x43de),
        Register('vr29_8_14', 1, 0x43de),
        Register('vr29_8_15', 1, 0x43df),
        Register('vs62', 16, 0x43e0),
        Register('vr30_64_0', 8, 0x43e0),
        Register('vr30_32_0', 4, 0x43e0),
        Register('vr30_16_0', 2, 0x43e0),
        Register('vr30_8_0', 1, 0x43e0),
        Register('vr30_8_1', 1, 0x43e1),
        Register('vr30_16_1', 2, 0x43e2),
        Register('vr30_8_2', 1, 0x43e2),
        Register('vr30_8_3', 1, 0x43e3),
        Register('vr30_32_1', 4, 0x43e4),
        Register('vr30_16_2', 2, 0x43e4),
        Register('vr30_8_4', 1, 0x43e4),
        Register('vr30_8_5', 1, 0x43e5),
        Register('vr30_16_3', 2, 0x43e6),
        Register('vr30_8_6', 1, 0x43e6),
        Register('vr30_8_7', 1, 0x43e7),
        Register('vr30_64_1', 8, 0x43e8),
        Register('vr30_32_2', 4, 0x43e8),
        Register('vr30_16_4', 2, 0x43e8),
        Register('vr30_8_8', 1, 0x43e8),
        Register('vr30_8_9', 1, 0x43e9),
        Register('vr30_16_5', 2, 0x43ea),
        Register('vr30_8_10', 1, 0x43ea),
        Register('vr30_8_11', 1, 0x43eb),
        Register('vr30_32_3', 4, 0x43ec),
        Register('vr30_16_6', 2, 0x43ec),
        Register('vr30_8_12', 1, 0x43ec),
        Register('vr30_8_13', 1, 0x43ed),
        Register('vr30_16_7', 2, 0x43ee),
        Register('vr30_8_14', 1, 0x43ee),
        Register('vr30_8_15', 1, 0x43ef),
        Register('vs63', 16, 0x43f0),
        Register('vr31_64_0', 8, 0x43f0),
        Register('vr31_32_0', 4, 0x43f0),
        Register('vr31_16_0', 2, 0x43f0),
        Register('vr31_8_0', 1, 0x43f0),
        Register('vr31_8_1', 1, 0x43f1),
        Register('vr31_16_1', 2, 0x43f2),
        Register('vr31_8_2', 1, 0x43f2),
        Register('vr31_8_3', 1, 0x43f3),
        Register('vr31_32_1', 4, 0x43f4),
        Register('vr31_16_2', 2, 0x43f4),
        Register('vr31_8_4', 1, 0x43f4),
        Register('vr31_8_5', 1, 0x43f5),
        Register('vr31_16_3', 2, 0x43f6),
        Register('vr31_8_6', 1, 0x43f6),
        Register('vr31_8_7', 1, 0x43f7),
        Register('vr31_64_1', 8, 0x43f8),
        Register('vr31_32_2', 4, 0x43f8),
        Register('vr31_16_4', 2, 0x43f8),
        Register('vr31_8_8', 1, 0x43f8),
        Register('vr31_8_9', 1, 0x43f9),
        Register('vr31_16_5', 2, 0x43fa),
        Register('vr31_8_10', 1, 0x43fa),
        Register('vr31_8_11', 1, 0x43fb),
        Register('vr31_32_3', 4, 0x43fc),
        Register('vr31_16_6', 2, 0x43fc),
        Register('vr31_8_12', 1, 0x43fc),
        Register('vr31_8_13', 1, 0x43fd),
        Register('vr31_16_7', 2, 0x43fe),
        Register('vr31_8_14', 1, 0x43fe),
        Register('vr31_8_15', 1, 0x43ff),
        Register('contextreg', 4, 0x6000),
        Register('dcr000', 8, 0x7000),
        Register('dcr001', 8, 0x7008),
        Register('dcr002', 8, 0x7010),
        Register('dcr003', 8, 0x7018),
        Register('dcr004', 8, 0x7020),
        Register('dcr005', 8, 0x7028),
        Register('dcr006', 8, 0x7030),
        Register('dcr007', 8, 0x7038),
        Register('dcr008', 8, 0x7040),
        Register('dcr009', 8, 0x7048),
        Register('dcr00a', 8, 0x7050),
        Register('dcr00b', 8, 0x7058),
        Register('dcr00c', 8, 0x7060),
        Register('dcr00d', 8, 0x7068),
        Register('dcr00e', 8, 0x7070),
        Register('dcr00f', 8, 0x7078),
        Register('dcr010', 8, 0x7080),
        Register('dcr011', 8, 0x7088),
        Register('dcr012', 8, 0x7090),
        Register('dcr013', 8, 0x7098),
        Register('dcr014', 8, 0x70a0),
        Register('dcr015', 8, 0x70a8),
        Register('dcr016', 8, 0x70b0),
        Register('dcr017', 8, 0x70b8),
        Register('dcr018', 8, 0x70c0),
        Register('dcr019', 8, 0x70c8),
        Register('dcr01a', 8, 0x70d0),
        Register('dcr01b', 8, 0x70d8),
        Register('dcr01c', 8, 0x70e0),
        Register('dcr01d', 8, 0x70e8),
        Register('dcr01e', 8, 0x70f0),
        Register('dcr01f', 8, 0x70f8),
        Register('dcr020', 8, 0x7100),
        Register('dcr021', 8, 0x7108),
        Register('dcr022', 8, 0x7110),
        Register('dcr023', 8, 0x7118),
        Register('dcr024', 8, 0x7120),
        Register('dcr025', 8, 0x7128),
        Register('dcr026', 8, 0x7130),
        Register('dcr027', 8, 0x7138),
        Register('dcr028', 8, 0x7140),
        Register('dcr029', 8, 0x7148),
        Register('dcr02a', 8, 0x7150),
        Register('dcr02b', 8, 0x7158),
        Register('dcr02c', 8, 0x7160),
        Register('dcr02d', 8, 0x7168),
        Register('dcr02e', 8, 0x7170),
        Register('dcr02f', 8, 0x7178),
        Register('dcr030', 8, 0x7180),
        Register('dcr031', 8, 0x7188),
        Register('dcr032', 8, 0x7190),
        Register('dcr033', 8, 0x7198),
        Register('dcr034', 8, 0x71a0),
        Register('dcr035', 8, 0x71a8),
        Register('dcr036', 8, 0x71b0),
        Register('dcr037', 8, 0x71b8),
        Register('dcr038', 8, 0x71c0),
        Register('dcr039', 8, 0x71c8),
        Register('dcr03a', 8, 0x71d0),
        Register('dcr03b', 8, 0x71d8),
        Register('dcr03c', 8, 0x71e0),
        Register('dcr03d', 8, 0x71e8),
        Register('dcr03e', 8, 0x71f0),
        Register('dcr03f', 8, 0x71f8),
        Register('dcr040', 8, 0x7200),
        Register('dcr041', 8, 0x7208),
        Register('dcr042', 8, 0x7210),
        Register('dcr043', 8, 0x7218),
        Register('dcr044', 8, 0x7220),
        Register('dcr045', 8, 0x7228),
        Register('dcr046', 8, 0x7230),
        Register('dcr047', 8, 0x7238),
        Register('dcr048', 8, 0x7240),
        Register('dcr049', 8, 0x7248),
        Register('dcr04a', 8, 0x7250),
        Register('dcr04b', 8, 0x7258),
        Register('dcr04c', 8, 0x7260),
        Register('dcr04d', 8, 0x7268),
        Register('dcr04e', 8, 0x7270),
        Register('dcr04f', 8, 0x7278),
        Register('dcr050', 8, 0x7280),
        Register('dcr051', 8, 0x7288),
        Register('dcr052', 8, 0x7290),
        Register('dcr053', 8, 0x7298),
        Register('dcr054', 8, 0x72a0),
        Register('dcr055', 8, 0x72a8),
        Register('dcr056', 8, 0x72b0),
        Register('dcr057', 8, 0x72b8),
        Register('dcr058', 8, 0x72c0),
        Register('dcr059', 8, 0x72c8),
        Register('dcr05a', 8, 0x72d0),
        Register('dcr05b', 8, 0x72d8),
        Register('dcr05c', 8, 0x72e0),
        Register('dcr05d', 8, 0x72e8),
        Register('dcr05e', 8, 0x72f0),
        Register('dcr05f', 8, 0x72f8),
        Register('dcr060', 8, 0x7300),
        Register('dcr061', 8, 0x7308),
        Register('dcr062', 8, 0x7310),
        Register('dcr063', 8, 0x7318),
        Register('dcr064', 8, 0x7320),
        Register('dcr065', 8, 0x7328),
        Register('dcr066', 8, 0x7330),
        Register('dcr067', 8, 0x7338),
        Register('dcr068', 8, 0x7340),
        Register('dcr069', 8, 0x7348),
        Register('dcr06a', 8, 0x7350),
        Register('dcr06b', 8, 0x7358),
        Register('dcr06c', 8, 0x7360),
        Register('dcr06d', 8, 0x7368),
        Register('dcr06e', 8, 0x7370),
        Register('dcr06f', 8, 0x7378),
        Register('dcr070', 8, 0x7380),
        Register('dcr071', 8, 0x7388),
        Register('dcr072', 8, 0x7390),
        Register('dcr073', 8, 0x7398),
        Register('dcr074', 8, 0x73a0),
        Register('dcr075', 8, 0x73a8),
        Register('dcr076', 8, 0x73b0),
        Register('dcr077', 8, 0x73b8),
        Register('dcr078', 8, 0x73c0),
        Register('dcr079', 8, 0x73c8),
        Register('dcr07a', 8, 0x73d0),
        Register('dcr07b', 8, 0x73d8),
        Register('dcr07c', 8, 0x73e0),
        Register('dcr07d', 8, 0x73e8),
        Register('dcr07e', 8, 0x73f0),
        Register('dcr07f', 8, 0x73f8),
        Register('dcr080', 8, 0x7400),
        Register('dcr081', 8, 0x7408),
        Register('dcr082', 8, 0x7410),
        Register('dcr083', 8, 0x7418),
        Register('dcr084', 8, 0x7420),
        Register('dcr085', 8, 0x7428),
        Register('dcr086', 8, 0x7430),
        Register('dcr087', 8, 0x7438),
        Register('dcr088', 8, 0x7440),
        Register('dcr089', 8, 0x7448),
        Register('dcr08a', 8, 0x7450),
        Register('dcr08b', 8, 0x7458),
        Register('dcr08c', 8, 0x7460),
        Register('dcr08d', 8, 0x7468),
        Register('dcr08e', 8, 0x7470),
        Register('dcr08f', 8, 0x7478),
        Register('dcr090', 8, 0x7480),
        Register('dcr091', 8, 0x7488),
        Register('dcr092', 8, 0x7490),
        Register('dcr093', 8, 0x7498),
        Register('dcr094', 8, 0x74a0),
        Register('dcr095', 8, 0x74a8),
        Register('dcr096', 8, 0x74b0),
        Register('dcr097', 8, 0x74b8),
        Register('dcr098', 8, 0x74c0),
        Register('dcr099', 8, 0x74c8),
        Register('dcr09a', 8, 0x74d0),
        Register('dcr09b', 8, 0x74d8),
        Register('dcr09c', 8, 0x74e0),
        Register('dcr09d', 8, 0x74e8),
        Register('dcr09e', 8, 0x74f0),
        Register('dcr09f', 8, 0x74f8),
        Register('dcr0a0', 8, 0x7500),
        Register('dcr0a1', 8, 0x7508),
        Register('dcr0a2', 8, 0x7510),
        Register('dcr0a3', 8, 0x7518),
        Register('dcr0a4', 8, 0x7520),
        Register('dcr0a5', 8, 0x7528),
        Register('dcr0a6', 8, 0x7530),
        Register('dcr0a7', 8, 0x7538),
        Register('dcr0a8', 8, 0x7540),
        Register('dcr0a9', 8, 0x7548),
        Register('dcr0aa', 8, 0x7550),
        Register('dcr0ab', 8, 0x7558),
        Register('dcr0ac', 8, 0x7560),
        Register('dcr0ad', 8, 0x7568),
        Register('dcr0ae', 8, 0x7570),
        Register('dcr0af', 8, 0x7578),
        Register('dcr0b0', 8, 0x7580),
        Register('dcr0b1', 8, 0x7588),
        Register('dcr0b2', 8, 0x7590),
        Register('dcr0b3', 8, 0x7598),
        Register('dcr0b4', 8, 0x75a0),
        Register('dcr0b5', 8, 0x75a8),
        Register('dcr0b6', 8, 0x75b0),
        Register('dcr0b7', 8, 0x75b8),
        Register('dcr0b8', 8, 0x75c0),
        Register('dcr0b9', 8, 0x75c8),
        Register('dcr0ba', 8, 0x75d0),
        Register('dcr0bb', 8, 0x75d8),
        Register('dcr0bc', 8, 0x75e0),
        Register('dcr0bd', 8, 0x75e8),
        Register('dcr0be', 8, 0x75f0),
        Register('dcr0bf', 8, 0x75f8),
        Register('dcr0c0', 8, 0x7600),
        Register('dcr0c1', 8, 0x7608),
        Register('dcr0c2', 8, 0x7610),
        Register('dcr0c3', 8, 0x7618),
        Register('dcr0c4', 8, 0x7620),
        Register('dcr0c5', 8, 0x7628),
        Register('dcr0c6', 8, 0x7630),
        Register('dcr0c7', 8, 0x7638),
        Register('dcr0c8', 8, 0x7640),
        Register('dcr0c9', 8, 0x7648),
        Register('dcr0ca', 8, 0x7650),
        Register('dcr0cb', 8, 0x7658),
        Register('dcr0cc', 8, 0x7660),
        Register('dcr0cd', 8, 0x7668),
        Register('dcr0ce', 8, 0x7670),
        Register('dcr0cf', 8, 0x7678),
        Register('dcr0d0', 8, 0x7680),
        Register('dcr0d1', 8, 0x7688),
        Register('dcr0d2', 8, 0x7690),
        Register('dcr0d3', 8, 0x7698),
        Register('dcr0d4', 8, 0x76a0),
        Register('dcr0d5', 8, 0x76a8),
        Register('dcr0d6', 8, 0x76b0),
        Register('dcr0d7', 8, 0x76b8),
        Register('dcr0d8', 8, 0x76c0),
        Register('dcr0d9', 8, 0x76c8),
        Register('dcr0da', 8, 0x76d0),
        Register('dcr0db', 8, 0x76d8),
        Register('dcr0dc', 8, 0x76e0),
        Register('dcr0dd', 8, 0x76e8),
        Register('dcr0de', 8, 0x76f0),
        Register('dcr0df', 8, 0x76f8),
        Register('dcr0e0', 8, 0x7700),
        Register('dcr0e1', 8, 0x7708),
        Register('dcr0e2', 8, 0x7710),
        Register('dcr0e3', 8, 0x7718),
        Register('dcr0e4', 8, 0x7720),
        Register('dcr0e5', 8, 0x7728),
        Register('dcr0e6', 8, 0x7730),
        Register('dcr0e7', 8, 0x7738),
        Register('dcr0e8', 8, 0x7740),
        Register('dcr0e9', 8, 0x7748),
        Register('dcr0ea', 8, 0x7750),
        Register('dcr0eb', 8, 0x7758),
        Register('dcr0ec', 8, 0x7760),
        Register('dcr0ed', 8, 0x7768),
        Register('dcr0ee', 8, 0x7770),
        Register('dcr0ef', 8, 0x7778),
        Register('dcr0f0', 8, 0x7780),
        Register('dcr0f1', 8, 0x7788),
        Register('dcr0f2', 8, 0x7790),
        Register('dcr0f3', 8, 0x7798),
        Register('dcr0f4', 8, 0x77a0),
        Register('dcr0f5', 8, 0x77a8),
        Register('dcr0f6', 8, 0x77b0),
        Register('dcr0f7', 8, 0x77b8),
        Register('dcr0f8', 8, 0x77c0),
        Register('dcr0f9', 8, 0x77c8),
        Register('dcr0fa', 8, 0x77d0),
        Register('dcr0fb', 8, 0x77d8),
        Register('dcr0fc', 8, 0x77e0),
        Register('dcr0fd', 8, 0x77e8),
        Register('dcr0fe', 8, 0x77f0),
        Register('dcr0ff', 8, 0x77f8),
        Register('dcr100', 8, 0x7800),
        Register('dcr101', 8, 0x7808),
        Register('dcr102', 8, 0x7810),
        Register('dcr103', 8, 0x7818),
        Register('dcr104', 8, 0x7820),
        Register('dcr105', 8, 0x7828),
        Register('dcr106', 8, 0x7830),
        Register('dcr107', 8, 0x7838),
        Register('dcr108', 8, 0x7840),
        Register('dcr109', 8, 0x7848),
        Register('dcr10a', 8, 0x7850),
        Register('dcr10b', 8, 0x7858),
        Register('dcr10c', 8, 0x7860),
        Register('dcr10d', 8, 0x7868),
        Register('dcr10e', 8, 0x7870),
        Register('dcr10f', 8, 0x7878),
        Register('dcr110', 8, 0x7880),
        Register('dcr111', 8, 0x7888),
        Register('dcr112', 8, 0x7890),
        Register('dcr113', 8, 0x7898),
        Register('dcr114', 8, 0x78a0),
        Register('dcr115', 8, 0x78a8),
        Register('dcr116', 8, 0x78b0),
        Register('dcr117', 8, 0x78b8),
        Register('dcr118', 8, 0x78c0),
        Register('dcr119', 8, 0x78c8),
        Register('dcr11a', 8, 0x78d0),
        Register('dcr11b', 8, 0x78d8),
        Register('dcr11c', 8, 0x78e0),
        Register('dcr11d', 8, 0x78e8),
        Register('dcr11e', 8, 0x78f0),
        Register('dcr11f', 8, 0x78f8),
        Register('dcr120', 8, 0x7900),
        Register('dcr121', 8, 0x7908),
        Register('dcr122', 8, 0x7910),
        Register('dcr123', 8, 0x7918),
        Register('dcr124', 8, 0x7920),
        Register('dcr125', 8, 0x7928),
        Register('dcr126', 8, 0x7930),
        Register('dcr127', 8, 0x7938),
        Register('dcr128', 8, 0x7940),
        Register('dcr129', 8, 0x7948),
        Register('dcr12a', 8, 0x7950),
        Register('dcr12b', 8, 0x7958),
        Register('dcr12c', 8, 0x7960),
        Register('dcr12d', 8, 0x7968),
        Register('dcr12e', 8, 0x7970),
        Register('dcr12f', 8, 0x7978),
        Register('dcr130', 8, 0x7980),
        Register('dcr131', 8, 0x7988),
        Register('dcr132', 8, 0x7990),
        Register('dcr133', 8, 0x7998),
        Register('dcr134', 8, 0x79a0),
        Register('dcr135', 8, 0x79a8),
        Register('dcr136', 8, 0x79b0),
        Register('dcr137', 8, 0x79b8),
        Register('dcr138', 8, 0x79c0),
        Register('dcr139', 8, 0x79c8),
        Register('dcr13a', 8, 0x79d0),
        Register('dcr13b', 8, 0x79d8),
        Register('dcr13c', 8, 0x79e0),
        Register('dcr13d', 8, 0x79e8),
        Register('dcr13e', 8, 0x79f0),
        Register('dcr13f', 8, 0x79f8),
        Register('dcr140', 8, 0x7a00),
        Register('dcr141', 8, 0x7a08),
        Register('dcr142', 8, 0x7a10),
        Register('dcr143', 8, 0x7a18),
        Register('dcr144', 8, 0x7a20),
        Register('dcr145', 8, 0x7a28),
        Register('dcr146', 8, 0x7a30),
        Register('dcr147', 8, 0x7a38),
        Register('dcr148', 8, 0x7a40),
        Register('dcr149', 8, 0x7a48),
        Register('dcr14a', 8, 0x7a50),
        Register('dcr14b', 8, 0x7a58),
        Register('dcr14c', 8, 0x7a60),
        Register('dcr14d', 8, 0x7a68),
        Register('dcr14e', 8, 0x7a70),
        Register('dcr14f', 8, 0x7a78),
        Register('dcr150', 8, 0x7a80),
        Register('dcr151', 8, 0x7a88),
        Register('dcr152', 8, 0x7a90),
        Register('dcr153', 8, 0x7a98),
        Register('dcr154', 8, 0x7aa0),
        Register('dcr155', 8, 0x7aa8),
        Register('dcr156', 8, 0x7ab0),
        Register('dcr157', 8, 0x7ab8),
        Register('dcr158', 8, 0x7ac0),
        Register('dcr159', 8, 0x7ac8),
        Register('dcr15a', 8, 0x7ad0),
        Register('dcr15b', 8, 0x7ad8),
        Register('dcr15c', 8, 0x7ae0),
        Register('dcr15d', 8, 0x7ae8),
        Register('dcr15e', 8, 0x7af0),
        Register('dcr15f', 8, 0x7af8),
        Register('dcr160', 8, 0x7b00),
        Register('dcr161', 8, 0x7b08),
        Register('dcr162', 8, 0x7b10),
        Register('dcr163', 8, 0x7b18),
        Register('dcr164', 8, 0x7b20),
        Register('dcr165', 8, 0x7b28),
        Register('dcr166', 8, 0x7b30),
        Register('dcr167', 8, 0x7b38),
        Register('dcr168', 8, 0x7b40),
        Register('dcr169', 8, 0x7b48),
        Register('dcr16a', 8, 0x7b50),
        Register('dcr16b', 8, 0x7b58),
        Register('dcr16c', 8, 0x7b60),
        Register('dcr16d', 8, 0x7b68),
        Register('dcr16e', 8, 0x7b70),
        Register('dcr16f', 8, 0x7b78),
        Register('dcr170', 8, 0x7b80),
        Register('dcr171', 8, 0x7b88),
        Register('dcr172', 8, 0x7b90),
        Register('dcr173', 8, 0x7b98),
        Register('dcr174', 8, 0x7ba0),
        Register('dcr175', 8, 0x7ba8),
        Register('dcr176', 8, 0x7bb0),
        Register('dcr177', 8, 0x7bb8),
        Register('dcr178', 8, 0x7bc0),
        Register('dcr179', 8, 0x7bc8),
        Register('dcr17a', 8, 0x7bd0),
        Register('dcr17b', 8, 0x7bd8),
        Register('dcr17c', 8, 0x7be0),
        Register('dcr17d', 8, 0x7be8),
        Register('dcr17e', 8, 0x7bf0),
        Register('dcr17f', 8, 0x7bf8),
        Register('dcr180', 8, 0x7c00),
        Register('dcr181', 8, 0x7c08),
        Register('dcr182', 8, 0x7c10),
        Register('dcr183', 8, 0x7c18),
        Register('dcr184', 8, 0x7c20),
        Register('dcr185', 8, 0x7c28),
        Register('dcr186', 8, 0x7c30),
        Register('dcr187', 8, 0x7c38),
        Register('dcr188', 8, 0x7c40),
        Register('dcr189', 8, 0x7c48),
        Register('dcr18a', 8, 0x7c50),
        Register('dcr18b', 8, 0x7c58),
        Register('dcr18c', 8, 0x7c60),
        Register('dcr18d', 8, 0x7c68),
        Register('dcr18e', 8, 0x7c70),
        Register('dcr18f', 8, 0x7c78),
        Register('dcr190', 8, 0x7c80),
        Register('dcr191', 8, 0x7c88),
        Register('dcr192', 8, 0x7c90),
        Register('dcr193', 8, 0x7c98),
        Register('dcr194', 8, 0x7ca0),
        Register('dcr195', 8, 0x7ca8),
        Register('dcr196', 8, 0x7cb0),
        Register('dcr197', 8, 0x7cb8),
        Register('dcr198', 8, 0x7cc0),
        Register('dcr199', 8, 0x7cc8),
        Register('dcr19a', 8, 0x7cd0),
        Register('dcr19b', 8, 0x7cd8),
        Register('dcr19c', 8, 0x7ce0),
        Register('dcr19d', 8, 0x7ce8),
        Register('dcr19e', 8, 0x7cf0),
        Register('dcr19f', 8, 0x7cf8),
        Register('dcr1a0', 8, 0x7d00),
        Register('dcr1a1', 8, 0x7d08),
        Register('dcr1a2', 8, 0x7d10),
        Register('dcr1a3', 8, 0x7d18),
        Register('dcr1a4', 8, 0x7d20),
        Register('dcr1a5', 8, 0x7d28),
        Register('dcr1a6', 8, 0x7d30),
        Register('dcr1a7', 8, 0x7d38),
        Register('dcr1a8', 8, 0x7d40),
        Register('dcr1a9', 8, 0x7d48),
        Register('dcr1aa', 8, 0x7d50),
        Register('dcr1ab', 8, 0x7d58),
        Register('dcr1ac', 8, 0x7d60),
        Register('dcr1ad', 8, 0x7d68),
        Register('dcr1ae', 8, 0x7d70),
        Register('dcr1af', 8, 0x7d78),
        Register('dcr1b0', 8, 0x7d80),
        Register('dcr1b1', 8, 0x7d88),
        Register('dcr1b2', 8, 0x7d90),
        Register('dcr1b3', 8, 0x7d98),
        Register('dcr1b4', 8, 0x7da0),
        Register('dcr1b5', 8, 0x7da8),
        Register('dcr1b6', 8, 0x7db0),
        Register('dcr1b7', 8, 0x7db8),
        Register('dcr1b8', 8, 0x7dc0),
        Register('dcr1b9', 8, 0x7dc8),
        Register('dcr1ba', 8, 0x7dd0),
        Register('dcr1bb', 8, 0x7dd8),
        Register('dcr1bc', 8, 0x7de0),
        Register('dcr1bd', 8, 0x7de8),
        Register('dcr1be', 8, 0x7df0),
        Register('dcr1bf', 8, 0x7df8),
        Register('dcr1c0', 8, 0x7e00),
        Register('dcr1c1', 8, 0x7e08),
        Register('dcr1c2', 8, 0x7e10),
        Register('dcr1c3', 8, 0x7e18),
        Register('dcr1c4', 8, 0x7e20),
        Register('dcr1c5', 8, 0x7e28),
        Register('dcr1c6', 8, 0x7e30),
        Register('dcr1c7', 8, 0x7e38),
        Register('dcr1c8', 8, 0x7e40),
        Register('dcr1c9', 8, 0x7e48),
        Register('dcr1ca', 8, 0x7e50),
        Register('dcr1cb', 8, 0x7e58),
        Register('dcr1cc', 8, 0x7e60),
        Register('dcr1cd', 8, 0x7e68),
        Register('dcr1ce', 8, 0x7e70),
        Register('dcr1cf', 8, 0x7e78),
        Register('dcr1d0', 8, 0x7e80),
        Register('dcr1d1', 8, 0x7e88),
        Register('dcr1d2', 8, 0x7e90),
        Register('dcr1d3', 8, 0x7e98),
        Register('dcr1d4', 8, 0x7ea0),
        Register('dcr1d5', 8, 0x7ea8),
        Register('dcr1d6', 8, 0x7eb0),
        Register('dcr1d7', 8, 0x7eb8),
        Register('dcr1d8', 8, 0x7ec0),
        Register('dcr1d9', 8, 0x7ec8),
        Register('dcr1da', 8, 0x7ed0),
        Register('dcr1db', 8, 0x7ed8),
        Register('dcr1dc', 8, 0x7ee0),
        Register('dcr1dd', 8, 0x7ee8),
        Register('dcr1de', 8, 0x7ef0),
        Register('dcr1df', 8, 0x7ef8),
        Register('dcr1e0', 8, 0x7f00),
        Register('dcr1e1', 8, 0x7f08),
        Register('dcr1e2', 8, 0x7f10),
        Register('dcr1e3', 8, 0x7f18),
        Register('dcr1e4', 8, 0x7f20),
        Register('dcr1e5', 8, 0x7f28),
        Register('dcr1e6', 8, 0x7f30),
        Register('dcr1e7', 8, 0x7f38),
        Register('dcr1e8', 8, 0x7f40),
        Register('dcr1e9', 8, 0x7f48),
        Register('dcr1ea', 8, 0x7f50),
        Register('dcr1eb', 8, 0x7f58),
        Register('dcr1ec', 8, 0x7f60),
        Register('dcr1ed', 8, 0x7f68),
        Register('dcr1ee', 8, 0x7f70),
        Register('dcr1ef', 8, 0x7f78),
        Register('dcr1f0', 8, 0x7f80),
        Register('dcr1f1', 8, 0x7f88),
        Register('dcr1f2', 8, 0x7f90),
        Register('dcr1f3', 8, 0x7f98),
        Register('dcr1f4', 8, 0x7fa0),
        Register('dcr1f5', 8, 0x7fa8),
        Register('dcr1f6', 8, 0x7fb0),
        Register('dcr1f7', 8, 0x7fb8),
        Register('dcr1f8', 8, 0x7fc0),
        Register('dcr1f9', 8, 0x7fc8),
        Register('dcr1fa', 8, 0x7fd0),
        Register('dcr1fb', 8, 0x7fd8),
        Register('dcr1fc', 8, 0x7fe0),
        Register('dcr1fd', 8, 0x7fe8),
        Register('dcr1fe', 8, 0x7ff0),
        Register('dcr1ff', 8, 0x7ff8),
        Register('dcr200', 8, 0x8000),
        Register('dcr201', 8, 0x8008),
        Register('dcr202', 8, 0x8010),
        Register('dcr203', 8, 0x8018),
        Register('dcr204', 8, 0x8020),
        Register('dcr205', 8, 0x8028),
        Register('dcr206', 8, 0x8030),
        Register('dcr207', 8, 0x8038),
        Register('dcr208', 8, 0x8040),
        Register('dcr209', 8, 0x8048),
        Register('dcr20a', 8, 0x8050),
        Register('dcr20b', 8, 0x8058),
        Register('dcr20c', 8, 0x8060),
        Register('dcr20d', 8, 0x8068),
        Register('dcr20e', 8, 0x8070),
        Register('dcr20f', 8, 0x8078),
        Register('dcr210', 8, 0x8080),
        Register('dcr211', 8, 0x8088),
        Register('dcr212', 8, 0x8090),
        Register('dcr213', 8, 0x8098),
        Register('dcr214', 8, 0x80a0),
        Register('dcr215', 8, 0x80a8),
        Register('dcr216', 8, 0x80b0),
        Register('dcr217', 8, 0x80b8),
        Register('dcr218', 8, 0x80c0),
        Register('dcr219', 8, 0x80c8),
        Register('dcr21a', 8, 0x80d0),
        Register('dcr21b', 8, 0x80d8),
        Register('dcr21c', 8, 0x80e0),
        Register('dcr21d', 8, 0x80e8),
        Register('dcr21e', 8, 0x80f0),
        Register('dcr21f', 8, 0x80f8),
        Register('dcr220', 8, 0x8100),
        Register('dcr221', 8, 0x8108),
        Register('dcr222', 8, 0x8110),
        Register('dcr223', 8, 0x8118),
        Register('dcr224', 8, 0x8120),
        Register('dcr225', 8, 0x8128),
        Register('dcr226', 8, 0x8130),
        Register('dcr227', 8, 0x8138),
        Register('dcr228', 8, 0x8140),
        Register('dcr229', 8, 0x8148),
        Register('dcr22a', 8, 0x8150),
        Register('dcr22b', 8, 0x8158),
        Register('dcr22c', 8, 0x8160),
        Register('dcr22d', 8, 0x8168),
        Register('dcr22e', 8, 0x8170),
        Register('dcr22f', 8, 0x8178),
        Register('dcr230', 8, 0x8180),
        Register('dcr231', 8, 0x8188),
        Register('dcr232', 8, 0x8190),
        Register('dcr233', 8, 0x8198),
        Register('dcr234', 8, 0x81a0),
        Register('dcr235', 8, 0x81a8),
        Register('dcr236', 8, 0x81b0),
        Register('dcr237', 8, 0x81b8),
        Register('dcr238', 8, 0x81c0),
        Register('dcr239', 8, 0x81c8),
        Register('dcr23a', 8, 0x81d0),
        Register('dcr23b', 8, 0x81d8),
        Register('dcr23c', 8, 0x81e0),
        Register('dcr23d', 8, 0x81e8),
        Register('dcr23e', 8, 0x81f0),
        Register('dcr23f', 8, 0x81f8),
        Register('dcr240', 8, 0x8200),
        Register('dcr241', 8, 0x8208),
        Register('dcr242', 8, 0x8210),
        Register('dcr243', 8, 0x8218),
        Register('dcr244', 8, 0x8220),
        Register('dcr245', 8, 0x8228),
        Register('dcr246', 8, 0x8230),
        Register('dcr247', 8, 0x8238),
        Register('dcr248', 8, 0x8240),
        Register('dcr249', 8, 0x8248),
        Register('dcr24a', 8, 0x8250),
        Register('dcr24b', 8, 0x8258),
        Register('dcr24c', 8, 0x8260),
        Register('dcr24d', 8, 0x8268),
        Register('dcr24e', 8, 0x8270),
        Register('dcr24f', 8, 0x8278),
        Register('dcr250', 8, 0x8280),
        Register('dcr251', 8, 0x8288),
        Register('dcr252', 8, 0x8290),
        Register('dcr253', 8, 0x8298),
        Register('dcr254', 8, 0x82a0),
        Register('dcr255', 8, 0x82a8),
        Register('dcr256', 8, 0x82b0),
        Register('dcr257', 8, 0x82b8),
        Register('dcr258', 8, 0x82c0),
        Register('dcr259', 8, 0x82c8),
        Register('dcr25a', 8, 0x82d0),
        Register('dcr25b', 8, 0x82d8),
        Register('dcr25c', 8, 0x82e0),
        Register('dcr25d', 8, 0x82e8),
        Register('dcr25e', 8, 0x82f0),
        Register('dcr25f', 8, 0x82f8),
        Register('dcr260', 8, 0x8300),
        Register('dcr261', 8, 0x8308),
        Register('dcr262', 8, 0x8310),
        Register('dcr263', 8, 0x8318),
        Register('dcr264', 8, 0x8320),
        Register('dcr265', 8, 0x8328),
        Register('dcr266', 8, 0x8330),
        Register('dcr267', 8, 0x8338),
        Register('dcr268', 8, 0x8340),
        Register('dcr269', 8, 0x8348),
        Register('dcr26a', 8, 0x8350),
        Register('dcr26b', 8, 0x8358),
        Register('dcr26c', 8, 0x8360),
        Register('dcr26d', 8, 0x8368),
        Register('dcr26e', 8, 0x8370),
        Register('dcr26f', 8, 0x8378),
        Register('dcr270', 8, 0x8380),
        Register('dcr271', 8, 0x8388),
        Register('dcr272', 8, 0x8390),
        Register('dcr273', 8, 0x8398),
        Register('dcr274', 8, 0x83a0),
        Register('dcr275', 8, 0x83a8),
        Register('dcr276', 8, 0x83b0),
        Register('dcr277', 8, 0x83b8),
        Register('dcr278', 8, 0x83c0),
        Register('dcr279', 8, 0x83c8),
        Register('dcr27a', 8, 0x83d0),
        Register('dcr27b', 8, 0x83d8),
        Register('dcr27c', 8, 0x83e0),
        Register('dcr27d', 8, 0x83e8),
        Register('dcr27e', 8, 0x83f0),
        Register('dcr27f', 8, 0x83f8),
        Register('dcr280', 8, 0x8400),
        Register('dcr281', 8, 0x8408),
        Register('dcr282', 8, 0x8410),
        Register('dcr283', 8, 0x8418),
        Register('dcr284', 8, 0x8420),
        Register('dcr285', 8, 0x8428),
        Register('dcr286', 8, 0x8430),
        Register('dcr287', 8, 0x8438),
        Register('dcr288', 8, 0x8440),
        Register('dcr289', 8, 0x8448),
        Register('dcr28a', 8, 0x8450),
        Register('dcr28b', 8, 0x8458),
        Register('dcr28c', 8, 0x8460),
        Register('dcr28d', 8, 0x8468),
        Register('dcr28e', 8, 0x8470),
        Register('dcr28f', 8, 0x8478),
        Register('dcr290', 8, 0x8480),
        Register('dcr291', 8, 0x8488),
        Register('dcr292', 8, 0x8490),
        Register('dcr293', 8, 0x8498),
        Register('dcr294', 8, 0x84a0),
        Register('dcr295', 8, 0x84a8),
        Register('dcr296', 8, 0x84b0),
        Register('dcr297', 8, 0x84b8),
        Register('dcr298', 8, 0x84c0),
        Register('dcr299', 8, 0x84c8),
        Register('dcr29a', 8, 0x84d0),
        Register('dcr29b', 8, 0x84d8),
        Register('dcr29c', 8, 0x84e0),
        Register('dcr29d', 8, 0x84e8),
        Register('dcr29e', 8, 0x84f0),
        Register('dcr29f', 8, 0x84f8),
        Register('dcr2a0', 8, 0x8500),
        Register('dcr2a1', 8, 0x8508),
        Register('dcr2a2', 8, 0x8510),
        Register('dcr2a3', 8, 0x8518),
        Register('dcr2a4', 8, 0x8520),
        Register('dcr2a5', 8, 0x8528),
        Register('dcr2a6', 8, 0x8530),
        Register('dcr2a7', 8, 0x8538),
        Register('dcr2a8', 8, 0x8540),
        Register('dcr2a9', 8, 0x8548),
        Register('dcr2aa', 8, 0x8550),
        Register('dcr2ab', 8, 0x8558),
        Register('dcr2ac', 8, 0x8560),
        Register('dcr2ad', 8, 0x8568),
        Register('dcr2ae', 8, 0x8570),
        Register('dcr2af', 8, 0x8578),
        Register('dcr2b0', 8, 0x8580),
        Register('dcr2b1', 8, 0x8588),
        Register('dcr2b2', 8, 0x8590),
        Register('dcr2b3', 8, 0x8598),
        Register('dcr2b4', 8, 0x85a0),
        Register('dcr2b5', 8, 0x85a8),
        Register('dcr2b6', 8, 0x85b0),
        Register('dcr2b7', 8, 0x85b8),
        Register('dcr2b8', 8, 0x85c0),
        Register('dcr2b9', 8, 0x85c8),
        Register('dcr2ba', 8, 0x85d0),
        Register('dcr2bb', 8, 0x85d8),
        Register('dcr2bc', 8, 0x85e0),
        Register('dcr2bd', 8, 0x85e8),
        Register('dcr2be', 8, 0x85f0),
        Register('dcr2bf', 8, 0x85f8),
        Register('dcr2c0', 8, 0x8600),
        Register('dcr2c1', 8, 0x8608),
        Register('dcr2c2', 8, 0x8610),
        Register('dcr2c3', 8, 0x8618),
        Register('dcr2c4', 8, 0x8620),
        Register('dcr2c5', 8, 0x8628),
        Register('dcr2c6', 8, 0x8630),
        Register('dcr2c7', 8, 0x8638),
        Register('dcr2c8', 8, 0x8640),
        Register('dcr2c9', 8, 0x8648),
        Register('dcr2ca', 8, 0x8650),
        Register('dcr2cb', 8, 0x8658),
        Register('dcr2cc', 8, 0x8660),
        Register('dcr2cd', 8, 0x8668),
        Register('dcr2ce', 8, 0x8670),
        Register('dcr2cf', 8, 0x8678),
        Register('dcr2d0', 8, 0x8680),
        Register('dcr2d1', 8, 0x8688),
        Register('dcr2d2', 8, 0x8690),
        Register('dcr2d3', 8, 0x8698),
        Register('dcr2d4', 8, 0x86a0),
        Register('dcr2d5', 8, 0x86a8),
        Register('dcr2d6', 8, 0x86b0),
        Register('dcr2d7', 8, 0x86b8),
        Register('dcr2d8', 8, 0x86c0),
        Register('dcr2d9', 8, 0x86c8),
        Register('dcr2da', 8, 0x86d0),
        Register('dcr2db', 8, 0x86d8),
        Register('dcr2dc', 8, 0x86e0),
        Register('dcr2dd', 8, 0x86e8),
        Register('dcr2de', 8, 0x86f0),
        Register('dcr2df', 8, 0x86f8),
        Register('dcr2e0', 8, 0x8700),
        Register('dcr2e1', 8, 0x8708),
        Register('dcr2e2', 8, 0x8710),
        Register('dcr2e3', 8, 0x8718),
        Register('dcr2e4', 8, 0x8720),
        Register('dcr2e5', 8, 0x8728),
        Register('dcr2e6', 8, 0x8730),
        Register('dcr2e7', 8, 0x8738),
        Register('dcr2e8', 8, 0x8740),
        Register('dcr2e9', 8, 0x8748),
        Register('dcr2ea', 8, 0x8750),
        Register('dcr2eb', 8, 0x8758),
        Register('dcr2ec', 8, 0x8760),
        Register('dcr2ed', 8, 0x8768),
        Register('dcr2ee', 8, 0x8770),
        Register('dcr2ef', 8, 0x8778),
        Register('dcr2f0', 8, 0x8780),
        Register('dcr2f1', 8, 0x8788),
        Register('dcr2f2', 8, 0x8790),
        Register('dcr2f3', 8, 0x8798),
        Register('dcr2f4', 8, 0x87a0),
        Register('dcr2f5', 8, 0x87a8),
        Register('dcr2f6', 8, 0x87b0),
        Register('dcr2f7', 8, 0x87b8),
        Register('dcr2f8', 8, 0x87c0),
        Register('dcr2f9', 8, 0x87c8),
        Register('dcr2fa', 8, 0x87d0),
        Register('dcr2fb', 8, 0x87d8),
        Register('dcr2fc', 8, 0x87e0),
        Register('dcr2fd', 8, 0x87e8),
        Register('dcr2fe', 8, 0x87f0),
        Register('dcr2ff', 8, 0x87f8),
        Register('dcr300', 8, 0x8800),
        Register('dcr301', 8, 0x8808),
        Register('dcr302', 8, 0x8810),
        Register('dcr303', 8, 0x8818),
        Register('dcr304', 8, 0x8820),
        Register('dcr305', 8, 0x8828),
        Register('dcr306', 8, 0x8830),
        Register('dcr307', 8, 0x8838),
        Register('dcr308', 8, 0x8840),
        Register('dcr309', 8, 0x8848),
        Register('dcr30a', 8, 0x8850),
        Register('dcr30b', 8, 0x8858),
        Register('dcr30c', 8, 0x8860),
        Register('dcr30d', 8, 0x8868),
        Register('dcr30e', 8, 0x8870),
        Register('dcr30f', 8, 0x8878),
        Register('dcr310', 8, 0x8880),
        Register('dcr311', 8, 0x8888),
        Register('dcr312', 8, 0x8890),
        Register('dcr313', 8, 0x8898),
        Register('dcr314', 8, 0x88a0),
        Register('dcr315', 8, 0x88a8),
        Register('dcr316', 8, 0x88b0),
        Register('dcr317', 8, 0x88b8),
        Register('dcr318', 8, 0x88c0),
        Register('dcr319', 8, 0x88c8),
        Register('dcr31a', 8, 0x88d0),
        Register('dcr31b', 8, 0x88d8),
        Register('dcr31c', 8, 0x88e0),
        Register('dcr31d', 8, 0x88e8),
        Register('dcr31e', 8, 0x88f0),
        Register('dcr31f', 8, 0x88f8),
        Register('dcr320', 8, 0x8900),
        Register('dcr321', 8, 0x8908),
        Register('dcr322', 8, 0x8910),
        Register('dcr323', 8, 0x8918),
        Register('dcr324', 8, 0x8920),
        Register('dcr325', 8, 0x8928),
        Register('dcr326', 8, 0x8930),
        Register('dcr327', 8, 0x8938),
        Register('dcr328', 8, 0x8940),
        Register('dcr329', 8, 0x8948),
        Register('dcr32a', 8, 0x8950),
        Register('dcr32b', 8, 0x8958),
        Register('dcr32c', 8, 0x8960),
        Register('dcr32d', 8, 0x8968),
        Register('dcr32e', 8, 0x8970),
        Register('dcr32f', 8, 0x8978),
        Register('dcr330', 8, 0x8980),
        Register('dcr331', 8, 0x8988),
        Register('dcr332', 8, 0x8990),
        Register('dcr333', 8, 0x8998),
        Register('dcr334', 8, 0x89a0),
        Register('dcr335', 8, 0x89a8),
        Register('dcr336', 8, 0x89b0),
        Register('dcr337', 8, 0x89b8),
        Register('dcr338', 8, 0x89c0),
        Register('dcr339', 8, 0x89c8),
        Register('dcr33a', 8, 0x89d0),
        Register('dcr33b', 8, 0x89d8),
        Register('dcr33c', 8, 0x89e0),
        Register('dcr33d', 8, 0x89e8),
        Register('dcr33e', 8, 0x89f0),
        Register('dcr33f', 8, 0x89f8),
        Register('dcr340', 8, 0x8a00),
        Register('dcr341', 8, 0x8a08),
        Register('dcr342', 8, 0x8a10),
        Register('dcr343', 8, 0x8a18),
        Register('dcr344', 8, 0x8a20),
        Register('dcr345', 8, 0x8a28),
        Register('dcr346', 8, 0x8a30),
        Register('dcr347', 8, 0x8a38),
        Register('dcr348', 8, 0x8a40),
        Register('dcr349', 8, 0x8a48),
        Register('dcr34a', 8, 0x8a50),
        Register('dcr34b', 8, 0x8a58),
        Register('dcr34c', 8, 0x8a60),
        Register('dcr34d', 8, 0x8a68),
        Register('dcr34e', 8, 0x8a70),
        Register('dcr34f', 8, 0x8a78),
        Register('dcr350', 8, 0x8a80),
        Register('dcr351', 8, 0x8a88),
        Register('dcr352', 8, 0x8a90),
        Register('dcr353', 8, 0x8a98),
        Register('dcr354', 8, 0x8aa0),
        Register('dcr355', 8, 0x8aa8),
        Register('dcr356', 8, 0x8ab0),
        Register('dcr357', 8, 0x8ab8),
        Register('dcr358', 8, 0x8ac0),
        Register('dcr359', 8, 0x8ac8),
        Register('dcr35a', 8, 0x8ad0),
        Register('dcr35b', 8, 0x8ad8),
        Register('dcr35c', 8, 0x8ae0),
        Register('dcr35d', 8, 0x8ae8),
        Register('dcr35e', 8, 0x8af0),
        Register('dcr35f', 8, 0x8af8),
        Register('dcr360', 8, 0x8b00),
        Register('dcr361', 8, 0x8b08),
        Register('dcr362', 8, 0x8b10),
        Register('dcr363', 8, 0x8b18),
        Register('dcr364', 8, 0x8b20),
        Register('dcr365', 8, 0x8b28),
        Register('dcr366', 8, 0x8b30),
        Register('dcr367', 8, 0x8b38),
        Register('dcr368', 8, 0x8b40),
        Register('dcr369', 8, 0x8b48),
        Register('dcr36a', 8, 0x8b50),
        Register('dcr36b', 8, 0x8b58),
        Register('dcr36c', 8, 0x8b60),
        Register('dcr36d', 8, 0x8b68),
        Register('dcr36e', 8, 0x8b70),
        Register('dcr36f', 8, 0x8b78),
        Register('dcr370', 8, 0x8b80),
        Register('dcr371', 8, 0x8b88),
        Register('dcr372', 8, 0x8b90),
        Register('dcr373', 8, 0x8b98),
        Register('dcr374', 8, 0x8ba0),
        Register('dcr375', 8, 0x8ba8),
        Register('dcr376', 8, 0x8bb0),
        Register('dcr377', 8, 0x8bb8),
        Register('dcr378', 8, 0x8bc0),
        Register('dcr379', 8, 0x8bc8),
        Register('dcr37a', 8, 0x8bd0),
        Register('dcr37b', 8, 0x8bd8),
        Register('dcr37c', 8, 0x8be0),
        Register('dcr37d', 8, 0x8be8),
        Register('dcr37e', 8, 0x8bf0),
        Register('dcr37f', 8, 0x8bf8),
        Register('dcr380', 8, 0x8c00),
        Register('dcr381', 8, 0x8c08),
        Register('dcr382', 8, 0x8c10),
        Register('dcr383', 8, 0x8c18),
        Register('dcr384', 8, 0x8c20),
        Register('dcr385', 8, 0x8c28),
        Register('dcr386', 8, 0x8c30),
        Register('dcr387', 8, 0x8c38),
        Register('dcr388', 8, 0x8c40),
        Register('dcr389', 8, 0x8c48),
        Register('dcr38a', 8, 0x8c50),
        Register('dcr38b', 8, 0x8c58),
        Register('dcr38c', 8, 0x8c60),
        Register('dcr38d', 8, 0x8c68),
        Register('dcr38e', 8, 0x8c70),
        Register('dcr38f', 8, 0x8c78),
        Register('dcr390', 8, 0x8c80),
        Register('dcr391', 8, 0x8c88),
        Register('dcr392', 8, 0x8c90),
        Register('dcr393', 8, 0x8c98),
        Register('dcr394', 8, 0x8ca0),
        Register('dcr395', 8, 0x8ca8),
        Register('dcr396', 8, 0x8cb0),
        Register('dcr397', 8, 0x8cb8),
        Register('dcr398', 8, 0x8cc0),
        Register('dcr399', 8, 0x8cc8),
        Register('dcr39a', 8, 0x8cd0),
        Register('dcr39b', 8, 0x8cd8),
        Register('dcr39c', 8, 0x8ce0),
        Register('dcr39d', 8, 0x8ce8),
        Register('dcr39e', 8, 0x8cf0),
        Register('dcr39f', 8, 0x8cf8),
        Register('dcr3a0', 8, 0x8d00),
        Register('dcr3a1', 8, 0x8d08),
        Register('dcr3a2', 8, 0x8d10),
        Register('dcr3a3', 8, 0x8d18),
        Register('dcr3a4', 8, 0x8d20),
        Register('dcr3a5', 8, 0x8d28),
        Register('dcr3a6', 8, 0x8d30),
        Register('dcr3a7', 8, 0x8d38),
        Register('dcr3a8', 8, 0x8d40),
        Register('dcr3a9', 8, 0x8d48),
        Register('dcr3aa', 8, 0x8d50),
        Register('dcr3ab', 8, 0x8d58),
        Register('dcr3ac', 8, 0x8d60),
        Register('dcr3ad', 8, 0x8d68),
        Register('dcr3ae', 8, 0x8d70),
        Register('dcr3af', 8, 0x8d78),
        Register('dcr3b0', 8, 0x8d80),
        Register('dcr3b1', 8, 0x8d88),
        Register('dcr3b2', 8, 0x8d90),
        Register('dcr3b3', 8, 0x8d98),
        Register('dcr3b4', 8, 0x8da0),
        Register('dcr3b5', 8, 0x8da8),
        Register('dcr3b6', 8, 0x8db0),
        Register('dcr3b7', 8, 0x8db8),
        Register('dcr3b8', 8, 0x8dc0),
        Register('dcr3b9', 8, 0x8dc8),
        Register('dcr3ba', 8, 0x8dd0),
        Register('dcr3bb', 8, 0x8dd8),
        Register('dcr3bc', 8, 0x8de0),
        Register('dcr3bd', 8, 0x8de8),
        Register('dcr3be', 8, 0x8df0),
        Register('dcr3bf', 8, 0x8df8),
        Register('dcr3c0', 8, 0x8e00),
        Register('dcr3c1', 8, 0x8e08),
        Register('dcr3c2', 8, 0x8e10),
        Register('dcr3c3', 8, 0x8e18),
        Register('dcr3c4', 8, 0x8e20),
        Register('dcr3c5', 8, 0x8e28),
        Register('dcr3c6', 8, 0x8e30),
        Register('dcr3c7', 8, 0x8e38),
        Register('dcr3c8', 8, 0x8e40),
        Register('dcr3c9', 8, 0x8e48),
        Register('dcr3ca', 8, 0x8e50),
        Register('dcr3cb', 8, 0x8e58),
        Register('dcr3cc', 8, 0x8e60),
        Register('dcr3cd', 8, 0x8e68),
        Register('dcr3ce', 8, 0x8e70),
        Register('dcr3cf', 8, 0x8e78),
        Register('dcr3d0', 8, 0x8e80),
        Register('dcr3d1', 8, 0x8e88),
        Register('dcr3d2', 8, 0x8e90),
        Register('dcr3d3', 8, 0x8e98),
        Register('dcr3d4', 8, 0x8ea0),
        Register('dcr3d5', 8, 0x8ea8),
        Register('dcr3d6', 8, 0x8eb0),
        Register('dcr3d7', 8, 0x8eb8),
        Register('dcr3d8', 8, 0x8ec0),
        Register('dcr3d9', 8, 0x8ec8),
        Register('dcr3da', 8, 0x8ed0),
        Register('dcr3db', 8, 0x8ed8),
        Register('dcr3dc', 8, 0x8ee0),
        Register('dcr3dd', 8, 0x8ee8),
        Register('dcr3de', 8, 0x8ef0),
        Register('dcr3df', 8, 0x8ef8),
        Register('dcr3e0', 8, 0x8f00),
        Register('dcr3e1', 8, 0x8f08),
        Register('dcr3e2', 8, 0x8f10),
        Register('dcr3e3', 8, 0x8f18),
        Register('dcr3e4', 8, 0x8f20),
        Register('dcr3e5', 8, 0x8f28),
        Register('dcr3e6', 8, 0x8f30),
        Register('dcr3e7', 8, 0x8f38),
        Register('dcr3e8', 8, 0x8f40),
        Register('dcr3e9', 8, 0x8f48),
        Register('dcr3ea', 8, 0x8f50),
        Register('dcr3eb', 8, 0x8f58),
        Register('dcr3ec', 8, 0x8f60),
        Register('dcr3ed', 8, 0x8f68),
        Register('dcr3ee', 8, 0x8f70),
        Register('dcr3ef', 8, 0x8f78),
        Register('dcr3f0', 8, 0x8f80),
        Register('dcr3f1', 8, 0x8f88),
        Register('dcr3f2', 8, 0x8f90),
        Register('dcr3f3', 8, 0x8f98),
        Register('dcr3f4', 8, 0x8fa0),
        Register('dcr3f5', 8, 0x8fa8),
        Register('dcr3f6', 8, 0x8fb0),
        Register('dcr3f7', 8, 0x8fb8),
        Register('dcr3f8', 8, 0x8fc0),
        Register('dcr3f9', 8, 0x8fc8),
        Register('dcr3fa', 8, 0x8fd0),
        Register('dcr3fb', 8, 0x8fd8),
        Register('dcr3fc', 8, 0x8fe0),
        Register('dcr3fd', 8, 0x8fe8),
        Register('dcr3fe', 8, 0x8ff0),
        Register('dcr3ff', 8, 0x8ff8),
        Register('acc', 8, 0x10000)
    ]

register_arch(['powerpc:be:64:a2-32addr'], 32, Endness.BE, ArchPcode_PowerPC_BE_64_A2_32addr)
