###
### This file was automatically generated
###

from archinfo.arch import register_arch, Endness, Register

from .common import ArchPcode


class ArchPcode_PowerPC_LE_32_default(ArchPcode):
    name = 'PowerPC:LE:32:default'
    pcode_arch = 'PowerPC:LE:32:default'
    description = 'PowerPC 32-bit little endian w/Altivec, G2'
    bits = 32
    ip_offset = 0x780
    sp_offset = 0x4
    bp_offset = sp_offset
    instruction_endness = Endness.LE
    register_list = [
        Register('r0', 4, 0x0),
        Register('r1', 4, 0x4),
        Register('r2', 4, 0x8),
        Register('r3', 4, 0xc),
        Register('r4', 4, 0x10),
        Register('r5', 4, 0x14),
        Register('r6', 4, 0x18),
        Register('r7', 4, 0x1c),
        Register('r8', 4, 0x20),
        Register('r9', 4, 0x24),
        Register('r10', 4, 0x28),
        Register('r11', 4, 0x2c),
        Register('r12', 4, 0x30),
        Register('r13', 4, 0x34),
        Register('r14', 4, 0x38),
        Register('r15', 4, 0x3c),
        Register('r16', 4, 0x40),
        Register('r17', 4, 0x44),
        Register('r18', 4, 0x48),
        Register('r19', 4, 0x4c),
        Register('r20', 4, 0x50),
        Register('r21', 4, 0x54),
        Register('r22', 4, 0x58),
        Register('r23', 4, 0x5c),
        Register('r24', 4, 0x60),
        Register('r25', 4, 0x64),
        Register('r26', 4, 0x68),
        Register('r27', 4, 0x6c),
        Register('r28', 4, 0x70),
        Register('r29', 4, 0x74),
        Register('r30', 4, 0x78),
        Register('r31', 4, 0x7c),
        Register('xer_so', 1, 0x400),
        Register('xer_ov', 1, 0x401),
        Register('xer_ov32', 1, 0x402),
        Register('xer_ca', 1, 0x403),
        Register('xer_ca32', 1, 0x404),
        Register('xer_count', 1, 0x405),
        Register('fp_fx', 1, 0x500),
        Register('fp_fex', 1, 0x501),
        Register('fp_vx', 1, 0x502),
        Register('fp_ox', 1, 0x503),
        Register('fp_ux', 1, 0x504),
        Register('fp_zx', 1, 0x505),
        Register('fp_xx', 1, 0x506),
        Register('fp_vxsnan', 1, 0x507),
        Register('fp_vxisi', 1, 0x508),
        Register('fp_vxidi', 1, 0x509),
        Register('fp_vxzdz', 1, 0x50a),
        Register('fp_vximz', 1, 0x50b),
        Register('fp_vxvc', 1, 0x50c),
        Register('fp_fr', 1, 0x50d),
        Register('fp_fi', 1, 0x50e),
        Register('fp_c', 1, 0x50f),
        Register('fp_cc0', 1, 0x510),
        Register('fp_cc1', 1, 0x511),
        Register('fp_cc2', 1, 0x512),
        Register('fp_cc3', 1, 0x513),
        Register('fp_reserve1', 1, 0x514),
        Register('fp_vxsoft', 1, 0x515),
        Register('fp_vxsqrt', 1, 0x516),
        Register('fp_vxcvi', 1, 0x517),
        Register('fp_ve', 1, 0x518),
        Register('fp_oe', 1, 0x519),
        Register('fp_ue', 1, 0x51a),
        Register('fp_ze', 1, 0x51b),
        Register('fp_xe', 1, 0x51c),
        Register('fp_ni', 1, 0x51d),
        Register('fp_rn0', 1, 0x51e),
        Register('fp_rn1', 1, 0x51f),
        Register('msr', 4, 0x700),
        Register('reserve_address', 4, 0x720),
        Register('reserve', 1, 0x728),
        Register('reserve_length', 1, 0x730),
        Register('pc', 4, 0x780, alias_names=('ip',)),
        Register('sr0', 4, 0x800),
        Register('sr1', 4, 0x804),
        Register('sr2', 4, 0x808),
        Register('sr3', 4, 0x80c),
        Register('sr4', 4, 0x810),
        Register('sr5', 4, 0x814),
        Register('sr6', 4, 0x818),
        Register('sr7', 4, 0x81c),
        Register('sr8', 4, 0x820),
        Register('sr9', 4, 0x824),
        Register('sr10', 4, 0x828),
        Register('sr11', 4, 0x82c),
        Register('sr12', 4, 0x830),
        Register('sr13', 4, 0x834),
        Register('sr14', 4, 0x838),
        Register('sr15', 4, 0x83c),
        Register('crall', 8, 0x900),
        Register('cr0', 1, 0x900),
        Register('cr1', 1, 0x901),
        Register('cr2', 1, 0x902),
        Register('cr3', 1, 0x903),
        Register('cr4', 1, 0x904),
        Register('cr5', 1, 0x905),
        Register('cr6', 1, 0x906),
        Register('cr7', 1, 0x907),
        Register('tea', 4, 0x980),
        Register('r2save', 4, 0x988),
        Register('spr000', 4, 0x1000),
        Register('xer', 4, 0x1004),
        Register('spr002', 4, 0x1008),
        Register('spr003', 4, 0x100c),
        Register('spr004', 4, 0x1010),
        Register('spr005', 4, 0x1014),
        Register('spr006', 4, 0x1018),
        Register('spr007', 4, 0x101c),
        Register('lr', 4, 0x1020),
        Register('ctr', 4, 0x1024),
        Register('spr00a', 4, 0x1028),
        Register('spr00b', 4, 0x102c),
        Register('spr00c', 4, 0x1030),
        Register('spr00d', 4, 0x1034),
        Register('spr00e', 4, 0x1038),
        Register('spr00f', 4, 0x103c),
        Register('spr010', 4, 0x1040),
        Register('spr011', 4, 0x1044),
        Register('spr012', 4, 0x1048),
        Register('spr013', 4, 0x104c),
        Register('spr014', 4, 0x1050),
        Register('spr015', 4, 0x1054),
        Register('spr016', 4, 0x1058),
        Register('spr017', 4, 0x105c),
        Register('spr018', 4, 0x1060),
        Register('spr019', 4, 0x1064),
        Register('srr0', 4, 0x1068),
        Register('srr1', 4, 0x106c),
        Register('spr01c', 4, 0x1070),
        Register('spr01d', 4, 0x1074),
        Register('spr01e', 4, 0x1078),
        Register('spr01f', 4, 0x107c),
        Register('spr020', 4, 0x1080),
        Register('spr021', 4, 0x1084),
        Register('spr022', 4, 0x1088),
        Register('spr023', 4, 0x108c),
        Register('spr024', 4, 0x1090),
        Register('spr025', 4, 0x1094),
        Register('spr026', 4, 0x1098),
        Register('spr027', 4, 0x109c),
        Register('spr028', 4, 0x10a0),
        Register('spr029', 4, 0x10a4),
        Register('spr02a', 4, 0x10a8),
        Register('spr02b', 4, 0x10ac),
        Register('spr02c', 4, 0x10b0),
        Register('spr02d', 4, 0x10b4),
        Register('spr02e', 4, 0x10b8),
        Register('spr02f', 4, 0x10bc),
        Register('spr030', 4, 0x10c0),
        Register('spr031', 4, 0x10c4),
        Register('spr032', 4, 0x10c8),
        Register('spr033', 4, 0x10cc),
        Register('spr034', 4, 0x10d0),
        Register('spr035', 4, 0x10d4),
        Register('spr036', 4, 0x10d8),
        Register('spr037', 4, 0x10dc),
        Register('spr038', 4, 0x10e0),
        Register('spr039', 4, 0x10e4),
        Register('spr03a', 4, 0x10e8),
        Register('spr03b', 4, 0x10ec),
        Register('spr03c', 4, 0x10f0),
        Register('spr03d', 4, 0x10f4),
        Register('spr03e', 4, 0x10f8),
        Register('spr03f', 4, 0x10fc),
        Register('spr040', 4, 0x1100),
        Register('spr041', 4, 0x1104),
        Register('spr042', 4, 0x1108),
        Register('spr043', 4, 0x110c),
        Register('spr044', 4, 0x1110),
        Register('spr045', 4, 0x1114),
        Register('spr046', 4, 0x1118),
        Register('spr047', 4, 0x111c),
        Register('spr048', 4, 0x1120),
        Register('spr049', 4, 0x1124),
        Register('spr04a', 4, 0x1128),
        Register('spr04b', 4, 0x112c),
        Register('spr04c', 4, 0x1130),
        Register('spr04d', 4, 0x1134),
        Register('spr04e', 4, 0x1138),
        Register('spr04f', 4, 0x113c),
        Register('spr050', 4, 0x1140),
        Register('spr051', 4, 0x1144),
        Register('spr052', 4, 0x1148),
        Register('spr053', 4, 0x114c),
        Register('spr054', 4, 0x1150),
        Register('spr055', 4, 0x1154),
        Register('spr056', 4, 0x1158),
        Register('spr057', 4, 0x115c),
        Register('spr058', 4, 0x1160),
        Register('spr059', 4, 0x1164),
        Register('spr05a', 4, 0x1168),
        Register('spr05b', 4, 0x116c),
        Register('spr05c', 4, 0x1170),
        Register('spr05d', 4, 0x1174),
        Register('spr05e', 4, 0x1178),
        Register('spr05f', 4, 0x117c),
        Register('spr060', 4, 0x1180),
        Register('spr061', 4, 0x1184),
        Register('spr062', 4, 0x1188),
        Register('spr063', 4, 0x118c),
        Register('spr064', 4, 0x1190),
        Register('spr065', 4, 0x1194),
        Register('spr066', 4, 0x1198),
        Register('spr067', 4, 0x119c),
        Register('spr068', 4, 0x11a0),
        Register('spr069', 4, 0x11a4),
        Register('spr06a', 4, 0x11a8),
        Register('spr06b', 4, 0x11ac),
        Register('spr06c', 4, 0x11b0),
        Register('spr06d', 4, 0x11b4),
        Register('spr06e', 4, 0x11b8),
        Register('spr06f', 4, 0x11bc),
        Register('spr070', 4, 0x11c0),
        Register('spr071', 4, 0x11c4),
        Register('spr072', 4, 0x11c8),
        Register('spr073', 4, 0x11cc),
        Register('spr074', 4, 0x11d0),
        Register('spr075', 4, 0x11d4),
        Register('spr076', 4, 0x11d8),
        Register('spr077', 4, 0x11dc),
        Register('spr078', 4, 0x11e0),
        Register('spr079', 4, 0x11e4),
        Register('spr07a', 4, 0x11e8),
        Register('spr07b', 4, 0x11ec),
        Register('spr07c', 4, 0x11f0),
        Register('spr07d', 4, 0x11f4),
        Register('spr07e', 4, 0x11f8),
        Register('spr07f', 4, 0x11fc),
        Register('spr080', 4, 0x1200),
        Register('spr081', 4, 0x1204),
        Register('spr082', 4, 0x1208),
        Register('spr083', 4, 0x120c),
        Register('spr084', 4, 0x1210),
        Register('spr085', 4, 0x1214),
        Register('spr086', 4, 0x1218),
        Register('spr087', 4, 0x121c),
        Register('spr088', 4, 0x1220),
        Register('spr089', 4, 0x1224),
        Register('spr08a', 4, 0x1228),
        Register('spr08b', 4, 0x122c),
        Register('spr08c', 4, 0x1230),
        Register('spr08d', 4, 0x1234),
        Register('spr08e', 4, 0x1238),
        Register('spr08f', 4, 0x123c),
        Register('spr090', 4, 0x1240),
        Register('spr091', 4, 0x1244),
        Register('spr092', 4, 0x1248),
        Register('spr093', 4, 0x124c),
        Register('spr094', 4, 0x1250),
        Register('spr095', 4, 0x1254),
        Register('spr096', 4, 0x1258),
        Register('spr097', 4, 0x125c),
        Register('spr098', 4, 0x1260),
        Register('spr099', 4, 0x1264),
        Register('spr09a', 4, 0x1268),
        Register('spr09b', 4, 0x126c),
        Register('spr09c', 4, 0x1270),
        Register('spr09d', 4, 0x1274),
        Register('spr09e', 4, 0x1278),
        Register('spr09f', 4, 0x127c),
        Register('spr0a0', 4, 0x1280),
        Register('spr0a1', 4, 0x1284),
        Register('spr0a2', 4, 0x1288),
        Register('spr0a3', 4, 0x128c),
        Register('spr0a4', 4, 0x1290),
        Register('spr0a5', 4, 0x1294),
        Register('spr0a6', 4, 0x1298),
        Register('spr0a7', 4, 0x129c),
        Register('spr0a8', 4, 0x12a0),
        Register('spr0a9', 4, 0x12a4),
        Register('spr0aa', 4, 0x12a8),
        Register('spr0ab', 4, 0x12ac),
        Register('spr0ac', 4, 0x12b0),
        Register('spr0ad', 4, 0x12b4),
        Register('spr0ae', 4, 0x12b8),
        Register('spr0af', 4, 0x12bc),
        Register('spr0b0', 4, 0x12c0),
        Register('spr0b1', 4, 0x12c4),
        Register('spr0b2', 4, 0x12c8),
        Register('spr0b3', 4, 0x12cc),
        Register('spr0b4', 4, 0x12d0),
        Register('spr0b5', 4, 0x12d4),
        Register('spr0b6', 4, 0x12d8),
        Register('spr0b7', 4, 0x12dc),
        Register('spr0b8', 4, 0x12e0),
        Register('spr0b9', 4, 0x12e4),
        Register('spr0ba', 4, 0x12e8),
        Register('spr0bb', 4, 0x12ec),
        Register('spr0bc', 4, 0x12f0),
        Register('spr0bd', 4, 0x12f4),
        Register('spr0be', 4, 0x12f8),
        Register('spr0bf', 4, 0x12fc),
        Register('spr0c0', 4, 0x1300),
        Register('spr0c1', 4, 0x1304),
        Register('spr0c2', 4, 0x1308),
        Register('spr0c3', 4, 0x130c),
        Register('spr0c4', 4, 0x1310),
        Register('spr0c5', 4, 0x1314),
        Register('spr0c6', 4, 0x1318),
        Register('spr0c7', 4, 0x131c),
        Register('spr0c8', 4, 0x1320),
        Register('spr0c9', 4, 0x1324),
        Register('spr0ca', 4, 0x1328),
        Register('spr0cb', 4, 0x132c),
        Register('spr0cc', 4, 0x1330),
        Register('spr0cd', 4, 0x1334),
        Register('spr0ce', 4, 0x1338),
        Register('spr0cf', 4, 0x133c),
        Register('spr0d0', 4, 0x1340),
        Register('spr0d1', 4, 0x1344),
        Register('spr0d2', 4, 0x1348),
        Register('spr0d3', 4, 0x134c),
        Register('spr0d4', 4, 0x1350),
        Register('spr0d5', 4, 0x1354),
        Register('spr0d6', 4, 0x1358),
        Register('spr0d7', 4, 0x135c),
        Register('spr0d8', 4, 0x1360),
        Register('spr0d9', 4, 0x1364),
        Register('spr0da', 4, 0x1368),
        Register('spr0db', 4, 0x136c),
        Register('spr0dc', 4, 0x1370),
        Register('spr0dd', 4, 0x1374),
        Register('spr0de', 4, 0x1378),
        Register('spr0df', 4, 0x137c),
        Register('spr0e0', 4, 0x1380),
        Register('spr0e1', 4, 0x1384),
        Register('spr0e2', 4, 0x1388),
        Register('spr0e3', 4, 0x138c),
        Register('spr0e4', 4, 0x1390),
        Register('spr0e5', 4, 0x1394),
        Register('spr0e6', 4, 0x1398),
        Register('spr0e7', 4, 0x139c),
        Register('spr0e8', 4, 0x13a0),
        Register('spr0e9', 4, 0x13a4),
        Register('spr0ea', 4, 0x13a8),
        Register('spr0eb', 4, 0x13ac),
        Register('spr0ec', 4, 0x13b0),
        Register('spr0ed', 4, 0x13b4),
        Register('spr0ee', 4, 0x13b8),
        Register('spr0ef', 4, 0x13bc),
        Register('spr0f0', 4, 0x13c0),
        Register('spr0f1', 4, 0x13c4),
        Register('spr0f2', 4, 0x13c8),
        Register('spr0f3', 4, 0x13cc),
        Register('spr0f4', 4, 0x13d0),
        Register('spr0f5', 4, 0x13d4),
        Register('spr0f6', 4, 0x13d8),
        Register('spr0f7', 4, 0x13dc),
        Register('spr0f8', 4, 0x13e0),
        Register('spr0f9', 4, 0x13e4),
        Register('spr0fa', 4, 0x13e8),
        Register('spr0fb', 4, 0x13ec),
        Register('spr0fc', 4, 0x13f0),
        Register('spr0fd', 4, 0x13f4),
        Register('spr0fe', 4, 0x13f8),
        Register('spr0ff', 4, 0x13fc),
        Register('spr100', 4, 0x1400),
        Register('spr101', 4, 0x1404),
        Register('spr102', 4, 0x1408),
        Register('spr103', 4, 0x140c),
        Register('spr104', 4, 0x1410),
        Register('spr105', 4, 0x1414),
        Register('spr106', 4, 0x1418),
        Register('spr107', 4, 0x141c),
        Register('spr108', 4, 0x1420),
        Register('spr109', 4, 0x1424),
        Register('spr10a', 4, 0x1428),
        Register('spr10b', 4, 0x142c),
        Register('tblr', 4, 0x1430),
        Register('tbur', 4, 0x1434),
        Register('spr10e', 4, 0x1438),
        Register('spr10f', 4, 0x143c),
        Register('spr110', 4, 0x1440),
        Register('spr111', 4, 0x1444),
        Register('spr112', 4, 0x1448),
        Register('spr113', 4, 0x144c),
        Register('spr114', 4, 0x1450),
        Register('spr115', 4, 0x1454),
        Register('spr116', 4, 0x1458),
        Register('spr117', 4, 0x145c),
        Register('spr118', 4, 0x1460),
        Register('spr119', 4, 0x1464),
        Register('spr11a', 4, 0x1468),
        Register('spr11b', 4, 0x146c),
        Register('tblw', 4, 0x1470),
        Register('tbuw', 4, 0x1474),
        Register('spr11e', 4, 0x1478),
        Register('spr11f', 4, 0x147c),
        Register('spr120', 4, 0x1480),
        Register('spr121', 4, 0x1484),
        Register('spr122', 4, 0x1488),
        Register('spr123', 4, 0x148c),
        Register('spr124', 4, 0x1490),
        Register('spr125', 4, 0x1494),
        Register('spr126', 4, 0x1498),
        Register('spr127', 4, 0x149c),
        Register('spr128', 4, 0x14a0),
        Register('spr129', 4, 0x14a4),
        Register('spr12a', 4, 0x14a8),
        Register('spr12b', 4, 0x14ac),
        Register('spr12c', 4, 0x14b0),
        Register('spr12d', 4, 0x14b4),
        Register('spr12e', 4, 0x14b8),
        Register('spr12f', 4, 0x14bc),
        Register('spr130', 4, 0x14c0),
        Register('spr131', 4, 0x14c4),
        Register('spr132', 4, 0x14c8),
        Register('spr133', 4, 0x14cc),
        Register('spr134', 4, 0x14d0),
        Register('spr135', 4, 0x14d4),
        Register('spr136', 4, 0x14d8),
        Register('spr137', 4, 0x14dc),
        Register('spr138', 4, 0x14e0),
        Register('spr139', 4, 0x14e4),
        Register('spr13a', 4, 0x14e8),
        Register('spr13b', 4, 0x14ec),
        Register('spr13c', 4, 0x14f0),
        Register('spr13d', 4, 0x14f4),
        Register('spr13e', 4, 0x14f8),
        Register('spr13f', 4, 0x14fc),
        Register('spr140', 4, 0x1500),
        Register('spr141', 4, 0x1504),
        Register('spr142', 4, 0x1508),
        Register('spr143', 4, 0x150c),
        Register('spr144', 4, 0x1510),
        Register('spr145', 4, 0x1514),
        Register('spr146', 4, 0x1518),
        Register('spr147', 4, 0x151c),
        Register('spr148', 4, 0x1520),
        Register('spr149', 4, 0x1524),
        Register('spr14a', 4, 0x1528),
        Register('spr14b', 4, 0x152c),
        Register('spr14c', 4, 0x1530),
        Register('spr14d', 4, 0x1534),
        Register('spr14e', 4, 0x1538),
        Register('spr14f', 4, 0x153c),
        Register('spr150', 4, 0x1540),
        Register('spr151', 4, 0x1544),
        Register('spr152', 4, 0x1548),
        Register('spr153', 4, 0x154c),
        Register('spr154', 4, 0x1550),
        Register('spr155', 4, 0x1554),
        Register('spr156', 4, 0x1558),
        Register('spr157', 4, 0x155c),
        Register('spr158', 4, 0x1560),
        Register('spr159', 4, 0x1564),
        Register('spr15a', 4, 0x1568),
        Register('spr15b', 4, 0x156c),
        Register('spr15c', 4, 0x1570),
        Register('spr15d', 4, 0x1574),
        Register('spr15e', 4, 0x1578),
        Register('spr15f', 4, 0x157c),
        Register('spr160', 4, 0x1580),
        Register('spr161', 4, 0x1584),
        Register('spr162', 4, 0x1588),
        Register('spr163', 4, 0x158c),
        Register('spr164', 4, 0x1590),
        Register('spr165', 4, 0x1594),
        Register('spr166', 4, 0x1598),
        Register('spr167', 4, 0x159c),
        Register('spr168', 4, 0x15a0),
        Register('spr169', 4, 0x15a4),
        Register('spr16a', 4, 0x15a8),
        Register('spr16b', 4, 0x15ac),
        Register('spr16c', 4, 0x15b0),
        Register('spr16d', 4, 0x15b4),
        Register('spr16e', 4, 0x15b8),
        Register('spr16f', 4, 0x15bc),
        Register('spr170', 4, 0x15c0),
        Register('spr171', 4, 0x15c4),
        Register('spr172', 4, 0x15c8),
        Register('spr173', 4, 0x15cc),
        Register('spr174', 4, 0x15d0),
        Register('spr175', 4, 0x15d4),
        Register('spr176', 4, 0x15d8),
        Register('spr177', 4, 0x15dc),
        Register('spr178', 4, 0x15e0),
        Register('spr179', 4, 0x15e4),
        Register('spr17a', 4, 0x15e8),
        Register('spr17b', 4, 0x15ec),
        Register('spr17c', 4, 0x15f0),
        Register('spr17d', 4, 0x15f4),
        Register('spr17e', 4, 0x15f8),
        Register('spr17f', 4, 0x15fc),
        Register('spr180', 4, 0x1600),
        Register('spr181', 4, 0x1604),
        Register('spr182', 4, 0x1608),
        Register('spr183', 4, 0x160c),
        Register('spr184', 4, 0x1610),
        Register('spr185', 4, 0x1614),
        Register('spr186', 4, 0x1618),
        Register('spr187', 4, 0x161c),
        Register('spr188', 4, 0x1620),
        Register('spr189', 4, 0x1624),
        Register('spr18a', 4, 0x1628),
        Register('spr18b', 4, 0x162c),
        Register('spr18c', 4, 0x1630),
        Register('spr18d', 4, 0x1634),
        Register('spr18e', 4, 0x1638),
        Register('spr18f', 4, 0x163c),
        Register('spr190', 4, 0x1640),
        Register('spr191', 4, 0x1644),
        Register('spr192', 4, 0x1648),
        Register('spr193', 4, 0x164c),
        Register('spr194', 4, 0x1650),
        Register('spr195', 4, 0x1654),
        Register('spr196', 4, 0x1658),
        Register('spr197', 4, 0x165c),
        Register('spr198', 4, 0x1660),
        Register('spr199', 4, 0x1664),
        Register('spr19a', 4, 0x1668),
        Register('spr19b', 4, 0x166c),
        Register('spr19c', 4, 0x1670),
        Register('spr19d', 4, 0x1674),
        Register('spr19e', 4, 0x1678),
        Register('spr19f', 4, 0x167c),
        Register('spr1a0', 4, 0x1680),
        Register('spr1a1', 4, 0x1684),
        Register('spr1a2', 4, 0x1688),
        Register('spr1a3', 4, 0x168c),
        Register('spr1a4', 4, 0x1690),
        Register('spr1a5', 4, 0x1694),
        Register('spr1a6', 4, 0x1698),
        Register('spr1a7', 4, 0x169c),
        Register('spr1a8', 4, 0x16a0),
        Register('spr1a9', 4, 0x16a4),
        Register('spr1aa', 4, 0x16a8),
        Register('spr1ab', 4, 0x16ac),
        Register('spr1ac', 4, 0x16b0),
        Register('spr1ad', 4, 0x16b4),
        Register('spr1ae', 4, 0x16b8),
        Register('spr1af', 4, 0x16bc),
        Register('spr1b0', 4, 0x16c0),
        Register('spr1b1', 4, 0x16c4),
        Register('spr1b2', 4, 0x16c8),
        Register('spr1b3', 4, 0x16cc),
        Register('spr1b4', 4, 0x16d0),
        Register('spr1b5', 4, 0x16d4),
        Register('spr1b6', 4, 0x16d8),
        Register('spr1b7', 4, 0x16dc),
        Register('spr1b8', 4, 0x16e0),
        Register('spr1b9', 4, 0x16e4),
        Register('spr1ba', 4, 0x16e8),
        Register('spr1bb', 4, 0x16ec),
        Register('spr1bc', 4, 0x16f0),
        Register('spr1bd', 4, 0x16f4),
        Register('spr1be', 4, 0x16f8),
        Register('spr1bf', 4, 0x16fc),
        Register('spr1c0', 4, 0x1700),
        Register('spr1c1', 4, 0x1704),
        Register('spr1c2', 4, 0x1708),
        Register('spr1c3', 4, 0x170c),
        Register('spr1c4', 4, 0x1710),
        Register('spr1c5', 4, 0x1714),
        Register('spr1c6', 4, 0x1718),
        Register('spr1c7', 4, 0x171c),
        Register('spr1c8', 4, 0x1720),
        Register('spr1c9', 4, 0x1724),
        Register('spr1ca', 4, 0x1728),
        Register('spr1cb', 4, 0x172c),
        Register('spr1cc', 4, 0x1730),
        Register('spr1cd', 4, 0x1734),
        Register('spr1ce', 4, 0x1738),
        Register('spr1cf', 4, 0x173c),
        Register('spr1d0', 4, 0x1740),
        Register('spr1d1', 4, 0x1744),
        Register('spr1d2', 4, 0x1748),
        Register('spr1d3', 4, 0x174c),
        Register('spr1d4', 4, 0x1750),
        Register('spr1d5', 4, 0x1754),
        Register('spr1d6', 4, 0x1758),
        Register('spr1d7', 4, 0x175c),
        Register('spr1d8', 4, 0x1760),
        Register('spr1d9', 4, 0x1764),
        Register('spr1da', 4, 0x1768),
        Register('spr1db', 4, 0x176c),
        Register('spr1dc', 4, 0x1770),
        Register('spr1dd', 4, 0x1774),
        Register('spr1de', 4, 0x1778),
        Register('spr1df', 4, 0x177c),
        Register('spr1e0', 4, 0x1780),
        Register('spr1e1', 4, 0x1784),
        Register('spr1e2', 4, 0x1788),
        Register('spr1e3', 4, 0x178c),
        Register('spr1e4', 4, 0x1790),
        Register('spr1e5', 4, 0x1794),
        Register('spr1e6', 4, 0x1798),
        Register('spr1e7', 4, 0x179c),
        Register('spr1e8', 4, 0x17a0),
        Register('spr1e9', 4, 0x17a4),
        Register('spr1ea', 4, 0x17a8),
        Register('spr1eb', 4, 0x17ac),
        Register('spr1ec', 4, 0x17b0),
        Register('spr1ed', 4, 0x17b4),
        Register('spr1ee', 4, 0x17b8),
        Register('spr1ef', 4, 0x17bc),
        Register('spr1f0', 4, 0x17c0),
        Register('spr1f1', 4, 0x17c4),
        Register('spr1f2', 4, 0x17c8),
        Register('spr1f3', 4, 0x17cc),
        Register('spr1f4', 4, 0x17d0),
        Register('spr1f5', 4, 0x17d4),
        Register('spr1f6', 4, 0x17d8),
        Register('spr1f7', 4, 0x17dc),
        Register('spr1f8', 4, 0x17e0),
        Register('spr1f9', 4, 0x17e4),
        Register('spr1fa', 4, 0x17e8),
        Register('spr1fb', 4, 0x17ec),
        Register('spr1fc', 4, 0x17f0),
        Register('spr1fd', 4, 0x17f4),
        Register('spr1fe', 4, 0x17f8),
        Register('spr1ff', 4, 0x17fc),
        Register('spr200', 4, 0x1800),
        Register('spr201', 4, 0x1804),
        Register('spr202', 4, 0x1808),
        Register('spr203', 4, 0x180c),
        Register('spr204', 4, 0x1810),
        Register('spr205', 4, 0x1814),
        Register('spr206', 4, 0x1818),
        Register('spr207', 4, 0x181c),
        Register('spr208', 4, 0x1820),
        Register('spr209', 4, 0x1824),
        Register('spr20a', 4, 0x1828),
        Register('spr20b', 4, 0x182c),
        Register('spr20c', 4, 0x1830),
        Register('spr20d', 4, 0x1834),
        Register('spr20e', 4, 0x1838),
        Register('spr20f', 4, 0x183c),
        Register('spr210', 4, 0x1840),
        Register('spr211', 4, 0x1844),
        Register('spr212', 4, 0x1848),
        Register('spr213', 4, 0x184c),
        Register('spr214', 4, 0x1850),
        Register('spr215', 4, 0x1854),
        Register('spr216', 4, 0x1858),
        Register('spr217', 4, 0x185c),
        Register('spr218', 4, 0x1860),
        Register('spr219', 4, 0x1864),
        Register('spr21a', 4, 0x1868),
        Register('spr21b', 4, 0x186c),
        Register('spr21c', 4, 0x1870),
        Register('spr21d', 4, 0x1874),
        Register('spr21e', 4, 0x1878),
        Register('spr21f', 4, 0x187c),
        Register('spr220', 4, 0x1880),
        Register('spr221', 4, 0x1884),
        Register('spr222', 4, 0x1888),
        Register('spr223', 4, 0x188c),
        Register('spr224', 4, 0x1890),
        Register('spr225', 4, 0x1894),
        Register('spr226', 4, 0x1898),
        Register('spr227', 4, 0x189c),
        Register('spr228', 4, 0x18a0),
        Register('spr229', 4, 0x18a4),
        Register('spr22a', 4, 0x18a8),
        Register('spr22b', 4, 0x18ac),
        Register('spr22c', 4, 0x18b0),
        Register('spr22d', 4, 0x18b4),
        Register('spr22e', 4, 0x18b8),
        Register('spr22f', 4, 0x18bc),
        Register('spr230', 4, 0x18c0),
        Register('spr231', 4, 0x18c4),
        Register('spr232', 4, 0x18c8),
        Register('spr233', 4, 0x18cc),
        Register('spr234', 4, 0x18d0),
        Register('spr235', 4, 0x18d4),
        Register('spr236', 4, 0x18d8),
        Register('spr237', 4, 0x18dc),
        Register('spr238', 4, 0x18e0),
        Register('spr239', 4, 0x18e4),
        Register('spr23a', 4, 0x18e8),
        Register('spr23b', 4, 0x18ec),
        Register('spr23c', 4, 0x18f0),
        Register('spr23d', 4, 0x18f4),
        Register('spr23e', 4, 0x18f8),
        Register('spr23f', 4, 0x18fc),
        Register('spr240', 4, 0x1900),
        Register('spr241', 4, 0x1904),
        Register('spr242', 4, 0x1908),
        Register('spr243', 4, 0x190c),
        Register('spr244', 4, 0x1910),
        Register('spr245', 4, 0x1914),
        Register('spr246', 4, 0x1918),
        Register('spr247', 4, 0x191c),
        Register('spr248', 4, 0x1920),
        Register('spr249', 4, 0x1924),
        Register('spr24a', 4, 0x1928),
        Register('spr24b', 4, 0x192c),
        Register('spr24c', 4, 0x1930),
        Register('spr24d', 4, 0x1934),
        Register('spr24e', 4, 0x1938),
        Register('spr24f', 4, 0x193c),
        Register('spr250', 4, 0x1940),
        Register('spr251', 4, 0x1944),
        Register('spr252', 4, 0x1948),
        Register('spr253', 4, 0x194c),
        Register('spr254', 4, 0x1950),
        Register('spr255', 4, 0x1954),
        Register('spr256', 4, 0x1958),
        Register('spr257', 4, 0x195c),
        Register('spr258', 4, 0x1960),
        Register('spr259', 4, 0x1964),
        Register('spr25a', 4, 0x1968),
        Register('spr25b', 4, 0x196c),
        Register('spr25c', 4, 0x1970),
        Register('spr25d', 4, 0x1974),
        Register('spr25e', 4, 0x1978),
        Register('spr25f', 4, 0x197c),
        Register('spr260', 4, 0x1980),
        Register('spr261', 4, 0x1984),
        Register('spr262', 4, 0x1988),
        Register('spr263', 4, 0x198c),
        Register('spr264', 4, 0x1990),
        Register('spr265', 4, 0x1994),
        Register('spr266', 4, 0x1998),
        Register('spr267', 4, 0x199c),
        Register('spr268', 4, 0x19a0),
        Register('spr269', 4, 0x19a4),
        Register('spr26a', 4, 0x19a8),
        Register('spr26b', 4, 0x19ac),
        Register('spr26c', 4, 0x19b0),
        Register('spr26d', 4, 0x19b4),
        Register('spr26e', 4, 0x19b8),
        Register('spr26f', 4, 0x19bc),
        Register('spr270', 4, 0x19c0),
        Register('spr271', 4, 0x19c4),
        Register('spr272', 4, 0x19c8),
        Register('spr273', 4, 0x19cc),
        Register('spr274', 4, 0x19d0),
        Register('spr275', 4, 0x19d4),
        Register('spr276', 4, 0x19d8),
        Register('spr277', 4, 0x19dc),
        Register('spr278', 4, 0x19e0),
        Register('spr279', 4, 0x19e4),
        Register('spr27a', 4, 0x19e8),
        Register('spr27b', 4, 0x19ec),
        Register('spr27c', 4, 0x19f0),
        Register('spr27d', 4, 0x19f4),
        Register('spr27e', 4, 0x19f8),
        Register('spr27f', 4, 0x19fc),
        Register('spr280', 4, 0x1a00),
        Register('spr281', 4, 0x1a04),
        Register('spr282', 4, 0x1a08),
        Register('spr283', 4, 0x1a0c),
        Register('spr284', 4, 0x1a10),
        Register('spr285', 4, 0x1a14),
        Register('spr286', 4, 0x1a18),
        Register('spr287', 4, 0x1a1c),
        Register('spr288', 4, 0x1a20),
        Register('spr289', 4, 0x1a24),
        Register('spr28a', 4, 0x1a28),
        Register('spr28b', 4, 0x1a2c),
        Register('spr28c', 4, 0x1a30),
        Register('spr28d', 4, 0x1a34),
        Register('spr28e', 4, 0x1a38),
        Register('spr28f', 4, 0x1a3c),
        Register('spr290', 4, 0x1a40),
        Register('spr291', 4, 0x1a44),
        Register('spr292', 4, 0x1a48),
        Register('spr293', 4, 0x1a4c),
        Register('spr294', 4, 0x1a50),
        Register('spr295', 4, 0x1a54),
        Register('spr296', 4, 0x1a58),
        Register('spr297', 4, 0x1a5c),
        Register('spr298', 4, 0x1a60),
        Register('spr299', 4, 0x1a64),
        Register('spr29a', 4, 0x1a68),
        Register('spr29b', 4, 0x1a6c),
        Register('spr29c', 4, 0x1a70),
        Register('spr29d', 4, 0x1a74),
        Register('spr29e', 4, 0x1a78),
        Register('spr29f', 4, 0x1a7c),
        Register('spr2a0', 4, 0x1a80),
        Register('spr2a1', 4, 0x1a84),
        Register('spr2a2', 4, 0x1a88),
        Register('spr2a3', 4, 0x1a8c),
        Register('spr2a4', 4, 0x1a90),
        Register('spr2a5', 4, 0x1a94),
        Register('spr2a6', 4, 0x1a98),
        Register('spr2a7', 4, 0x1a9c),
        Register('spr2a8', 4, 0x1aa0),
        Register('spr2a9', 4, 0x1aa4),
        Register('spr2aa', 4, 0x1aa8),
        Register('spr2ab', 4, 0x1aac),
        Register('spr2ac', 4, 0x1ab0),
        Register('spr2ad', 4, 0x1ab4),
        Register('spr2ae', 4, 0x1ab8),
        Register('spr2af', 4, 0x1abc),
        Register('spr2b0', 4, 0x1ac0),
        Register('spr2b1', 4, 0x1ac4),
        Register('spr2b2', 4, 0x1ac8),
        Register('spr2b3', 4, 0x1acc),
        Register('spr2b4', 4, 0x1ad0),
        Register('spr2b5', 4, 0x1ad4),
        Register('spr2b6', 4, 0x1ad8),
        Register('spr2b7', 4, 0x1adc),
        Register('spr2b8', 4, 0x1ae0),
        Register('spr2b9', 4, 0x1ae4),
        Register('spr2ba', 4, 0x1ae8),
        Register('spr2bb', 4, 0x1aec),
        Register('spr2bc', 4, 0x1af0),
        Register('spr2bd', 4, 0x1af4),
        Register('spr2be', 4, 0x1af8),
        Register('spr2bf', 4, 0x1afc),
        Register('spr2c0', 4, 0x1b00),
        Register('spr2c1', 4, 0x1b04),
        Register('spr2c2', 4, 0x1b08),
        Register('spr2c3', 4, 0x1b0c),
        Register('spr2c4', 4, 0x1b10),
        Register('spr2c5', 4, 0x1b14),
        Register('spr2c6', 4, 0x1b18),
        Register('spr2c7', 4, 0x1b1c),
        Register('spr2c8', 4, 0x1b20),
        Register('spr2c9', 4, 0x1b24),
        Register('spr2ca', 4, 0x1b28),
        Register('spr2cb', 4, 0x1b2c),
        Register('spr2cc', 4, 0x1b30),
        Register('spr2cd', 4, 0x1b34),
        Register('spr2ce', 4, 0x1b38),
        Register('spr2cf', 4, 0x1b3c),
        Register('spr2d0', 4, 0x1b40),
        Register('spr2d1', 4, 0x1b44),
        Register('spr2d2', 4, 0x1b48),
        Register('spr2d3', 4, 0x1b4c),
        Register('spr2d4', 4, 0x1b50),
        Register('spr2d5', 4, 0x1b54),
        Register('spr2d6', 4, 0x1b58),
        Register('spr2d7', 4, 0x1b5c),
        Register('spr2d8', 4, 0x1b60),
        Register('spr2d9', 4, 0x1b64),
        Register('spr2da', 4, 0x1b68),
        Register('spr2db', 4, 0x1b6c),
        Register('spr2dc', 4, 0x1b70),
        Register('spr2dd', 4, 0x1b74),
        Register('spr2de', 4, 0x1b78),
        Register('spr2df', 4, 0x1b7c),
        Register('spr2e0', 4, 0x1b80),
        Register('spr2e1', 4, 0x1b84),
        Register('spr2e2', 4, 0x1b88),
        Register('spr2e3', 4, 0x1b8c),
        Register('spr2e4', 4, 0x1b90),
        Register('spr2e5', 4, 0x1b94),
        Register('spr2e6', 4, 0x1b98),
        Register('spr2e7', 4, 0x1b9c),
        Register('spr2e8', 4, 0x1ba0),
        Register('spr2e9', 4, 0x1ba4),
        Register('spr2ea', 4, 0x1ba8),
        Register('spr2eb', 4, 0x1bac),
        Register('spr2ec', 4, 0x1bb0),
        Register('spr2ed', 4, 0x1bb4),
        Register('spr2ee', 4, 0x1bb8),
        Register('spr2ef', 4, 0x1bbc),
        Register('spr2f0', 4, 0x1bc0),
        Register('spr2f1', 4, 0x1bc4),
        Register('spr2f2', 4, 0x1bc8),
        Register('spr2f3', 4, 0x1bcc),
        Register('spr2f4', 4, 0x1bd0),
        Register('spr2f5', 4, 0x1bd4),
        Register('spr2f6', 4, 0x1bd8),
        Register('spr2f7', 4, 0x1bdc),
        Register('spr2f8', 4, 0x1be0),
        Register('spr2f9', 4, 0x1be4),
        Register('spr2fa', 4, 0x1be8),
        Register('spr2fb', 4, 0x1bec),
        Register('spr2fc', 4, 0x1bf0),
        Register('spr2fd', 4, 0x1bf4),
        Register('spr2fe', 4, 0x1bf8),
        Register('spr2ff', 4, 0x1bfc),
        Register('spr300', 4, 0x1c00),
        Register('spr301', 4, 0x1c04),
        Register('spr302', 4, 0x1c08),
        Register('spr303', 4, 0x1c0c),
        Register('spr304', 4, 0x1c10),
        Register('spr305', 4, 0x1c14),
        Register('spr306', 4, 0x1c18),
        Register('spr307', 4, 0x1c1c),
        Register('spr308', 4, 0x1c20),
        Register('spr309', 4, 0x1c24),
        Register('spr30a', 4, 0x1c28),
        Register('spr30b', 4, 0x1c2c),
        Register('spr30c', 4, 0x1c30),
        Register('spr30d', 4, 0x1c34),
        Register('spr30e', 4, 0x1c38),
        Register('spr30f', 4, 0x1c3c),
        Register('spr310', 4, 0x1c40),
        Register('spr311', 4, 0x1c44),
        Register('spr312', 4, 0x1c48),
        Register('spr313', 4, 0x1c4c),
        Register('spr314', 4, 0x1c50),
        Register('spr315', 4, 0x1c54),
        Register('spr316', 4, 0x1c58),
        Register('spr317', 4, 0x1c5c),
        Register('spr318', 4, 0x1c60),
        Register('spr319', 4, 0x1c64),
        Register('spr31a', 4, 0x1c68),
        Register('spr31b', 4, 0x1c6c),
        Register('spr31c', 4, 0x1c70),
        Register('spr31d', 4, 0x1c74),
        Register('spr31e', 4, 0x1c78),
        Register('spr31f', 4, 0x1c7c),
        Register('spr320', 4, 0x1c80),
        Register('spr321', 4, 0x1c84),
        Register('spr322', 4, 0x1c88),
        Register('spr323', 4, 0x1c8c),
        Register('spr324', 4, 0x1c90),
        Register('spr325', 4, 0x1c94),
        Register('spr326', 4, 0x1c98),
        Register('spr327', 4, 0x1c9c),
        Register('spr328', 4, 0x1ca0),
        Register('spr329', 4, 0x1ca4),
        Register('spr32a', 4, 0x1ca8),
        Register('spr32b', 4, 0x1cac),
        Register('spr32c', 4, 0x1cb0),
        Register('spr32d', 4, 0x1cb4),
        Register('spr32e', 4, 0x1cb8),
        Register('tar', 4, 0x1cbc),
        Register('spr330', 4, 0x1cc0),
        Register('spr331', 4, 0x1cc4),
        Register('spr332', 4, 0x1cc8),
        Register('spr333', 4, 0x1ccc),
        Register('spr334', 4, 0x1cd0),
        Register('spr335', 4, 0x1cd4),
        Register('spr336', 4, 0x1cd8),
        Register('spr337', 4, 0x1cdc),
        Register('spr338', 4, 0x1ce0),
        Register('spr339', 4, 0x1ce4),
        Register('spr33a', 4, 0x1ce8),
        Register('spr33b', 4, 0x1cec),
        Register('spr33c', 4, 0x1cf0),
        Register('spr33d', 4, 0x1cf4),
        Register('spr33e', 4, 0x1cf8),
        Register('spr33f', 4, 0x1cfc),
        Register('spr340', 4, 0x1d00),
        Register('spr341', 4, 0x1d04),
        Register('spr342', 4, 0x1d08),
        Register('spr343', 4, 0x1d0c),
        Register('spr344', 4, 0x1d10),
        Register('spr345', 4, 0x1d14),
        Register('spr346', 4, 0x1d18),
        Register('spr347', 4, 0x1d1c),
        Register('spr348', 4, 0x1d20),
        Register('spr349', 4, 0x1d24),
        Register('spr34a', 4, 0x1d28),
        Register('spr34b', 4, 0x1d2c),
        Register('spr34c', 4, 0x1d30),
        Register('spr34d', 4, 0x1d34),
        Register('spr34e', 4, 0x1d38),
        Register('spr34f', 4, 0x1d3c),
        Register('spr350', 4, 0x1d40),
        Register('spr351', 4, 0x1d44),
        Register('spr352', 4, 0x1d48),
        Register('spr353', 4, 0x1d4c),
        Register('spr354', 4, 0x1d50),
        Register('spr355', 4, 0x1d54),
        Register('spr356', 4, 0x1d58),
        Register('spr357', 4, 0x1d5c),
        Register('spr358', 4, 0x1d60),
        Register('spr359', 4, 0x1d64),
        Register('spr35a', 4, 0x1d68),
        Register('spr35b', 4, 0x1d6c),
        Register('spr35c', 4, 0x1d70),
        Register('spr35d', 4, 0x1d74),
        Register('spr35e', 4, 0x1d78),
        Register('spr35f', 4, 0x1d7c),
        Register('spr360', 4, 0x1d80),
        Register('spr361', 4, 0x1d84),
        Register('spr362', 4, 0x1d88),
        Register('spr363', 4, 0x1d8c),
        Register('spr364', 4, 0x1d90),
        Register('spr365', 4, 0x1d94),
        Register('spr366', 4, 0x1d98),
        Register('spr367', 4, 0x1d9c),
        Register('spr368', 4, 0x1da0),
        Register('spr369', 4, 0x1da4),
        Register('spr36a', 4, 0x1da8),
        Register('spr36b', 4, 0x1dac),
        Register('spr36c', 4, 0x1db0),
        Register('spr36d', 4, 0x1db4),
        Register('spr36e', 4, 0x1db8),
        Register('spr36f', 4, 0x1dbc),
        Register('spr370', 4, 0x1dc0),
        Register('spr371', 4, 0x1dc4),
        Register('spr372', 4, 0x1dc8),
        Register('spr373', 4, 0x1dcc),
        Register('spr374', 4, 0x1dd0),
        Register('spr375', 4, 0x1dd4),
        Register('spr376', 4, 0x1dd8),
        Register('spr377', 4, 0x1ddc),
        Register('spr378', 4, 0x1de0),
        Register('spr379', 4, 0x1de4),
        Register('spr37a', 4, 0x1de8),
        Register('spr37b', 4, 0x1dec),
        Register('spr37c', 4, 0x1df0),
        Register('spr37d', 4, 0x1df4),
        Register('spr37e', 4, 0x1df8),
        Register('spr37f', 4, 0x1dfc),
        Register('spr380', 4, 0x1e00),
        Register('spr381', 4, 0x1e04),
        Register('spr382', 4, 0x1e08),
        Register('spr383', 4, 0x1e0c),
        Register('spr384', 4, 0x1e10),
        Register('spr385', 4, 0x1e14),
        Register('spr386', 4, 0x1e18),
        Register('spr387', 4, 0x1e1c),
        Register('spr388', 4, 0x1e20),
        Register('spr389', 4, 0x1e24),
        Register('spr38a', 4, 0x1e28),
        Register('spr38b', 4, 0x1e2c),
        Register('spr38c', 4, 0x1e30),
        Register('spr38d', 4, 0x1e34),
        Register('spr38e', 4, 0x1e38),
        Register('spr38f', 4, 0x1e3c),
        Register('spr390', 4, 0x1e40),
        Register('spr391', 4, 0x1e44),
        Register('spr392', 4, 0x1e48),
        Register('spr393', 4, 0x1e4c),
        Register('spr394', 4, 0x1e50),
        Register('spr395', 4, 0x1e54),
        Register('spr396', 4, 0x1e58),
        Register('spr397', 4, 0x1e5c),
        Register('spr398', 4, 0x1e60),
        Register('spr399', 4, 0x1e64),
        Register('spr39a', 4, 0x1e68),
        Register('spr39b', 4, 0x1e6c),
        Register('spr39c', 4, 0x1e70),
        Register('spr39d', 4, 0x1e74),
        Register('spr39e', 4, 0x1e78),
        Register('spr39f', 4, 0x1e7c),
        Register('spr3a0', 4, 0x1e80),
        Register('spr3a1', 4, 0x1e84),
        Register('spr3a2', 4, 0x1e88),
        Register('spr3a3', 4, 0x1e8c),
        Register('spr3a4', 4, 0x1e90),
        Register('spr3a5', 4, 0x1e94),
        Register('spr3a6', 4, 0x1e98),
        Register('spr3a7', 4, 0x1e9c),
        Register('spr3a8', 4, 0x1ea0),
        Register('spr3a9', 4, 0x1ea4),
        Register('spr3aa', 4, 0x1ea8),
        Register('spr3ab', 4, 0x1eac),
        Register('spr3ac', 4, 0x1eb0),
        Register('spr3ad', 4, 0x1eb4),
        Register('spr3ae', 4, 0x1eb8),
        Register('spr3af', 4, 0x1ebc),
        Register('spr3b0', 4, 0x1ec0),
        Register('spr3b1', 4, 0x1ec4),
        Register('spr3b2', 4, 0x1ec8),
        Register('spr3b3', 4, 0x1ecc),
        Register('spr3b4', 4, 0x1ed0),
        Register('spr3b5', 4, 0x1ed4),
        Register('spr3b6', 4, 0x1ed8),
        Register('spr3b7', 4, 0x1edc),
        Register('spr3b8', 4, 0x1ee0),
        Register('spr3b9', 4, 0x1ee4),
        Register('spr3ba', 4, 0x1ee8),
        Register('spr3bb', 4, 0x1eec),
        Register('spr3bc', 4, 0x1ef0),
        Register('spr3bd', 4, 0x1ef4),
        Register('spr3be', 4, 0x1ef8),
        Register('spr3bf', 4, 0x1efc),
        Register('spr3c0', 4, 0x1f00),
        Register('spr3c1', 4, 0x1f04),
        Register('spr3c2', 4, 0x1f08),
        Register('spr3c3', 4, 0x1f0c),
        Register('spr3c4', 4, 0x1f10),
        Register('spr3c5', 4, 0x1f14),
        Register('spr3c6', 4, 0x1f18),
        Register('spr3c7', 4, 0x1f1c),
        Register('spr3c8', 4, 0x1f20),
        Register('spr3c9', 4, 0x1f24),
        Register('spr3ca', 4, 0x1f28),
        Register('spr3cb', 4, 0x1f2c),
        Register('spr3cc', 4, 0x1f30),
        Register('spr3cd', 4, 0x1f34),
        Register('spr3ce', 4, 0x1f38),
        Register('spr3cf', 4, 0x1f3c),
        Register('spr3d0', 4, 0x1f40),
        Register('spr3d1', 4, 0x1f44),
        Register('spr3d2', 4, 0x1f48),
        Register('spr3d3', 4, 0x1f4c),
        Register('spr3d4', 4, 0x1f50),
        Register('spr3d5', 4, 0x1f54),
        Register('spr3d6', 4, 0x1f58),
        Register('spr3d7', 4, 0x1f5c),
        Register('spr3d8', 4, 0x1f60),
        Register('spr3d9', 4, 0x1f64),
        Register('spr3da', 4, 0x1f68),
        Register('spr3db', 4, 0x1f6c),
        Register('spr3dc', 4, 0x1f70),
        Register('spr3dd', 4, 0x1f74),
        Register('spr3de', 4, 0x1f78),
        Register('spr3df', 4, 0x1f7c),
        Register('spr3e0', 4, 0x1f80),
        Register('spr3e1', 4, 0x1f84),
        Register('spr3e2', 4, 0x1f88),
        Register('spr3e3', 4, 0x1f8c),
        Register('spr3e4', 4, 0x1f90),
        Register('spr3e5', 4, 0x1f94),
        Register('spr3e6', 4, 0x1f98),
        Register('spr3e7', 4, 0x1f9c),
        Register('spr3e8', 4, 0x1fa0),
        Register('spr3e9', 4, 0x1fa4),
        Register('spr3ea', 4, 0x1fa8),
        Register('spr3eb', 4, 0x1fac),
        Register('spr3ec', 4, 0x1fb0),
        Register('spr3ed', 4, 0x1fb4),
        Register('spr3ee', 4, 0x1fb8),
        Register('spr3ef', 4, 0x1fbc),
        Register('spr3f0', 4, 0x1fc0),
        Register('spr3f1', 4, 0x1fc4),
        Register('spr3f2', 4, 0x1fc8),
        Register('spr3f3', 4, 0x1fcc),
        Register('spr3f4', 4, 0x1fd0),
        Register('spr3f5', 4, 0x1fd4),
        Register('spr3f6', 4, 0x1fd8),
        Register('spr3f7', 4, 0x1fdc),
        Register('spr3f8', 4, 0x1fe0),
        Register('spr3f9', 4, 0x1fe4),
        Register('spr3fa', 4, 0x1fe8),
        Register('spr3fb', 4, 0x1fec),
        Register('spr3fc', 4, 0x1ff0),
        Register('spr3fd', 4, 0x1ff4),
        Register('spr3fe', 4, 0x1ff8),
        Register('spr3ff', 4, 0x1ffc),
        Register('vs0', 16, 0x4000),
        Register('f0', 8, 0x4008),
        Register('vs1', 16, 0x4010),
        Register('f1', 8, 0x4018),
        Register('vs2', 16, 0x4020),
        Register('f2', 8, 0x4028),
        Register('vs3', 16, 0x4030),
        Register('f3', 8, 0x4038),
        Register('vs4', 16, 0x4040),
        Register('f4', 8, 0x4048),
        Register('vs5', 16, 0x4050),
        Register('f5', 8, 0x4058),
        Register('vs6', 16, 0x4060),
        Register('f6', 8, 0x4068),
        Register('vs7', 16, 0x4070),
        Register('f7', 8, 0x4078),
        Register('vs8', 16, 0x4080),
        Register('f8', 8, 0x4088),
        Register('vs9', 16, 0x4090),
        Register('f9', 8, 0x4098),
        Register('vs10', 16, 0x40a0),
        Register('f10', 8, 0x40a8),
        Register('vs11', 16, 0x40b0),
        Register('f11', 8, 0x40b8),
        Register('vs12', 16, 0x40c0),
        Register('f12', 8, 0x40c8),
        Register('vs13', 16, 0x40d0),
        Register('f13', 8, 0x40d8),
        Register('vs14', 16, 0x40e0),
        Register('f14', 8, 0x40e8),
        Register('vs15', 16, 0x40f0),
        Register('f15', 8, 0x40f8),
        Register('vs16', 16, 0x4100),
        Register('f16', 8, 0x4108),
        Register('vs17', 16, 0x4110),
        Register('f17', 8, 0x4118),
        Register('vs18', 16, 0x4120),
        Register('f18', 8, 0x4128),
        Register('vs19', 16, 0x4130),
        Register('f19', 8, 0x4138),
        Register('vs20', 16, 0x4140),
        Register('f20', 8, 0x4148),
        Register('vs21', 16, 0x4150),
        Register('f21', 8, 0x4158),
        Register('vs22', 16, 0x4160),
        Register('f22', 8, 0x4168),
        Register('vs23', 16, 0x4170),
        Register('f23', 8, 0x4178),
        Register('vs24', 16, 0x4180),
        Register('f24', 8, 0x4188),
        Register('vs25', 16, 0x4190),
        Register('f25', 8, 0x4198),
        Register('vs26', 16, 0x41a0),
        Register('f26', 8, 0x41a8),
        Register('vs27', 16, 0x41b0),
        Register('f27', 8, 0x41b8),
        Register('vs28', 16, 0x41c0),
        Register('f28', 8, 0x41c8),
        Register('vs29', 16, 0x41d0),
        Register('f29', 8, 0x41d8),
        Register('vs30', 16, 0x41e0),
        Register('f30', 8, 0x41e8),
        Register('vs31', 16, 0x41f0),
        Register('f31', 8, 0x41f8),
        Register('vs32', 16, 0x4200),
        Register('vr0_64_1', 8, 0x4200),
        Register('vr0_32_3', 4, 0x4200),
        Register('vr0_16_7', 2, 0x4200),
        Register('vr0_8_15', 1, 0x4200),
        Register('vr0_8_14', 1, 0x4201),
        Register('vr0_16_6', 2, 0x4202),
        Register('vr0_8_13', 1, 0x4202),
        Register('vr0_8_12', 1, 0x4203),
        Register('vr0_32_2', 4, 0x4204),
        Register('vr0_16_5', 2, 0x4204),
        Register('vr0_8_11', 1, 0x4204),
        Register('vr0_8_10', 1, 0x4205),
        Register('vr0_16_4', 2, 0x4206),
        Register('vr0_8_9', 1, 0x4206),
        Register('vr0_8_8', 1, 0x4207),
        Register('vr0_64_0', 8, 0x4208),
        Register('vr0_32_1', 4, 0x4208),
        Register('vr0_16_3', 2, 0x4208),
        Register('vr0_8_7', 1, 0x4208),
        Register('vr0_8_6', 1, 0x4209),
        Register('vr0_16_2', 2, 0x420a),
        Register('vr0_8_5', 1, 0x420a),
        Register('vr0_8_4', 1, 0x420b),
        Register('vr0_32_0', 4, 0x420c),
        Register('vr0_16_1', 2, 0x420c),
        Register('vr0_8_3', 1, 0x420c),
        Register('vr0_8_2', 1, 0x420d),
        Register('vr0_16_0', 2, 0x420e),
        Register('vr0_8_1', 1, 0x420e),
        Register('vr0_8_0', 1, 0x420f),
        Register('vs33', 16, 0x4210),
        Register('vr1_64_1', 8, 0x4210),
        Register('vr1_32_3', 4, 0x4210),
        Register('vr1_16_7', 2, 0x4210),
        Register('vr1_8_15', 1, 0x4210),
        Register('vr1_8_14', 1, 0x4211),
        Register('vr1_16_6', 2, 0x4212),
        Register('vr1_8_13', 1, 0x4212),
        Register('vr1_8_12', 1, 0x4213),
        Register('vr1_32_2', 4, 0x4214),
        Register('vr1_16_5', 2, 0x4214),
        Register('vr1_8_11', 1, 0x4214),
        Register('vr1_8_10', 1, 0x4215),
        Register('vr1_16_4', 2, 0x4216),
        Register('vr1_8_9', 1, 0x4216),
        Register('vr1_8_8', 1, 0x4217),
        Register('vr1_64_0', 8, 0x4218),
        Register('vr1_32_1', 4, 0x4218),
        Register('vr1_16_3', 2, 0x4218),
        Register('vr1_8_7', 1, 0x4218),
        Register('vr1_8_6', 1, 0x4219),
        Register('vr1_16_2', 2, 0x421a),
        Register('vr1_8_5', 1, 0x421a),
        Register('vr1_8_4', 1, 0x421b),
        Register('vr1_32_0', 4, 0x421c),
        Register('vr1_16_1', 2, 0x421c),
        Register('vr1_8_3', 1, 0x421c),
        Register('vr1_8_2', 1, 0x421d),
        Register('vr1_16_0', 2, 0x421e),
        Register('vr1_8_1', 1, 0x421e),
        Register('vr1_8_0', 1, 0x421f),
        Register('vs34', 16, 0x4220),
        Register('vr2_64_1', 8, 0x4220),
        Register('vr2_32_3', 4, 0x4220),
        Register('vr2_16_7', 2, 0x4220),
        Register('vr2_8_15', 1, 0x4220),
        Register('vr2_8_14', 1, 0x4221),
        Register('vr2_16_6', 2, 0x4222),
        Register('vr2_8_13', 1, 0x4222),
        Register('vr2_8_12', 1, 0x4223),
        Register('vr2_32_2', 4, 0x4224),
        Register('vr2_16_5', 2, 0x4224),
        Register('vr2_8_11', 1, 0x4224),
        Register('vr2_8_10', 1, 0x4225),
        Register('vr2_16_4', 2, 0x4226),
        Register('vr2_8_9', 1, 0x4226),
        Register('vr2_8_8', 1, 0x4227),
        Register('vr2_64_0', 8, 0x4228),
        Register('vr2_32_1', 4, 0x4228),
        Register('vr2_16_3', 2, 0x4228),
        Register('vr2_8_7', 1, 0x4228),
        Register('vr2_8_6', 1, 0x4229),
        Register('vr2_16_2', 2, 0x422a),
        Register('vr2_8_5', 1, 0x422a),
        Register('vr2_8_4', 1, 0x422b),
        Register('vr2_32_0', 4, 0x422c),
        Register('vr2_16_1', 2, 0x422c),
        Register('vr2_8_3', 1, 0x422c),
        Register('vr2_8_2', 1, 0x422d),
        Register('vr2_16_0', 2, 0x422e),
        Register('vr2_8_1', 1, 0x422e),
        Register('vr2_8_0', 1, 0x422f),
        Register('vs35', 16, 0x4230),
        Register('vr3_64_1', 8, 0x4230),
        Register('vr3_32_3', 4, 0x4230),
        Register('vr3_16_7', 2, 0x4230),
        Register('vr3_8_15', 1, 0x4230),
        Register('vr3_8_14', 1, 0x4231),
        Register('vr3_16_6', 2, 0x4232),
        Register('vr3_8_13', 1, 0x4232),
        Register('vr3_8_12', 1, 0x4233),
        Register('vr3_32_2', 4, 0x4234),
        Register('vr3_16_5', 2, 0x4234),
        Register('vr3_8_11', 1, 0x4234),
        Register('vr3_8_10', 1, 0x4235),
        Register('vr3_16_4', 2, 0x4236),
        Register('vr3_8_9', 1, 0x4236),
        Register('vr3_8_8', 1, 0x4237),
        Register('vr3_64_0', 8, 0x4238),
        Register('vr3_32_1', 4, 0x4238),
        Register('vr3_16_3', 2, 0x4238),
        Register('vr3_8_7', 1, 0x4238),
        Register('vr3_8_6', 1, 0x4239),
        Register('vr3_16_2', 2, 0x423a),
        Register('vr3_8_5', 1, 0x423a),
        Register('vr3_8_4', 1, 0x423b),
        Register('vr3_32_0', 4, 0x423c),
        Register('vr3_16_1', 2, 0x423c),
        Register('vr3_8_3', 1, 0x423c),
        Register('vr3_8_2', 1, 0x423d),
        Register('vr3_16_0', 2, 0x423e),
        Register('vr3_8_1', 1, 0x423e),
        Register('vr3_8_0', 1, 0x423f),
        Register('vs36', 16, 0x4240),
        Register('vr4_64_1', 8, 0x4240),
        Register('vr4_32_3', 4, 0x4240),
        Register('vr4_16_7', 2, 0x4240),
        Register('vr4_8_15', 1, 0x4240),
        Register('vr4_8_14', 1, 0x4241),
        Register('vr4_16_6', 2, 0x4242),
        Register('vr4_8_13', 1, 0x4242),
        Register('vr4_8_12', 1, 0x4243),
        Register('vr4_32_2', 4, 0x4244),
        Register('vr4_16_5', 2, 0x4244),
        Register('vr4_8_11', 1, 0x4244),
        Register('vr4_8_10', 1, 0x4245),
        Register('vr4_16_4', 2, 0x4246),
        Register('vr4_8_9', 1, 0x4246),
        Register('vr4_8_8', 1, 0x4247),
        Register('vr4_64_0', 8, 0x4248),
        Register('vr4_32_1', 4, 0x4248),
        Register('vr4_16_3', 2, 0x4248),
        Register('vr4_8_7', 1, 0x4248),
        Register('vr4_8_6', 1, 0x4249),
        Register('vr4_16_2', 2, 0x424a),
        Register('vr4_8_5', 1, 0x424a),
        Register('vr4_8_4', 1, 0x424b),
        Register('vr4_32_0', 4, 0x424c),
        Register('vr4_16_1', 2, 0x424c),
        Register('vr4_8_3', 1, 0x424c),
        Register('vr4_8_2', 1, 0x424d),
        Register('vr4_16_0', 2, 0x424e),
        Register('vr4_8_1', 1, 0x424e),
        Register('vr4_8_0', 1, 0x424f),
        Register('vs37', 16, 0x4250),
        Register('vr5_64_1', 8, 0x4250),
        Register('vr5_32_3', 4, 0x4250),
        Register('vr5_16_7', 2, 0x4250),
        Register('vr5_8_15', 1, 0x4250),
        Register('vr5_8_14', 1, 0x4251),
        Register('vr5_16_6', 2, 0x4252),
        Register('vr5_8_13', 1, 0x4252),
        Register('vr5_8_12', 1, 0x4253),
        Register('vr5_32_2', 4, 0x4254),
        Register('vr5_16_5', 2, 0x4254),
        Register('vr5_8_11', 1, 0x4254),
        Register('vr5_8_10', 1, 0x4255),
        Register('vr5_16_4', 2, 0x4256),
        Register('vr5_8_9', 1, 0x4256),
        Register('vr5_8_8', 1, 0x4257),
        Register('vr5_64_0', 8, 0x4258),
        Register('vr5_32_1', 4, 0x4258),
        Register('vr5_16_3', 2, 0x4258),
        Register('vr5_8_7', 1, 0x4258),
        Register('vr5_8_6', 1, 0x4259),
        Register('vr5_16_2', 2, 0x425a),
        Register('vr5_8_5', 1, 0x425a),
        Register('vr5_8_4', 1, 0x425b),
        Register('vr5_32_0', 4, 0x425c),
        Register('vr5_16_1', 2, 0x425c),
        Register('vr5_8_3', 1, 0x425c),
        Register('vr5_8_2', 1, 0x425d),
        Register('vr5_16_0', 2, 0x425e),
        Register('vr5_8_1', 1, 0x425e),
        Register('vr5_8_0', 1, 0x425f),
        Register('vs38', 16, 0x4260),
        Register('vr6_64_1', 8, 0x4260),
        Register('vr6_32_3', 4, 0x4260),
        Register('vr6_16_7', 2, 0x4260),
        Register('vr6_8_15', 1, 0x4260),
        Register('vr6_8_14', 1, 0x4261),
        Register('vr6_16_6', 2, 0x4262),
        Register('vr6_8_13', 1, 0x4262),
        Register('vr6_8_12', 1, 0x4263),
        Register('vr6_32_2', 4, 0x4264),
        Register('vr6_16_5', 2, 0x4264),
        Register('vr6_8_11', 1, 0x4264),
        Register('vr6_8_10', 1, 0x4265),
        Register('vr6_16_4', 2, 0x4266),
        Register('vr6_8_9', 1, 0x4266),
        Register('vr6_8_8', 1, 0x4267),
        Register('vr6_64_0', 8, 0x4268),
        Register('vr6_32_1', 4, 0x4268),
        Register('vr6_16_3', 2, 0x4268),
        Register('vr6_8_7', 1, 0x4268),
        Register('vr6_8_6', 1, 0x4269),
        Register('vr6_16_2', 2, 0x426a),
        Register('vr6_8_5', 1, 0x426a),
        Register('vr6_8_4', 1, 0x426b),
        Register('vr6_32_0', 4, 0x426c),
        Register('vr6_16_1', 2, 0x426c),
        Register('vr6_8_3', 1, 0x426c),
        Register('vr6_8_2', 1, 0x426d),
        Register('vr6_16_0', 2, 0x426e),
        Register('vr6_8_1', 1, 0x426e),
        Register('vr6_8_0', 1, 0x426f),
        Register('vs39', 16, 0x4270),
        Register('vr7_64_1', 8, 0x4270),
        Register('vr7_32_3', 4, 0x4270),
        Register('vr7_16_7', 2, 0x4270),
        Register('vr7_8_15', 1, 0x4270),
        Register('vr7_8_14', 1, 0x4271),
        Register('vr7_16_6', 2, 0x4272),
        Register('vr7_8_13', 1, 0x4272),
        Register('vr7_8_12', 1, 0x4273),
        Register('vr7_32_2', 4, 0x4274),
        Register('vr7_16_5', 2, 0x4274),
        Register('vr7_8_11', 1, 0x4274),
        Register('vr7_8_10', 1, 0x4275),
        Register('vr7_16_4', 2, 0x4276),
        Register('vr7_8_9', 1, 0x4276),
        Register('vr7_8_8', 1, 0x4277),
        Register('vr7_64_0', 8, 0x4278),
        Register('vr7_32_1', 4, 0x4278),
        Register('vr7_16_3', 2, 0x4278),
        Register('vr7_8_7', 1, 0x4278),
        Register('vr7_8_6', 1, 0x4279),
        Register('vr7_16_2', 2, 0x427a),
        Register('vr7_8_5', 1, 0x427a),
        Register('vr7_8_4', 1, 0x427b),
        Register('vr7_32_0', 4, 0x427c),
        Register('vr7_16_1', 2, 0x427c),
        Register('vr7_8_3', 1, 0x427c),
        Register('vr7_8_2', 1, 0x427d),
        Register('vr7_16_0', 2, 0x427e),
        Register('vr7_8_1', 1, 0x427e),
        Register('vr7_8_0', 1, 0x427f),
        Register('vs40', 16, 0x4280),
        Register('vr8_64_1', 8, 0x4280),
        Register('vr8_32_3', 4, 0x4280),
        Register('vr8_16_7', 2, 0x4280),
        Register('vr8_8_15', 1, 0x4280),
        Register('vr8_8_14', 1, 0x4281),
        Register('vr8_16_6', 2, 0x4282),
        Register('vr8_8_13', 1, 0x4282),
        Register('vr8_8_12', 1, 0x4283),
        Register('vr8_32_2', 4, 0x4284),
        Register('vr8_16_5', 2, 0x4284),
        Register('vr8_8_11', 1, 0x4284),
        Register('vr8_8_10', 1, 0x4285),
        Register('vr8_16_4', 2, 0x4286),
        Register('vr8_8_9', 1, 0x4286),
        Register('vr8_8_8', 1, 0x4287),
        Register('vr8_64_0', 8, 0x4288),
        Register('vr8_32_1', 4, 0x4288),
        Register('vr8_16_3', 2, 0x4288),
        Register('vr8_8_7', 1, 0x4288),
        Register('vr8_8_6', 1, 0x4289),
        Register('vr8_16_2', 2, 0x428a),
        Register('vr8_8_5', 1, 0x428a),
        Register('vr8_8_4', 1, 0x428b),
        Register('vr8_32_0', 4, 0x428c),
        Register('vr8_16_1', 2, 0x428c),
        Register('vr8_8_3', 1, 0x428c),
        Register('vr8_8_2', 1, 0x428d),
        Register('vr8_16_0', 2, 0x428e),
        Register('vr8_8_1', 1, 0x428e),
        Register('vr8_8_0', 1, 0x428f),
        Register('vs41', 16, 0x4290),
        Register('vr9_64_1', 8, 0x4290),
        Register('vr9_32_3', 4, 0x4290),
        Register('vr9_16_7', 2, 0x4290),
        Register('vr9_8_15', 1, 0x4290),
        Register('vr9_8_14', 1, 0x4291),
        Register('vr9_16_6', 2, 0x4292),
        Register('vr9_8_13', 1, 0x4292),
        Register('vr9_8_12', 1, 0x4293),
        Register('vr9_32_2', 4, 0x4294),
        Register('vr9_16_5', 2, 0x4294),
        Register('vr9_8_11', 1, 0x4294),
        Register('vr9_8_10', 1, 0x4295),
        Register('vr9_16_4', 2, 0x4296),
        Register('vr9_8_9', 1, 0x4296),
        Register('vr9_8_8', 1, 0x4297),
        Register('vr9_64_0', 8, 0x4298),
        Register('vr9_32_1', 4, 0x4298),
        Register('vr9_16_3', 2, 0x4298),
        Register('vr9_8_7', 1, 0x4298),
        Register('vr9_8_6', 1, 0x4299),
        Register('vr9_16_2', 2, 0x429a),
        Register('vr9_8_5', 1, 0x429a),
        Register('vr9_8_4', 1, 0x429b),
        Register('vr9_32_0', 4, 0x429c),
        Register('vr9_16_1', 2, 0x429c),
        Register('vr9_8_3', 1, 0x429c),
        Register('vr9_8_2', 1, 0x429d),
        Register('vr9_16_0', 2, 0x429e),
        Register('vr9_8_1', 1, 0x429e),
        Register('vr9_8_0', 1, 0x429f),
        Register('vs42', 16, 0x42a0),
        Register('vr10_64_1', 8, 0x42a0),
        Register('vr10_32_3', 4, 0x42a0),
        Register('vr10_16_7', 2, 0x42a0),
        Register('vr10_8_15', 1, 0x42a0),
        Register('vr10_8_14', 1, 0x42a1),
        Register('vr10_16_6', 2, 0x42a2),
        Register('vr10_8_13', 1, 0x42a2),
        Register('vr10_8_12', 1, 0x42a3),
        Register('vr10_32_2', 4, 0x42a4),
        Register('vr10_16_5', 2, 0x42a4),
        Register('vr10_8_11', 1, 0x42a4),
        Register('vr10_8_10', 1, 0x42a5),
        Register('vr10_16_4', 2, 0x42a6),
        Register('vr10_8_9', 1, 0x42a6),
        Register('vr10_8_8', 1, 0x42a7),
        Register('vr10_64_0', 8, 0x42a8),
        Register('vr10_32_1', 4, 0x42a8),
        Register('vr10_16_3', 2, 0x42a8),
        Register('vr10_8_7', 1, 0x42a8),
        Register('vr10_8_6', 1, 0x42a9),
        Register('vr10_16_2', 2, 0x42aa),
        Register('vr10_8_5', 1, 0x42aa),
        Register('vr10_8_4', 1, 0x42ab),
        Register('vr10_32_0', 4, 0x42ac),
        Register('vr10_16_1', 2, 0x42ac),
        Register('vr10_8_3', 1, 0x42ac),
        Register('vr10_8_2', 1, 0x42ad),
        Register('vr10_16_0', 2, 0x42ae),
        Register('vr10_8_1', 1, 0x42ae),
        Register('vr10_8_0', 1, 0x42af),
        Register('vs43', 16, 0x42b0),
        Register('vr11_64_1', 8, 0x42b0),
        Register('vr11_32_3', 4, 0x42b0),
        Register('vr11_16_7', 2, 0x42b0),
        Register('vr11_8_15', 1, 0x42b0),
        Register('vr11_8_14', 1, 0x42b1),
        Register('vr11_16_6', 2, 0x42b2),
        Register('vr11_8_13', 1, 0x42b2),
        Register('vr11_8_12', 1, 0x42b3),
        Register('vr11_32_2', 4, 0x42b4),
        Register('vr11_16_5', 2, 0x42b4),
        Register('vr11_8_11', 1, 0x42b4),
        Register('vr11_8_10', 1, 0x42b5),
        Register('vr11_16_4', 2, 0x42b6),
        Register('vr11_8_9', 1, 0x42b6),
        Register('vr11_8_8', 1, 0x42b7),
        Register('vr11_64_0', 8, 0x42b8),
        Register('vr11_32_1', 4, 0x42b8),
        Register('vr11_16_3', 2, 0x42b8),
        Register('vr11_8_7', 1, 0x42b8),
        Register('vr11_8_6', 1, 0x42b9),
        Register('vr11_16_2', 2, 0x42ba),
        Register('vr11_8_5', 1, 0x42ba),
        Register('vr11_8_4', 1, 0x42bb),
        Register('vr11_32_0', 4, 0x42bc),
        Register('vr11_16_1', 2, 0x42bc),
        Register('vr11_8_3', 1, 0x42bc),
        Register('vr11_8_2', 1, 0x42bd),
        Register('vr11_16_0', 2, 0x42be),
        Register('vr11_8_1', 1, 0x42be),
        Register('vr11_8_0', 1, 0x42bf),
        Register('vs44', 16, 0x42c0),
        Register('vr12_64_1', 8, 0x42c0),
        Register('vr12_32_3', 4, 0x42c0),
        Register('vr12_16_7', 2, 0x42c0),
        Register('vr12_8_15', 1, 0x42c0),
        Register('vr12_8_14', 1, 0x42c1),
        Register('vr12_16_6', 2, 0x42c2),
        Register('vr12_8_13', 1, 0x42c2),
        Register('vr12_8_12', 1, 0x42c3),
        Register('vr12_32_2', 4, 0x42c4),
        Register('vr12_16_5', 2, 0x42c4),
        Register('vr12_8_11', 1, 0x42c4),
        Register('vr12_8_10', 1, 0x42c5),
        Register('vr12_16_4', 2, 0x42c6),
        Register('vr12_8_9', 1, 0x42c6),
        Register('vr12_8_8', 1, 0x42c7),
        Register('vr12_64_0', 8, 0x42c8),
        Register('vr12_32_1', 4, 0x42c8),
        Register('vr12_16_3', 2, 0x42c8),
        Register('vr12_8_7', 1, 0x42c8),
        Register('vr12_8_6', 1, 0x42c9),
        Register('vr12_16_2', 2, 0x42ca),
        Register('vr12_8_5', 1, 0x42ca),
        Register('vr12_8_4', 1, 0x42cb),
        Register('vr12_32_0', 4, 0x42cc),
        Register('vr12_16_1', 2, 0x42cc),
        Register('vr12_8_3', 1, 0x42cc),
        Register('vr12_8_2', 1, 0x42cd),
        Register('vr12_16_0', 2, 0x42ce),
        Register('vr12_8_1', 1, 0x42ce),
        Register('vr12_8_0', 1, 0x42cf),
        Register('vs45', 16, 0x42d0),
        Register('vr13_64_1', 8, 0x42d0),
        Register('vr13_32_3', 4, 0x42d0),
        Register('vr13_16_7', 2, 0x42d0),
        Register('vr13_8_15', 1, 0x42d0),
        Register('vr13_8_14', 1, 0x42d1),
        Register('vr13_16_6', 2, 0x42d2),
        Register('vr13_8_13', 1, 0x42d2),
        Register('vr13_8_12', 1, 0x42d3),
        Register('vr13_32_2', 4, 0x42d4),
        Register('vr13_16_5', 2, 0x42d4),
        Register('vr13_8_11', 1, 0x42d4),
        Register('vr13_8_10', 1, 0x42d5),
        Register('vr13_16_4', 2, 0x42d6),
        Register('vr13_8_9', 1, 0x42d6),
        Register('vr13_8_8', 1, 0x42d7),
        Register('vr13_64_0', 8, 0x42d8),
        Register('vr13_32_1', 4, 0x42d8),
        Register('vr13_16_3', 2, 0x42d8),
        Register('vr13_8_7', 1, 0x42d8),
        Register('vr13_8_6', 1, 0x42d9),
        Register('vr13_16_2', 2, 0x42da),
        Register('vr13_8_5', 1, 0x42da),
        Register('vr13_8_4', 1, 0x42db),
        Register('vr13_32_0', 4, 0x42dc),
        Register('vr13_16_1', 2, 0x42dc),
        Register('vr13_8_3', 1, 0x42dc),
        Register('vr13_8_2', 1, 0x42dd),
        Register('vr13_16_0', 2, 0x42de),
        Register('vr13_8_1', 1, 0x42de),
        Register('vr13_8_0', 1, 0x42df),
        Register('vs46', 16, 0x42e0),
        Register('vr14_64_1', 8, 0x42e0),
        Register('vr14_32_3', 4, 0x42e0),
        Register('vr14_16_7', 2, 0x42e0),
        Register('vr14_8_15', 1, 0x42e0),
        Register('vr14_8_14', 1, 0x42e1),
        Register('vr14_16_6', 2, 0x42e2),
        Register('vr14_8_13', 1, 0x42e2),
        Register('vr14_8_12', 1, 0x42e3),
        Register('vr14_32_2', 4, 0x42e4),
        Register('vr14_16_5', 2, 0x42e4),
        Register('vr14_8_11', 1, 0x42e4),
        Register('vr14_8_10', 1, 0x42e5),
        Register('vr14_16_4', 2, 0x42e6),
        Register('vr14_8_9', 1, 0x42e6),
        Register('vr14_8_8', 1, 0x42e7),
        Register('vr14_64_0', 8, 0x42e8),
        Register('vr14_32_1', 4, 0x42e8),
        Register('vr14_16_3', 2, 0x42e8),
        Register('vr14_8_7', 1, 0x42e8),
        Register('vr14_8_6', 1, 0x42e9),
        Register('vr14_16_2', 2, 0x42ea),
        Register('vr14_8_5', 1, 0x42ea),
        Register('vr14_8_4', 1, 0x42eb),
        Register('vr14_32_0', 4, 0x42ec),
        Register('vr14_16_1', 2, 0x42ec),
        Register('vr14_8_3', 1, 0x42ec),
        Register('vr14_8_2', 1, 0x42ed),
        Register('vr14_16_0', 2, 0x42ee),
        Register('vr14_8_1', 1, 0x42ee),
        Register('vr14_8_0', 1, 0x42ef),
        Register('vs47', 16, 0x42f0),
        Register('vr15_64_1', 8, 0x42f0),
        Register('vr15_32_3', 4, 0x42f0),
        Register('vr15_16_7', 2, 0x42f0),
        Register('vr15_8_15', 1, 0x42f0),
        Register('vr15_8_14', 1, 0x42f1),
        Register('vr15_16_6', 2, 0x42f2),
        Register('vr15_8_13', 1, 0x42f2),
        Register('vr15_8_12', 1, 0x42f3),
        Register('vr15_32_2', 4, 0x42f4),
        Register('vr15_16_5', 2, 0x42f4),
        Register('vr15_8_11', 1, 0x42f4),
        Register('vr15_8_10', 1, 0x42f5),
        Register('vr15_16_4', 2, 0x42f6),
        Register('vr15_8_9', 1, 0x42f6),
        Register('vr15_8_8', 1, 0x42f7),
        Register('vr15_64_0', 8, 0x42f8),
        Register('vr15_32_1', 4, 0x42f8),
        Register('vr15_16_3', 2, 0x42f8),
        Register('vr15_8_7', 1, 0x42f8),
        Register('vr15_8_6', 1, 0x42f9),
        Register('vr15_16_2', 2, 0x42fa),
        Register('vr15_8_5', 1, 0x42fa),
        Register('vr15_8_4', 1, 0x42fb),
        Register('vr15_32_0', 4, 0x42fc),
        Register('vr15_16_1', 2, 0x42fc),
        Register('vr15_8_3', 1, 0x42fc),
        Register('vr15_8_2', 1, 0x42fd),
        Register('vr15_16_0', 2, 0x42fe),
        Register('vr15_8_1', 1, 0x42fe),
        Register('vr15_8_0', 1, 0x42ff),
        Register('vs48', 16, 0x4300),
        Register('vr16_64_1', 8, 0x4300),
        Register('vr16_32_3', 4, 0x4300),
        Register('vr16_16_7', 2, 0x4300),
        Register('vr16_8_15', 1, 0x4300),
        Register('vr16_8_14', 1, 0x4301),
        Register('vr16_16_6', 2, 0x4302),
        Register('vr16_8_13', 1, 0x4302),
        Register('vr16_8_12', 1, 0x4303),
        Register('vr16_32_2', 4, 0x4304),
        Register('vr16_16_5', 2, 0x4304),
        Register('vr16_8_11', 1, 0x4304),
        Register('vr16_8_10', 1, 0x4305),
        Register('vr16_16_4', 2, 0x4306),
        Register('vr16_8_9', 1, 0x4306),
        Register('vr16_8_8', 1, 0x4307),
        Register('vr16_64_0', 8, 0x4308),
        Register('vr16_32_1', 4, 0x4308),
        Register('vr16_16_3', 2, 0x4308),
        Register('vr16_8_7', 1, 0x4308),
        Register('vr16_8_6', 1, 0x4309),
        Register('vr16_16_2', 2, 0x430a),
        Register('vr16_8_5', 1, 0x430a),
        Register('vr16_8_4', 1, 0x430b),
        Register('vr16_32_0', 4, 0x430c),
        Register('vr16_16_1', 2, 0x430c),
        Register('vr16_8_3', 1, 0x430c),
        Register('vr16_8_2', 1, 0x430d),
        Register('vr16_16_0', 2, 0x430e),
        Register('vr16_8_1', 1, 0x430e),
        Register('vr16_8_0', 1, 0x430f),
        Register('vs49', 16, 0x4310),
        Register('vr17_64_1', 8, 0x4310),
        Register('vr17_32_3', 4, 0x4310),
        Register('vr17_16_7', 2, 0x4310),
        Register('vr17_8_15', 1, 0x4310),
        Register('vr17_8_14', 1, 0x4311),
        Register('vr17_16_6', 2, 0x4312),
        Register('vr17_8_13', 1, 0x4312),
        Register('vr17_8_12', 1, 0x4313),
        Register('vr17_32_2', 4, 0x4314),
        Register('vr17_16_5', 2, 0x4314),
        Register('vr17_8_11', 1, 0x4314),
        Register('vr17_8_10', 1, 0x4315),
        Register('vr17_16_4', 2, 0x4316),
        Register('vr17_8_9', 1, 0x4316),
        Register('vr17_8_8', 1, 0x4317),
        Register('vr17_64_0', 8, 0x4318),
        Register('vr17_32_1', 4, 0x4318),
        Register('vr17_16_3', 2, 0x4318),
        Register('vr17_8_7', 1, 0x4318),
        Register('vr17_8_6', 1, 0x4319),
        Register('vr17_16_2', 2, 0x431a),
        Register('vr17_8_5', 1, 0x431a),
        Register('vr17_8_4', 1, 0x431b),
        Register('vr17_32_0', 4, 0x431c),
        Register('vr17_16_1', 2, 0x431c),
        Register('vr17_8_3', 1, 0x431c),
        Register('vr17_8_2', 1, 0x431d),
        Register('vr17_16_0', 2, 0x431e),
        Register('vr17_8_1', 1, 0x431e),
        Register('vr17_8_0', 1, 0x431f),
        Register('vs50', 16, 0x4320),
        Register('vr18_64_1', 8, 0x4320),
        Register('vr18_32_3', 4, 0x4320),
        Register('vr18_16_7', 2, 0x4320),
        Register('vr18_8_15', 1, 0x4320),
        Register('vr18_8_14', 1, 0x4321),
        Register('vr18_16_6', 2, 0x4322),
        Register('vr18_8_13', 1, 0x4322),
        Register('vr18_8_12', 1, 0x4323),
        Register('vr18_32_2', 4, 0x4324),
        Register('vr18_16_5', 2, 0x4324),
        Register('vr18_8_11', 1, 0x4324),
        Register('vr18_8_10', 1, 0x4325),
        Register('vr18_16_4', 2, 0x4326),
        Register('vr18_8_9', 1, 0x4326),
        Register('vr18_8_8', 1, 0x4327),
        Register('vr18_64_0', 8, 0x4328),
        Register('vr18_32_1', 4, 0x4328),
        Register('vr18_16_3', 2, 0x4328),
        Register('vr18_8_7', 1, 0x4328),
        Register('vr18_8_6', 1, 0x4329),
        Register('vr18_16_2', 2, 0x432a),
        Register('vr18_8_5', 1, 0x432a),
        Register('vr18_8_4', 1, 0x432b),
        Register('vr18_32_0', 4, 0x432c),
        Register('vr18_16_1', 2, 0x432c),
        Register('vr18_8_3', 1, 0x432c),
        Register('vr18_8_2', 1, 0x432d),
        Register('vr18_16_0', 2, 0x432e),
        Register('vr18_8_1', 1, 0x432e),
        Register('vr18_8_0', 1, 0x432f),
        Register('vs51', 16, 0x4330),
        Register('vr19_64_1', 8, 0x4330),
        Register('vr19_32_3', 4, 0x4330),
        Register('vr19_16_7', 2, 0x4330),
        Register('vr19_8_15', 1, 0x4330),
        Register('vr19_8_14', 1, 0x4331),
        Register('vr19_16_6', 2, 0x4332),
        Register('vr19_8_13', 1, 0x4332),
        Register('vr19_8_12', 1, 0x4333),
        Register('vr19_32_2', 4, 0x4334),
        Register('vr19_16_5', 2, 0x4334),
        Register('vr19_8_11', 1, 0x4334),
        Register('vr19_8_10', 1, 0x4335),
        Register('vr19_16_4', 2, 0x4336),
        Register('vr19_8_9', 1, 0x4336),
        Register('vr19_8_8', 1, 0x4337),
        Register('vr19_64_0', 8, 0x4338),
        Register('vr19_32_1', 4, 0x4338),
        Register('vr19_16_3', 2, 0x4338),
        Register('vr19_8_7', 1, 0x4338),
        Register('vr19_8_6', 1, 0x4339),
        Register('vr19_16_2', 2, 0x433a),
        Register('vr19_8_5', 1, 0x433a),
        Register('vr19_8_4', 1, 0x433b),
        Register('vr19_32_0', 4, 0x433c),
        Register('vr19_16_1', 2, 0x433c),
        Register('vr19_8_3', 1, 0x433c),
        Register('vr19_8_2', 1, 0x433d),
        Register('vr19_16_0', 2, 0x433e),
        Register('vr19_8_1', 1, 0x433e),
        Register('vr19_8_0', 1, 0x433f),
        Register('vs52', 16, 0x4340),
        Register('vr20_64_1', 8, 0x4340),
        Register('vr20_32_3', 4, 0x4340),
        Register('vr20_16_7', 2, 0x4340),
        Register('vr20_8_15', 1, 0x4340),
        Register('vr20_8_14', 1, 0x4341),
        Register('vr20_16_6', 2, 0x4342),
        Register('vr20_8_13', 1, 0x4342),
        Register('vr20_8_12', 1, 0x4343),
        Register('vr20_32_2', 4, 0x4344),
        Register('vr20_16_5', 2, 0x4344),
        Register('vr20_8_11', 1, 0x4344),
        Register('vr20_8_10', 1, 0x4345),
        Register('vr20_16_4', 2, 0x4346),
        Register('vr20_8_9', 1, 0x4346),
        Register('vr20_8_8', 1, 0x4347),
        Register('vr20_64_0', 8, 0x4348),
        Register('vr20_32_1', 4, 0x4348),
        Register('vr20_16_3', 2, 0x4348),
        Register('vr20_8_7', 1, 0x4348),
        Register('vr20_8_6', 1, 0x4349),
        Register('vr20_16_2', 2, 0x434a),
        Register('vr20_8_5', 1, 0x434a),
        Register('vr20_8_4', 1, 0x434b),
        Register('vr20_32_0', 4, 0x434c),
        Register('vr20_16_1', 2, 0x434c),
        Register('vr20_8_3', 1, 0x434c),
        Register('vr20_8_2', 1, 0x434d),
        Register('vr20_16_0', 2, 0x434e),
        Register('vr20_8_1', 1, 0x434e),
        Register('vr20_8_0', 1, 0x434f),
        Register('vs53', 16, 0x4350),
        Register('vr21_64_1', 8, 0x4350),
        Register('vr21_32_3', 4, 0x4350),
        Register('vr21_16_7', 2, 0x4350),
        Register('vr21_8_15', 1, 0x4350),
        Register('vr21_8_14', 1, 0x4351),
        Register('vr21_16_6', 2, 0x4352),
        Register('vr21_8_13', 1, 0x4352),
        Register('vr21_8_12', 1, 0x4353),
        Register('vr21_32_2', 4, 0x4354),
        Register('vr21_16_5', 2, 0x4354),
        Register('vr21_8_11', 1, 0x4354),
        Register('vr21_8_10', 1, 0x4355),
        Register('vr21_16_4', 2, 0x4356),
        Register('vr21_8_9', 1, 0x4356),
        Register('vr21_8_8', 1, 0x4357),
        Register('vr21_64_0', 8, 0x4358),
        Register('vr21_32_1', 4, 0x4358),
        Register('vr21_16_3', 2, 0x4358),
        Register('vr21_8_7', 1, 0x4358),
        Register('vr21_8_6', 1, 0x4359),
        Register('vr21_16_2', 2, 0x435a),
        Register('vr21_8_5', 1, 0x435a),
        Register('vr21_8_4', 1, 0x435b),
        Register('vr21_32_0', 4, 0x435c),
        Register('vr21_16_1', 2, 0x435c),
        Register('vr21_8_3', 1, 0x435c),
        Register('vr21_8_2', 1, 0x435d),
        Register('vr21_16_0', 2, 0x435e),
        Register('vr21_8_1', 1, 0x435e),
        Register('vr21_8_0', 1, 0x435f),
        Register('vs54', 16, 0x4360),
        Register('vr22_64_1', 8, 0x4360),
        Register('vr22_32_3', 4, 0x4360),
        Register('vr22_16_7', 2, 0x4360),
        Register('vr22_8_15', 1, 0x4360),
        Register('vr22_8_14', 1, 0x4361),
        Register('vr22_16_6', 2, 0x4362),
        Register('vr22_8_13', 1, 0x4362),
        Register('vr22_8_12', 1, 0x4363),
        Register('vr22_32_2', 4, 0x4364),
        Register('vr22_16_5', 2, 0x4364),
        Register('vr22_8_11', 1, 0x4364),
        Register('vr22_8_10', 1, 0x4365),
        Register('vr22_16_4', 2, 0x4366),
        Register('vr22_8_9', 1, 0x4366),
        Register('vr22_8_8', 1, 0x4367),
        Register('vr22_64_0', 8, 0x4368),
        Register('vr22_32_1', 4, 0x4368),
        Register('vr22_16_3', 2, 0x4368),
        Register('vr22_8_7', 1, 0x4368),
        Register('vr22_8_6', 1, 0x4369),
        Register('vr22_16_2', 2, 0x436a),
        Register('vr22_8_5', 1, 0x436a),
        Register('vr22_8_4', 1, 0x436b),
        Register('vr22_32_0', 4, 0x436c),
        Register('vr22_16_1', 2, 0x436c),
        Register('vr22_8_3', 1, 0x436c),
        Register('vr22_8_2', 1, 0x436d),
        Register('vr22_16_0', 2, 0x436e),
        Register('vr22_8_1', 1, 0x436e),
        Register('vr22_8_0', 1, 0x436f),
        Register('vs55', 16, 0x4370),
        Register('vr23_64_1', 8, 0x4370),
        Register('vr23_32_3', 4, 0x4370),
        Register('vr23_16_7', 2, 0x4370),
        Register('vr23_8_15', 1, 0x4370),
        Register('vr23_8_14', 1, 0x4371),
        Register('vr23_16_6', 2, 0x4372),
        Register('vr23_8_13', 1, 0x4372),
        Register('vr23_8_12', 1, 0x4373),
        Register('vr23_32_2', 4, 0x4374),
        Register('vr23_16_5', 2, 0x4374),
        Register('vr23_8_11', 1, 0x4374),
        Register('vr23_8_10', 1, 0x4375),
        Register('vr23_16_4', 2, 0x4376),
        Register('vr23_8_9', 1, 0x4376),
        Register('vr23_8_8', 1, 0x4377),
        Register('vr23_64_0', 8, 0x4378),
        Register('vr23_32_1', 4, 0x4378),
        Register('vr23_16_3', 2, 0x4378),
        Register('vr23_8_7', 1, 0x4378),
        Register('vr23_8_6', 1, 0x4379),
        Register('vr23_16_2', 2, 0x437a),
        Register('vr23_8_5', 1, 0x437a),
        Register('vr23_8_4', 1, 0x437b),
        Register('vr23_32_0', 4, 0x437c),
        Register('vr23_16_1', 2, 0x437c),
        Register('vr23_8_3', 1, 0x437c),
        Register('vr23_8_2', 1, 0x437d),
        Register('vr23_16_0', 2, 0x437e),
        Register('vr23_8_1', 1, 0x437e),
        Register('vr23_8_0', 1, 0x437f),
        Register('vs56', 16, 0x4380),
        Register('vr24_64_1', 8, 0x4380),
        Register('vr24_32_3', 4, 0x4380),
        Register('vr24_16_7', 2, 0x4380),
        Register('vr24_8_15', 1, 0x4380),
        Register('vr24_8_14', 1, 0x4381),
        Register('vr24_16_6', 2, 0x4382),
        Register('vr24_8_13', 1, 0x4382),
        Register('vr24_8_12', 1, 0x4383),
        Register('vr24_32_2', 4, 0x4384),
        Register('vr24_16_5', 2, 0x4384),
        Register('vr24_8_11', 1, 0x4384),
        Register('vr24_8_10', 1, 0x4385),
        Register('vr24_16_4', 2, 0x4386),
        Register('vr24_8_9', 1, 0x4386),
        Register('vr24_8_8', 1, 0x4387),
        Register('vr24_64_0', 8, 0x4388),
        Register('vr24_32_1', 4, 0x4388),
        Register('vr24_16_3', 2, 0x4388),
        Register('vr24_8_7', 1, 0x4388),
        Register('vr24_8_6', 1, 0x4389),
        Register('vr24_16_2', 2, 0x438a),
        Register('vr24_8_5', 1, 0x438a),
        Register('vr24_8_4', 1, 0x438b),
        Register('vr24_32_0', 4, 0x438c),
        Register('vr24_16_1', 2, 0x438c),
        Register('vr24_8_3', 1, 0x438c),
        Register('vr24_8_2', 1, 0x438d),
        Register('vr24_16_0', 2, 0x438e),
        Register('vr24_8_1', 1, 0x438e),
        Register('vr24_8_0', 1, 0x438f),
        Register('vs57', 16, 0x4390),
        Register('vr25_64_1', 8, 0x4390),
        Register('vr25_32_3', 4, 0x4390),
        Register('vr25_16_7', 2, 0x4390),
        Register('vr25_8_15', 1, 0x4390),
        Register('vr25_8_14', 1, 0x4391),
        Register('vr25_16_6', 2, 0x4392),
        Register('vr25_8_13', 1, 0x4392),
        Register('vr25_8_12', 1, 0x4393),
        Register('vr25_32_2', 4, 0x4394),
        Register('vr25_16_5', 2, 0x4394),
        Register('vr25_8_11', 1, 0x4394),
        Register('vr25_8_10', 1, 0x4395),
        Register('vr25_16_4', 2, 0x4396),
        Register('vr25_8_9', 1, 0x4396),
        Register('vr25_8_8', 1, 0x4397),
        Register('vr25_64_0', 8, 0x4398),
        Register('vr25_32_1', 4, 0x4398),
        Register('vr25_16_3', 2, 0x4398),
        Register('vr25_8_7', 1, 0x4398),
        Register('vr25_8_6', 1, 0x4399),
        Register('vr25_16_2', 2, 0x439a),
        Register('vr25_8_5', 1, 0x439a),
        Register('vr25_8_4', 1, 0x439b),
        Register('vr25_32_0', 4, 0x439c),
        Register('vr25_16_1', 2, 0x439c),
        Register('vr25_8_3', 1, 0x439c),
        Register('vr25_8_2', 1, 0x439d),
        Register('vr25_16_0', 2, 0x439e),
        Register('vr25_8_1', 1, 0x439e),
        Register('vr25_8_0', 1, 0x439f),
        Register('vs58', 16, 0x43a0),
        Register('vr26_64_1', 8, 0x43a0),
        Register('vr26_32_3', 4, 0x43a0),
        Register('vr26_16_7', 2, 0x43a0),
        Register('vr26_8_15', 1, 0x43a0),
        Register('vr26_8_14', 1, 0x43a1),
        Register('vr26_16_6', 2, 0x43a2),
        Register('vr26_8_13', 1, 0x43a2),
        Register('vr26_8_12', 1, 0x43a3),
        Register('vr26_32_2', 4, 0x43a4),
        Register('vr26_16_5', 2, 0x43a4),
        Register('vr26_8_11', 1, 0x43a4),
        Register('vr26_8_10', 1, 0x43a5),
        Register('vr26_16_4', 2, 0x43a6),
        Register('vr26_8_9', 1, 0x43a6),
        Register('vr26_8_8', 1, 0x43a7),
        Register('vr26_64_0', 8, 0x43a8),
        Register('vr26_32_1', 4, 0x43a8),
        Register('vr26_16_3', 2, 0x43a8),
        Register('vr26_8_7', 1, 0x43a8),
        Register('vr26_8_6', 1, 0x43a9),
        Register('vr26_16_2', 2, 0x43aa),
        Register('vr26_8_5', 1, 0x43aa),
        Register('vr26_8_4', 1, 0x43ab),
        Register('vr26_32_0', 4, 0x43ac),
        Register('vr26_16_1', 2, 0x43ac),
        Register('vr26_8_3', 1, 0x43ac),
        Register('vr26_8_2', 1, 0x43ad),
        Register('vr26_16_0', 2, 0x43ae),
        Register('vr26_8_1', 1, 0x43ae),
        Register('vr26_8_0', 1, 0x43af),
        Register('vs59', 16, 0x43b0),
        Register('vr27_64_1', 8, 0x43b0),
        Register('vr27_32_3', 4, 0x43b0),
        Register('vr27_16_7', 2, 0x43b0),
        Register('vr27_8_15', 1, 0x43b0),
        Register('vr27_8_14', 1, 0x43b1),
        Register('vr27_16_6', 2, 0x43b2),
        Register('vr27_8_13', 1, 0x43b2),
        Register('vr27_8_12', 1, 0x43b3),
        Register('vr27_32_2', 4, 0x43b4),
        Register('vr27_16_5', 2, 0x43b4),
        Register('vr27_8_11', 1, 0x43b4),
        Register('vr27_8_10', 1, 0x43b5),
        Register('vr27_16_4', 2, 0x43b6),
        Register('vr27_8_9', 1, 0x43b6),
        Register('vr27_8_8', 1, 0x43b7),
        Register('vr27_64_0', 8, 0x43b8),
        Register('vr27_32_1', 4, 0x43b8),
        Register('vr27_16_3', 2, 0x43b8),
        Register('vr27_8_7', 1, 0x43b8),
        Register('vr27_8_6', 1, 0x43b9),
        Register('vr27_16_2', 2, 0x43ba),
        Register('vr27_8_5', 1, 0x43ba),
        Register('vr27_8_4', 1, 0x43bb),
        Register('vr27_32_0', 4, 0x43bc),
        Register('vr27_16_1', 2, 0x43bc),
        Register('vr27_8_3', 1, 0x43bc),
        Register('vr27_8_2', 1, 0x43bd),
        Register('vr27_16_0', 2, 0x43be),
        Register('vr27_8_1', 1, 0x43be),
        Register('vr27_8_0', 1, 0x43bf),
        Register('vs60', 16, 0x43c0),
        Register('vr28_64_1', 8, 0x43c0),
        Register('vr28_32_3', 4, 0x43c0),
        Register('vr28_16_7', 2, 0x43c0),
        Register('vr28_8_15', 1, 0x43c0),
        Register('vr28_8_14', 1, 0x43c1),
        Register('vr28_16_6', 2, 0x43c2),
        Register('vr28_8_13', 1, 0x43c2),
        Register('vr28_8_12', 1, 0x43c3),
        Register('vr28_32_2', 4, 0x43c4),
        Register('vr28_16_5', 2, 0x43c4),
        Register('vr28_8_11', 1, 0x43c4),
        Register('vr28_8_10', 1, 0x43c5),
        Register('vr28_16_4', 2, 0x43c6),
        Register('vr28_8_9', 1, 0x43c6),
        Register('vr28_8_8', 1, 0x43c7),
        Register('vr28_64_0', 8, 0x43c8),
        Register('vr28_32_1', 4, 0x43c8),
        Register('vr28_16_3', 2, 0x43c8),
        Register('vr28_8_7', 1, 0x43c8),
        Register('vr28_8_6', 1, 0x43c9),
        Register('vr28_16_2', 2, 0x43ca),
        Register('vr28_8_5', 1, 0x43ca),
        Register('vr28_8_4', 1, 0x43cb),
        Register('vr28_32_0', 4, 0x43cc),
        Register('vr28_16_1', 2, 0x43cc),
        Register('vr28_8_3', 1, 0x43cc),
        Register('vr28_8_2', 1, 0x43cd),
        Register('vr28_16_0', 2, 0x43ce),
        Register('vr28_8_1', 1, 0x43ce),
        Register('vr28_8_0', 1, 0x43cf),
        Register('vs61', 16, 0x43d0),
        Register('vr29_64_1', 8, 0x43d0),
        Register('vr29_32_3', 4, 0x43d0),
        Register('vr29_16_7', 2, 0x43d0),
        Register('vr29_8_15', 1, 0x43d0),
        Register('vr29_8_14', 1, 0x43d1),
        Register('vr29_16_6', 2, 0x43d2),
        Register('vr29_8_13', 1, 0x43d2),
        Register('vr29_8_12', 1, 0x43d3),
        Register('vr29_32_2', 4, 0x43d4),
        Register('vr29_16_5', 2, 0x43d4),
        Register('vr29_8_11', 1, 0x43d4),
        Register('vr29_8_10', 1, 0x43d5),
        Register('vr29_16_4', 2, 0x43d6),
        Register('vr29_8_9', 1, 0x43d6),
        Register('vr29_8_8', 1, 0x43d7),
        Register('vr29_64_0', 8, 0x43d8),
        Register('vr29_32_1', 4, 0x43d8),
        Register('vr29_16_3', 2, 0x43d8),
        Register('vr29_8_7', 1, 0x43d8),
        Register('vr29_8_6', 1, 0x43d9),
        Register('vr29_16_2', 2, 0x43da),
        Register('vr29_8_5', 1, 0x43da),
        Register('vr29_8_4', 1, 0x43db),
        Register('vr29_32_0', 4, 0x43dc),
        Register('vr29_16_1', 2, 0x43dc),
        Register('vr29_8_3', 1, 0x43dc),
        Register('vr29_8_2', 1, 0x43dd),
        Register('vr29_16_0', 2, 0x43de),
        Register('vr29_8_1', 1, 0x43de),
        Register('vr29_8_0', 1, 0x43df),
        Register('vs62', 16, 0x43e0),
        Register('vr30_64_1', 8, 0x43e0),
        Register('vr30_32_3', 4, 0x43e0),
        Register('vr30_16_7', 2, 0x43e0),
        Register('vr30_8_15', 1, 0x43e0),
        Register('vr30_8_14', 1, 0x43e1),
        Register('vr30_16_6', 2, 0x43e2),
        Register('vr30_8_13', 1, 0x43e2),
        Register('vr30_8_12', 1, 0x43e3),
        Register('vr30_32_2', 4, 0x43e4),
        Register('vr30_16_5', 2, 0x43e4),
        Register('vr30_8_11', 1, 0x43e4),
        Register('vr30_8_10', 1, 0x43e5),
        Register('vr30_16_4', 2, 0x43e6),
        Register('vr30_8_9', 1, 0x43e6),
        Register('vr30_8_8', 1, 0x43e7),
        Register('vr30_64_0', 8, 0x43e8),
        Register('vr30_32_1', 4, 0x43e8),
        Register('vr30_16_3', 2, 0x43e8),
        Register('vr30_8_7', 1, 0x43e8),
        Register('vr30_8_6', 1, 0x43e9),
        Register('vr30_16_2', 2, 0x43ea),
        Register('vr30_8_5', 1, 0x43ea),
        Register('vr30_8_4', 1, 0x43eb),
        Register('vr30_32_0', 4, 0x43ec),
        Register('vr30_16_1', 2, 0x43ec),
        Register('vr30_8_3', 1, 0x43ec),
        Register('vr30_8_2', 1, 0x43ed),
        Register('vr30_16_0', 2, 0x43ee),
        Register('vr30_8_1', 1, 0x43ee),
        Register('vr30_8_0', 1, 0x43ef),
        Register('vs63', 16, 0x43f0),
        Register('vr31_64_1', 8, 0x43f0),
        Register('vr31_32_3', 4, 0x43f0),
        Register('vr31_16_7', 2, 0x43f0),
        Register('vr31_8_15', 1, 0x43f0),
        Register('vr31_8_14', 1, 0x43f1),
        Register('vr31_16_6', 2, 0x43f2),
        Register('vr31_8_13', 1, 0x43f2),
        Register('vr31_8_12', 1, 0x43f3),
        Register('vr31_32_2', 4, 0x43f4),
        Register('vr31_16_5', 2, 0x43f4),
        Register('vr31_8_11', 1, 0x43f4),
        Register('vr31_8_10', 1, 0x43f5),
        Register('vr31_16_4', 2, 0x43f6),
        Register('vr31_8_9', 1, 0x43f6),
        Register('vr31_8_8', 1, 0x43f7),
        Register('vr31_64_0', 8, 0x43f8),
        Register('vr31_32_1', 4, 0x43f8),
        Register('vr31_16_3', 2, 0x43f8),
        Register('vr31_8_7', 1, 0x43f8),
        Register('vr31_8_6', 1, 0x43f9),
        Register('vr31_16_2', 2, 0x43fa),
        Register('vr31_8_5', 1, 0x43fa),
        Register('vr31_8_4', 1, 0x43fb),
        Register('vr31_32_0', 4, 0x43fc),
        Register('vr31_16_1', 2, 0x43fc),
        Register('vr31_8_3', 1, 0x43fc),
        Register('vr31_8_2', 1, 0x43fd),
        Register('vr31_16_0', 2, 0x43fe),
        Register('vr31_8_1', 1, 0x43fe),
        Register('vr31_8_0', 1, 0x43ff),
        Register('contextreg', 4, 0x6000),
        Register('dcr000', 4, 0x7000),
        Register('dcr001', 4, 0x7004),
        Register('dcr002', 4, 0x7008),
        Register('dcr003', 4, 0x700c),
        Register('dcr004', 4, 0x7010),
        Register('dcr005', 4, 0x7014),
        Register('dcr006', 4, 0x7018),
        Register('dcr007', 4, 0x701c),
        Register('dcr008', 4, 0x7020),
        Register('dcr009', 4, 0x7024),
        Register('dcr00a', 4, 0x7028),
        Register('dcr00b', 4, 0x702c),
        Register('dcr00c', 4, 0x7030),
        Register('dcr00d', 4, 0x7034),
        Register('dcr00e', 4, 0x7038),
        Register('dcr00f', 4, 0x703c),
        Register('dcr010', 4, 0x7040),
        Register('dcr011', 4, 0x7044),
        Register('dcr012', 4, 0x7048),
        Register('dcr013', 4, 0x704c),
        Register('dcr014', 4, 0x7050),
        Register('dcr015', 4, 0x7054),
        Register('dcr016', 4, 0x7058),
        Register('dcr017', 4, 0x705c),
        Register('dcr018', 4, 0x7060),
        Register('dcr019', 4, 0x7064),
        Register('dcr01a', 4, 0x7068),
        Register('dcr01b', 4, 0x706c),
        Register('dcr01c', 4, 0x7070),
        Register('dcr01d', 4, 0x7074),
        Register('dcr01e', 4, 0x7078),
        Register('dcr01f', 4, 0x707c),
        Register('dcr020', 4, 0x7080),
        Register('dcr021', 4, 0x7084),
        Register('dcr022', 4, 0x7088),
        Register('dcr023', 4, 0x708c),
        Register('dcr024', 4, 0x7090),
        Register('dcr025', 4, 0x7094),
        Register('dcr026', 4, 0x7098),
        Register('dcr027', 4, 0x709c),
        Register('dcr028', 4, 0x70a0),
        Register('dcr029', 4, 0x70a4),
        Register('dcr02a', 4, 0x70a8),
        Register('dcr02b', 4, 0x70ac),
        Register('dcr02c', 4, 0x70b0),
        Register('dcr02d', 4, 0x70b4),
        Register('dcr02e', 4, 0x70b8),
        Register('dcr02f', 4, 0x70bc),
        Register('dcr030', 4, 0x70c0),
        Register('dcr031', 4, 0x70c4),
        Register('dcr032', 4, 0x70c8),
        Register('dcr033', 4, 0x70cc),
        Register('dcr034', 4, 0x70d0),
        Register('dcr035', 4, 0x70d4),
        Register('dcr036', 4, 0x70d8),
        Register('dcr037', 4, 0x70dc),
        Register('dcr038', 4, 0x70e0),
        Register('dcr039', 4, 0x70e4),
        Register('dcr03a', 4, 0x70e8),
        Register('dcr03b', 4, 0x70ec),
        Register('dcr03c', 4, 0x70f0),
        Register('dcr03d', 4, 0x70f4),
        Register('dcr03e', 4, 0x70f8),
        Register('dcr03f', 4, 0x70fc),
        Register('dcr040', 4, 0x7100),
        Register('dcr041', 4, 0x7104),
        Register('dcr042', 4, 0x7108),
        Register('dcr043', 4, 0x710c),
        Register('dcr044', 4, 0x7110),
        Register('dcr045', 4, 0x7114),
        Register('dcr046', 4, 0x7118),
        Register('dcr047', 4, 0x711c),
        Register('dcr048', 4, 0x7120),
        Register('dcr049', 4, 0x7124),
        Register('dcr04a', 4, 0x7128),
        Register('dcr04b', 4, 0x712c),
        Register('dcr04c', 4, 0x7130),
        Register('dcr04d', 4, 0x7134),
        Register('dcr04e', 4, 0x7138),
        Register('dcr04f', 4, 0x713c),
        Register('dcr050', 4, 0x7140),
        Register('dcr051', 4, 0x7144),
        Register('dcr052', 4, 0x7148),
        Register('dcr053', 4, 0x714c),
        Register('dcr054', 4, 0x7150),
        Register('dcr055', 4, 0x7154),
        Register('dcr056', 4, 0x7158),
        Register('dcr057', 4, 0x715c),
        Register('dcr058', 4, 0x7160),
        Register('dcr059', 4, 0x7164),
        Register('dcr05a', 4, 0x7168),
        Register('dcr05b', 4, 0x716c),
        Register('dcr05c', 4, 0x7170),
        Register('dcr05d', 4, 0x7174),
        Register('dcr05e', 4, 0x7178),
        Register('dcr05f', 4, 0x717c),
        Register('dcr060', 4, 0x7180),
        Register('dcr061', 4, 0x7184),
        Register('dcr062', 4, 0x7188),
        Register('dcr063', 4, 0x718c),
        Register('dcr064', 4, 0x7190),
        Register('dcr065', 4, 0x7194),
        Register('dcr066', 4, 0x7198),
        Register('dcr067', 4, 0x719c),
        Register('dcr068', 4, 0x71a0),
        Register('dcr069', 4, 0x71a4),
        Register('dcr06a', 4, 0x71a8),
        Register('dcr06b', 4, 0x71ac),
        Register('dcr06c', 4, 0x71b0),
        Register('dcr06d', 4, 0x71b4),
        Register('dcr06e', 4, 0x71b8),
        Register('dcr06f', 4, 0x71bc),
        Register('dcr070', 4, 0x71c0),
        Register('dcr071', 4, 0x71c4),
        Register('dcr072', 4, 0x71c8),
        Register('dcr073', 4, 0x71cc),
        Register('dcr074', 4, 0x71d0),
        Register('dcr075', 4, 0x71d4),
        Register('dcr076', 4, 0x71d8),
        Register('dcr077', 4, 0x71dc),
        Register('dcr078', 4, 0x71e0),
        Register('dcr079', 4, 0x71e4),
        Register('dcr07a', 4, 0x71e8),
        Register('dcr07b', 4, 0x71ec),
        Register('dcr07c', 4, 0x71f0),
        Register('dcr07d', 4, 0x71f4),
        Register('dcr07e', 4, 0x71f8),
        Register('dcr07f', 4, 0x71fc),
        Register('dcr080', 4, 0x7200),
        Register('dcr081', 4, 0x7204),
        Register('dcr082', 4, 0x7208),
        Register('dcr083', 4, 0x720c),
        Register('dcr084', 4, 0x7210),
        Register('dcr085', 4, 0x7214),
        Register('dcr086', 4, 0x7218),
        Register('dcr087', 4, 0x721c),
        Register('dcr088', 4, 0x7220),
        Register('dcr089', 4, 0x7224),
        Register('dcr08a', 4, 0x7228),
        Register('dcr08b', 4, 0x722c),
        Register('dcr08c', 4, 0x7230),
        Register('dcr08d', 4, 0x7234),
        Register('dcr08e', 4, 0x7238),
        Register('dcr08f', 4, 0x723c),
        Register('dcr090', 4, 0x7240),
        Register('dcr091', 4, 0x7244),
        Register('dcr092', 4, 0x7248),
        Register('dcr093', 4, 0x724c),
        Register('dcr094', 4, 0x7250),
        Register('dcr095', 4, 0x7254),
        Register('dcr096', 4, 0x7258),
        Register('dcr097', 4, 0x725c),
        Register('dcr098', 4, 0x7260),
        Register('dcr099', 4, 0x7264),
        Register('dcr09a', 4, 0x7268),
        Register('dcr09b', 4, 0x726c),
        Register('dcr09c', 4, 0x7270),
        Register('dcr09d', 4, 0x7274),
        Register('dcr09e', 4, 0x7278),
        Register('dcr09f', 4, 0x727c),
        Register('dcr0a0', 4, 0x7280),
        Register('dcr0a1', 4, 0x7284),
        Register('dcr0a2', 4, 0x7288),
        Register('dcr0a3', 4, 0x728c),
        Register('dcr0a4', 4, 0x7290),
        Register('dcr0a5', 4, 0x7294),
        Register('dcr0a6', 4, 0x7298),
        Register('dcr0a7', 4, 0x729c),
        Register('dcr0a8', 4, 0x72a0),
        Register('dcr0a9', 4, 0x72a4),
        Register('dcr0aa', 4, 0x72a8),
        Register('dcr0ab', 4, 0x72ac),
        Register('dcr0ac', 4, 0x72b0),
        Register('dcr0ad', 4, 0x72b4),
        Register('dcr0ae', 4, 0x72b8),
        Register('dcr0af', 4, 0x72bc),
        Register('dcr0b0', 4, 0x72c0),
        Register('dcr0b1', 4, 0x72c4),
        Register('dcr0b2', 4, 0x72c8),
        Register('dcr0b3', 4, 0x72cc),
        Register('dcr0b4', 4, 0x72d0),
        Register('dcr0b5', 4, 0x72d4),
        Register('dcr0b6', 4, 0x72d8),
        Register('dcr0b7', 4, 0x72dc),
        Register('dcr0b8', 4, 0x72e0),
        Register('dcr0b9', 4, 0x72e4),
        Register('dcr0ba', 4, 0x72e8),
        Register('dcr0bb', 4, 0x72ec),
        Register('dcr0bc', 4, 0x72f0),
        Register('dcr0bd', 4, 0x72f4),
        Register('dcr0be', 4, 0x72f8),
        Register('dcr0bf', 4, 0x72fc),
        Register('dcr0c0', 4, 0x7300),
        Register('dcr0c1', 4, 0x7304),
        Register('dcr0c2', 4, 0x7308),
        Register('dcr0c3', 4, 0x730c),
        Register('dcr0c4', 4, 0x7310),
        Register('dcr0c5', 4, 0x7314),
        Register('dcr0c6', 4, 0x7318),
        Register('dcr0c7', 4, 0x731c),
        Register('dcr0c8', 4, 0x7320),
        Register('dcr0c9', 4, 0x7324),
        Register('dcr0ca', 4, 0x7328),
        Register('dcr0cb', 4, 0x732c),
        Register('dcr0cc', 4, 0x7330),
        Register('dcr0cd', 4, 0x7334),
        Register('dcr0ce', 4, 0x7338),
        Register('dcr0cf', 4, 0x733c),
        Register('dcr0d0', 4, 0x7340),
        Register('dcr0d1', 4, 0x7344),
        Register('dcr0d2', 4, 0x7348),
        Register('dcr0d3', 4, 0x734c),
        Register('dcr0d4', 4, 0x7350),
        Register('dcr0d5', 4, 0x7354),
        Register('dcr0d6', 4, 0x7358),
        Register('dcr0d7', 4, 0x735c),
        Register('dcr0d8', 4, 0x7360),
        Register('dcr0d9', 4, 0x7364),
        Register('dcr0da', 4, 0x7368),
        Register('dcr0db', 4, 0x736c),
        Register('dcr0dc', 4, 0x7370),
        Register('dcr0dd', 4, 0x7374),
        Register('dcr0de', 4, 0x7378),
        Register('dcr0df', 4, 0x737c),
        Register('dcr0e0', 4, 0x7380),
        Register('dcr0e1', 4, 0x7384),
        Register('dcr0e2', 4, 0x7388),
        Register('dcr0e3', 4, 0x738c),
        Register('dcr0e4', 4, 0x7390),
        Register('dcr0e5', 4, 0x7394),
        Register('dcr0e6', 4, 0x7398),
        Register('dcr0e7', 4, 0x739c),
        Register('dcr0e8', 4, 0x73a0),
        Register('dcr0e9', 4, 0x73a4),
        Register('dcr0ea', 4, 0x73a8),
        Register('dcr0eb', 4, 0x73ac),
        Register('dcr0ec', 4, 0x73b0),
        Register('dcr0ed', 4, 0x73b4),
        Register('dcr0ee', 4, 0x73b8),
        Register('dcr0ef', 4, 0x73bc),
        Register('dcr0f0', 4, 0x73c0),
        Register('dcr0f1', 4, 0x73c4),
        Register('dcr0f2', 4, 0x73c8),
        Register('dcr0f3', 4, 0x73cc),
        Register('dcr0f4', 4, 0x73d0),
        Register('dcr0f5', 4, 0x73d4),
        Register('dcr0f6', 4, 0x73d8),
        Register('dcr0f7', 4, 0x73dc),
        Register('dcr0f8', 4, 0x73e0),
        Register('dcr0f9', 4, 0x73e4),
        Register('dcr0fa', 4, 0x73e8),
        Register('dcr0fb', 4, 0x73ec),
        Register('dcr0fc', 4, 0x73f0),
        Register('dcr0fd', 4, 0x73f4),
        Register('dcr0fe', 4, 0x73f8),
        Register('dcr0ff', 4, 0x73fc),
        Register('dcr100', 4, 0x7400),
        Register('dcr101', 4, 0x7404),
        Register('dcr102', 4, 0x7408),
        Register('dcr103', 4, 0x740c),
        Register('dcr104', 4, 0x7410),
        Register('dcr105', 4, 0x7414),
        Register('dcr106', 4, 0x7418),
        Register('dcr107', 4, 0x741c),
        Register('dcr108', 4, 0x7420),
        Register('dcr109', 4, 0x7424),
        Register('dcr10a', 4, 0x7428),
        Register('dcr10b', 4, 0x742c),
        Register('dcr10c', 4, 0x7430),
        Register('dcr10d', 4, 0x7434),
        Register('dcr10e', 4, 0x7438),
        Register('dcr10f', 4, 0x743c),
        Register('dcr110', 4, 0x7440),
        Register('dcr111', 4, 0x7444),
        Register('dcr112', 4, 0x7448),
        Register('dcr113', 4, 0x744c),
        Register('dcr114', 4, 0x7450),
        Register('dcr115', 4, 0x7454),
        Register('dcr116', 4, 0x7458),
        Register('dcr117', 4, 0x745c),
        Register('dcr118', 4, 0x7460),
        Register('dcr119', 4, 0x7464),
        Register('dcr11a', 4, 0x7468),
        Register('dcr11b', 4, 0x746c),
        Register('dcr11c', 4, 0x7470),
        Register('dcr11d', 4, 0x7474),
        Register('dcr11e', 4, 0x7478),
        Register('dcr11f', 4, 0x747c),
        Register('dcr120', 4, 0x7480),
        Register('dcr121', 4, 0x7484),
        Register('dcr122', 4, 0x7488),
        Register('dcr123', 4, 0x748c),
        Register('dcr124', 4, 0x7490),
        Register('dcr125', 4, 0x7494),
        Register('dcr126', 4, 0x7498),
        Register('dcr127', 4, 0x749c),
        Register('dcr128', 4, 0x74a0),
        Register('dcr129', 4, 0x74a4),
        Register('dcr12a', 4, 0x74a8),
        Register('dcr12b', 4, 0x74ac),
        Register('dcr12c', 4, 0x74b0),
        Register('dcr12d', 4, 0x74b4),
        Register('dcr12e', 4, 0x74b8),
        Register('dcr12f', 4, 0x74bc),
        Register('dcr130', 4, 0x74c0),
        Register('dcr131', 4, 0x74c4),
        Register('dcr132', 4, 0x74c8),
        Register('dcr133', 4, 0x74cc),
        Register('dcr134', 4, 0x74d0),
        Register('dcr135', 4, 0x74d4),
        Register('dcr136', 4, 0x74d8),
        Register('dcr137', 4, 0x74dc),
        Register('dcr138', 4, 0x74e0),
        Register('dcr139', 4, 0x74e4),
        Register('dcr13a', 4, 0x74e8),
        Register('dcr13b', 4, 0x74ec),
        Register('dcr13c', 4, 0x74f0),
        Register('dcr13d', 4, 0x74f4),
        Register('dcr13e', 4, 0x74f8),
        Register('dcr13f', 4, 0x74fc),
        Register('dcr140', 4, 0x7500),
        Register('dcr141', 4, 0x7504),
        Register('dcr142', 4, 0x7508),
        Register('dcr143', 4, 0x750c),
        Register('dcr144', 4, 0x7510),
        Register('dcr145', 4, 0x7514),
        Register('dcr146', 4, 0x7518),
        Register('dcr147', 4, 0x751c),
        Register('dcr148', 4, 0x7520),
        Register('dcr149', 4, 0x7524),
        Register('dcr14a', 4, 0x7528),
        Register('dcr14b', 4, 0x752c),
        Register('dcr14c', 4, 0x7530),
        Register('dcr14d', 4, 0x7534),
        Register('dcr14e', 4, 0x7538),
        Register('dcr14f', 4, 0x753c),
        Register('dcr150', 4, 0x7540),
        Register('dcr151', 4, 0x7544),
        Register('dcr152', 4, 0x7548),
        Register('dcr153', 4, 0x754c),
        Register('dcr154', 4, 0x7550),
        Register('dcr155', 4, 0x7554),
        Register('dcr156', 4, 0x7558),
        Register('dcr157', 4, 0x755c),
        Register('dcr158', 4, 0x7560),
        Register('dcr159', 4, 0x7564),
        Register('dcr15a', 4, 0x7568),
        Register('dcr15b', 4, 0x756c),
        Register('dcr15c', 4, 0x7570),
        Register('dcr15d', 4, 0x7574),
        Register('dcr15e', 4, 0x7578),
        Register('dcr15f', 4, 0x757c),
        Register('dcr160', 4, 0x7580),
        Register('dcr161', 4, 0x7584),
        Register('dcr162', 4, 0x7588),
        Register('dcr163', 4, 0x758c),
        Register('dcr164', 4, 0x7590),
        Register('dcr165', 4, 0x7594),
        Register('dcr166', 4, 0x7598),
        Register('dcr167', 4, 0x759c),
        Register('dcr168', 4, 0x75a0),
        Register('dcr169', 4, 0x75a4),
        Register('dcr16a', 4, 0x75a8),
        Register('dcr16b', 4, 0x75ac),
        Register('dcr16c', 4, 0x75b0),
        Register('dcr16d', 4, 0x75b4),
        Register('dcr16e', 4, 0x75b8),
        Register('dcr16f', 4, 0x75bc),
        Register('dcr170', 4, 0x75c0),
        Register('dcr171', 4, 0x75c4),
        Register('dcr172', 4, 0x75c8),
        Register('dcr173', 4, 0x75cc),
        Register('dcr174', 4, 0x75d0),
        Register('dcr175', 4, 0x75d4),
        Register('dcr176', 4, 0x75d8),
        Register('dcr177', 4, 0x75dc),
        Register('dcr178', 4, 0x75e0),
        Register('dcr179', 4, 0x75e4),
        Register('dcr17a', 4, 0x75e8),
        Register('dcr17b', 4, 0x75ec),
        Register('dcr17c', 4, 0x75f0),
        Register('dcr17d', 4, 0x75f4),
        Register('dcr17e', 4, 0x75f8),
        Register('dcr17f', 4, 0x75fc),
        Register('dcr180', 4, 0x7600),
        Register('dcr181', 4, 0x7604),
        Register('dcr182', 4, 0x7608),
        Register('dcr183', 4, 0x760c),
        Register('dcr184', 4, 0x7610),
        Register('dcr185', 4, 0x7614),
        Register('dcr186', 4, 0x7618),
        Register('dcr187', 4, 0x761c),
        Register('dcr188', 4, 0x7620),
        Register('dcr189', 4, 0x7624),
        Register('dcr18a', 4, 0x7628),
        Register('dcr18b', 4, 0x762c),
        Register('dcr18c', 4, 0x7630),
        Register('dcr18d', 4, 0x7634),
        Register('dcr18e', 4, 0x7638),
        Register('dcr18f', 4, 0x763c),
        Register('dcr190', 4, 0x7640),
        Register('dcr191', 4, 0x7644),
        Register('dcr192', 4, 0x7648),
        Register('dcr193', 4, 0x764c),
        Register('dcr194', 4, 0x7650),
        Register('dcr195', 4, 0x7654),
        Register('dcr196', 4, 0x7658),
        Register('dcr197', 4, 0x765c),
        Register('dcr198', 4, 0x7660),
        Register('dcr199', 4, 0x7664),
        Register('dcr19a', 4, 0x7668),
        Register('dcr19b', 4, 0x766c),
        Register('dcr19c', 4, 0x7670),
        Register('dcr19d', 4, 0x7674),
        Register('dcr19e', 4, 0x7678),
        Register('dcr19f', 4, 0x767c),
        Register('dcr1a0', 4, 0x7680),
        Register('dcr1a1', 4, 0x7684),
        Register('dcr1a2', 4, 0x7688),
        Register('dcr1a3', 4, 0x768c),
        Register('dcr1a4', 4, 0x7690),
        Register('dcr1a5', 4, 0x7694),
        Register('dcr1a6', 4, 0x7698),
        Register('dcr1a7', 4, 0x769c),
        Register('dcr1a8', 4, 0x76a0),
        Register('dcr1a9', 4, 0x76a4),
        Register('dcr1aa', 4, 0x76a8),
        Register('dcr1ab', 4, 0x76ac),
        Register('dcr1ac', 4, 0x76b0),
        Register('dcr1ad', 4, 0x76b4),
        Register('dcr1ae', 4, 0x76b8),
        Register('dcr1af', 4, 0x76bc),
        Register('dcr1b0', 4, 0x76c0),
        Register('dcr1b1', 4, 0x76c4),
        Register('dcr1b2', 4, 0x76c8),
        Register('dcr1b3', 4, 0x76cc),
        Register('dcr1b4', 4, 0x76d0),
        Register('dcr1b5', 4, 0x76d4),
        Register('dcr1b6', 4, 0x76d8),
        Register('dcr1b7', 4, 0x76dc),
        Register('dcr1b8', 4, 0x76e0),
        Register('dcr1b9', 4, 0x76e4),
        Register('dcr1ba', 4, 0x76e8),
        Register('dcr1bb', 4, 0x76ec),
        Register('dcr1bc', 4, 0x76f0),
        Register('dcr1bd', 4, 0x76f4),
        Register('dcr1be', 4, 0x76f8),
        Register('dcr1bf', 4, 0x76fc),
        Register('dcr1c0', 4, 0x7700),
        Register('dcr1c1', 4, 0x7704),
        Register('dcr1c2', 4, 0x7708),
        Register('dcr1c3', 4, 0x770c),
        Register('dcr1c4', 4, 0x7710),
        Register('dcr1c5', 4, 0x7714),
        Register('dcr1c6', 4, 0x7718),
        Register('dcr1c7', 4, 0x771c),
        Register('dcr1c8', 4, 0x7720),
        Register('dcr1c9', 4, 0x7724),
        Register('dcr1ca', 4, 0x7728),
        Register('dcr1cb', 4, 0x772c),
        Register('dcr1cc', 4, 0x7730),
        Register('dcr1cd', 4, 0x7734),
        Register('dcr1ce', 4, 0x7738),
        Register('dcr1cf', 4, 0x773c),
        Register('dcr1d0', 4, 0x7740),
        Register('dcr1d1', 4, 0x7744),
        Register('dcr1d2', 4, 0x7748),
        Register('dcr1d3', 4, 0x774c),
        Register('dcr1d4', 4, 0x7750),
        Register('dcr1d5', 4, 0x7754),
        Register('dcr1d6', 4, 0x7758),
        Register('dcr1d7', 4, 0x775c),
        Register('dcr1d8', 4, 0x7760),
        Register('dcr1d9', 4, 0x7764),
        Register('dcr1da', 4, 0x7768),
        Register('dcr1db', 4, 0x776c),
        Register('dcr1dc', 4, 0x7770),
        Register('dcr1dd', 4, 0x7774),
        Register('dcr1de', 4, 0x7778),
        Register('dcr1df', 4, 0x777c),
        Register('dcr1e0', 4, 0x7780),
        Register('dcr1e1', 4, 0x7784),
        Register('dcr1e2', 4, 0x7788),
        Register('dcr1e3', 4, 0x778c),
        Register('dcr1e4', 4, 0x7790),
        Register('dcr1e5', 4, 0x7794),
        Register('dcr1e6', 4, 0x7798),
        Register('dcr1e7', 4, 0x779c),
        Register('dcr1e8', 4, 0x77a0),
        Register('dcr1e9', 4, 0x77a4),
        Register('dcr1ea', 4, 0x77a8),
        Register('dcr1eb', 4, 0x77ac),
        Register('dcr1ec', 4, 0x77b0),
        Register('dcr1ed', 4, 0x77b4),
        Register('dcr1ee', 4, 0x77b8),
        Register('dcr1ef', 4, 0x77bc),
        Register('dcr1f0', 4, 0x77c0),
        Register('dcr1f1', 4, 0x77c4),
        Register('dcr1f2', 4, 0x77c8),
        Register('dcr1f3', 4, 0x77cc),
        Register('dcr1f4', 4, 0x77d0),
        Register('dcr1f5', 4, 0x77d4),
        Register('dcr1f6', 4, 0x77d8),
        Register('dcr1f7', 4, 0x77dc),
        Register('dcr1f8', 4, 0x77e0),
        Register('dcr1f9', 4, 0x77e4),
        Register('dcr1fa', 4, 0x77e8),
        Register('dcr1fb', 4, 0x77ec),
        Register('dcr1fc', 4, 0x77f0),
        Register('dcr1fd', 4, 0x77f4),
        Register('dcr1fe', 4, 0x77f8),
        Register('dcr1ff', 4, 0x77fc),
        Register('dcr200', 4, 0x7800),
        Register('dcr201', 4, 0x7804),
        Register('dcr202', 4, 0x7808),
        Register('dcr203', 4, 0x780c),
        Register('dcr204', 4, 0x7810),
        Register('dcr205', 4, 0x7814),
        Register('dcr206', 4, 0x7818),
        Register('dcr207', 4, 0x781c),
        Register('dcr208', 4, 0x7820),
        Register('dcr209', 4, 0x7824),
        Register('dcr20a', 4, 0x7828),
        Register('dcr20b', 4, 0x782c),
        Register('dcr20c', 4, 0x7830),
        Register('dcr20d', 4, 0x7834),
        Register('dcr20e', 4, 0x7838),
        Register('dcr20f', 4, 0x783c),
        Register('dcr210', 4, 0x7840),
        Register('dcr211', 4, 0x7844),
        Register('dcr212', 4, 0x7848),
        Register('dcr213', 4, 0x784c),
        Register('dcr214', 4, 0x7850),
        Register('dcr215', 4, 0x7854),
        Register('dcr216', 4, 0x7858),
        Register('dcr217', 4, 0x785c),
        Register('dcr218', 4, 0x7860),
        Register('dcr219', 4, 0x7864),
        Register('dcr21a', 4, 0x7868),
        Register('dcr21b', 4, 0x786c),
        Register('dcr21c', 4, 0x7870),
        Register('dcr21d', 4, 0x7874),
        Register('dcr21e', 4, 0x7878),
        Register('dcr21f', 4, 0x787c),
        Register('dcr220', 4, 0x7880),
        Register('dcr221', 4, 0x7884),
        Register('dcr222', 4, 0x7888),
        Register('dcr223', 4, 0x788c),
        Register('dcr224', 4, 0x7890),
        Register('dcr225', 4, 0x7894),
        Register('dcr226', 4, 0x7898),
        Register('dcr227', 4, 0x789c),
        Register('dcr228', 4, 0x78a0),
        Register('dcr229', 4, 0x78a4),
        Register('dcr22a', 4, 0x78a8),
        Register('dcr22b', 4, 0x78ac),
        Register('dcr22c', 4, 0x78b0),
        Register('dcr22d', 4, 0x78b4),
        Register('dcr22e', 4, 0x78b8),
        Register('dcr22f', 4, 0x78bc),
        Register('dcr230', 4, 0x78c0),
        Register('dcr231', 4, 0x78c4),
        Register('dcr232', 4, 0x78c8),
        Register('dcr233', 4, 0x78cc),
        Register('dcr234', 4, 0x78d0),
        Register('dcr235', 4, 0x78d4),
        Register('dcr236', 4, 0x78d8),
        Register('dcr237', 4, 0x78dc),
        Register('dcr238', 4, 0x78e0),
        Register('dcr239', 4, 0x78e4),
        Register('dcr23a', 4, 0x78e8),
        Register('dcr23b', 4, 0x78ec),
        Register('dcr23c', 4, 0x78f0),
        Register('dcr23d', 4, 0x78f4),
        Register('dcr23e', 4, 0x78f8),
        Register('dcr23f', 4, 0x78fc),
        Register('dcr240', 4, 0x7900),
        Register('dcr241', 4, 0x7904),
        Register('dcr242', 4, 0x7908),
        Register('dcr243', 4, 0x790c),
        Register('dcr244', 4, 0x7910),
        Register('dcr245', 4, 0x7914),
        Register('dcr246', 4, 0x7918),
        Register('dcr247', 4, 0x791c),
        Register('dcr248', 4, 0x7920),
        Register('dcr249', 4, 0x7924),
        Register('dcr24a', 4, 0x7928),
        Register('dcr24b', 4, 0x792c),
        Register('dcr24c', 4, 0x7930),
        Register('dcr24d', 4, 0x7934),
        Register('dcr24e', 4, 0x7938),
        Register('dcr24f', 4, 0x793c),
        Register('dcr250', 4, 0x7940),
        Register('dcr251', 4, 0x7944),
        Register('dcr252', 4, 0x7948),
        Register('dcr253', 4, 0x794c),
        Register('dcr254', 4, 0x7950),
        Register('dcr255', 4, 0x7954),
        Register('dcr256', 4, 0x7958),
        Register('dcr257', 4, 0x795c),
        Register('dcr258', 4, 0x7960),
        Register('dcr259', 4, 0x7964),
        Register('dcr25a', 4, 0x7968),
        Register('dcr25b', 4, 0x796c),
        Register('dcr25c', 4, 0x7970),
        Register('dcr25d', 4, 0x7974),
        Register('dcr25e', 4, 0x7978),
        Register('dcr25f', 4, 0x797c),
        Register('dcr260', 4, 0x7980),
        Register('dcr261', 4, 0x7984),
        Register('dcr262', 4, 0x7988),
        Register('dcr263', 4, 0x798c),
        Register('dcr264', 4, 0x7990),
        Register('dcr265', 4, 0x7994),
        Register('dcr266', 4, 0x7998),
        Register('dcr267', 4, 0x799c),
        Register('dcr268', 4, 0x79a0),
        Register('dcr269', 4, 0x79a4),
        Register('dcr26a', 4, 0x79a8),
        Register('dcr26b', 4, 0x79ac),
        Register('dcr26c', 4, 0x79b0),
        Register('dcr26d', 4, 0x79b4),
        Register('dcr26e', 4, 0x79b8),
        Register('dcr26f', 4, 0x79bc),
        Register('dcr270', 4, 0x79c0),
        Register('dcr271', 4, 0x79c4),
        Register('dcr272', 4, 0x79c8),
        Register('dcr273', 4, 0x79cc),
        Register('dcr274', 4, 0x79d0),
        Register('dcr275', 4, 0x79d4),
        Register('dcr276', 4, 0x79d8),
        Register('dcr277', 4, 0x79dc),
        Register('dcr278', 4, 0x79e0),
        Register('dcr279', 4, 0x79e4),
        Register('dcr27a', 4, 0x79e8),
        Register('dcr27b', 4, 0x79ec),
        Register('dcr27c', 4, 0x79f0),
        Register('dcr27d', 4, 0x79f4),
        Register('dcr27e', 4, 0x79f8),
        Register('dcr27f', 4, 0x79fc),
        Register('dcr280', 4, 0x7a00),
        Register('dcr281', 4, 0x7a04),
        Register('dcr282', 4, 0x7a08),
        Register('dcr283', 4, 0x7a0c),
        Register('dcr284', 4, 0x7a10),
        Register('dcr285', 4, 0x7a14),
        Register('dcr286', 4, 0x7a18),
        Register('dcr287', 4, 0x7a1c),
        Register('dcr288', 4, 0x7a20),
        Register('dcr289', 4, 0x7a24),
        Register('dcr28a', 4, 0x7a28),
        Register('dcr28b', 4, 0x7a2c),
        Register('dcr28c', 4, 0x7a30),
        Register('dcr28d', 4, 0x7a34),
        Register('dcr28e', 4, 0x7a38),
        Register('dcr28f', 4, 0x7a3c),
        Register('dcr290', 4, 0x7a40),
        Register('dcr291', 4, 0x7a44),
        Register('dcr292', 4, 0x7a48),
        Register('dcr293', 4, 0x7a4c),
        Register('dcr294', 4, 0x7a50),
        Register('dcr295', 4, 0x7a54),
        Register('dcr296', 4, 0x7a58),
        Register('dcr297', 4, 0x7a5c),
        Register('dcr298', 4, 0x7a60),
        Register('dcr299', 4, 0x7a64),
        Register('dcr29a', 4, 0x7a68),
        Register('dcr29b', 4, 0x7a6c),
        Register('dcr29c', 4, 0x7a70),
        Register('dcr29d', 4, 0x7a74),
        Register('dcr29e', 4, 0x7a78),
        Register('dcr29f', 4, 0x7a7c),
        Register('dcr2a0', 4, 0x7a80),
        Register('dcr2a1', 4, 0x7a84),
        Register('dcr2a2', 4, 0x7a88),
        Register('dcr2a3', 4, 0x7a8c),
        Register('dcr2a4', 4, 0x7a90),
        Register('dcr2a5', 4, 0x7a94),
        Register('dcr2a6', 4, 0x7a98),
        Register('dcr2a7', 4, 0x7a9c),
        Register('dcr2a8', 4, 0x7aa0),
        Register('dcr2a9', 4, 0x7aa4),
        Register('dcr2aa', 4, 0x7aa8),
        Register('dcr2ab', 4, 0x7aac),
        Register('dcr2ac', 4, 0x7ab0),
        Register('dcr2ad', 4, 0x7ab4),
        Register('dcr2ae', 4, 0x7ab8),
        Register('dcr2af', 4, 0x7abc),
        Register('dcr2b0', 4, 0x7ac0),
        Register('dcr2b1', 4, 0x7ac4),
        Register('dcr2b2', 4, 0x7ac8),
        Register('dcr2b3', 4, 0x7acc),
        Register('dcr2b4', 4, 0x7ad0),
        Register('dcr2b5', 4, 0x7ad4),
        Register('dcr2b6', 4, 0x7ad8),
        Register('dcr2b7', 4, 0x7adc),
        Register('dcr2b8', 4, 0x7ae0),
        Register('dcr2b9', 4, 0x7ae4),
        Register('dcr2ba', 4, 0x7ae8),
        Register('dcr2bb', 4, 0x7aec),
        Register('dcr2bc', 4, 0x7af0),
        Register('dcr2bd', 4, 0x7af4),
        Register('dcr2be', 4, 0x7af8),
        Register('dcr2bf', 4, 0x7afc),
        Register('dcr2c0', 4, 0x7b00),
        Register('dcr2c1', 4, 0x7b04),
        Register('dcr2c2', 4, 0x7b08),
        Register('dcr2c3', 4, 0x7b0c),
        Register('dcr2c4', 4, 0x7b10),
        Register('dcr2c5', 4, 0x7b14),
        Register('dcr2c6', 4, 0x7b18),
        Register('dcr2c7', 4, 0x7b1c),
        Register('dcr2c8', 4, 0x7b20),
        Register('dcr2c9', 4, 0x7b24),
        Register('dcr2ca', 4, 0x7b28),
        Register('dcr2cb', 4, 0x7b2c),
        Register('dcr2cc', 4, 0x7b30),
        Register('dcr2cd', 4, 0x7b34),
        Register('dcr2ce', 4, 0x7b38),
        Register('dcr2cf', 4, 0x7b3c),
        Register('dcr2d0', 4, 0x7b40),
        Register('dcr2d1', 4, 0x7b44),
        Register('dcr2d2', 4, 0x7b48),
        Register('dcr2d3', 4, 0x7b4c),
        Register('dcr2d4', 4, 0x7b50),
        Register('dcr2d5', 4, 0x7b54),
        Register('dcr2d6', 4, 0x7b58),
        Register('dcr2d7', 4, 0x7b5c),
        Register('dcr2d8', 4, 0x7b60),
        Register('dcr2d9', 4, 0x7b64),
        Register('dcr2da', 4, 0x7b68),
        Register('dcr2db', 4, 0x7b6c),
        Register('dcr2dc', 4, 0x7b70),
        Register('dcr2dd', 4, 0x7b74),
        Register('dcr2de', 4, 0x7b78),
        Register('dcr2df', 4, 0x7b7c),
        Register('dcr2e0', 4, 0x7b80),
        Register('dcr2e1', 4, 0x7b84),
        Register('dcr2e2', 4, 0x7b88),
        Register('dcr2e3', 4, 0x7b8c),
        Register('dcr2e4', 4, 0x7b90),
        Register('dcr2e5', 4, 0x7b94),
        Register('dcr2e6', 4, 0x7b98),
        Register('dcr2e7', 4, 0x7b9c),
        Register('dcr2e8', 4, 0x7ba0),
        Register('dcr2e9', 4, 0x7ba4),
        Register('dcr2ea', 4, 0x7ba8),
        Register('dcr2eb', 4, 0x7bac),
        Register('dcr2ec', 4, 0x7bb0),
        Register('dcr2ed', 4, 0x7bb4),
        Register('dcr2ee', 4, 0x7bb8),
        Register('dcr2ef', 4, 0x7bbc),
        Register('dcr2f0', 4, 0x7bc0),
        Register('dcr2f1', 4, 0x7bc4),
        Register('dcr2f2', 4, 0x7bc8),
        Register('dcr2f3', 4, 0x7bcc),
        Register('dcr2f4', 4, 0x7bd0),
        Register('dcr2f5', 4, 0x7bd4),
        Register('dcr2f6', 4, 0x7bd8),
        Register('dcr2f7', 4, 0x7bdc),
        Register('dcr2f8', 4, 0x7be0),
        Register('dcr2f9', 4, 0x7be4),
        Register('dcr2fa', 4, 0x7be8),
        Register('dcr2fb', 4, 0x7bec),
        Register('dcr2fc', 4, 0x7bf0),
        Register('dcr2fd', 4, 0x7bf4),
        Register('dcr2fe', 4, 0x7bf8),
        Register('dcr2ff', 4, 0x7bfc),
        Register('dcr300', 4, 0x7c00),
        Register('dcr301', 4, 0x7c04),
        Register('dcr302', 4, 0x7c08),
        Register('dcr303', 4, 0x7c0c),
        Register('dcr304', 4, 0x7c10),
        Register('dcr305', 4, 0x7c14),
        Register('dcr306', 4, 0x7c18),
        Register('dcr307', 4, 0x7c1c),
        Register('dcr308', 4, 0x7c20),
        Register('dcr309', 4, 0x7c24),
        Register('dcr30a', 4, 0x7c28),
        Register('dcr30b', 4, 0x7c2c),
        Register('dcr30c', 4, 0x7c30),
        Register('dcr30d', 4, 0x7c34),
        Register('dcr30e', 4, 0x7c38),
        Register('dcr30f', 4, 0x7c3c),
        Register('dcr310', 4, 0x7c40),
        Register('dcr311', 4, 0x7c44),
        Register('dcr312', 4, 0x7c48),
        Register('dcr313', 4, 0x7c4c),
        Register('dcr314', 4, 0x7c50),
        Register('dcr315', 4, 0x7c54),
        Register('dcr316', 4, 0x7c58),
        Register('dcr317', 4, 0x7c5c),
        Register('dcr318', 4, 0x7c60),
        Register('dcr319', 4, 0x7c64),
        Register('dcr31a', 4, 0x7c68),
        Register('dcr31b', 4, 0x7c6c),
        Register('dcr31c', 4, 0x7c70),
        Register('dcr31d', 4, 0x7c74),
        Register('dcr31e', 4, 0x7c78),
        Register('dcr31f', 4, 0x7c7c),
        Register('dcr320', 4, 0x7c80),
        Register('dcr321', 4, 0x7c84),
        Register('dcr322', 4, 0x7c88),
        Register('dcr323', 4, 0x7c8c),
        Register('dcr324', 4, 0x7c90),
        Register('dcr325', 4, 0x7c94),
        Register('dcr326', 4, 0x7c98),
        Register('dcr327', 4, 0x7c9c),
        Register('dcr328', 4, 0x7ca0),
        Register('dcr329', 4, 0x7ca4),
        Register('dcr32a', 4, 0x7ca8),
        Register('dcr32b', 4, 0x7cac),
        Register('dcr32c', 4, 0x7cb0),
        Register('dcr32d', 4, 0x7cb4),
        Register('dcr32e', 4, 0x7cb8),
        Register('dcr32f', 4, 0x7cbc),
        Register('dcr330', 4, 0x7cc0),
        Register('dcr331', 4, 0x7cc4),
        Register('dcr332', 4, 0x7cc8),
        Register('dcr333', 4, 0x7ccc),
        Register('dcr334', 4, 0x7cd0),
        Register('dcr335', 4, 0x7cd4),
        Register('dcr336', 4, 0x7cd8),
        Register('dcr337', 4, 0x7cdc),
        Register('dcr338', 4, 0x7ce0),
        Register('dcr339', 4, 0x7ce4),
        Register('dcr33a', 4, 0x7ce8),
        Register('dcr33b', 4, 0x7cec),
        Register('dcr33c', 4, 0x7cf0),
        Register('dcr33d', 4, 0x7cf4),
        Register('dcr33e', 4, 0x7cf8),
        Register('dcr33f', 4, 0x7cfc),
        Register('dcr340', 4, 0x7d00),
        Register('dcr341', 4, 0x7d04),
        Register('dcr342', 4, 0x7d08),
        Register('dcr343', 4, 0x7d0c),
        Register('dcr344', 4, 0x7d10),
        Register('dcr345', 4, 0x7d14),
        Register('dcr346', 4, 0x7d18),
        Register('dcr347', 4, 0x7d1c),
        Register('dcr348', 4, 0x7d20),
        Register('dcr349', 4, 0x7d24),
        Register('dcr34a', 4, 0x7d28),
        Register('dcr34b', 4, 0x7d2c),
        Register('dcr34c', 4, 0x7d30),
        Register('dcr34d', 4, 0x7d34),
        Register('dcr34e', 4, 0x7d38),
        Register('dcr34f', 4, 0x7d3c),
        Register('dcr350', 4, 0x7d40),
        Register('dcr351', 4, 0x7d44),
        Register('dcr352', 4, 0x7d48),
        Register('dcr353', 4, 0x7d4c),
        Register('dcr354', 4, 0x7d50),
        Register('dcr355', 4, 0x7d54),
        Register('dcr356', 4, 0x7d58),
        Register('dcr357', 4, 0x7d5c),
        Register('dcr358', 4, 0x7d60),
        Register('dcr359', 4, 0x7d64),
        Register('dcr35a', 4, 0x7d68),
        Register('dcr35b', 4, 0x7d6c),
        Register('dcr35c', 4, 0x7d70),
        Register('dcr35d', 4, 0x7d74),
        Register('dcr35e', 4, 0x7d78),
        Register('dcr35f', 4, 0x7d7c),
        Register('dcr360', 4, 0x7d80),
        Register('dcr361', 4, 0x7d84),
        Register('dcr362', 4, 0x7d88),
        Register('dcr363', 4, 0x7d8c),
        Register('dcr364', 4, 0x7d90),
        Register('dcr365', 4, 0x7d94),
        Register('dcr366', 4, 0x7d98),
        Register('dcr367', 4, 0x7d9c),
        Register('dcr368', 4, 0x7da0),
        Register('dcr369', 4, 0x7da4),
        Register('dcr36a', 4, 0x7da8),
        Register('dcr36b', 4, 0x7dac),
        Register('dcr36c', 4, 0x7db0),
        Register('dcr36d', 4, 0x7db4),
        Register('dcr36e', 4, 0x7db8),
        Register('dcr36f', 4, 0x7dbc),
        Register('dcr370', 4, 0x7dc0),
        Register('dcr371', 4, 0x7dc4),
        Register('dcr372', 4, 0x7dc8),
        Register('dcr373', 4, 0x7dcc),
        Register('dcr374', 4, 0x7dd0),
        Register('dcr375', 4, 0x7dd4),
        Register('dcr376', 4, 0x7dd8),
        Register('dcr377', 4, 0x7ddc),
        Register('dcr378', 4, 0x7de0),
        Register('dcr379', 4, 0x7de4),
        Register('dcr37a', 4, 0x7de8),
        Register('dcr37b', 4, 0x7dec),
        Register('dcr37c', 4, 0x7df0),
        Register('dcr37d', 4, 0x7df4),
        Register('dcr37e', 4, 0x7df8),
        Register('dcr37f', 4, 0x7dfc),
        Register('dcr380', 4, 0x7e00),
        Register('dcr381', 4, 0x7e04),
        Register('dcr382', 4, 0x7e08),
        Register('dcr383', 4, 0x7e0c),
        Register('dcr384', 4, 0x7e10),
        Register('dcr385', 4, 0x7e14),
        Register('dcr386', 4, 0x7e18),
        Register('dcr387', 4, 0x7e1c),
        Register('dcr388', 4, 0x7e20),
        Register('dcr389', 4, 0x7e24),
        Register('dcr38a', 4, 0x7e28),
        Register('dcr38b', 4, 0x7e2c),
        Register('dcr38c', 4, 0x7e30),
        Register('dcr38d', 4, 0x7e34),
        Register('dcr38e', 4, 0x7e38),
        Register('dcr38f', 4, 0x7e3c),
        Register('dcr390', 4, 0x7e40),
        Register('dcr391', 4, 0x7e44),
        Register('dcr392', 4, 0x7e48),
        Register('dcr393', 4, 0x7e4c),
        Register('dcr394', 4, 0x7e50),
        Register('dcr395', 4, 0x7e54),
        Register('dcr396', 4, 0x7e58),
        Register('dcr397', 4, 0x7e5c),
        Register('dcr398', 4, 0x7e60),
        Register('dcr399', 4, 0x7e64),
        Register('dcr39a', 4, 0x7e68),
        Register('dcr39b', 4, 0x7e6c),
        Register('dcr39c', 4, 0x7e70),
        Register('dcr39d', 4, 0x7e74),
        Register('dcr39e', 4, 0x7e78),
        Register('dcr39f', 4, 0x7e7c),
        Register('dcr3a0', 4, 0x7e80),
        Register('dcr3a1', 4, 0x7e84),
        Register('dcr3a2', 4, 0x7e88),
        Register('dcr3a3', 4, 0x7e8c),
        Register('dcr3a4', 4, 0x7e90),
        Register('dcr3a5', 4, 0x7e94),
        Register('dcr3a6', 4, 0x7e98),
        Register('dcr3a7', 4, 0x7e9c),
        Register('dcr3a8', 4, 0x7ea0),
        Register('dcr3a9', 4, 0x7ea4),
        Register('dcr3aa', 4, 0x7ea8),
        Register('dcr3ab', 4, 0x7eac),
        Register('dcr3ac', 4, 0x7eb0),
        Register('dcr3ad', 4, 0x7eb4),
        Register('dcr3ae', 4, 0x7eb8),
        Register('dcr3af', 4, 0x7ebc),
        Register('dcr3b0', 4, 0x7ec0),
        Register('dcr3b1', 4, 0x7ec4),
        Register('dcr3b2', 4, 0x7ec8),
        Register('dcr3b3', 4, 0x7ecc),
        Register('dcr3b4', 4, 0x7ed0),
        Register('dcr3b5', 4, 0x7ed4),
        Register('dcr3b6', 4, 0x7ed8),
        Register('dcr3b7', 4, 0x7edc),
        Register('dcr3b8', 4, 0x7ee0),
        Register('dcr3b9', 4, 0x7ee4),
        Register('dcr3ba', 4, 0x7ee8),
        Register('dcr3bb', 4, 0x7eec),
        Register('dcr3bc', 4, 0x7ef0),
        Register('dcr3bd', 4, 0x7ef4),
        Register('dcr3be', 4, 0x7ef8),
        Register('dcr3bf', 4, 0x7efc),
        Register('dcr3c0', 4, 0x7f00),
        Register('dcr3c1', 4, 0x7f04),
        Register('dcr3c2', 4, 0x7f08),
        Register('dcr3c3', 4, 0x7f0c),
        Register('dcr3c4', 4, 0x7f10),
        Register('dcr3c5', 4, 0x7f14),
        Register('dcr3c6', 4, 0x7f18),
        Register('dcr3c7', 4, 0x7f1c),
        Register('dcr3c8', 4, 0x7f20),
        Register('dcr3c9', 4, 0x7f24),
        Register('dcr3ca', 4, 0x7f28),
        Register('dcr3cb', 4, 0x7f2c),
        Register('dcr3cc', 4, 0x7f30),
        Register('dcr3cd', 4, 0x7f34),
        Register('dcr3ce', 4, 0x7f38),
        Register('dcr3cf', 4, 0x7f3c),
        Register('dcr3d0', 4, 0x7f40),
        Register('dcr3d1', 4, 0x7f44),
        Register('dcr3d2', 4, 0x7f48),
        Register('dcr3d3', 4, 0x7f4c),
        Register('dcr3d4', 4, 0x7f50),
        Register('dcr3d5', 4, 0x7f54),
        Register('dcr3d6', 4, 0x7f58),
        Register('dcr3d7', 4, 0x7f5c),
        Register('dcr3d8', 4, 0x7f60),
        Register('dcr3d9', 4, 0x7f64),
        Register('dcr3da', 4, 0x7f68),
        Register('dcr3db', 4, 0x7f6c),
        Register('dcr3dc', 4, 0x7f70),
        Register('dcr3dd', 4, 0x7f74),
        Register('dcr3de', 4, 0x7f78),
        Register('dcr3df', 4, 0x7f7c),
        Register('dcr3e0', 4, 0x7f80),
        Register('dcr3e1', 4, 0x7f84),
        Register('dcr3e2', 4, 0x7f88),
        Register('dcr3e3', 4, 0x7f8c),
        Register('dcr3e4', 4, 0x7f90),
        Register('dcr3e5', 4, 0x7f94),
        Register('dcr3e6', 4, 0x7f98),
        Register('dcr3e7', 4, 0x7f9c),
        Register('dcr3e8', 4, 0x7fa0),
        Register('dcr3e9', 4, 0x7fa4),
        Register('dcr3ea', 4, 0x7fa8),
        Register('dcr3eb', 4, 0x7fac),
        Register('dcr3ec', 4, 0x7fb0),
        Register('dcr3ed', 4, 0x7fb4),
        Register('dcr3ee', 4, 0x7fb8),
        Register('dcr3ef', 4, 0x7fbc),
        Register('dcr3f0', 4, 0x7fc0),
        Register('dcr3f1', 4, 0x7fc4),
        Register('dcr3f2', 4, 0x7fc8),
        Register('dcr3f3', 4, 0x7fcc),
        Register('dcr3f4', 4, 0x7fd0),
        Register('dcr3f5', 4, 0x7fd4),
        Register('dcr3f6', 4, 0x7fd8),
        Register('dcr3f7', 4, 0x7fdc),
        Register('dcr3f8', 4, 0x7fe0),
        Register('dcr3f9', 4, 0x7fe4),
        Register('dcr3fa', 4, 0x7fe8),
        Register('dcr3fb', 4, 0x7fec),
        Register('dcr3fc', 4, 0x7ff0),
        Register('dcr3fd', 4, 0x7ff4),
        Register('dcr3fe', 4, 0x7ff8),
        Register('dcr3ff', 4, 0x7ffc),
        Register('acc', 8, 0x10000)
    ]

register_arch(['powerpc:le:32:default'], 32, Endness.LE, ArchPcode_PowerPC_LE_32_default)
