###
### This file was automatically generated
###

from archinfo.arch import register_arch, Endness, Register

from .common import ArchPcode


class ArchPcode_RISCV_LE_64_RV64IC(ArchPcode):
    name = 'RISCV:LE:64:RV64IC'
    pcode_arch = 'RISCV:LE:64:RV64IC'
    description = 'RISC-V 64 little base compressed'
    bits = 64
    ip_offset = 0x1000
    sp_offset = 0x2010
    bp_offset = sp_offset
    instruction_endness = Endness.LE
    register_list = [
        Register('pc', 8, 0x1000, alias_names=('ip',)),
        Register('reserve_address', 8, 0x1010),
        Register('reserve', 1, 0x1018),
        Register('reserve_length', 1, 0x101c),
        Register('zero', 8, 0x2000),
        Register('ra', 8, 0x2008),
        Register('sp', 8, 0x2010),
        Register('gp', 8, 0x2018),
        Register('tp', 8, 0x2020),
        Register('t0', 8, 0x2028),
        Register('t1', 8, 0x2030),
        Register('t2', 8, 0x2038),
        Register('s0', 8, 0x2040),
        Register('s1', 8, 0x2048),
        Register('a0', 8, 0x2050),
        Register('a1', 8, 0x2058),
        Register('a2', 8, 0x2060),
        Register('a3', 8, 0x2068),
        Register('a4', 8, 0x2070),
        Register('a5', 8, 0x2078),
        Register('a6', 8, 0x2080),
        Register('a7', 8, 0x2088),
        Register('s2', 8, 0x2090),
        Register('s3', 8, 0x2098),
        Register('s4', 8, 0x20a0),
        Register('s5', 8, 0x20a8),
        Register('s6', 8, 0x20b0),
        Register('s7', 8, 0x20b8),
        Register('s8', 8, 0x20c0),
        Register('s9', 8, 0x20c8),
        Register('s10', 8, 0x20d0),
        Register('s11', 8, 0x20d8),
        Register('t3', 8, 0x20e0),
        Register('t4', 8, 0x20e8),
        Register('t5', 8, 0x20f0),
        Register('t6', 8, 0x20f8),
        Register('ft0', 8, 0x3000),
        Register('ft1', 8, 0x3008),
        Register('ft2', 8, 0x3010),
        Register('ft3', 8, 0x3018),
        Register('ft4', 8, 0x3020),
        Register('ft5', 8, 0x3028),
        Register('ft6', 8, 0x3030),
        Register('ft7', 8, 0x3038),
        Register('fs0', 8, 0x3040),
        Register('fs1', 8, 0x3048),
        Register('fa0', 8, 0x3050),
        Register('fa1', 8, 0x3058),
        Register('fa2', 8, 0x3060),
        Register('fa3', 8, 0x3068),
        Register('fa4', 8, 0x3070),
        Register('fa5', 8, 0x3078),
        Register('fa6', 8, 0x3080),
        Register('fa7', 8, 0x3088),
        Register('fs2', 8, 0x3090),
        Register('fs3', 8, 0x3098),
        Register('fs4', 8, 0x30a0),
        Register('fs5', 8, 0x30a8),
        Register('fs6', 8, 0x30b0),
        Register('fs7', 8, 0x30b8),
        Register('fs8', 8, 0x30c0),
        Register('fs9', 8, 0x30c8),
        Register('fs10', 8, 0x30d0),
        Register('fs11', 8, 0x30d8),
        Register('ft8', 8, 0x30e0),
        Register('ft9', 8, 0x30e8),
        Register('ft10', 8, 0x30f0),
        Register('ft11', 8, 0x30f8),
        Register('v0', 256, 0x4000),
        Register('v1', 256, 0x4100),
        Register('v2', 256, 0x4200),
        Register('v3', 256, 0x4300),
        Register('v4', 256, 0x4400),
        Register('v5', 256, 0x4500),
        Register('v6', 256, 0x4600),
        Register('v7', 256, 0x4700),
        Register('v8', 256, 0x4800),
        Register('v9', 256, 0x4900),
        Register('v10', 256, 0x4a00),
        Register('v11', 256, 0x4b00),
        Register('v12', 256, 0x4c00),
        Register('v13', 256, 0x4d00),
        Register('v14', 256, 0x4e00),
        Register('v15', 256, 0x4f00),
        Register('v16', 256, 0x5000),
        Register('v17', 256, 0x5100),
        Register('v18', 256, 0x5200),
        Register('v19', 256, 0x5300),
        Register('v20', 256, 0x5400),
        Register('v21', 256, 0x5500),
        Register('v22', 256, 0x5600),
        Register('v23', 256, 0x5700),
        Register('v24', 256, 0x5800),
        Register('v25', 256, 0x5900),
        Register('v26', 256, 0x5a00),
        Register('v27', 256, 0x5b00),
        Register('v28', 256, 0x5c00),
        Register('v29', 256, 0x5d00),
        Register('v30', 256, 0x5e00),
        Register('v31', 256, 0x5f00),
        Register('ustatus', 8, 0x90000000),
        Register('fflags', 8, 0x90000008),
        Register('frm', 8, 0x90000010),
        Register('fcsr', 8, 0x90000018),
        Register('uie', 8, 0x90000020),
        Register('utvec', 8, 0x90000028),
        Register('csr006', 8, 0x90000030),
        Register('csr007', 8, 0x90000038),
        Register('vstart', 8, 0x90000040),
        Register('vxsat', 8, 0x90000048),
        Register('vxrm', 8, 0x90000050),
        Register('csr00b', 8, 0x90000058),
        Register('csr00c', 8, 0x90000060),
        Register('csr00d', 8, 0x90000068),
        Register('csr00e', 8, 0x90000070),
        Register('vcsr', 8, 0x90000078),
        Register('csr010', 8, 0x90000080),
        Register('csr011', 8, 0x90000088),
        Register('csr012', 8, 0x90000090),
        Register('csr013', 8, 0x90000098),
        Register('csr014', 8, 0x900000a0),
        Register('csr015', 8, 0x900000a8),
        Register('csr016', 8, 0x900000b0),
        Register('csr017', 8, 0x900000b8),
        Register('csr018', 8, 0x900000c0),
        Register('csr019', 8, 0x900000c8),
        Register('csr01a', 8, 0x900000d0),
        Register('csr01b', 8, 0x900000d8),
        Register('csr01c', 8, 0x900000e0),
        Register('csr01d', 8, 0x900000e8),
        Register('csr01e', 8, 0x900000f0),
        Register('csr01f', 8, 0x900000f8),
        Register('csr020', 8, 0x90000100),
        Register('csr021', 8, 0x90000108),
        Register('csr022', 8, 0x90000110),
        Register('csr023', 8, 0x90000118),
        Register('csr024', 8, 0x90000120),
        Register('csr025', 8, 0x90000128),
        Register('csr026', 8, 0x90000130),
        Register('csr027', 8, 0x90000138),
        Register('csr028', 8, 0x90000140),
        Register('csr029', 8, 0x90000148),
        Register('csr02a', 8, 0x90000150),
        Register('csr02b', 8, 0x90000158),
        Register('csr02c', 8, 0x90000160),
        Register('csr02d', 8, 0x90000168),
        Register('csr02e', 8, 0x90000170),
        Register('csr02f', 8, 0x90000178),
        Register('csr030', 8, 0x90000180),
        Register('csr031', 8, 0x90000188),
        Register('csr032', 8, 0x90000190),
        Register('csr033', 8, 0x90000198),
        Register('csr034', 8, 0x900001a0),
        Register('csr035', 8, 0x900001a8),
        Register('csr036', 8, 0x900001b0),
        Register('csr037', 8, 0x900001b8),
        Register('csr038', 8, 0x900001c0),
        Register('csr039', 8, 0x900001c8),
        Register('csr03a', 8, 0x900001d0),
        Register('csr03b', 8, 0x900001d8),
        Register('csr03c', 8, 0x900001e0),
        Register('csr03d', 8, 0x900001e8),
        Register('csr03e', 8, 0x900001f0),
        Register('csr03f', 8, 0x900001f8),
        Register('uscratch', 8, 0x90000200),
        Register('uepc', 8, 0x90000208),
        Register('ucause', 8, 0x90000210),
        Register('utval', 8, 0x90000218),
        Register('uip', 8, 0x90000220),
        Register('csr045', 8, 0x90000228),
        Register('csr046', 8, 0x90000230),
        Register('csr047', 8, 0x90000238),
        Register('csr048', 8, 0x90000240),
        Register('csr049', 8, 0x90000248),
        Register('csr04a', 8, 0x90000250),
        Register('csr04b', 8, 0x90000258),
        Register('csr04c', 8, 0x90000260),
        Register('csr04d', 8, 0x90000268),
        Register('csr04e', 8, 0x90000270),
        Register('csr04f', 8, 0x90000278),
        Register('csr050', 8, 0x90000280),
        Register('csr051', 8, 0x90000288),
        Register('csr052', 8, 0x90000290),
        Register('csr053', 8, 0x90000298),
        Register('csr054', 8, 0x900002a0),
        Register('csr055', 8, 0x900002a8),
        Register('csr056', 8, 0x900002b0),
        Register('csr057', 8, 0x900002b8),
        Register('csr058', 8, 0x900002c0),
        Register('csr059', 8, 0x900002c8),
        Register('csr05a', 8, 0x900002d0),
        Register('csr05b', 8, 0x900002d8),
        Register('csr05c', 8, 0x900002e0),
        Register('csr05d', 8, 0x900002e8),
        Register('csr05e', 8, 0x900002f0),
        Register('csr05f', 8, 0x900002f8),
        Register('csr060', 8, 0x90000300),
        Register('csr061', 8, 0x90000308),
        Register('csr062', 8, 0x90000310),
        Register('csr063', 8, 0x90000318),
        Register('csr064', 8, 0x90000320),
        Register('csr065', 8, 0x90000328),
        Register('csr066', 8, 0x90000330),
        Register('csr067', 8, 0x90000338),
        Register('csr068', 8, 0x90000340),
        Register('csr069', 8, 0x90000348),
        Register('csr06a', 8, 0x90000350),
        Register('csr06b', 8, 0x90000358),
        Register('csr06c', 8, 0x90000360),
        Register('csr06d', 8, 0x90000368),
        Register('csr06e', 8, 0x90000370),
        Register('csr06f', 8, 0x90000378),
        Register('csr070', 8, 0x90000380),
        Register('csr071', 8, 0x90000388),
        Register('csr072', 8, 0x90000390),
        Register('csr073', 8, 0x90000398),
        Register('csr074', 8, 0x900003a0),
        Register('csr075', 8, 0x900003a8),
        Register('csr076', 8, 0x900003b0),
        Register('csr077', 8, 0x900003b8),
        Register('csr078', 8, 0x900003c0),
        Register('csr079', 8, 0x900003c8),
        Register('csr07a', 8, 0x900003d0),
        Register('csr07b', 8, 0x900003d8),
        Register('csr07c', 8, 0x900003e0),
        Register('csr07d', 8, 0x900003e8),
        Register('csr07e', 8, 0x900003f0),
        Register('csr07f', 8, 0x900003f8),
        Register('csr080', 8, 0x90000400),
        Register('csr081', 8, 0x90000408),
        Register('csr082', 8, 0x90000410),
        Register('csr083', 8, 0x90000418),
        Register('csr084', 8, 0x90000420),
        Register('csr085', 8, 0x90000428),
        Register('csr086', 8, 0x90000430),
        Register('csr087', 8, 0x90000438),
        Register('csr088', 8, 0x90000440),
        Register('csr089', 8, 0x90000448),
        Register('csr08a', 8, 0x90000450),
        Register('csr08b', 8, 0x90000458),
        Register('csr08c', 8, 0x90000460),
        Register('csr08d', 8, 0x90000468),
        Register('csr08e', 8, 0x90000470),
        Register('csr08f', 8, 0x90000478),
        Register('csr090', 8, 0x90000480),
        Register('csr091', 8, 0x90000488),
        Register('csr092', 8, 0x90000490),
        Register('csr093', 8, 0x90000498),
        Register('csr094', 8, 0x900004a0),
        Register('csr095', 8, 0x900004a8),
        Register('csr096', 8, 0x900004b0),
        Register('csr097', 8, 0x900004b8),
        Register('csr098', 8, 0x900004c0),
        Register('csr099', 8, 0x900004c8),
        Register('csr09a', 8, 0x900004d0),
        Register('csr09b', 8, 0x900004d8),
        Register('csr09c', 8, 0x900004e0),
        Register('csr09d', 8, 0x900004e8),
        Register('csr09e', 8, 0x900004f0),
        Register('csr09f', 8, 0x900004f8),
        Register('csr0a0', 8, 0x90000500),
        Register('csr0a1', 8, 0x90000508),
        Register('csr0a2', 8, 0x90000510),
        Register('csr0a3', 8, 0x90000518),
        Register('csr0a4', 8, 0x90000520),
        Register('csr0a5', 8, 0x90000528),
        Register('csr0a6', 8, 0x90000530),
        Register('csr0a7', 8, 0x90000538),
        Register('csr0a8', 8, 0x90000540),
        Register('csr0a9', 8, 0x90000548),
        Register('csr0aa', 8, 0x90000550),
        Register('csr0ab', 8, 0x90000558),
        Register('csr0ac', 8, 0x90000560),
        Register('csr0ad', 8, 0x90000568),
        Register('csr0ae', 8, 0x90000570),
        Register('csr0af', 8, 0x90000578),
        Register('csr0b0', 8, 0x90000580),
        Register('csr0b1', 8, 0x90000588),
        Register('csr0b2', 8, 0x90000590),
        Register('csr0b3', 8, 0x90000598),
        Register('csr0b4', 8, 0x900005a0),
        Register('csr0b5', 8, 0x900005a8),
        Register('csr0b6', 8, 0x900005b0),
        Register('csr0b7', 8, 0x900005b8),
        Register('csr0b8', 8, 0x900005c0),
        Register('csr0b9', 8, 0x900005c8),
        Register('csr0ba', 8, 0x900005d0),
        Register('csr0bb', 8, 0x900005d8),
        Register('csr0bc', 8, 0x900005e0),
        Register('csr0bd', 8, 0x900005e8),
        Register('csr0be', 8, 0x900005f0),
        Register('csr0bf', 8, 0x900005f8),
        Register('csr0c0', 8, 0x90000600),
        Register('csr0c1', 8, 0x90000608),
        Register('csr0c2', 8, 0x90000610),
        Register('csr0c3', 8, 0x90000618),
        Register('csr0c4', 8, 0x90000620),
        Register('csr0c5', 8, 0x90000628),
        Register('csr0c6', 8, 0x90000630),
        Register('csr0c7', 8, 0x90000638),
        Register('csr0c8', 8, 0x90000640),
        Register('csr0c9', 8, 0x90000648),
        Register('csr0ca', 8, 0x90000650),
        Register('csr0cb', 8, 0x90000658),
        Register('csr0cc', 8, 0x90000660),
        Register('csr0cd', 8, 0x90000668),
        Register('csr0ce', 8, 0x90000670),
        Register('csr0cf', 8, 0x90000678),
        Register('csr0d0', 8, 0x90000680),
        Register('csr0d1', 8, 0x90000688),
        Register('csr0d2', 8, 0x90000690),
        Register('csr0d3', 8, 0x90000698),
        Register('csr0d4', 8, 0x900006a0),
        Register('csr0d5', 8, 0x900006a8),
        Register('csr0d6', 8, 0x900006b0),
        Register('csr0d7', 8, 0x900006b8),
        Register('csr0d8', 8, 0x900006c0),
        Register('csr0d9', 8, 0x900006c8),
        Register('csr0da', 8, 0x900006d0),
        Register('csr0db', 8, 0x900006d8),
        Register('csr0dc', 8, 0x900006e0),
        Register('csr0dd', 8, 0x900006e8),
        Register('csr0de', 8, 0x900006f0),
        Register('csr0df', 8, 0x900006f8),
        Register('csr0e0', 8, 0x90000700),
        Register('csr0e1', 8, 0x90000708),
        Register('csr0e2', 8, 0x90000710),
        Register('csr0e3', 8, 0x90000718),
        Register('csr0e4', 8, 0x90000720),
        Register('csr0e5', 8, 0x90000728),
        Register('csr0e6', 8, 0x90000730),
        Register('csr0e7', 8, 0x90000738),
        Register('csr0e8', 8, 0x90000740),
        Register('csr0e9', 8, 0x90000748),
        Register('csr0ea', 8, 0x90000750),
        Register('csr0eb', 8, 0x90000758),
        Register('csr0ec', 8, 0x90000760),
        Register('csr0ed', 8, 0x90000768),
        Register('csr0ee', 8, 0x90000770),
        Register('csr0ef', 8, 0x90000778),
        Register('csr0f0', 8, 0x90000780),
        Register('csr0f1', 8, 0x90000788),
        Register('csr0f2', 8, 0x90000790),
        Register('csr0f3', 8, 0x90000798),
        Register('csr0f4', 8, 0x900007a0),
        Register('csr0f5', 8, 0x900007a8),
        Register('csr0f6', 8, 0x900007b0),
        Register('csr0f7', 8, 0x900007b8),
        Register('csr0f8', 8, 0x900007c0),
        Register('csr0f9', 8, 0x900007c8),
        Register('csr0fa', 8, 0x900007d0),
        Register('csr0fb', 8, 0x900007d8),
        Register('csr0fc', 8, 0x900007e0),
        Register('csr0fd', 8, 0x900007e8),
        Register('csr0fe', 8, 0x900007f0),
        Register('csr0ff', 8, 0x900007f8),
        Register('sstatus', 8, 0x90000800),
        Register('csr101', 8, 0x90000808),
        Register('sedeleg', 8, 0x90000810),
        Register('sideleg', 8, 0x90000818),
        Register('sie', 8, 0x90000820),
        Register('stvec', 8, 0x90000828),
        Register('scounteren', 8, 0x90000830),
        Register('csr107', 8, 0x90000838),
        Register('csr108', 8, 0x90000840),
        Register('csr109', 8, 0x90000848),
        Register('csr10a', 8, 0x90000850),
        Register('csr10b', 8, 0x90000858),
        Register('csr10c', 8, 0x90000860),
        Register('csr10d', 8, 0x90000868),
        Register('csr10e', 8, 0x90000870),
        Register('csr10f', 8, 0x90000878),
        Register('csr110', 8, 0x90000880),
        Register('csr111', 8, 0x90000888),
        Register('csr112', 8, 0x90000890),
        Register('csr113', 8, 0x90000898),
        Register('csr114', 8, 0x900008a0),
        Register('csr115', 8, 0x900008a8),
        Register('csr116', 8, 0x900008b0),
        Register('csr117', 8, 0x900008b8),
        Register('csr118', 8, 0x900008c0),
        Register('csr119', 8, 0x900008c8),
        Register('csr11a', 8, 0x900008d0),
        Register('csr11b', 8, 0x900008d8),
        Register('csr11c', 8, 0x900008e0),
        Register('csr11d', 8, 0x900008e8),
        Register('csr11e', 8, 0x900008f0),
        Register('csr11f', 8, 0x900008f8),
        Register('csr120', 8, 0x90000900),
        Register('csr121', 8, 0x90000908),
        Register('csr122', 8, 0x90000910),
        Register('csr123', 8, 0x90000918),
        Register('csr124', 8, 0x90000920),
        Register('csr125', 8, 0x90000928),
        Register('csr126', 8, 0x90000930),
        Register('csr127', 8, 0x90000938),
        Register('csr128', 8, 0x90000940),
        Register('csr129', 8, 0x90000948),
        Register('csr12a', 8, 0x90000950),
        Register('csr12b', 8, 0x90000958),
        Register('csr12c', 8, 0x90000960),
        Register('csr12d', 8, 0x90000968),
        Register('csr12e', 8, 0x90000970),
        Register('csr12f', 8, 0x90000978),
        Register('csr130', 8, 0x90000980),
        Register('csr131', 8, 0x90000988),
        Register('csr132', 8, 0x90000990),
        Register('csr133', 8, 0x90000998),
        Register('csr134', 8, 0x900009a0),
        Register('csr135', 8, 0x900009a8),
        Register('csr136', 8, 0x900009b0),
        Register('csr137', 8, 0x900009b8),
        Register('csr138', 8, 0x900009c0),
        Register('csr139', 8, 0x900009c8),
        Register('csr13a', 8, 0x900009d0),
        Register('csr13b', 8, 0x900009d8),
        Register('csr13c', 8, 0x900009e0),
        Register('csr13d', 8, 0x900009e8),
        Register('csr13e', 8, 0x900009f0),
        Register('csr13f', 8, 0x900009f8),
        Register('sscratch', 8, 0x90000a00),
        Register('sepc', 8, 0x90000a08),
        Register('scause', 8, 0x90000a10),
        Register('stval', 8, 0x90000a18),
        Register('sip', 8, 0x90000a20),
        Register('csr145', 8, 0x90000a28),
        Register('csr146', 8, 0x90000a30),
        Register('csr147', 8, 0x90000a38),
        Register('csr148', 8, 0x90000a40),
        Register('csr149', 8, 0x90000a48),
        Register('csr14a', 8, 0x90000a50),
        Register('csr14b', 8, 0x90000a58),
        Register('csr14c', 8, 0x90000a60),
        Register('csr14d', 8, 0x90000a68),
        Register('csr14e', 8, 0x90000a70),
        Register('csr14f', 8, 0x90000a78),
        Register('csr150', 8, 0x90000a80),
        Register('csr151', 8, 0x90000a88),
        Register('csr152', 8, 0x90000a90),
        Register('csr153', 8, 0x90000a98),
        Register('csr154', 8, 0x90000aa0),
        Register('csr155', 8, 0x90000aa8),
        Register('csr156', 8, 0x90000ab0),
        Register('csr157', 8, 0x90000ab8),
        Register('csr158', 8, 0x90000ac0),
        Register('csr159', 8, 0x90000ac8),
        Register('csr15a', 8, 0x90000ad0),
        Register('csr15b', 8, 0x90000ad8),
        Register('csr15c', 8, 0x90000ae0),
        Register('csr15d', 8, 0x90000ae8),
        Register('csr15e', 8, 0x90000af0),
        Register('csr15f', 8, 0x90000af8),
        Register('csr160', 8, 0x90000b00),
        Register('csr161', 8, 0x90000b08),
        Register('csr162', 8, 0x90000b10),
        Register('csr163', 8, 0x90000b18),
        Register('csr164', 8, 0x90000b20),
        Register('csr165', 8, 0x90000b28),
        Register('csr166', 8, 0x90000b30),
        Register('csr167', 8, 0x90000b38),
        Register('csr168', 8, 0x90000b40),
        Register('csr169', 8, 0x90000b48),
        Register('csr16a', 8, 0x90000b50),
        Register('csr16b', 8, 0x90000b58),
        Register('csr16c', 8, 0x90000b60),
        Register('csr16d', 8, 0x90000b68),
        Register('csr16e', 8, 0x90000b70),
        Register('csr16f', 8, 0x90000b78),
        Register('csr170', 8, 0x90000b80),
        Register('csr171', 8, 0x90000b88),
        Register('csr172', 8, 0x90000b90),
        Register('csr173', 8, 0x90000b98),
        Register('csr174', 8, 0x90000ba0),
        Register('csr175', 8, 0x90000ba8),
        Register('csr176', 8, 0x90000bb0),
        Register('csr177', 8, 0x90000bb8),
        Register('csr178', 8, 0x90000bc0),
        Register('csr179', 8, 0x90000bc8),
        Register('csr17a', 8, 0x90000bd0),
        Register('csr17b', 8, 0x90000bd8),
        Register('csr17c', 8, 0x90000be0),
        Register('csr17d', 8, 0x90000be8),
        Register('csr17e', 8, 0x90000bf0),
        Register('csr17f', 8, 0x90000bf8),
        Register('satp', 8, 0x90000c00),
        Register('csr181', 8, 0x90000c08),
        Register('csr182', 8, 0x90000c10),
        Register('csr183', 8, 0x90000c18),
        Register('csr184', 8, 0x90000c20),
        Register('csr185', 8, 0x90000c28),
        Register('csr186', 8, 0x90000c30),
        Register('csr187', 8, 0x90000c38),
        Register('csr188', 8, 0x90000c40),
        Register('csr189', 8, 0x90000c48),
        Register('csr18a', 8, 0x90000c50),
        Register('csr18b', 8, 0x90000c58),
        Register('csr18c', 8, 0x90000c60),
        Register('csr18d', 8, 0x90000c68),
        Register('csr18e', 8, 0x90000c70),
        Register('csr18f', 8, 0x90000c78),
        Register('csr190', 8, 0x90000c80),
        Register('csr191', 8, 0x90000c88),
        Register('csr192', 8, 0x90000c90),
        Register('csr193', 8, 0x90000c98),
        Register('csr194', 8, 0x90000ca0),
        Register('csr195', 8, 0x90000ca8),
        Register('csr196', 8, 0x90000cb0),
        Register('csr197', 8, 0x90000cb8),
        Register('csr198', 8, 0x90000cc0),
        Register('csr199', 8, 0x90000cc8),
        Register('csr19a', 8, 0x90000cd0),
        Register('csr19b', 8, 0x90000cd8),
        Register('csr19c', 8, 0x90000ce0),
        Register('csr19d', 8, 0x90000ce8),
        Register('csr19e', 8, 0x90000cf0),
        Register('csr19f', 8, 0x90000cf8),
        Register('csr1a0', 8, 0x90000d00),
        Register('csr1a1', 8, 0x90000d08),
        Register('csr1a2', 8, 0x90000d10),
        Register('csr1a3', 8, 0x90000d18),
        Register('csr1a4', 8, 0x90000d20),
        Register('csr1a5', 8, 0x90000d28),
        Register('csr1a6', 8, 0x90000d30),
        Register('csr1a7', 8, 0x90000d38),
        Register('csr1a8', 8, 0x90000d40),
        Register('csr1a9', 8, 0x90000d48),
        Register('csr1aa', 8, 0x90000d50),
        Register('csr1ab', 8, 0x90000d58),
        Register('csr1ac', 8, 0x90000d60),
        Register('csr1ad', 8, 0x90000d68),
        Register('csr1ae', 8, 0x90000d70),
        Register('csr1af', 8, 0x90000d78),
        Register('csr1b0', 8, 0x90000d80),
        Register('csr1b1', 8, 0x90000d88),
        Register('csr1b2', 8, 0x90000d90),
        Register('csr1b3', 8, 0x90000d98),
        Register('csr1b4', 8, 0x90000da0),
        Register('csr1b5', 8, 0x90000da8),
        Register('csr1b6', 8, 0x90000db0),
        Register('csr1b7', 8, 0x90000db8),
        Register('csr1b8', 8, 0x90000dc0),
        Register('csr1b9', 8, 0x90000dc8),
        Register('csr1ba', 8, 0x90000dd0),
        Register('csr1bb', 8, 0x90000dd8),
        Register('csr1bc', 8, 0x90000de0),
        Register('csr1bd', 8, 0x90000de8),
        Register('csr1be', 8, 0x90000df0),
        Register('csr1bf', 8, 0x90000df8),
        Register('csr1c0', 8, 0x90000e00),
        Register('csr1c1', 8, 0x90000e08),
        Register('csr1c2', 8, 0x90000e10),
        Register('csr1c3', 8, 0x90000e18),
        Register('csr1c4', 8, 0x90000e20),
        Register('csr1c5', 8, 0x90000e28),
        Register('csr1c6', 8, 0x90000e30),
        Register('csr1c7', 8, 0x90000e38),
        Register('csr1c8', 8, 0x90000e40),
        Register('csr1c9', 8, 0x90000e48),
        Register('csr1ca', 8, 0x90000e50),
        Register('csr1cb', 8, 0x90000e58),
        Register('csr1cc', 8, 0x90000e60),
        Register('csr1cd', 8, 0x90000e68),
        Register('csr1ce', 8, 0x90000e70),
        Register('csr1cf', 8, 0x90000e78),
        Register('csr1d0', 8, 0x90000e80),
        Register('csr1d1', 8, 0x90000e88),
        Register('csr1d2', 8, 0x90000e90),
        Register('csr1d3', 8, 0x90000e98),
        Register('csr1d4', 8, 0x90000ea0),
        Register('csr1d5', 8, 0x90000ea8),
        Register('csr1d6', 8, 0x90000eb0),
        Register('csr1d7', 8, 0x90000eb8),
        Register('csr1d8', 8, 0x90000ec0),
        Register('csr1d9', 8, 0x90000ec8),
        Register('csr1da', 8, 0x90000ed0),
        Register('csr1db', 8, 0x90000ed8),
        Register('csr1dc', 8, 0x90000ee0),
        Register('csr1dd', 8, 0x90000ee8),
        Register('csr1de', 8, 0x90000ef0),
        Register('csr1df', 8, 0x90000ef8),
        Register('csr1e0', 8, 0x90000f00),
        Register('csr1e1', 8, 0x90000f08),
        Register('csr1e2', 8, 0x90000f10),
        Register('csr1e3', 8, 0x90000f18),
        Register('csr1e4', 8, 0x90000f20),
        Register('csr1e5', 8, 0x90000f28),
        Register('csr1e6', 8, 0x90000f30),
        Register('csr1e7', 8, 0x90000f38),
        Register('csr1e8', 8, 0x90000f40),
        Register('csr1e9', 8, 0x90000f48),
        Register('csr1ea', 8, 0x90000f50),
        Register('csr1eb', 8, 0x90000f58),
        Register('csr1ec', 8, 0x90000f60),
        Register('csr1ed', 8, 0x90000f68),
        Register('csr1ee', 8, 0x90000f70),
        Register('csr1ef', 8, 0x90000f78),
        Register('csr1f0', 8, 0x90000f80),
        Register('csr1f1', 8, 0x90000f88),
        Register('csr1f2', 8, 0x90000f90),
        Register('csr1f3', 8, 0x90000f98),
        Register('csr1f4', 8, 0x90000fa0),
        Register('csr1f5', 8, 0x90000fa8),
        Register('csr1f6', 8, 0x90000fb0),
        Register('csr1f7', 8, 0x90000fb8),
        Register('csr1f8', 8, 0x90000fc0),
        Register('csr1f9', 8, 0x90000fc8),
        Register('csr1fa', 8, 0x90000fd0),
        Register('csr1fb', 8, 0x90000fd8),
        Register('csr1fc', 8, 0x90000fe0),
        Register('csr1fd', 8, 0x90000fe8),
        Register('csr1fe', 8, 0x90000ff0),
        Register('csr1ff', 8, 0x90000ff8),
        Register('vsstatus', 8, 0x90001000),
        Register('csr201', 8, 0x90001008),
        Register('csr202', 8, 0x90001010),
        Register('csr203', 8, 0x90001018),
        Register('vsie', 8, 0x90001020),
        Register('vstvec', 8, 0x90001028),
        Register('csr206', 8, 0x90001030),
        Register('csr207', 8, 0x90001038),
        Register('csr208', 8, 0x90001040),
        Register('csr209', 8, 0x90001048),
        Register('csr20a', 8, 0x90001050),
        Register('csr20b', 8, 0x90001058),
        Register('csr20c', 8, 0x90001060),
        Register('csr20d', 8, 0x90001068),
        Register('csr20e', 8, 0x90001070),
        Register('csr20f', 8, 0x90001078),
        Register('csr210', 8, 0x90001080),
        Register('csr211', 8, 0x90001088),
        Register('csr212', 8, 0x90001090),
        Register('csr213', 8, 0x90001098),
        Register('csr214', 8, 0x900010a0),
        Register('csr215', 8, 0x900010a8),
        Register('csr216', 8, 0x900010b0),
        Register('csr217', 8, 0x900010b8),
        Register('csr218', 8, 0x900010c0),
        Register('csr219', 8, 0x900010c8),
        Register('csr21a', 8, 0x900010d0),
        Register('csr21b', 8, 0x900010d8),
        Register('csr21c', 8, 0x900010e0),
        Register('csr21d', 8, 0x900010e8),
        Register('csr21e', 8, 0x900010f0),
        Register('csr21f', 8, 0x900010f8),
        Register('csr220', 8, 0x90001100),
        Register('csr221', 8, 0x90001108),
        Register('csr222', 8, 0x90001110),
        Register('csr223', 8, 0x90001118),
        Register('csr224', 8, 0x90001120),
        Register('csr225', 8, 0x90001128),
        Register('csr226', 8, 0x90001130),
        Register('csr227', 8, 0x90001138),
        Register('csr228', 8, 0x90001140),
        Register('csr229', 8, 0x90001148),
        Register('csr22a', 8, 0x90001150),
        Register('csr22b', 8, 0x90001158),
        Register('csr22c', 8, 0x90001160),
        Register('csr22d', 8, 0x90001168),
        Register('csr22e', 8, 0x90001170),
        Register('csr22f', 8, 0x90001178),
        Register('csr230', 8, 0x90001180),
        Register('csr231', 8, 0x90001188),
        Register('csr232', 8, 0x90001190),
        Register('csr233', 8, 0x90001198),
        Register('csr234', 8, 0x900011a0),
        Register('csr235', 8, 0x900011a8),
        Register('csr236', 8, 0x900011b0),
        Register('csr237', 8, 0x900011b8),
        Register('csr238', 8, 0x900011c0),
        Register('csr239', 8, 0x900011c8),
        Register('csr23a', 8, 0x900011d0),
        Register('csr23b', 8, 0x900011d8),
        Register('csr23c', 8, 0x900011e0),
        Register('csr23d', 8, 0x900011e8),
        Register('csr23e', 8, 0x900011f0),
        Register('csr23f', 8, 0x900011f8),
        Register('vsscratch', 8, 0x90001200),
        Register('vsepc', 8, 0x90001208),
        Register('vscause', 8, 0x90001210),
        Register('vstval', 8, 0x90001218),
        Register('vsip', 8, 0x90001220),
        Register('csr245', 8, 0x90001228),
        Register('csr246', 8, 0x90001230),
        Register('csr247', 8, 0x90001238),
        Register('csr248', 8, 0x90001240),
        Register('csr249', 8, 0x90001248),
        Register('csr24a', 8, 0x90001250),
        Register('csr24b', 8, 0x90001258),
        Register('csr24c', 8, 0x90001260),
        Register('csr24d', 8, 0x90001268),
        Register('csr24e', 8, 0x90001270),
        Register('csr24f', 8, 0x90001278),
        Register('csr250', 8, 0x90001280),
        Register('csr251', 8, 0x90001288),
        Register('csr252', 8, 0x90001290),
        Register('csr253', 8, 0x90001298),
        Register('csr254', 8, 0x900012a0),
        Register('csr255', 8, 0x900012a8),
        Register('csr256', 8, 0x900012b0),
        Register('csr257', 8, 0x900012b8),
        Register('csr258', 8, 0x900012c0),
        Register('csr259', 8, 0x900012c8),
        Register('csr25a', 8, 0x900012d0),
        Register('csr25b', 8, 0x900012d8),
        Register('csr25c', 8, 0x900012e0),
        Register('csr25d', 8, 0x900012e8),
        Register('csr25e', 8, 0x900012f0),
        Register('csr25f', 8, 0x900012f8),
        Register('csr260', 8, 0x90001300),
        Register('csr261', 8, 0x90001308),
        Register('csr262', 8, 0x90001310),
        Register('csr263', 8, 0x90001318),
        Register('csr264', 8, 0x90001320),
        Register('csr265', 8, 0x90001328),
        Register('csr266', 8, 0x90001330),
        Register('csr267', 8, 0x90001338),
        Register('csr268', 8, 0x90001340),
        Register('csr269', 8, 0x90001348),
        Register('csr26a', 8, 0x90001350),
        Register('csr26b', 8, 0x90001358),
        Register('csr26c', 8, 0x90001360),
        Register('csr26d', 8, 0x90001368),
        Register('csr26e', 8, 0x90001370),
        Register('csr26f', 8, 0x90001378),
        Register('csr270', 8, 0x90001380),
        Register('csr271', 8, 0x90001388),
        Register('csr272', 8, 0x90001390),
        Register('csr273', 8, 0x90001398),
        Register('csr274', 8, 0x900013a0),
        Register('csr275', 8, 0x900013a8),
        Register('csr276', 8, 0x900013b0),
        Register('csr277', 8, 0x900013b8),
        Register('csr278', 8, 0x900013c0),
        Register('csr279', 8, 0x900013c8),
        Register('csr27a', 8, 0x900013d0),
        Register('csr27b', 8, 0x900013d8),
        Register('csr27c', 8, 0x900013e0),
        Register('csr27d', 8, 0x900013e8),
        Register('csr27e', 8, 0x900013f0),
        Register('csr27f', 8, 0x900013f8),
        Register('vsatp', 8, 0x90001400),
        Register('csr281', 8, 0x90001408),
        Register('csr282', 8, 0x90001410),
        Register('csr283', 8, 0x90001418),
        Register('csr284', 8, 0x90001420),
        Register('csr285', 8, 0x90001428),
        Register('csr286', 8, 0x90001430),
        Register('csr287', 8, 0x90001438),
        Register('csr288', 8, 0x90001440),
        Register('csr289', 8, 0x90001448),
        Register('csr28a', 8, 0x90001450),
        Register('csr28b', 8, 0x90001458),
        Register('csr28c', 8, 0x90001460),
        Register('csr28d', 8, 0x90001468),
        Register('csr28e', 8, 0x90001470),
        Register('csr28f', 8, 0x90001478),
        Register('csr290', 8, 0x90001480),
        Register('csr291', 8, 0x90001488),
        Register('csr292', 8, 0x90001490),
        Register('csr293', 8, 0x90001498),
        Register('csr294', 8, 0x900014a0),
        Register('csr295', 8, 0x900014a8),
        Register('csr296', 8, 0x900014b0),
        Register('csr297', 8, 0x900014b8),
        Register('csr298', 8, 0x900014c0),
        Register('csr299', 8, 0x900014c8),
        Register('csr29a', 8, 0x900014d0),
        Register('csr29b', 8, 0x900014d8),
        Register('csr29c', 8, 0x900014e0),
        Register('csr29d', 8, 0x900014e8),
        Register('csr29e', 8, 0x900014f0),
        Register('csr29f', 8, 0x900014f8),
        Register('csr2a0', 8, 0x90001500),
        Register('csr2a1', 8, 0x90001508),
        Register('csr2a2', 8, 0x90001510),
        Register('csr2a3', 8, 0x90001518),
        Register('csr2a4', 8, 0x90001520),
        Register('csr2a5', 8, 0x90001528),
        Register('csr2a6', 8, 0x90001530),
        Register('csr2a7', 8, 0x90001538),
        Register('csr2a8', 8, 0x90001540),
        Register('csr2a9', 8, 0x90001548),
        Register('csr2aa', 8, 0x90001550),
        Register('csr2ab', 8, 0x90001558),
        Register('csr2ac', 8, 0x90001560),
        Register('csr2ad', 8, 0x90001568),
        Register('csr2ae', 8, 0x90001570),
        Register('csr2af', 8, 0x90001578),
        Register('csr2b0', 8, 0x90001580),
        Register('csr2b1', 8, 0x90001588),
        Register('csr2b2', 8, 0x90001590),
        Register('csr2b3', 8, 0x90001598),
        Register('csr2b4', 8, 0x900015a0),
        Register('csr2b5', 8, 0x900015a8),
        Register('csr2b6', 8, 0x900015b0),
        Register('csr2b7', 8, 0x900015b8),
        Register('csr2b8', 8, 0x900015c0),
        Register('csr2b9', 8, 0x900015c8),
        Register('csr2ba', 8, 0x900015d0),
        Register('csr2bb', 8, 0x900015d8),
        Register('csr2bc', 8, 0x900015e0),
        Register('csr2bd', 8, 0x900015e8),
        Register('csr2be', 8, 0x900015f0),
        Register('csr2bf', 8, 0x900015f8),
        Register('csr2c0', 8, 0x90001600),
        Register('csr2c1', 8, 0x90001608),
        Register('csr2c2', 8, 0x90001610),
        Register('csr2c3', 8, 0x90001618),
        Register('csr2c4', 8, 0x90001620),
        Register('csr2c5', 8, 0x90001628),
        Register('csr2c6', 8, 0x90001630),
        Register('csr2c7', 8, 0x90001638),
        Register('csr2c8', 8, 0x90001640),
        Register('csr2c9', 8, 0x90001648),
        Register('csr2ca', 8, 0x90001650),
        Register('csr2cb', 8, 0x90001658),
        Register('csr2cc', 8, 0x90001660),
        Register('csr2cd', 8, 0x90001668),
        Register('csr2ce', 8, 0x90001670),
        Register('csr2cf', 8, 0x90001678),
        Register('csr2d0', 8, 0x90001680),
        Register('csr2d1', 8, 0x90001688),
        Register('csr2d2', 8, 0x90001690),
        Register('csr2d3', 8, 0x90001698),
        Register('csr2d4', 8, 0x900016a0),
        Register('csr2d5', 8, 0x900016a8),
        Register('csr2d6', 8, 0x900016b0),
        Register('csr2d7', 8, 0x900016b8),
        Register('csr2d8', 8, 0x900016c0),
        Register('csr2d9', 8, 0x900016c8),
        Register('csr2da', 8, 0x900016d0),
        Register('csr2db', 8, 0x900016d8),
        Register('csr2dc', 8, 0x900016e0),
        Register('csr2dd', 8, 0x900016e8),
        Register('csr2de', 8, 0x900016f0),
        Register('csr2df', 8, 0x900016f8),
        Register('csr2e0', 8, 0x90001700),
        Register('csr2e1', 8, 0x90001708),
        Register('csr2e2', 8, 0x90001710),
        Register('csr2e3', 8, 0x90001718),
        Register('csr2e4', 8, 0x90001720),
        Register('csr2e5', 8, 0x90001728),
        Register('csr2e6', 8, 0x90001730),
        Register('csr2e7', 8, 0x90001738),
        Register('csr2e8', 8, 0x90001740),
        Register('csr2e9', 8, 0x90001748),
        Register('csr2ea', 8, 0x90001750),
        Register('csr2eb', 8, 0x90001758),
        Register('csr2ec', 8, 0x90001760),
        Register('csr2ed', 8, 0x90001768),
        Register('csr2ee', 8, 0x90001770),
        Register('csr2ef', 8, 0x90001778),
        Register('csr2f0', 8, 0x90001780),
        Register('csr2f1', 8, 0x90001788),
        Register('csr2f2', 8, 0x90001790),
        Register('csr2f3', 8, 0x90001798),
        Register('csr2f4', 8, 0x900017a0),
        Register('csr2f5', 8, 0x900017a8),
        Register('csr2f6', 8, 0x900017b0),
        Register('csr2f7', 8, 0x900017b8),
        Register('csr2f8', 8, 0x900017c0),
        Register('csr2f9', 8, 0x900017c8),
        Register('csr2fa', 8, 0x900017d0),
        Register('csr2fb', 8, 0x900017d8),
        Register('csr2fc', 8, 0x900017e0),
        Register('csr2fd', 8, 0x900017e8),
        Register('csr2fe', 8, 0x900017f0),
        Register('csr2ff', 8, 0x900017f8),
        Register('mstatus', 8, 0x90001800),
        Register('misa', 8, 0x90001808),
        Register('medeleg', 8, 0x90001810),
        Register('mideleg', 8, 0x90001818),
        Register('mie', 8, 0x90001820),
        Register('mtvec', 8, 0x90001828),
        Register('mcounteren', 8, 0x90001830),
        Register('csr307', 8, 0x90001838),
        Register('csr308', 8, 0x90001840),
        Register('csr309', 8, 0x90001848),
        Register('csr30a', 8, 0x90001850),
        Register('csr30b', 8, 0x90001858),
        Register('csr30c', 8, 0x90001860),
        Register('csr30d', 8, 0x90001868),
        Register('csr30e', 8, 0x90001870),
        Register('csr30f', 8, 0x90001878),
        Register('mstatush', 8, 0x90001880),
        Register('csr311', 8, 0x90001888),
        Register('csr312', 8, 0x90001890),
        Register('csr313', 8, 0x90001898),
        Register('csr314', 8, 0x900018a0),
        Register('csr315', 8, 0x900018a8),
        Register('csr316', 8, 0x900018b0),
        Register('csr317', 8, 0x900018b8),
        Register('csr318', 8, 0x900018c0),
        Register('csr319', 8, 0x900018c8),
        Register('csr31a', 8, 0x900018d0),
        Register('csr31b', 8, 0x900018d8),
        Register('csr31c', 8, 0x900018e0),
        Register('csr31d', 8, 0x900018e8),
        Register('csr31e', 8, 0x900018f0),
        Register('csr31f', 8, 0x900018f8),
        Register('mcountinhibit', 8, 0x90001900),
        Register('csr321', 8, 0x90001908),
        Register('csr322', 8, 0x90001910),
        Register('mhpmevent3', 8, 0x90001918),
        Register('mhpmevent4', 8, 0x90001920),
        Register('mhpmevent5', 8, 0x90001928),
        Register('mhpmevent6', 8, 0x90001930),
        Register('mhpmevent7', 8, 0x90001938),
        Register('mhpmevent8', 8, 0x90001940),
        Register('mhpmevent9', 8, 0x90001948),
        Register('mhpmevent10', 8, 0x90001950),
        Register('mhpmevent11', 8, 0x90001958),
        Register('mhpmevent12', 8, 0x90001960),
        Register('mhpmevent13', 8, 0x90001968),
        Register('mhpmevent14', 8, 0x90001970),
        Register('mhpmevent15', 8, 0x90001978),
        Register('mhpmevent16', 8, 0x90001980),
        Register('mhpmevent17', 8, 0x90001988),
        Register('mhpmevent18', 8, 0x90001990),
        Register('mhpmevent19', 8, 0x90001998),
        Register('mhpmevent20', 8, 0x900019a0),
        Register('mhpmevent21', 8, 0x900019a8),
        Register('mhpmevent22', 8, 0x900019b0),
        Register('mhpmevent23', 8, 0x900019b8),
        Register('mhpmevent24', 8, 0x900019c0),
        Register('mhpmevent25', 8, 0x900019c8),
        Register('mhpmevent26', 8, 0x900019d0),
        Register('mhpmevent27', 8, 0x900019d8),
        Register('mhpmevent28', 8, 0x900019e0),
        Register('mhpmevent29', 8, 0x900019e8),
        Register('mhpmevent30', 8, 0x900019f0),
        Register('mhpmevent31', 8, 0x900019f8),
        Register('mscratch', 8, 0x90001a00),
        Register('mepc', 8, 0x90001a08),
        Register('mcause', 8, 0x90001a10),
        Register('mtval', 8, 0x90001a18),
        Register('mip', 8, 0x90001a20),
        Register('csr345', 8, 0x90001a28),
        Register('csr346', 8, 0x90001a30),
        Register('csr347', 8, 0x90001a38),
        Register('csr348', 8, 0x90001a40),
        Register('csr349', 8, 0x90001a48),
        Register('mtinst', 8, 0x90001a50),
        Register('mtval2', 8, 0x90001a58),
        Register('csr34c', 8, 0x90001a60),
        Register('csr34d', 8, 0x90001a68),
        Register('csr34e', 8, 0x90001a70),
        Register('csr34f', 8, 0x90001a78),
        Register('csr350', 8, 0x90001a80),
        Register('csr351', 8, 0x90001a88),
        Register('csr352', 8, 0x90001a90),
        Register('csr353', 8, 0x90001a98),
        Register('csr354', 8, 0x90001aa0),
        Register('csr355', 8, 0x90001aa8),
        Register('csr356', 8, 0x90001ab0),
        Register('csr357', 8, 0x90001ab8),
        Register('csr358', 8, 0x90001ac0),
        Register('csr359', 8, 0x90001ac8),
        Register('csr35a', 8, 0x90001ad0),
        Register('csr35b', 8, 0x90001ad8),
        Register('csr35c', 8, 0x90001ae0),
        Register('csr35d', 8, 0x90001ae8),
        Register('csr35e', 8, 0x90001af0),
        Register('csr35f', 8, 0x90001af8),
        Register('csr360', 8, 0x90001b00),
        Register('csr361', 8, 0x90001b08),
        Register('csr362', 8, 0x90001b10),
        Register('csr363', 8, 0x90001b18),
        Register('csr364', 8, 0x90001b20),
        Register('csr365', 8, 0x90001b28),
        Register('csr366', 8, 0x90001b30),
        Register('csr367', 8, 0x90001b38),
        Register('csr368', 8, 0x90001b40),
        Register('csr369', 8, 0x90001b48),
        Register('csr36a', 8, 0x90001b50),
        Register('csr36b', 8, 0x90001b58),
        Register('csr36c', 8, 0x90001b60),
        Register('csr36d', 8, 0x90001b68),
        Register('csr36e', 8, 0x90001b70),
        Register('csr36f', 8, 0x90001b78),
        Register('csr370', 8, 0x90001b80),
        Register('csr371', 8, 0x90001b88),
        Register('csr372', 8, 0x90001b90),
        Register('csr373', 8, 0x90001b98),
        Register('csr374', 8, 0x90001ba0),
        Register('csr375', 8, 0x90001ba8),
        Register('csr376', 8, 0x90001bb0),
        Register('csr377', 8, 0x90001bb8),
        Register('csr378', 8, 0x90001bc0),
        Register('csr379', 8, 0x90001bc8),
        Register('csr37a', 8, 0x90001bd0),
        Register('csr37b', 8, 0x90001bd8),
        Register('csr37c', 8, 0x90001be0),
        Register('csr37d', 8, 0x90001be8),
        Register('csr37e', 8, 0x90001bf0),
        Register('csr37f', 8, 0x90001bf8),
        Register('mbase', 8, 0x90001c00),
        Register('mbound', 8, 0x90001c08),
        Register('mibase', 8, 0x90001c10),
        Register('mibound', 8, 0x90001c18),
        Register('mdbase', 8, 0x90001c20),
        Register('mdbound', 8, 0x90001c28),
        Register('csr386', 8, 0x90001c30),
        Register('csr387', 8, 0x90001c38),
        Register('csr388', 8, 0x90001c40),
        Register('csr389', 8, 0x90001c48),
        Register('csr38a', 8, 0x90001c50),
        Register('csr38b', 8, 0x90001c58),
        Register('csr38c', 8, 0x90001c60),
        Register('csr38d', 8, 0x90001c68),
        Register('csr38e', 8, 0x90001c70),
        Register('csr38f', 8, 0x90001c78),
        Register('csr390', 8, 0x90001c80),
        Register('csr391', 8, 0x90001c88),
        Register('csr392', 8, 0x90001c90),
        Register('csr393', 8, 0x90001c98),
        Register('csr394', 8, 0x90001ca0),
        Register('csr395', 8, 0x90001ca8),
        Register('csr396', 8, 0x90001cb0),
        Register('csr397', 8, 0x90001cb8),
        Register('csr398', 8, 0x90001cc0),
        Register('csr399', 8, 0x90001cc8),
        Register('csr39a', 8, 0x90001cd0),
        Register('csr39b', 8, 0x90001cd8),
        Register('csr39c', 8, 0x90001ce0),
        Register('csr39d', 8, 0x90001ce8),
        Register('csr39e', 8, 0x90001cf0),
        Register('csr39f', 8, 0x90001cf8),
        Register('pmpcfg0', 8, 0x90001d00),
        Register('pmpcfg1', 8, 0x90001d08),
        Register('pmpcfg2', 8, 0x90001d10),
        Register('pmpcfg3', 8, 0x90001d18),
        Register('pmpcfg4', 8, 0x90001d20),
        Register('pmpcfg5', 8, 0x90001d28),
        Register('pmpcfg6', 8, 0x90001d30),
        Register('pmpcfg7', 8, 0x90001d38),
        Register('pmpcfg8', 8, 0x90001d40),
        Register('pmpcfg9', 8, 0x90001d48),
        Register('pmpcfg10', 8, 0x90001d50),
        Register('pmpcfg11', 8, 0x90001d58),
        Register('pmpcfg12', 8, 0x90001d60),
        Register('pmpcfg13', 8, 0x90001d68),
        Register('pmpcfg14', 8, 0x90001d70),
        Register('pmpcfg15', 8, 0x90001d78),
        Register('pmpaddr0', 8, 0x90001d80),
        Register('pmpaddr1', 8, 0x90001d88),
        Register('pmpaddr2', 8, 0x90001d90),
        Register('pmpaddr3', 8, 0x90001d98),
        Register('pmpaddr4', 8, 0x90001da0),
        Register('pmpaddr5', 8, 0x90001da8),
        Register('pmpaddr6', 8, 0x90001db0),
        Register('pmpaddr7', 8, 0x90001db8),
        Register('pmpaddr8', 8, 0x90001dc0),
        Register('pmpaddr9', 8, 0x90001dc8),
        Register('pmpaddr10', 8, 0x90001dd0),
        Register('pmpaddr11', 8, 0x90001dd8),
        Register('pmpaddr12', 8, 0x90001de0),
        Register('pmpaddr13', 8, 0x90001de8),
        Register('pmpaddr14', 8, 0x90001df0),
        Register('pmpaddr15', 8, 0x90001df8),
        Register('pmpaddr16', 8, 0x90001e00),
        Register('pmpaddr17', 8, 0x90001e08),
        Register('pmpaddr18', 8, 0x90001e10),
        Register('pmpaddr19', 8, 0x90001e18),
        Register('pmpaddr20', 8, 0x90001e20),
        Register('pmpaddr21', 8, 0x90001e28),
        Register('pmpaddr22', 8, 0x90001e30),
        Register('pmpaddr23', 8, 0x90001e38),
        Register('pmpaddr24', 8, 0x90001e40),
        Register('pmpaddr25', 8, 0x90001e48),
        Register('pmpaddr26', 8, 0x90001e50),
        Register('pmpaddr27', 8, 0x90001e58),
        Register('pmpaddr28', 8, 0x90001e60),
        Register('pmpaddr29', 8, 0x90001e68),
        Register('pmpaddr30', 8, 0x90001e70),
        Register('pmpaddr31', 8, 0x90001e78),
        Register('pmpaddr32', 8, 0x90001e80),
        Register('pmpaddr33', 8, 0x90001e88),
        Register('pmpaddr34', 8, 0x90001e90),
        Register('pmpaddr35', 8, 0x90001e98),
        Register('pmpaddr36', 8, 0x90001ea0),
        Register('pmpaddr37', 8, 0x90001ea8),
        Register('pmpaddr38', 8, 0x90001eb0),
        Register('pmpaddr39', 8, 0x90001eb8),
        Register('pmpaddr40', 8, 0x90001ec0),
        Register('pmpaddr41', 8, 0x90001ec8),
        Register('pmpaddr42', 8, 0x90001ed0),
        Register('pmpaddr43', 8, 0x90001ed8),
        Register('pmpaddr44', 8, 0x90001ee0),
        Register('pmpaddr45', 8, 0x90001ee8),
        Register('pmpaddr46', 8, 0x90001ef0),
        Register('pmpaddr47', 8, 0x90001ef8),
        Register('pmpaddr48', 8, 0x90001f00),
        Register('pmpaddr49', 8, 0x90001f08),
        Register('pmpaddr50', 8, 0x90001f10),
        Register('pmpaddr51', 8, 0x90001f18),
        Register('pmpaddr52', 8, 0x90001f20),
        Register('pmpaddr53', 8, 0x90001f28),
        Register('pmpaddr54', 8, 0x90001f30),
        Register('pmpaddr55', 8, 0x90001f38),
        Register('pmpaddr56', 8, 0x90001f40),
        Register('pmpaddr57', 8, 0x90001f48),
        Register('pmpaddr58', 8, 0x90001f50),
        Register('pmpaddr59', 8, 0x90001f58),
        Register('pmpaddr60', 8, 0x90001f60),
        Register('pmpaddr61', 8, 0x90001f68),
        Register('pmpaddr62', 8, 0x90001f70),
        Register('pmpaddr63', 8, 0x90001f78),
        Register('csr3f0', 8, 0x90001f80),
        Register('csr3f1', 8, 0x90001f88),
        Register('csr3f2', 8, 0x90001f90),
        Register('csr3f3', 8, 0x90001f98),
        Register('csr3f4', 8, 0x90001fa0),
        Register('csr3f5', 8, 0x90001fa8),
        Register('csr3f6', 8, 0x90001fb0),
        Register('csr3f7', 8, 0x90001fb8),
        Register('csr3f8', 8, 0x90001fc0),
        Register('csr3f9', 8, 0x90001fc8),
        Register('csr3fa', 8, 0x90001fd0),
        Register('csr3fb', 8, 0x90001fd8),
        Register('csr3fc', 8, 0x90001fe0),
        Register('csr3fd', 8, 0x90001fe8),
        Register('csr3fe', 8, 0x90001ff0),
        Register('csr3ff', 8, 0x90001ff8),
        Register('csr400', 8, 0x90002000),
        Register('csr401', 8, 0x90002008),
        Register('csr402', 8, 0x90002010),
        Register('csr403', 8, 0x90002018),
        Register('csr404', 8, 0x90002020),
        Register('csr405', 8, 0x90002028),
        Register('csr406', 8, 0x90002030),
        Register('csr407', 8, 0x90002038),
        Register('csr408', 8, 0x90002040),
        Register('csr409', 8, 0x90002048),
        Register('csr40a', 8, 0x90002050),
        Register('csr40b', 8, 0x90002058),
        Register('csr40c', 8, 0x90002060),
        Register('csr40d', 8, 0x90002068),
        Register('csr40e', 8, 0x90002070),
        Register('csr40f', 8, 0x90002078),
        Register('csr410', 8, 0x90002080),
        Register('csr411', 8, 0x90002088),
        Register('csr412', 8, 0x90002090),
        Register('csr413', 8, 0x90002098),
        Register('csr414', 8, 0x900020a0),
        Register('csr415', 8, 0x900020a8),
        Register('csr416', 8, 0x900020b0),
        Register('csr417', 8, 0x900020b8),
        Register('csr418', 8, 0x900020c0),
        Register('csr419', 8, 0x900020c8),
        Register('csr41a', 8, 0x900020d0),
        Register('csr41b', 8, 0x900020d8),
        Register('csr41c', 8, 0x900020e0),
        Register('csr41d', 8, 0x900020e8),
        Register('csr41e', 8, 0x900020f0),
        Register('csr41f', 8, 0x900020f8),
        Register('csr420', 8, 0x90002100),
        Register('csr421', 8, 0x90002108),
        Register('csr422', 8, 0x90002110),
        Register('csr423', 8, 0x90002118),
        Register('csr424', 8, 0x90002120),
        Register('csr425', 8, 0x90002128),
        Register('csr426', 8, 0x90002130),
        Register('csr427', 8, 0x90002138),
        Register('csr428', 8, 0x90002140),
        Register('csr429', 8, 0x90002148),
        Register('csr42a', 8, 0x90002150),
        Register('csr42b', 8, 0x90002158),
        Register('csr42c', 8, 0x90002160),
        Register('csr42d', 8, 0x90002168),
        Register('csr42e', 8, 0x90002170),
        Register('csr42f', 8, 0x90002178),
        Register('csr430', 8, 0x90002180),
        Register('csr431', 8, 0x90002188),
        Register('csr432', 8, 0x90002190),
        Register('csr433', 8, 0x90002198),
        Register('csr434', 8, 0x900021a0),
        Register('csr435', 8, 0x900021a8),
        Register('csr436', 8, 0x900021b0),
        Register('csr437', 8, 0x900021b8),
        Register('csr438', 8, 0x900021c0),
        Register('csr439', 8, 0x900021c8),
        Register('csr43a', 8, 0x900021d0),
        Register('csr43b', 8, 0x900021d8),
        Register('csr43c', 8, 0x900021e0),
        Register('csr43d', 8, 0x900021e8),
        Register('csr43e', 8, 0x900021f0),
        Register('csr43f', 8, 0x900021f8),
        Register('csr440', 8, 0x90002200),
        Register('csr441', 8, 0x90002208),
        Register('csr442', 8, 0x90002210),
        Register('csr443', 8, 0x90002218),
        Register('csr444', 8, 0x90002220),
        Register('csr445', 8, 0x90002228),
        Register('csr446', 8, 0x90002230),
        Register('csr447', 8, 0x90002238),
        Register('csr448', 8, 0x90002240),
        Register('csr449', 8, 0x90002248),
        Register('csr44a', 8, 0x90002250),
        Register('csr44b', 8, 0x90002258),
        Register('csr44c', 8, 0x90002260),
        Register('csr44d', 8, 0x90002268),
        Register('csr44e', 8, 0x90002270),
        Register('csr44f', 8, 0x90002278),
        Register('csr450', 8, 0x90002280),
        Register('csr451', 8, 0x90002288),
        Register('csr452', 8, 0x90002290),
        Register('csr453', 8, 0x90002298),
        Register('csr454', 8, 0x900022a0),
        Register('csr455', 8, 0x900022a8),
        Register('csr456', 8, 0x900022b0),
        Register('csr457', 8, 0x900022b8),
        Register('csr458', 8, 0x900022c0),
        Register('csr459', 8, 0x900022c8),
        Register('csr45a', 8, 0x900022d0),
        Register('csr45b', 8, 0x900022d8),
        Register('csr45c', 8, 0x900022e0),
        Register('csr45d', 8, 0x900022e8),
        Register('csr45e', 8, 0x900022f0),
        Register('csr45f', 8, 0x900022f8),
        Register('csr460', 8, 0x90002300),
        Register('csr461', 8, 0x90002308),
        Register('csr462', 8, 0x90002310),
        Register('csr463', 8, 0x90002318),
        Register('csr464', 8, 0x90002320),
        Register('csr465', 8, 0x90002328),
        Register('csr466', 8, 0x90002330),
        Register('csr467', 8, 0x90002338),
        Register('csr468', 8, 0x90002340),
        Register('csr469', 8, 0x90002348),
        Register('csr46a', 8, 0x90002350),
        Register('csr46b', 8, 0x90002358),
        Register('csr46c', 8, 0x90002360),
        Register('csr46d', 8, 0x90002368),
        Register('csr46e', 8, 0x90002370),
        Register('csr46f', 8, 0x90002378),
        Register('csr470', 8, 0x90002380),
        Register('csr471', 8, 0x90002388),
        Register('csr472', 8, 0x90002390),
        Register('csr473', 8, 0x90002398),
        Register('csr474', 8, 0x900023a0),
        Register('csr475', 8, 0x900023a8),
        Register('csr476', 8, 0x900023b0),
        Register('csr477', 8, 0x900023b8),
        Register('csr478', 8, 0x900023c0),
        Register('csr479', 8, 0x900023c8),
        Register('csr47a', 8, 0x900023d0),
        Register('csr47b', 8, 0x900023d8),
        Register('csr47c', 8, 0x900023e0),
        Register('csr47d', 8, 0x900023e8),
        Register('csr47e', 8, 0x900023f0),
        Register('csr47f', 8, 0x900023f8),
        Register('csr480', 8, 0x90002400),
        Register('csr481', 8, 0x90002408),
        Register('csr482', 8, 0x90002410),
        Register('csr483', 8, 0x90002418),
        Register('csr484', 8, 0x90002420),
        Register('csr485', 8, 0x90002428),
        Register('csr486', 8, 0x90002430),
        Register('csr487', 8, 0x90002438),
        Register('csr488', 8, 0x90002440),
        Register('csr489', 8, 0x90002448),
        Register('csr48a', 8, 0x90002450),
        Register('csr48b', 8, 0x90002458),
        Register('csr48c', 8, 0x90002460),
        Register('csr48d', 8, 0x90002468),
        Register('csr48e', 8, 0x90002470),
        Register('csr48f', 8, 0x90002478),
        Register('csr490', 8, 0x90002480),
        Register('csr491', 8, 0x90002488),
        Register('csr492', 8, 0x90002490),
        Register('csr493', 8, 0x90002498),
        Register('csr494', 8, 0x900024a0),
        Register('csr495', 8, 0x900024a8),
        Register('csr496', 8, 0x900024b0),
        Register('csr497', 8, 0x900024b8),
        Register('csr498', 8, 0x900024c0),
        Register('csr499', 8, 0x900024c8),
        Register('csr49a', 8, 0x900024d0),
        Register('csr49b', 8, 0x900024d8),
        Register('csr49c', 8, 0x900024e0),
        Register('csr49d', 8, 0x900024e8),
        Register('csr49e', 8, 0x900024f0),
        Register('csr49f', 8, 0x900024f8),
        Register('csr4a0', 8, 0x90002500),
        Register('csr4a1', 8, 0x90002508),
        Register('csr4a2', 8, 0x90002510),
        Register('csr4a3', 8, 0x90002518),
        Register('csr4a4', 8, 0x90002520),
        Register('csr4a5', 8, 0x90002528),
        Register('csr4a6', 8, 0x90002530),
        Register('csr4a7', 8, 0x90002538),
        Register('csr4a8', 8, 0x90002540),
        Register('csr4a9', 8, 0x90002548),
        Register('csr4aa', 8, 0x90002550),
        Register('csr4ab', 8, 0x90002558),
        Register('csr4ac', 8, 0x90002560),
        Register('csr4ad', 8, 0x90002568),
        Register('csr4ae', 8, 0x90002570),
        Register('csr4af', 8, 0x90002578),
        Register('csr4b0', 8, 0x90002580),
        Register('csr4b1', 8, 0x90002588),
        Register('csr4b2', 8, 0x90002590),
        Register('csr4b3', 8, 0x90002598),
        Register('csr4b4', 8, 0x900025a0),
        Register('csr4b5', 8, 0x900025a8),
        Register('csr4b6', 8, 0x900025b0),
        Register('csr4b7', 8, 0x900025b8),
        Register('csr4b8', 8, 0x900025c0),
        Register('csr4b9', 8, 0x900025c8),
        Register('csr4ba', 8, 0x900025d0),
        Register('csr4bb', 8, 0x900025d8),
        Register('csr4bc', 8, 0x900025e0),
        Register('csr4bd', 8, 0x900025e8),
        Register('csr4be', 8, 0x900025f0),
        Register('csr4bf', 8, 0x900025f8),
        Register('csr4c0', 8, 0x90002600),
        Register('csr4c1', 8, 0x90002608),
        Register('csr4c2', 8, 0x90002610),
        Register('csr4c3', 8, 0x90002618),
        Register('csr4c4', 8, 0x90002620),
        Register('csr4c5', 8, 0x90002628),
        Register('csr4c6', 8, 0x90002630),
        Register('csr4c7', 8, 0x90002638),
        Register('csr4c8', 8, 0x90002640),
        Register('csr4c9', 8, 0x90002648),
        Register('csr4ca', 8, 0x90002650),
        Register('csr4cb', 8, 0x90002658),
        Register('csr4cc', 8, 0x90002660),
        Register('csr4cd', 8, 0x90002668),
        Register('csr4ce', 8, 0x90002670),
        Register('csr4cf', 8, 0x90002678),
        Register('csr4d0', 8, 0x90002680),
        Register('csr4d1', 8, 0x90002688),
        Register('csr4d2', 8, 0x90002690),
        Register('csr4d3', 8, 0x90002698),
        Register('csr4d4', 8, 0x900026a0),
        Register('csr4d5', 8, 0x900026a8),
        Register('csr4d6', 8, 0x900026b0),
        Register('csr4d7', 8, 0x900026b8),
        Register('csr4d8', 8, 0x900026c0),
        Register('csr4d9', 8, 0x900026c8),
        Register('csr4da', 8, 0x900026d0),
        Register('csr4db', 8, 0x900026d8),
        Register('csr4dc', 8, 0x900026e0),
        Register('csr4dd', 8, 0x900026e8),
        Register('csr4de', 8, 0x900026f0),
        Register('csr4df', 8, 0x900026f8),
        Register('csr4e0', 8, 0x90002700),
        Register('csr4e1', 8, 0x90002708),
        Register('csr4e2', 8, 0x90002710),
        Register('csr4e3', 8, 0x90002718),
        Register('csr4e4', 8, 0x90002720),
        Register('csr4e5', 8, 0x90002728),
        Register('csr4e6', 8, 0x90002730),
        Register('csr4e7', 8, 0x90002738),
        Register('csr4e8', 8, 0x90002740),
        Register('csr4e9', 8, 0x90002748),
        Register('csr4ea', 8, 0x90002750),
        Register('csr4eb', 8, 0x90002758),
        Register('csr4ec', 8, 0x90002760),
        Register('csr4ed', 8, 0x90002768),
        Register('csr4ee', 8, 0x90002770),
        Register('csr4ef', 8, 0x90002778),
        Register('csr4f0', 8, 0x90002780),
        Register('csr4f1', 8, 0x90002788),
        Register('csr4f2', 8, 0x90002790),
        Register('csr4f3', 8, 0x90002798),
        Register('csr4f4', 8, 0x900027a0),
        Register('csr4f5', 8, 0x900027a8),
        Register('csr4f6', 8, 0x900027b0),
        Register('csr4f7', 8, 0x900027b8),
        Register('csr4f8', 8, 0x900027c0),
        Register('csr4f9', 8, 0x900027c8),
        Register('csr4fa', 8, 0x900027d0),
        Register('csr4fb', 8, 0x900027d8),
        Register('csr4fc', 8, 0x900027e0),
        Register('csr4fd', 8, 0x900027e8),
        Register('csr4fe', 8, 0x900027f0),
        Register('csr4ff', 8, 0x900027f8),
        Register('csr500', 8, 0x90002800),
        Register('csr501', 8, 0x90002808),
        Register('csr502', 8, 0x90002810),
        Register('csr503', 8, 0x90002818),
        Register('csr504', 8, 0x90002820),
        Register('csr505', 8, 0x90002828),
        Register('csr506', 8, 0x90002830),
        Register('csr507', 8, 0x90002838),
        Register('csr508', 8, 0x90002840),
        Register('csr509', 8, 0x90002848),
        Register('csr50a', 8, 0x90002850),
        Register('csr50b', 8, 0x90002858),
        Register('csr50c', 8, 0x90002860),
        Register('csr50d', 8, 0x90002868),
        Register('csr50e', 8, 0x90002870),
        Register('csr50f', 8, 0x90002878),
        Register('csr510', 8, 0x90002880),
        Register('csr511', 8, 0x90002888),
        Register('csr512', 8, 0x90002890),
        Register('csr513', 8, 0x90002898),
        Register('csr514', 8, 0x900028a0),
        Register('csr515', 8, 0x900028a8),
        Register('csr516', 8, 0x900028b0),
        Register('csr517', 8, 0x900028b8),
        Register('csr518', 8, 0x900028c0),
        Register('csr519', 8, 0x900028c8),
        Register('csr51a', 8, 0x900028d0),
        Register('csr51b', 8, 0x900028d8),
        Register('csr51c', 8, 0x900028e0),
        Register('csr51d', 8, 0x900028e8),
        Register('csr51e', 8, 0x900028f0),
        Register('csr51f', 8, 0x900028f8),
        Register('csr520', 8, 0x90002900),
        Register('csr521', 8, 0x90002908),
        Register('csr522', 8, 0x90002910),
        Register('csr523', 8, 0x90002918),
        Register('csr524', 8, 0x90002920),
        Register('csr525', 8, 0x90002928),
        Register('csr526', 8, 0x90002930),
        Register('csr527', 8, 0x90002938),
        Register('csr528', 8, 0x90002940),
        Register('csr529', 8, 0x90002948),
        Register('csr52a', 8, 0x90002950),
        Register('csr52b', 8, 0x90002958),
        Register('csr52c', 8, 0x90002960),
        Register('csr52d', 8, 0x90002968),
        Register('csr52e', 8, 0x90002970),
        Register('csr52f', 8, 0x90002978),
        Register('csr530', 8, 0x90002980),
        Register('csr531', 8, 0x90002988),
        Register('csr532', 8, 0x90002990),
        Register('csr533', 8, 0x90002998),
        Register('csr534', 8, 0x900029a0),
        Register('csr535', 8, 0x900029a8),
        Register('csr536', 8, 0x900029b0),
        Register('csr537', 8, 0x900029b8),
        Register('csr538', 8, 0x900029c0),
        Register('csr539', 8, 0x900029c8),
        Register('csr53a', 8, 0x900029d0),
        Register('csr53b', 8, 0x900029d8),
        Register('csr53c', 8, 0x900029e0),
        Register('csr53d', 8, 0x900029e8),
        Register('csr53e', 8, 0x900029f0),
        Register('csr53f', 8, 0x900029f8),
        Register('csr540', 8, 0x90002a00),
        Register('csr541', 8, 0x90002a08),
        Register('csr542', 8, 0x90002a10),
        Register('csr543', 8, 0x90002a18),
        Register('csr544', 8, 0x90002a20),
        Register('csr545', 8, 0x90002a28),
        Register('csr546', 8, 0x90002a30),
        Register('csr547', 8, 0x90002a38),
        Register('csr548', 8, 0x90002a40),
        Register('csr549', 8, 0x90002a48),
        Register('csr54a', 8, 0x90002a50),
        Register('csr54b', 8, 0x90002a58),
        Register('csr54c', 8, 0x90002a60),
        Register('csr54d', 8, 0x90002a68),
        Register('csr54e', 8, 0x90002a70),
        Register('csr54f', 8, 0x90002a78),
        Register('csr550', 8, 0x90002a80),
        Register('csr551', 8, 0x90002a88),
        Register('csr552', 8, 0x90002a90),
        Register('csr553', 8, 0x90002a98),
        Register('csr554', 8, 0x90002aa0),
        Register('csr555', 8, 0x90002aa8),
        Register('csr556', 8, 0x90002ab0),
        Register('csr557', 8, 0x90002ab8),
        Register('csr558', 8, 0x90002ac0),
        Register('csr559', 8, 0x90002ac8),
        Register('csr55a', 8, 0x90002ad0),
        Register('csr55b', 8, 0x90002ad8),
        Register('csr55c', 8, 0x90002ae0),
        Register('csr55d', 8, 0x90002ae8),
        Register('csr55e', 8, 0x90002af0),
        Register('csr55f', 8, 0x90002af8),
        Register('csr560', 8, 0x90002b00),
        Register('csr561', 8, 0x90002b08),
        Register('csr562', 8, 0x90002b10),
        Register('csr563', 8, 0x90002b18),
        Register('csr564', 8, 0x90002b20),
        Register('csr565', 8, 0x90002b28),
        Register('csr566', 8, 0x90002b30),
        Register('csr567', 8, 0x90002b38),
        Register('csr568', 8, 0x90002b40),
        Register('csr569', 8, 0x90002b48),
        Register('csr56a', 8, 0x90002b50),
        Register('csr56b', 8, 0x90002b58),
        Register('csr56c', 8, 0x90002b60),
        Register('csr56d', 8, 0x90002b68),
        Register('csr56e', 8, 0x90002b70),
        Register('csr56f', 8, 0x90002b78),
        Register('csr570', 8, 0x90002b80),
        Register('csr571', 8, 0x90002b88),
        Register('csr572', 8, 0x90002b90),
        Register('csr573', 8, 0x90002b98),
        Register('csr574', 8, 0x90002ba0),
        Register('csr575', 8, 0x90002ba8),
        Register('csr576', 8, 0x90002bb0),
        Register('csr577', 8, 0x90002bb8),
        Register('csr578', 8, 0x90002bc0),
        Register('csr579', 8, 0x90002bc8),
        Register('csr57a', 8, 0x90002bd0),
        Register('csr57b', 8, 0x90002bd8),
        Register('csr57c', 8, 0x90002be0),
        Register('csr57d', 8, 0x90002be8),
        Register('csr57e', 8, 0x90002bf0),
        Register('csr57f', 8, 0x90002bf8),
        Register('csr580', 8, 0x90002c00),
        Register('csr581', 8, 0x90002c08),
        Register('csr582', 8, 0x90002c10),
        Register('csr583', 8, 0x90002c18),
        Register('csr584', 8, 0x90002c20),
        Register('csr585', 8, 0x90002c28),
        Register('csr586', 8, 0x90002c30),
        Register('csr587', 8, 0x90002c38),
        Register('csr588', 8, 0x90002c40),
        Register('csr589', 8, 0x90002c48),
        Register('csr58a', 8, 0x90002c50),
        Register('csr58b', 8, 0x90002c58),
        Register('csr58c', 8, 0x90002c60),
        Register('csr58d', 8, 0x90002c68),
        Register('csr58e', 8, 0x90002c70),
        Register('csr58f', 8, 0x90002c78),
        Register('csr590', 8, 0x90002c80),
        Register('csr591', 8, 0x90002c88),
        Register('csr592', 8, 0x90002c90),
        Register('csr593', 8, 0x90002c98),
        Register('csr594', 8, 0x90002ca0),
        Register('csr595', 8, 0x90002ca8),
        Register('csr596', 8, 0x90002cb0),
        Register('csr597', 8, 0x90002cb8),
        Register('csr598', 8, 0x90002cc0),
        Register('csr599', 8, 0x90002cc8),
        Register('csr59a', 8, 0x90002cd0),
        Register('csr59b', 8, 0x90002cd8),
        Register('csr59c', 8, 0x90002ce0),
        Register('csr59d', 8, 0x90002ce8),
        Register('csr59e', 8, 0x90002cf0),
        Register('csr59f', 8, 0x90002cf8),
        Register('csr5a0', 8, 0x90002d00),
        Register('csr5a1', 8, 0x90002d08),
        Register('csr5a2', 8, 0x90002d10),
        Register('csr5a3', 8, 0x90002d18),
        Register('csr5a4', 8, 0x90002d20),
        Register('csr5a5', 8, 0x90002d28),
        Register('csr5a6', 8, 0x90002d30),
        Register('csr5a7', 8, 0x90002d38),
        Register('scontext', 8, 0x90002d40),
        Register('csr5a9', 8, 0x90002d48),
        Register('csr5aa', 8, 0x90002d50),
        Register('csr5ab', 8, 0x90002d58),
        Register('csr5ac', 8, 0x90002d60),
        Register('csr5ad', 8, 0x90002d68),
        Register('csr5ae', 8, 0x90002d70),
        Register('csr5af', 8, 0x90002d78),
        Register('csr5b0', 8, 0x90002d80),
        Register('csr5b1', 8, 0x90002d88),
        Register('csr5b2', 8, 0x90002d90),
        Register('csr5b3', 8, 0x90002d98),
        Register('csr5b4', 8, 0x90002da0),
        Register('csr5b5', 8, 0x90002da8),
        Register('csr5b6', 8, 0x90002db0),
        Register('csr5b7', 8, 0x90002db8),
        Register('csr5b8', 8, 0x90002dc0),
        Register('csr5b9', 8, 0x90002dc8),
        Register('csr5ba', 8, 0x90002dd0),
        Register('csr5bb', 8, 0x90002dd8),
        Register('csr5bc', 8, 0x90002de0),
        Register('csr5bd', 8, 0x90002de8),
        Register('csr5be', 8, 0x90002df0),
        Register('csr5bf', 8, 0x90002df8),
        Register('csr5c0', 8, 0x90002e00),
        Register('csr5c1', 8, 0x90002e08),
        Register('csr5c2', 8, 0x90002e10),
        Register('csr5c3', 8, 0x90002e18),
        Register('csr5c4', 8, 0x90002e20),
        Register('csr5c5', 8, 0x90002e28),
        Register('csr5c6', 8, 0x90002e30),
        Register('csr5c7', 8, 0x90002e38),
        Register('csr5c8', 8, 0x90002e40),
        Register('csr5c9', 8, 0x90002e48),
        Register('csr5ca', 8, 0x90002e50),
        Register('csr5cb', 8, 0x90002e58),
        Register('csr5cc', 8, 0x90002e60),
        Register('csr5cd', 8, 0x90002e68),
        Register('csr5ce', 8, 0x90002e70),
        Register('csr5cf', 8, 0x90002e78),
        Register('csr5d0', 8, 0x90002e80),
        Register('csr5d1', 8, 0x90002e88),
        Register('csr5d2', 8, 0x90002e90),
        Register('csr5d3', 8, 0x90002e98),
        Register('csr5d4', 8, 0x90002ea0),
        Register('csr5d5', 8, 0x90002ea8),
        Register('csr5d6', 8, 0x90002eb0),
        Register('csr5d7', 8, 0x90002eb8),
        Register('csr5d8', 8, 0x90002ec0),
        Register('csr5d9', 8, 0x90002ec8),
        Register('csr5da', 8, 0x90002ed0),
        Register('csr5db', 8, 0x90002ed8),
        Register('csr5dc', 8, 0x90002ee0),
        Register('csr5dd', 8, 0x90002ee8),
        Register('csr5de', 8, 0x90002ef0),
        Register('csr5df', 8, 0x90002ef8),
        Register('csr5e0', 8, 0x90002f00),
        Register('csr5e1', 8, 0x90002f08),
        Register('csr5e2', 8, 0x90002f10),
        Register('csr5e3', 8, 0x90002f18),
        Register('csr5e4', 8, 0x90002f20),
        Register('csr5e5', 8, 0x90002f28),
        Register('csr5e6', 8, 0x90002f30),
        Register('csr5e7', 8, 0x90002f38),
        Register('csr5e8', 8, 0x90002f40),
        Register('csr5e9', 8, 0x90002f48),
        Register('csr5ea', 8, 0x90002f50),
        Register('csr5eb', 8, 0x90002f58),
        Register('csr5ec', 8, 0x90002f60),
        Register('csr5ed', 8, 0x90002f68),
        Register('csr5ee', 8, 0x90002f70),
        Register('csr5ef', 8, 0x90002f78),
        Register('csr5f0', 8, 0x90002f80),
        Register('csr5f1', 8, 0x90002f88),
        Register('csr5f2', 8, 0x90002f90),
        Register('csr5f3', 8, 0x90002f98),
        Register('csr5f4', 8, 0x90002fa0),
        Register('csr5f5', 8, 0x90002fa8),
        Register('csr5f6', 8, 0x90002fb0),
        Register('csr5f7', 8, 0x90002fb8),
        Register('csr5f8', 8, 0x90002fc0),
        Register('csr5f9', 8, 0x90002fc8),
        Register('csr5fa', 8, 0x90002fd0),
        Register('csr5fb', 8, 0x90002fd8),
        Register('csr5fc', 8, 0x90002fe0),
        Register('csr5fd', 8, 0x90002fe8),
        Register('csr5fe', 8, 0x90002ff0),
        Register('csr5ff', 8, 0x90002ff8),
        Register('hstatus', 8, 0x90003000),
        Register('csr601', 8, 0x90003008),
        Register('hedeleg', 8, 0x90003010),
        Register('hideleg', 8, 0x90003018),
        Register('hie', 8, 0x90003020),
        Register('htimedelta', 8, 0x90003028),
        Register('hcounteren', 8, 0x90003030),
        Register('hgeie', 8, 0x90003038),
        Register('csr608', 8, 0x90003040),
        Register('csr609', 8, 0x90003048),
        Register('csr60a', 8, 0x90003050),
        Register('csr60b', 8, 0x90003058),
        Register('csr60c', 8, 0x90003060),
        Register('csr60d', 8, 0x90003068),
        Register('csr60e', 8, 0x90003070),
        Register('csr60f', 8, 0x90003078),
        Register('csr610', 8, 0x90003080),
        Register('csr611', 8, 0x90003088),
        Register('csr612', 8, 0x90003090),
        Register('csr613', 8, 0x90003098),
        Register('csr614', 8, 0x900030a0),
        Register('htimedeltah', 8, 0x900030a8),
        Register('csr616', 8, 0x900030b0),
        Register('csr617', 8, 0x900030b8),
        Register('csr618', 8, 0x900030c0),
        Register('csr619', 8, 0x900030c8),
        Register('csr61a', 8, 0x900030d0),
        Register('csr61b', 8, 0x900030d8),
        Register('csr61c', 8, 0x900030e0),
        Register('csr61d', 8, 0x900030e8),
        Register('csr61e', 8, 0x900030f0),
        Register('csr61f', 8, 0x900030f8),
        Register('csr620', 8, 0x90003100),
        Register('csr621', 8, 0x90003108),
        Register('csr622', 8, 0x90003110),
        Register('csr623', 8, 0x90003118),
        Register('csr624', 8, 0x90003120),
        Register('csr625', 8, 0x90003128),
        Register('csr626', 8, 0x90003130),
        Register('csr627', 8, 0x90003138),
        Register('csr628', 8, 0x90003140),
        Register('csr629', 8, 0x90003148),
        Register('csr62a', 8, 0x90003150),
        Register('csr62b', 8, 0x90003158),
        Register('csr62c', 8, 0x90003160),
        Register('csr62d', 8, 0x90003168),
        Register('csr62e', 8, 0x90003170),
        Register('csr62f', 8, 0x90003178),
        Register('csr630', 8, 0x90003180),
        Register('csr631', 8, 0x90003188),
        Register('csr632', 8, 0x90003190),
        Register('csr633', 8, 0x90003198),
        Register('csr634', 8, 0x900031a0),
        Register('csr635', 8, 0x900031a8),
        Register('csr636', 8, 0x900031b0),
        Register('csr637', 8, 0x900031b8),
        Register('csr638', 8, 0x900031c0),
        Register('csr639', 8, 0x900031c8),
        Register('csr63a', 8, 0x900031d0),
        Register('csr63b', 8, 0x900031d8),
        Register('csr63c', 8, 0x900031e0),
        Register('csr63d', 8, 0x900031e8),
        Register('csr63e', 8, 0x900031f0),
        Register('csr63f', 8, 0x900031f8),
        Register('csr640', 8, 0x90003200),
        Register('csr641', 8, 0x90003208),
        Register('csr642', 8, 0x90003210),
        Register('htval', 8, 0x90003218),
        Register('hip', 8, 0x90003220),
        Register('hvip', 8, 0x90003228),
        Register('csr646', 8, 0x90003230),
        Register('csr647', 8, 0x90003238),
        Register('csr648', 8, 0x90003240),
        Register('csr649', 8, 0x90003248),
        Register('htinst', 8, 0x90003250),
        Register('csr64b', 8, 0x90003258),
        Register('csr64c', 8, 0x90003260),
        Register('csr64d', 8, 0x90003268),
        Register('csr64e', 8, 0x90003270),
        Register('csr64f', 8, 0x90003278),
        Register('csr650', 8, 0x90003280),
        Register('csr651', 8, 0x90003288),
        Register('csr652', 8, 0x90003290),
        Register('csr653', 8, 0x90003298),
        Register('csr654', 8, 0x900032a0),
        Register('csr655', 8, 0x900032a8),
        Register('csr656', 8, 0x900032b0),
        Register('csr657', 8, 0x900032b8),
        Register('csr658', 8, 0x900032c0),
        Register('csr659', 8, 0x900032c8),
        Register('csr65a', 8, 0x900032d0),
        Register('csr65b', 8, 0x900032d8),
        Register('csr65c', 8, 0x900032e0),
        Register('csr65d', 8, 0x900032e8),
        Register('csr65e', 8, 0x900032f0),
        Register('csr65f', 8, 0x900032f8),
        Register('csr660', 8, 0x90003300),
        Register('csr661', 8, 0x90003308),
        Register('csr662', 8, 0x90003310),
        Register('csr663', 8, 0x90003318),
        Register('csr664', 8, 0x90003320),
        Register('csr665', 8, 0x90003328),
        Register('csr666', 8, 0x90003330),
        Register('csr667', 8, 0x90003338),
        Register('csr668', 8, 0x90003340),
        Register('csr669', 8, 0x90003348),
        Register('csr66a', 8, 0x90003350),
        Register('csr66b', 8, 0x90003358),
        Register('csr66c', 8, 0x90003360),
        Register('csr66d', 8, 0x90003368),
        Register('csr66e', 8, 0x90003370),
        Register('csr66f', 8, 0x90003378),
        Register('csr670', 8, 0x90003380),
        Register('csr671', 8, 0x90003388),
        Register('csr672', 8, 0x90003390),
        Register('csr673', 8, 0x90003398),
        Register('csr674', 8, 0x900033a0),
        Register('csr675', 8, 0x900033a8),
        Register('csr676', 8, 0x900033b0),
        Register('csr677', 8, 0x900033b8),
        Register('csr678', 8, 0x900033c0),
        Register('csr679', 8, 0x900033c8),
        Register('csr67a', 8, 0x900033d0),
        Register('csr67b', 8, 0x900033d8),
        Register('csr67c', 8, 0x900033e0),
        Register('csr67d', 8, 0x900033e8),
        Register('csr67e', 8, 0x900033f0),
        Register('csr67f', 8, 0x900033f8),
        Register('hgatp', 8, 0x90003400),
        Register('csr681', 8, 0x90003408),
        Register('csr682', 8, 0x90003410),
        Register('csr683', 8, 0x90003418),
        Register('csr684', 8, 0x90003420),
        Register('csr685', 8, 0x90003428),
        Register('csr686', 8, 0x90003430),
        Register('csr687', 8, 0x90003438),
        Register('csr688', 8, 0x90003440),
        Register('csr689', 8, 0x90003448),
        Register('csr68a', 8, 0x90003450),
        Register('csr68b', 8, 0x90003458),
        Register('csr68c', 8, 0x90003460),
        Register('csr68d', 8, 0x90003468),
        Register('csr68e', 8, 0x90003470),
        Register('csr68f', 8, 0x90003478),
        Register('csr690', 8, 0x90003480),
        Register('csr691', 8, 0x90003488),
        Register('csr692', 8, 0x90003490),
        Register('csr693', 8, 0x90003498),
        Register('csr694', 8, 0x900034a0),
        Register('csr695', 8, 0x900034a8),
        Register('csr696', 8, 0x900034b0),
        Register('csr697', 8, 0x900034b8),
        Register('csr698', 8, 0x900034c0),
        Register('csr699', 8, 0x900034c8),
        Register('csr69a', 8, 0x900034d0),
        Register('csr69b', 8, 0x900034d8),
        Register('csr69c', 8, 0x900034e0),
        Register('csr69d', 8, 0x900034e8),
        Register('csr69e', 8, 0x900034f0),
        Register('csr69f', 8, 0x900034f8),
        Register('csr6a0', 8, 0x90003500),
        Register('csr6a1', 8, 0x90003508),
        Register('csr6a2', 8, 0x90003510),
        Register('csr6a3', 8, 0x90003518),
        Register('csr6a4', 8, 0x90003520),
        Register('csr6a5', 8, 0x90003528),
        Register('csr6a6', 8, 0x90003530),
        Register('csr6a7', 8, 0x90003538),
        Register('hcontext', 8, 0x90003540),
        Register('csr6a9', 8, 0x90003548),
        Register('csr6aa', 8, 0x90003550),
        Register('csr6ab', 8, 0x90003558),
        Register('csr6ac', 8, 0x90003560),
        Register('csr6ad', 8, 0x90003568),
        Register('csr6ae', 8, 0x90003570),
        Register('csr6af', 8, 0x90003578),
        Register('csr6b0', 8, 0x90003580),
        Register('csr6b1', 8, 0x90003588),
        Register('csr6b2', 8, 0x90003590),
        Register('csr6b3', 8, 0x90003598),
        Register('csr6b4', 8, 0x900035a0),
        Register('csr6b5', 8, 0x900035a8),
        Register('csr6b6', 8, 0x900035b0),
        Register('csr6b7', 8, 0x900035b8),
        Register('csr6b8', 8, 0x900035c0),
        Register('csr6b9', 8, 0x900035c8),
        Register('csr6ba', 8, 0x900035d0),
        Register('csr6bb', 8, 0x900035d8),
        Register('csr6bc', 8, 0x900035e0),
        Register('csr6bd', 8, 0x900035e8),
        Register('csr6be', 8, 0x900035f0),
        Register('csr6bf', 8, 0x900035f8),
        Register('csr6c0', 8, 0x90003600),
        Register('csr6c1', 8, 0x90003608),
        Register('csr6c2', 8, 0x90003610),
        Register('csr6c3', 8, 0x90003618),
        Register('csr6c4', 8, 0x90003620),
        Register('csr6c5', 8, 0x90003628),
        Register('csr6c6', 8, 0x90003630),
        Register('csr6c7', 8, 0x90003638),
        Register('csr6c8', 8, 0x90003640),
        Register('csr6c9', 8, 0x90003648),
        Register('csr6ca', 8, 0x90003650),
        Register('csr6cb', 8, 0x90003658),
        Register('csr6cc', 8, 0x90003660),
        Register('csr6cd', 8, 0x90003668),
        Register('csr6ce', 8, 0x90003670),
        Register('csr6cf', 8, 0x90003678),
        Register('csr6d0', 8, 0x90003680),
        Register('csr6d1', 8, 0x90003688),
        Register('csr6d2', 8, 0x90003690),
        Register('csr6d3', 8, 0x90003698),
        Register('csr6d4', 8, 0x900036a0),
        Register('csr6d5', 8, 0x900036a8),
        Register('csr6d6', 8, 0x900036b0),
        Register('csr6d7', 8, 0x900036b8),
        Register('csr6d8', 8, 0x900036c0),
        Register('csr6d9', 8, 0x900036c8),
        Register('csr6da', 8, 0x900036d0),
        Register('csr6db', 8, 0x900036d8),
        Register('csr6dc', 8, 0x900036e0),
        Register('csr6dd', 8, 0x900036e8),
        Register('csr6de', 8, 0x900036f0),
        Register('csr6df', 8, 0x900036f8),
        Register('csr6e0', 8, 0x90003700),
        Register('csr6e1', 8, 0x90003708),
        Register('csr6e2', 8, 0x90003710),
        Register('csr6e3', 8, 0x90003718),
        Register('csr6e4', 8, 0x90003720),
        Register('csr6e5', 8, 0x90003728),
        Register('csr6e6', 8, 0x90003730),
        Register('csr6e7', 8, 0x90003738),
        Register('csr6e8', 8, 0x90003740),
        Register('csr6e9', 8, 0x90003748),
        Register('csr6ea', 8, 0x90003750),
        Register('csr6eb', 8, 0x90003758),
        Register('csr6ec', 8, 0x90003760),
        Register('csr6ed', 8, 0x90003768),
        Register('csr6ee', 8, 0x90003770),
        Register('csr6ef', 8, 0x90003778),
        Register('csr6f0', 8, 0x90003780),
        Register('csr6f1', 8, 0x90003788),
        Register('csr6f2', 8, 0x90003790),
        Register('csr6f3', 8, 0x90003798),
        Register('csr6f4', 8, 0x900037a0),
        Register('csr6f5', 8, 0x900037a8),
        Register('csr6f6', 8, 0x900037b0),
        Register('csr6f7', 8, 0x900037b8),
        Register('csr6f8', 8, 0x900037c0),
        Register('csr6f9', 8, 0x900037c8),
        Register('csr6fa', 8, 0x900037d0),
        Register('csr6fb', 8, 0x900037d8),
        Register('csr6fc', 8, 0x900037e0),
        Register('csr6fd', 8, 0x900037e8),
        Register('csr6fe', 8, 0x900037f0),
        Register('csr6ff', 8, 0x900037f8),
        Register('csr700', 8, 0x90003800),
        Register('csr701', 8, 0x90003808),
        Register('csr702', 8, 0x90003810),
        Register('csr703', 8, 0x90003818),
        Register('csr704', 8, 0x90003820),
        Register('csr705', 8, 0x90003828),
        Register('csr706', 8, 0x90003830),
        Register('csr707', 8, 0x90003838),
        Register('csr708', 8, 0x90003840),
        Register('csr709', 8, 0x90003848),
        Register('csr70a', 8, 0x90003850),
        Register('csr70b', 8, 0x90003858),
        Register('csr70c', 8, 0x90003860),
        Register('csr70d', 8, 0x90003868),
        Register('csr70e', 8, 0x90003870),
        Register('csr70f', 8, 0x90003878),
        Register('csr710', 8, 0x90003880),
        Register('csr711', 8, 0x90003888),
        Register('csr712', 8, 0x90003890),
        Register('csr713', 8, 0x90003898),
        Register('csr714', 8, 0x900038a0),
        Register('csr715', 8, 0x900038a8),
        Register('csr716', 8, 0x900038b0),
        Register('csr717', 8, 0x900038b8),
        Register('csr718', 8, 0x900038c0),
        Register('csr719', 8, 0x900038c8),
        Register('csr71a', 8, 0x900038d0),
        Register('csr71b', 8, 0x900038d8),
        Register('csr71c', 8, 0x900038e0),
        Register('csr71d', 8, 0x900038e8),
        Register('csr71e', 8, 0x900038f0),
        Register('csr71f', 8, 0x900038f8),
        Register('csr720', 8, 0x90003900),
        Register('csr721', 8, 0x90003908),
        Register('csr722', 8, 0x90003910),
        Register('csr723', 8, 0x90003918),
        Register('csr724', 8, 0x90003920),
        Register('csr725', 8, 0x90003928),
        Register('csr726', 8, 0x90003930),
        Register('csr727', 8, 0x90003938),
        Register('csr728', 8, 0x90003940),
        Register('csr729', 8, 0x90003948),
        Register('csr72a', 8, 0x90003950),
        Register('csr72b', 8, 0x90003958),
        Register('csr72c', 8, 0x90003960),
        Register('csr72d', 8, 0x90003968),
        Register('csr72e', 8, 0x90003970),
        Register('csr72f', 8, 0x90003978),
        Register('csr730', 8, 0x90003980),
        Register('csr731', 8, 0x90003988),
        Register('csr732', 8, 0x90003990),
        Register('csr733', 8, 0x90003998),
        Register('csr734', 8, 0x900039a0),
        Register('csr735', 8, 0x900039a8),
        Register('csr736', 8, 0x900039b0),
        Register('csr737', 8, 0x900039b8),
        Register('csr738', 8, 0x900039c0),
        Register('csr739', 8, 0x900039c8),
        Register('csr73a', 8, 0x900039d0),
        Register('csr73b', 8, 0x900039d8),
        Register('csr73c', 8, 0x900039e0),
        Register('csr73d', 8, 0x900039e8),
        Register('csr73e', 8, 0x900039f0),
        Register('csr73f', 8, 0x900039f8),
        Register('csr740', 8, 0x90003a00),
        Register('csr741', 8, 0x90003a08),
        Register('csr742', 8, 0x90003a10),
        Register('csr743', 8, 0x90003a18),
        Register('csr744', 8, 0x90003a20),
        Register('csr745', 8, 0x90003a28),
        Register('csr746', 8, 0x90003a30),
        Register('csr747', 8, 0x90003a38),
        Register('csr748', 8, 0x90003a40),
        Register('csr749', 8, 0x90003a48),
        Register('csr74a', 8, 0x90003a50),
        Register('csr74b', 8, 0x90003a58),
        Register('csr74c', 8, 0x90003a60),
        Register('csr74d', 8, 0x90003a68),
        Register('csr74e', 8, 0x90003a70),
        Register('csr74f', 8, 0x90003a78),
        Register('csr750', 8, 0x90003a80),
        Register('csr751', 8, 0x90003a88),
        Register('csr752', 8, 0x90003a90),
        Register('csr753', 8, 0x90003a98),
        Register('csr754', 8, 0x90003aa0),
        Register('csr755', 8, 0x90003aa8),
        Register('csr756', 8, 0x90003ab0),
        Register('csr757', 8, 0x90003ab8),
        Register('csr758', 8, 0x90003ac0),
        Register('csr759', 8, 0x90003ac8),
        Register('csr75a', 8, 0x90003ad0),
        Register('csr75b', 8, 0x90003ad8),
        Register('csr75c', 8, 0x90003ae0),
        Register('csr75d', 8, 0x90003ae8),
        Register('csr75e', 8, 0x90003af0),
        Register('csr75f', 8, 0x90003af8),
        Register('csr760', 8, 0x90003b00),
        Register('csr761', 8, 0x90003b08),
        Register('csr762', 8, 0x90003b10),
        Register('csr763', 8, 0x90003b18),
        Register('csr764', 8, 0x90003b20),
        Register('csr765', 8, 0x90003b28),
        Register('csr766', 8, 0x90003b30),
        Register('csr767', 8, 0x90003b38),
        Register('csr768', 8, 0x90003b40),
        Register('csr769', 8, 0x90003b48),
        Register('csr76a', 8, 0x90003b50),
        Register('csr76b', 8, 0x90003b58),
        Register('csr76c', 8, 0x90003b60),
        Register('csr76d', 8, 0x90003b68),
        Register('csr76e', 8, 0x90003b70),
        Register('csr76f', 8, 0x90003b78),
        Register('csr770', 8, 0x90003b80),
        Register('csr771', 8, 0x90003b88),
        Register('csr772', 8, 0x90003b90),
        Register('csr773', 8, 0x90003b98),
        Register('csr774', 8, 0x90003ba0),
        Register('csr775', 8, 0x90003ba8),
        Register('csr776', 8, 0x90003bb0),
        Register('csr777', 8, 0x90003bb8),
        Register('csr778', 8, 0x90003bc0),
        Register('csr779', 8, 0x90003bc8),
        Register('csr77a', 8, 0x90003bd0),
        Register('csr77b', 8, 0x90003bd8),
        Register('csr77c', 8, 0x90003be0),
        Register('csr77d', 8, 0x90003be8),
        Register('csr77e', 8, 0x90003bf0),
        Register('csr77f', 8, 0x90003bf8),
        Register('csr780', 8, 0x90003c00),
        Register('csr781', 8, 0x90003c08),
        Register('csr782', 8, 0x90003c10),
        Register('csr783', 8, 0x90003c18),
        Register('csr784', 8, 0x90003c20),
        Register('csr785', 8, 0x90003c28),
        Register('csr786', 8, 0x90003c30),
        Register('csr787', 8, 0x90003c38),
        Register('csr788', 8, 0x90003c40),
        Register('csr789', 8, 0x90003c48),
        Register('csr78a', 8, 0x90003c50),
        Register('csr78b', 8, 0x90003c58),
        Register('csr78c', 8, 0x90003c60),
        Register('csr78d', 8, 0x90003c68),
        Register('csr78e', 8, 0x90003c70),
        Register('csr78f', 8, 0x90003c78),
        Register('csr790', 8, 0x90003c80),
        Register('csr791', 8, 0x90003c88),
        Register('csr792', 8, 0x90003c90),
        Register('csr793', 8, 0x90003c98),
        Register('csr794', 8, 0x90003ca0),
        Register('csr795', 8, 0x90003ca8),
        Register('csr796', 8, 0x90003cb0),
        Register('csr797', 8, 0x90003cb8),
        Register('csr798', 8, 0x90003cc0),
        Register('csr799', 8, 0x90003cc8),
        Register('csr79a', 8, 0x90003cd0),
        Register('csr79b', 8, 0x90003cd8),
        Register('csr79c', 8, 0x90003ce0),
        Register('csr79d', 8, 0x90003ce8),
        Register('csr79e', 8, 0x90003cf0),
        Register('csr79f', 8, 0x90003cf8),
        Register('tselect', 8, 0x90003d00),
        Register('tdata1', 8, 0x90003d08),
        Register('tdata2', 8, 0x90003d10),
        Register('tdata3', 8, 0x90003d18),
        Register('csr7a4', 8, 0x90003d20),
        Register('csr7a5', 8, 0x90003d28),
        Register('csr7a6', 8, 0x90003d30),
        Register('csr7a7', 8, 0x90003d38),
        Register('mcontext', 8, 0x90003d40),
        Register('csr7a9', 8, 0x90003d48),
        Register('csr7aa', 8, 0x90003d50),
        Register('csr7ab', 8, 0x90003d58),
        Register('csr7ac', 8, 0x90003d60),
        Register('csr7ad', 8, 0x90003d68),
        Register('csr7ae', 8, 0x90003d70),
        Register('csr7af', 8, 0x90003d78),
        Register('dcsr', 8, 0x90003d80),
        Register('dpc', 8, 0x90003d88),
        Register('dscratch0', 8, 0x90003d90),
        Register('dscratch1', 8, 0x90003d98),
        Register('csr7b4', 8, 0x90003da0),
        Register('csr7b5', 8, 0x90003da8),
        Register('csr7b6', 8, 0x90003db0),
        Register('csr7b7', 8, 0x90003db8),
        Register('csr7b8', 8, 0x90003dc0),
        Register('csr7b9', 8, 0x90003dc8),
        Register('csr7ba', 8, 0x90003dd0),
        Register('csr7bb', 8, 0x90003dd8),
        Register('csr7bc', 8, 0x90003de0),
        Register('csr7bd', 8, 0x90003de8),
        Register('csr7be', 8, 0x90003df0),
        Register('csr7bf', 8, 0x90003df8),
        Register('csr7c0', 8, 0x90003e00),
        Register('csr7c1', 8, 0x90003e08),
        Register('csr7c2', 8, 0x90003e10),
        Register('csr7c3', 8, 0x90003e18),
        Register('csr7c4', 8, 0x90003e20),
        Register('csr7c5', 8, 0x90003e28),
        Register('csr7c6', 8, 0x90003e30),
        Register('csr7c7', 8, 0x90003e38),
        Register('csr7c8', 8, 0x90003e40),
        Register('csr7c9', 8, 0x90003e48),
        Register('csr7ca', 8, 0x90003e50),
        Register('csr7cb', 8, 0x90003e58),
        Register('csr7cc', 8, 0x90003e60),
        Register('csr7cd', 8, 0x90003e68),
        Register('csr7ce', 8, 0x90003e70),
        Register('csr7cf', 8, 0x90003e78),
        Register('csr7d0', 8, 0x90003e80),
        Register('csr7d1', 8, 0x90003e88),
        Register('csr7d2', 8, 0x90003e90),
        Register('csr7d3', 8, 0x90003e98),
        Register('csr7d4', 8, 0x90003ea0),
        Register('csr7d5', 8, 0x90003ea8),
        Register('csr7d6', 8, 0x90003eb0),
        Register('csr7d7', 8, 0x90003eb8),
        Register('csr7d8', 8, 0x90003ec0),
        Register('csr7d9', 8, 0x90003ec8),
        Register('csr7da', 8, 0x90003ed0),
        Register('csr7db', 8, 0x90003ed8),
        Register('csr7dc', 8, 0x90003ee0),
        Register('csr7dd', 8, 0x90003ee8),
        Register('csr7de', 8, 0x90003ef0),
        Register('csr7df', 8, 0x90003ef8),
        Register('csr7e0', 8, 0x90003f00),
        Register('csr7e1', 8, 0x90003f08),
        Register('csr7e2', 8, 0x90003f10),
        Register('csr7e3', 8, 0x90003f18),
        Register('csr7e4', 8, 0x90003f20),
        Register('csr7e5', 8, 0x90003f28),
        Register('csr7e6', 8, 0x90003f30),
        Register('csr7e7', 8, 0x90003f38),
        Register('csr7e8', 8, 0x90003f40),
        Register('csr7e9', 8, 0x90003f48),
        Register('csr7ea', 8, 0x90003f50),
        Register('csr7eb', 8, 0x90003f58),
        Register('csr7ec', 8, 0x90003f60),
        Register('csr7ed', 8, 0x90003f68),
        Register('csr7ee', 8, 0x90003f70),
        Register('csr7ef', 8, 0x90003f78),
        Register('csr7f0', 8, 0x90003f80),
        Register('csr7f1', 8, 0x90003f88),
        Register('csr7f2', 8, 0x90003f90),
        Register('csr7f3', 8, 0x90003f98),
        Register('csr7f4', 8, 0x90003fa0),
        Register('csr7f5', 8, 0x90003fa8),
        Register('csr7f6', 8, 0x90003fb0),
        Register('csr7f7', 8, 0x90003fb8),
        Register('csr7f8', 8, 0x90003fc0),
        Register('csr7f9', 8, 0x90003fc8),
        Register('csr7fa', 8, 0x90003fd0),
        Register('csr7fb', 8, 0x90003fd8),
        Register('csr7fc', 8, 0x90003fe0),
        Register('csr7fd', 8, 0x90003fe8),
        Register('csr7fe', 8, 0x90003ff0),
        Register('csr7ff', 8, 0x90003ff8),
        Register('csr800', 8, 0x90004000),
        Register('csr801', 8, 0x90004008),
        Register('csr802', 8, 0x90004010),
        Register('csr803', 8, 0x90004018),
        Register('csr804', 8, 0x90004020),
        Register('csr805', 8, 0x90004028),
        Register('csr806', 8, 0x90004030),
        Register('csr807', 8, 0x90004038),
        Register('csr808', 8, 0x90004040),
        Register('csr809', 8, 0x90004048),
        Register('csr80a', 8, 0x90004050),
        Register('csr80b', 8, 0x90004058),
        Register('csr80c', 8, 0x90004060),
        Register('csr80d', 8, 0x90004068),
        Register('csr80e', 8, 0x90004070),
        Register('csr80f', 8, 0x90004078),
        Register('csr810', 8, 0x90004080),
        Register('csr811', 8, 0x90004088),
        Register('csr812', 8, 0x90004090),
        Register('csr813', 8, 0x90004098),
        Register('csr814', 8, 0x900040a0),
        Register('csr815', 8, 0x900040a8),
        Register('csr816', 8, 0x900040b0),
        Register('csr817', 8, 0x900040b8),
        Register('csr818', 8, 0x900040c0),
        Register('csr819', 8, 0x900040c8),
        Register('csr81a', 8, 0x900040d0),
        Register('csr81b', 8, 0x900040d8),
        Register('csr81c', 8, 0x900040e0),
        Register('csr81d', 8, 0x900040e8),
        Register('csr81e', 8, 0x900040f0),
        Register('csr81f', 8, 0x900040f8),
        Register('csr820', 8, 0x90004100),
        Register('csr821', 8, 0x90004108),
        Register('csr822', 8, 0x90004110),
        Register('csr823', 8, 0x90004118),
        Register('csr824', 8, 0x90004120),
        Register('csr825', 8, 0x90004128),
        Register('csr826', 8, 0x90004130),
        Register('csr827', 8, 0x90004138),
        Register('csr828', 8, 0x90004140),
        Register('csr829', 8, 0x90004148),
        Register('csr82a', 8, 0x90004150),
        Register('csr82b', 8, 0x90004158),
        Register('csr82c', 8, 0x90004160),
        Register('csr82d', 8, 0x90004168),
        Register('csr82e', 8, 0x90004170),
        Register('csr82f', 8, 0x90004178),
        Register('csr830', 8, 0x90004180),
        Register('csr831', 8, 0x90004188),
        Register('csr832', 8, 0x90004190),
        Register('csr833', 8, 0x90004198),
        Register('csr834', 8, 0x900041a0),
        Register('csr835', 8, 0x900041a8),
        Register('csr836', 8, 0x900041b0),
        Register('csr837', 8, 0x900041b8),
        Register('csr838', 8, 0x900041c0),
        Register('csr839', 8, 0x900041c8),
        Register('csr83a', 8, 0x900041d0),
        Register('csr83b', 8, 0x900041d8),
        Register('csr83c', 8, 0x900041e0),
        Register('csr83d', 8, 0x900041e8),
        Register('csr83e', 8, 0x900041f0),
        Register('csr83f', 8, 0x900041f8),
        Register('csr840', 8, 0x90004200),
        Register('csr841', 8, 0x90004208),
        Register('csr842', 8, 0x90004210),
        Register('csr843', 8, 0x90004218),
        Register('csr844', 8, 0x90004220),
        Register('csr845', 8, 0x90004228),
        Register('csr846', 8, 0x90004230),
        Register('csr847', 8, 0x90004238),
        Register('csr848', 8, 0x90004240),
        Register('csr849', 8, 0x90004248),
        Register('csr84a', 8, 0x90004250),
        Register('csr84b', 8, 0x90004258),
        Register('csr84c', 8, 0x90004260),
        Register('csr84d', 8, 0x90004268),
        Register('csr84e', 8, 0x90004270),
        Register('csr84f', 8, 0x90004278),
        Register('csr850', 8, 0x90004280),
        Register('csr851', 8, 0x90004288),
        Register('csr852', 8, 0x90004290),
        Register('csr853', 8, 0x90004298),
        Register('csr854', 8, 0x900042a0),
        Register('csr855', 8, 0x900042a8),
        Register('csr856', 8, 0x900042b0),
        Register('csr857', 8, 0x900042b8),
        Register('csr858', 8, 0x900042c0),
        Register('csr859', 8, 0x900042c8),
        Register('csr85a', 8, 0x900042d0),
        Register('csr85b', 8, 0x900042d8),
        Register('csr85c', 8, 0x900042e0),
        Register('csr85d', 8, 0x900042e8),
        Register('csr85e', 8, 0x900042f0),
        Register('csr85f', 8, 0x900042f8),
        Register('csr860', 8, 0x90004300),
        Register('csr861', 8, 0x90004308),
        Register('csr862', 8, 0x90004310),
        Register('csr863', 8, 0x90004318),
        Register('csr864', 8, 0x90004320),
        Register('csr865', 8, 0x90004328),
        Register('csr866', 8, 0x90004330),
        Register('csr867', 8, 0x90004338),
        Register('csr868', 8, 0x90004340),
        Register('csr869', 8, 0x90004348),
        Register('csr86a', 8, 0x90004350),
        Register('csr86b', 8, 0x90004358),
        Register('csr86c', 8, 0x90004360),
        Register('csr86d', 8, 0x90004368),
        Register('csr86e', 8, 0x90004370),
        Register('csr86f', 8, 0x90004378),
        Register('csr870', 8, 0x90004380),
        Register('csr871', 8, 0x90004388),
        Register('csr872', 8, 0x90004390),
        Register('csr873', 8, 0x90004398),
        Register('csr874', 8, 0x900043a0),
        Register('csr875', 8, 0x900043a8),
        Register('csr876', 8, 0x900043b0),
        Register('csr877', 8, 0x900043b8),
        Register('csr878', 8, 0x900043c0),
        Register('csr879', 8, 0x900043c8),
        Register('csr87a', 8, 0x900043d0),
        Register('csr87b', 8, 0x900043d8),
        Register('csr87c', 8, 0x900043e0),
        Register('csr87d', 8, 0x900043e8),
        Register('csr87e', 8, 0x900043f0),
        Register('csr87f', 8, 0x900043f8),
        Register('csr880', 8, 0x90004400),
        Register('csr881', 8, 0x90004408),
        Register('csr882', 8, 0x90004410),
        Register('csr883', 8, 0x90004418),
        Register('csr884', 8, 0x90004420),
        Register('csr885', 8, 0x90004428),
        Register('csr886', 8, 0x90004430),
        Register('csr887', 8, 0x90004438),
        Register('csr888', 8, 0x90004440),
        Register('csr889', 8, 0x90004448),
        Register('csr88a', 8, 0x90004450),
        Register('csr88b', 8, 0x90004458),
        Register('csr88c', 8, 0x90004460),
        Register('csr88d', 8, 0x90004468),
        Register('csr88e', 8, 0x90004470),
        Register('csr88f', 8, 0x90004478),
        Register('csr890', 8, 0x90004480),
        Register('csr891', 8, 0x90004488),
        Register('csr892', 8, 0x90004490),
        Register('csr893', 8, 0x90004498),
        Register('csr894', 8, 0x900044a0),
        Register('csr895', 8, 0x900044a8),
        Register('csr896', 8, 0x900044b0),
        Register('csr897', 8, 0x900044b8),
        Register('csr898', 8, 0x900044c0),
        Register('csr899', 8, 0x900044c8),
        Register('csr89a', 8, 0x900044d0),
        Register('csr89b', 8, 0x900044d8),
        Register('csr89c', 8, 0x900044e0),
        Register('csr89d', 8, 0x900044e8),
        Register('csr89e', 8, 0x900044f0),
        Register('csr89f', 8, 0x900044f8),
        Register('csr8a0', 8, 0x90004500),
        Register('csr8a1', 8, 0x90004508),
        Register('csr8a2', 8, 0x90004510),
        Register('csr8a3', 8, 0x90004518),
        Register('csr8a4', 8, 0x90004520),
        Register('csr8a5', 8, 0x90004528),
        Register('csr8a6', 8, 0x90004530),
        Register('csr8a7', 8, 0x90004538),
        Register('csr8a8', 8, 0x90004540),
        Register('csr8a9', 8, 0x90004548),
        Register('csr8aa', 8, 0x90004550),
        Register('csr8ab', 8, 0x90004558),
        Register('csr8ac', 8, 0x90004560),
        Register('csr8ad', 8, 0x90004568),
        Register('csr8ae', 8, 0x90004570),
        Register('csr8af', 8, 0x90004578),
        Register('csr8b0', 8, 0x90004580),
        Register('csr8b1', 8, 0x90004588),
        Register('csr8b2', 8, 0x90004590),
        Register('csr8b3', 8, 0x90004598),
        Register('csr8b4', 8, 0x900045a0),
        Register('csr8b5', 8, 0x900045a8),
        Register('csr8b6', 8, 0x900045b0),
        Register('csr8b7', 8, 0x900045b8),
        Register('csr8b8', 8, 0x900045c0),
        Register('csr8b9', 8, 0x900045c8),
        Register('csr8ba', 8, 0x900045d0),
        Register('csr8bb', 8, 0x900045d8),
        Register('csr8bc', 8, 0x900045e0),
        Register('csr8bd', 8, 0x900045e8),
        Register('csr8be', 8, 0x900045f0),
        Register('csr8bf', 8, 0x900045f8),
        Register('csr8c0', 8, 0x90004600),
        Register('csr8c1', 8, 0x90004608),
        Register('csr8c2', 8, 0x90004610),
        Register('csr8c3', 8, 0x90004618),
        Register('csr8c4', 8, 0x90004620),
        Register('csr8c5', 8, 0x90004628),
        Register('csr8c6', 8, 0x90004630),
        Register('csr8c7', 8, 0x90004638),
        Register('csr8c8', 8, 0x90004640),
        Register('csr8c9', 8, 0x90004648),
        Register('csr8ca', 8, 0x90004650),
        Register('csr8cb', 8, 0x90004658),
        Register('csr8cc', 8, 0x90004660),
        Register('csr8cd', 8, 0x90004668),
        Register('csr8ce', 8, 0x90004670),
        Register('csr8cf', 8, 0x90004678),
        Register('csr8d0', 8, 0x90004680),
        Register('csr8d1', 8, 0x90004688),
        Register('csr8d2', 8, 0x90004690),
        Register('csr8d3', 8, 0x90004698),
        Register('csr8d4', 8, 0x900046a0),
        Register('csr8d5', 8, 0x900046a8),
        Register('csr8d6', 8, 0x900046b0),
        Register('csr8d7', 8, 0x900046b8),
        Register('csr8d8', 8, 0x900046c0),
        Register('csr8d9', 8, 0x900046c8),
        Register('csr8da', 8, 0x900046d0),
        Register('csr8db', 8, 0x900046d8),
        Register('csr8dc', 8, 0x900046e0),
        Register('csr8dd', 8, 0x900046e8),
        Register('csr8de', 8, 0x900046f0),
        Register('csr8df', 8, 0x900046f8),
        Register('csr8e0', 8, 0x90004700),
        Register('csr8e1', 8, 0x90004708),
        Register('csr8e2', 8, 0x90004710),
        Register('csr8e3', 8, 0x90004718),
        Register('csr8e4', 8, 0x90004720),
        Register('csr8e5', 8, 0x90004728),
        Register('csr8e6', 8, 0x90004730),
        Register('csr8e7', 8, 0x90004738),
        Register('csr8e8', 8, 0x90004740),
        Register('csr8e9', 8, 0x90004748),
        Register('csr8ea', 8, 0x90004750),
        Register('csr8eb', 8, 0x90004758),
        Register('csr8ec', 8, 0x90004760),
        Register('csr8ed', 8, 0x90004768),
        Register('csr8ee', 8, 0x90004770),
        Register('csr8ef', 8, 0x90004778),
        Register('csr8f0', 8, 0x90004780),
        Register('csr8f1', 8, 0x90004788),
        Register('csr8f2', 8, 0x90004790),
        Register('csr8f3', 8, 0x90004798),
        Register('csr8f4', 8, 0x900047a0),
        Register('csr8f5', 8, 0x900047a8),
        Register('csr8f6', 8, 0x900047b0),
        Register('csr8f7', 8, 0x900047b8),
        Register('csr8f8', 8, 0x900047c0),
        Register('csr8f9', 8, 0x900047c8),
        Register('csr8fa', 8, 0x900047d0),
        Register('csr8fb', 8, 0x900047d8),
        Register('csr8fc', 8, 0x900047e0),
        Register('csr8fd', 8, 0x900047e8),
        Register('csr8fe', 8, 0x900047f0),
        Register('csr8ff', 8, 0x900047f8),
        Register('csr900', 8, 0x90004800),
        Register('csr901', 8, 0x90004808),
        Register('csr902', 8, 0x90004810),
        Register('csr903', 8, 0x90004818),
        Register('csr904', 8, 0x90004820),
        Register('csr905', 8, 0x90004828),
        Register('csr906', 8, 0x90004830),
        Register('csr907', 8, 0x90004838),
        Register('csr908', 8, 0x90004840),
        Register('csr909', 8, 0x90004848),
        Register('csr90a', 8, 0x90004850),
        Register('csr90b', 8, 0x90004858),
        Register('csr90c', 8, 0x90004860),
        Register('csr90d', 8, 0x90004868),
        Register('csr90e', 8, 0x90004870),
        Register('csr90f', 8, 0x90004878),
        Register('csr910', 8, 0x90004880),
        Register('csr911', 8, 0x90004888),
        Register('csr912', 8, 0x90004890),
        Register('csr913', 8, 0x90004898),
        Register('csr914', 8, 0x900048a0),
        Register('csr915', 8, 0x900048a8),
        Register('csr916', 8, 0x900048b0),
        Register('csr917', 8, 0x900048b8),
        Register('csr918', 8, 0x900048c0),
        Register('csr919', 8, 0x900048c8),
        Register('csr91a', 8, 0x900048d0),
        Register('csr91b', 8, 0x900048d8),
        Register('csr91c', 8, 0x900048e0),
        Register('csr91d', 8, 0x900048e8),
        Register('csr91e', 8, 0x900048f0),
        Register('csr91f', 8, 0x900048f8),
        Register('csr920', 8, 0x90004900),
        Register('csr921', 8, 0x90004908),
        Register('csr922', 8, 0x90004910),
        Register('csr923', 8, 0x90004918),
        Register('csr924', 8, 0x90004920),
        Register('csr925', 8, 0x90004928),
        Register('csr926', 8, 0x90004930),
        Register('csr927', 8, 0x90004938),
        Register('csr928', 8, 0x90004940),
        Register('csr929', 8, 0x90004948),
        Register('csr92a', 8, 0x90004950),
        Register('csr92b', 8, 0x90004958),
        Register('csr92c', 8, 0x90004960),
        Register('csr92d', 8, 0x90004968),
        Register('csr92e', 8, 0x90004970),
        Register('csr92f', 8, 0x90004978),
        Register('csr930', 8, 0x90004980),
        Register('csr931', 8, 0x90004988),
        Register('csr932', 8, 0x90004990),
        Register('csr933', 8, 0x90004998),
        Register('csr934', 8, 0x900049a0),
        Register('csr935', 8, 0x900049a8),
        Register('csr936', 8, 0x900049b0),
        Register('csr937', 8, 0x900049b8),
        Register('csr938', 8, 0x900049c0),
        Register('csr939', 8, 0x900049c8),
        Register('csr93a', 8, 0x900049d0),
        Register('csr93b', 8, 0x900049d8),
        Register('csr93c', 8, 0x900049e0),
        Register('csr93d', 8, 0x900049e8),
        Register('csr93e', 8, 0x900049f0),
        Register('csr93f', 8, 0x900049f8),
        Register('csr940', 8, 0x90004a00),
        Register('csr941', 8, 0x90004a08),
        Register('csr942', 8, 0x90004a10),
        Register('csr943', 8, 0x90004a18),
        Register('csr944', 8, 0x90004a20),
        Register('csr945', 8, 0x90004a28),
        Register('csr946', 8, 0x90004a30),
        Register('csr947', 8, 0x90004a38),
        Register('csr948', 8, 0x90004a40),
        Register('csr949', 8, 0x90004a48),
        Register('csr94a', 8, 0x90004a50),
        Register('csr94b', 8, 0x90004a58),
        Register('csr94c', 8, 0x90004a60),
        Register('csr94d', 8, 0x90004a68),
        Register('csr94e', 8, 0x90004a70),
        Register('csr94f', 8, 0x90004a78),
        Register('csr950', 8, 0x90004a80),
        Register('csr951', 8, 0x90004a88),
        Register('csr952', 8, 0x90004a90),
        Register('csr953', 8, 0x90004a98),
        Register('csr954', 8, 0x90004aa0),
        Register('csr955', 8, 0x90004aa8),
        Register('csr956', 8, 0x90004ab0),
        Register('csr957', 8, 0x90004ab8),
        Register('csr958', 8, 0x90004ac0),
        Register('csr959', 8, 0x90004ac8),
        Register('csr95a', 8, 0x90004ad0),
        Register('csr95b', 8, 0x90004ad8),
        Register('csr95c', 8, 0x90004ae0),
        Register('csr95d', 8, 0x90004ae8),
        Register('csr95e', 8, 0x90004af0),
        Register('csr95f', 8, 0x90004af8),
        Register('csr960', 8, 0x90004b00),
        Register('csr961', 8, 0x90004b08),
        Register('csr962', 8, 0x90004b10),
        Register('csr963', 8, 0x90004b18),
        Register('csr964', 8, 0x90004b20),
        Register('csr965', 8, 0x90004b28),
        Register('csr966', 8, 0x90004b30),
        Register('csr967', 8, 0x90004b38),
        Register('csr968', 8, 0x90004b40),
        Register('csr969', 8, 0x90004b48),
        Register('csr96a', 8, 0x90004b50),
        Register('csr96b', 8, 0x90004b58),
        Register('csr96c', 8, 0x90004b60),
        Register('csr96d', 8, 0x90004b68),
        Register('csr96e', 8, 0x90004b70),
        Register('csr96f', 8, 0x90004b78),
        Register('csr970', 8, 0x90004b80),
        Register('csr971', 8, 0x90004b88),
        Register('csr972', 8, 0x90004b90),
        Register('csr973', 8, 0x90004b98),
        Register('csr974', 8, 0x90004ba0),
        Register('csr975', 8, 0x90004ba8),
        Register('csr976', 8, 0x90004bb0),
        Register('csr977', 8, 0x90004bb8),
        Register('csr978', 8, 0x90004bc0),
        Register('csr979', 8, 0x90004bc8),
        Register('csr97a', 8, 0x90004bd0),
        Register('csr97b', 8, 0x90004bd8),
        Register('csr97c', 8, 0x90004be0),
        Register('csr97d', 8, 0x90004be8),
        Register('csr97e', 8, 0x90004bf0),
        Register('csr97f', 8, 0x90004bf8),
        Register('csr980', 8, 0x90004c00),
        Register('csr981', 8, 0x90004c08),
        Register('csr982', 8, 0x90004c10),
        Register('csr983', 8, 0x90004c18),
        Register('csr984', 8, 0x90004c20),
        Register('csr985', 8, 0x90004c28),
        Register('csr986', 8, 0x90004c30),
        Register('csr987', 8, 0x90004c38),
        Register('csr988', 8, 0x90004c40),
        Register('csr989', 8, 0x90004c48),
        Register('csr98a', 8, 0x90004c50),
        Register('csr98b', 8, 0x90004c58),
        Register('csr98c', 8, 0x90004c60),
        Register('csr98d', 8, 0x90004c68),
        Register('csr98e', 8, 0x90004c70),
        Register('csr98f', 8, 0x90004c78),
        Register('csr990', 8, 0x90004c80),
        Register('csr991', 8, 0x90004c88),
        Register('csr992', 8, 0x90004c90),
        Register('csr993', 8, 0x90004c98),
        Register('csr994', 8, 0x90004ca0),
        Register('csr995', 8, 0x90004ca8),
        Register('csr996', 8, 0x90004cb0),
        Register('csr997', 8, 0x90004cb8),
        Register('csr998', 8, 0x90004cc0),
        Register('csr999', 8, 0x90004cc8),
        Register('csr99a', 8, 0x90004cd0),
        Register('csr99b', 8, 0x90004cd8),
        Register('csr99c', 8, 0x90004ce0),
        Register('csr99d', 8, 0x90004ce8),
        Register('csr99e', 8, 0x90004cf0),
        Register('csr99f', 8, 0x90004cf8),
        Register('csr9a0', 8, 0x90004d00),
        Register('csr9a1', 8, 0x90004d08),
        Register('csr9a2', 8, 0x90004d10),
        Register('csr9a3', 8, 0x90004d18),
        Register('csr9a4', 8, 0x90004d20),
        Register('csr9a5', 8, 0x90004d28),
        Register('csr9a6', 8, 0x90004d30),
        Register('csr9a7', 8, 0x90004d38),
        Register('csr9a8', 8, 0x90004d40),
        Register('csr9a9', 8, 0x90004d48),
        Register('csr9aa', 8, 0x90004d50),
        Register('csr9ab', 8, 0x90004d58),
        Register('csr9ac', 8, 0x90004d60),
        Register('csr9ad', 8, 0x90004d68),
        Register('csr9ae', 8, 0x90004d70),
        Register('csr9af', 8, 0x90004d78),
        Register('csr9b0', 8, 0x90004d80),
        Register('csr9b1', 8, 0x90004d88),
        Register('csr9b2', 8, 0x90004d90),
        Register('csr9b3', 8, 0x90004d98),
        Register('csr9b4', 8, 0x90004da0),
        Register('csr9b5', 8, 0x90004da8),
        Register('csr9b6', 8, 0x90004db0),
        Register('csr9b7', 8, 0x90004db8),
        Register('csr9b8', 8, 0x90004dc0),
        Register('csr9b9', 8, 0x90004dc8),
        Register('csr9ba', 8, 0x90004dd0),
        Register('csr9bb', 8, 0x90004dd8),
        Register('csr9bc', 8, 0x90004de0),
        Register('csr9bd', 8, 0x90004de8),
        Register('csr9be', 8, 0x90004df0),
        Register('csr9bf', 8, 0x90004df8),
        Register('csr9c0', 8, 0x90004e00),
        Register('csr9c1', 8, 0x90004e08),
        Register('csr9c2', 8, 0x90004e10),
        Register('csr9c3', 8, 0x90004e18),
        Register('csr9c4', 8, 0x90004e20),
        Register('csr9c5', 8, 0x90004e28),
        Register('csr9c6', 8, 0x90004e30),
        Register('csr9c7', 8, 0x90004e38),
        Register('csr9c8', 8, 0x90004e40),
        Register('csr9c9', 8, 0x90004e48),
        Register('csr9ca', 8, 0x90004e50),
        Register('csr9cb', 8, 0x90004e58),
        Register('csr9cc', 8, 0x90004e60),
        Register('csr9cd', 8, 0x90004e68),
        Register('csr9ce', 8, 0x90004e70),
        Register('csr9cf', 8, 0x90004e78),
        Register('csr9d0', 8, 0x90004e80),
        Register('csr9d1', 8, 0x90004e88),
        Register('csr9d2', 8, 0x90004e90),
        Register('csr9d3', 8, 0x90004e98),
        Register('csr9d4', 8, 0x90004ea0),
        Register('csr9d5', 8, 0x90004ea8),
        Register('csr9d6', 8, 0x90004eb0),
        Register('csr9d7', 8, 0x90004eb8),
        Register('csr9d8', 8, 0x90004ec0),
        Register('csr9d9', 8, 0x90004ec8),
        Register('csr9da', 8, 0x90004ed0),
        Register('csr9db', 8, 0x90004ed8),
        Register('csr9dc', 8, 0x90004ee0),
        Register('csr9dd', 8, 0x90004ee8),
        Register('csr9de', 8, 0x90004ef0),
        Register('csr9df', 8, 0x90004ef8),
        Register('csr9e0', 8, 0x90004f00),
        Register('csr9e1', 8, 0x90004f08),
        Register('csr9e2', 8, 0x90004f10),
        Register('csr9e3', 8, 0x90004f18),
        Register('csr9e4', 8, 0x90004f20),
        Register('csr9e5', 8, 0x90004f28),
        Register('csr9e6', 8, 0x90004f30),
        Register('csr9e7', 8, 0x90004f38),
        Register('csr9e8', 8, 0x90004f40),
        Register('csr9e9', 8, 0x90004f48),
        Register('csr9ea', 8, 0x90004f50),
        Register('csr9eb', 8, 0x90004f58),
        Register('csr9ec', 8, 0x90004f60),
        Register('csr9ed', 8, 0x90004f68),
        Register('csr9ee', 8, 0x90004f70),
        Register('csr9ef', 8, 0x90004f78),
        Register('csr9f0', 8, 0x90004f80),
        Register('csr9f1', 8, 0x90004f88),
        Register('csr9f2', 8, 0x90004f90),
        Register('csr9f3', 8, 0x90004f98),
        Register('csr9f4', 8, 0x90004fa0),
        Register('csr9f5', 8, 0x90004fa8),
        Register('csr9f6', 8, 0x90004fb0),
        Register('csr9f7', 8, 0x90004fb8),
        Register('csr9f8', 8, 0x90004fc0),
        Register('csr9f9', 8, 0x90004fc8),
        Register('csr9fa', 8, 0x90004fd0),
        Register('csr9fb', 8, 0x90004fd8),
        Register('csr9fc', 8, 0x90004fe0),
        Register('csr9fd', 8, 0x90004fe8),
        Register('csr9fe', 8, 0x90004ff0),
        Register('csr9ff', 8, 0x90004ff8),
        Register('csra00', 8, 0x90005000),
        Register('csra01', 8, 0x90005008),
        Register('csra02', 8, 0x90005010),
        Register('csra03', 8, 0x90005018),
        Register('csra04', 8, 0x90005020),
        Register('csra05', 8, 0x90005028),
        Register('csra06', 8, 0x90005030),
        Register('csra07', 8, 0x90005038),
        Register('csra08', 8, 0x90005040),
        Register('csra09', 8, 0x90005048),
        Register('csra0a', 8, 0x90005050),
        Register('csra0b', 8, 0x90005058),
        Register('csra0c', 8, 0x90005060),
        Register('csra0d', 8, 0x90005068),
        Register('csra0e', 8, 0x90005070),
        Register('csra0f', 8, 0x90005078),
        Register('csra10', 8, 0x90005080),
        Register('csra11', 8, 0x90005088),
        Register('csra12', 8, 0x90005090),
        Register('csra13', 8, 0x90005098),
        Register('csra14', 8, 0x900050a0),
        Register('csra15', 8, 0x900050a8),
        Register('csra16', 8, 0x900050b0),
        Register('csra17', 8, 0x900050b8),
        Register('csra18', 8, 0x900050c0),
        Register('csra19', 8, 0x900050c8),
        Register('csra1a', 8, 0x900050d0),
        Register('csra1b', 8, 0x900050d8),
        Register('csra1c', 8, 0x900050e0),
        Register('csra1d', 8, 0x900050e8),
        Register('csra1e', 8, 0x900050f0),
        Register('csra1f', 8, 0x900050f8),
        Register('csra20', 8, 0x90005100),
        Register('csra21', 8, 0x90005108),
        Register('csra22', 8, 0x90005110),
        Register('csra23', 8, 0x90005118),
        Register('csra24', 8, 0x90005120),
        Register('csra25', 8, 0x90005128),
        Register('csra26', 8, 0x90005130),
        Register('csra27', 8, 0x90005138),
        Register('csra28', 8, 0x90005140),
        Register('csra29', 8, 0x90005148),
        Register('csra2a', 8, 0x90005150),
        Register('csra2b', 8, 0x90005158),
        Register('csra2c', 8, 0x90005160),
        Register('csra2d', 8, 0x90005168),
        Register('csra2e', 8, 0x90005170),
        Register('csra2f', 8, 0x90005178),
        Register('csra30', 8, 0x90005180),
        Register('csra31', 8, 0x90005188),
        Register('csra32', 8, 0x90005190),
        Register('csra33', 8, 0x90005198),
        Register('csra34', 8, 0x900051a0),
        Register('csra35', 8, 0x900051a8),
        Register('csra36', 8, 0x900051b0),
        Register('csra37', 8, 0x900051b8),
        Register('csra38', 8, 0x900051c0),
        Register('csra39', 8, 0x900051c8),
        Register('csra3a', 8, 0x900051d0),
        Register('csra3b', 8, 0x900051d8),
        Register('csra3c', 8, 0x900051e0),
        Register('csra3d', 8, 0x900051e8),
        Register('csra3e', 8, 0x900051f0),
        Register('csra3f', 8, 0x900051f8),
        Register('csra40', 8, 0x90005200),
        Register('csra41', 8, 0x90005208),
        Register('csra42', 8, 0x90005210),
        Register('csra43', 8, 0x90005218),
        Register('csra44', 8, 0x90005220),
        Register('csra45', 8, 0x90005228),
        Register('csra46', 8, 0x90005230),
        Register('csra47', 8, 0x90005238),
        Register('csra48', 8, 0x90005240),
        Register('csra49', 8, 0x90005248),
        Register('csra4a', 8, 0x90005250),
        Register('csra4b', 8, 0x90005258),
        Register('csra4c', 8, 0x90005260),
        Register('csra4d', 8, 0x90005268),
        Register('csra4e', 8, 0x90005270),
        Register('csra4f', 8, 0x90005278),
        Register('csra50', 8, 0x90005280),
        Register('csra51', 8, 0x90005288),
        Register('csra52', 8, 0x90005290),
        Register('csra53', 8, 0x90005298),
        Register('csra54', 8, 0x900052a0),
        Register('csra55', 8, 0x900052a8),
        Register('csra56', 8, 0x900052b0),
        Register('csra57', 8, 0x900052b8),
        Register('csra58', 8, 0x900052c0),
        Register('csra59', 8, 0x900052c8),
        Register('csra5a', 8, 0x900052d0),
        Register('csra5b', 8, 0x900052d8),
        Register('csra5c', 8, 0x900052e0),
        Register('csra5d', 8, 0x900052e8),
        Register('csra5e', 8, 0x900052f0),
        Register('csra5f', 8, 0x900052f8),
        Register('csra60', 8, 0x90005300),
        Register('csra61', 8, 0x90005308),
        Register('csra62', 8, 0x90005310),
        Register('csra63', 8, 0x90005318),
        Register('csra64', 8, 0x90005320),
        Register('csra65', 8, 0x90005328),
        Register('csra66', 8, 0x90005330),
        Register('csra67', 8, 0x90005338),
        Register('csra68', 8, 0x90005340),
        Register('csra69', 8, 0x90005348),
        Register('csra6a', 8, 0x90005350),
        Register('csra6b', 8, 0x90005358),
        Register('csra6c', 8, 0x90005360),
        Register('csra6d', 8, 0x90005368),
        Register('csra6e', 8, 0x90005370),
        Register('csra6f', 8, 0x90005378),
        Register('csra70', 8, 0x90005380),
        Register('csra71', 8, 0x90005388),
        Register('csra72', 8, 0x90005390),
        Register('csra73', 8, 0x90005398),
        Register('csra74', 8, 0x900053a0),
        Register('csra75', 8, 0x900053a8),
        Register('csra76', 8, 0x900053b0),
        Register('csra77', 8, 0x900053b8),
        Register('csra78', 8, 0x900053c0),
        Register('csra79', 8, 0x900053c8),
        Register('csra7a', 8, 0x900053d0),
        Register('csra7b', 8, 0x900053d8),
        Register('csra7c', 8, 0x900053e0),
        Register('csra7d', 8, 0x900053e8),
        Register('csra7e', 8, 0x900053f0),
        Register('csra7f', 8, 0x900053f8),
        Register('csra80', 8, 0x90005400),
        Register('csra81', 8, 0x90005408),
        Register('csra82', 8, 0x90005410),
        Register('csra83', 8, 0x90005418),
        Register('csra84', 8, 0x90005420),
        Register('csra85', 8, 0x90005428),
        Register('csra86', 8, 0x90005430),
        Register('csra87', 8, 0x90005438),
        Register('csra88', 8, 0x90005440),
        Register('csra89', 8, 0x90005448),
        Register('csra8a', 8, 0x90005450),
        Register('csra8b', 8, 0x90005458),
        Register('csra8c', 8, 0x90005460),
        Register('csra8d', 8, 0x90005468),
        Register('csra8e', 8, 0x90005470),
        Register('csra8f', 8, 0x90005478),
        Register('csra90', 8, 0x90005480),
        Register('csra91', 8, 0x90005488),
        Register('csra92', 8, 0x90005490),
        Register('csra93', 8, 0x90005498),
        Register('csra94', 8, 0x900054a0),
        Register('csra95', 8, 0x900054a8),
        Register('csra96', 8, 0x900054b0),
        Register('csra97', 8, 0x900054b8),
        Register('csra98', 8, 0x900054c0),
        Register('csra99', 8, 0x900054c8),
        Register('csra9a', 8, 0x900054d0),
        Register('csra9b', 8, 0x900054d8),
        Register('csra9c', 8, 0x900054e0),
        Register('csra9d', 8, 0x900054e8),
        Register('csra9e', 8, 0x900054f0),
        Register('csra9f', 8, 0x900054f8),
        Register('csraa0', 8, 0x90005500),
        Register('csraa1', 8, 0x90005508),
        Register('csraa2', 8, 0x90005510),
        Register('csraa3', 8, 0x90005518),
        Register('csraa4', 8, 0x90005520),
        Register('csraa5', 8, 0x90005528),
        Register('csraa6', 8, 0x90005530),
        Register('csraa7', 8, 0x90005538),
        Register('csraa8', 8, 0x90005540),
        Register('csraa9', 8, 0x90005548),
        Register('csraaa', 8, 0x90005550),
        Register('csraab', 8, 0x90005558),
        Register('csraac', 8, 0x90005560),
        Register('csraad', 8, 0x90005568),
        Register('csraae', 8, 0x90005570),
        Register('csraaf', 8, 0x90005578),
        Register('csrab0', 8, 0x90005580),
        Register('csrab1', 8, 0x90005588),
        Register('csrab2', 8, 0x90005590),
        Register('csrab3', 8, 0x90005598),
        Register('csrab4', 8, 0x900055a0),
        Register('csrab5', 8, 0x900055a8),
        Register('csrab6', 8, 0x900055b0),
        Register('csrab7', 8, 0x900055b8),
        Register('csrab8', 8, 0x900055c0),
        Register('csrab9', 8, 0x900055c8),
        Register('csraba', 8, 0x900055d0),
        Register('csrabb', 8, 0x900055d8),
        Register('csrabc', 8, 0x900055e0),
        Register('csrabd', 8, 0x900055e8),
        Register('csrabe', 8, 0x900055f0),
        Register('csrabf', 8, 0x900055f8),
        Register('csrac0', 8, 0x90005600),
        Register('csrac1', 8, 0x90005608),
        Register('csrac2', 8, 0x90005610),
        Register('csrac3', 8, 0x90005618),
        Register('csrac4', 8, 0x90005620),
        Register('csrac5', 8, 0x90005628),
        Register('csrac6', 8, 0x90005630),
        Register('csrac7', 8, 0x90005638),
        Register('csrac8', 8, 0x90005640),
        Register('csrac9', 8, 0x90005648),
        Register('csraca', 8, 0x90005650),
        Register('csracb', 8, 0x90005658),
        Register('csracc', 8, 0x90005660),
        Register('csracd', 8, 0x90005668),
        Register('csrace', 8, 0x90005670),
        Register('csracf', 8, 0x90005678),
        Register('csrad0', 8, 0x90005680),
        Register('csrad1', 8, 0x90005688),
        Register('csrad2', 8, 0x90005690),
        Register('csrad3', 8, 0x90005698),
        Register('csrad4', 8, 0x900056a0),
        Register('csrad5', 8, 0x900056a8),
        Register('csrad6', 8, 0x900056b0),
        Register('csrad7', 8, 0x900056b8),
        Register('csrad8', 8, 0x900056c0),
        Register('csrad9', 8, 0x900056c8),
        Register('csrada', 8, 0x900056d0),
        Register('csradb', 8, 0x900056d8),
        Register('csradc', 8, 0x900056e0),
        Register('csradd', 8, 0x900056e8),
        Register('csrade', 8, 0x900056f0),
        Register('csradf', 8, 0x900056f8),
        Register('csrae0', 8, 0x90005700),
        Register('csrae1', 8, 0x90005708),
        Register('csrae2', 8, 0x90005710),
        Register('csrae3', 8, 0x90005718),
        Register('csrae4', 8, 0x90005720),
        Register('csrae5', 8, 0x90005728),
        Register('csrae6', 8, 0x90005730),
        Register('csrae7', 8, 0x90005738),
        Register('csrae8', 8, 0x90005740),
        Register('csrae9', 8, 0x90005748),
        Register('csraea', 8, 0x90005750),
        Register('csraeb', 8, 0x90005758),
        Register('csraec', 8, 0x90005760),
        Register('csraed', 8, 0x90005768),
        Register('csraee', 8, 0x90005770),
        Register('csraef', 8, 0x90005778),
        Register('csraf0', 8, 0x90005780),
        Register('csraf1', 8, 0x90005788),
        Register('csraf2', 8, 0x90005790),
        Register('csraf3', 8, 0x90005798),
        Register('csraf4', 8, 0x900057a0),
        Register('csraf5', 8, 0x900057a8),
        Register('csraf6', 8, 0x900057b0),
        Register('csraf7', 8, 0x900057b8),
        Register('csraf8', 8, 0x900057c0),
        Register('csraf9', 8, 0x900057c8),
        Register('csrafa', 8, 0x900057d0),
        Register('csrafb', 8, 0x900057d8),
        Register('csrafc', 8, 0x900057e0),
        Register('csrafd', 8, 0x900057e8),
        Register('csrafe', 8, 0x900057f0),
        Register('csraff', 8, 0x900057f8),
        Register('mcycle', 8, 0x90005800),
        Register('csrb01', 8, 0x90005808),
        Register('minstret', 8, 0x90005810),
        Register('mhpmcounter3', 8, 0x90005818),
        Register('mhpmcounter4', 8, 0x90005820),
        Register('mhpmcounter5', 8, 0x90005828),
        Register('mhpmcounter6', 8, 0x90005830),
        Register('mhpmcounter7', 8, 0x90005838),
        Register('mhpmcounter8', 8, 0x90005840),
        Register('mhpmcounter9', 8, 0x90005848),
        Register('mhpmcounter10', 8, 0x90005850),
        Register('mhpmcounter11', 8, 0x90005858),
        Register('mhpmcounter12', 8, 0x90005860),
        Register('mhpmcounter13', 8, 0x90005868),
        Register('mhpmcounter14', 8, 0x90005870),
        Register('mhpmcounter15', 8, 0x90005878),
        Register('mhpmcounter16', 8, 0x90005880),
        Register('mhpmcounter17', 8, 0x90005888),
        Register('mhpmcounter18', 8, 0x90005890),
        Register('mhpmcounter19', 8, 0x90005898),
        Register('mhpmcounter20', 8, 0x900058a0),
        Register('mhpmcounter21', 8, 0x900058a8),
        Register('mhpmcounter22', 8, 0x900058b0),
        Register('mhpmcounter23', 8, 0x900058b8),
        Register('mhpmcounter24', 8, 0x900058c0),
        Register('mhpmcounter25', 8, 0x900058c8),
        Register('mhpmcounter26', 8, 0x900058d0),
        Register('mhpmcounter27', 8, 0x900058d8),
        Register('mhpmcounter28', 8, 0x900058e0),
        Register('mhpmcounter29', 8, 0x900058e8),
        Register('mhpmcounter30', 8, 0x900058f0),
        Register('mhpmcounter31', 8, 0x900058f8),
        Register('csrb20', 8, 0x90005900),
        Register('csrb21', 8, 0x90005908),
        Register('csrb22', 8, 0x90005910),
        Register('csrb23', 8, 0x90005918),
        Register('csrb24', 8, 0x90005920),
        Register('csrb25', 8, 0x90005928),
        Register('csrb26', 8, 0x90005930),
        Register('csrb27', 8, 0x90005938),
        Register('csrb28', 8, 0x90005940),
        Register('csrb29', 8, 0x90005948),
        Register('csrb2a', 8, 0x90005950),
        Register('csrb2b', 8, 0x90005958),
        Register('csrb2c', 8, 0x90005960),
        Register('csrb2d', 8, 0x90005968),
        Register('csrb2e', 8, 0x90005970),
        Register('csrb2f', 8, 0x90005978),
        Register('csrb30', 8, 0x90005980),
        Register('csrb31', 8, 0x90005988),
        Register('csrb32', 8, 0x90005990),
        Register('csrb33', 8, 0x90005998),
        Register('csrb34', 8, 0x900059a0),
        Register('csrb35', 8, 0x900059a8),
        Register('csrb36', 8, 0x900059b0),
        Register('csrb37', 8, 0x900059b8),
        Register('csrb38', 8, 0x900059c0),
        Register('csrb39', 8, 0x900059c8),
        Register('csrb3a', 8, 0x900059d0),
        Register('csrb3b', 8, 0x900059d8),
        Register('csrb3c', 8, 0x900059e0),
        Register('csrb3d', 8, 0x900059e8),
        Register('csrb3e', 8, 0x900059f0),
        Register('csrb3f', 8, 0x900059f8),
        Register('csrb40', 8, 0x90005a00),
        Register('csrb41', 8, 0x90005a08),
        Register('csrb42', 8, 0x90005a10),
        Register('csrb43', 8, 0x90005a18),
        Register('csrb44', 8, 0x90005a20),
        Register('csrb45', 8, 0x90005a28),
        Register('csrb46', 8, 0x90005a30),
        Register('csrb47', 8, 0x90005a38),
        Register('csrb48', 8, 0x90005a40),
        Register('csrb49', 8, 0x90005a48),
        Register('csrb4a', 8, 0x90005a50),
        Register('csrb4b', 8, 0x90005a58),
        Register('csrb4c', 8, 0x90005a60),
        Register('csrb4d', 8, 0x90005a68),
        Register('csrb4e', 8, 0x90005a70),
        Register('csrb4f', 8, 0x90005a78),
        Register('csrb50', 8, 0x90005a80),
        Register('csrb51', 8, 0x90005a88),
        Register('csrb52', 8, 0x90005a90),
        Register('csrb53', 8, 0x90005a98),
        Register('csrb54', 8, 0x90005aa0),
        Register('csrb55', 8, 0x90005aa8),
        Register('csrb56', 8, 0x90005ab0),
        Register('csrb57', 8, 0x90005ab8),
        Register('csrb58', 8, 0x90005ac0),
        Register('csrb59', 8, 0x90005ac8),
        Register('csrb5a', 8, 0x90005ad0),
        Register('csrb5b', 8, 0x90005ad8),
        Register('csrb5c', 8, 0x90005ae0),
        Register('csrb5d', 8, 0x90005ae8),
        Register('csrb5e', 8, 0x90005af0),
        Register('csrb5f', 8, 0x90005af8),
        Register('csrb60', 8, 0x90005b00),
        Register('csrb61', 8, 0x90005b08),
        Register('csrb62', 8, 0x90005b10),
        Register('csrb63', 8, 0x90005b18),
        Register('csrb64', 8, 0x90005b20),
        Register('csrb65', 8, 0x90005b28),
        Register('csrb66', 8, 0x90005b30),
        Register('csrb67', 8, 0x90005b38),
        Register('csrb68', 8, 0x90005b40),
        Register('csrb69', 8, 0x90005b48),
        Register('csrb6a', 8, 0x90005b50),
        Register('csrb6b', 8, 0x90005b58),
        Register('csrb6c', 8, 0x90005b60),
        Register('csrb6d', 8, 0x90005b68),
        Register('csrb6e', 8, 0x90005b70),
        Register('csrb6f', 8, 0x90005b78),
        Register('csrb70', 8, 0x90005b80),
        Register('csrb71', 8, 0x90005b88),
        Register('csrb72', 8, 0x90005b90),
        Register('csrb73', 8, 0x90005b98),
        Register('csrb74', 8, 0x90005ba0),
        Register('csrb75', 8, 0x90005ba8),
        Register('csrb76', 8, 0x90005bb0),
        Register('csrb77', 8, 0x90005bb8),
        Register('csrb78', 8, 0x90005bc0),
        Register('csrb79', 8, 0x90005bc8),
        Register('csrb7a', 8, 0x90005bd0),
        Register('csrb7b', 8, 0x90005bd8),
        Register('csrb7c', 8, 0x90005be0),
        Register('csrb7d', 8, 0x90005be8),
        Register('csrb7e', 8, 0x90005bf0),
        Register('csrb7f', 8, 0x90005bf8),
        Register('mcycleh', 8, 0x90005c00),
        Register('csrb81', 8, 0x90005c08),
        Register('minstreth', 8, 0x90005c10),
        Register('mhpmcounter3h', 8, 0x90005c18),
        Register('mhpmcounter4h', 8, 0x90005c20),
        Register('mhpmcounter5h', 8, 0x90005c28),
        Register('mhpmcounter6h', 8, 0x90005c30),
        Register('mhpmcounter7h', 8, 0x90005c38),
        Register('mhpmcounter8h', 8, 0x90005c40),
        Register('mhpmcounter9h', 8, 0x90005c48),
        Register('mhpmcounter10h', 8, 0x90005c50),
        Register('mhpmcounter11h', 8, 0x90005c58),
        Register('mhpmcounter12h', 8, 0x90005c60),
        Register('mhpmcounter13h', 8, 0x90005c68),
        Register('mhpmcounter14h', 8, 0x90005c70),
        Register('mhpmcounter15h', 8, 0x90005c78),
        Register('mhpmcounter16h', 8, 0x90005c80),
        Register('mhpmcounter17h', 8, 0x90005c88),
        Register('mhpmcounter18h', 8, 0x90005c90),
        Register('mhpmcounter19h', 8, 0x90005c98),
        Register('mhpmcounter20h', 8, 0x90005ca0),
        Register('mhpmcounter21h', 8, 0x90005ca8),
        Register('mhpmcounter22h', 8, 0x90005cb0),
        Register('mhpmcounter23h', 8, 0x90005cb8),
        Register('mhpmcounter24h', 8, 0x90005cc0),
        Register('mhpmcounter25h', 8, 0x90005cc8),
        Register('mhpmcounter26h', 8, 0x90005cd0),
        Register('mhpmcounter27h', 8, 0x90005cd8),
        Register('mhpmcounter28h', 8, 0x90005ce0),
        Register('mhpmcounter29h', 8, 0x90005ce8),
        Register('mhpmcounter30h', 8, 0x90005cf0),
        Register('mhpmcounter31h', 8, 0x90005cf8),
        Register('csrba0', 8, 0x90005d00),
        Register('csrba1', 8, 0x90005d08),
        Register('csrba2', 8, 0x90005d10),
        Register('csrba3', 8, 0x90005d18),
        Register('csrba4', 8, 0x90005d20),
        Register('csrba5', 8, 0x90005d28),
        Register('csrba6', 8, 0x90005d30),
        Register('csrba7', 8, 0x90005d38),
        Register('csrba8', 8, 0x90005d40),
        Register('csrba9', 8, 0x90005d48),
        Register('csrbaa', 8, 0x90005d50),
        Register('csrbab', 8, 0x90005d58),
        Register('csrbac', 8, 0x90005d60),
        Register('csrbad', 8, 0x90005d68),
        Register('csrbae', 8, 0x90005d70),
        Register('csrbaf', 8, 0x90005d78),
        Register('csrbb0', 8, 0x90005d80),
        Register('csrbb1', 8, 0x90005d88),
        Register('csrbb2', 8, 0x90005d90),
        Register('csrbb3', 8, 0x90005d98),
        Register('csrbb4', 8, 0x90005da0),
        Register('csrbb5', 8, 0x90005da8),
        Register('csrbb6', 8, 0x90005db0),
        Register('csrbb7', 8, 0x90005db8),
        Register('csrbb8', 8, 0x90005dc0),
        Register('csrbb9', 8, 0x90005dc8),
        Register('csrbba', 8, 0x90005dd0),
        Register('csrbbb', 8, 0x90005dd8),
        Register('csrbbc', 8, 0x90005de0),
        Register('csrbbd', 8, 0x90005de8),
        Register('csrbbe', 8, 0x90005df0),
        Register('csrbbf', 8, 0x90005df8),
        Register('csrbc0', 8, 0x90005e00),
        Register('csrbc1', 8, 0x90005e08),
        Register('csrbc2', 8, 0x90005e10),
        Register('csrbc3', 8, 0x90005e18),
        Register('csrbc4', 8, 0x90005e20),
        Register('csrbc5', 8, 0x90005e28),
        Register('csrbc6', 8, 0x90005e30),
        Register('csrbc7', 8, 0x90005e38),
        Register('csrbc8', 8, 0x90005e40),
        Register('csrbc9', 8, 0x90005e48),
        Register('csrbca', 8, 0x90005e50),
        Register('csrbcb', 8, 0x90005e58),
        Register('csrbcc', 8, 0x90005e60),
        Register('csrbcd', 8, 0x90005e68),
        Register('csrbce', 8, 0x90005e70),
        Register('csrbcf', 8, 0x90005e78),
        Register('csrbd0', 8, 0x90005e80),
        Register('csrbd1', 8, 0x90005e88),
        Register('csrbd2', 8, 0x90005e90),
        Register('csrbd3', 8, 0x90005e98),
        Register('csrbd4', 8, 0x90005ea0),
        Register('csrbd5', 8, 0x90005ea8),
        Register('csrbd6', 8, 0x90005eb0),
        Register('csrbd7', 8, 0x90005eb8),
        Register('csrbd8', 8, 0x90005ec0),
        Register('csrbd9', 8, 0x90005ec8),
        Register('csrbda', 8, 0x90005ed0),
        Register('csrbdb', 8, 0x90005ed8),
        Register('csrbdc', 8, 0x90005ee0),
        Register('csrbdd', 8, 0x90005ee8),
        Register('csrbde', 8, 0x90005ef0),
        Register('csrbdf', 8, 0x90005ef8),
        Register('csrbe0', 8, 0x90005f00),
        Register('csrbe1', 8, 0x90005f08),
        Register('csrbe2', 8, 0x90005f10),
        Register('csrbe3', 8, 0x90005f18),
        Register('csrbe4', 8, 0x90005f20),
        Register('csrbe5', 8, 0x90005f28),
        Register('csrbe6', 8, 0x90005f30),
        Register('csrbe7', 8, 0x90005f38),
        Register('csrbe8', 8, 0x90005f40),
        Register('csrbe9', 8, 0x90005f48),
        Register('csrbea', 8, 0x90005f50),
        Register('csrbeb', 8, 0x90005f58),
        Register('csrbec', 8, 0x90005f60),
        Register('csrbed', 8, 0x90005f68),
        Register('csrbee', 8, 0x90005f70),
        Register('csrbef', 8, 0x90005f78),
        Register('csrbf0', 8, 0x90005f80),
        Register('csrbf1', 8, 0x90005f88),
        Register('csrbf2', 8, 0x90005f90),
        Register('csrbf3', 8, 0x90005f98),
        Register('csrbf4', 8, 0x90005fa0),
        Register('csrbf5', 8, 0x90005fa8),
        Register('csrbf6', 8, 0x90005fb0),
        Register('csrbf7', 8, 0x90005fb8),
        Register('csrbf8', 8, 0x90005fc0),
        Register('csrbf9', 8, 0x90005fc8),
        Register('csrbfa', 8, 0x90005fd0),
        Register('csrbfb', 8, 0x90005fd8),
        Register('csrbfc', 8, 0x90005fe0),
        Register('csrbfd', 8, 0x90005fe8),
        Register('csrbfe', 8, 0x90005ff0),
        Register('csrbff', 8, 0x90005ff8),
        Register('cycle', 8, 0x90006000),
        Register('time', 8, 0x90006008),
        Register('instret', 8, 0x90006010),
        Register('hpmcounter3', 8, 0x90006018),
        Register('hpmcounter4', 8, 0x90006020),
        Register('hpmcounter5', 8, 0x90006028),
        Register('hpmcounter6', 8, 0x90006030),
        Register('hpmcounter7', 8, 0x90006038),
        Register('hpmcounter8', 8, 0x90006040),
        Register('hpmcounter9', 8, 0x90006048),
        Register('hpmcounter10', 8, 0x90006050),
        Register('hpmcounter11', 8, 0x90006058),
        Register('hpmcounter12', 8, 0x90006060),
        Register('hpmcounter13', 8, 0x90006068),
        Register('hpmcounter14', 8, 0x90006070),
        Register('hpmcounter15', 8, 0x90006078),
        Register('hpmcounter16', 8, 0x90006080),
        Register('hpmcounter17', 8, 0x90006088),
        Register('hpmcounter18', 8, 0x90006090),
        Register('hpmcounter19', 8, 0x90006098),
        Register('hpmcounter20', 8, 0x900060a0),
        Register('hpmcounter21', 8, 0x900060a8),
        Register('hpmcounter22', 8, 0x900060b0),
        Register('hpmcounter23', 8, 0x900060b8),
        Register('hpmcounter24', 8, 0x900060c0),
        Register('hpmcounter25', 8, 0x900060c8),
        Register('hpmcounter26', 8, 0x900060d0),
        Register('hpmcounter27', 8, 0x900060d8),
        Register('hpmcounter28', 8, 0x900060e0),
        Register('hpmcounter29', 8, 0x900060e8),
        Register('hpmcounter30', 8, 0x900060f0),
        Register('hpmcounter31', 8, 0x900060f8),
        Register('vl', 8, 0x90006100),
        Register('vtype', 8, 0x90006108),
        Register('vlenb', 8, 0x90006110),
        Register('csrc23', 8, 0x90006118),
        Register('csrc24', 8, 0x90006120),
        Register('csrc25', 8, 0x90006128),
        Register('csrc26', 8, 0x90006130),
        Register('csrc27', 8, 0x90006138),
        Register('csrc28', 8, 0x90006140),
        Register('csrc29', 8, 0x90006148),
        Register('csrc2a', 8, 0x90006150),
        Register('csrc2b', 8, 0x90006158),
        Register('csrc2c', 8, 0x90006160),
        Register('csrc2d', 8, 0x90006168),
        Register('csrc2e', 8, 0x90006170),
        Register('csrc2f', 8, 0x90006178),
        Register('csrc30', 8, 0x90006180),
        Register('csrc31', 8, 0x90006188),
        Register('csrc32', 8, 0x90006190),
        Register('csrc33', 8, 0x90006198),
        Register('csrc34', 8, 0x900061a0),
        Register('csrc35', 8, 0x900061a8),
        Register('csrc36', 8, 0x900061b0),
        Register('csrc37', 8, 0x900061b8),
        Register('csrc38', 8, 0x900061c0),
        Register('csrc39', 8, 0x900061c8),
        Register('csrc3a', 8, 0x900061d0),
        Register('csrc3b', 8, 0x900061d8),
        Register('csrc3c', 8, 0x900061e0),
        Register('csrc3d', 8, 0x900061e8),
        Register('csrc3e', 8, 0x900061f0),
        Register('csrc3f', 8, 0x900061f8),
        Register('csrc40', 8, 0x90006200),
        Register('csrc41', 8, 0x90006208),
        Register('csrc42', 8, 0x90006210),
        Register('csrc43', 8, 0x90006218),
        Register('csrc44', 8, 0x90006220),
        Register('csrc45', 8, 0x90006228),
        Register('csrc46', 8, 0x90006230),
        Register('csrc47', 8, 0x90006238),
        Register('csrc48', 8, 0x90006240),
        Register('csrc49', 8, 0x90006248),
        Register('csrc4a', 8, 0x90006250),
        Register('csrc4b', 8, 0x90006258),
        Register('csrc4c', 8, 0x90006260),
        Register('csrc4d', 8, 0x90006268),
        Register('csrc4e', 8, 0x90006270),
        Register('csrc4f', 8, 0x90006278),
        Register('csrc50', 8, 0x90006280),
        Register('csrc51', 8, 0x90006288),
        Register('csrc52', 8, 0x90006290),
        Register('csrc53', 8, 0x90006298),
        Register('csrc54', 8, 0x900062a0),
        Register('csrc55', 8, 0x900062a8),
        Register('csrc56', 8, 0x900062b0),
        Register('csrc57', 8, 0x900062b8),
        Register('csrc58', 8, 0x900062c0),
        Register('csrc59', 8, 0x900062c8),
        Register('csrc5a', 8, 0x900062d0),
        Register('csrc5b', 8, 0x900062d8),
        Register('csrc5c', 8, 0x900062e0),
        Register('csrc5d', 8, 0x900062e8),
        Register('csrc5e', 8, 0x900062f0),
        Register('csrc5f', 8, 0x900062f8),
        Register('csrc60', 8, 0x90006300),
        Register('csrc61', 8, 0x90006308),
        Register('csrc62', 8, 0x90006310),
        Register('csrc63', 8, 0x90006318),
        Register('csrc64', 8, 0x90006320),
        Register('csrc65', 8, 0x90006328),
        Register('csrc66', 8, 0x90006330),
        Register('csrc67', 8, 0x90006338),
        Register('csrc68', 8, 0x90006340),
        Register('csrc69', 8, 0x90006348),
        Register('csrc6a', 8, 0x90006350),
        Register('csrc6b', 8, 0x90006358),
        Register('csrc6c', 8, 0x90006360),
        Register('csrc6d', 8, 0x90006368),
        Register('csrc6e', 8, 0x90006370),
        Register('csrc6f', 8, 0x90006378),
        Register('csrc70', 8, 0x90006380),
        Register('csrc71', 8, 0x90006388),
        Register('csrc72', 8, 0x90006390),
        Register('csrc73', 8, 0x90006398),
        Register('csrc74', 8, 0x900063a0),
        Register('csrc75', 8, 0x900063a8),
        Register('csrc76', 8, 0x900063b0),
        Register('csrc77', 8, 0x900063b8),
        Register('csrc78', 8, 0x900063c0),
        Register('csrc79', 8, 0x900063c8),
        Register('csrc7a', 8, 0x900063d0),
        Register('csrc7b', 8, 0x900063d8),
        Register('csrc7c', 8, 0x900063e0),
        Register('csrc7d', 8, 0x900063e8),
        Register('csrc7e', 8, 0x900063f0),
        Register('csrc7f', 8, 0x900063f8),
        Register('cycleh', 8, 0x90006400),
        Register('timeh', 8, 0x90006408),
        Register('instreth', 8, 0x90006410),
        Register('hpmcounter3h', 8, 0x90006418),
        Register('hpmcounter4h', 8, 0x90006420),
        Register('hpmcounter5h', 8, 0x90006428),
        Register('hpmcounter6h', 8, 0x90006430),
        Register('hpmcounter7h', 8, 0x90006438),
        Register('hpmcounter8h', 8, 0x90006440),
        Register('hpmcounter9h', 8, 0x90006448),
        Register('hpmcounter10h', 8, 0x90006450),
        Register('hpmcounter11h', 8, 0x90006458),
        Register('hpmcounter12h', 8, 0x90006460),
        Register('hpmcounter13h', 8, 0x90006468),
        Register('hpmcounter14h', 8, 0x90006470),
        Register('hpmcounter15h', 8, 0x90006478),
        Register('hpmcounter16h', 8, 0x90006480),
        Register('hpmcounter17h', 8, 0x90006488),
        Register('hpmcounter18h', 8, 0x90006490),
        Register('hpmcounter19h', 8, 0x90006498),
        Register('hpmcounter20h', 8, 0x900064a0),
        Register('hpmcounter21h', 8, 0x900064a8),
        Register('hpmcounter22h', 8, 0x900064b0),
        Register('hpmcounter23h', 8, 0x900064b8),
        Register('hpmcounter24h', 8, 0x900064c0),
        Register('hpmcounter25h', 8, 0x900064c8),
        Register('hpmcounter26h', 8, 0x900064d0),
        Register('hpmcounter27h', 8, 0x900064d8),
        Register('hpmcounter28h', 8, 0x900064e0),
        Register('hpmcounter29h', 8, 0x900064e8),
        Register('hpmcounter30h', 8, 0x900064f0),
        Register('hpmcounter31h', 8, 0x900064f8),
        Register('csrca0', 8, 0x90006500),
        Register('csrca1', 8, 0x90006508),
        Register('csrca2', 8, 0x90006510),
        Register('csrca3', 8, 0x90006518),
        Register('csrca4', 8, 0x90006520),
        Register('csrca5', 8, 0x90006528),
        Register('csrca6', 8, 0x90006530),
        Register('csrca7', 8, 0x90006538),
        Register('csrca8', 8, 0x90006540),
        Register('csrca9', 8, 0x90006548),
        Register('csrcaa', 8, 0x90006550),
        Register('csrcab', 8, 0x90006558),
        Register('csrcac', 8, 0x90006560),
        Register('csrcad', 8, 0x90006568),
        Register('csrcae', 8, 0x90006570),
        Register('csrcaf', 8, 0x90006578),
        Register('csrcb0', 8, 0x90006580),
        Register('csrcb1', 8, 0x90006588),
        Register('csrcb2', 8, 0x90006590),
        Register('csrcb3', 8, 0x90006598),
        Register('csrcb4', 8, 0x900065a0),
        Register('csrcb5', 8, 0x900065a8),
        Register('csrcb6', 8, 0x900065b0),
        Register('csrcb7', 8, 0x900065b8),
        Register('csrcb8', 8, 0x900065c0),
        Register('csrcb9', 8, 0x900065c8),
        Register('csrcba', 8, 0x900065d0),
        Register('csrcbb', 8, 0x900065d8),
        Register('csrcbc', 8, 0x900065e0),
        Register('csrcbd', 8, 0x900065e8),
        Register('csrcbe', 8, 0x900065f0),
        Register('csrcbf', 8, 0x900065f8),
        Register('csrcc0', 8, 0x90006600),
        Register('csrcc1', 8, 0x90006608),
        Register('csrcc2', 8, 0x90006610),
        Register('csrcc3', 8, 0x90006618),
        Register('csrcc4', 8, 0x90006620),
        Register('csrcc5', 8, 0x90006628),
        Register('csrcc6', 8, 0x90006630),
        Register('csrcc7', 8, 0x90006638),
        Register('csrcc8', 8, 0x90006640),
        Register('csrcc9', 8, 0x90006648),
        Register('csrcca', 8, 0x90006650),
        Register('csrccb', 8, 0x90006658),
        Register('csrccc', 8, 0x90006660),
        Register('csrccd', 8, 0x90006668),
        Register('csrcce', 8, 0x90006670),
        Register('csrccf', 8, 0x90006678),
        Register('csrcd0', 8, 0x90006680),
        Register('csrcd1', 8, 0x90006688),
        Register('csrcd2', 8, 0x90006690),
        Register('csrcd3', 8, 0x90006698),
        Register('csrcd4', 8, 0x900066a0),
        Register('csrcd5', 8, 0x900066a8),
        Register('csrcd6', 8, 0x900066b0),
        Register('csrcd7', 8, 0x900066b8),
        Register('csrcd8', 8, 0x900066c0),
        Register('csrcd9', 8, 0x900066c8),
        Register('csrcda', 8, 0x900066d0),
        Register('csrcdb', 8, 0x900066d8),
        Register('csrcdc', 8, 0x900066e0),
        Register('csrcdd', 8, 0x900066e8),
        Register('csrcde', 8, 0x900066f0),
        Register('csrcdf', 8, 0x900066f8),
        Register('csrce0', 8, 0x90006700),
        Register('csrce1', 8, 0x90006708),
        Register('csrce2', 8, 0x90006710),
        Register('csrce3', 8, 0x90006718),
        Register('csrce4', 8, 0x90006720),
        Register('csrce5', 8, 0x90006728),
        Register('csrce6', 8, 0x90006730),
        Register('csrce7', 8, 0x90006738),
        Register('csrce8', 8, 0x90006740),
        Register('csrce9', 8, 0x90006748),
        Register('csrcea', 8, 0x90006750),
        Register('csrceb', 8, 0x90006758),
        Register('csrcec', 8, 0x90006760),
        Register('csrced', 8, 0x90006768),
        Register('csrcee', 8, 0x90006770),
        Register('csrcef', 8, 0x90006778),
        Register('csrcf0', 8, 0x90006780),
        Register('csrcf1', 8, 0x90006788),
        Register('csrcf2', 8, 0x90006790),
        Register('csrcf3', 8, 0x90006798),
        Register('csrcf4', 8, 0x900067a0),
        Register('csrcf5', 8, 0x900067a8),
        Register('csrcf6', 8, 0x900067b0),
        Register('csrcf7', 8, 0x900067b8),
        Register('csrcf8', 8, 0x900067c0),
        Register('csrcf9', 8, 0x900067c8),
        Register('csrcfa', 8, 0x900067d0),
        Register('csrcfb', 8, 0x900067d8),
        Register('csrcfc', 8, 0x900067e0),
        Register('csrcfd', 8, 0x900067e8),
        Register('csrcfe', 8, 0x900067f0),
        Register('csrcff', 8, 0x900067f8),
        Register('csrd00', 8, 0x90006800),
        Register('csrd01', 8, 0x90006808),
        Register('csrd02', 8, 0x90006810),
        Register('csrd03', 8, 0x90006818),
        Register('csrd04', 8, 0x90006820),
        Register('csrd05', 8, 0x90006828),
        Register('csrd06', 8, 0x90006830),
        Register('csrd07', 8, 0x90006838),
        Register('csrd08', 8, 0x90006840),
        Register('csrd09', 8, 0x90006848),
        Register('csrd0a', 8, 0x90006850),
        Register('csrd0b', 8, 0x90006858),
        Register('csrd0c', 8, 0x90006860),
        Register('csrd0d', 8, 0x90006868),
        Register('csrd0e', 8, 0x90006870),
        Register('csrd0f', 8, 0x90006878),
        Register('csrd10', 8, 0x90006880),
        Register('csrd11', 8, 0x90006888),
        Register('csrd12', 8, 0x90006890),
        Register('csrd13', 8, 0x90006898),
        Register('csrd14', 8, 0x900068a0),
        Register('csrd15', 8, 0x900068a8),
        Register('csrd16', 8, 0x900068b0),
        Register('csrd17', 8, 0x900068b8),
        Register('csrd18', 8, 0x900068c0),
        Register('csrd19', 8, 0x900068c8),
        Register('csrd1a', 8, 0x900068d0),
        Register('csrd1b', 8, 0x900068d8),
        Register('csrd1c', 8, 0x900068e0),
        Register('csrd1d', 8, 0x900068e8),
        Register('csrd1e', 8, 0x900068f0),
        Register('csrd1f', 8, 0x900068f8),
        Register('csrd20', 8, 0x90006900),
        Register('csrd21', 8, 0x90006908),
        Register('csrd22', 8, 0x90006910),
        Register('csrd23', 8, 0x90006918),
        Register('csrd24', 8, 0x90006920),
        Register('csrd25', 8, 0x90006928),
        Register('csrd26', 8, 0x90006930),
        Register('csrd27', 8, 0x90006938),
        Register('csrd28', 8, 0x90006940),
        Register('csrd29', 8, 0x90006948),
        Register('csrd2a', 8, 0x90006950),
        Register('csrd2b', 8, 0x90006958),
        Register('csrd2c', 8, 0x90006960),
        Register('csrd2d', 8, 0x90006968),
        Register('csrd2e', 8, 0x90006970),
        Register('csrd2f', 8, 0x90006978),
        Register('csrd30', 8, 0x90006980),
        Register('csrd31', 8, 0x90006988),
        Register('csrd32', 8, 0x90006990),
        Register('csrd33', 8, 0x90006998),
        Register('csrd34', 8, 0x900069a0),
        Register('csrd35', 8, 0x900069a8),
        Register('csrd36', 8, 0x900069b0),
        Register('csrd37', 8, 0x900069b8),
        Register('csrd38', 8, 0x900069c0),
        Register('csrd39', 8, 0x900069c8),
        Register('csrd3a', 8, 0x900069d0),
        Register('csrd3b', 8, 0x900069d8),
        Register('csrd3c', 8, 0x900069e0),
        Register('csrd3d', 8, 0x900069e8),
        Register('csrd3e', 8, 0x900069f0),
        Register('csrd3f', 8, 0x900069f8),
        Register('csrd40', 8, 0x90006a00),
        Register('csrd41', 8, 0x90006a08),
        Register('csrd42', 8, 0x90006a10),
        Register('csrd43', 8, 0x90006a18),
        Register('csrd44', 8, 0x90006a20),
        Register('csrd45', 8, 0x90006a28),
        Register('csrd46', 8, 0x90006a30),
        Register('csrd47', 8, 0x90006a38),
        Register('csrd48', 8, 0x90006a40),
        Register('csrd49', 8, 0x90006a48),
        Register('csrd4a', 8, 0x90006a50),
        Register('csrd4b', 8, 0x90006a58),
        Register('csrd4c', 8, 0x90006a60),
        Register('csrd4d', 8, 0x90006a68),
        Register('csrd4e', 8, 0x90006a70),
        Register('csrd4f', 8, 0x90006a78),
        Register('csrd50', 8, 0x90006a80),
        Register('csrd51', 8, 0x90006a88),
        Register('csrd52', 8, 0x90006a90),
        Register('csrd53', 8, 0x90006a98),
        Register('csrd54', 8, 0x90006aa0),
        Register('csrd55', 8, 0x90006aa8),
        Register('csrd56', 8, 0x90006ab0),
        Register('csrd57', 8, 0x90006ab8),
        Register('csrd58', 8, 0x90006ac0),
        Register('csrd59', 8, 0x90006ac8),
        Register('csrd5a', 8, 0x90006ad0),
        Register('csrd5b', 8, 0x90006ad8),
        Register('csrd5c', 8, 0x90006ae0),
        Register('csrd5d', 8, 0x90006ae8),
        Register('csrd5e', 8, 0x90006af0),
        Register('csrd5f', 8, 0x90006af8),
        Register('csrd60', 8, 0x90006b00),
        Register('csrd61', 8, 0x90006b08),
        Register('csrd62', 8, 0x90006b10),
        Register('csrd63', 8, 0x90006b18),
        Register('csrd64', 8, 0x90006b20),
        Register('csrd65', 8, 0x90006b28),
        Register('csrd66', 8, 0x90006b30),
        Register('csrd67', 8, 0x90006b38),
        Register('csrd68', 8, 0x90006b40),
        Register('csrd69', 8, 0x90006b48),
        Register('csrd6a', 8, 0x90006b50),
        Register('csrd6b', 8, 0x90006b58),
        Register('csrd6c', 8, 0x90006b60),
        Register('csrd6d', 8, 0x90006b68),
        Register('csrd6e', 8, 0x90006b70),
        Register('csrd6f', 8, 0x90006b78),
        Register('csrd70', 8, 0x90006b80),
        Register('csrd71', 8, 0x90006b88),
        Register('csrd72', 8, 0x90006b90),
        Register('csrd73', 8, 0x90006b98),
        Register('csrd74', 8, 0x90006ba0),
        Register('csrd75', 8, 0x90006ba8),
        Register('csrd76', 8, 0x90006bb0),
        Register('csrd77', 8, 0x90006bb8),
        Register('csrd78', 8, 0x90006bc0),
        Register('csrd79', 8, 0x90006bc8),
        Register('csrd7a', 8, 0x90006bd0),
        Register('csrd7b', 8, 0x90006bd8),
        Register('csrd7c', 8, 0x90006be0),
        Register('csrd7d', 8, 0x90006be8),
        Register('csrd7e', 8, 0x90006bf0),
        Register('csrd7f', 8, 0x90006bf8),
        Register('csrd80', 8, 0x90006c00),
        Register('csrd81', 8, 0x90006c08),
        Register('csrd82', 8, 0x90006c10),
        Register('csrd83', 8, 0x90006c18),
        Register('csrd84', 8, 0x90006c20),
        Register('csrd85', 8, 0x90006c28),
        Register('csrd86', 8, 0x90006c30),
        Register('csrd87', 8, 0x90006c38),
        Register('csrd88', 8, 0x90006c40),
        Register('csrd89', 8, 0x90006c48),
        Register('csrd8a', 8, 0x90006c50),
        Register('csrd8b', 8, 0x90006c58),
        Register('csrd8c', 8, 0x90006c60),
        Register('csrd8d', 8, 0x90006c68),
        Register('csrd8e', 8, 0x90006c70),
        Register('csrd8f', 8, 0x90006c78),
        Register('csrd90', 8, 0x90006c80),
        Register('csrd91', 8, 0x90006c88),
        Register('csrd92', 8, 0x90006c90),
        Register('csrd93', 8, 0x90006c98),
        Register('csrd94', 8, 0x90006ca0),
        Register('csrd95', 8, 0x90006ca8),
        Register('csrd96', 8, 0x90006cb0),
        Register('csrd97', 8, 0x90006cb8),
        Register('csrd98', 8, 0x90006cc0),
        Register('csrd99', 8, 0x90006cc8),
        Register('csrd9a', 8, 0x90006cd0),
        Register('csrd9b', 8, 0x90006cd8),
        Register('csrd9c', 8, 0x90006ce0),
        Register('csrd9d', 8, 0x90006ce8),
        Register('csrd9e', 8, 0x90006cf0),
        Register('csrd9f', 8, 0x90006cf8),
        Register('csrda0', 8, 0x90006d00),
        Register('csrda1', 8, 0x90006d08),
        Register('csrda2', 8, 0x90006d10),
        Register('csrda3', 8, 0x90006d18),
        Register('csrda4', 8, 0x90006d20),
        Register('csrda5', 8, 0x90006d28),
        Register('csrda6', 8, 0x90006d30),
        Register('csrda7', 8, 0x90006d38),
        Register('csrda8', 8, 0x90006d40),
        Register('csrda9', 8, 0x90006d48),
        Register('csrdaa', 8, 0x90006d50),
        Register('csrdab', 8, 0x90006d58),
        Register('csrdac', 8, 0x90006d60),
        Register('csrdad', 8, 0x90006d68),
        Register('csrdae', 8, 0x90006d70),
        Register('csrdaf', 8, 0x90006d78),
        Register('csrdb0', 8, 0x90006d80),
        Register('csrdb1', 8, 0x90006d88),
        Register('csrdb2', 8, 0x90006d90),
        Register('csrdb3', 8, 0x90006d98),
        Register('csrdb4', 8, 0x90006da0),
        Register('csrdb5', 8, 0x90006da8),
        Register('csrdb6', 8, 0x90006db0),
        Register('csrdb7', 8, 0x90006db8),
        Register('csrdb8', 8, 0x90006dc0),
        Register('csrdb9', 8, 0x90006dc8),
        Register('csrdba', 8, 0x90006dd0),
        Register('csrdbb', 8, 0x90006dd8),
        Register('csrdbc', 8, 0x90006de0),
        Register('csrdbd', 8, 0x90006de8),
        Register('csrdbe', 8, 0x90006df0),
        Register('csrdbf', 8, 0x90006df8),
        Register('csrdc0', 8, 0x90006e00),
        Register('csrdc1', 8, 0x90006e08),
        Register('csrdc2', 8, 0x90006e10),
        Register('csrdc3', 8, 0x90006e18),
        Register('csrdc4', 8, 0x90006e20),
        Register('csrdc5', 8, 0x90006e28),
        Register('csrdc6', 8, 0x90006e30),
        Register('csrdc7', 8, 0x90006e38),
        Register('csrdc8', 8, 0x90006e40),
        Register('csrdc9', 8, 0x90006e48),
        Register('csrdca', 8, 0x90006e50),
        Register('csrdcb', 8, 0x90006e58),
        Register('csrdcc', 8, 0x90006e60),
        Register('csrdcd', 8, 0x90006e68),
        Register('csrdce', 8, 0x90006e70),
        Register('csrdcf', 8, 0x90006e78),
        Register('csrdd0', 8, 0x90006e80),
        Register('csrdd1', 8, 0x90006e88),
        Register('csrdd2', 8, 0x90006e90),
        Register('csrdd3', 8, 0x90006e98),
        Register('csrdd4', 8, 0x90006ea0),
        Register('csrdd5', 8, 0x90006ea8),
        Register('csrdd6', 8, 0x90006eb0),
        Register('csrdd7', 8, 0x90006eb8),
        Register('csrdd8', 8, 0x90006ec0),
        Register('csrdd9', 8, 0x90006ec8),
        Register('csrdda', 8, 0x90006ed0),
        Register('csrddb', 8, 0x90006ed8),
        Register('csrddc', 8, 0x90006ee0),
        Register('csrddd', 8, 0x90006ee8),
        Register('csrdde', 8, 0x90006ef0),
        Register('csrddf', 8, 0x90006ef8),
        Register('csrde0', 8, 0x90006f00),
        Register('csrde1', 8, 0x90006f08),
        Register('csrde2', 8, 0x90006f10),
        Register('csrde3', 8, 0x90006f18),
        Register('csrde4', 8, 0x90006f20),
        Register('csrde5', 8, 0x90006f28),
        Register('csrde6', 8, 0x90006f30),
        Register('csrde7', 8, 0x90006f38),
        Register('csrde8', 8, 0x90006f40),
        Register('csrde9', 8, 0x90006f48),
        Register('csrdea', 8, 0x90006f50),
        Register('csrdeb', 8, 0x90006f58),
        Register('csrdec', 8, 0x90006f60),
        Register('csrded', 8, 0x90006f68),
        Register('csrdee', 8, 0x90006f70),
        Register('csrdef', 8, 0x90006f78),
        Register('csrdf0', 8, 0x90006f80),
        Register('csrdf1', 8, 0x90006f88),
        Register('csrdf2', 8, 0x90006f90),
        Register('csrdf3', 8, 0x90006f98),
        Register('csrdf4', 8, 0x90006fa0),
        Register('csrdf5', 8, 0x90006fa8),
        Register('csrdf6', 8, 0x90006fb0),
        Register('csrdf7', 8, 0x90006fb8),
        Register('csrdf8', 8, 0x90006fc0),
        Register('csrdf9', 8, 0x90006fc8),
        Register('csrdfa', 8, 0x90006fd0),
        Register('csrdfb', 8, 0x90006fd8),
        Register('csrdfc', 8, 0x90006fe0),
        Register('csrdfd', 8, 0x90006fe8),
        Register('csrdfe', 8, 0x90006ff0),
        Register('csrdff', 8, 0x90006ff8),
        Register('csre00', 8, 0x90007000),
        Register('csre01', 8, 0x90007008),
        Register('csre02', 8, 0x90007010),
        Register('csre03', 8, 0x90007018),
        Register('csre04', 8, 0x90007020),
        Register('csre05', 8, 0x90007028),
        Register('csre06', 8, 0x90007030),
        Register('csre07', 8, 0x90007038),
        Register('csre08', 8, 0x90007040),
        Register('csre09', 8, 0x90007048),
        Register('csre0a', 8, 0x90007050),
        Register('csre0b', 8, 0x90007058),
        Register('csre0c', 8, 0x90007060),
        Register('csre0d', 8, 0x90007068),
        Register('csre0e', 8, 0x90007070),
        Register('csre0f', 8, 0x90007078),
        Register('csre10', 8, 0x90007080),
        Register('csre11', 8, 0x90007088),
        Register('hgeip', 8, 0x90007090),
        Register('csre13', 8, 0x90007098),
        Register('csre14', 8, 0x900070a0),
        Register('csre15', 8, 0x900070a8),
        Register('csre16', 8, 0x900070b0),
        Register('csre17', 8, 0x900070b8),
        Register('csre18', 8, 0x900070c0),
        Register('csre19', 8, 0x900070c8),
        Register('csre1a', 8, 0x900070d0),
        Register('csre1b', 8, 0x900070d8),
        Register('csre1c', 8, 0x900070e0),
        Register('csre1d', 8, 0x900070e8),
        Register('csre1e', 8, 0x900070f0),
        Register('csre1f', 8, 0x900070f8),
        Register('csre20', 8, 0x90007100),
        Register('csre21', 8, 0x90007108),
        Register('csre22', 8, 0x90007110),
        Register('csre23', 8, 0x90007118),
        Register('csre24', 8, 0x90007120),
        Register('csre25', 8, 0x90007128),
        Register('csre26', 8, 0x90007130),
        Register('csre27', 8, 0x90007138),
        Register('csre28', 8, 0x90007140),
        Register('csre29', 8, 0x90007148),
        Register('csre2a', 8, 0x90007150),
        Register('csre2b', 8, 0x90007158),
        Register('csre2c', 8, 0x90007160),
        Register('csre2d', 8, 0x90007168),
        Register('csre2e', 8, 0x90007170),
        Register('csre2f', 8, 0x90007178),
        Register('csre30', 8, 0x90007180),
        Register('csre31', 8, 0x90007188),
        Register('csre32', 8, 0x90007190),
        Register('csre33', 8, 0x90007198),
        Register('csre34', 8, 0x900071a0),
        Register('csre35', 8, 0x900071a8),
        Register('csre36', 8, 0x900071b0),
        Register('csre37', 8, 0x900071b8),
        Register('csre38', 8, 0x900071c0),
        Register('csre39', 8, 0x900071c8),
        Register('csre3a', 8, 0x900071d0),
        Register('csre3b', 8, 0x900071d8),
        Register('csre3c', 8, 0x900071e0),
        Register('csre3d', 8, 0x900071e8),
        Register('csre3e', 8, 0x900071f0),
        Register('csre3f', 8, 0x900071f8),
        Register('csre40', 8, 0x90007200),
        Register('csre41', 8, 0x90007208),
        Register('csre42', 8, 0x90007210),
        Register('csre43', 8, 0x90007218),
        Register('csre44', 8, 0x90007220),
        Register('csre45', 8, 0x90007228),
        Register('csre46', 8, 0x90007230),
        Register('csre47', 8, 0x90007238),
        Register('csre48', 8, 0x90007240),
        Register('csre49', 8, 0x90007248),
        Register('csre4a', 8, 0x90007250),
        Register('csre4b', 8, 0x90007258),
        Register('csre4c', 8, 0x90007260),
        Register('csre4d', 8, 0x90007268),
        Register('csre4e', 8, 0x90007270),
        Register('csre4f', 8, 0x90007278),
        Register('csre50', 8, 0x90007280),
        Register('csre51', 8, 0x90007288),
        Register('csre52', 8, 0x90007290),
        Register('csre53', 8, 0x90007298),
        Register('csre54', 8, 0x900072a0),
        Register('csre55', 8, 0x900072a8),
        Register('csre56', 8, 0x900072b0),
        Register('csre57', 8, 0x900072b8),
        Register('csre58', 8, 0x900072c0),
        Register('csre59', 8, 0x900072c8),
        Register('csre5a', 8, 0x900072d0),
        Register('csre5b', 8, 0x900072d8),
        Register('csre5c', 8, 0x900072e0),
        Register('csre5d', 8, 0x900072e8),
        Register('csre5e', 8, 0x900072f0),
        Register('csre5f', 8, 0x900072f8),
        Register('csre60', 8, 0x90007300),
        Register('csre61', 8, 0x90007308),
        Register('csre62', 8, 0x90007310),
        Register('csre63', 8, 0x90007318),
        Register('csre64', 8, 0x90007320),
        Register('csre65', 8, 0x90007328),
        Register('csre66', 8, 0x90007330),
        Register('csre67', 8, 0x90007338),
        Register('csre68', 8, 0x90007340),
        Register('csre69', 8, 0x90007348),
        Register('csre6a', 8, 0x90007350),
        Register('csre6b', 8, 0x90007358),
        Register('csre6c', 8, 0x90007360),
        Register('csre6d', 8, 0x90007368),
        Register('csre6e', 8, 0x90007370),
        Register('csre6f', 8, 0x90007378),
        Register('csre70', 8, 0x90007380),
        Register('csre71', 8, 0x90007388),
        Register('csre72', 8, 0x90007390),
        Register('csre73', 8, 0x90007398),
        Register('csre74', 8, 0x900073a0),
        Register('csre75', 8, 0x900073a8),
        Register('csre76', 8, 0x900073b0),
        Register('csre77', 8, 0x900073b8),
        Register('csre78', 8, 0x900073c0),
        Register('csre79', 8, 0x900073c8),
        Register('csre7a', 8, 0x900073d0),
        Register('csre7b', 8, 0x900073d8),
        Register('csre7c', 8, 0x900073e0),
        Register('csre7d', 8, 0x900073e8),
        Register('csre7e', 8, 0x900073f0),
        Register('csre7f', 8, 0x900073f8),
        Register('csre80', 8, 0x90007400),
        Register('csre81', 8, 0x90007408),
        Register('csre82', 8, 0x90007410),
        Register('csre83', 8, 0x90007418),
        Register('csre84', 8, 0x90007420),
        Register('csre85', 8, 0x90007428),
        Register('csre86', 8, 0x90007430),
        Register('csre87', 8, 0x90007438),
        Register('csre88', 8, 0x90007440),
        Register('csre89', 8, 0x90007448),
        Register('csre8a', 8, 0x90007450),
        Register('csre8b', 8, 0x90007458),
        Register('csre8c', 8, 0x90007460),
        Register('csre8d', 8, 0x90007468),
        Register('csre8e', 8, 0x90007470),
        Register('csre8f', 8, 0x90007478),
        Register('csre90', 8, 0x90007480),
        Register('csre91', 8, 0x90007488),
        Register('csre92', 8, 0x90007490),
        Register('csre93', 8, 0x90007498),
        Register('csre94', 8, 0x900074a0),
        Register('csre95', 8, 0x900074a8),
        Register('csre96', 8, 0x900074b0),
        Register('csre97', 8, 0x900074b8),
        Register('csre98', 8, 0x900074c0),
        Register('csre99', 8, 0x900074c8),
        Register('csre9a', 8, 0x900074d0),
        Register('csre9b', 8, 0x900074d8),
        Register('csre9c', 8, 0x900074e0),
        Register('csre9d', 8, 0x900074e8),
        Register('csre9e', 8, 0x900074f0),
        Register('csre9f', 8, 0x900074f8),
        Register('csrea0', 8, 0x90007500),
        Register('csrea1', 8, 0x90007508),
        Register('csrea2', 8, 0x90007510),
        Register('csrea3', 8, 0x90007518),
        Register('csrea4', 8, 0x90007520),
        Register('csrea5', 8, 0x90007528),
        Register('csrea6', 8, 0x90007530),
        Register('csrea7', 8, 0x90007538),
        Register('csrea8', 8, 0x90007540),
        Register('csrea9', 8, 0x90007548),
        Register('csreaa', 8, 0x90007550),
        Register('csreab', 8, 0x90007558),
        Register('csreac', 8, 0x90007560),
        Register('csread', 8, 0x90007568),
        Register('csreae', 8, 0x90007570),
        Register('csreaf', 8, 0x90007578),
        Register('csreb0', 8, 0x90007580),
        Register('csreb1', 8, 0x90007588),
        Register('csreb2', 8, 0x90007590),
        Register('csreb3', 8, 0x90007598),
        Register('csreb4', 8, 0x900075a0),
        Register('csreb5', 8, 0x900075a8),
        Register('csreb6', 8, 0x900075b0),
        Register('csreb7', 8, 0x900075b8),
        Register('csreb8', 8, 0x900075c0),
        Register('csreb9', 8, 0x900075c8),
        Register('csreba', 8, 0x900075d0),
        Register('csrebb', 8, 0x900075d8),
        Register('csrebc', 8, 0x900075e0),
        Register('csrebd', 8, 0x900075e8),
        Register('csrebe', 8, 0x900075f0),
        Register('csrebf', 8, 0x900075f8),
        Register('csrec0', 8, 0x90007600),
        Register('csrec1', 8, 0x90007608),
        Register('csrec2', 8, 0x90007610),
        Register('csrec3', 8, 0x90007618),
        Register('csrec4', 8, 0x90007620),
        Register('csrec5', 8, 0x90007628),
        Register('csrec6', 8, 0x90007630),
        Register('csrec7', 8, 0x90007638),
        Register('csrec8', 8, 0x90007640),
        Register('csrec9', 8, 0x90007648),
        Register('csreca', 8, 0x90007650),
        Register('csrecb', 8, 0x90007658),
        Register('csrecc', 8, 0x90007660),
        Register('csrecd', 8, 0x90007668),
        Register('csrece', 8, 0x90007670),
        Register('csrecf', 8, 0x90007678),
        Register('csred0', 8, 0x90007680),
        Register('csred1', 8, 0x90007688),
        Register('csred2', 8, 0x90007690),
        Register('csred3', 8, 0x90007698),
        Register('csred4', 8, 0x900076a0),
        Register('csred5', 8, 0x900076a8),
        Register('csred6', 8, 0x900076b0),
        Register('csred7', 8, 0x900076b8),
        Register('csred8', 8, 0x900076c0),
        Register('csred9', 8, 0x900076c8),
        Register('csreda', 8, 0x900076d0),
        Register('csredb', 8, 0x900076d8),
        Register('csredc', 8, 0x900076e0),
        Register('csredd', 8, 0x900076e8),
        Register('csrede', 8, 0x900076f0),
        Register('csredf', 8, 0x900076f8),
        Register('csree0', 8, 0x90007700),
        Register('csree1', 8, 0x90007708),
        Register('csree2', 8, 0x90007710),
        Register('csree3', 8, 0x90007718),
        Register('csree4', 8, 0x90007720),
        Register('csree5', 8, 0x90007728),
        Register('csree6', 8, 0x90007730),
        Register('csree7', 8, 0x90007738),
        Register('csree8', 8, 0x90007740),
        Register('csree9', 8, 0x90007748),
        Register('csreea', 8, 0x90007750),
        Register('csreeb', 8, 0x90007758),
        Register('csreec', 8, 0x90007760),
        Register('csreed', 8, 0x90007768),
        Register('csreee', 8, 0x90007770),
        Register('csreef', 8, 0x90007778),
        Register('csref0', 8, 0x90007780),
        Register('csref1', 8, 0x90007788),
        Register('csref2', 8, 0x90007790),
        Register('csref3', 8, 0x90007798),
        Register('csref4', 8, 0x900077a0),
        Register('csref5', 8, 0x900077a8),
        Register('csref6', 8, 0x900077b0),
        Register('csref7', 8, 0x900077b8),
        Register('csref8', 8, 0x900077c0),
        Register('csref9', 8, 0x900077c8),
        Register('csrefa', 8, 0x900077d0),
        Register('csrefb', 8, 0x900077d8),
        Register('csrefc', 8, 0x900077e0),
        Register('csrefd', 8, 0x900077e8),
        Register('csrefe', 8, 0x900077f0),
        Register('csreff', 8, 0x900077f8),
        Register('csrf00', 8, 0x90007800),
        Register('csrf01', 8, 0x90007808),
        Register('csrf02', 8, 0x90007810),
        Register('csrf03', 8, 0x90007818),
        Register('csrf04', 8, 0x90007820),
        Register('csrf05', 8, 0x90007828),
        Register('csrf06', 8, 0x90007830),
        Register('csrf07', 8, 0x90007838),
        Register('csrf08', 8, 0x90007840),
        Register('csrf09', 8, 0x90007848),
        Register('csrf0a', 8, 0x90007850),
        Register('csrf0b', 8, 0x90007858),
        Register('csrf0c', 8, 0x90007860),
        Register('csrf0d', 8, 0x90007868),
        Register('csrf0e', 8, 0x90007870),
        Register('csrf0f', 8, 0x90007878),
        Register('csrf10', 8, 0x90007880),
        Register('mvendorid', 8, 0x90007888),
        Register('marchid', 8, 0x90007890),
        Register('mimpid', 8, 0x90007898),
        Register('mhartid', 8, 0x900078a0),
        Register('csrf15', 8, 0x900078a8),
        Register('csrf16', 8, 0x900078b0),
        Register('csrf17', 8, 0x900078b8),
        Register('csrf18', 8, 0x900078c0),
        Register('csrf19', 8, 0x900078c8),
        Register('csrf1a', 8, 0x900078d0),
        Register('csrf1b', 8, 0x900078d8),
        Register('csrf1c', 8, 0x900078e0),
        Register('csrf1d', 8, 0x900078e8),
        Register('csrf1e', 8, 0x900078f0),
        Register('csrf1f', 8, 0x900078f8),
        Register('csrf20', 8, 0x90007900),
        Register('csrf21', 8, 0x90007908),
        Register('csrf22', 8, 0x90007910),
        Register('csrf23', 8, 0x90007918),
        Register('csrf24', 8, 0x90007920),
        Register('csrf25', 8, 0x90007928),
        Register('csrf26', 8, 0x90007930),
        Register('csrf27', 8, 0x90007938),
        Register('csrf28', 8, 0x90007940),
        Register('csrf29', 8, 0x90007948),
        Register('csrf2a', 8, 0x90007950),
        Register('csrf2b', 8, 0x90007958),
        Register('csrf2c', 8, 0x90007960),
        Register('csrf2d', 8, 0x90007968),
        Register('csrf2e', 8, 0x90007970),
        Register('csrf2f', 8, 0x90007978),
        Register('csrf30', 8, 0x90007980),
        Register('csrf31', 8, 0x90007988),
        Register('csrf32', 8, 0x90007990),
        Register('csrf33', 8, 0x90007998),
        Register('csrf34', 8, 0x900079a0),
        Register('csrf35', 8, 0x900079a8),
        Register('csrf36', 8, 0x900079b0),
        Register('csrf37', 8, 0x900079b8),
        Register('csrf38', 8, 0x900079c0),
        Register('csrf39', 8, 0x900079c8),
        Register('csrf3a', 8, 0x900079d0),
        Register('csrf3b', 8, 0x900079d8),
        Register('csrf3c', 8, 0x900079e0),
        Register('csrf3d', 8, 0x900079e8),
        Register('csrf3e', 8, 0x900079f0),
        Register('csrf3f', 8, 0x900079f8),
        Register('csrf40', 8, 0x90007a00),
        Register('csrf41', 8, 0x90007a08),
        Register('csrf42', 8, 0x90007a10),
        Register('csrf43', 8, 0x90007a18),
        Register('csrf44', 8, 0x90007a20),
        Register('csrf45', 8, 0x90007a28),
        Register('csrf46', 8, 0x90007a30),
        Register('csrf47', 8, 0x90007a38),
        Register('csrf48', 8, 0x90007a40),
        Register('csrf49', 8, 0x90007a48),
        Register('csrf4a', 8, 0x90007a50),
        Register('csrf4b', 8, 0x90007a58),
        Register('csrf4c', 8, 0x90007a60),
        Register('csrf4d', 8, 0x90007a68),
        Register('csrf4e', 8, 0x90007a70),
        Register('csrf4f', 8, 0x90007a78),
        Register('csrf50', 8, 0x90007a80),
        Register('csrf51', 8, 0x90007a88),
        Register('csrf52', 8, 0x90007a90),
        Register('csrf53', 8, 0x90007a98),
        Register('csrf54', 8, 0x90007aa0),
        Register('csrf55', 8, 0x90007aa8),
        Register('csrf56', 8, 0x90007ab0),
        Register('csrf57', 8, 0x90007ab8),
        Register('csrf58', 8, 0x90007ac0),
        Register('csrf59', 8, 0x90007ac8),
        Register('csrf5a', 8, 0x90007ad0),
        Register('csrf5b', 8, 0x90007ad8),
        Register('csrf5c', 8, 0x90007ae0),
        Register('csrf5d', 8, 0x90007ae8),
        Register('csrf5e', 8, 0x90007af0),
        Register('csrf5f', 8, 0x90007af8),
        Register('csrf60', 8, 0x90007b00),
        Register('csrf61', 8, 0x90007b08),
        Register('csrf62', 8, 0x90007b10),
        Register('csrf63', 8, 0x90007b18),
        Register('csrf64', 8, 0x90007b20),
        Register('csrf65', 8, 0x90007b28),
        Register('csrf66', 8, 0x90007b30),
        Register('csrf67', 8, 0x90007b38),
        Register('csrf68', 8, 0x90007b40),
        Register('csrf69', 8, 0x90007b48),
        Register('csrf6a', 8, 0x90007b50),
        Register('csrf6b', 8, 0x90007b58),
        Register('csrf6c', 8, 0x90007b60),
        Register('csrf6d', 8, 0x90007b68),
        Register('csrf6e', 8, 0x90007b70),
        Register('csrf6f', 8, 0x90007b78),
        Register('csrf70', 8, 0x90007b80),
        Register('csrf71', 8, 0x90007b88),
        Register('csrf72', 8, 0x90007b90),
        Register('csrf73', 8, 0x90007b98),
        Register('csrf74', 8, 0x90007ba0),
        Register('csrf75', 8, 0x90007ba8),
        Register('csrf76', 8, 0x90007bb0),
        Register('csrf77', 8, 0x90007bb8),
        Register('csrf78', 8, 0x90007bc0),
        Register('csrf79', 8, 0x90007bc8),
        Register('csrf7a', 8, 0x90007bd0),
        Register('csrf7b', 8, 0x90007bd8),
        Register('csrf7c', 8, 0x90007be0),
        Register('csrf7d', 8, 0x90007be8),
        Register('csrf7e', 8, 0x90007bf0),
        Register('csrf7f', 8, 0x90007bf8),
        Register('csrf80', 8, 0x90007c00),
        Register('csrf81', 8, 0x90007c08),
        Register('csrf82', 8, 0x90007c10),
        Register('csrf83', 8, 0x90007c18),
        Register('csrf84', 8, 0x90007c20),
        Register('csrf85', 8, 0x90007c28),
        Register('csrf86', 8, 0x90007c30),
        Register('csrf87', 8, 0x90007c38),
        Register('csrf88', 8, 0x90007c40),
        Register('csrf89', 8, 0x90007c48),
        Register('csrf8a', 8, 0x90007c50),
        Register('csrf8b', 8, 0x90007c58),
        Register('csrf8c', 8, 0x90007c60),
        Register('csrf8d', 8, 0x90007c68),
        Register('csrf8e', 8, 0x90007c70),
        Register('csrf8f', 8, 0x90007c78),
        Register('csrf90', 8, 0x90007c80),
        Register('csrf91', 8, 0x90007c88),
        Register('csrf92', 8, 0x90007c90),
        Register('csrf93', 8, 0x90007c98),
        Register('csrf94', 8, 0x90007ca0),
        Register('csrf95', 8, 0x90007ca8),
        Register('csrf96', 8, 0x90007cb0),
        Register('csrf97', 8, 0x90007cb8),
        Register('csrf98', 8, 0x90007cc0),
        Register('csrf99', 8, 0x90007cc8),
        Register('csrf9a', 8, 0x90007cd0),
        Register('csrf9b', 8, 0x90007cd8),
        Register('csrf9c', 8, 0x90007ce0),
        Register('csrf9d', 8, 0x90007ce8),
        Register('csrf9e', 8, 0x90007cf0),
        Register('csrf9f', 8, 0x90007cf8),
        Register('csrfa0', 8, 0x90007d00),
        Register('csrfa1', 8, 0x90007d08),
        Register('csrfa2', 8, 0x90007d10),
        Register('csrfa3', 8, 0x90007d18),
        Register('csrfa4', 8, 0x90007d20),
        Register('csrfa5', 8, 0x90007d28),
        Register('csrfa6', 8, 0x90007d30),
        Register('csrfa7', 8, 0x90007d38),
        Register('csrfa8', 8, 0x90007d40),
        Register('csrfa9', 8, 0x90007d48),
        Register('csrfaa', 8, 0x90007d50),
        Register('csrfab', 8, 0x90007d58),
        Register('csrfac', 8, 0x90007d60),
        Register('csrfad', 8, 0x90007d68),
        Register('csrfae', 8, 0x90007d70),
        Register('csrfaf', 8, 0x90007d78),
        Register('csrfb0', 8, 0x90007d80),
        Register('csrfb1', 8, 0x90007d88),
        Register('csrfb2', 8, 0x90007d90),
        Register('csrfb3', 8, 0x90007d98),
        Register('csrfb4', 8, 0x90007da0),
        Register('csrfb5', 8, 0x90007da8),
        Register('csrfb6', 8, 0x90007db0),
        Register('csrfb7', 8, 0x90007db8),
        Register('csrfb8', 8, 0x90007dc0),
        Register('csrfb9', 8, 0x90007dc8),
        Register('csrfba', 8, 0x90007dd0),
        Register('csrfbb', 8, 0x90007dd8),
        Register('csrfbc', 8, 0x90007de0),
        Register('csrfbd', 8, 0x90007de8),
        Register('csrfbe', 8, 0x90007df0),
        Register('csrfbf', 8, 0x90007df8),
        Register('csrfc0', 8, 0x90007e00),
        Register('csrfc1', 8, 0x90007e08),
        Register('csrfc2', 8, 0x90007e10),
        Register('csrfc3', 8, 0x90007e18),
        Register('csrfc4', 8, 0x90007e20),
        Register('csrfc5', 8, 0x90007e28),
        Register('csrfc6', 8, 0x90007e30),
        Register('csrfc7', 8, 0x90007e38),
        Register('csrfc8', 8, 0x90007e40),
        Register('csrfc9', 8, 0x90007e48),
        Register('csrfca', 8, 0x90007e50),
        Register('csrfcb', 8, 0x90007e58),
        Register('csrfcc', 8, 0x90007e60),
        Register('csrfcd', 8, 0x90007e68),
        Register('csrfce', 8, 0x90007e70),
        Register('csrfcf', 8, 0x90007e78),
        Register('csrfd0', 8, 0x90007e80),
        Register('csrfd1', 8, 0x90007e88),
        Register('csrfd2', 8, 0x90007e90),
        Register('csrfd3', 8, 0x90007e98),
        Register('csrfd4', 8, 0x90007ea0),
        Register('csrfd5', 8, 0x90007ea8),
        Register('csrfd6', 8, 0x90007eb0),
        Register('csrfd7', 8, 0x90007eb8),
        Register('csrfd8', 8, 0x90007ec0),
        Register('csrfd9', 8, 0x90007ec8),
        Register('csrfda', 8, 0x90007ed0),
        Register('csrfdb', 8, 0x90007ed8),
        Register('csrfdc', 8, 0x90007ee0),
        Register('csrfdd', 8, 0x90007ee8),
        Register('csrfde', 8, 0x90007ef0),
        Register('csrfdf', 8, 0x90007ef8),
        Register('csrfe0', 8, 0x90007f00),
        Register('csrfe1', 8, 0x90007f08),
        Register('csrfe2', 8, 0x90007f10),
        Register('csrfe3', 8, 0x90007f18),
        Register('csrfe4', 8, 0x90007f20),
        Register('csrfe5', 8, 0x90007f28),
        Register('csrfe6', 8, 0x90007f30),
        Register('csrfe7', 8, 0x90007f38),
        Register('csrfe8', 8, 0x90007f40),
        Register('csrfe9', 8, 0x90007f48),
        Register('csrfea', 8, 0x90007f50),
        Register('csrfeb', 8, 0x90007f58),
        Register('csrfec', 8, 0x90007f60),
        Register('csrfed', 8, 0x90007f68),
        Register('csrfee', 8, 0x90007f70),
        Register('csrfef', 8, 0x90007f78),
        Register('csrff0', 8, 0x90007f80),
        Register('csrff1', 8, 0x90007f88),
        Register('csrff2', 8, 0x90007f90),
        Register('csrff3', 8, 0x90007f98),
        Register('csrff4', 8, 0x90007fa0),
        Register('csrff5', 8, 0x90007fa8),
        Register('csrff6', 8, 0x90007fb0),
        Register('csrff7', 8, 0x90007fb8),
        Register('csrff8', 8, 0x90007fc0),
        Register('csrff9', 8, 0x90007fc8),
        Register('csrffa', 8, 0x90007fd0),
        Register('csrffb', 8, 0x90007fd8),
        Register('csrffc', 8, 0x90007fe0),
        Register('csrffd', 8, 0x90007fe8),
        Register('csrffe', 8, 0x90007ff0),
        Register('csrfff', 8, 0x90007ff8)
    ]

register_arch(['riscv:le:64:rv64ic'], 64, Endness.LE, ArchPcode_RISCV_LE_64_RV64IC)
