# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("clfsw32.dll")
prototypes = \
    {
        # 
        'LsnEqual': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["plsn1", "plsn2"]),
        # 
        'LsnLess': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["plsn1", "plsn2"]),
        # 
        'LsnGreater': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["plsn1", "plsn2"]),
        # 
        'LsnNull': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["plsn"]),
        # 
        'LsnContainer': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["plsn"]),
        # 
        'LsnCreate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), arg_names=["cidContainer", "offBlock", "cRecord"]),
        # 
        'LsnBlockOffset': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["plsn"]),
        # 
        'LsnRecordSequence': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["plsn"]),
        # 
        'LsnInvalid': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["plsn"]),
        # 
        'LsnIncrement': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0)], SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), arg_names=["plsn"]),
        # 
        'CreateLogFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="FILE_ACCESS_FLAGS"), SimTypeInt(signed=False, label="FILE_SHARE_MODE"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="FILE_CREATION_DISPOSITION"), SimTypeInt(signed=False, label="FILE_FLAGS_AND_ATTRIBUTES")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszLogFileName", "fDesiredAccess", "dwShareMode", "psaLogFile", "fCreateDisposition", "fFlagsAndAttributes"]),
        # 
        'DeleteLogByHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog"]),
        # 
        'DeleteLogFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLogFileName", "pvReserved"]),
        # 
        'AddLogContainer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pcbContainer", "pwszContainerPath", "pReserved"]),
        # 
        'AddLogContainerSet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "cContainer", "pcbContainer", "rgwszContainerPath", "pReserved"]),
        # 
        'RemoveLogContainer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pwszContainerPath", "fForce", "pReserved"]),
        # 
        'RemoveLogContainerSet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "cContainer", "rgwszContainerPath", "fForce", "pReserved"]),
        # 
        'SetLogArchiveTail': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "plsnArchiveTail", "pReserved"]),
        # 
        'SetEndOfLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "plsnEnd", "lpOverlapped"]),
        # 
        'TruncateLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "plsnEnd", "lpOverlapped"]),
        # 
        'CreateLogContainerScanContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"cidNode": SimStruct({"cType": SimTypeInt(signed=False, label="UInt32"), "cbNode": SimTypeInt(signed=False, label="UInt32")}, name="CLFS_NODE_ID", pack=False, align=None), "hLog": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cIndex": SimTypeInt(signed=False, label="UInt32"), "cContainers": SimTypeInt(signed=False, label="UInt32"), "cContainersReturned": SimTypeInt(signed=False, label="UInt32"), "eScanMode": SimTypeChar(label="Byte"), "pinfoContainer": SimTypePointer(SimStruct({"FileAttributes": SimTypeInt(signed=False, label="UInt32"), "CreationTime": SimTypeLongLong(signed=False, label="UInt64"), "LastAccessTime": SimTypeLongLong(signed=False, label="UInt64"), "LastWriteTime": SimTypeLongLong(signed=False, label="UInt64"), "ContainerSize": SimTypeLongLong(signed=True, label="Int64"), "FileNameActualLength": SimTypeInt(signed=False, label="UInt32"), "FileNameLength": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "State": SimTypeInt(signed=False, label="UInt32"), "PhysicalContainerId": SimTypeInt(signed=False, label="UInt32"), "LogicalContainerId": SimTypeInt(signed=False, label="UInt32")}, name="CLS_CONTAINER_INFORMATION", pack=False, align=None), offset=0)}, name="CLS_SCAN_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "cFromContainer", "cContainers", "eScanMode", "pcxScan", "pOverlapped"]),
        # 
        'ScanLogContainers': SimTypeFunction([SimTypePointer(SimStruct({"cidNode": SimStruct({"cType": SimTypeInt(signed=False, label="UInt32"), "cbNode": SimTypeInt(signed=False, label="UInt32")}, name="CLFS_NODE_ID", pack=False, align=None), "hLog": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cIndex": SimTypeInt(signed=False, label="UInt32"), "cContainers": SimTypeInt(signed=False, label="UInt32"), "cContainersReturned": SimTypeInt(signed=False, label="UInt32"), "eScanMode": SimTypeChar(label="Byte"), "pinfoContainer": SimTypePointer(SimStruct({"FileAttributes": SimTypeInt(signed=False, label="UInt32"), "CreationTime": SimTypeLongLong(signed=False, label="UInt64"), "LastAccessTime": SimTypeLongLong(signed=False, label="UInt64"), "LastWriteTime": SimTypeLongLong(signed=False, label="UInt64"), "ContainerSize": SimTypeLongLong(signed=True, label="Int64"), "FileNameActualLength": SimTypeInt(signed=False, label="UInt32"), "FileNameLength": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "State": SimTypeInt(signed=False, label="UInt32"), "PhysicalContainerId": SimTypeInt(signed=False, label="UInt32"), "LogicalContainerId": SimTypeInt(signed=False, label="UInt32")}, name="CLS_CONTAINER_INFORMATION", pack=False, align=None), offset=0)}, name="CLS_SCAN_CONTEXT", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcxScan", "eScanMode", "pReserved"]),
        # 
        'AlignReservedLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "cReservedRecords", "rgcbReservation", "pcbAlignReservation"]),
        # 
        'AllocReservedLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "cReservedRecords", "pcbAdjustment"]),
        # 
        'FreeReservedLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "cReservedRecords", "pcbAdjustment"]),
        # 
        'GetLogFileInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"TotalAvailable": SimTypeLongLong(signed=True, label="Int64"), "CurrentAvailable": SimTypeLongLong(signed=True, label="Int64"), "TotalReservation": SimTypeLongLong(signed=True, label="Int64"), "BaseFileSize": SimTypeLongLong(signed=False, label="UInt64"), "ContainerSize": SimTypeLongLong(signed=False, label="UInt64"), "TotalContainers": SimTypeInt(signed=False, label="UInt32"), "FreeContainers": SimTypeInt(signed=False, label="UInt32"), "TotalClients": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypeInt(signed=False, label="UInt32"), "FlushThreshold": SimTypeInt(signed=False, label="UInt32"), "SectorSize": SimTypeInt(signed=False, label="UInt32"), "MinArchiveTailLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "BaseLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "LastFlushedLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "LastLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "RestartLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "Identity": SimTypeBottom(label="Guid")}, name="CLS_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pinfoBuffer", "cbBuffer"]),
        # 
        'SetLogArchiveMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CLFS_LOG_ARCHIVE_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "eMode"]),
        # 
        'ReadLogRestartArea': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "ppvRestartBuffer", "pcbRestartBuffer", "plsn", "ppvContext", "pOverlapped"]),
        # 
        'ReadPreviousLogRestartArea': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvReadContext", "ppvRestartBuffer", "pcbRestartBuffer", "plsnRestart", "pOverlapped"]),
        # 
        'WriteLogRestartArea': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLFS_FLAG"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "pvRestartBuffer", "cbRestartBuffer", "plsnBase", "fFlags", "pcbWritten", "plsnNext", "pOverlapped"]),
        # 
        'GetLogReservationInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "pcbRecordNumber", "pcbUserReservation", "pcbCommitReservation"]),
        # 
        'AdvanceLogBase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "plsnBase", "fFlags", "pOverlapped"]),
        # 
        'CloseAndResetLogFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog"]),
        # 
        'CreateLogMarshallingArea': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbBufferLength", "pvUserContext"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvBuffer", "pvUserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pfnAllocBuffer", "pfnFreeBuffer", "pvBlockAllocContext", "cbMarshallingBuffer", "cMaxWriteBuffers", "cMaxReadBuffers", "ppvMarshal"]),
        # 
        'DeleteLogMarshallingArea': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal"]),
        # 
        'ReserveAndAppendLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ByteLength": SimTypeInt(signed=False, label="UInt32")}, name="CLS_WRITE_ENTRY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypeInt(signed=False, label="CLFS_FLAG"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "rgWriteEntries", "cWriteEntries", "plsnUndoNext", "plsnPrevious", "cReserveRecords", "rgcbReservation", "fFlags", "plsn", "pOverlapped"]),
        # 
        'ReserveAndAppendLogAligned': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ByteLength": SimTypeInt(signed=False, label="UInt32")}, name="CLS_WRITE_ENTRY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypeInt(signed=False, label="CLFS_FLAG"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "rgWriteEntries", "cWriteEntries", "cbEntryAlignment", "plsnUndoNext", "plsnPrevious", "cReserveRecords", "rgcbReservation", "fFlags", "plsn", "pOverlapped"]),
        # 
        'FlushLogBuffers': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "pOverlapped"]),
        # 
        'FlushLogToLsn': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshalContext", "plsnFlush", "plsnLastFlushed", "pOverlapped"]),
        # 
        'ReadLogRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLFS_CONTEXT_MODE"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvMarshal", "plsnFirst", "eContextMode", "ppvReadBuffer", "pcbReadBuffer", "peRecordType", "plsnUndoNext", "plsnPrevious", "ppvReadContext", "pOverlapped"]),
        # 
        'ReadNextLogRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvReadContext", "ppvBuffer", "pcbBuffer", "peRecordType", "plsnUser", "plsnUndoNext", "plsnPrevious", "plsnRecord", "pOverlapped"]),
        # 
        'TerminateReadLog': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCursorContext"]),
        # 
        'PrepareLogArchive': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pszBaseLogFileName", "cLen", "plsnLow", "plsnHigh", "pcActualLength", "poffBaseLogFileData", "pcbBaseLogFileLength", "plsnBase", "plsnLast", "plsnCurrentArchiveTail", "ppvArchiveContext"]),
        # 
        'ReadLogArchiveMetadata': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArchiveContext", "cbOffset", "cbBytesToRead", "pbReadBuffer", "pcbBytesRead"]),
        # 
        'GetNextLogArchiveExtent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"coffLow": SimTypeLongLong(signed=False, label="UInt64"), "coffHigh": SimTypeLongLong(signed=False, label="UInt64"), "infoContainer": SimStruct({"FileAttributes": SimTypeInt(signed=False, label="UInt32"), "CreationTime": SimTypeLongLong(signed=False, label="UInt64"), "LastAccessTime": SimTypeLongLong(signed=False, label="UInt64"), "LastWriteTime": SimTypeLongLong(signed=False, label="UInt64"), "ContainerSize": SimTypeLongLong(signed=True, label="Int64"), "FileNameActualLength": SimTypeInt(signed=False, label="UInt32"), "FileNameLength": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "State": SimTypeInt(signed=False, label="UInt32"), "PhysicalContainerId": SimTypeInt(signed=False, label="UInt32"), "LogicalContainerId": SimTypeInt(signed=False, label="UInt32")}, name="CLS_CONTAINER_INFORMATION", pack=False, align=None)}, name="CLS_ARCHIVE_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArchiveContext", "rgadExtent", "cDescriptors", "pcDescriptorsReturned"]),
        # 
        'TerminateLogArchive': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvArchiveContext"]),
        # 
        'ValidateLog': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"TotalAvailable": SimTypeLongLong(signed=True, label="Int64"), "CurrentAvailable": SimTypeLongLong(signed=True, label="Int64"), "TotalReservation": SimTypeLongLong(signed=True, label="Int64"), "BaseFileSize": SimTypeLongLong(signed=False, label="UInt64"), "ContainerSize": SimTypeLongLong(signed=False, label="UInt64"), "TotalContainers": SimTypeInt(signed=False, label="UInt32"), "FreeContainers": SimTypeInt(signed=False, label="UInt32"), "TotalClients": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypeInt(signed=False, label="UInt32"), "FlushThreshold": SimTypeInt(signed=False, label="UInt32"), "SectorSize": SimTypeInt(signed=False, label="UInt32"), "MinArchiveTailLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "BaseLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "LastFlushedLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "LastLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "RestartLsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "Identity": SimTypeBottom(label="Guid")}, name="CLS_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLogFileName", "psaLogFile", "pinfoBuffer", "pcbBuffer"]),
        # 
        'GetLogContainerName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "cidLogicalContainer", "pwstrContainerName", "cLenContainerName", "pcActualLenContainerName"]),
        # 
        'GetLogIoStatistics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CLFS_IOSTATS_CLASS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pvStatsBuffer", "cbStatsBuffer", "eStatsClass", "pcbStatsWritten"]),
        # 
        'RegisterManageableLogClient': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CallbackContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "AdvanceTailCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hLogFile", "lsnTarget", "pvClientContext"]), offset=0), "LogFullHandlerCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hLogFile", "dwError", "fLogIsPinned", "pvClientContext"]), offset=0), "LogUnpinnedCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hLogFile", "pvClientContext"]), offset=0)}, name="LOG_MANAGEMENT_CALLBACKS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pCallbacks"]),
        # 
        'DeregisterManageableLogClient': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog"]),
        # 
        'ReadLogNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Notification": SimTypeInt(signed=False, label="CLFS_MGMT_NOTIFICATION_TYPE"), "Lsn": SimStruct({"Internal": SimTypeLongLong(signed=False, label="UInt64")}, name="CLS_LSN", pack=False, align=None), "LogIsPinned": SimTypeShort(signed=False, label="UInt16")}, name="CLFS_MGMT_NOTIFICATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pNotification", "lpOverlapped"]),
        # 
        'InstallLogPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "LengthInBytes": SimTypeInt(signed=False, label="UInt32"), "PolicyFlags": SimTypeInt(signed=False, label="UInt32"), "PolicyType": SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE"), "PolicyParameters": SimUnion({"MaximumSize": SimStruct({"Containers": SimTypeInt(signed=False, label="UInt32")}, name="_MaximumSize_e__Struct", pack=False, align=None), "MinimumSize": SimStruct({"Containers": SimTypeInt(signed=False, label="UInt32")}, name="_MinimumSize_e__Struct", pack=False, align=None), "NewContainerSize": SimStruct({"SizeInBytes": SimTypeInt(signed=False, label="UInt32")}, name="_NewContainerSize_e__Struct", pack=False, align=None), "GrowthRate": SimStruct({"AbsoluteGrowthInContainers": SimTypeInt(signed=False, label="UInt32"), "RelativeGrowthPercentage": SimTypeInt(signed=False, label="UInt32")}, name="_GrowthRate_e__Struct", pack=False, align=None), "LogTail": SimStruct({"MinimumAvailablePercentage": SimTypeInt(signed=False, label="UInt32"), "MinimumAvailableContainers": SimTypeInt(signed=False, label="UInt32")}, name="_LogTail_e__Struct", pack=False, align=None), "AutoShrink": SimStruct({"Percentage": SimTypeInt(signed=False, label="UInt32")}, name="_AutoShrink_e__Struct", pack=False, align=None), "AutoGrow": SimStruct({"Enabled": SimTypeInt(signed=False, label="UInt32")}, name="_AutoGrow_e__Struct", pack=False, align=None), "NewContainerPrefix": SimStruct({"PrefixLengthInBytes": SimTypeShort(signed=False, label="UInt16"), "PrefixString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_NewContainerPrefix_e__Struct", pack=False, align=None), "NewContainerSuffix": SimStruct({"NextContainerSuffix": SimTypeLongLong(signed=False, label="UInt64")}, name="_NewContainerSuffix_e__Struct", pack=False, align=None), "NewContainerExtension": SimStruct({"ExtensionLengthInBytes": SimTypeShort(signed=False, label="UInt16"), "ExtensionString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_NewContainerExtension_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="CLFS_MGMT_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pPolicy"]),
        # 
        'RemoveLogPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "ePolicyType"]),
        # 
        'QueryLogPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "LengthInBytes": SimTypeInt(signed=False, label="UInt32"), "PolicyFlags": SimTypeInt(signed=False, label="UInt32"), "PolicyType": SimTypeInt(signed=False, label="CLFS_MGMT_POLICY_TYPE"), "PolicyParameters": SimUnion({"MaximumSize": SimStruct({"Containers": SimTypeInt(signed=False, label="UInt32")}, name="_MaximumSize_e__Struct", pack=False, align=None), "MinimumSize": SimStruct({"Containers": SimTypeInt(signed=False, label="UInt32")}, name="_MinimumSize_e__Struct", pack=False, align=None), "NewContainerSize": SimStruct({"SizeInBytes": SimTypeInt(signed=False, label="UInt32")}, name="_NewContainerSize_e__Struct", pack=False, align=None), "GrowthRate": SimStruct({"AbsoluteGrowthInContainers": SimTypeInt(signed=False, label="UInt32"), "RelativeGrowthPercentage": SimTypeInt(signed=False, label="UInt32")}, name="_GrowthRate_e__Struct", pack=False, align=None), "LogTail": SimStruct({"MinimumAvailablePercentage": SimTypeInt(signed=False, label="UInt32"), "MinimumAvailableContainers": SimTypeInt(signed=False, label="UInt32")}, name="_LogTail_e__Struct", pack=False, align=None), "AutoShrink": SimStruct({"Percentage": SimTypeInt(signed=False, label="UInt32")}, name="_AutoShrink_e__Struct", pack=False, align=None), "AutoGrow": SimStruct({"Enabled": SimTypeInt(signed=False, label="UInt32")}, name="_AutoGrow_e__Struct", pack=False, align=None), "NewContainerPrefix": SimStruct({"PrefixLengthInBytes": SimTypeShort(signed=False, label="UInt16"), "PrefixString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_NewContainerPrefix_e__Struct", pack=False, align=None), "NewContainerSuffix": SimStruct({"NextContainerSuffix": SimTypeLongLong(signed=False, label="UInt64")}, name="_NewContainerSuffix_e__Struct", pack=False, align=None), "NewContainerExtension": SimStruct({"ExtensionLengthInBytes": SimTypeShort(signed=False, label="UInt16"), "ExtensionString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_NewContainerExtension_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="CLFS_MGMT_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "ePolicyType", "pPolicyBuffer", "pcbPolicyBuffer"]),
        # 
        'SetLogFileSizeWithPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "pDesiredSize", "pResultingSize"]),
        # 
        'HandleLogFull': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog"]),
        # 
        'LogTailAdvanceFailure': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "dwReason"]),
        # 
        'RegisterForLogWriteNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLog", "cbThreshold", "fEnable"]),
    }

lib.set_prototypes(prototypes)
