# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("clusapi.dll")
prototypes = \
    {
        # 
        'GetNodeClusterState': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszNodeName", "pdwClusterState"]),
        # 
        'OpenCluster': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["lpszClusterName"]),
        # 
        'OpenClusterEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["lpszClusterName", "DesiredAccess", "GrantedAccess"]),
        # 
        'CloseCluster': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCluster"]),
        # 
        'SetClusterName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszNewClusterName"]),
        # 
        'GetClusterInformation': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwVersionInfoSize": SimTypeInt(signed=False, label="UInt32"), "MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16"), "BuildNumber": SimTypeShort(signed=False, label="UInt16"), "szVendorId": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "szCSDVersion": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "dwClusterHighestVersion": SimTypeInt(signed=False, label="UInt32"), "dwClusterLowestVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTERVERSIONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszClusterName", "lpcchClusterName", "lpClusterInfo"]),
        # 
        'GetClusterQuorumResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszResourceName", "lpcchResourceName", "lpszDeviceName", "lpcchDeviceName", "lpdwMaxQuorumLogSize"]),
        # 
        'SetClusterQuorumResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "lpszDeviceName", "dwMaxQuoLogSize"]),
        # 
        'BackupClusterDatabase': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszPathName"]),
        # 
        'RestoreClusterDatabase': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszPathName", "bForce", "lpszQuorumDriveLetter"]),
        # 
        'SetClusterNetworkPriorityOrder': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "NetworkCount", "NetworkList"]),
        # 
        'SetClusterServiceAccountPassword': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"NodeId": SimTypeInt(signed=False, label="UInt32"), "SetAttempted": SimTypeChar(label="Byte"), "ReturnStatus": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_SET_PASSWORD_STATUS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszClusterName", "lpszNewPassword", "dwFlags", "lpReturnStatusBuffer", "lpcbReturnStatusBufferSize"]),
        # 
        'ClusterControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterUpgradeFunctionalLevel': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_UPGRADE_PHASE")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eUpgradePhase"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "perform", "pfnProgressCallback", "pvCallbackArg"]),
        # 
        'CreateClusterNotifyPortV2': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwObjectType": SimTypeInt(signed=False, label="UInt32"), "FilterFlags": SimTypeLongLong(signed=True, label="Int64")}, name="NOTIFY_FILTER_AND_TYPE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), arg_names=["hChange", "hCluster", "Filters", "dwFilterCount", "dwNotifyKey"]),
        # 
        'RegisterClusterNotifyV2': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimStruct({"dwObjectType": SimTypeInt(signed=False, label="UInt32"), "FilterFlags": SimTypeLongLong(signed=True, label="Int64")}, name="NOTIFY_FILTER_AND_TYPE", pack=False, align=None), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "Filter", "hObject", "dwNotifyKey"]),
        # 
        'GetNotifyEventHandle': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "lphTargetEvent"]),
        # 
        'GetClusterNotifyV2': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"dwObjectType": SimTypeInt(signed=False, label="UInt32"), "FilterFlags": SimTypeLongLong(signed=True, label="Int64")}, name="NOTIFY_FILTER_AND_TYPE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "lpdwNotifyKey", "pFilterAndType", "buffer", "lpbBufferSize", "lpszObjectId", "lpcchObjectId", "lpszParentId", "lpcchParentId", "lpszName", "lpcchName", "lpszType", "lpcchType", "dwMilliseconds"]),
        # 
        'CreateClusterNotifyPort': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), arg_names=["hChange", "hCluster", "dwFilter", "dwNotifyKey"]),
        # 
        'RegisterClusterNotify': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "dwFilterType", "hObject", "dwNotifyKey"]),
        # 
        'GetClusterNotify': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "lpdwNotifyKey", "lpdwFilterType", "lpszName", "lpcchName", "dwMilliseconds"]),
        # 
        'CloseClusterNotifyPort': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChange"]),
        # 
        'ClusterOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HCLUSENUM", pack=False, align=None), offset=0), arg_names=["hCluster", "dwType"]),
        # 
        'ClusterGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEnum"]),
        # 
        'ClusterEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEnum", "dwIndex", "lpdwType", "lpszName", "lpcchName"]),
        # 
        'ClusterCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEnum"]),
        # 
        'ClusterOpenEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSENUMEX", pack=False, align=None), offset=0), arg_names=["hCluster", "dwType", "pOptions"]),
        # 
        'ClusterGetEnumCountEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusterEnum"]),
        # 
        'ClusterEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUMEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "lpszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbName": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CLUSTER_ENUM_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusterEnum", "dwIndex", "pItem", "cbItem"]),
        # 
        'ClusterCloseEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusterEnum"]),
        # 
        'CreateClusterGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), arg_names=["hCluster", "groupSetName"]),
        # 
        'OpenClusterGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszGroupSetName"]),
        # 
        'CloseClusterGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroupSet"]),
        # 
        'DeleteClusterGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet"]),
        # 
        'ClusterAddGroupToGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet", "hGroup"]),
        # 
        'ClusterAddGroupToGroupSetWithDomains': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet", "hGroup", "faultDomain", "updateDomain"]),
        # 
        'ClusterRemoveGroupFromGroupSet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup"]),
        # 
        'ClusterGroupSetControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet", "hHostNode", "dwControlCode", "lpInBuffer", "cbInBufferSize", "lpOutBuffer", "cbOutBufferSize", "lpBytesReturned"]),
        # 
        'AddClusterGroupDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependentGroup", "hProviderGroup"]),
        # 
        'SetGroupDependencyExpression': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "lpszDependencyExpression"]),
        # 
        'RemoveClusterGroupDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDependsOn"]),
        # 
        'AddClusterGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependentGroupSet", "hProviderGroupSet"]),
        # 
        'SetClusterGroupSetDependencyExpression': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet", "lpszDependencyExprssion"]),
        # 
        'RemoveClusterGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSet", "hDependsOn"]),
        # 
        'AddClusterGroupToGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependentGroup", "hProviderGroupSet"]),
        # 
        'RemoveClusterGroupToGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDependsOn"]),
        # 
        'ClusterGroupSetOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUPSETENUM", pack=False, align=None), offset=0), arg_names=["hCluster"]),
        # 
        'ClusterGroupSetGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSETENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSetEnum"]),
        # 
        'ClusterGroupSetEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSETENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSetEnum", "dwIndex", "lpszName", "lpcchName"]),
        # 
        'ClusterGroupSetCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSETENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupSetEnum"]),
        # 
        'AddCrossClusterGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependentGroupSet", "lpRemoteClusterName", "lpRemoteGroupSetName"]),
        # 
        'RemoveCrossClusterGroupSetDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependentGroupSet", "lpRemoteClusterName", "lpRemoteGroupSetName"]),
        # 
        'CreateClusterAvailabilitySet': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwUpdateDomains": SimTypeInt(signed=False, label="UInt32"), "dwFaultDomains": SimTypeInt(signed=False, label="UInt32"), "bReserveSpareNode": SimTypeInt(signed=True, label="Int32")}, name="CLUSTER_AVAILABILITY_SET_CONFIG", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUPSET", pack=False, align=None), offset=0), arg_names=["hCluster", "lpAvailabilitySetName", "pAvailabilitySetConfig"]),
        # 
        'ClusterNodeReplacement': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszNodeNameCurrent", "lpszNodeNameNew"]),
        # 
        'ClusterCreateAffinityRule': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CLUS_AFFINITY_RULE_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "ruleName", "ruleType"]),
        # 
        'ClusterRemoveAffinityRule': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "ruleName"]),
        # 
        'ClusterAddGroupToAffinityRule': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "ruleName", "hGroup"]),
        # 
        'ClusterRemoveGroupFromAffinityRule': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "ruleName", "hGroup"]),
        # 
        'ClusterAffinityRuleControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "affinityRuleName", "hHostNode", "dwControlCode", "lpInBuffer", "cbInBufferSize", "lpOutBuffer", "cbOutBufferSize", "lpBytesReturned"]),
        # 
        'OpenClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNodeName"]),
        # 
        'OpenClusterNodeEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNodeName", "dwDesiredAccess", "lpdwGrantedAccess"]),
        # 
        'OpenClusterNodeById': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), arg_names=["hCluster", "nodeId"]),
        # 
        'CloseClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNode"]),
        # 
        'GetClusterNodeState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="CLUSTER_NODE_STATE"), arg_names=["hNode"]),
        # 
        'GetClusterNodeId': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode", "lpszNodeId", "lpcchName"]),
        # 
        'GetClusterFromNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["hNode"]),
        # 
        'PauseClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode"]),
        # 
        'ResumeClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode"]),
        # 
        'EvictClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode"]),
        # 
        'ClusterNetInterfaceOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HNETINTERFACEENUM", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNodeName", "lpszNetworkName"]),
        # 
        'ClusterNetInterfaceEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACEENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetInterfaceEnum", "dwIndex", "lpszName", "lpcchName"]),
        # 
        'ClusterNetInterfaceCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACEENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetInterfaceEnum"]),
        # 
        'ClusterNodeOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HNODEENUM", pack=False, align=None), offset=0), arg_names=["hNode", "dwType"]),
        # 
        'ClusterNodeOpenEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({}, name="_HNODEENUMEX", pack=False, align=None), offset=0), arg_names=["hNode", "dwType", "pOptions"]),
        # 
        'ClusterNodeGetEnumCountEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum"]),
        # 
        'ClusterNodeEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUMEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "lpszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbName": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CLUSTER_ENUM_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum", "dwIndex", "pItem", "cbItem"]),
        # 
        'ClusterNodeCloseEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum"]),
        # 
        'ClusterNodeGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum"]),
        # 
        'ClusterNodeCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum"]),
        # 
        'ClusterNodeEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODEENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNodeEnum", "dwIndex", "lpdwType", "lpszName", "lpcchName"]),
        # 
        'EvictClusterNodeEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode", "dwTimeOut", "phrCleanupStatus"]),
        # 
        'GetClusterResourceTypeKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hCluster", "lpszTypeName", "samDesired"]),
        # 
        'CreateClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszGroupName"]),
        # 
        'OpenClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszGroupName"]),
        # 
        'OpenClusterGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszGroupName", "dwDesiredAccess", "lpdwGrantedAccess"]),
        # 
        'PauseClusterNodeEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode", "bDrainNode", "dwPauseFlags", "hNodeDrainTarget"]),
        # 
        'ResumeClusterNodeEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLUSTER_NODE_RESUME_FAILBACK_TYPE"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode", "eResumeFailbackType", "dwResumeFlagsReserved"]),
        # 
        'CreateClusterGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "groupType": SimTypeInt(signed=False, label="CLUSGROUP_TYPE")}, name="CLUSTER_CREATE_GROUP_INFO", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszGroupName", "pGroupInfo"]),
        # 
        'ClusterGroupOpenEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HGROUPENUMEX", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszProperties", "cbProperties", "lpszRoProperties", "cbRoProperties", "dwFlags"]),
        # 
        'ClusterGroupGetEnumCountEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnumEx"]),
        # 
        'ClusterGroupEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUMEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "lpszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbName": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "state": SimTypeInt(signed=False, label="CLUSTER_GROUP_STATE"), "cbOwnerNode": SimTypeInt(signed=False, label="UInt32"), "lpszOwnerNode": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "cbProperties": SimTypeInt(signed=False, label="UInt32"), "pProperties": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbRoProperties": SimTypeInt(signed=False, label="UInt32"), "pRoProperties": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CLUSTER_GROUP_ENUM_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnumEx", "dwIndex", "pItem", "cbItem"]),
        # 
        'ClusterGroupCloseEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnumEx"]),
        # 
        'ClusterResourceOpenEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESENUMEX", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszProperties", "cbProperties", "lpszRoProperties", "cbRoProperties", "dwFlags"]),
        # 
        'ClusterResourceGetEnumCountEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResourceEnumEx"]),
        # 
        'ClusterResourceEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUMEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "lpszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbName": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbOwnerGroupName": SimTypeInt(signed=False, label="UInt32"), "lpszOwnerGroupName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbOwnerGroupId": SimTypeInt(signed=False, label="UInt32"), "lpszOwnerGroupId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbProperties": SimTypeInt(signed=False, label="UInt32"), "pProperties": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbRoProperties": SimTypeInt(signed=False, label="UInt32"), "pRoProperties": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CLUSTER_RESOURCE_ENUM_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResourceEnumEx", "dwIndex", "pItem", "cbItem"]),
        # 
        'ClusterResourceCloseEnumEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUMEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResourceEnumEx"]),
        # 
        'OnlineClusterGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDestinationNode", "dwOnlineFlags", "lpInBuffer", "cbInBufferSize"]),
        # 
        'OfflineClusterGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "dwOfflineFlags", "lpInBuffer", "cbInBufferSize"]),
        # 
        'OnlineClusterResourceEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "dwOnlineFlags", "lpInBuffer", "cbInBufferSize"]),
        # 
        'OfflineClusterResourceEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "dwOfflineFlags", "lpInBuffer", "cbInBufferSize"]),
        # 
        'MoveClusterGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDestinationNode", "dwMoveFlags", "lpInBuffer", "cbInBufferSize"]),
        # 
        'CancelClusterGroupOperation': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "dwCancelFlags_RESERVED"]),
        # 
        'RestartClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "dwFlags"]),
        # 
        'CloseClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup"]),
        # 
        'GetClusterFromGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["hGroup"]),
        # 
        'GetClusterGroupState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="CLUSTER_GROUP_STATE"), arg_names=["hGroup", "lpszNodeName", "lpcchNodeName"]),
        # 
        'SetClusterGroupName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "lpszGroupName"]),
        # 
        'SetClusterGroupNodeList': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "NodeCount", "NodeList"]),
        # 
        'OnlineClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDestinationNode"]),
        # 
        'MoveClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hDestinationNode"]),
        # 
        'OfflineClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup"]),
        # 
        'DeleteClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup"]),
        # 
        'DestroyClusterGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup"]),
        # 
        'ClusterGroupOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HGROUPENUM", pack=False, align=None), offset=0), arg_names=["hGroup", "dwType"]),
        # 
        'ClusterGroupGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnum"]),
        # 
        'ClusterGroupEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnum", "dwIndex", "lpdwType", "lpszResourceName", "lpcchName"]),
        # 
        'ClusterGroupCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUPENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroupEnum"]),
        # 
        'CreateClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hGroup", "lpszResourceName", "lpszResourceType", "dwFlags"]),
        # 
        'OpenClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszResourceName"]),
        # 
        'OpenClusterResourceEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszResourceName", "dwDesiredAccess", "lpdwGrantedAccess"]),
        # 
        'CloseClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hResource"]),
        # 
        'GetClusterFromResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["hResource"]),
        # 
        'DeleteClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'GetClusterResourceState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="CLUSTER_RESOURCE_STATE"), arg_names=["hResource", "lpszNodeName", "lpcchNodeName", "lpszGroupName", "lpcchGroupName"]),
        # 
        'SetClusterResourceName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "lpszResourceName"]),
        # 
        'FailClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'OnlineClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'OfflineClusterResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'ChangeClusterResourceGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hGroup"]),
        # 
        'ChangeClusterResourceGroupEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hGroup", "Flags"]),
        # 
        'AddClusterResourceNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hNode"]),
        # 
        'RemoveClusterResourceNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hNode"]),
        # 
        'AddClusterResourceDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hDependsOn"]),
        # 
        'RemoveClusterResourceDependency': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hDependsOn"]),
        # 
        'SetClusterResourceDependencyExpression': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "lpszDependencyExpression"]),
        # 
        'GetClusterResourceDependencyExpression': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "lpszDependencyExpression", "lpcchDependencyExpression"]),
        # 
        'AddResourceToClusterSharedVolumes': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'RemoveResourceFromClusterSharedVolumes': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource"]),
        # 
        'IsFileOnClusterSharedVolume': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszPathName", "pbFileIsOnSharedVolume"]),
        # 
        'ClusterSharedVolumeSetSnapshotState': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["guidSnapshotSet", "lpszVolumeName", "state"]),
        # 
        'CanResourceBeDependent': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hResource", "hResourceDependent"]),
        # 
        'ClusterResourceControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hHostNode", "dwControlCode", "lpInBuffer", "cbInBufferSize", "lpOutBuffer", "cbOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterResourceControlAsUser': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "hHostNode", "dwControlCode", "lpInBuffer", "cbInBufferSize", "lpOutBuffer", "cbOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterResourceTypeControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszResourceTypeName", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterResourceTypeControlAsUser': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszResourceTypeName", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterGroupControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'ClusterNodeControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNode", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'GetClusterResourceNetworkName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hResource", "lpBuffer", "nSize"]),
        # 
        'ClusterResourceOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESENUM", pack=False, align=None), offset=0), arg_names=["hResource", "dwType"]),
        # 
        'ClusterResourceGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResEnum"]),
        # 
        'ClusterResourceEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResEnum", "dwIndex", "lpdwType", "lpszName", "lpcchName"]),
        # 
        'ClusterResourceCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResEnum"]),
        # 
        'CreateClusterResourceType': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszResourceTypeName", "lpszDisplayName", "lpszResourceTypeDll", "dwLooksAlivePollInterval", "dwIsAlivePollInterval"]),
        # 
        'DeleteClusterResourceType': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszResourceTypeName"]),
        # 
        'ClusterResourceTypeOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESTYPEENUM", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszResourceTypeName", "dwType"]),
        # 
        'ClusterResourceTypeGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESTYPEENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResTypeEnum"]),
        # 
        'ClusterResourceTypeEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESTYPEENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResTypeEnum", "dwIndex", "lpdwType", "lpszName", "lpcchName"]),
        # 
        'ClusterResourceTypeCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESTYPEENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResTypeEnum"]),
        # 
        'OpenClusterNetwork': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNetworkName"]),
        # 
        'OpenClusterNetworkEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNetworkName", "dwDesiredAccess", "lpdwGrantedAccess"]),
        # 
        'CloseClusterNetwork': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNetwork"]),
        # 
        'GetClusterFromNetwork': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["hNetwork"]),
        # 
        'ClusterNetworkOpenEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HNETWORKENUM", pack=False, align=None), offset=0), arg_names=["hNetwork", "dwType"]),
        # 
        'ClusterNetworkGetEnumCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORKENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetworkEnum"]),
        # 
        'ClusterNetworkEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORKENUM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetworkEnum", "dwIndex", "lpdwType", "lpszName", "lpcchName"]),
        # 
        'ClusterNetworkCloseEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORKENUM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetworkEnum"]),
        # 
        'GetClusterNetworkState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="CLUSTER_NETWORK_STATE"), arg_names=["hNetwork"]),
        # 
        'SetClusterNetworkName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetwork", "lpszName"]),
        # 
        'GetClusterNetworkId': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetwork", "lpszNetworkId", "lpcchName"]),
        # 
        'ClusterNetworkControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetwork", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'OpenClusterNetInterface': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszInterfaceName"]),
        # 
        'OpenClusterNetInterfaceEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszInterfaceName", "dwDesiredAccess", "lpdwGrantedAccess"]),
        # 
        'GetClusterNetInterface': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszNodeName", "lpszNetworkName", "lpszInterfaceName", "lpcchInterfaceName"]),
        # 
        'CloseClusterNetInterface': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNetInterface"]),
        # 
        'GetClusterFromNetInterface': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["hNetInterface"]),
        # 
        'GetClusterNetInterfaceState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="CLUSTER_NETINTERFACE_STATE"), arg_names=["hNetInterface"]),
        # 
        'ClusterNetInterfaceControl': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hNetInterface", "hHostNode", "dwControlCode", "lpInBuffer", "nInBufferSize", "lpOutBuffer", "nOutBufferSize", "lpBytesReturned"]),
        # 
        'GetClusterKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hCluster", "samDesired"]),
        # 
        'GetClusterGroupKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hGroup", "samDesired"]),
        # 
        'GetClusterResourceKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hResource", "samDesired"]),
        # 
        'GetClusterNodeKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hNode", "samDesired"]),
        # 
        'GetClusterNetworkKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETWORK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hNetwork", "samDesired"]),
        # 
        'GetClusterNetInterfaceKey': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HNETINTERFACE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hNetInterface", "samDesired"]),
        # 
        'ClusterRegCreateKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpszSubKey", "dwOptions", "samDesired", "lpSecurityAttributes", "phkResult", "lpdwDisposition"]),
        # 
        'ClusterRegOpenKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpszSubKey", "samDesired", "phkResult"]),
        # 
        'ClusterRegDeleteKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpszSubKey"]),
        # 
        'ClusterRegCloseKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey"]),
        # 
        'ClusterRegEnumKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpszName", "lpcchName", "lpftLastWriteTime"]),
        # 
        'ClusterRegSetValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hKey", "lpszValueName", "dwType", "lpData", "cbData"]),
        # 
        'ClusterRegDeleteValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hKey", "lpszValueName"]),
        # 
        'ClusterRegQueryValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpszValueName", "lpdwValueType", "lpData", "lpcbData"]),
        # 
        'ClusterRegEnumValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hKey", "dwIndex", "lpszValueName", "lpcchValueName", "lpdwType", "lpData", "lpcbData"]),
        # 
        'ClusterRegQueryInfoKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpcSubKeys", "lpcchMaxSubKeyLen", "lpcValues", "lpcchMaxValueNameLen", "lpcbMaxValueLen", "lpcbSecurityDescriptor", "lpftLastWriteTime"]),
        # 
        'ClusterRegGetKeySecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "RequestedInformation", "pSecurityDescriptor", "lpcbSecurityDescriptor"]),
        # 
        'ClusterRegSetKeySecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'ClusterRegSyncDatabase': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCluster", "flags"]),
        # 
        'ClusterRegCreateBatch': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGBATCH", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pHREGBATCH"]),
        # 
        'ClusterRegBatchAddCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegBatch", "dwCommand", "wzName", "dwOptions", "lpData", "cbData"]),
        # 
        'ClusterRegCloseBatch': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCH", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegBatch", "bCommit", "failedCommandNumber"]),
        # 
        'ClusterRegCloseBatchEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegBatch", "flags", "failedCommandNumber"]),
        # 
        'ClusterRegBatchReadCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCHNOTIFICATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Command": SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "wzName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_BATCH_COMMAND", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBatchNotification", "pBatchCommand"]),
        # 
        'ClusterRegBatchCloseNotification': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCHNOTIFICATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBatchNotification"]),
        # 
        'ClusterRegCreateBatchNotifyPort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGBATCHPORT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "phBatchNotifyPort"]),
        # 
        'ClusterRegCloseBatchNotifyPort': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCHPORT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBatchNotifyPort"]),
        # 
        'ClusterRegGetBatchNotification': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGBATCHPORT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGBATCHNOTIFICATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBatchNotify", "phBatchNotification"]),
        # 
        'ClusterRegCreateReadBatch': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGREADBATCH", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "phRegReadBatch"]),
        # 
        'ClusterRegReadBatchAddCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGREADBATCH", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegReadBatch", "wzSubkeyName", "wzValueName"]),
        # 
        'ClusterRegCloseReadBatch': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGREADBATCH", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGREADBATCHREPLY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegReadBatch", "phRegReadBatchReply"]),
        # 
        'ClusterRegCloseReadBatchEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGREADBATCH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="_HREGREADBATCHREPLY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegReadBatch", "flags", "phRegReadBatchReply"]),
        # 
        'ClusterRegReadBatchReplyNextCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGREADBATCHREPLY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Command": SimTypeInt(signed=False, label="CLUSTER_REG_COMMAND"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "wzSubkeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wzValueName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_READ_BATCH_COMMAND", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegReadBatchReply", "pBatchCommand"]),
        # 
        'ClusterRegCloseReadBatchReply': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HREGREADBATCHREPLY", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegReadBatchReply"]),
        # 
        'ClusterSetAccountAccess': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "szAccountSID", "dwAccess", "dwControlType"]),
        # 
        'CreateCluster': SimTypeFunction([SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszClusterName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cNodes": SimTypeInt(signed=False, label="UInt32"), "ppszNodeNames": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "cIpEntries": SimTypeInt(signed=False, label="UInt32"), "pIpEntries": SimTypePointer(SimStruct({"lpszIpAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_IP_ENTRY", pack=False, align=None), offset=0), "fEmptyCluster": SimTypeChar(label="Byte"), "managementPointType": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_TYPE"), "managementPointResType": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE")}, name="CREATE_CLUSTER_CONFIG", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eSetupPhase", "ePhaseType", "ePhaseSeverity", "dwPercentComplete", "lpszObjectName", "dwStatus"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), arg_names=["pConfig", "pfnProgressCallback", "pvCallbackArg"]),
        # 
        'CreateClusterNameAccount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszClusterName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pszUserName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDomain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "managementPointType": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_TYPE"), "managementPointResType": SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE"), "bUpgradeVCOs": SimTypeChar(label="Byte")}, name="CREATE_CLUSTER_NAME_ACCOUNT", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eSetupPhase", "ePhaseType", "ePhaseSeverity", "dwPercentComplete", "lpszObjectName", "dwStatus"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "pConfig", "pfnProgressCallback", "pvCallbackArg"]),
        # 
        'RemoveClusterNameAccount': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "bDeleteComputerObjects"]),
        # 
        'DetermineCNOResTypeFromNodelist': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["cNodes", "ppszNodeNames", "pCNOResType"]),
        # 
        'DetermineCNOResTypeFromCluster': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CLUSTER_MGMT_POINT_RESTYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "pCNOResType"]),
        # 
        'DetermineClusterCloudTypeFromNodelist': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CLUSTER_CLOUD_TYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["cNodes", "ppszNodeNames", "pCloudType"]),
        # 
        'DetermineClusterCloudTypeFromCluster': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CLUSTER_CLOUD_TYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "pCloudType"]),
        # 
        'GetNodeCloudTypeDW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppszNodeName", "NodeCloudType"]),
        # 
        'RegisterClusterResourceTypeNotifyV2': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCHANGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hChange", "hCluster", "Flags", "resTypeName", "dwNotifyKey"]),
        # 
        'AddClusterNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eSetupPhase", "ePhaseType", "ePhaseSeverity", "dwPercentComplete", "lpszObjectName", "dwStatus"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), arg_names=["hCluster", "lpszNodeName", "pfnProgressCallback", "pvCallbackArg"]),
        # 
        'AddClusterStorageNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eSetupPhase", "ePhaseType", "ePhaseSeverity", "dwPercentComplete", "lpszObjectName", "dwStatus"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszNodeName", "pfnProgressCallback", "pvCallbackArg", "lpszClusterStorageNodeDescription", "lpszClusterStorageNodeLocation"]),
        # 
        'RemoveClusterStorageNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "lpszClusterStorageEnclosureName", "dwTimeout", "dwFlags"]),
        # 
        'DestroyCluster': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_TYPE"), SimTypeInt(signed=False, label="CLUSTER_SETUP_PHASE_SEVERITY"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackArg", "eSetupPhase", "ePhaseType", "ePhaseSeverity", "dwPercentComplete", "lpszObjectName", "dwStatus"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "pfnProgressCallback", "pvCallbackArg", "fdeleteVirtualComputerObjects"]),
    }

lib.set_prototypes(prototypes)
