# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("cryptxml.dll")
prototypes = \
    {
        # 
        'CryptXmlClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml"]),
        # 
        'CryptXmlGetTransforms': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cTransformInfo": SimTypeInt(signed=False, label="UInt32"), "rgpTransformInfo": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS"), "pfnCreateTransform": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_XML_ALGORITHM"), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTransform", "pProviderIn", "pProviderOut"]), offset=0)}, name="CRYPT_XML_TRANSFORM_INFO", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_TRANSFORM_CHAIN_CONFIG", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppConfig"]),
        # 
        'CryptXmlOpenToEncode': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cTransformInfo": SimTypeInt(signed=False, label="UInt32"), "rgpTransformInfo": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS"), "pfnCreateTransform": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_XML_ALGORITHM"), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTransform", "pProviderIn", "pProviderOut"]), offset=0)}, name="CRYPT_XML_TRANSFORM_INFO", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_TRANSFORM_CHAIN_CONFIG", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwPropId": SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID"), "pvValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbValue": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_XML_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pConfig", "dwFlags", "wszId", "rgProperty", "cProperty", "pEncoded", "phSignature"]),
        # 
        'CryptXmlOpenToDecode': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cTransformInfo": SimTypeInt(signed=False, label="UInt32"), "rgpTransformInfo": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS"), "pfnCreateTransform": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_XML_ALGORITHM"), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTransform", "pProviderIn", "pProviderOut"]), offset=0)}, name="CRYPT_XML_TRANSFORM_INFO", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_TRANSFORM_CHAIN_CONFIG", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"), SimTypePointer(SimStruct({"dwPropId": SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID"), "pvValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbValue": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_XML_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pConfig", "dwFlags", "rgProperty", "cProperty", "pEncoded", "phCryptXml"]),
        # 
        'CryptXmlAddObject': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwPropId": SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID"), "pvValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbValue": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_XML_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hObject": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszMimeType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszEncoding": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Manifest": SimStruct({"cReference": SimTypeInt(signed=False, label="UInt32"), "rgpReference": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_REFERENCES", pack=False, align=None), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_OBJECT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSignatureOrObject", "dwFlags", "rgProperty", "cProperty", "pEncoded", "ppObject"]),
        # 
        'CryptXmlCreateReference': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "dwFlags", "wszId", "wszURI", "wszType", "pDigestMethod", "cTransform", "rgTransform", "phReference"]),
        # 
        'CryptXmlDigestReference': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReference", "dwFlags", "pDataProviderIn"]),
        # 
        'CryptXmlSetHMACSecret': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSignature", "pbSecret", "cbSecret"]),
        # 
        'CryptXmlSign': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CERT_KEY_SPEC"), SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"), SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_SPEC"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSignature", "hKey", "dwKeySpec", "dwFlags", "dwKeyInfoSpec", "pvKeyInfoSpec", "pSignatureMethod", "pCanonicalization"]),
        # 
        'CryptXmlImportPublicKey': SimTypeFunction([SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_KEY_VALUE_TYPE"), "Anonymous": SimUnion({"DSAKeyValue": SimStruct({"P": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Q": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "G": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "J": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Seed": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Counter": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_DSA_KEY_VALUE", pack=False, align=None), "RSAKeyValue": SimStruct({"Modulus": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Exponent": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_RSA_KEY_VALUE", pack=False, align=None), "ECDSAKeyValue": SimStruct({"wszNamedCurve": SimTypePointer(SimTypeChar(label="Char"), offset=0), "X": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "ExplicitPara": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_ECDSA_KEY_VALUE", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_KEY_VALUE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "pKeyValue", "phKey"]),
        # 
        'CryptXmlVerifySignature': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_XML_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSignature", "hKey", "dwFlags"]),
        # 
        'CryptXmlGetDocContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hDocCtxt": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pTransformsConfig": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "cTransformInfo": SimTypeInt(signed=False, label="UInt32"), "rgpTransformInfo": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_XML_TRANSFORM_FLAGS"), "pfnCreateTransform": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_XML_ALGORITHM"), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pvCallbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbBufferSize": SimTypeInt(signed=False, label="UInt32"), "pfnRead": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData", "pcbRead"]), offset=0), "pfnClose": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState"]), offset=0)}, name="CRYPT_XML_DATA_PROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTransform", "pProviderIn", "pProviderOut"]), offset=0)}, name="CRYPT_XML_TRANSFORM_INFO", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_TRANSFORM_CHAIN_CONFIG", pack=False, align=None), offset=0), "cSignature": SimTypeInt(signed=False, label="UInt32"), "rgpSignature": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hSignature": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SignedInfo": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Canonicalization": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "SignatureMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "cReference": SimTypeInt(signed=False, label="UInt32"), "rgpReference": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_SIGNED_INFO", pack=False, align=None), "SignatureValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "pKeyInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cKeyInfo": SimTypeInt(signed=False, label="UInt32"), "rgKeyInfo": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_TYPE"), "Anonymous": SimUnion({"wszKeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyValue": SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_KEY_VALUE_TYPE"), "Anonymous": SimUnion({"DSAKeyValue": SimStruct({"P": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Q": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "G": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "J": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Seed": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Counter": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_DSA_KEY_VALUE", pack=False, align=None), "RSAKeyValue": SimStruct({"Modulus": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Exponent": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_RSA_KEY_VALUE", pack=False, align=None), "ECDSAKeyValue": SimStruct({"wszNamedCurve": SimTypePointer(SimTypeChar(label="Char"), offset=0), "X": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "ExplicitPara": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_ECDSA_KEY_VALUE", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_KEY_VALUE", pack=False, align=None), "RetrievalMethod": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None), "X509Data": SimStruct({"cX509Data": SimTypeInt(signed=False, label="UInt32"), "rgX509Data": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_X509DATA_TYPE"), "Anonymous": SimUnion({"IssuerSerial": SimStruct({"wszIssuer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszSerial": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_XML_ISSUER_SERIAL", pack=False, align=None), "SKI": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "wszSubjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Certificate": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "CRL": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_X509DATA_ITEM", pack=False, align=None), offset=0)}, name="CRYPT_XML_X509DATA", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_KEY_INFO_ITEM", pack=False, align=None), offset=0), "hVerifyKey": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPT_XML_KEY_INFO", pack=False, align=None), offset=0), "cObject": SimTypeInt(signed=False, label="UInt32"), "rgpObject": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hObject": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszMimeType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszEncoding": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Manifest": SimStruct({"cReference": SimTypeInt(signed=False, label="UInt32"), "rgpReference": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_REFERENCES", pack=False, align=None), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_OBJECT", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_SIGNATURE", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_DOC_CTXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "ppStruct"]),
        # 
        'CryptXmlGetSignature': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hSignature": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SignedInfo": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Canonicalization": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "SignatureMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "cReference": SimTypeInt(signed=False, label="UInt32"), "rgpReference": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_SIGNED_INFO", pack=False, align=None), "SignatureValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "pKeyInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cKeyInfo": SimTypeInt(signed=False, label="UInt32"), "rgKeyInfo": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_KEYINFO_TYPE"), "Anonymous": SimUnion({"wszKeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyValue": SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_KEY_VALUE_TYPE"), "Anonymous": SimUnion({"DSAKeyValue": SimStruct({"P": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Q": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "G": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "J": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Seed": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Counter": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_DSA_KEY_VALUE", pack=False, align=None), "RSAKeyValue": SimStruct({"Modulus": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Exponent": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_RSA_KEY_VALUE", pack=False, align=None), "ECDSAKeyValue": SimStruct({"wszNamedCurve": SimTypePointer(SimTypeChar(label="Char"), offset=0), "X": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Y": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "ExplicitPara": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_KEY_ECDSA_KEY_VALUE", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_KEY_VALUE", pack=False, align=None), "RetrievalMethod": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None), "X509Data": SimStruct({"cX509Data": SimTypeInt(signed=False, label="UInt32"), "rgX509Data": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CRYPT_XML_X509DATA_TYPE"), "Anonymous": SimUnion({"IssuerSerial": SimStruct({"wszIssuer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszSerial": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_XML_ISSUER_SERIAL", pack=False, align=None), "SKI": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "wszSubjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Certificate": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "CRL": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_DATA_BLOB", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_X509DATA_ITEM", pack=False, align=None), offset=0)}, name="CRYPT_XML_X509DATA", pack=False, align=None), "Custom": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="<anon>", label="None")}, name="CRYPT_XML_KEY_INFO_ITEM", pack=False, align=None), offset=0), "hVerifyKey": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPT_XML_KEY_INFO", pack=False, align=None), offset=0), "cObject": SimTypeInt(signed=False, label="UInt32"), "rgpObject": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hObject": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszMimeType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszEncoding": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Manifest": SimStruct({"cReference": SimTypeInt(signed=False, label="UInt32"), "rgpReference": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_REFERENCES", pack=False, align=None), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_OBJECT", pack=False, align=None), offset=0), offset=0)}, name="CRYPT_XML_SIGNATURE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "ppStruct"]),
        # 
        'CryptXmlGetReference': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hReference": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "wszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DigestMethod": SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), "DigestValue": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cTransform": SimTypeInt(signed=False, label="UInt32"), "rgTransform": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0)}, name="CRYPT_XML_REFERENCE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "ppStruct"]),
        # 
        'CryptXmlGetStatus': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwErrorStatus": SimTypeInt(signed=False, label="CRYPT_XML_STATUS_ERROR_STATUS"), "dwInfoStatus": SimTypeInt(signed=False, label="CRYPT_XML_STATUS_INFO_STATUS")}, name="CRYPT_XML_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "pStatus"]),
        # 
        'CryptXmlEncode': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), SimTypePointer(SimStruct({"dwPropId": SimTypeInt(signed=False, label="CRYPT_XML_PROPERTY_ID"), "pvValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbValue": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_XML_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackState", "pbData", "cbData"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCryptXml", "dwCharset", "rgProperty", "cProperty", "pvCallbackState", "pfnWrite"]),
        # 
        'CryptXmlGetAlgorithmInfo': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithm": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Encoded": SimStruct({"dwCharset": SimTypeInt(signed=False, label="CRYPT_XML_CHARSET"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_XML_BLOB", pack=False, align=None)}, name="CRYPT_XML_ALGORITHM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CRYPT_XML_FLAGS"), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithmURI": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="CRYPT_XML_GROUP_ID"), "wszCNGAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszCNGExtraAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwSignFlags": SimTypeInt(signed=False, label="UInt32"), "dwVerifyFlags": SimTypeInt(signed=False, label="UInt32"), "pvPaddingInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvExtraInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_XML_ALGORITHM_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pXmlAlgorithm", "dwFlags", "ppAlgInfo"]),
        # 
        'CryptXmlFindAlgorithmInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithmURI": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="CRYPT_XML_GROUP_ID"), "wszCNGAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszCNGExtraAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwSignFlags": SimTypeInt(signed=False, label="UInt32"), "dwVerifyFlags": SimTypeInt(signed=False, label="UInt32"), "pvPaddingInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvExtraInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_XML_ALGORITHM_INFO", pack=False, align=None), offset=0), arg_names=["dwFindByType", "pvFindBy", "dwGroupId", "dwFlags"]),
        # 
        'CryptXmlEnumAlgorithmInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "wszAlgorithmURI": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwGroupId": SimTypeInt(signed=False, label="CRYPT_XML_GROUP_ID"), "wszCNGAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wszCNGExtraAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwSignFlags": SimTypeInt(signed=False, label="UInt32"), "dwVerifyFlags": SimTypeInt(signed=False, label="UInt32"), "pvPaddingInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvExtraInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_XML_ALGORITHM_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInfo", "pvArg"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwGroupId", "dwFlags", "pvArg", "pfnEnumAlgInfo"]),
    }

lib.set_prototypes(prototypes)
