# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("d3d10.dll")
prototypes = \
    {
        # 
        'D3D10CreateDevice': SimTypeFunction([SimTypeBottom(label="IDXGIAdapter"), SimTypeInt(signed=False, label="D3D10_DRIVER_TYPE"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="ID3D10Device"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAdapter", "DriverType", "Software", "Flags", "SDKVersion", "ppDevice"]),
        # 
        'D3D10CreateDeviceAndSwapChain': SimTypeFunction([SimTypeBottom(label="IDXGIAdapter"), SimTypeInt(signed=False, label="D3D10_DRIVER_TYPE"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"BufferDesc": SimStruct({"Width": SimTypeInt(signed=False, label="UInt32"), "Height": SimTypeInt(signed=False, label="UInt32"), "RefreshRate": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="DXGI_RATIONAL", pack=False, align=None), "Format": SimTypeInt(signed=False, label="DXGI_FORMAT"), "ScanlineOrdering": SimTypeInt(signed=False, label="DXGI_MODE_SCANLINE_ORDER"), "Scaling": SimTypeInt(signed=False, label="DXGI_MODE_SCALING")}, name="DXGI_MODE_DESC", pack=False, align=None), "SampleDesc": SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Quality": SimTypeInt(signed=False, label="UInt32")}, name="DXGI_SAMPLE_DESC", pack=False, align=None), "BufferUsage": SimTypeInt(signed=False, label="UInt32"), "BufferCount": SimTypeInt(signed=False, label="UInt32"), "OutputWindow": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Windowed": SimTypeInt(signed=True, label="Int32"), "SwapEffect": SimTypeInt(signed=False, label="DXGI_SWAP_EFFECT"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="DXGI_SWAP_CHAIN_DESC", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IDXGISwapChain"), offset=0), SimTypePointer(SimTypeBottom(label="ID3D10Device"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAdapter", "DriverType", "Software", "Flags", "SDKVersion", "pSwapChainDesc", "ppSwapChain", "ppDevice"]),
        # 
        'D3D10CreateBlob': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["NumBytes", "ppBuffer"]),
        # 
        'D3D10CompileShader': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Definition": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="D3D_SHADER_MACRO", pack=False, align=None), offset=0), SimTypeBottom(label="ID3DInclude"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSrcData", "SrcDataSize", "pFileName", "pDefines", "pInclude", "pFunctionName", "pProfile", "Flags", "ppShader", "ppErrorMsgs"]),
        # 
        'D3D10DisassembleShader': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShader", "BytecodeLength", "EnableColorCode", "pComments", "ppDisassembly"]),
        # 
        'D3D10GetPixelShaderProfile': SimTypeFunction([SimTypeBottom(label="ID3D10Device")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pDevice"]),
        # 
        'D3D10GetVertexShaderProfile': SimTypeFunction([SimTypeBottom(label="ID3D10Device")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pDevice"]),
        # 
        'D3D10GetGeometryShaderProfile': SimTypeFunction([SimTypeBottom(label="ID3D10Device")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pDevice"]),
        # 
        'D3D10ReflectShader': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3D10ShaderReflection"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShaderBytecode", "BytecodeLength", "ppReflector"]),
        # 
        'D3D10PreprocessShader': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Definition": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="D3D_SHADER_MACRO", pack=False, align=None), offset=0), SimTypeBottom(label="ID3DInclude"), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSrcData", "SrcDataSize", "pFileName", "pDefines", "pInclude", "ppShaderText", "ppErrorMsgs"]),
        # 
        'D3D10GetInputSignatureBlob': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShaderBytecode", "BytecodeLength", "ppSignatureBlob"]),
        # 
        'D3D10GetOutputSignatureBlob': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShaderBytecode", "BytecodeLength", "ppSignatureBlob"]),
        # 
        'D3D10GetInputAndOutputSignatureBlob': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShaderBytecode", "BytecodeLength", "ppSignatureBlob"]),
        # 
        'D3D10GetShaderDebugInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pShaderBytecode", "BytecodeLength", "ppDebugInfo"]),
        # 
        'D3D10StateBlockMaskUnion': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pA", "pB", "pResult"]),
        # 
        'D3D10StateBlockMaskIntersect': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pA", "pB", "pResult"]),
        # 
        'D3D10StateBlockMaskDifference': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pA", "pB", "pResult"]),
        # 
        'D3D10StateBlockMaskEnableCapture': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="D3D10_DEVICE_STATE_TYPES"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMask", "StateType", "RangeStart", "RangeLength"]),
        # 
        'D3D10StateBlockMaskDisableCapture': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="D3D10_DEVICE_STATE_TYPES"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMask", "StateType", "RangeStart", "RangeLength"]),
        # 
        'D3D10StateBlockMaskEnableAll': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMask"]),
        # 
        'D3D10StateBlockMaskDisableAll': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMask"]),
        # 
        'D3D10StateBlockMaskGetSetting': SimTypeFunction([SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="D3D10_DEVICE_STATE_TYPES"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMask", "StateType", "Entry"]),
        # 
        'D3D10CreateStateBlock': SimTypeFunction([SimTypeBottom(label="ID3D10Device"), SimTypePointer(SimStruct({"VS": SimTypeChar(label="Byte"), "VSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "VSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "VSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GS": SimTypeChar(label="Byte"), "GSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "GSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "GSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PS": SimTypeChar(label="Byte"), "PSSamplers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "PSShaderResources": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "PSConstantBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAVertexBuffers": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "IAIndexBuffer": SimTypeChar(label="Byte"), "IAInputLayout": SimTypeChar(label="Byte"), "IAPrimitiveTopology": SimTypeChar(label="Byte"), "OMRenderTargets": SimTypeChar(label="Byte"), "OMDepthStencilState": SimTypeChar(label="Byte"), "OMBlendState": SimTypeChar(label="Byte"), "RSViewports": SimTypeChar(label="Byte"), "RSScissorRects": SimTypeChar(label="Byte"), "RSRasterizerState": SimTypeChar(label="Byte"), "SOBuffers": SimTypeChar(label="Byte"), "Predication": SimTypeChar(label="Byte")}, name="D3D10_STATE_BLOCK_MASK", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="ID3D10StateBlock"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDevice", "pStateBlockMask", "ppStateBlock"]),
        # 
        'D3D10CompileEffectFromMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Definition": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="D3D_SHADER_MACRO", pack=False, align=None), offset=0), SimTypeBottom(label="ID3DInclude"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pData", "DataLength", "pSrcFileName", "pDefines", "pInclude", "HLSLFlags", "FXFlags", "ppCompiledEffect", "ppErrors"]),
        # 
        'D3D10CreateEffectFromMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="ID3D10Device"), SimTypeBottom(label="ID3D10EffectPool"), SimTypePointer(SimTypeBottom(label="ID3D10Effect"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pData", "DataLength", "FXFlags", "pDevice", "pEffectPool", "ppEffect"]),
        # 
        'D3D10CreateEffectPoolFromMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="ID3D10Device"), SimTypePointer(SimTypeBottom(label="ID3D10EffectPool"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pData", "DataLength", "FXFlags", "pDevice", "ppEffectPool"]),
        # 
        'D3D10DisassembleEffect': SimTypeFunction([SimTypeBottom(label="ID3D10Effect"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pEffect", "EnableColorCode", "ppDisassembly"]),
    }

lib.set_prototypes(prototypes)
