# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("esent.dll")
prototypes = \
    {
        # 
        'JetInit': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance"]),
        # 
        'JetInit2': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "grbit"]),
        # 
        'JetInit3A': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "rgrstmap": SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="JET_RSTMAP_A", pack=False, align=None), offset=0), "crstmap": SimTypeInt(signed=True, label="Int32"), "lgposStop": SimStruct({"ib": SimTypeShort(signed=False, label="UInt16"), "isec": SimTypeShort(signed=False, label="UInt16"), "lGeneration": SimTypeInt(signed=True, label="Int32")}, name="JET_LGPOS", pack=False, align=None), "logtimeStop": SimStruct({"bSeconds": SimTypeBottom(label="CHAR"), "bMinutes": SimTypeBottom(label="CHAR"), "bHours": SimTypeBottom(label="CHAR"), "bDay": SimTypeBottom(label="CHAR"), "bMonth": SimTypeBottom(label="CHAR"), "bYear": SimTypeBottom(label="CHAR"), "Anonymous1": SimUnion({"bFiller1": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"bFiller2": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="JET_LOGTIME", pack=False, align=None), "pfnStatus": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)}, name="JET_RSTINFO_A", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "prstInfo", "grbit"]),
        # 
        'JetInit3W': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "rgrstmap": SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="JET_RSTMAP_W", pack=False, align=None), offset=0), "crstmap": SimTypeInt(signed=True, label="Int32"), "lgposStop": SimStruct({"ib": SimTypeShort(signed=False, label="UInt16"), "isec": SimTypeShort(signed=False, label="UInt16"), "lGeneration": SimTypeInt(signed=True, label="Int32")}, name="JET_LGPOS", pack=False, align=None), "logtimeStop": SimStruct({"bSeconds": SimTypeBottom(label="CHAR"), "bMinutes": SimTypeBottom(label="CHAR"), "bHours": SimTypeBottom(label="CHAR"), "bDay": SimTypeBottom(label="CHAR"), "bMonth": SimTypeBottom(label="CHAR"), "bYear": SimTypeBottom(label="CHAR"), "Anonymous1": SimUnion({"bFiller1": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"bFiller2": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="JET_LOGTIME", pack=False, align=None), "pfnStatus": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)}, name="JET_RSTINFO_W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "prstInfo", "grbit"]),
        # 
        'JetCreateInstanceA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "szInstanceName"]),
        # 
        'JetCreateInstanceW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "szInstanceName"]),
        # 
        'JetCreateInstance2A': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "szInstanceName", "szDisplayName", "grbit"]),
        # 
        'JetCreateInstance2W': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "szInstanceName", "szDisplayName", "grbit"]),
        # 
        'JetGetInstanceMiscInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetTerm': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance"]),
        # 
        'JetTerm2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "grbit"]),
        # 
        'JetStopService': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'JetStopServiceInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance"]),
        # 
        'JetStopServiceInstance2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "grbit"]),
        # 
        'JetStopBackup': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'JetStopBackupInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance"]),
        # 
        'JetSetSystemParameterA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "sesid", "paramid", "lParam", "szParam"]),
        # 
        'JetSetSystemParameterW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pinstance", "sesid", "paramid", "lParam", "szParam"]),
        # 
        'JetGetSystemParameterA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "sesid", "paramid", "plParam", "szParam", "cbMax"]),
        # 
        'JetGetSystemParameterW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "sesid", "paramid", "plParam", "szParam", "cbMax"]),
        # 
        'JetEnableMultiInstanceA': SimTypeFunction([SimTypePointer(SimStruct({"paramid": SimTypeInt(signed=False, label="UInt32"), "lParam": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sz": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_SETSYSPARAM_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psetsysparam", "csetsysparam", "pcsetsucceed"]),
        # 
        'JetEnableMultiInstanceW': SimTypeFunction([SimTypePointer(SimStruct({"paramid": SimTypeInt(signed=False, label="UInt32"), "lParam": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sz": SimTypePointer(SimTypeChar(label="Char"), offset=0), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_SETSYSPARAM_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psetsysparam", "csetsysparam", "pcsetsucceed"]),
        # 
        'JetGetThreadStats': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvResult", "cbMax"]),
        # 
        'JetBeginSessionA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "psesid", "szUserName", "szPassword"]),
        # 
        'JetBeginSessionW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "psesid", "szUserName", "szPassword"]),
        # 
        'JetDupSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "psesid"]),
        # 
        'JetEndSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit"]),
        # 
        'JetGetVersion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "pwVersion"]),
        # 
        'JetIdle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit"]),
        # 
        'JetCreateDatabaseA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "szConnect", "pdbid", "grbit"]),
        # 
        'JetCreateDatabaseW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "szConnect", "pdbid", "grbit"]),
        # 
        'JetCreateDatabase2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "cpgDatabaseSizeMax", "pdbid", "grbit"]),
        # 
        'JetCreateDatabase2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "cpgDatabaseSizeMax", "pdbid", "grbit"]),
        # 
        'JetAttachDatabaseA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "grbit"]),
        # 
        'JetAttachDatabaseW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "grbit"]),
        # 
        'JetAttachDatabase2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "cpgDatabaseSizeMax", "grbit"]),
        # 
        'JetAttachDatabase2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "cpgDatabaseSizeMax", "grbit"]),
        # 
        'JetDetachDatabaseA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename"]),
        # 
        'JetDetachDatabaseW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename"]),
        # 
        'JetDetachDatabase2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "grbit"]),
        # 
        'JetDetachDatabase2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "grbit"]),
        # 
        'JetGetObjectInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "objtyp", "szContainerName", "szObjectName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetObjectInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "objtyp", "szContainerName", "szObjectName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetTableInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetTableInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetCreateTableA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "lPages", "lDensity", "ptableid"]),
        # 
        'JetCreateTableW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "lPages", "lDensity", "ptableid"]),
        # 
        'JetCreateTableColumnIndexA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_A", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_A", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE_A", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_W", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_W", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE_W", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_A", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_A", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE2_A", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_W", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_W", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE2_W", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex3A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_A", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE2_A", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pSeqSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "pLVSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "cbSeparateLV": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE3_A", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex3W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_W", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE2_W", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pSeqSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "pLVSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "cbSeparateLV": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE3_W", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex4A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_A", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"szLocaleName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX2", pack=False, align=None), offset=0), "Anonymous": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE3_A", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pSeqSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "pLVSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "cbSeparateLV": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE4_A", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetCreateTableColumnIndex4W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szTemplateTableName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPages": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "rgcolumncreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "coltyp": SimTypeInt(signed=False, label="UInt32"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pvDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDefault": SimTypeInt(signed=False, label="UInt32"), "cp": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_COLUMNCREATE_W", pack=False, align=None), offset=0), "cColumns": SimTypeInt(signed=False, label="UInt32"), "rgindexcreate": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"szLocaleName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX2", pack=False, align=None), offset=0), "Anonymous": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE3_W", pack=False, align=None), offset=0), "cIndexes": SimTypeInt(signed=False, label="UInt32"), "szCallback": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbtyp": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "pSeqSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "pLVSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0), "cbSeparateLV": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cCreated": SimTypeInt(signed=False, label="UInt32")}, name="JET_TABLECREATE4_W", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "ptablecreate"]),
        # 
        'JetDeleteTableA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName"]),
        # 
        'JetDeleteTableW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName"]),
        # 
        'JetRenameTableA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szName", "szNameNew"]),
        # 
        'JetRenameTableW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szName", "szNameNew"]),
        # 
        'JetGetTableColumnInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetTableColumnInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetColumnInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pColumnNameOrId", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetColumnInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pwColumnNameOrId", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetAddColumnA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "pcolumndef", "pvDefault", "cbDefault", "pcolumnid"]),
        # 
        'JetAddColumnW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "pcolumndef", "pvDefault", "cbDefault", "pcolumnid"]),
        # 
        'JetDeleteColumnA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName"]),
        # 
        'JetDeleteColumnW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName"]),
        # 
        'JetDeleteColumn2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "grbit"]),
        # 
        'JetDeleteColumn2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szColumnName", "grbit"]),
        # 
        'JetRenameColumnA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szName", "szNameNew", "grbit"]),
        # 
        'JetRenameColumnW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szName", "szNameNew", "grbit"]),
        # 
        'JetSetColumnDefaultValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "szColumnName", "pvData", "cbData", "grbit"]),
        # 
        'JetSetColumnDefaultValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "szColumnName", "pvData", "cbData", "grbit"]),
        # 
        'JetGetTableIndexInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "pvResult", "cbResult", "InfoLevel"]),
        # 
        'JetGetTableIndexInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "pvResult", "cbResult", "InfoLevel"]),
        # 
        'JetGetIndexInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "szIndexName", "pvResult", "cbResult", "InfoLevel"]),
        # 
        'JetGetIndexInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "szIndexName", "pvResult", "cbResult", "InfoLevel"]),
        # 
        'JetCreateIndexA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit", "szKey", "cbKey", "lDensity"]),
        # 
        'JetCreateIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit", "szKey", "cbKey", "lDensity"]),
        # 
        'JetCreateIndex2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetCreateIndex2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXCREATE_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetCreateIndex3A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE2_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetCreateIndex3W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"lcid": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE2_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetCreateIndex4A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"szLocaleName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX2", pack=False, align=None), offset=0), "Anonymous": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_A", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE3_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetCreateIndex4W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szIndexName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szKey": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbKey": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulDensity": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"szLocaleName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX2", pack=False, align=None), offset=0), "Anonymous": SimUnion({"cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "ptuplelimits": SimTypePointer(SimStruct({"chLengthMin": SimTypeInt(signed=False, label="UInt32"), "chLengthMax": SimTypeInt(signed=False, label="UInt32"), "chToIndexMax": SimTypeInt(signed=False, label="UInt32"), "cchIncrement": SimTypeInt(signed=False, label="UInt32"), "ichStart": SimTypeInt(signed=False, label="UInt32")}, name="JET_TUPLELIMITS", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "rgconditionalcolumn": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "szColumnName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_CONDITIONALCOLUMN_W", pack=False, align=None), offset=0), "cConditionalColumn": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "pSpacehints": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ulInitialDensity": SimTypeInt(signed=False, label="UInt32"), "cbInitial": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ulMaintDensity": SimTypeInt(signed=False, label="UInt32"), "ulGrowth": SimTypeInt(signed=False, label="UInt32"), "cbMinExtent": SimTypeInt(signed=False, label="UInt32"), "cbMaxExtent": SimTypeInt(signed=False, label="UInt32")}, name="JET_SPACEHINTS", pack=False, align=None), offset=0)}, name="JET_INDEXCREATE3_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pindexcreate", "cIndexCreate"]),
        # 
        'JetDeleteIndexA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName"]),
        # 
        'JetDeleteIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName"]),
        # 
        'JetBeginTransaction': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid"]),
        # 
        'JetBeginTransaction2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit"]),
        # 
        'JetBeginTransaction3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "trxid", "grbit"]),
        # 
        'JetCommitTransaction': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit"]),
        # 
        'JetCommitTransaction2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"signLog": SimStruct({"ulRandom": SimTypeInt(signed=False, label="UInt32"), "logtimeCreate": SimStruct({"bSeconds": SimTypeBottom(label="CHAR"), "bMinutes": SimTypeBottom(label="CHAR"), "bHours": SimTypeBottom(label="CHAR"), "bDay": SimTypeBottom(label="CHAR"), "bMonth": SimTypeBottom(label="CHAR"), "bYear": SimTypeBottom(label="CHAR"), "Anonymous1": SimUnion({"bFiller1": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"bFiller2": SimTypeBottom(label="CHAR"), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="JET_LOGTIME", pack=False, align=None), "szComputerName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="JET_SIGNATURE", pack=False, align=None), "reserved": SimTypeInt(signed=True, label="Int32"), "commitId": SimTypeLongLong(signed=True, label="Int64")}, name="JET_COMMIT_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit", "cmsecDurableCommit", "pCommitId"]),
        # 
        'JetRollback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "grbit"]),
        # 
        'JetGetDatabaseInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetDatabaseInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetDatabaseFileInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szDatabaseName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetGetDatabaseFileInfoW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szDatabaseName", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetOpenDatabaseA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "szConnect", "pdbid", "grbit"]),
        # 
        'JetOpenDatabaseW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szFilename", "szConnect", "pdbid", "grbit"]),
        # 
        'JetCloseDatabase': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "grbit"]),
        # 
        'JetOpenTableA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pvParameters", "cbParameters", "grbit", "ptableid"]),
        # 
        'JetOpenTableW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pvParameters", "cbParameters", "grbit", "ptableid"]),
        # 
        'JetSetTableSequential': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "grbit"]),
        # 
        'JetResetTableSequential': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "grbit"]),
        # 
        'JetCloseTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid"]),
        # 
        'JetDelete': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid"]),
        # 
        'JetUpdate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvBookmark", "cbBookmark", "pcbActual"]),
        # 
        'JetUpdate2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvBookmark", "cbBookmark", "pcbActual", "grbit"]),
        # 
        'JetEscrowUpdate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "columnid", "pv", "cbMax", "pvOld", "cbOldMax", "pcbOldActual", "grbit"]),
        # 
        'JetRetrieveColumn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ibLongValue": SimTypeInt(signed=False, label="UInt32"), "itagSequence": SimTypeInt(signed=False, label="UInt32"), "columnidNextTagged": SimTypeInt(signed=False, label="UInt32")}, name="JET_RETINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "columnid", "pvData", "cbData", "pcbActual", "grbit", "pretinfo"]),
        # 
        'JetRetrieveColumns': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32"), "cbActual": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ibLongValue": SimTypeInt(signed=False, label="UInt32"), "itagSequence": SimTypeInt(signed=False, label="UInt32"), "columnidNextTagged": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_RETRIEVECOLUMN", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pretrievecolumn", "cretrievecolumn"]),
        # 
        'JetEnumerateColumns': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "ctagSequence": SimTypeInt(signed=False, label="UInt32"), "rgtagSequence": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="JET_ENUMCOLUMNID", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "Anonymous": SimUnion({"Anonymous1": SimStruct({"cEnumColumnValue": SimTypeInt(signed=False, label="UInt32"), "rgEnumColumnValue": SimTypePointer(SimStruct({"itagSequence": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="JET_ENUMCOLUMNVALUE", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="JET_ENUMCOLUMN", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pvContext", "pv", "cb"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "cEnumColumnId", "rgEnumColumnId", "pcEnumColumn", "prgEnumColumn", "pfnRealloc", "pvReallocContext", "cbDataMost", "grbit"]),
        # 
        'JetGetRecordSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbData": SimTypeLongLong(signed=False, label="UInt64"), "cbLongValueData": SimTypeLongLong(signed=False, label="UInt64"), "cbOverhead": SimTypeLongLong(signed=False, label="UInt64"), "cbLongValueOverhead": SimTypeLongLong(signed=False, label="UInt64"), "cNonTaggedColumns": SimTypeLongLong(signed=False, label="UInt64"), "cTaggedColumns": SimTypeLongLong(signed=False, label="UInt64"), "cLongValues": SimTypeLongLong(signed=False, label="UInt64"), "cMultiValues": SimTypeLongLong(signed=False, label="UInt64")}, name="JET_RECSIZE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "precsize", "grbit"]),
        # 
        'JetGetRecordSize2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbData": SimTypeLongLong(signed=False, label="UInt64"), "cbLongValueData": SimTypeLongLong(signed=False, label="UInt64"), "cbOverhead": SimTypeLongLong(signed=False, label="UInt64"), "cbLongValueOverhead": SimTypeLongLong(signed=False, label="UInt64"), "cNonTaggedColumns": SimTypeLongLong(signed=False, label="UInt64"), "cTaggedColumns": SimTypeLongLong(signed=False, label="UInt64"), "cLongValues": SimTypeLongLong(signed=False, label="UInt64"), "cMultiValues": SimTypeLongLong(signed=False, label="UInt64"), "cCompressedColumns": SimTypeLongLong(signed=False, label="UInt64"), "cbDataCompressed": SimTypeLongLong(signed=False, label="UInt64"), "cbLongValueDataCompressed": SimTypeLongLong(signed=False, label="UInt64")}, name="JET_RECSIZE2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "precsize", "grbit"]),
        # 
        'JetSetColumn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "ibLongValue": SimTypeInt(signed=False, label="UInt32"), "itagSequence": SimTypeInt(signed=False, label="UInt32")}, name="JET_SETINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "columnid", "pvData", "cbData", "grbit", "psetinfo"]),
        # 
        'JetSetColumns': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32"), "ibLongValue": SimTypeInt(signed=False, label="UInt32"), "itagSequence": SimTypeInt(signed=False, label="UInt32"), "err": SimTypeInt(signed=True, label="Int32")}, name="JET_SETCOLUMN", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "psetcolumn", "csetcolumn"]),
        # 
        'JetPrepareUpdate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "prep"]),
        # 
        'JetGetRecordPosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "centriesLT": SimTypeInt(signed=False, label="UInt32"), "centriesInRange": SimTypeInt(signed=False, label="UInt32"), "centriesTotal": SimTypeInt(signed=False, label="UInt32")}, name="JET_RECPOS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "precpos", "cbRecpos"]),
        # 
        'JetGotoPosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "centriesLT": SimTypeInt(signed=False, label="UInt32"), "centriesInRange": SimTypeInt(signed=False, label="UInt32"), "centriesTotal": SimTypeInt(signed=False, label="UInt32")}, name="JET_RECPOS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "precpos"]),
        # 
        'JetGetCursorInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvResult", "cbMax", "InfoLevel"]),
        # 
        'JetDupCursor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "ptableid", "grbit"]),
        # 
        'JetGetCurrentIndexA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "cbIndexName"]),
        # 
        'JetGetCurrentIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "cbIndexName"]),
        # 
        'JetSetCurrentIndexA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName"]),
        # 
        'JetSetCurrentIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName"]),
        # 
        'JetSetCurrentIndex2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit"]),
        # 
        'JetSetCurrentIndex2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit"]),
        # 
        'JetSetCurrentIndex3A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit", "itagSequence"]),
        # 
        'JetSetCurrentIndex3W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "grbit", "itagSequence"]),
        # 
        'JetSetCurrentIndex4A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "rgbIndexId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 12)}, name="JET_INDEXID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "pindexid", "grbit", "itagSequence"]),
        # 
        'JetSetCurrentIndex4W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "rgbIndexId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 12)}, name="JET_INDEXID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "szIndexName", "pindexid", "grbit", "itagSequence"]),
        # 
        'JetMove': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "cRow", "grbit"]),
        # 
        'JetSetCursorFilter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "relop": SimTypeInt(signed=False, label="JET_RELOP"), "pv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cb": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEX_COLUMN", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "rgColumnFilters", "cColumnFilters", "grbit"]),
        # 
        'JetGetLock': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "grbit"]),
        # 
        'JetMakeKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvData", "cbData", "grbit"]),
        # 
        'JetSeek': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "grbit"]),
        # 
        'JetPrereadKeys': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "rgpvKeys", "rgcbKeys", "ckeys", "pckeysPreread", "grbit"]),
        # 
        'JetPrereadIndexRanges': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"rgStartColumns": SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "relop": SimTypeInt(signed=False, label="JET_RELOP"), "pv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cb": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEX_COLUMN", pack=False, align=None), offset=0), "cStartColumns": SimTypeInt(signed=False, label="UInt32"), "rgEndColumns": SimTypePointer(SimStruct({"columnid": SimTypeInt(signed=False, label="UInt32"), "relop": SimTypeInt(signed=False, label="JET_RELOP"), "pv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cb": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEX_COLUMN", pack=False, align=None), offset=0), "cEndColumns": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEX_RANGE", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "rgIndexRanges", "cIndexRanges", "pcRangesPreread", "rgcolumnidPreread", "ccolumnidPreread", "grbit"]),
        # 
        'JetGetBookmark': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvBookmark", "cbMax", "pcbActual"]),
        # 
        'JetGetSecondaryIndexBookmark': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvSecondaryKey", "cbSecondaryKeyMax", "pcbSecondaryKeyActual", "pvPrimaryBookmark", "cbPrimaryBookmarkMax", "pcbPrimaryBookmarkActual", "grbit"]),
        # 
        'JetCompactA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0), SimTypePointer(SimStruct({"szOldDll": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"fFlags": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="CONVERT_A", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseSrc", "szDatabaseDest", "pfnStatus", "pconvert", "grbit"]),
        # 
        'JetCompactW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0), SimTypePointer(SimStruct({"szOldDll": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"fFlags": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="CONVERT_W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseSrc", "szDatabaseDest", "pfnStatus", "pconvert", "grbit"]),
        # 
        'JetDefragmentA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pcPasses", "pcSeconds", "grbit"]),
        # 
        'JetDefragmentW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pcPasses", "pcSeconds", "grbit"]),
        # 
        'JetDefragment2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "tableid", "cbtyp", "pvArg1", "pvArg2", "pvContext", "ulUnused"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pcPasses", "pcSeconds", "callback", "grbit"]),
        # 
        'JetDefragment2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "tableid", "cbtyp", "pvArg1", "pvArg2", "pvContext", "ulUnused"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "szTableName", "pcPasses", "pcSeconds", "callback", "grbit"]),
        # 
        'JetDefragment3A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "tableid", "cbtyp", "pvArg1", "pvArg2", "pvContext", "ulUnused"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseName", "szTableName", "pcPasses", "pcSeconds", "callback", "pvContext", "grbit"]),
        # 
        'JetDefragment3W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "tableid", "cbtyp", "pvArg1", "pvArg2", "pvContext", "ulUnused"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseName", "szTableName", "pcPasses", "pcSeconds", "callback", "pvContext", "grbit"]),
        # 
        'JetSetDatabaseSizeA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseName", "cpg", "pcpgReal"]),
        # 
        'JetSetDatabaseSizeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "szDatabaseName", "cpg", "pcpgReal"]),
        # 
        'JetGrowDatabase': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "cpg", "pcpgReal"]),
        # 
        'JetResizeDatabase': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "cpgTarget", "pcpgActual", "grbit"]),
        # 
        'JetSetSessionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "ulContext"]),
        # 
        'JetResetSessionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid"]),
        # 
        'JetGotoBookmark': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvBookmark", "cbBookmark"]),
        # 
        'JetGotoSecondaryIndexBookmark': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvSecondaryKey", "cbSecondaryKey", "pvPrimaryBookmark", "cbPrimaryBookmark", "grbit"]),
        # 
        'JetIntersectIndexes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_INDEXRANGE", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "cRecord": SimTypeInt(signed=False, label="UInt32"), "columnidBookmark": SimTypeInt(signed=False, label="UInt32")}, name="JET_RECORDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "rgindexrange", "cindexrange", "precordlist", "grbit"]),
        # 
        'JetComputeStats': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid"]),
        # 
        'JetOpenTempTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "prgcolumndef", "ccolumn", "grbit", "ptableid", "prgcolumnid"]),
        # 
        'JetOpenTempTable2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "prgcolumndef", "ccolumn", "lcid", "grbit", "ptableid", "prgcolumnid"]),
        # 
        'JetOpenTempTable3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "prgcolumndef", "ccolumn", "pidxunicode", "grbit", "ptableid", "prgcolumnid"]),
        # 
        'JetOpenTemporaryTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "prgcolumndef": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), offset=0), "ccolumn": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"lcid": SimTypeInt(signed=False, label="UInt32"), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX", pack=False, align=None), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32"), "prgcolumnid": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="JET_OPENTEMPORARYTABLE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "popentemporarytable"]),
        # 
        'JetOpenTemporaryTable2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "prgcolumndef": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "columnid": SimTypeInt(signed=False, label="UInt32"), "coltyp": SimTypeInt(signed=False, label="UInt32"), "wCountry": SimTypeShort(signed=False, label="UInt16"), "langid": SimTypeShort(signed=False, label="UInt16"), "cp": SimTypeShort(signed=False, label="UInt16"), "wCollate": SimTypeShort(signed=False, label="UInt16"), "cbMax": SimTypeInt(signed=False, label="UInt32"), "grbit": SimTypeInt(signed=False, label="UInt32")}, name="JET_COLUMNDEF", pack=False, align=None), offset=0), "ccolumn": SimTypeInt(signed=False, label="UInt32"), "pidxunicode": SimTypePointer(SimStruct({"szLocaleName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMapFlags": SimTypeInt(signed=False, label="UInt32")}, name="JET_UNICODEINDEX2", pack=False, align=None), offset=0), "grbit": SimTypeInt(signed=False, label="UInt32"), "prgcolumnid": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "cbKeyMost": SimTypeInt(signed=False, label="UInt32"), "cbVarSegMac": SimTypeInt(signed=False, label="UInt32"), "tableid": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="JET_OPENTEMPORARYTABLE2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "popentemporarytable"]),
        # 
        'JetBackupA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szBackupPath", "grbit", "pfnStatus"]),
        # 
        'JetBackupW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szBackupPath", "grbit", "pfnStatus"]),
        # 
        'JetBackupInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szBackupPath", "grbit", "pfnStatus"]),
        # 
        'JetBackupInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szBackupPath", "grbit", "pfnStatus"]),
        # 
        'JetRestoreA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szSource", "pfn"]),
        # 
        'JetRestoreW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szSource", "pfn"]),
        # 
        'JetRestore2A': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sz", "szDest", "pfn"]),
        # 
        'JetRestore2W': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sz", "szDest", "pfn"]),
        # 
        'JetRestoreInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "sz", "szDest", "pfn"]),
        # 
        'JetRestoreInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "sz", "szDest", "pfn"]),
        # 
        'JetSetIndexRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableidSrc", "grbit"]),
        # 
        'JetIndexRecordCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pcrec", "crecMax"]),
        # 
        'JetRetrieveKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pvKey", "cbMax", "pcbActual", "grbit"]),
        # 
        'JetBeginExternalBackup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["grbit"]),
        # 
        'JetBeginExternalBackupInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "grbit"]),
        # 
        'JetGetAttachInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szzDatabases", "cbMax", "pcbActual"]),
        # 
        'JetGetAttachInfoW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wszzDatabases", "cbMax", "pcbActual"]),
        # 
        'JetGetAttachInfoInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szzDatabases", "cbMax", "pcbActual"]),
        # 
        'JetGetAttachInfoInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szzDatabases", "cbMax", "pcbActual"]),
        # 
        'JetOpenFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szFileName", "phfFile", "pulFileSizeLow", "pulFileSizeHigh"]),
        # 
        'JetOpenFileW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szFileName", "phfFile", "pulFileSizeLow", "pulFileSizeHigh"]),
        # 
        'JetOpenFileInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szFileName", "phfFile", "pulFileSizeLow", "pulFileSizeHigh"]),
        # 
        'JetOpenFileInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szFileName", "phfFile", "pulFileSizeLow", "pulFileSizeHigh"]),
        # 
        'JetReadFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfFile", "pv", "cb", "pcbActual"]),
        # 
        'JetReadFileInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "hfFile", "pv", "cb", "pcbActual"]),
        # 
        'JetCloseFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfFile"]),
        # 
        'JetCloseFileInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "hfFile"]),
        # 
        'JetGetLogInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szzLogs", "cbMax", "pcbActual"]),
        # 
        'JetGetLogInfoW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szzLogs", "cbMax", "pcbActual"]),
        # 
        'JetGetLogInfoInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szzLogs", "cbMax", "pcbActual"]),
        # 
        'JetGetLogInfoInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "wszzLogs", "cbMax", "pcbActual"]),
        # 
        'JetGetLogInfoInstance2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "ulGenLow": SimTypeInt(signed=False, label="UInt32"), "ulGenHigh": SimTypeInt(signed=False, label="UInt32"), "szBaseName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 4)}, name="JET_LOGINFO_A", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szzLogs", "cbMax", "pcbActual", "pLogInfo"]),
        # 
        'JetGetLogInfoInstance2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "ulGenLow": SimTypeInt(signed=False, label="UInt32"), "ulGenHigh": SimTypeInt(signed=False, label="UInt32"), "szBaseName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 4)}, name="JET_LOGINFO_W", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "wszzLogs", "cbMax", "pcbActual", "pLogInfo"]),
        # 
        'JetGetTruncateLogInfoInstanceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "szzLogs", "cbMax", "pcbActual"]),
        # 
        'JetGetTruncateLogInfoInstanceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "wszzLogs", "cbMax", "pcbActual"]),
        # 
        'JetTruncateLog': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'JetTruncateLogInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance"]),
        # 
        'JetEndExternalBackup': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'JetEndExternalBackupInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["instance"]),
        # 
        'JetEndExternalBackupInstance2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["instance", "grbit"]),
        # 
        'JetExternalRestoreA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="JET_RSTMAP_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szCheckpointFilePath", "szLogPath", "rgrstmap", "crstfilemap", "szBackupLogPath", "genLow", "genHigh", "pfn"]),
        # 
        'JetExternalRestoreW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="JET_RSTMAP_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szCheckpointFilePath", "szLogPath", "rgrstmap", "crstfilemap", "szBackupLogPath", "genLow", "genHigh", "pfn"]),
        # 
        'JetExternalRestore2A': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="JET_RSTMAP_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "ulGenLow": SimTypeInt(signed=False, label="UInt32"), "ulGenHigh": SimTypeInt(signed=False, label="UInt32"), "szBaseName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 4)}, name="JET_LOGINFO_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szCheckpointFilePath", "szLogPath", "rgrstmap", "crstfilemap", "szBackupLogPath", "pLogInfo", "szTargetInstanceName", "szTargetInstanceLogPath", "szTargetInstanceCheckpointPath", "pfn"]),
        # 
        'JetExternalRestore2W': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"szDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szNewDatabaseName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="JET_RSTMAP_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "ulGenLow": SimTypeInt(signed=False, label="UInt32"), "ulGenHigh": SimTypeInt(signed=False, label="UInt32"), "szBaseName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 4)}, name="JET_LOGINFO_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "snp", "snt", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szCheckpointFilePath", "szLogPath", "rgrstmap", "crstfilemap", "szBackupLogPath", "pLogInfo", "szTargetInstanceName", "szTargetInstanceLogPath", "szTargetInstanceCheckpointPath", "pfn"]),
        # 
        'JetRegisterCallback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "dbid", "tableid", "cbtyp", "pvArg1", "pvArg2", "pvContext", "ulUnused"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "cbtyp", "pCallback", "pvContext", "phCallbackId"]),
        # 
        'JetUnregisterCallback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "cbtyp", "hCallbackId"]),
        # 
        'JetGetInstanceInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_A", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcInstanceInfo", "paInstanceInfo"]),
        # 
        'JetGetInstanceInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_W", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcInstanceInfo", "paInstanceInfo"]),
        # 
        'JetFreeBuffer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbBuf"]),
        # 
        'JetSetLS': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "ls", "grbit"]),
        # 
        'JetGetLS': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "tableid", "pls", "grbit"]),
        # 
        'JetOSSnapshotPrepare': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psnapId", "grbit"]),
        # 
        'JetOSSnapshotPrepareInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "instance", "grbit"]),
        # 
        'JetOSSnapshotFreezeA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_A", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "pcInstanceInfo", "paInstanceInfo", "grbit"]),
        # 
        'JetOSSnapshotFreezeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_W", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "pcInstanceInfo", "paInstanceInfo", "grbit"]),
        # 
        'JetOSSnapshotThaw': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "grbit"]),
        # 
        'JetOSSnapshotAbort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "grbit"]),
        # 
        'JetOSSnapshotTruncateLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "grbit"]),
        # 
        'JetOSSnapshotTruncateLogInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "instance", "grbit"]),
        # 
        'JetOSSnapshotGetFreezeInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_A", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "pcInstanceInfo", "paInstanceInfo", "grbit"]),
        # 
        'JetOSSnapshotGetFreezeInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hInstanceId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cDatabases": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "szDatabaseFileName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseDisplayName": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), "szDatabaseSLVFileName_Obsolete": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)}, name="JET_INSTANCE_INFO_W", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "pcInstanceInfo", "paInstanceInfo", "grbit"]),
        # 
        'JetOSSnapshotEnd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["snapId", "grbit"]),
        # 
        'JetConfigureProcessForCrashDump': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["grbit"]),
        # 
        'JetGetErrorInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvContext", "pvResult", "cbMax", "InfoLevel", "grbit"]),
        # 
        'JetSetSessionParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "sesparamid", "pvParam", "cbParam"]),
        # 
        'JetGetSessionParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sesid", "sesparamid", "pvParam", "cbParamMax", "pcbParamActual"]),
    }

lib.set_prototypes(prototypes)
