# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("gdi32.dll")
prototypes = \
    {
        # 
        'GetTextCharset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetTextCharsetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"fsUsb": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "fsCsb": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2)}, name="FONTSIGNATURE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpSig", "dwFlags"]),
        # 
        'TranslateCharsetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"ciCharset": SimTypeInt(signed=False, label="UInt32"), "ciACP": SimTypeInt(signed=False, label="UInt32"), "fs": SimStruct({"fsUsb": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "fsCsb": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2)}, name="FONTSIGNATURE", pack=False, align=None)}, name="CHARSETINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TRANSLATE_CHARSET_INFO_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSrc", "lpCs", "dwFlags"]),
        # 
        'GetObjectA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["h", "c", "pv"]),
        # 
        'AddFontResourceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'AddFontResourceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'AnimatePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPal", "iStartIndex", "cEntries", "ppe"]),
        # 
        'Arc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x1", "y1", "x2", "y2", "x3", "y3", "x4", "y4"]),
        # 
        'BitBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="ROP_CODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "cx", "cy", "hdcSrc", "x1", "y1", "rop"]),
        # 
        'CancelDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'Chord': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x1", "y1", "x2", "y2", "x3", "y3", "x4", "y4"]),
        # 
        'CloseMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'CombineRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RGN_COMBINE_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgnDst", "hrgnSrc1", "hrgnSrc2", "iMode"]),
        # 
        'CopyMetaFileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0", "param1"]),
        # 
        'CopyMetaFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0", "param1"]),
        # 
        'CreateBitmap': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["nWidth", "nHeight", "nPlanes", "nBitCount", "lpBits"]),
        # 
        'CreateBitmapIndirect': SimTypeFunction([SimTypePointer(SimStruct({"bmType": SimTypeInt(signed=True, label="Int32"), "bmWidth": SimTypeInt(signed=True, label="Int32"), "bmHeight": SimTypeInt(signed=True, label="Int32"), "bmWidthBytes": SimTypeInt(signed=True, label="Int32"), "bmPlanes": SimTypeShort(signed=False, label="UInt16"), "bmBitsPixel": SimTypeShort(signed=False, label="UInt16"), "bmBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BITMAP", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pbm"]),
        # 
        'CreateBrushIndirect': SimTypeFunction([SimTypePointer(SimStruct({"lbStyle": SimTypeInt(signed=False, label="UInt32"), "lbColor": SimTypeInt(signed=False, label="UInt32"), "lbHatch": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="LOGBRUSH", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["plbrush"]),
        # 
        'CreateCompatibleBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "cx", "cy"]),
        # 
        'CreateDiscardableBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "cx", "cy"]),
        # 
        'CreateCompatibleDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'CreateDCA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pwszDriver", "pwszDevice", "pszPort", "pdm"]),
        # 
        'CreateDCW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pwszDriver", "pwszDevice", "pszPort", "pdm"]),
        # 
        'CreateDIBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "pbmih", "flInit", "pjBits", "pbmi", "iUsage"]),
        # 
        'CreateDIBPatternBrush': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["h", "iUsage"]),
        # 
        'CreateDIBPatternBrushPt': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpPackedDIB", "iUsage"]),
        # 
        'CreateEllipticRgn': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["x1", "y1", "x2", "y2"]),
        # 
        'CreateEllipticRgnIndirect': SimTypeFunction([SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lprect"]),
        # 
        'CreateFontIndirectA': SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lplf"]),
        # 
        'CreateFontIndirectW': SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lplf"]),
        # 
        'CreateFontA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="FONT_OUTPUT_PRECISION"), SimTypeInt(signed=False, label="FONT_CLIP_PRECISION"), SimTypeInt(signed=False, label="FONT_QUALITY"), SimTypeInt(signed=False, label="FONT_PITCH_AND_FAMILY"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["cHeight", "cWidth", "cEscapement", "cOrientation", "cWeight", "bItalic", "bUnderline", "bStrikeOut", "iCharSet", "iOutPrecision", "iClipPrecision", "iQuality", "iPitchAndFamily", "pszFaceName"]),
        # 
        'CreateFontW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="FONT_OUTPUT_PRECISION"), SimTypeInt(signed=False, label="FONT_CLIP_PRECISION"), SimTypeInt(signed=False, label="FONT_QUALITY"), SimTypeInt(signed=False, label="FONT_PITCH_AND_FAMILY"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["cHeight", "cWidth", "cEscapement", "cOrientation", "cWeight", "bItalic", "bUnderline", "bStrikeOut", "iCharSet", "iOutPrecision", "iClipPrecision", "iQuality", "iPitchAndFamily", "pszFaceName"]),
        # 
        'CreateHatchBrush': SimTypeFunction([SimTypeInt(signed=False, label="HATCH_BRUSH_STYLE"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["iHatch", "color"]),
        # 
        'CreateICA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszDriver", "pszDevice", "pszPort", "pdm"]),
        # 
        'CreateICW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszDriver", "pszDevice", "pszPort", "pdm"]),
        # 
        'CreateMetaFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFile"]),
        # 
        'CreateMetaFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFile"]),
        # 
        'CreatePalette': SimTypeFunction([SimTypePointer(SimStruct({"palVersion": SimTypeShort(signed=False, label="UInt16"), "palNumEntries": SimTypeShort(signed=False, label="UInt16"), "palPalEntry": SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), offset=0)}, name="LOGPALETTE", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["plpal"]),
        # 
        'CreatePen': SimTypeFunction([SimTypeInt(signed=False, label="PEN_STYLE"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["iStyle", "cWidth", "color"]),
        # 
        'CreatePenIndirect': SimTypeFunction([SimTypePointer(SimStruct({"lopnStyle": SimTypeInt(signed=False, label="UInt32"), "lopnWidth": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "lopnColor": SimTypeInt(signed=False, label="UInt32")}, name="LOGPEN", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["plpen"]),
        # 
        'CreatePolyPolygonRgn': SimTypeFunction([SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="CREATE_POLYGON_RGN_MODE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pptl", "pc", "cPoly", "iMode"]),
        # 
        'CreatePatternBrush': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hbm"]),
        # 
        'CreateRectRgn': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["x1", "y1", "x2", "y2"]),
        # 
        'CreateRectRgnIndirect': SimTypeFunction([SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lprect"]),
        # 
        'CreateRoundRectRgn': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["x1", "y1", "x2", "y2", "w", "h"]),
        # 
        'CreateScalableFontResourceA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fdwHidden", "lpszFont", "lpszFile", "lpszPath"]),
        # 
        'CreateScalableFontResourceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fdwHidden", "lpszFont", "lpszFile", "lpszPath"]),
        # 
        'CreateSolidBrush': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["color"]),
        # 
        'DeleteDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'DeleteMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hmf"]),
        # 
        'DeleteObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ho"]),
        # 
        'DrawEscape': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iEscape", "cjIn", "lpIn"]),
        # 
        'Ellipse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom"]),
        # 
        'EnumFontFamiliesExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Byte"), "tmLastChar": SimTypeChar(label="Byte"), "tmDefaultChar": SimTypeChar(label="Byte"), "tmBreakChar": SimTypeChar(label="Byte"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam", "dwFlags"]),
        # 
        'EnumFontFamiliesExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam", "dwFlags"]),
        # 
        'EnumFontFamiliesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Byte"), "tmLastChar": SimTypeChar(label="Byte"), "tmDefaultChar": SimTypeChar(label="Byte"), "tmBreakChar": SimTypeChar(label="Byte"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam"]),
        # 
        'EnumFontFamiliesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam"]),
        # 
        'EnumFontsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Byte"), "tmLastChar": SimTypeChar(label="Byte"), "tmDefaultChar": SimTypeChar(label="Byte"), "tmBreakChar": SimTypeChar(label="Byte"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam"]),
        # 
        'EnumFontsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpLogfont", "lpProc", "lParam"]),
        # 
        'EnumObjects': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="OBJ_TYPE"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "nType", "lpFunc", "lParam"]),
        # 
        'EqualRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn1", "hrgn2"]),
        # 
        'ExcludeClipRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom"]),
        # 
        'ExtCreateRegion': SimTypeFunction([SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"rdh": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeInt(signed=False, label="UInt32"), "nCount": SimTypeInt(signed=False, label="UInt32"), "nRgnSize": SimTypeInt(signed=False, label="UInt32"), "rcBound": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None)}, name="RGNDATAHEADER", pack=False, align=None), "Buffer": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="RGNDATA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpx", "nCount", "lpData"]),
        # 
        'ExtFloodFill': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="EXT_FLOOD_FILL_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "color", "type"]),
        # 
        'FillRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn", "hbr"]),
        # 
        'FloodFill': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "color"]),
        # 
        'FrameRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn", "hbr", "w", "h"]),
        # 
        'GetROP2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetAspectRatioFilterEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpsize"]),
        # 
        'GetBkColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetDCBrushColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetDCPenColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetBkMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetBitmapBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hbit", "cb", "lpvBits"]),
        # 
        'GetBitmapDimensionEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hbit", "lpsize"]),
        # 
        'GetBoundsRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lprect", "flags"]),
        # 
        'GetBrushOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppt"]),
        # 
        'GetCharWidthA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharWidthW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharWidth32A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharWidth32W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharWidthFloatA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharWidthFloatW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpBuffer"]),
        # 
        'GetCharABCWidthsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"abcA": SimTypeInt(signed=True, label="Int32"), "abcB": SimTypeInt(signed=False, label="UInt32"), "abcC": SimTypeInt(signed=True, label="Int32")}, name="ABC", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "wFirst", "wLast", "lpABC"]),
        # 
        'GetCharABCWidthsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"abcA": SimTypeInt(signed=True, label="Int32"), "abcB": SimTypeInt(signed=False, label="UInt32"), "abcC": SimTypeInt(signed=True, label="Int32")}, name="ABC", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "wFirst", "wLast", "lpABC"]),
        # 
        'GetCharABCWidthsFloatA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"abcfA": SimTypeFloat(size=32), "abcfB": SimTypeFloat(size=32), "abcfC": SimTypeFloat(size=32)}, name="ABCFLOAT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpABC"]),
        # 
        'GetCharABCWidthsFloatW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"abcfA": SimTypeFloat(size=32), "abcfB": SimTypeFloat(size=32), "abcfC": SimTypeFloat(size=32)}, name="ABCFLOAT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iFirst", "iLast", "lpABC"]),
        # 
        'GetClipBox': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lprect"]),
        # 
        'GetClipRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn"]),
        # 
        'GetMetaRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn"]),
        # 
        'GetCurrentObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="OBJ_TYPE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "type"]),
        # 
        'GetCurrentPositionEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppt"]),
        # 
        'GetDeviceCaps': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="GET_DEVICE_CAPS_INDEX")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "index"]),
        # 
        'GetDIBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hbm", "start", "cLines", "lpvBits", "lpbmi", "usage"]),
        # 
        'GetFontData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "dwTable", "dwOffset", "pvBuffer", "cjBuffer"]),
        # 
        'GetGlyphOutlineA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="GET_GLYPH_OUTLINE_FORMAT"), SimTypePointer(SimStruct({"gmBlackBoxX": SimTypeInt(signed=False, label="UInt32"), "gmBlackBoxY": SimTypeInt(signed=False, label="UInt32"), "gmptGlyphOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "gmCellIncX": SimTypeShort(signed=True, label="Int16"), "gmCellIncY": SimTypeShort(signed=True, label="Int16")}, name="GLYPHMETRICS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"eM11": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM12": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM21": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM22": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None)}, name="MAT2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "uChar", "fuFormat", "lpgm", "cjBuffer", "pvBuffer", "lpmat2"]),
        # 
        'GetGlyphOutlineW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="GET_GLYPH_OUTLINE_FORMAT"), SimTypePointer(SimStruct({"gmBlackBoxX": SimTypeInt(signed=False, label="UInt32"), "gmBlackBoxY": SimTypeInt(signed=False, label="UInt32"), "gmptGlyphOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "gmCellIncX": SimTypeShort(signed=True, label="Int16"), "gmCellIncY": SimTypeShort(signed=True, label="Int16")}, name="GLYPHMETRICS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"eM11": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM12": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM21": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None), "eM22": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="FIXED", pack=False, align=None)}, name="MAT2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "uChar", "fuFormat", "lpgm", "cjBuffer", "pvBuffer", "lpmat2"]),
        # 
        'GetGraphicsMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetMapMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetMetaFileBitsEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMF", "cbBuffer", "lpData"]),
        # 
        'GetMetaFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpName"]),
        # 
        'GetMetaFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpName"]),
        # 
        'GetNearestColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "color"]),
        # 
        'GetNearestPaletteIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["h", "color"]),
        # 
        'GetObjectType': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["h"]),
        # 
        'GetOutlineTextMetricsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"otmSize": SimTypeInt(signed=False, label="UInt32"), "otmTextMetrics": SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Byte"), "tmLastChar": SimTypeChar(label="Byte"), "tmDefaultChar": SimTypeChar(label="Byte"), "tmBreakChar": SimTypeChar(label="Byte"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICA", pack=False, align=None), "otmFiller": SimTypeChar(label="Byte"), "otmPanoseNumber": SimStruct({"bFamilyType": SimTypeChar(label="Byte"), "bSerifStyle": SimTypeChar(label="Byte"), "bWeight": SimTypeChar(label="Byte"), "bProportion": SimTypeChar(label="Byte"), "bContrast": SimTypeChar(label="Byte"), "bStrokeVariation": SimTypeChar(label="Byte"), "bArmStyle": SimTypeChar(label="Byte"), "bLetterform": SimTypeChar(label="Byte"), "bMidline": SimTypeChar(label="Byte"), "bXHeight": SimTypeChar(label="Byte")}, name="PANOSE", pack=False, align=None), "otmfsSelection": SimTypeInt(signed=False, label="UInt32"), "otmfsType": SimTypeInt(signed=False, label="UInt32"), "otmsCharSlopeRise": SimTypeInt(signed=True, label="Int32"), "otmsCharSlopeRun": SimTypeInt(signed=True, label="Int32"), "otmItalicAngle": SimTypeInt(signed=True, label="Int32"), "otmEMSquare": SimTypeInt(signed=False, label="UInt32"), "otmAscent": SimTypeInt(signed=True, label="Int32"), "otmDescent": SimTypeInt(signed=True, label="Int32"), "otmLineGap": SimTypeInt(signed=False, label="UInt32"), "otmsCapEmHeight": SimTypeInt(signed=False, label="UInt32"), "otmsXHeight": SimTypeInt(signed=False, label="UInt32"), "otmrcFontBox": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "otmMacAscent": SimTypeInt(signed=True, label="Int32"), "otmMacDescent": SimTypeInt(signed=True, label="Int32"), "otmMacLineGap": SimTypeInt(signed=False, label="UInt32"), "otmusMinimumPPEM": SimTypeInt(signed=False, label="UInt32"), "otmptSubscriptSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSubscriptOffset": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSuperscriptSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSuperscriptOffset": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmsStrikeoutSize": SimTypeInt(signed=False, label="UInt32"), "otmsStrikeoutPosition": SimTypeInt(signed=True, label="Int32"), "otmsUnderscoreSize": SimTypeInt(signed=True, label="Int32"), "otmsUnderscorePosition": SimTypeInt(signed=True, label="Int32"), "otmpFamilyName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpFaceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpStyleName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpFullName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="OUTLINETEXTMETRICA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "cjCopy", "potm"]),
        # 
        'GetOutlineTextMetricsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"otmSize": SimTypeInt(signed=False, label="UInt32"), "otmTextMetrics": SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), "otmFiller": SimTypeChar(label="Byte"), "otmPanoseNumber": SimStruct({"bFamilyType": SimTypeChar(label="Byte"), "bSerifStyle": SimTypeChar(label="Byte"), "bWeight": SimTypeChar(label="Byte"), "bProportion": SimTypeChar(label="Byte"), "bContrast": SimTypeChar(label="Byte"), "bStrokeVariation": SimTypeChar(label="Byte"), "bArmStyle": SimTypeChar(label="Byte"), "bLetterform": SimTypeChar(label="Byte"), "bMidline": SimTypeChar(label="Byte"), "bXHeight": SimTypeChar(label="Byte")}, name="PANOSE", pack=False, align=None), "otmfsSelection": SimTypeInt(signed=False, label="UInt32"), "otmfsType": SimTypeInt(signed=False, label="UInt32"), "otmsCharSlopeRise": SimTypeInt(signed=True, label="Int32"), "otmsCharSlopeRun": SimTypeInt(signed=True, label="Int32"), "otmItalicAngle": SimTypeInt(signed=True, label="Int32"), "otmEMSquare": SimTypeInt(signed=False, label="UInt32"), "otmAscent": SimTypeInt(signed=True, label="Int32"), "otmDescent": SimTypeInt(signed=True, label="Int32"), "otmLineGap": SimTypeInt(signed=False, label="UInt32"), "otmsCapEmHeight": SimTypeInt(signed=False, label="UInt32"), "otmsXHeight": SimTypeInt(signed=False, label="UInt32"), "otmrcFontBox": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "otmMacAscent": SimTypeInt(signed=True, label="Int32"), "otmMacDescent": SimTypeInt(signed=True, label="Int32"), "otmMacLineGap": SimTypeInt(signed=False, label="UInt32"), "otmusMinimumPPEM": SimTypeInt(signed=False, label="UInt32"), "otmptSubscriptSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSubscriptOffset": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSuperscriptSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmptSuperscriptOffset": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "otmsStrikeoutSize": SimTypeInt(signed=False, label="UInt32"), "otmsStrikeoutPosition": SimTypeInt(signed=True, label="Int32"), "otmsUnderscoreSize": SimTypeInt(signed=True, label="Int32"), "otmsUnderscorePosition": SimTypeInt(signed=True, label="Int32"), "otmpFamilyName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpFaceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpStyleName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "otmpFullName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="OUTLINETEXTMETRICW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "cjCopy", "potm"]),
        # 
        'GetPaletteEntries': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hpal", "iStart", "cEntries", "pPalEntries"]),
        # 
        'GetPixel': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "x", "y"]),
        # 
        'GetPolyFillMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetRasterizerCaps': SimTypeFunction([SimTypePointer(SimStruct({"nSize": SimTypeShort(signed=True, label="Int16"), "wFlags": SimTypeShort(signed=True, label="Int16"), "nLanguageID": SimTypeShort(signed=True, label="Int16")}, name="RASTERIZER_STATUS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpraststat", "cjBytes"]),
        # 
        'GetRandomRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn", "i"]),
        # 
        'GetRegionData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"rdh": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeInt(signed=False, label="UInt32"), "nCount": SimTypeInt(signed=False, label="UInt32"), "nRgnSize": SimTypeInt(signed=False, label="UInt32"), "rcBound": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None)}, name="RGNDATAHEADER", pack=False, align=None), "Buffer": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="RGNDATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hrgn", "nCount", "lpRgnData"]),
        # 
        'GetRgnBox': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn", "lprc"]),
        # 
        'GetStockObject': SimTypeFunction([SimTypeInt(signed=False, label="GET_STOCK_OBJECT_FLAGS")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["i"]),
        # 
        'GetStretchBltMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetSystemPaletteEntries': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "iStart", "cEntries", "pPalEntries"]),
        # 
        'GetSystemPaletteUse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetTextCharacterExtra': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetTextAlign': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetTextColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetTextExtentPointA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpString", "c", "lpsz"]),
        # 
        'GetTextExtentPointW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpString", "c", "lpsz"]),
        # 
        'GetTextExtentPoint32A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpString", "c", "psizl"]),
        # 
        'GetTextExtentPoint32W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpString", "c", "psizl"]),
        # 
        'GetTextExtentExPointA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpszString", "cchString", "nMaxExtent", "lpnFit", "lpnDx", "lpSize"]),
        # 
        'GetTextExtentExPointW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpszString", "cchString", "nMaxExtent", "lpnFit", "lpnDx", "lpSize"]),
        # 
        'GetFontLanguageInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'GetCharacterPlacementA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "lpOutString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpOrder": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "lpDx": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "lpCaretPos": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "lpClass": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpGlyphs": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nGlyphs": SimTypeInt(signed=False, label="UInt32"), "nMaxFit": SimTypeInt(signed=True, label="Int32")}, name="GCP_RESULTSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="GET_CHARACTER_PLACEMENT_FLAGS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lpString", "nCount", "nMexExtent", "lpResults", "dwFlags"]),
        # 
        'GetCharacterPlacementW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "lpOutString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpOrder": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "lpDx": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "lpCaretPos": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "lpClass": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpGlyphs": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nGlyphs": SimTypeInt(signed=False, label="UInt32"), "nMaxFit": SimTypeInt(signed=True, label="Int32")}, name="GCP_RESULTSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="GET_CHARACTER_PLACEMENT_FLAGS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lpString", "nCount", "nMexExtent", "lpResults", "dwFlags"]),
        # 
        'GetFontUnicodeRanges': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbThis": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "cGlyphsSupported": SimTypeInt(signed=False, label="UInt32"), "cRanges": SimTypeInt(signed=False, label="UInt32"), "ranges": SimTypePointer(SimStruct({"wcLow": SimTypeChar(label="Char"), "cGlyphs": SimTypeShort(signed=False, label="UInt16")}, name="WCRANGE", pack=False, align=None), offset=0)}, name="GLYPHSET", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lpgs"]),
        # 
        'GetGlyphIndicesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lpstr", "c", "pgi", "fl"]),
        # 
        'GetGlyphIndicesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lpstr", "c", "pgi", "fl"]),
        # 
        'GetTextExtentPointI': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pgiIn", "cgi", "psize"]),
        # 
        'GetTextExtentExPointI': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpwszString", "cwchString", "nMaxExtent", "lpnFit", "lpnDx", "lpSize"]),
        # 
        'GetCharWidthI': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "giFirst", "cgi", "pgi", "piWidths"]),
        # 
        'GetCharABCWidthsI': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimStruct({"abcA": SimTypeInt(signed=True, label="Int32"), "abcB": SimTypeInt(signed=False, label="UInt32"), "abcC": SimTypeInt(signed=True, label="Int32")}, name="ABC", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "giFirst", "cgi", "pgi", "pabc"]),
        # 
        'AddFontResourceExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="FONT_RESOURCE_CHARACTERISTICS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "fl", "res"]),
        # 
        'AddFontResourceExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="FONT_RESOURCE_CHARACTERISTICS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "fl", "res"]),
        # 
        'RemoveFontResourceExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "fl", "pdv"]),
        # 
        'RemoveFontResourceExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "fl", "pdv"]),
        # 
        'AddFontMemResourceEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pFileView", "cjSize", "pvResrved", "pNumFonts"]),
        # 
        'RemoveFontMemResourceEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["h"]),
        # 
        'CreateFontIndirectExA': SimTypeFunction([SimTypePointer(SimStruct({"elfEnumLogfontEx": SimStruct({"elfLogFont": SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), "elfFullName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 64), "elfStyle": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "elfScript": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="ENUMLOGFONTEXA", pack=False, align=None), "elfDesignVector": SimStruct({"dvReserved": SimTypeInt(signed=False, label="UInt32"), "dvNumAxes": SimTypeInt(signed=False, label="UInt32"), "dvValues": SimTypeFixedSizeArray(SimTypeInt(signed=True, label="Int32"), 16)}, name="DESIGNVECTOR", pack=False, align=None)}, name="ENUMLOGFONTEXDVA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'CreateFontIndirectExW': SimTypeFunction([SimTypePointer(SimStruct({"elfEnumLogfontEx": SimStruct({"elfLogFont": SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), "elfFullName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "elfStyle": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "elfScript": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="ENUMLOGFONTEXW", pack=False, align=None), "elfDesignVector": SimStruct({"dvReserved": SimTypeInt(signed=False, label="UInt32"), "dvNumAxes": SimTypeInt(signed=False, label="UInt32"), "dvValues": SimTypeFixedSizeArray(SimTypeInt(signed=True, label="Int32"), 16)}, name="DESIGNVECTOR", pack=False, align=None)}, name="ENUMLOGFONTEXDVW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'GetViewportExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpsize"]),
        # 
        'GetViewportOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppoint"]),
        # 
        'GetWindowExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpsize"]),
        # 
        'GetWindowOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppoint"]),
        # 
        'IntersectClipRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom"]),
        # 
        'InvertRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn"]),
        # 
        'LineDDA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1", "param2"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["xStart", "yStart", "xEnd", "yEnd", "lpProc", "data"]),
        # 
        'LineTo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y"]),
        # 
        'MaskBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdcDest", "xDest", "yDest", "width", "height", "hdcSrc", "xSrc", "ySrc", "hbmMask", "xMask", "yMask", "rop"]),
        # 
        'PlgBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdcDest", "lpPoint", "hdcSrc", "xSrc", "ySrc", "width", "height", "hbmMask", "xMask", "yMask"]),
        # 
        'OffsetClipRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y"]),
        # 
        'OffsetRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn", "x", "y"]),
        # 
        'PatBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="ROP_CODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "w", "h", "rop"]),
        # 
        'Pie': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom", "xr1", "yr1", "xr2", "yr2"]),
        # 
        'PlayMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hmf"]),
        # 
        'PaintRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn"]),
        # 
        'PolyPolygon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "asz", "csz"]),
        # 
        'PtInRegion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn", "x", "y"]),
        # 
        'PtVisible': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y"]),
        # 
        'RectInRegion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn", "lprect"]),
        # 
        'RectVisible': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lprect"]),
        # 
        'Rectangle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom"]),
        # 
        'RestoreDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "nSavedDC"]),
        # 
        'ResetDCA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "lpdm"]),
        # 
        'ResetDCW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "lpdm"]),
        # 
        'RealizePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'RemoveFontResourceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName"]),
        # 
        'RemoveFontResourceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName"]),
        # 
        'RoundRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom", "width", "height"]),
        # 
        'ResizePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hpal", "n"]),
        # 
        'SaveDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'SelectClipRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn"]),
        # 
        'ExtSelectClipRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RGN_COMBINE_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hrgn", "mode"]),
        # 
        'SetMetaRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'SelectObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "h"]),
        # 
        'SelectPalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "hPal", "bForceBkgd"]),
        # 
        'SetBkColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "color"]),
        # 
        'SetDCBrushColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "color"]),
        # 
        'SetDCPenColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "color"]),
        # 
        'SetBkMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="BACKGROUND_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "mode"]),
        # 
        'SetBitmapBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hbm", "cb", "pvBits"]),
        # 
        'SetBoundsRect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SET_BOUNDS_RECT_FLAGS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "lprect", "flags"]),
        # 
        'SetDIBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hbm", "start", "cLines", "lpBits", "lpbmi", "ColorUse"]),
        # 
        'SetDIBitsToDevice': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "xDest", "yDest", "w", "h", "xSrc", "ySrc", "StartScan", "cLines", "lpvBits", "lpbmi", "ColorUse"]),
        # 
        'SetMapperFlags': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "flags"]),
        # 
        'SetGraphicsMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="GRAPHICS_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iMode"]),
        # 
        'SetMapMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HDC_MAP_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iMode"]),
        # 
        'SetLayout': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="DC_LAYOUT")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "l"]),
        # 
        'GetLayout': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc"]),
        # 
        'SetMetaFileBitsEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["cbBuffer", "lpData"]),
        # 
        'SetPaletteEntries': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hpal", "iStart", "cEntries", "pPalEntries"]),
        # 
        'SetPixel': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "x", "y", "color"]),
        # 
        'SetPixelV': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "color"]),
        # 
        'SetPolyFillMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CREATE_POLYGON_RGN_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "mode"]),
        # 
        'StretchBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="ROP_CODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdcDest", "xDest", "yDest", "wDest", "hDest", "hdcSrc", "xSrc", "ySrc", "wSrc", "hSrc", "rop"]),
        # 
        'SetRectRgn': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hrgn", "left", "top", "right", "bottom"]),
        # 
        'StretchDIBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE"), SimTypeInt(signed=False, label="ROP_CODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "xDest", "yDest", "DestWidth", "DestHeight", "xSrc", "ySrc", "SrcWidth", "SrcHeight", "lpBits", "lpbmi", "iUsage", "rop"]),
        # 
        'SetROP2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="R2_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "rop2"]),
        # 
        'SetStretchBltMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="STRETCH_BLT_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "mode"]),
        # 
        'SetSystemPaletteUse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SYSTEM_PALETTE_USE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "use"]),
        # 
        'SetTextCharacterExtra': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "extra"]),
        # 
        'SetTextColor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "color"]),
        # 
        'SetTextAlign': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TEXT_ALIGN_OPTIONS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "align"]),
        # 
        'SetTextJustification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "extra", "count"]),
        # 
        'UpdateColors': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GdiAlphaBlend': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimStruct({"BlendOp": SimTypeChar(label="Byte"), "BlendFlags": SimTypeChar(label="Byte"), "SourceConstantAlpha": SimTypeChar(label="Byte"), "AlphaFormat": SimTypeChar(label="Byte")}, name="BLENDFUNCTION", pack=False, align=None)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdcDest", "xoriginDest", "yoriginDest", "wDest", "hDest", "hdcSrc", "xoriginSrc", "yoriginSrc", "wSrc", "hSrc", "ftn"]),
        # 
        'GdiTransparentBlt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdcDest", "xoriginDest", "yoriginDest", "wDest", "hDest", "hdcSrc", "xoriginSrc", "yoriginSrc", "wSrc", "hSrc", "crTransparent"]),
        # 
        'GdiGradientFill': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32"), "Red": SimTypeShort(signed=False, label="UInt16"), "Green": SimTypeShort(signed=False, label="UInt16"), "Blue": SimTypeShort(signed=False, label="UInt16"), "Alpha": SimTypeShort(signed=False, label="UInt16")}, name="TRIVERTEX", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="GRADIENT_FILL")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pVertex", "nVertex", "pMesh", "nCount", "ulMode"]),
        # 
        'PlayMetaFileRecord': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"objectHandle": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="HANDLETABLE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"rdSize": SimTypeInt(signed=False, label="UInt32"), "rdFunction": SimTypeShort(signed=False, label="UInt16"), "rdParm": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="METARECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpHandleTable", "lpMR", "noObjs"]),
        # 
        'EnumMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"objectHandle": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="HANDLETABLE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"rdSize": SimTypeInt(signed=False, label="UInt32"), "rdFunction": SimTypeShort(signed=False, label="UInt16"), "rdParm": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="METARECORD", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpht", "lpMR", "nObj", "param4"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hmf", "proc", "param3"]),
        # 
        'CloseEnhMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'CopyEnhMetaFileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hEnh", "lpFileName"]),
        # 
        'CopyEnhMetaFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hEnh", "lpFileName"]),
        # 
        'CreateEnhMetaFileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "lpFilename", "lprc", "lpDesc"]),
        # 
        'CreateEnhMetaFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "lpFilename", "lprc", "lpDesc"]),
        # 
        'DeleteEnhMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hmf"]),
        # 
        'EnumEnhMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"objectHandle": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="HANDLETABLE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"iType": SimTypeInt(signed=False, label="UInt32"), "nSize": SimTypeInt(signed=False, label="UInt32"), "dParm": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ENHMETARECORD", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpht", "lpmr", "nHandles", "data"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hmf", "proc", "param3", "lpRect"]),
        # 
        'GetEnhMetaFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpName"]),
        # 
        'GetEnhMetaFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpName"]),
        # 
        'GetEnhMetaFileBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEMF", "nSize", "lpData"]),
        # 
        'GetEnhMetaFileDescriptionA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "cchBuffer", "lpDescription"]),
        # 
        'GetEnhMetaFileDescriptionW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "cchBuffer", "lpDescription"]),
        # 
        'GetEnhMetaFileHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"iType": SimTypeInt(signed=False, label="UInt32"), "nSize": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "rclFrame": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "dSignature": SimTypeInt(signed=False, label="UInt32"), "nVersion": SimTypeInt(signed=False, label="UInt32"), "nBytes": SimTypeInt(signed=False, label="UInt32"), "nRecords": SimTypeInt(signed=False, label="UInt32"), "nHandles": SimTypeShort(signed=False, label="UInt16"), "sReserved": SimTypeShort(signed=False, label="UInt16"), "nDescription": SimTypeInt(signed=False, label="UInt32"), "offDescription": SimTypeInt(signed=False, label="UInt32"), "nPalEntries": SimTypeInt(signed=False, label="UInt32"), "szlDevice": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "szlMillimeters": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cbPixelFormat": SimTypeInt(signed=False, label="UInt32"), "offPixelFormat": SimTypeInt(signed=False, label="UInt32"), "bOpenGL": SimTypeInt(signed=False, label="UInt32"), "szlMicrometers": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="ENHMETAHEADER", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "nSize", "lpEnhMetaHeader"]),
        # 
        'GetEnhMetaFilePaletteEntries': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "nNumEntries", "lpPaletteEntries"]),
        # 
        'GetWinMetaFileBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "cbData16", "pData16", "iMapMode", "hdcRef"]),
        # 
        'PlayEnhMetaFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hmf", "lprect"]),
        # 
        'PlayEnhMetaFileRecord': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"objectHandle": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="HANDLETABLE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"iType": SimTypeInt(signed=False, label="UInt32"), "nSize": SimTypeInt(signed=False, label="UInt32"), "dParm": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ENHMETARECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pht", "pmr", "cht"]),
        # 
        'SetEnhMetaFileBits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["nSize", "pb"]),
        # 
        'SetWinMetaFileBits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"mm": SimTypeInt(signed=True, label="Int32"), "xExt": SimTypeInt(signed=True, label="Int32"), "yExt": SimTypeInt(signed=True, label="Int32"), "hMF": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="METAFILEPICT", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["nSize", "lpMeta16Data", "hdcRef", "lpMFP"]),
        # 
        'GdiComment': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "nSize", "lpData"]),
        # 
        'GetTextMetricsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Byte"), "tmLastChar": SimTypeChar(label="Byte"), "tmDefaultChar": SimTypeChar(label="Byte"), "tmBreakChar": SimTypeChar(label="Byte"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lptm"]),
        # 
        'GetTextMetricsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"tmHeight": SimTypeInt(signed=True, label="Int32"), "tmAscent": SimTypeInt(signed=True, label="Int32"), "tmDescent": SimTypeInt(signed=True, label="Int32"), "tmInternalLeading": SimTypeInt(signed=True, label="Int32"), "tmExternalLeading": SimTypeInt(signed=True, label="Int32"), "tmAveCharWidth": SimTypeInt(signed=True, label="Int32"), "tmMaxCharWidth": SimTypeInt(signed=True, label="Int32"), "tmWeight": SimTypeInt(signed=True, label="Int32"), "tmOverhang": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectX": SimTypeInt(signed=True, label="Int32"), "tmDigitizedAspectY": SimTypeInt(signed=True, label="Int32"), "tmFirstChar": SimTypeChar(label="Char"), "tmLastChar": SimTypeChar(label="Char"), "tmDefaultChar": SimTypeChar(label="Char"), "tmBreakChar": SimTypeChar(label="Char"), "tmItalic": SimTypeChar(label="Byte"), "tmUnderlined": SimTypeChar(label="Byte"), "tmStruckOut": SimTypeChar(label="Byte"), "tmPitchAndFamily": SimTypeChar(label="Byte"), "tmCharSet": SimTypeChar(label="Byte")}, name="TEXTMETRICW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lptm"]),
        # 
        'AngleArc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeFloat(size=32), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "r", "StartAngle", "SweepAngle"]),
        # 
        'PolyPolyline': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "asz", "csz"]),
        # 
        'GetWorldTransform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpxf"]),
        # 
        'SetWorldTransform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpxf"]),
        # 
        'ModifyWorldTransform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="MODIFY_WORLD_TRANSFORM_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpxf", "mode"]),
        # 
        'CombineTransform': SimTypeFunction([SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORM", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpxfOut", "lpxf1", "lpxf2"]),
        # 
        'CreateDIBSection': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DIB_USAGE"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "pbmi", "usage", "ppvBits", "hSection", "offset"]),
        # 
        'GetDIBColorTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "iStart", "cEntries", "prgbq"]),
        # 
        'SetDIBColorTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "iStart", "cEntries", "prgbq"]),
        # 
        'SetColorAdjustment': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"caSize": SimTypeShort(signed=False, label="UInt16"), "caFlags": SimTypeShort(signed=False, label="UInt16"), "caIlluminantIndex": SimTypeShort(signed=False, label="UInt16"), "caRedGamma": SimTypeShort(signed=False, label="UInt16"), "caGreenGamma": SimTypeShort(signed=False, label="UInt16"), "caBlueGamma": SimTypeShort(signed=False, label="UInt16"), "caReferenceBlack": SimTypeShort(signed=False, label="UInt16"), "caReferenceWhite": SimTypeShort(signed=False, label="UInt16"), "caContrast": SimTypeShort(signed=True, label="Int16"), "caBrightness": SimTypeShort(signed=True, label="Int16"), "caColorfulness": SimTypeShort(signed=True, label="Int16"), "caRedGreenTint": SimTypeShort(signed=True, label="Int16")}, name="COLORADJUSTMENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpca"]),
        # 
        'GetColorAdjustment': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"caSize": SimTypeShort(signed=False, label="UInt16"), "caFlags": SimTypeShort(signed=False, label="UInt16"), "caIlluminantIndex": SimTypeShort(signed=False, label="UInt16"), "caRedGamma": SimTypeShort(signed=False, label="UInt16"), "caGreenGamma": SimTypeShort(signed=False, label="UInt16"), "caBlueGamma": SimTypeShort(signed=False, label="UInt16"), "caReferenceBlack": SimTypeShort(signed=False, label="UInt16"), "caReferenceWhite": SimTypeShort(signed=False, label="UInt16"), "caContrast": SimTypeShort(signed=True, label="Int16"), "caBrightness": SimTypeShort(signed=True, label="Int16"), "caColorfulness": SimTypeShort(signed=True, label="Int16"), "caRedGreenTint": SimTypeShort(signed=True, label="Int16")}, name="COLORADJUSTMENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpca"]),
        # 
        'CreateHalftonePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'AbortPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'ArcTo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "left", "top", "right", "bottom", "xr1", "yr1", "xr2", "yr2"]),
        # 
        'BeginPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'CloseFigure': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'EndPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'FillPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'FlattenPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "aj", "cpt"]),
        # 
        'PathToRegion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'PolyDraw': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "aj", "cpt"]),
        # 
        'SelectClipPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RGN_COMBINE_MODE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "mode"]),
        # 
        'SetArcDirection': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="ARC_DIRECTION")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "dir"]),
        # 
        'SetMiterLimit': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeFloat(size=32), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "limit", "old"]),
        # 
        'StrokeAndFillPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'StrokePath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'WidenPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'ExtCreatePen': SimTypeFunction([SimTypeInt(signed=False, label="PEN_STYLE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lbStyle": SimTypeInt(signed=False, label="UInt32"), "lbColor": SimTypeInt(signed=False, label="UInt32"), "lbHatch": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="LOGBRUSH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["iPenStyle", "cWidth", "plbrush", "cStyle", "pstyle"]),
        # 
        'GetMiterLimit': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "plimit"]),
        # 
        'GetArcDirection': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'GetObjectW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["h", "c", "pv"]),
        # 
        'MoveToEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'TextOutA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lpString", "c"]),
        # 
        'TextOutW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lpString", "c"]),
        # 
        'ExtTextOutA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="ETO_OPTIONS"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "options", "lprect", "lpString", "c", "lpDx"]),
        # 
        'ExtTextOutW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="ETO_OPTIONS"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "options", "lprect", "lpString", "c", "lpDx"]),
        # 
        'PolyTextOutA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32"), "n": SimTypeInt(signed=False, label="UInt32"), "lpstr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "uiFlags": SimTypeInt(signed=False, label="UInt32"), "rcl": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "pdx": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="POLYTEXTA", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "ppt", "nstrings"]),
        # 
        'PolyTextOutW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32"), "n": SimTypeInt(signed=False, label="UInt32"), "lpstr": SimTypePointer(SimTypeChar(label="Char"), offset=0), "uiFlags": SimTypeInt(signed=False, label="UInt32"), "rcl": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "pdx": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="POLYTEXTW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "ppt", "nstrings"]),
        # 
        'CreatePolygonRgn': SimTypeFunction([SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="CREATE_POLYGON_RGN_MODE")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pptl", "cPoint", "iMode"]),
        # 
        'DPtoLP': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppt", "c"]),
        # 
        'LPtoDP': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppt", "c"]),
        # 
        'Polygon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "cpt"]),
        # 
        'Polyline': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "cpt"]),
        # 
        'PolyBezier': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "cpt"]),
        # 
        'PolyBezierTo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "cpt"]),
        # 
        'PolylineTo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "apt", "cpt"]),
        # 
        'SetViewportExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lpsz"]),
        # 
        'SetViewportOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'SetWindowExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lpsz"]),
        # 
        'SetWindowOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'OffsetViewportOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'OffsetWindowOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'ScaleViewportExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "xn", "dx", "yn", "yd", "lpsz"]),
        # 
        'ScaleWindowExtEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "xn", "xd", "yn", "yd", "lpsz"]),
        # 
        'SetBitmapDimensionEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hbm", "w", "h", "lpsz"]),
        # 
        'SetBrushOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "lppt"]),
        # 
        'GetTextFaceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "c", "lpName"]),
        # 
        'GetTextFaceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "c", "lpName"]),
        # 
        'GetKerningPairsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"wFirst": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "iKernAmount": SimTypeInt(signed=True, label="Int32")}, name="KERNINGPAIR", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "nPairs", "lpKernPair"]),
        # 
        'GetKerningPairsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"wFirst": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "iKernAmount": SimTypeInt(signed=True, label="Int32")}, name="KERNINGPAIR", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdc", "nPairs", "lpKernPair"]),
        # 
        'GetDCOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lppt"]),
        # 
        'FixBrushOrgEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "x", "y", "ptl"]),
        # 
        'UnrealizeObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["h"]),
        # 
        'GdiFlush': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'GdiSetBatchLimit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dw"]),
        # 
        'GdiGetBatchLimit': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'ChoosePixelFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"nSize": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "iPixelType": SimTypeChar(label="Byte"), "cColorBits": SimTypeChar(label="Byte"), "cRedBits": SimTypeChar(label="Byte"), "cRedShift": SimTypeChar(label="Byte"), "cGreenBits": SimTypeChar(label="Byte"), "cGreenShift": SimTypeChar(label="Byte"), "cBlueBits": SimTypeChar(label="Byte"), "cBlueShift": SimTypeChar(label="Byte"), "cAlphaBits": SimTypeChar(label="Byte"), "cAlphaShift": SimTypeChar(label="Byte"), "cAccumBits": SimTypeChar(label="Byte"), "cAccumRedBits": SimTypeChar(label="Byte"), "cAccumGreenBits": SimTypeChar(label="Byte"), "cAccumBlueBits": SimTypeChar(label="Byte"), "cAccumAlphaBits": SimTypeChar(label="Byte"), "cDepthBits": SimTypeChar(label="Byte"), "cStencilBits": SimTypeChar(label="Byte"), "cAuxBuffers": SimTypeChar(label="Byte"), "iLayerType": SimTypeChar(label="Byte"), "bReserved": SimTypeChar(label="Byte"), "dwLayerMask": SimTypeInt(signed=False, label="UInt32"), "dwVisibleMask": SimTypeInt(signed=False, label="UInt32"), "dwDamageMask": SimTypeInt(signed=False, label="UInt32")}, name="PIXELFORMATDESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "ppfd"]),
        # 
        'DescribePixelFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"nSize": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "iPixelType": SimTypeChar(label="Byte"), "cColorBits": SimTypeChar(label="Byte"), "cRedBits": SimTypeChar(label="Byte"), "cRedShift": SimTypeChar(label="Byte"), "cGreenBits": SimTypeChar(label="Byte"), "cGreenShift": SimTypeChar(label="Byte"), "cBlueBits": SimTypeChar(label="Byte"), "cBlueShift": SimTypeChar(label="Byte"), "cAlphaBits": SimTypeChar(label="Byte"), "cAlphaShift": SimTypeChar(label="Byte"), "cAccumBits": SimTypeChar(label="Byte"), "cAccumRedBits": SimTypeChar(label="Byte"), "cAccumGreenBits": SimTypeChar(label="Byte"), "cAccumBlueBits": SimTypeChar(label="Byte"), "cAccumAlphaBits": SimTypeChar(label="Byte"), "cDepthBits": SimTypeChar(label="Byte"), "cStencilBits": SimTypeChar(label="Byte"), "cAuxBuffers": SimTypeChar(label="Byte"), "iLayerType": SimTypeChar(label="Byte"), "bReserved": SimTypeChar(label="Byte"), "dwLayerMask": SimTypeInt(signed=False, label="UInt32"), "dwVisibleMask": SimTypeInt(signed=False, label="UInt32"), "dwDamageMask": SimTypeInt(signed=False, label="UInt32")}, name="PIXELFORMATDESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iPixelFormat", "nBytes", "ppfd"]),
        # 
        'GetPixelFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'SetPixelFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"nSize": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "iPixelType": SimTypeChar(label="Byte"), "cColorBits": SimTypeChar(label="Byte"), "cRedBits": SimTypeChar(label="Byte"), "cRedShift": SimTypeChar(label="Byte"), "cGreenBits": SimTypeChar(label="Byte"), "cGreenShift": SimTypeChar(label="Byte"), "cBlueBits": SimTypeChar(label="Byte"), "cBlueShift": SimTypeChar(label="Byte"), "cAlphaBits": SimTypeChar(label="Byte"), "cAlphaShift": SimTypeChar(label="Byte"), "cAccumBits": SimTypeChar(label="Byte"), "cAccumRedBits": SimTypeChar(label="Byte"), "cAccumGreenBits": SimTypeChar(label="Byte"), "cAccumBlueBits": SimTypeChar(label="Byte"), "cAccumAlphaBits": SimTypeChar(label="Byte"), "cDepthBits": SimTypeChar(label="Byte"), "cStencilBits": SimTypeChar(label="Byte"), "cAuxBuffers": SimTypeChar(label="Byte"), "iLayerType": SimTypeChar(label="Byte"), "bReserved": SimTypeChar(label="Byte"), "dwLayerMask": SimTypeInt(signed=False, label="UInt32"), "dwVisibleMask": SimTypeInt(signed=False, label="UInt32"), "dwDamageMask": SimTypeInt(signed=False, label="UInt32")}, name="PIXELFORMATDESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "format", "ppfd"]),
        # 
        'GetEnhMetaFilePixelFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"nSize": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "iPixelType": SimTypeChar(label="Byte"), "cColorBits": SimTypeChar(label="Byte"), "cRedBits": SimTypeChar(label="Byte"), "cRedShift": SimTypeChar(label="Byte"), "cGreenBits": SimTypeChar(label="Byte"), "cGreenShift": SimTypeChar(label="Byte"), "cBlueBits": SimTypeChar(label="Byte"), "cBlueShift": SimTypeChar(label="Byte"), "cAlphaBits": SimTypeChar(label="Byte"), "cAlphaShift": SimTypeChar(label="Byte"), "cAccumBits": SimTypeChar(label="Byte"), "cAccumRedBits": SimTypeChar(label="Byte"), "cAccumGreenBits": SimTypeChar(label="Byte"), "cAccumBlueBits": SimTypeChar(label="Byte"), "cAccumAlphaBits": SimTypeChar(label="Byte"), "cDepthBits": SimTypeChar(label="Byte"), "cStencilBits": SimTypeChar(label="Byte"), "cAuxBuffers": SimTypeChar(label="Byte"), "iLayerType": SimTypeChar(label="Byte"), "bReserved": SimTypeChar(label="Byte"), "dwLayerMask": SimTypeInt(signed=False, label="UInt32"), "dwVisibleMask": SimTypeInt(signed=False, label="UInt32"), "dwDamageMask": SimTypeInt(signed=False, label="UInt32")}, name="PIXELFORMATDESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hemf", "cbBuffer", "ppfd"]),
        # 
        'SwapBuffers': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'GdiGetSpoolFileHandle': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pwszPrinterName", "pDevmode", "pwszDocName"]),
        # 
        'GdiDeleteSpoolFileHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle"]),
        # 
        'GdiGetPageCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SpoolFileHandle"]),
        # 
        'GdiGetDC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["SpoolFileHandle"]),
        # 
        'GdiGetPageHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["SpoolFileHandle", "Page", "pdwPageType"]),
        # 
        'GdiStartDocEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "lpszDocName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszOutput": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fwType": SimTypeInt(signed=False, label="UInt32")}, name="DOCINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle", "pDocInfo"]),
        # 
        'GdiStartPageEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle"]),
        # 
        'GdiPlayPageEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle", "hemf", "prectDocument", "prectBorder", "prectClip"]),
        # 
        'GdiEndPageEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle", "dwOptimization"]),
        # 
        'GdiEndDocEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle"]),
        # 
        'GdiGetDevmodeForPage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle", "dwPageNumber", "pCurrDM", "pLastDM"]),
        # 
        'GdiResetDCEMF': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dmDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmSpecVersion": SimTypeShort(signed=False, label="UInt16"), "dmDriverVersion": SimTypeShort(signed=False, label="UInt16"), "dmSize": SimTypeShort(signed=False, label="UInt16"), "dmDriverExtra": SimTypeShort(signed=False, label="UInt16"), "dmFields": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"dmOrientation": SimTypeShort(signed=True, label="Int16"), "dmPaperSize": SimTypeShort(signed=True, label="Int16"), "dmPaperLength": SimTypeShort(signed=True, label="Int16"), "dmPaperWidth": SimTypeShort(signed=True, label="Int16"), "dmScale": SimTypeShort(signed=True, label="Int16"), "dmCopies": SimTypeShort(signed=True, label="Int16"), "dmDefaultSource": SimTypeShort(signed=True, label="Int16"), "dmPrintQuality": SimTypeShort(signed=True, label="Int16")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dmPosition": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "dmDisplayOrientation": SimTypeInt(signed=False, label="UInt32"), "dmDisplayFixedOutput": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "dmColor": SimTypeShort(signed=True, label="Int16"), "dmDuplex": SimTypeShort(signed=True, label="Int16"), "dmYResolution": SimTypeShort(signed=True, label="Int16"), "dmTTOption": SimTypeShort(signed=True, label="Int16"), "dmCollate": SimTypeShort(signed=True, label="Int16"), "dmFormName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dmLogPixels": SimTypeShort(signed=False, label="UInt16"), "dmBitsPerPel": SimTypeInt(signed=False, label="UInt32"), "dmPelsWidth": SimTypeInt(signed=False, label="UInt32"), "dmPelsHeight": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"dmDisplayFlags": SimTypeInt(signed=False, label="UInt32"), "dmNup": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dmDisplayFrequency": SimTypeInt(signed=False, label="UInt32"), "dmICMMethod": SimTypeInt(signed=False, label="UInt32"), "dmICMIntent": SimTypeInt(signed=False, label="UInt32"), "dmMediaType": SimTypeInt(signed=False, label="UInt32"), "dmDitherType": SimTypeInt(signed=False, label="UInt32"), "dmReserved1": SimTypeInt(signed=False, label="UInt32"), "dmReserved2": SimTypeInt(signed=False, label="UInt32"), "dmPanningWidth": SimTypeInt(signed=False, label="UInt32"), "dmPanningHeight": SimTypeInt(signed=False, label="UInt32")}, name="DEVMODEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SpoolFileHandle", "pCurrDM"]),
        # 
        'Escape': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iEscape", "cjIn", "pvIn", "pvOut"]),
        # 
        'ExtEscape': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "iEscape", "cjInput", "lpInData", "cjOutput", "lpOutData"]),
        # 
        'StartDocA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "lpszDocName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszOutput": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszDatatype": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fwType": SimTypeInt(signed=False, label="UInt32")}, name="DOCINFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpdi"]),
        # 
        'StartDocW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "lpszDocName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszOutput": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszDatatype": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fwType": SimTypeInt(signed=False, label="UInt32")}, name="DOCINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpdi"]),
        # 
        'EndDoc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'StartPage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'EndPage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'AbortDoc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc"]),
        # 
        'SetAbortProc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "proc"]),
        # 
        'EngQueryEMFInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"nSize": SimTypeInt(signed=False, label="UInt32"), "hdc": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pvEMF": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvCurrentRecord": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EMFINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdev", "pEMFInfo"]),
        # 
        'SetICMMode': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "mode"]),
        # 
        'CheckColorsInGamut': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"rgbtBlue": SimTypeChar(label="Byte"), "rgbtGreen": SimTypeChar(label="Byte"), "rgbtRed": SimTypeChar(label="Byte")}, name="RGBTRIPLE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpRGBTriple", "dlpBuffer", "nCount"]),
        # 
        'GetColorSpace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc"]),
        # 
        'GetLogColorSpaceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 260)}, name="LOGCOLORSPACEA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorSpace", "lpBuffer", "nSize"]),
        # 
        'GetLogColorSpaceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="LOGCOLORSPACEW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorSpace", "lpBuffer", "nSize"]),
        # 
        'CreateColorSpaceA': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 260)}, name="LOGCOLORSPACEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lplcs"]),
        # 
        'CreateColorSpaceW': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="LOGCOLORSPACEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lplcs"]),
        # 
        'SetColorSpace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdc", "hcs"]),
        # 
        'DeleteColorSpace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hcs"]),
        # 
        'GetICMProfileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pBufSize", "pszFilename"]),
        # 
        'GetICMProfileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "pBufSize", "pszFilename"]),
        # 
        'SetICMProfileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpFileName"]),
        # 
        'SetICMProfileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpFileName"]),
        # 
        'GetDeviceGammaRamp': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpRamp"]),
        # 
        'SetDeviceGammaRamp': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "lpRamp"]),
        # 
        'ColorMatchToTarget': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="COLOR_MATCH_TO_TARGET_ACTION")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hdcTarget", "action"]),
        # 
        'EnumICMProfilesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "proc", "param2"]),
        # 
        'EnumICMProfilesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "proc", "param2"]),
        # 
        'UpdateICMRegKeyA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="ICM_COMMAND")], SimTypeInt(signed=True, label="Int32"), arg_names=["reserved", "lpszCMID", "lpszFileName", "command"]),
        # 
        'UpdateICMRegKeyW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="ICM_COMMAND")], SimTypeInt(signed=True, label="Int32"), arg_names=["reserved", "lpszCMID", "lpszFileName", "command"]),
        # 
        'ColorCorrectPalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdc", "hPal", "deFirst", "num"]),
        # 
        'BRUSHOBJ_pvAllocRbrush': SimTypeFunction([SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pbo", "cj"]),
        # 
        'BRUSHOBJ_pvGetRbrush': SimTypeFunction([SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pbo"]),
        # 
        'BRUSHOBJ_ulGetBrushColor': SimTypeFunction([SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pbo"]),
        # 
        'BRUSHOBJ_hGetColorTransform': SimTypeFunction([SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pbo"]),
        # 
        'CLIPOBJ_cEnumStart': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pco", "bAll", "iType", "iDirection", "cLimit"]),
        # 
        'CLIPOBJ_bEnum': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pco", "cj", "pul"]),
        # 
        'CLIPOBJ_ppoGetPath': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), arg_names=["pco"]),
        # 
        'FONTOBJ_cGetAllGlyphHandles': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pfo", "phg"]),
        # 
        'FONTOBJ_vGetInfo': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cjThis": SimTypeInt(signed=False, label="UInt32"), "flCaps": SimTypeInt(signed=False, label="UInt32"), "cGlyphsSupported": SimTypeInt(signed=False, label="UInt32"), "cjMaxGlyph1": SimTypeInt(signed=False, label="UInt32"), "cjMaxGlyph4": SimTypeInt(signed=False, label="UInt32"), "cjMaxGlyph8": SimTypeInt(signed=False, label="UInt32"), "cjMaxGlyph32": SimTypeInt(signed=False, label="UInt32")}, name="FONTINFO", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pfo", "cjSize", "pfi"]),
        # 
        'FONTOBJ_cGetGlyphs': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pfo", "iMode", "cGlyph", "phg", "ppvGlyph"]),
        # 
        'FONTOBJ_pxoGetXform': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"ulReserved": SimTypeInt(signed=False, label="UInt32")}, name="XFORMOBJ", pack=False, align=None), offset=0), arg_names=["pfo"]),
        # 
        'FONTOBJ_pifi': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cjThis": SimTypeInt(signed=False, label="UInt32"), "cjIfiExtra": SimTypeInt(signed=False, label="UInt32"), "dpwszFamilyName": SimTypeInt(signed=True, label="Int32"), "dpwszStyleName": SimTypeInt(signed=True, label="Int32"), "dpwszFaceName": SimTypeInt(signed=True, label="Int32"), "dpwszUniqueName": SimTypeInt(signed=True, label="Int32"), "dpFontSim": SimTypeInt(signed=True, label="Int32"), "lEmbedId": SimTypeInt(signed=True, label="Int32"), "lItalicAngle": SimTypeInt(signed=True, label="Int32"), "lCharBias": SimTypeInt(signed=True, label="Int32"), "dpCharSets": SimTypeInt(signed=True, label="Int32"), "jWinCharSet": SimTypeChar(label="Byte"), "jWinPitchAndFamily": SimTypeChar(label="Byte"), "usWinWeight": SimTypeShort(signed=False, label="UInt16"), "flInfo": SimTypeInt(signed=False, label="UInt32"), "fsSelection": SimTypeShort(signed=False, label="UInt16"), "fsType": SimTypeShort(signed=False, label="UInt16"), "fwdUnitsPerEm": SimTypeShort(signed=True, label="Int16"), "fwdLowestPPEm": SimTypeShort(signed=True, label="Int16"), "fwdWinAscender": SimTypeShort(signed=True, label="Int16"), "fwdWinDescender": SimTypeShort(signed=True, label="Int16"), "fwdMacAscender": SimTypeShort(signed=True, label="Int16"), "fwdMacDescender": SimTypeShort(signed=True, label="Int16"), "fwdMacLineGap": SimTypeShort(signed=True, label="Int16"), "fwdTypoAscender": SimTypeShort(signed=True, label="Int16"), "fwdTypoDescender": SimTypeShort(signed=True, label="Int16"), "fwdTypoLineGap": SimTypeShort(signed=True, label="Int16"), "fwdAveCharWidth": SimTypeShort(signed=True, label="Int16"), "fwdMaxCharInc": SimTypeShort(signed=True, label="Int16"), "fwdCapHeight": SimTypeShort(signed=True, label="Int16"), "fwdXHeight": SimTypeShort(signed=True, label="Int16"), "fwdSubscriptXSize": SimTypeShort(signed=True, label="Int16"), "fwdSubscriptYSize": SimTypeShort(signed=True, label="Int16"), "fwdSubscriptXOffset": SimTypeShort(signed=True, label="Int16"), "fwdSubscriptYOffset": SimTypeShort(signed=True, label="Int16"), "fwdSuperscriptXSize": SimTypeShort(signed=True, label="Int16"), "fwdSuperscriptYSize": SimTypeShort(signed=True, label="Int16"), "fwdSuperscriptXOffset": SimTypeShort(signed=True, label="Int16"), "fwdSuperscriptYOffset": SimTypeShort(signed=True, label="Int16"), "fwdUnderscoreSize": SimTypeShort(signed=True, label="Int16"), "fwdUnderscorePosition": SimTypeShort(signed=True, label="Int16"), "fwdStrikeoutSize": SimTypeShort(signed=True, label="Int16"), "fwdStrikeoutPosition": SimTypeShort(signed=True, label="Int16"), "chFirstChar": SimTypeChar(label="Byte"), "chLastChar": SimTypeChar(label="Byte"), "chDefaultChar": SimTypeChar(label="Byte"), "chBreakChar": SimTypeChar(label="Byte"), "wcFirstChar": SimTypeChar(label="Char"), "wcLastChar": SimTypeChar(label="Char"), "wcDefaultChar": SimTypeChar(label="Char"), "wcBreakChar": SimTypeChar(label="Char"), "ptlBaseline": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "ptlAspect": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "ptlCaret": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "rclFontBox": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "achVendId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 4), "cKerningPairs": SimTypeInt(signed=False, label="UInt32"), "ulPanoseCulture": SimTypeInt(signed=False, label="UInt32"), "panose": SimStruct({"bFamilyType": SimTypeChar(label="Byte"), "bSerifStyle": SimTypeChar(label="Byte"), "bWeight": SimTypeChar(label="Byte"), "bProportion": SimTypeChar(label="Byte"), "bContrast": SimTypeChar(label="Byte"), "bStrokeVariation": SimTypeChar(label="Byte"), "bArmStyle": SimTypeChar(label="Byte"), "bLetterform": SimTypeChar(label="Byte"), "bMidline": SimTypeChar(label="Byte"), "bXHeight": SimTypeChar(label="Byte")}, name="PANOSE", pack=False, align=None)}, name="IFIMETRICS", pack=False, align=None), offset=0), arg_names=["pfo"]),
        # 
        'FONTOBJ_pfdg': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cjThis": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "cGlyphsSupported": SimTypeInt(signed=False, label="UInt32"), "cRuns": SimTypeInt(signed=False, label="UInt32"), "awcrun": SimTypePointer(SimStruct({"wcLow": SimTypeChar(label="Char"), "cGlyphs": SimTypeShort(signed=False, label="UInt16"), "phg": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="WCRUN", pack=False, align=None), offset=0)}, name="FD_GLYPHSET", pack=False, align=None), offset=0), arg_names=["pfo"]),
        # 
        'FONTOBJ_pvTrueTypeFontFile': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pfo", "pcjFile"]),
        # 
        'FONTOBJ_pQueryGlyphAttrs': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"cjThis": SimTypeInt(signed=False, label="UInt32"), "cGlyphs": SimTypeInt(signed=False, label="UInt32"), "iMode": SimTypeInt(signed=False, label="UInt32"), "aGlyphAttr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FD_GLYPHATTR", pack=False, align=None), offset=0), arg_names=["pfo", "iMode"]),
        # 
        'PATHOBJ_vEnumStart': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["ppo"]),
        # 
        'PATHOBJ_bEnum': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "count": SimTypeInt(signed=False, label="UInt32"), "pptfx": SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTFIX", pack=False, align=None), offset=0)}, name="PATHDATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppo", "ppd"]),
        # 
        'PATHOBJ_vEnumStartClipLines': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "iJoin": SimTypeInt(signed=False, label="UInt32"), "iEndCap": SimTypeInt(signed=False, label="UInt32"), "elWidth": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "eMiterLimit": SimTypeFloat(size=32), "cstyle": SimTypeInt(signed=False, label="UInt32"), "pstyle": SimTypePointer(SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), offset=0), "elStyleState": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")}, name="LINEATTRS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["ppo", "pco", "pso", "pla"]),
        # 
        'PATHOBJ_bEnumClipLines': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ptfxA": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTFIX", pack=False, align=None), "ptfxB": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTFIX", pack=False, align=None), "lStyleState": SimTypeInt(signed=True, label="Int32"), "c": SimTypeInt(signed=False, label="UInt32"), "arun": SimTypePointer(SimStruct({"iStart": SimTypeInt(signed=True, label="Int32"), "iStop": SimTypeInt(signed=True, label="Int32")}, name="RUN", pack=False, align=None), offset=0)}, name="CLIPLINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppo", "cb", "pcl"]),
        # 
        'PATHOBJ_vGetBounds': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"xLeft": SimTypeInt(signed=True, label="Int32"), "yTop": SimTypeInt(signed=True, label="Int32"), "xRight": SimTypeInt(signed=True, label="Int32"), "yBottom": SimTypeInt(signed=True, label="Int32")}, name="RECTFX", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["ppo", "prectfx"]),
        # 
        'STROBJ_vEnumStart': SimTypeFunction([SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pstro"]),
        # 
        'STROBJ_bEnum': SimTypeFunction([SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pstro", "pc", "ppgpos"]),
        # 
        'STROBJ_bEnumPositionsOnly': SimTypeFunction([SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pstro", "pc", "ppgpos"]),
        # 
        'STROBJ_dwGetCodePage': SimTypeFunction([SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pstro"]),
        # 
        'STROBJ_bGetAdvanceWidths': SimTypeFunction([SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"x": SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), "y": SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None")}, name="POINTQF", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "iFirst", "c", "pptqD"]),
        # 
        'XFORMOBJ_iGetXform': SimTypeFunction([SimTypePointer(SimStruct({"ulReserved": SimTypeInt(signed=False, label="UInt32")}, name="XFORMOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"eM11": SimTypeFloat(size=32), "eM12": SimTypeFloat(size=32), "eM21": SimTypeFloat(size=32), "eM22": SimTypeFloat(size=32), "eDx": SimTypeFloat(size=32), "eDy": SimTypeFloat(size=32)}, name="XFORML", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pxo", "pxform"]),
        # 
        'XFORMOBJ_bApplyXform': SimTypeFunction([SimTypePointer(SimStruct({"ulReserved": SimTypeInt(signed=False, label="UInt32")}, name="XFORMOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pxo", "iMode", "cPoints", "pvIn", "pvOut"]),
        # 
        'XLATEOBJ_iXlate': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pxlo", "iColor"]),
        # 
        'XLATEOBJ_piVector': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), arg_names=["pxlo"]),
        # 
        'XLATEOBJ_cGetPalette': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pxlo", "iPal", "cPal", "pPal"]),
        # 
        'XLATEOBJ_hGetColorTransform': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pxlo"]),
        # 
        'EngCreateBitmap': SimTypeFunction([SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["sizl", "lWidth", "iFormat", "fl", "pvBits"]),
        # 
        'EngCreateDeviceSurface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["dhsurf", "sizl", "iFormatCompat"]),
        # 
        'EngCreateDeviceBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["dhsurf", "sizl", "iFormatCompat"]),
        # 
        'EngDeleteSurface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hsurf"]),
        # 
        'EngLockSurface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), arg_names=["hsurf"]),
        # 
        'EngUnlockSurface': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pso"]),
        # 
        'EngEraseSurface': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "prcl", "iColor"]),
        # 
        'EngAssociateSurface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hsurf", "hdev", "flHooks"]),
        # 
        'EngMarkBandingSurface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hsurf"]),
        # 
        'EngCheckAbort': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pso"]),
        # 
        'EngDeletePath': SimTypeFunction([SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["ppo"]),
        # 
        'EngCreatePalette': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["iMode", "cColors", "pulColors", "flRed", "flGreen", "flBlue"]),
        # 
        'EngDeletePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hpal"]),
        # 
        'EngCreateClip': SimTypeFunction([], SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0)),
        # 
        'EngDeleteClip': SimTypeFunction([SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pco"]),
        # 
        'EngBitBlt': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoTrg", "psoSrc", "psoMask", "pco", "pxlo", "prclTrg", "pptlSrc", "pptlMask", "pbo", "pptlBrush", "rop4"]),
        # 
        'EngLineTo': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "pco", "pbo", "x1", "y1", "x2", "y2", "prclBounds", "mix"]),
        # 
        'EngStretchBlt': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"caSize": SimTypeShort(signed=False, label="UInt16"), "caFlags": SimTypeShort(signed=False, label="UInt16"), "caIlluminantIndex": SimTypeShort(signed=False, label="UInt16"), "caRedGamma": SimTypeShort(signed=False, label="UInt16"), "caGreenGamma": SimTypeShort(signed=False, label="UInt16"), "caBlueGamma": SimTypeShort(signed=False, label="UInt16"), "caReferenceBlack": SimTypeShort(signed=False, label="UInt16"), "caReferenceWhite": SimTypeShort(signed=False, label="UInt16"), "caContrast": SimTypeShort(signed=True, label="Int16"), "caBrightness": SimTypeShort(signed=True, label="Int16"), "caColorfulness": SimTypeShort(signed=True, label="Int16"), "caRedGreenTint": SimTypeShort(signed=True, label="Int16")}, name="COLORADJUSTMENT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDest", "psoSrc", "psoMask", "pco", "pxlo", "pca", "pptlHTOrg", "prclDest", "prclSrc", "pptlMask", "iMode"]),
        # 
        'EngStretchBltROP': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"caSize": SimTypeShort(signed=False, label="UInt16"), "caFlags": SimTypeShort(signed=False, label="UInt16"), "caIlluminantIndex": SimTypeShort(signed=False, label="UInt16"), "caRedGamma": SimTypeShort(signed=False, label="UInt16"), "caGreenGamma": SimTypeShort(signed=False, label="UInt16"), "caBlueGamma": SimTypeShort(signed=False, label="UInt16"), "caReferenceBlack": SimTypeShort(signed=False, label="UInt16"), "caReferenceWhite": SimTypeShort(signed=False, label="UInt16"), "caContrast": SimTypeShort(signed=True, label="Int16"), "caBrightness": SimTypeShort(signed=True, label="Int16"), "caColorfulness": SimTypeShort(signed=True, label="Int16"), "caRedGreenTint": SimTypeShort(signed=True, label="Int16")}, name="COLORADJUSTMENT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDest", "psoSrc", "psoMask", "pco", "pxlo", "pca", "pptlHTOrg", "prclDest", "prclSrc", "pptlMask", "iMode", "pbo", "rop4"]),
        # 
        'EngAlphaBlend': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"BlendFunction": SimStruct({"BlendOp": SimTypeChar(label="Byte"), "BlendFlags": SimTypeChar(label="Byte"), "SourceConstantAlpha": SimTypeChar(label="Byte"), "AlphaFormat": SimTypeChar(label="Byte")}, name="BLENDFUNCTION", pack=False, align=None)}, name="BLENDOBJ", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDest", "psoSrc", "pco", "pxlo", "prclDest", "prclSrc", "pBlendObj"]),
        # 
        'EngGradientFill': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32"), "Red": SimTypeShort(signed=False, label="UInt16"), "Green": SimTypeShort(signed=False, label="UInt16"), "Blue": SimTypeShort(signed=False, label="UInt16"), "Alpha": SimTypeShort(signed=False, label="UInt16")}, name="TRIVERTEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDest", "pco", "pxlo", "pVertex", "nVertex", "pMesh", "nMesh", "prclExtents", "pptlDitherOrg", "ulMode"]),
        # 
        'EngTransparentBlt': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDst", "psoSrc", "pco", "pxlo", "prclDst", "prclSrc", "TransColor", "bCalledFromBitBlt"]),
        # 
        'EngTextOut': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cGlyphs": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "ulCharInc": SimTypeInt(signed=False, label="UInt32"), "rclBkGround": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "pgp": SimTypePointer(SimStruct({"hg": SimTypeInt(signed=False, label="UInt32"), "pgdf": SimTypePointer(SimUnion({"pgb": SimTypePointer(SimStruct({"ptlOrigin": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "aj": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="GLYPHBITS", pack=False, align=None), offset=0), "ppo": SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0)}, name="<anon>", label="None"), offset=0), "ptl": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None)}, name="GLYPHPOS", pack=False, align=None), offset=0), "pwszOrg": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="STROBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "iFace": SimTypeInt(signed=False, label="UInt32"), "cxMax": SimTypeInt(signed=False, label="UInt32"), "flFontType": SimTypeInt(signed=False, label="UInt32"), "iTTUniq": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "iFile": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "sizLogResPpi": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "ulStyleSize": SimTypeInt(signed=False, label="UInt32"), "pvConsumer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvProducer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="FONTOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "pstro", "pfo", "pco", "prclExtra", "prclOpaque", "pboFore", "pboOpaque", "pptlOrg", "mix"]),
        # 
        'EngStrokePath': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulReserved": SimTypeInt(signed=False, label="UInt32")}, name="XFORMOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "iJoin": SimTypeInt(signed=False, label="UInt32"), "iEndCap": SimTypeInt(signed=False, label="UInt32"), "elWidth": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "eMiterLimit": SimTypeFloat(size=32), "cstyle": SimTypeInt(signed=False, label="UInt32"), "pstyle": SimTypePointer(SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), offset=0), "elStyleState": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")}, name="LINEATTRS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "ppo", "pco", "pxo", "pbo", "pptlBrushOrg", "plineattrs", "mix"]),
        # 
        'EngFillPath': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "ppo", "pco", "pbo", "pptlBrushOrg", "mix", "flOptions"]),
        # 
        'EngStrokeAndFillPath': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "cCurves": SimTypeInt(signed=False, label="UInt32")}, name="PATHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulReserved": SimTypeInt(signed=False, label="UInt32")}, name="XFORMOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fl": SimTypeInt(signed=False, label="UInt32"), "iJoin": SimTypeInt(signed=False, label="UInt32"), "iEndCap": SimTypeInt(signed=False, label="UInt32"), "elWidth": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "eMiterLimit": SimTypeFloat(size=32), "cstyle": SimTypeInt(signed=False, label="UInt32"), "pstyle": SimTypePointer(SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), offset=0), "elStyleState": SimUnion({"e": SimTypeFloat(size=32), "l": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")}, name="LINEATTRS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "ppo", "pco", "pxo", "pboStroke", "plineattrs", "pboFill", "pptlBrushOrg", "mixFill", "flOptions"]),
        # 
        'EngPaint': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iSolidColor": SimTypeInt(signed=False, label="UInt32"), "pvRbrush": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "flColorType": SimTypeInt(signed=False, label="UInt32")}, name="BRUSHOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pso", "pco", "pbo", "pptlBrushOrg", "mix"]),
        # 
        'EngCopyBits': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psoDest", "psoSrc", "pco", "pxlo", "prclDest", "pptlSrc"]),
        # 
        'EngPlgBlt': SimTypeFunction([SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dhsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hsurf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dhpdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hdev": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sizlBitmap": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None), "cjBits": SimTypeInt(signed=False, label="UInt32"), "pvBits": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pvScan0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lDelta": SimTypeInt(signed=True, label="Int32"), "iUniq": SimTypeInt(signed=False, label="UInt32"), "iBitmapFormat": SimTypeInt(signed=False, label="UInt32"), "iType": SimTypeShort(signed=False, label="UInt16"), "fjBitmap": SimTypeShort(signed=False, label="UInt16")}, name="SURFOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "rclBounds": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), "iDComplexity": SimTypeChar(label="Byte"), "iFComplexity": SimTypeChar(label="Byte"), "iMode": SimTypeChar(label="Byte"), "fjOptions": SimTypeChar(label="Byte")}, name="CLIPOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"iUniq": SimTypeInt(signed=False, label="UInt32"), "flXlate": SimTypeInt(signed=False, label="UInt32"), "iSrcType": SimTypeShort(signed=False, label="UInt16"), "iDstType": SimTypeShort(signed=False, label="UInt16"), "cEntries": SimTypeInt(signed=False, label="UInt32"), "pulXlate": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="XLATEOBJ", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"caSize": SimTypeShort(signed=False, label="UInt16"), "caFlags": SimTypeShort(signed=False, label="UInt16"), "caIlluminantIndex": SimTypeShort(signed=False, label="UInt16"), "caRedGamma": SimTypeShort(signed=False, label="UInt16"), "caGreenGamma": SimTypeShort(signed=False, label="UInt16"), "caBlueGamma": SimTypeShort(signed=False, label="UInt16"), "caReferenceBlack": SimTypeShort(signed=False, label="UInt16"), "caReferenceWhite": SimTypeShort(signed=False, label="UInt16"), "caContrast": SimTypeShort(signed=True, label="Int16"), "caBrightness": SimTypeShort(signed=True, label="Int16"), "caColorfulness": SimTypeShort(signed=True, label="Int16"), "caRedGreenTint": SimTypeShort(signed=True, label="Int16")}, name="COLORADJUSTMENT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTFIX", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECTL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINTL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psoTrg", "psoSrc", "psoMsk", "pco", "pxlo", "pca", "pptlBrushOrg", "pptfx", "prcl", "pptl", "iMode"]),
        # 
        'HT_Get8BPPFormatPalette': SimTypeFunction([SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["pPaletteEntry", "RedGamma", "GreenGamma", "BlueGamma"]),
        # 
        'HT_Get8BPPMaskPalette': SimTypeFunction([SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeChar(label="Byte"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["pPaletteEntry", "Use8BPPMaskPal", "CMYMask", "RedGamma", "GreenGamma", "BlueGamma"]),
        # 
        'EngGetPrinterDataFileName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hdev"]),
        # 
        'EngGetDriverName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hdev"]),
        # 
        'EngLoadModule': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pwsz"]),
        # 
        'EngFindResource': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["h", "iName", "iType", "pulSize"]),
        # 
        'EngFreeModule': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["h"]),
        # 
        'EngCreateSemaphore': SimTypeFunction([], SimTypePointer(SimStruct({"unused": SimTypeInt(signed=True, label="Int32")}, name="HSEMAPHORE__", pack=False, align=None), offset=0)),
        # 
        'EngAcquireSemaphore': SimTypeFunction([SimTypePointer(SimStruct({"unused": SimTypeInt(signed=True, label="Int32")}, name="HSEMAPHORE__", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["hsem"]),
        # 
        'EngReleaseSemaphore': SimTypeFunction([SimTypePointer(SimStruct({"unused": SimTypeInt(signed=True, label="Int32")}, name="HSEMAPHORE__", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["hsem"]),
        # 
        'EngDeleteSemaphore': SimTypeFunction([SimTypePointer(SimStruct({"unused": SimTypeInt(signed=True, label="Int32")}, name="HSEMAPHORE__", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["hsem"]),
        # 
        'EngMultiByteToUnicodeN': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["UnicodeString", "MaxBytesInUnicodeString", "BytesInUnicodeString", "MultiByteString", "BytesInMultiByteString"]),
        # 
        'EngUnicodeToMultiByteN': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["MultiByteString", "MaxBytesInMultiByteString", "BytesInMultiByteString", "UnicodeString", "BytesInUnicodeString"]),
        # 
        'EngQueryLocalTime': SimTypeFunction([SimTypePointer(SimStruct({"usYear": SimTypeShort(signed=False, label="UInt16"), "usMonth": SimTypeShort(signed=False, label="UInt16"), "usDay": SimTypeShort(signed=False, label="UInt16"), "usHour": SimTypeShort(signed=False, label="UInt16"), "usMinute": SimTypeShort(signed=False, label="UInt16"), "usSecond": SimTypeShort(signed=False, label="UInt16"), "usMilliseconds": SimTypeShort(signed=False, label="UInt16"), "usWeekday": SimTypeShort(signed=False, label="UInt16")}, name="ENG_TIME_FIELDS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]),
        # 
        'EngComputeGlyphSet': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({"cjThis": SimTypeInt(signed=False, label="UInt32"), "flAccel": SimTypeInt(signed=False, label="UInt32"), "cGlyphsSupported": SimTypeInt(signed=False, label="UInt32"), "cRuns": SimTypeInt(signed=False, label="UInt32"), "awcrun": SimTypePointer(SimStruct({"wcLow": SimTypeChar(label="Char"), "cGlyphs": SimTypeShort(signed=False, label="UInt16"), "phg": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="WCRUN", pack=False, align=None), offset=0)}, name="FD_GLYPHSET", pack=False, align=None), offset=0), arg_names=["nCodePage", "nFirstChar", "cChars"]),
        # 
        'EngMultiByteToWideChar': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CodePage", "WideCharString", "BytesInWideCharString", "MultiByteString", "BytesInMultiByteString"]),
        # 
        'EngWideCharToMultiByte': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CodePage", "WideCharString", "BytesInWideCharString", "MultiByteString", "BytesInMultiByteString"]),
        # 
        'EngGetCurrentCodePage': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeBottom(label="Void"), arg_names=["OemCodePage", "AnsiCodePage"]),
    }

lib.set_prototypes(prototypes)
